/* File: main.c */

#include "grend/config.h"

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <assert.h>

#include "grend/common.h"
#include "grend/grend.h"
#include "grend/grend_r.h"
#include "grend/grend_p.h"

#include "main.h"
#include "cube.h"

#define CAMERA_MOVE_UNIT	100.0f
#define CUBE_MAX_NUM		2000

static GRVector4 cam_pos;
static GRVector3 cam_angle;
static GRD_TEX_INFO texinfo[3];

static int mode_ct = 0;
static int global_ct = 0;
static int cubes = 500;
static int cubeadd_flag = FALSE;
static int cubetex_flag = FALSE;

static void camera_init( void )
{
	cam_pos.x	=     0.0f;
	cam_pos.y	=     0.0f;
	cam_pos.z	= -3000.0f;
	cam_pos.w	=     1.0f;
	cam_angle.x	=     0.0f;
	cam_angle.y	=     0.0f;
	cam_angle.z	=     0.0f;
	return;
}

int prog_init( void )
{
	camera_init();
	cube_init();
	grg_cam_pos   = cam_pos;
	grg_cam_angle = cam_angle;
	grg_set3Dmatrix( 3.0f, 65535.0f );
	grg_set3Dmatrix_camera();
	grd_tex_read( GRD_TRATTR_ERROREXIT, NULL, &texinfo[0], "texdata/terracotta_64.bmp" );
	grd_tex_read( GRD_TRATTR_ERROREXIT, NULL, &texinfo[1], "texdata/blue_gray_64.bmp" );
	grd_tex_read( GRD_TRATTR_ERROREXIT, NULL, &texinfo[2], "texdata/fibers_64.bmp" );

	return TRUE;
}

int prog_exit( void )
{
	gri_shutdown();
	return TRUE;
}

int prog_main( void )
{
	int i, j, k;
	int ct, retflag = TRUE;
	int pause_flag = FALSE;
	GRVector4 tvec = { 0.0f, 0.0f, 0.0f, 0.0f };
	GRVector3 trot = { 0.0f, 0.0f, 0.0f };

	grd_draw_framestart();

	/* move and set camera */
	for (i = 0; i < GRP_GAMEDEV_MAX; i++) {
	  	if (grp_key_buttons[i] & GRP_KEYSELECT) {
			pause_flag = TRUE;
			break;
		}
		cam_pos.x = cam_pos.x + (float)grp_key_analog1_h[i];
		cam_pos.y = cam_pos.y + (float)grp_key_analog1_v[i];
		cam_pos.z = cam_pos.z + (float)grp_key_analog2_v[i];
		if (grp_key_buttons[i] & GRP_KEYLEFT)
			cam_angle.x = cam_angle.x - (float)M_PI/180.0f;
		if (grp_key_buttons[i] & GRP_KEYRIGHT)
			cam_angle.x = cam_angle.x + (float)M_PI/180.0f;
		if (grp_key_buttons[i] & GRP_KEYUP)
			cam_angle.y = cam_angle.y - (float)M_PI/180.0f;
		if (grp_key_buttons[i] & GRP_KEYDOWN)
			cam_angle.y = cam_angle.y + (float)M_PI/180.0f;
		if (grp_key_triggers[i] & GRP_KEYSTART)
			camera_init();
		if (grp_key_buttons[i] & GRP_KEYA) {
			if (cubes < CUBE_MAX_NUM)
				cubes++;
		}
		if (grp_key_buttons[i] & GRP_KEYB) {
			if (cubes > 0)
				--cubes;
		}
		if (grp_key_triggers[i] & GRP_KEYC)
			mode_ct = (mode_ct + 1) % 4;
	}
	grg_cam_pos   = cam_pos;
	grg_cam_angle = cam_angle;
	grg_set3Dmatrix_camera();
	cubeadd_flag = (mode_ct >> 1) & 1;
	cubetex_flag = !(mode_ct & 1);

	if (!pause_flag)
		global_ct++;

	/* message */
	grd_font_locate( 0, 10, 40 );
	grd_font_setsize( 0, 100 );
	grd_font_setcolor( 0, 128, 255, 128+64, 128, 0 );
	grd_font_printf( 0, "CUBE : N=%d [tex=%d add=%d] %dx%d\n", cubes, cubetex_flag, cubeadd_flag, gri_resolution_x, gri_resolution_y );
	grd_font_setcolor( 0, 255, 255, 255, 128, 0 );
	grd_font_printf( 0, "pX:%9.2f pY:%9.2f pZ:%9.2f\n", cam_pos.x,   cam_pos.y,   cam_pos.z );
	grd_font_printf( 0, "rX:%9.2f rY:%9.2f rZ:%9.2f\n", cam_angle.x, cam_angle.y, cam_angle.z );
	grd_font_setcolor( 0, 255, 255, 128, 128, 0 );
	grd_font_printf( 0, "\nLeft/Right analog, Left buttons, Start ... camera control.\n" );
	grd_font_printf( 0, "O,X ... cubes number, Square ... change mode.\n" );
	grd_font_printf( 0, "Select + other buttons ... debug control. (select+start = framedump)\n" );

	/* set path */
	grd_set_currentdrawpath( GRDRAW_PATH1 );
	grd_set_currentcontext( GRDRAW_CONTEXT1 );
	grd_set_drawmode_anormal_znotest_znoupdate( grd_get_currentcontext() );

	/* BG triangles */
	for (i = 0; i < 100; i++) {
		grd_2d_gtriangle(
			SCREEN_SIZE_X/2-30.0f+i*2.0f, SCREEN_SIZE_Y/2-60.0f+i*2.0f,
			SCREEN_SIZE_X/2+30.0f+i*2.0f, SCREEN_SIZE_Y/2-60.0f+i*2.0f,
			SCREEN_SIZE_X/2+30.0f+i*2.0f, SCREEN_SIZE_Y/2+60.0f+i*2.0f,
			0.0f, 128.0f, 128.0f, 10.0f,
			0.0f,   0.0f, 128.0f, 10.0f,
			0.0f, 128.0f, 128.0f, 10.0f,
			GRDRAW_OPT_GOURAUD | GRDRAW_OPT_ALPHABLEND | GS_PRIM_CTXT_V(grd_get_currentcontext()) );
		grd_2d_gtriangle(
			SCREEN_SIZE_X/2-50.0f-i*2.0f, SCREEN_SIZE_Y/2-30.0f-i*2.0f,
			SCREEN_SIZE_X/2+60.0f-i*2.0f, SCREEN_SIZE_Y/2-30.0f-i*2.0f,
			SCREEN_SIZE_X/2+60.0f-i*2.0f, SCREEN_SIZE_Y/2+30.0f-i*2.0f,
			128.0f, 128.0f, 0.0f, 10.0f,
			128.0f,   0.0f, 0.0f, 10.0f,
			128.0f, 128.0f, 0.0f, 10.0f,
			GRDRAW_OPT_GOURAUD | GRDRAW_OPT_ALPHABLEND | GS_PRIM_CTXT_V(grd_get_currentcontext()) );
	}
	grd_debug_profset( GRD_DEBUG_PROF_EE_ID, 0xff0000 );

	/* N cube */
	if (!cubeadd_flag) {
		grd_set_drawmode_anormal_ztest_zupdate( grd_get_currentcontext() );
	} else
		grd_set_drawmode_aadd_znotest_znoupdate( grd_get_currentcontext() );
	ct = 0;
	for (k = -1; k <= 20; k++) {
		if (k == -1)
			grd_tex_use( &texinfo[0], GRTEX_OPT_LINEAR, GRD_TEX_MIPMAP_DEFAULT, 0 );
		else if (k == 1)
			grd_tex_use( &texinfo[1], GRTEX_OPT_LINEAR, GRD_TEX_MIPMAP_DEFAULT, 0 );
		else if (k == 3)
			grd_tex_use( &texinfo[2], GRTEX_OPT_LINEAR, GRD_TEX_MIPMAP_DEFAULT, 0 );
		for (j = -4; j <= 4; j++) {
			for (i = -4; i <= 4; i++) {
				if (ct >= cubes)
					goto lexit;
				tvec.x = i*300.0f;
				tvec.y = j*300.0f;
				tvec.z = k*300.0f;
				trot.x = ((global_ct % 360) * (GRMFPI*2.0f)) / 360.0f;
				trot.y = (((global_ct + i*(180/5)+j*(180/5)+k*(180/4)) % 180) * (GRMFPI*2.0f)) / 180.0f;
				grg_setpos_hm( &tvec, &trot );
				cube_draw( GS_PRIM_CTXT_V(grd_get_currentcontext()), cubeadd_flag, cubetex_flag );
				ct++;
			}
		}
		grd_debug_profset( GRD_DEBUG_PROF_EE_ID, 0 );
	}
lexit:
	grd_draw_frameflip();

	return retflag;
}
