/* File: init.c

	GRENDSYS sample program "CubeN"

	Written by Toshio Fukui. (xx/xx/2001-01/23/2002)
*/

#include "grend/config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "grend/common.h"
#include "grend/grend.h"
#include "grend/grend_r.h"
#include "main.h"

const char *mes_c =
	" GRENDSYS sample program \"CubeN\" "
	" Written by Toshio Fukui. ";

void help( void )
{
	fprintf(stderr, "CubeN v0.04 written by Toshio Fukui\n");
	fprintf(stderr, "(for Grendsys library 0.04)\n\n");
	fprintf(stderr, "cuben [-vesa | -ntsc | -pal] [-nointer]\n");
	return;
}

int main( int argc, char **argv )
{
	int i, div_flag = FALSE;

	gri_resolution_mode = GRD_RESOLUTIONMODE_VESA;
	for (i = 1; i < argc; i++) {
		if (!strcasecmp( argv[i], "-nointer" ))
			div_flag = TRUE;
		else if (!strcasecmp( argv[i], "-vesa" ))
			gri_resolution_mode = GRD_RESOLUTIONMODE_VESA;
		else if (!strcasecmp( argv[i], "-ntsc" ))
			gri_resolution_mode = GRD_RESOLUTIONMODE_NTSC;
		else if (!strcasecmp( argv[i], "-pal" ))
			gri_resolution_mode = GRD_RESOLUTIONMODE_PAL;
		else {
			help();
			return 1;
		}
	}
	if (gri_resolution_mode == GRD_RESOLUTIONMODE_VESA) {
		gri_resolution_x = 640;
		gri_resolution_y = 480;
	} else if (gri_resolution_mode == GRD_RESOLUTIONMODE_NTSC) {
		gri_resolution_x = 640;
		gri_resolution_y = 448 / (div_flag + 1);
	} else {
		gri_resolution_x = 640;
		gri_resolution_y = 512 / (div_flag + 1);
	}

	/* initialize GRENDSYS */
	gri_grdrawpath1_dmabufsize = 2*1024*1024;
	gri_grdrawpath2_dmabufsize = 2*1024*1024;
	gri_dmalloc_mmapsize = 16*1024*1024;
	strcpy( gri_default_fontpath, "texdata/font.bmp" );

	grif_enable_debuginput_flag = TRUE;
	grif_enable_profiler_flag = TRUE;
	grif_enable_dispprofiler_flag = TRUE;
	grif_enable_dumpframebuffer = TRUE;
	grif_enable_dumpframebuffer_alpha = FALSE;
	grif_enable_dumpframebuffer_raw = TRUE;

	gri_bootinit();
	gri_init();
	prog_init();
	while (prog_main())
		;
	prog_exit();

	return 0;
}
