/* File: cube.c */

#include "grend/config.h"

#include <string.h>
#include <math.h>

#include "grend/common.h"
#include "grend/grend.h"
#include "grend/grend_r.h"
#include "main.h"
#include "cube.h"

#define CUBE_VERTICIES_NUM	14

GRVector4 cube_vertices[CUBE_VERTICIES_NUM] = {
	{ -1.0f,  1.0f,  1.0f, 1.0f },	/* 1 */
	{ -1.0f, -1.0f,  1.0f, 1.0f },
	{  1.0f,  1.0f,  1.0f, 1.0f },
	{  1.0f, -1.0f,  1.0f, 1.0f },
	{  1.0f, -1.0f, -1.0f, 1.0f },	/* 5 */
	{ -1.0f, -1.0f,  1.0f, 1.0f },
	{ -1.0f, -1.0f, -1.0f, 1.0f },
	{ -1.0f,  1.0f,  1.0f, 1.0f },
	{ -1.0f,  1.0f, -1.0f, 1.0f },	/* 9 */
	{  1.0f,  1.0f,  1.0f, 1.0f },
	{  1.0f,  1.0f, -1.0f, 1.0f },
	{  1.0f, -1.0f, -1.0f, 1.0f },
	{ -1.0f,  1.0f, -1.0f, 1.0f },	/* 13 */
	{ -1.0f, -1.0f, -1.0f, 1.0f }
};

#if 1	/* graduation */
GRVector4 cube_colors[CUBE_VERTICIES_NUM] = {
	{ 1.0f, 1.0f, 1.0f, 1.0f },	/* 1 */
	{ 1.0f, 1.0f, 1.0f, 1.0f },
	{ 1.0f, 1.0f, 1.0f, 1.0f },
	{ 1.0f, 1.0f, 1.0f, 1.0f },
	{ 0.3f, 0.3f, 0.3f, 1.0f },	/* 5 */
	{ 1.0f, 1.0f, 1.0f, 1.0f },
	{ 0.3f, 0.3f, 0.3f, 1.0f },
	{ 1.0f, 1.0f, 1.0f, 1.0f },
	{ 0.3f, 0.3f, 0.3f, 1.0f },	/* 9 */
	{ 1.0f, 1.0f, 1.0f, 1.0f },
	{ 0.3f, 0.3f, 0.3f, 1.0f },
	{ 0.3f, 0.3f, 0.3f, 1.0f },
	{ 0.3f, 0.3f, 0.3f, 1.0f },	/* 13 */
	{ 0.3f, 0.3f, 0.3f, 1.0f }
};
#else	/* colourful */
GRVector4 cube_colors[CUBE_VERTICIES_NUM] = {
	{ 0.3f, 1.0f, 1.0f, 1.0f },	/* 1 */
	{ 0.3f, 0.3f, 1.0f, 1.0f },
	{ 1.0f, 1.0f, 1.0f, 1.0f },
	{ 1.0f, 0.3f, 1.0f, 1.0f },
	{ 1.0f, 0.3f, 0.3f, 1.0f },	/* 5 */
	{ 0.3f, 0.3f, 1.0f, 1.0f },
	{ 0.3f, 0.3f, 0.3f, 1.0f },
	{ 0.3f, 1.0f, 1.0f, 1.0f },
	{ 0.3f, 1.0f, 0.3f, 1.0f },	/* 9 */
	{ 1.0f, 1.0f, 1.0f, 1.0f },
	{ 1.0f, 1.0f, 0.3f, 1.0f },
	{ 1.0f, 0.3f, 0.3f, 1.0f },
	{ 0.3f, 1.0f, 0.3f, 1.0f },	/* 13 */
	{ 0.3f, 0.3f, 0.3f, 1.0f }
};
#endif

GRVector4 cube_texstq[CUBE_VERTICIES_NUM] = {
	{ 0.0f, 0.0f, 1.0f, 0.0f },	/* 1 */
	{ 0.0f, 1.0f, 1.0f, 0.0f },
	{ 1.0f, 0.0f, 1.0f, 0.0f },
	{ 1.0f, 1.0f, 1.0f, 0.0f },
	{ 0.0f, 1.0f, 1.0f, 0.0f },	/* 5 */
	{ 1.0f, 0.0f, 1.0f, 0.0f },
	{ 0.0f, 0.0f, 1.0f, 0.0f },
	{ 1.0f, 1.0f, 1.0f, 0.0f },
	{ 0.0f, 1.0f, 1.0f, 0.0f },	/* 9 */
	{ 1.0f, 0.0f, 1.0f, 0.0f },
	{ 0.0f, 0.0f, 1.0f, 0.0f },
	{ 0.0f, 1.0f, 1.0f, 0.0f },
	{ 1.0f, 0.0f, 1.0f, 0.0f },	/* 13 */
	{ 1.0f, 1.0f, 1.0f, 0.0f }
};

GRVector4 cube_colors_abe[CUBE_VERTICIES_NUM];
GRVector4 cube_colors_tex[CUBE_VERTICIES_NUM];
GRVector4 cube_normals[CUBE_VERTICIES_NUM];

int cube_init( void )
{
	int i;

	/* color normal */
	for (i = 0; i < CUBE_VERTICIES_NUM; i++) {
		cube_vertices[i].x *= 100.0f;
		cube_vertices[i].y *= 100.0f;
		cube_vertices[i].z *= 100.0f;
	}

	/* for abe/tex */
	memcpy( cube_colors_abe, cube_colors, sizeof(GRVector4)*CUBE_VERTICIES_NUM );
	memcpy( cube_colors_tex, cube_colors, sizeof(GRVector4)*CUBE_VERTICIES_NUM );

	/* color normal */
	for (i = 0; i < CUBE_VERTICIES_NUM; i++) {
		cube_colors[i].x *= 255.0f;
		cube_colors[i].y *= 255.0f;
		cube_colors[i].z *= 255.0f;
		cube_colors[i].w  = 255.0f;
	}

	/* color abe */
	for (i = 0; i < CUBE_VERTICIES_NUM; i++) {
		cube_colors_abe[i].x *= 128.0f;
		cube_colors_abe[i].y *= 128.0f;
		cube_colors_abe[i].z *= 128.0f;
		cube_colors_abe[i].w  = 60.0f;
	}

	/* color tex */
	for (i = 0; i < CUBE_VERTICIES_NUM; i++) {
		cube_colors_tex[i].x = cube_colors_abe[i].x;
		cube_colors_tex[i].y = cube_colors_abe[i].y;
		cube_colors_tex[i].z = cube_colors_abe[i].z;
		cube_colors_tex[i].w = 128.0f;
	}

#if 0
	/* normal */
	for (i = 0; i < CUBE_VERTICIES_NUM; i++) {
		grm_normalize_vector4( &cube_normals[i], &cube_vertices[i] );
		cube_normals[i].x = -cube_normals[i].x;
		cube_normals[i].y = -cube_normals[i].y;
		cube_normals[i].z = -cube_normals[i].z;
		cube_normals[i].w = 1.0f;
	}
#endif
	return TRUE;
}

int cube_draw( int opt, int abe_flag, int tex_flag )
{
	if (abe_flag) {
		if (!tex_flag) {
			grd_3d_vgtriangles( CUBE_VERTICIES_NUM, cube_vertices, cube_colors_abe,
				GRDRAW_OPT_GOURAUD | GRDRAW_OPT_ALPHABLEND | opt );
		} else {
			grd_3d_vgttriangles( CUBE_VERTICIES_NUM, cube_vertices,
				cube_colors_abe, cube_texstq,
				GRDRAW_OPT_GOURAUD | GRDRAW_OPT_ALPHABLEND | opt );
		}
	} else {
		if (!tex_flag) {
			grd_3d_vgtriangles( CUBE_VERTICIES_NUM, cube_vertices, cube_colors,
				GRDRAW_OPT_GOURAUD | opt );
		} else {
			grd_3d_vgttriangles( CUBE_VERTICIES_NUM, cube_vertices,
				cube_colors_tex, cube_texstq,
				GRDRAW_OPT_GOURAUD | opt );
		}
	}
	return TRUE;
}
