/* File: dmamemtest.c */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <sys/mman.h>
#include <asm/io.h>
#include <asm/page.h>
#include <linux/ps2/dev.h>

#ifndef PS2LINUX_ADD_FUNCTIONS_REV_MAJOR
#error "Need special patch version linux kernel\n"
#endif

//#define PORT_OFFSET 0x2000000
#define PORT_OFFSET 0x0000000

void *geniomem_alloc( void )
{
	int fd;
	void *m;

	fd = open(PS2_DEV_GENIO, O_RDWR);
	if (fd < 0) {
		printf("geniotest: open error\n");
		return (void *)-1;
	}

	m = mmap( 0, 0x4000000,
		PROT_READ | PROT_WRITE, MAP_PRIVATE, fd, PORT_OFFSET );
	if (m==(void*)-1) {
		printf("geniotest: mmap error %d\n", errno);
		close(fd);
		return (void *)-1;
	}
	close(fd);
	return m;
}

int main( int argc, char **argv )
{
	char *m;

	m = geniomem_alloc();

	while (1) {
		if (!PORT_OFFSET) {
			printf("T0 (0x10000000) : %d\n", *(int *)(m+0x10000000-PS2_DEV_GENIO_OFFSET));
			printf("T1 (0x10000800) : %d\n", *(int *)(m+0x10000800-PS2_DEV_GENIO_OFFSET));
			printf("T2 (0x10001000) : %d\n", *(int *)(m+0x10001000-PS2_DEV_GENIO_OFFSET));
			printf("T3 (0x10001800) : %d\n", *(int *)(m+0x10001800-PS2_DEV_GENIO_OFFSET));
		}

		if (PORT_OFFSET <= 0x2000000) {
			printf("Write BG (0x120000E0)\n");
			*(int *)(m+((0x120000E0-PS2_DEV_GENIO_OFFSET) -PORT_OFFSET)) = (rand() & 0xffU) | ((rand() & 0xffU) << 8) | ((rand() & 0xffU) << 16);
		}
		printf("\nPush Ctrl+C or Return\n\n");
		getchar();
	}
	return 0;
}
