/* File: matrix.h */

#ifndef __MATRIX_H_INCLUDED
#define __MATRIX_H_INCLUDED

#include <math.h>

#ifdef USE_TABLE_COSSIN
#define GRM_SINTABLE_MAX	8192
#define GRM_COSTABLE_MAX	8192

extern float __grm_sin_table[GRM_SINTABLE_MAX];
extern float __grm_cos_table[GRM_COSTABLE_MAX];

#define grm_tsinf(_X) __grm_sin_table[((int)(((float)(_X))*(((float)GRM_SINTABLE_MAX/2.0f)/(2.0f*GRMFPI))) % (GRM_SINTABLE_MAX/2)) + GRM_SINTABLE_MAX/2]
#define grm_tcosf(_X) __grm_cos_table[((int)(((float)(_X))*(((float)GRM_COSTABLE_MAX/2.0f)/(2.0f*GRMFPI))) % (GRM_COSTABLE_MAX/2)) + GRM_COSTABLE_MAX/2]
#else
#define grm_tsinf(_X) sinf((_X))
#define grm_tcosf(_X) cosf((_X))
#endif

#define GRMFPI	((float)M_PI)

typedef struct {
	float x;
	float y;
	float z;
} GRVector3 __attribute__ ((aligned(16)));

typedef struct {
	float x;
	float y;
	float z;
	float w;
} GRVector4 __attribute__ ((aligned(16)));

typedef struct {
	GRVector4 m[4];
} GRMatrix44 __attribute__ ((aligned(16)));

enum GRM_rotation_matrix_mode {
	GRM_XYZ = 0,
	GRM_ZYX,
        GRM_MAX_NUM
};

extern GRMatrix44 m_unitmatrix;

#define grm_matrix44_setunit( dest )   memcpy( (dest), &m_unitmatrix, sizeof(GRMatrix44) )
#define grm_matrix44_copy( dest, src ) memcpy( (dest), (src),         sizeof(GRMatrix44) )

#define grm_vector4_a_const( target, vec1, const ) \
	(target)->x = (vec1)->x + (const);	\
	(target)->y = (vec1)->y + (const);	\
	(target)->z = (vec1)->z + (const);	\
	(target)->w = (vec1)->w + (const);

#define grm_vector4_a_vector4( target, vec1, vec2 ) \
	(target)->x = (vec1)->x + (vec2)->x;	\
	(target)->y = (vec1)->y + (vec2)->y;	\
	(target)->z = (vec1)->z + (vec2)->z;	\
	(target)->w = (vec1)->w + (vec2)->w;

#define grm_vector4_s_vector4( target, vec1, vec2 ) \
	(target)->x = (vec1)->x - (vec2)->x;	\
	(target)->y = (vec1)->y - (vec2)->y;	\
	(target)->z = (vec1)->z - (vec2)->z;	\
	(target)->w = (vec1)->w - (vec2)->w;

#define grm_vector4_m_vector4( target, vec1, vec2 ) \
	(target)->x = (vec1)->x * (vec2)->x;	\
	(target)->y = (vec1)->y * (vec2)->y;	\
	(target)->z = (vec1)->z * (vec2)->z;	\
	(target)->w = (vec1)->w * (vec2)->w;

extern void __grm_init( void );
extern void grm_rotmatrix44_vector3( GRMatrix44 *target_m, GRVector3 *angles, int mode );
extern void grm_rotmatrix44_vector3_nt( GRMatrix44 *target_m, GRVector3 *angles, int mode );
extern void grm_translate_matrix44( GRMatrix44 *target_m, GRMatrix44 *mat, GRVector4 *vec );
extern void grm_matrix44_m_matrix44( GRMatrix44 *target_m, GRMatrix44 *mat1, GRMatrix44 *mat2 );
extern void grm_vector4_m_matrix44( GRVector4 *target_v, GRVector4 *vec1, GRMatrix44 *mat1 );
extern void grm_matrix44_m_vector4( GRVector4 *target_v, GRMatrix44 *mat1, GRVector4 *vec1 );

#endif /* __MATRIX_H_INCLUDED */
