/* File: main.c */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <assert.h>

#include "common.h"
#include "config_fire.h"
#include "main.h"
#include "input.h"
#include "draw.h"
#include "tex.h"
#include "font.h"
#include "matrix.h"
#include "geometry.h"
#include "prim.h"
#include "prim2d.h"
#include "prim3d.h"
#include "vpu1.h"
#include "debug.h"
#include "fire.h"

#define CAMERA_MOVE_UNIT	100.0f

static GRVector4 cam_pos;
static GRVector3 cam_angle;
GRD_TEX_INFO texinfo[FIRE_TEXTURE_NUM];

#ifdef USE_VPU1
int vpu1_id;
#endif

static int global_ct = 0;
static int fires = 10;
static int total = 0;

static void camera_init( void )
{
	cam_pos.x	=     0.0f;
	cam_pos.y	=     0.0f;
	cam_pos.z	=  -2000.0f;
	cam_pos.w	=     1.0f;
	cam_angle.x	=     0.0f;
	cam_angle.y	=     0.0f;
	cam_angle.z	=     0.0f;
	return;
}

int prog_init( void )
{
	int i;
	char buf[256];

	camera_init();
	grg_cam_pos   = cam_pos;
	grg_cam_angle = cam_angle;
	grg_set3Dmatrix( 3.0f, 65535.0f );
	grg_set3Dmatrix_camera();

	total = 0;
	fire_init();
	for (i = 0; i < FIRE_TEXTURE_NUM; i++) {
		sprintf(buf, "texdata/fire_%02d.bmp", i);
		grd_tex_read( GRD_TRATTR_ERROREXIT, NULL, &texinfo[i], buf );
	}
#ifdef USE_VPU1
	vpu1_id = grd_ps2_vpu1_load( "sprite.elf" );
	if (vpu1_id < 0)
		EXIT(1);
#endif
	return TRUE;
}

int prog_main( void )
{
	int i;
	int retflag = TRUE;
	int pause_flag = FALSE;

	grd_draw_framestart();

	/* move and set camera */
	for (i = 0; i < GRP_GAMEDEV_MAX; i++) {
	  	if (grp_key_buttons[i] & GRP_KEYSELECT) {
			pause_flag = TRUE;
			break;
		}
		cam_pos.x = cam_pos.x + (float)grp_key_analog1_h[i];
		cam_pos.y = cam_pos.y + (float)grp_key_analog1_v[i];
		cam_pos.z = cam_pos.z + (float)grp_key_analog2_v[i];
		if (grp_key_buttons[i] & GRP_KEYLEFT)
			cam_angle.x = cam_angle.x - (float)M_PI/180.0f;
		if (grp_key_buttons[i] & GRP_KEYRIGHT)
			cam_angle.x = cam_angle.x + (float)M_PI/180.0f;
		if (grp_key_buttons[i] & GRP_KEYUP)
			cam_angle.y = cam_angle.y - (float)M_PI/180.0f;
		if (grp_key_buttons[i] & GRP_KEYDOWN)
			cam_angle.y = cam_angle.y + (float)M_PI/180.0f;
		if (grp_key_triggers[i] & GRP_KEYSTART)
			camera_init();
		if (grp_key_buttons[i] & GRP_KEYA) {
			if (fires < FIRE_MAX_NUM)
				fires++;
		}
		if (grp_key_buttons[i] & GRP_KEYB) {
			if (fires > 0)
				--fires;
		}
	}
	grg_cam_pos   = cam_pos;
	grg_cam_angle = cam_angle;
	grg_set3Dmatrix_camera();

	if (!pause_flag)
		global_ct++;

	/* message */
	grd_font_locate( 0, 10, 40 );
	grd_font_setsize( 0, 100 );
	grd_font_setcolor( 0, 127, 255, 127+64, 127, 0 );
	grd_font_printf( 0, "Fire Demo : N=%d/MAX=%d SPRITE=%d %dx%d\n", fire_getnum(), fires, total, gri_resolution_x, gri_resolution_y );
	grd_font_setcolor( 0, 255, 255, 255, 127, 0 );
	grd_font_printf( 0, "pX:%9.2f pY:%9.2f pZ:%9.2f\n", cam_pos.x,   cam_pos.y,   cam_pos.z );
	grd_font_printf( 0, "rX:%9.2f rY:%9.2f rZ:%9.2f\n", cam_angle.x, cam_angle.y, cam_angle.z );
	grd_font_setcolor( 0, 255, 255, 127, 127, 0 );
	grd_font_printf( 0, "\nAnalog, Left buttons, L1,L2,R1,R2, Start ... camera control.\n" );
	grd_font_printf( 0, "O,X ... fire number.\n" );
	grd_font_printf( 0, "Select + other buttons ... debug control. (select+start = framedump)\n" );

	/* set path */
	grd_set_currentdrawpath( GRDRAW_PATH1 );
	grd_set_currentcontext( GRDRAW_CONTEXT1 );
	grd_debug_profset( GRD_DEBUG_PROF_EE_ID, 0xff0000 );

	/* fireworks */
	grd_set_drawmode_aadd_znotest_znoupdate( grd_get_currentcontext() );
	if (fires > 110) {
		if (fires > fire_getnum()) {
			fire_setup();
			fire_setup();
			fire_setup();
		}
	} else if (fires > 50) {
		if (fires > fire_getnum()) {
			fire_setup();
			fire_setup();
		}
	} else if (fires > 20) {
		if (fires > fire_getnum())
			fire_setup();
	} else {
		if ((fires > fire_getnum()) && (rand() > RAND_MAX/10*6))
			fire_setup();
	}
	grd_debug_profset( GRD_DEBUG_PROF_EE_ID, 0 );
	if (!pause_flag)
		fire_move();
	grd_debug_profset( GRD_DEBUG_PROF_EE_ID, 0 );
	total = fire_draw();
	grd_debug_profset( GRD_DEBUG_PROF_EE_ID, 0 );
	grd_draw_frameflip();

	return retflag;
}
