/* File: fire.c */

#include "config.h"

#include <string.h>
#include <math.h>

#include "common.h"
#include "config_fire.h"
#include "main.h"
#include "draw.h"
#include "matrix.h"
#include "geometry.h"
#include "prim3d.h"
#include "vpu1.h"
#include "fire.h"
#include "fire_sub.h"
#include "sprite.h"

int fire_num;
static int fire_new_index = 0;
static FIRE_COMMON_STRUCT fire_common_struct[FIRE_MAX_NUM];

int fire_init( void )
{
	fire_num = 0;
	fire_new_index = 0;
	memset( fire_common_struct, 0, sizeof(fire_common_struct) );
	return TRUE;
}

FIRE_COMMON_STRUCT *fire_new( FIRE_COMMON_STRUCT *fp, int size1, int size2 )
{
	int i;
	void *p1, *p2;

	p1 = MALLOC( size1 );
	p2 = DMALLOC( size2 );
	if (!p1 || !p2) {
		DFREE(p2);
		FREE(p1);
		return NULL;
	}

	for (i = 0; i < FIRE_MAX_NUM; i++) {
		fire_new_index++;
		if (fire_new_index >= FIRE_MAX_NUM)
			fire_new_index = 0;
		if (!fire_common_struct[fire_new_index].type) {
			fire_common_struct[fire_new_index] = *fp;
			fire_common_struct[fire_new_index].mem_p  = p1;
			fire_common_struct[fire_new_index].dmem_p = p2;
			fire_num++;
			return &fire_common_struct[fire_new_index];
		}
	}
	return NULL;
}

void fire_delete( FIRE_COMMON_STRUCT *fp )
{
	fp->type = -4;
	FREE(fp -> mem_p);
	DFREE(fp -> dmem_p);
	--fire_num;
	return;
}

void fire_move( void )
{
	int i, val;

	for (i = 0; i < FIRE_MAX_NUM; i++) {
		if ((val = fire_common_struct[i].type)) {
			if (val < 0)
				fire_common_struct[i].type++;
			else {
				fire_sub_move( &fire_common_struct[i] );
				fire_common_struct[i].pasttime++;
				--fire_common_struct[i].resttime;
				//printf("%d/%d\n", fire_common_struct[i].n, fire_common_struct[i].max);
				if (fire_common_struct[i].n <= 0)
					fire_common_struct[i].resttime = 0;
				if (fire_common_struct[i].resttime <= 0)
					fire_delete( &fire_common_struct[i] );
			}
		}
	}
	return;
}

int fire_draw( void )
{
	int i, val, total;

	total = 0;
#ifdef USE_VPU1
	if (grd_ps2_vpu1_use( vpu1_id, TRUE, FALSE ) == TRUE)
		grd_ps2_vpu1_setdma( VPU1_BASE, VPU1_OFFSET );
#endif
	for (i = 0; i < FIRE_MAX_NUM; i++) {
		if ((val = fire_common_struct[i].type) > 0) {
			fire_sub_draw( &fire_common_struct[i] );
			total += fire_common_struct[i].n;
		}
	}
	_gps2_setdma_vif1( PS2_VIF_SET_CODE(0, 0, PS2_VIF_FLUSHA, 0) );
	return total;
}

void fire_setup( void )
{
	fire_sub_setup();
}
