/* File: context.h */

#ifndef __CONTEXT_H_INCLUDED
#define __CONTEXT_H_INCLUDED

#include "draw.h"

/* draw context */
#define grd_set_currentcontext(_CTXT) \
	__grl_ps2draw_context = (_CTXT);

#define grd_get_currentcontext() __grl_ps2draw_context

/* draw path, packet adr */
#ifdef USE_DRAWPATH_3
#define grd_set_closedrawpath() \
	if (__grl_ps2gdma_sysbuf) { \
		__grl_ps2gdma_sysbuf = FALSE; \
		__grl_ps2gdma_buf[__grl_ps2gdma_path] = __grl_ps2gdma_buf_p; \
	}

#define grd_set_currentdrawpath(_PATH) { \
		grd_set_closedrawpath(); \
		__grl_ps2gdma_path  = (_PATH); \
		__grl_ps2gdma_buf_p = __grl_ps2gdma_buf[__grl_ps2gdma_path]; \
		__grl_ps2gdma_sysbuf  = TRUE; \
	}

#define grd_set_currentdrawpath_user(_PATH, _ADR) { \
		grd_set_closedrawpath(); \
		if ((_PATH) >= 0) \
			__grl_ps2gdma_path = (_PATH); \
		__grl_ps2gdma_buf_p = (_ADR); \
		__grl_ps2gdma_sysbuf = FALSE; \
	}
#else
#define grd_set_closedrawpath() \
	if (__grl_ps2gdma_sysbuf) { \
		__grl_ps2gdma_sysbuf = FALSE; \
		__grl_ps2gdma_buf[__grl_ps2gdma_path] = __grl_ps2gdma_buf_p; \
	}

#define grd_set_currentdrawpath(_PATH) { \
		grd_set_closedrawpath(); \
		__grl_ps2gdma_buf_p = __grl_ps2gdma_buf[__grl_ps2gdma_path]; \
		__grl_ps2gdma_sysbuf  = TRUE; \
	}

#define grd_set_currentdrawpath_user(_PATH, _ADR) { \
		grd_set_closedrawpath(); \
		__grl_ps2gdma_buf_p = (_ADR); \
		__grl_ps2gdma_sysbuf = FALSE; \
	}
#endif

#define grd_get_currentdrawpath()   __grl_ps2gdma_path
#define grd_get_currentdrawsysbuf() __grl_ps2gdma_sysbuf
#define grd_get_currentdrawadr()    __grl_ps2gdma_buf_p

#include "def_dma.h"
#include "def_gs.h"

/* draw sync functions */
#define grd_wait_draw() \
	_gps2_setdma_vif1( PS2_VIF_SET_CODE( 0, 0, PS2_VIF_FLUSH, 0 ) );

/* texture sync function */
#define grd_texture_flush() { \
		_gps2_setdma_dmagif( 1, 1, GIF_EOP | GIF_FLG_PACKED, GIF_REGS(GIF_REGS_A_D, 0) ); \
		_gps2_setdma_6464ul( PS2_GS_TEXFLUSH, 0 ); \
	}

/* alpha = normal, ztest, zupdate */
#define _gps2_set_drawmode_anormal_ztest_zupdate_p( _CTXT ) { \
		_gps2_setdma_6464ul( PS2_GS_ALPHA_1+(_CTXT), \
			GS_ALPHA_A(0) | GS_ALPHA_B(1) | GS_ALPHA_C(0) | GS_ALPHA_D(1) ); \
		_gps2_setdma_6464ul( PS2_GS_ZBUF_1+(_CTXT), \
			GS_ZBUF_ZBP(__grl_ps2_gdb.draw01.zbuf1.ZBP) | \
			GS_ZBUF_PSM(__grl_ps2_gdb.draw01.zbuf1.PSM) | GS_ZBUF_ZMSK_N ); \
		_gps2_setdma_6464ul( PS2_GS_TEST_1+(_CTXT), \
			GS_TEST_ZTE | GS_TEST_ZTST(2) ); \
	}

#define grd_set_drawmode_anormal_ztest_zupdate( _CTXT ) { \
		_gps2_setdma_dmagif( 3, 1, GIF_EOP | GIF_FLG_PACKED, GIF_REGS(GIF_REGS_A_D, 0) ); \
		_gps2_set_drawmode_anormal_ztest_zupdate_p( (_CTXT) ); \
	}

/* alpha = normal, znotest, znoupdate */
#define _gps2_set_drawmode_anormal_znotest_znoupdate_p( _CTXT ) { \
		_gps2_setdma_6464ul( PS2_GS_ALPHA_1+(_CTXT), \
			GS_ALPHA_A(0) | GS_ALPHA_B(1) | GS_ALPHA_C(0) | GS_ALPHA_D(1) ); \
		_gps2_setdma_6464ul( PS2_GS_ZBUF_1+(_CTXT), \
			GS_ZBUF_ZBP(__grl_ps2_gdb.draw01.zbuf1.ZBP) | \
			GS_ZBUF_PSM(__grl_ps2_gdb.draw01.zbuf1.PSM) | GS_ZBUF_ZMSK ); \
		_gps2_setdma_6464ul( PS2_GS_TEST_1+(_CTXT), \
			GS_TEST_ZTE | GS_TEST_ZTST(1) ); \
	}

#define grd_set_drawmode_anormal_znotest_znoupdate( _CTXT ) { \
		_gps2_setdma_dmagif( 3, 1, GIF_EOP | GIF_FLG_PACKED, GIF_REGS(GIF_REGS_A_D, 0) ); \
		_gps2_set_drawmode_anormal_znotest_znoupdate_p( (_CTXT) ); \
	}

/* alpha = add, ztest, zupdate */
#define _gps2_set_drawmode_aadd_ztest_zupdate_p( _CTXT ) { \
		_gps2_setdma_6464ul( PS2_GS_ALPHA_1+(_CTXT), \
			GS_ALPHA_A(0) | GS_ALPHA_B(2) | GS_ALPHA_C(0) | GS_ALPHA_D(1) ); \
		_gps2_setdma_6464ul( PS2_GS_ZBUF_1+(_CTXT), \
			GS_ZBUF_ZBP(__grl_ps2_gdb.draw01.zbuf1.ZBP) | \
			GS_ZBUF_PSM(__grl_ps2_gdb.draw01.zbuf1.PSM) | GS_ZBUF_ZMSK_N ); \
		_gps2_setdma_6464ul( PS2_GS_TEST_1+(_CTXT), \
			GS_TEST_ZTE | GS_TEST_ZTST(2) ); \
	}

#define grd_set_drawmode_aadd_ztest_zupdate( _CTXT ) { \
		_gps2_setdma_dmagif( 3, 1, GIF_EOP | GIF_FLG_PACKED, GIF_REGS(GIF_REGS_A_D, 0) ); \
		_gps2_set_drawmode_aadd_ztest_zupdate_p( (_CTXT) ); \
	}

/* alpha = add, znotest, znoupdate */
#define _gps2_set_drawmode_aadd_znotest_znoupdate_p( _CTXT ) { \
		_gps2_setdma_6464ul( PS2_GS_ALPHA_1+(_CTXT), \
			GS_ALPHA_A(0) | GS_ALPHA_B(2) | GS_ALPHA_C(0) | GS_ALPHA_D(1) ); \
		_gps2_setdma_6464ul( PS2_GS_ZBUF_1+(_CTXT), \
			GS_ZBUF_ZBP(__grl_ps2_gdb.draw01.zbuf1.ZBP) | \
			GS_ZBUF_PSM(__grl_ps2_gdb.draw01.zbuf1.PSM) | GS_ZBUF_ZMSK ); \
		_gps2_setdma_6464ul( PS2_GS_TEST_1+(_CTXT), \
			GS_TEST_ZTE | GS_TEST_ZTST(1) ); \
	}

#define grd_set_drawmode_aadd_znotest_znoupdate( _CTXT ) { \
		_gps2_setdma_dmagif( 3, 1, GIF_EOP | GIF_FLG_PACKED, GIF_REGS(GIF_REGS_A_D, 0) ); \
		_gps2_set_drawmode_aadd_znotest_znoupdate_p( (_CTXT) ); \
	}

/* set clamp, repeat */
#define grd_set_drawmode_texrepeat( _CTXT ) { \
	_gps2_setdma_dmagif( 1, 1, GIF_EOP | GIF_FLG_PACKED, GIF_REGS(GIF_REGS_A_D, 0) ); \
	_gps2_setdma_6464ul( PS2_GS_CLAMP_1+(_CTXT), \
		GS_CLAMP_WMS_REPEAT | GS_CLAMP_WMT_REPEAT ); \
}

/* set clamp, clamp */
#define grd_set_drawmode_texclamp( _CTXT ) { \
	_gps2_setdma_dmagif( 1, 1, GIF_EOP | GIF_FLG_PACKED, GIF_REGS(GIF_REGS_A_D, 0) ); \
	_gps2_setdma_6464ul( PS2_GS_CLAMP_1+(_CTXT), \
		GS_CLAMP_WMS_CLAMP | GS_CLAMP_WMT_CLAMP ); \
}

#endif /* __CONTEXT_H_INCLUDED */
