/*
 * Decompiled with CFR 0.152.
 */
package jdd.zdd;

import jdd.bdd.OptimizedCache;
import jdd.util.Configuration;
import jdd.util.Test;
import jdd.zdd.ZDD;

public class ZDD2
extends ZDD {
    private static final int CACHE_MUL = 0;
    private static final int CACHE_DIV = 1;
    private static final int CACHE_MOD = 2;
    protected OptimizedCache unate_cache;

    public ZDD2(int n) {
        this(n, 1000);
    }

    public ZDD2(int n, int n2) {
        super(n, n2);
        this.unate_cache = new OptimizedCache("unate", n2 / Configuration.zddUnateCacheDiv, 3, 2);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.unate_cache = null;
    }

    @Override
    protected void post_removal_callbak() {
        super.post_removal_callbak();
        this.unate_cache.free_or_grow(this);
    }

    public final int mul(int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n == 0 || n2 == 0) {
            return 0;
        }
        if (n == 1) {
            return n2;
        }
        if (n2 == 1) {
            return n;
        }
        int n6 = this.getVar(n);
        if (n6 > (n5 = this.getVar(n2))) {
            n4 = n;
            n = n2;
            n2 = n4;
            n4 = n6;
            n6 = n5;
            n5 = n4;
        }
        if (this.unate_cache.lookup(n, n2, 0)) {
            return this.unate_cache.answer;
        }
        n4 = this.unate_cache.hash_value;
        if (n6 < n5) {
            int n7 = this.mul(n, this.getHigh(n2));
            this.work_stack[this.work_stack_tos++] = n7;
            int n8 = n7;
            int n9 = this.mul(n, this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n9;
            int n10 = n9;
            n3 = this.mk(n5, n10, n8);
            this.work_stack_tos -= 2;
        } else {
            int n11 = this.mul(this.getHigh(n), this.getHigh(n2));
            this.work_stack[this.work_stack_tos++] = n11;
            int n12 = n11;
            int n13 = this.mul(this.getHigh(n), this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n13;
            int n14 = n13;
            n3 = this.union(n12, n14);
            this.work_stack_tos -= 2;
            this.work_stack[this.work_stack_tos++] = n3;
            int n15 = this.mul(this.getLow(n), this.getHigh(n2));
            this.work_stack[this.work_stack_tos++] = n15;
            n12 = n15;
            n12 = this.union(n3, n12);
            this.work_stack_tos -= 2;
            this.work_stack[this.work_stack_tos++] = n12;
            int n16 = this.mul(this.getLow(n), this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n16;
            n14 = n16;
            n3 = this.mk(n6, n14, n12);
            this.work_stack_tos -= 2;
        }
        this.unate_cache.insert(n4, n, n2, 0, n3);
        return n3;
    }

    public final int div(int n, int n2) {
        int n3;
        int n4;
        if (n < 2) {
            return 0;
        }
        if (n == n2) {
            return 1;
        }
        if (n2 == 1) {
            return n;
        }
        int n5 = this.getVar(n);
        if (n5 < (n4 = this.getVar(n2))) {
            return 0;
        }
        if (this.unate_cache.lookup(n, n2, 1)) {
            return this.unate_cache.answer;
        }
        int n6 = this.unate_cache.hash_value;
        if (n5 > n4) {
            int n7 = this.div(this.getLow(n), n2);
            this.work_stack[this.work_stack_tos++] = n7;
            int n8 = n7;
            int n9 = this.div(this.getHigh(n), n2);
            this.work_stack[this.work_stack_tos++] = n9;
            int n10 = n9;
            n3 = this.mk(n5, n8, n10);
            this.work_stack_tos -= 2;
        } else {
            n3 = this.div(this.getHigh(n), this.getHigh(n2));
            int n11 = this.getLow(n2);
            if (n11 != 0 && n3 != 0) {
                this.work_stack[this.work_stack_tos++] = n3;
                int n12 = this.div(this.getLow(n), n11);
                this.work_stack[this.work_stack_tos++] = n12;
                n11 = n12;
                n3 = this.intersect(n11, n3);
                this.work_stack_tos -= 2;
            }
        }
        this.unate_cache.insert(n6, n, n2, 1, n3);
        return n3;
    }

    public final int mod(int n, int n2) {
        if (this.unate_cache.lookup(n, n2, 2)) {
            return this.unate_cache.answer;
        }
        int n3 = this.unate_cache.hash_value;
        int n4 = this.div(n, n2);
        this.work_stack[this.work_stack_tos++] = n4;
        int n5 = n4;
        int n6 = this.mul(n2, n5);
        this.work_stack[this.work_stack_tos++] = n6;
        n5 = n6;
        n5 = this.diff(n, n5);
        this.work_stack_tos -= 2;
        this.unate_cache.insert(n3, n, n2, 2, n5);
        return n5;
    }

    @Override
    public void showStats() {
        super.showStats();
        this.unate_cache.showStats();
    }

    @Override
    public long getMemoryUsage() {
        long l = super.getMemoryUsage();
        if (this.unate_cache != null) {
            l += this.unate_cache.getMemoryUsage();
        }
        return l;
    }

    public static void internal_test() {
        Test.start("ZDD2");
        ZDD2 zDD2 = new ZDD2(1000);
        int n = zDD2.createVar();
        int n2 = zDD2.createVar();
        int n3 = zDD2.createVar();
        int n4 = zDD2.createVar();
        int n5 = zDD2.createVar();
        int n6 = zDD2.createVar();
        int n7 = zDD2.createVar();
        int n8 = zDD2.createVar();
        int n9 = zDD2.cubes_union("010 100 011");
        int n10 = zDD2.union(zDD2.cube("11"), 1);
        int n11 = zDD2.mul(n9, n10);
        int n12 = zDD2.cubes_union("010 100 011 111");
        Test.checkEquality(n11, n12, "P * Q");
        Test.checkEquality(zDD2.work_stack_tos, 0, "TOS restored after mul");
        int n13 = zDD2.cubes_union("011 111 1110");
        int n14 = zDD2.cube("1000");
        int n15 = zDD2.mul(n13, n14);
        n12 = zDD2.cubes_union("1011 1111 1110");
        Test.checkEquality(n15, n12, "{ab,abc,bcd}*d = {abd,abcd,bcd}");
        n14 = zDD2.cube("1");
        n15 = zDD2.mul(n13, n14);
        n12 = zDD2.cubes_union("011 111 1111");
        Test.checkEquality(n15, n12, "{ab,abc,bcd}*a = {ab,abc,abc}");
        n9 = zDD2.cubes_union("111 110 101");
        n10 = zDD2.cube("110");
        n11 = zDD2.div(n9, n10);
        n12 = zDD2.union(zDD2.cube("1"), 1);
        Test.checkEquality(n11, n12, "P / Q");
        Test.checkEquality(zDD2.work_stack_tos, 0, "TOS restored after div (1)");
        n9 = zDD2.cubes_union("1011 10011 1000011 1100 10000100 10100");
        n10 = zDD2.cubes_union("011 100");
        n11 = zDD2.div(n9, n10);
        n12 = zDD2.cubes_union("1000 10000");
        Test.checkEquality(n11, n12, "P / Q (2)");
        Test.checkEquality(zDD2.work_stack_tos, 0, "TOS restored after div (2)");
        n9 = zDD2.cubes_union("1011 0111 1110");
        n10 = zDD2.cubes_union("1000");
        n12 = zDD2.cubes_union("011 110");
        n11 = zDD2.div(n9, n10);
        Test.checkEquality(n11, n12, "div by scalar (prefix)");
        Test.checkEquality(zDD2.work_stack_tos, 0, "TOS restored after div (3)");
        Test.checkEquality(n12, zDD2.subset1(n9, zDD2.getVar(n10)), "div by scalar (prefix)");
        n11 = zDD2.mod(n9, n10);
        Test.checkEquality(n11, zDD2.subset0(n9, zDD2.getVar(n10)), "mod by scalar (prefix)");
        Test.checkEquality(zDD2.work_stack_tos, 0, "TOS restored after mod");
        n9 = zDD2.cubes_union("1011 0111 1110");
        n10 = zDD2.cubes_union("0001");
        n12 = zDD2.cubes_union("1010 0110");
        n11 = zDD2.div(n9, n10);
        Test.checkEquality(n11, n12, "div by scalar (suffix)");
        Test.checkEquality(zDD2.work_stack_tos, 0, "TOS restored after div (4)");
        Test.checkEquality(n12, zDD2.subset1(n9, zDD2.getVar(n10)), "div by scalar (suffix)");
        n11 = zDD2.mod(n9, n10);
        Test.checkEquality(n11, zDD2.subset0(n9, zDD2.getVar(n10)), "mod by scalar (suffix)");
        Test.checkEquality(zDD2.work_stack_tos, 0, "TOS restored after mod (2)");
        n9 = zDD2.cubes_union("0011 0111 1110");
        n10 = zDD2.cubes_union("0110 0111");
        n12 = zDD2.cubes_union("0111 1111 1110");
        n11 = zDD2.mul(n9, n10);
        Test.checkEquality(n12, n11, "generic mul");
        Test.checkEquality(zDD2.work_stack_tos, 0, "TOS restored after mul (2)");
        Test.checkEquality(0, zDD2.div(n9, n10), "generic div");
        Test.checkEquality(n9, zDD2.mod(n9, n10), "generic mod");
        Test.end();
    }
}

