/*
 * Decompiled with CFR 0.152.
 */
package jdd.sat.bdd;

import java.io.IOException;
import jdd.sat.Clause;
import jdd.sat.DimacsReader;
import jdd.sat.bdd.BDDSolver;
import jdd.util.Array;

public class BDDSolver2
extends BDDSolver {
    private boolean[] clause_taken;
    private int[] clause_list;
    private int[] extra_list;

    public BDDSolver2(boolean bl) {
        super(bl);
    }

    @Override
    public int[] solve() {
        this.clause_taken = new boolean[this.cnf.curr];
        this.clause_list = new int[this.cnf.curr];
        this.extra_list = new int[this.cnf.curr];
        Array.set(this.clause_taken, false);
        return super.solve();
    }

    @Override
    public Clause nextClause() {
        return this.choose_smallest_random();
    }

    private Clause choose_smallest_random() {
        int n = 3;
        int n2 = -1;
        int n3 = Integer.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            int n4 = -1;
            while (this.clause_taken[n4 = (int)(Math.random() * (double)this.cnf.curr)]) {
            }
            int n5 = this.jdd.and(this.bdd_all, this.clauseBDD(this.cnf.clauses[n4]));
            int n6 = this.jdd.nodeCount(n5);
            this.jdd.deref(n5);
            if (n6 >= n3) continue;
            n2 = n4;
            n3 = n6;
        }
        this.clause_taken[n2] = true;
        return this.cnf.clauses[n2];
    }

    private Clause choose_first() {
        for (int i = 0; i < this.cnf.curr; ++i) {
            if (this.clause_taken[i]) continue;
            this.clause_taken[i] = true;
            return this.cnf.clauses[i];
        }
        return null;
    }

    private Clause choose_most_relevant() {
        int n;
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        for (n = 0; n < this.cnf.curr; ++n) {
            if (this.clause_taken[n]) continue;
            Clause clause = this.cnf.clauses[n];
            int n4 = clause.curr - this.count_allocation(clause);
            if (n3 > n4) {
                n2 = 0;
                n3 = n4;
            }
            if (n3 != n4) continue;
            this.clause_list[n2++] = n;
        }
        n = this.clause_list[(int)(Math.random() * (double)n2)];
        this.clause_taken[n] = true;
        return this.cnf.clauses[n];
    }

    private Clause choose_largest() {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.cnf.curr; ++n) {
            if (this.clause_taken[n]) continue;
            Clause clause = this.cnf.clauses[n];
            if (n3 < clause.curr) {
                n2 = 0;
                n3 = clause.curr;
            }
            if (n3 != clause.curr) continue;
            this.clause_list[n2++] = n;
        }
        n = this.choose_least_new(this.clause_list, n2);
        this.clause_taken[n] = true;
        return this.cnf.clauses[n];
    }

    private Clause choose_smallest() {
        int n;
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        for (n = 0; n < this.cnf.curr; ++n) {
            if (this.clause_taken[n]) continue;
            Clause clause = this.cnf.clauses[n];
            if (n3 > clause.curr) {
                n2 = 0;
                n3 = clause.curr;
            }
            if (n3 != clause.curr) continue;
            this.clause_list[n2++] = n;
        }
        n = this.choose_most_used(this.clause_list, n2);
        this.clause_taken[n] = true;
        return this.cnf.clauses[n];
    }

    private int choose_most_used(int[] nArray, int n) {
        double d = 0.0;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Clause clause = this.cnf.clauses[nArray[i]];
            double d2 = (double)this.count_allocation(clause) / (double)clause.curr;
            if (d < d2) {
                n2 = 0;
                d = d2;
            }
            if (d2 != d) continue;
            this.extra_list[n2++] = nArray[i];
        }
        return this.extra_list[(int)(Math.random() * (double)n2)];
    }

    private int choose_least_new(int[] nArray, int n) {
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            Clause clause = this.cnf.clauses[nArray[i]];
            int n4 = clause.curr - this.count_allocation(clause);
            if (n2 > n4) {
                n3 = 0;
                n2 = n4;
            }
            if (n2 != n4) continue;
            this.extra_list[n3++] = nArray[i];
        }
        return this.extra_list[(int)(Math.random() * (double)n3)];
    }

    private int count_allocation(Clause clause) {
        int n = 0;
        for (int i = 0; i < clause.curr; ++i) {
            if (clause.lits[i].bdd == -1) continue;
            ++n;
        }
        return n;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Need DIMACS file as argument");
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    System.out.print("Solving " + stringArray[i] + "\t\t");
                    DimacsReader dimacsReader = new DimacsReader(stringArray[i], true);
                    BDDSolver2 bDDSolver2 = new BDDSolver2(false);
                    bDDSolver2.setFormula(dimacsReader.getFormula());
                    dimacsReader = null;
                    bDDSolver2.solve();
                    bDDSolver2.cleanup();
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

