/*
 * Decompiled with CFR 0.152.
 */
package bits;

import bits.BitExclusiveSelector;
import bits.Conjunction;
import bits.IBooleanVariable;
import bits.IProblem;
import bits.Problem;
import bits.exceptions.BitArrayPartitionException;
import java.util.ArrayList;

public class BitArrayPartition
extends Problem
implements IProblem {
    public BitArrayPartition(IBooleanVariable[][] partition) throws Exception {
        if (partition == null) {
            throw new BitArrayPartitionException("A null partition was passed to constructor.");
        }
        int partitions = partition.length;
        if (partitions == 0) {
            throw new BitArrayPartitionException("A partition of zerolength was passed to constructor.");
        }
        if (partition[0] == null) {
            throw new BitArrayPartitionException("A partition with partition[0]==null was passed to constructor.");
        }
        int bits = partition[0].length;
        ArrayList[] bitArrayList = new ArrayList[bits];
        IProblem[] p = new IProblem[bits];
        int j = 0;
        while (j < bits) {
            bitArrayList[j] = new ArrayList();
            int i = 0;
            while (i < partitions) {
                bitArrayList[j].add(partition[i][j]);
                ++i;
            }
            p[j] = new BitExclusiveSelector(bitArrayList[j]);
            ++j;
        }
        Conjunction problem = new Conjunction(p);
        this.setClauses(problem.getClauses());
    }
}

