/*
 * JgclGeometry  JunGeometry  JunOpenGL3dObject ւ
 * ϊs߂̃NX
 *
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 *
 * $Id: JudanTransform.java,v 1.6 2000/04/28 07:37:55 shikano Exp $
 */
package jp.co.sra.judan;

import sra.jun.geometry.abstracts.*;
import sra.jun.geometry.basic.*;
import sra.jun.geometry.curves.*;
import sra.jun.geometry.surfaces.*;
import sra.jun.opengl.objects.*;

import java.awt.Color;
import java.util.*;

import jp.go.ipa.jgcl.*;
import jp.co.sra.judan.*;

/**
 * JgclGeometry  JunGeometry  JunOpenGL3dObject ւ
 * ϊs߂̃NX
 *
 * @version $Revision: 1.6 $, $Date: 2000/04/28 07:37:55 $
 * @author $Author: shikano $
 */

public class JudanTransform {
    /**
     * JgclGeometry ̔z񂩂 JunOpenGL3dCompoundObject ֕ϊ
     *
     * @param JgclGeometry[] Jgcl ̊􉽗vf̔z
     * @return 3D\IuWFNg
     * @see JgclGeometry
     * @see JunOpenGL3dCompoundObject
     */
    public static JunOpenGL3dCompoundObject
        asJunOpenGL3dCompoundObject(JgclGeometry[] geometries) {
        int numberOfGeometry = geometries.length;
        JunOpenGL3dCompoundObject compoundObject =
            new JunOpenGL3dCompoundObject();

        for (int currentGeometry = 0; currentGeometry < numberOfGeometry;
             currentGeometry++){
            compoundObject.add_(asJunOpenGL3dObject
                                (geometries[currentGeometry]));
        }
        return compoundObject;
    }

    /**
     * JgclGeometry  JunOpenGL3dObject ֕ϊ
     *
     * @param JgclGeometry Jgcl ̊􉽗vf
     * @return 3D\IuWFNg
     * @see JgclGeometry
     * @see JunOpenGL3dObject
     */
    public static JunOpenGL3dObject asJunOpenGL3dObject(JgclGeometry geometry) {

        // {͂̕ϊ@\͂ꂼ JgclGeometry IuWFNg
        // Ăׂł邪A(̕炩ɃGKg)
        // JGCL uvɈˑȂ悤ɂ邽߂
        // ŕϊ悤ɂĂB

        try {
	    //
	    // ϊ̂ƂɎgp[^Q
	    //
	    double TOLERANCE = 0.001;
	    double SURFACE_TOLERANCE = 0.01;

	    boolean is2D = geometry.is2D();

            // JgclPoint[23]D
	    if (geometry.isPoint()) {
		if (is2D)
		    return asJunOpenGL3dObject((JgclPoint2D)geometry);
		else
		    return asJunOpenGL3dObject((JgclPoint3D)geometry);
            }	

	    // JgclParametricCurve[23]D
	    if (geometry.isCurve()) {
		if (is2D) {
		    // JgclPolyLine2D
		    if (geometry instanceof JgclPolyline2D) {
			return asJunOpenGL3dObject((JgclPolyline2D)geometry);
		    }
		    // JgclBoundedCurve2D
		    if (geometry instanceof JgclBoundedCurve2D)
			return asJunOpenGL3dObject(((JgclBoundedCurve2D)geometry).toPolyline
						   (new JgclToleranceForDistance(TOLERANCE)));

		    JgclParameterSection psec = JudanSuitableParameterSection.asCurve(geometry);
		    return asJunOpenGL3dObject(((JgclParametricCurve2D)geometry).toPolyline
					       (psec, new JgclToleranceForDistance(TOLERANCE)));

		} else {
		    // JgclPolyLine3D
		    if (geometry instanceof JgclPolyline3D) {
			return asJunOpenGL3dObject((JgclPolyline3D)geometry);
		    }
		    // JgclSurfaceCurve3D
		    if (geometry instanceof JgclSurfaceCurve3D) {
			JgclSurfaceCurve3D surfaceCurve = (JgclSurfaceCurve3D)geometry;
			if (surfaceCurve.masterRepresentation()
			    == JgclPreferredSurfaceCurveRepresentation.CURVE_3D)
			    return asJunOpenGL3dObject(surfaceCurve.curve3d());
			else
			    throw new JgclNotSupported();
		    }
		    if (geometry instanceof JgclBoundedCurve3D)
			return asJunOpenGL3dObject(((JgclBoundedCurve3D)geometry).toPolyline
						   (new JgclToleranceForDistance(TOLERANCE)));
		    JgclParameterSection psec = JudanSuitableParameterSection.asCurve(geometry);
		    return asJunOpenGL3dObject(((JgclParametricCurve3D)geometry).toPolyline
					       (psec, new JgclToleranceForDistance(TOLERANCE)));
		}
	    }

            // JgclParametricSurface3D
            if (geometry.isSurface()) {
		JunOpenGL3dObject obj;
		// JgclCurveBoundedSurface3D
		if (geometry instanceof JgclCurveBoundedSurface3D) {
		    obj = asJunOpenGL3dObject
			(((JgclCurveBoundedSurface3D)geometry).toSetOfTriangles(SURFACE_TOLERANCE,
										TOLERANCE));
		}
		// JgclBoundedSurface3D
		else if (geometry instanceof JgclBoundedSurface3D)
		    obj = asJunOpenGL3dObject
			(((JgclBoundedSurface3D)geometry).toMesh
			 (new JgclToleranceForDistance(SURFACE_TOLERANCE)).toSetOfTriangles());
		else {
		    JgclParameterSection[] psecs = JudanSuitableParameterSection.asSurface(geometry);
		    obj = asJunOpenGL3dObject
			(((JgclParametricSurface3D)geometry).toMesh
			 (psecs[0], psecs[1],
			  new JgclToleranceForDistance(SURFACE_TOLERANCE)).toSetOfTriangles());
		}
		obj.paint_(Color.blue);
		return obj;
	    }

	    // Other Geometry is not supported.
	    System.out.println(geometry.getClass().getName());
	    throw new JgclFatal();
        }
        catch (JgclParameterOutOfRange e){
            throw new JgclFatal();
        }
    }

    /**
     * JgclSetOfTriangles3D  JunOpenGL3dObject֕ϊ
     *
     * @param JgclSetofTriangles3D Jgcl ̊􉽗vf(3̎Op`W\)
     * @return 3D\IuWFNg
     * @see JgclSetOfTriangles3D
     * @see JunOpenGL3dObject
     */
    public static JunOpenGL3dObject asJunOpenGL3dObject(JgclSetOfTriangles3D triangles) {
	Enumeration enum = triangles.faceElements();
	int numberOfFace = 0;
	Vector glVector = new Vector();
	JunPolygon polygon;

	while (enum.hasMoreElements()) {
	    JgclSetOfTriangles3D.Face face =
		(JgclSetOfTriangles3D.Face)enum.nextElement();
	    JgclSetOfTriangles3D.Vertex[] vertex =
		face.getVerticesInCCW();
	    Jun3dPoint junPoint;
	    Vector vector = new Vector();

	    for (int i = 0; i < vertex.length; i++) {
		JgclPoint3D point = vertex[i].getCoordinates();
		vector.addElement(asJunGeometry(point));
	    }
	    if ((polygon = JunPolygon.Vertexes_(vector)) != null)
		glVector.addElement(polygon.asJunOpenGL3dObject());
	}
	JunOpenGL3dCompoundObject openGLObj = new JunOpenGL3dCompoundObject();
	openGLObj.addAll_(glVector);

	return openGLObj;
    }

    /**
     * JgclPoint2D  JunOpenGL3dObject֕ϊ
     *
     * @param JgclPoint2D Jgcl ̊􉽗vf(Q̓_\)
     * @return 3D\IuWFNg
     * @see JgclPoint2D
     * @see JunOpenGL3dObject
     */
    public static JunOpenGL3dObject asJunOpenGL3dObject(JgclPoint2D point2d) {
	JunOpenGL3dVertex vertex = new JunOpenGL3dVertex(asJun3dPoint(point2d));
	vertex.size_(5);
        return vertex;
    }

    /**
     * JgclPoint3D  JunOpenGL3dObject֕ϊ
     *
     * @param JgclPoint3D Jgcl ̊􉽗vf(Q̓_\)
     * @return 3D\IuWFNg
     * @see JgclPoint3D
     * @see JunOpenGL3dObject
     */
    public static JunOpenGL3dObject asJunOpenGL3dObject(JgclPoint3D point3d) {
	JunOpenGL3dVertex vertex = new JunOpenGL3dVertex(asJunGeometry(point3d));
	vertex.size_(5);
        return vertex;
    }

    /**
     * JgclLine3D  JunOpenGL3dObject֕ϊ
     *
     * @param JgclLine3D Jgcl ̊􉽗vf(R̒\)
     * @return 3D\IuWFNg
     * @see JgclLine3D
     * @see JunOpenGL3dObject
     */
    public static JunOpenGL3dObject asJunOpenGL3dObject(JgclLine3D line3d) {
	JunOpenGL3dObject junOpenGL3dObject = asJunGeometry(line3d).asJunOpenGL3dObject();
	return junOpenGL3dObject;
    }

    /**
     * JgclPolyline3D  JunOpenGL3dObject ֕ϊ
     *
     * @param JgclPolyline3D Jgcl ̊􉽗vf(Q̒\)
     * @return 3D\IuWFNg
     * @see JgclPolyline3D
     * @see JunOpenGL3dObject
     */
    public static JunOpenGL3dObject asJunOpenGL3dObject(JgclPolyline3D polyline3d) {
        JgclPoint3D[] point3dArray = polyline3d.points();
        int numberOfPoint = point3dArray.length;
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[numberOfPoint];

        for(int i = 0; i < numberOfPoint; i++) {
            jun3dPointArray[i] = asJunGeometry(point3dArray[i]);
        }

	if (polyline3d.closed())
	    return new JunOpenGL3dPolylineLoop(jun3dPointArray);
	else 
	    return new JunOpenGL3dPolyline(jun3dPointArray);
    }

    /**
     * JgclPolyline2D  JunOpenGL3dObject ֕ϊ
     *
     * @param JgclPolyline2D Jgcl ̊􉽗vf(R̒\)
     * @return 2D\IuWFNg
     * @see JgclPolyline3D
     * @see JunOpenGL3dObject
     */
    public static JunOpenGL3dObject asJunOpenGL3dObject(JgclPolyline2D polyline2d) {
        JgclPoint2D[] point2dArray = polyline2d.points();
        int numberOfPoint = point2dArray.length;
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[numberOfPoint];
        for(int i = 0; i < numberOfPoint; i++) {
            jun3dPointArray[i] = asJun3dPoint(point2dArray[i]);
        }
	if (polyline2d.closed())
	    return new JunOpenGL3dPolylineLoop(jun3dPointArray);
	else 
	    return new JunOpenGL3dPolyline(jun3dPointArray);
    }

    /**
     * JgclLine2D  JunOpenGL3dObject ֕ϊ
     *
     * @param JgclLine2D Jgcl ̊􉽗vf(Q̒\)
     * @return 3D\IuWFNg
     * @see JgclLine2D
     * @see JunOpenGL3dObject
     */
    public static JunOpenGL3dObject asJunOpenGL3dObject(JgclLine2D line2d) {
	JunOpenGL3dObject junOpenGL3dObject = asJun3dLine(line2d).asJunOpenGL3dObject();
	return junOpenGL3dObject;
    }

    /**
     * JgclLine2D  Jun3dLine ֕ϊ(\̂)
     *
     * @param JgclLine2D Jgcl ̊􉽗vf(Q̒\)
     * @return ̊􉽗vf(R̒\)
     * @see JgclLine2D
     * @see JgclPoint2D
     * @see JgclVector2D
     * @see JgclCartesianPoint2D
     * @see Jun3dPoint
     * @see Jun3dLine
     */
    public static Jun3dLine asJun3dLine(JgclLine2D line2d) {
        JgclPoint2D point2d = line2d.pnt();
        JgclVector2D vector2d = line2d.dir();
        JgclPoint2D newPoint2d = point2d.add(vector2d);
        Jun3dPoint jun3dPoint1 = asJun3dPoint(point2d);
        Jun3dPoint jun3dPoint2 = asJun3dPoint(newPoint2d);
	
        return new Jun3dLine(jun3dPoint1, jun3dPoint2);
    }

    /**
     * JgclLine3D  Jun3dLine ֕ϊ
     *
     * @param JgclLine2D Jgcl ̊􉽗vf(R̒\)
     * @return ̊􉽗vf(R̒\)
     * @see JgclLine3D
     * @see JgclPoint3D
     * @see JgclVector3D
     * @see JgclCartesianPoint3D
     * @see Jun3dLine
     */
    public static Jun3dLine asJunGeometry(JgclLine3D line3d) {
        JgclPoint3D point3d = line3d.pnt();
        JgclVector3D vector3d = line3d.dir();
        JgclPoint3D newPoint3d = point3d.add(vector3d);
        Jun3dPoint junPoint1 = asJunGeometry(point3d);
        Jun3dPoint junPoint2 = asJunGeometry(newPoint3d);

        return new Jun3dLine(junPoint1, junPoint2);
    }

    /**
     * JgclPoint3D  Jun3dPoint ֕ϊ
     *
     * @param JgclLine2D Jgcl ̊􉽗vf(R̓_\)
     * @return ̊􉽗vf(R̓_\)
     * @see JgclPoint3D
     * @see Jun3dPoint
     */
    public static Jun3dPoint asJunGeometry(JgclPoint3D point3d) {
        return new Jun3dPoint(point3d.x(), point3d.y(), point3d.z());
    }

    /**
     * JgclPoint2D  Jun3dPoint ֕ϊ
     * (e Jgcl IuWFNg 2D  3D ϊ̂)
     *
     * @param JgclLine2D Jgcl ̊􉽗vf(Q̓_\)
     * @return ̊􉽗vf(R̓_\)
     * @see JgclPoint2D
     * @see Jun3dPoint
     */
    public static Jun3dPoint asJun3dPoint(JgclPoint2D point2d) {
        return new Jun3dPoint(point2d.x(), point2d.y(), 0);
    }
}
