/*
 * JGCL $BF0:n3NG'$N$?$a$N%F%9%H4D6-(B($BJ,;6<BAu<B83MQ(B RMI $B%5!<%P<BAu(B)
 *
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 *
 * $Id: JudanRMIServerImpl.java,v 1.8 2000/04/27 08:08:30 ryo Exp $
 */
package jp.co.sra.judan;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.rmi.*;
import java.rmi.server.UnicastRemoteObject;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jp.go.ipa.jgcl.*;

/**
 * JGCL $BF0:n3NG'$N$?$a$N%F%9%H4D6-(B($BJ,;6<BAu<B83MQ(B RMI $B%5!<%P<BAu(B)
 *
 * @version $Revision: 1.8 $
 * @author $Author: ryo $
 */
public class JudanRMIServerImpl extends UnicastRemoteObject implements JudanRMIServer {
    /**
     * $B%Q!<%6(B
     */
    private JudanParser parser;

    /**
     * $B2r@O8e$N>pJs(B
     */
    private JudanParsedInfo pi;

    /**
     * $B4v2?%*%V%8%'%/%H$,3JG<$5$l$k%O%C%7%e%F!<%V%k(B
     */
    private Hashtable table;

    /**
     * $B4v2?%*%V%8%'%/%H$NL>A0$N%j%9%H(B
     */
    private Vector nameList;

    /**
     * verbose mode flag
     */
    private static boolean verbose = false;

    /**
     * $B%3%s%9%H%i%/%?(B
     */
    public JudanRMIServerImpl() throws RemoteException {
	super();
    }

    /**
     * $BM?$($i$l$?0z?t$N%U%!%$%k$r2r@O$7$F!"7k2L$rJV$9!#(B
     *
     * @param str  $B2r@O$9$k%U%!%$%k$NCf?H(B
     * @return     $B2r@O7k2L(B($B4v2?%*%V%8%'%/%H$NL>A0$N=89g(B)
     */
    public Vector parse(String str) {
	if (verbose)
	    System.out.println("JudanRMIServerImpl.parse(String) method invoked...");

	try {
    	    Reader reader = new StringReader(str);
	    if (parser != null) {
  		parser.ReInit();
  		parser.ReInit(reader);
	    }
	    else {
  		parser = new JudanParser(reader);
	    }

	    pi = parser.jgclFile();
	    table = parser.getEntityTable();
	    nameList = parser.getNameList();
	}
	catch (ParseException e) {
	    System.out.println("Parse Error");
	}
	return nameList;
    }

    /**
     * $B0z?t$K$h$jM?$($i$l$?L>A0$N4v2?%*%V%8%'%/%H$,6J@~$+$I$&$+$rJV$9(B
     *
     * @param name $B4v2?%*%V%8%'%/%H$NL>A0(B
     * @return     $B6J@~$+$I$&$+(B
     */
    public boolean isCurve(String name) {
	if (verbose)
	    System.out.println("JudanRMIServerImpl.isCurve(String) method invoked...");
	return ((JgclGeometry)getGeometry(name)).isCurve();
    }

    /**
     * $B0z?t$K$h$jM?$($i$l$?L>A0$N4v2?%*%V%8%'%/%H$,6JLL$+$I$&$+$rJV$9(B
     *
     * @param name $B4v2?%*%V%8%'%/%H$NL>A0(B
     * @return     $B6JLL$+$I$&$+(B
     */
    public boolean isSurface(String name) {
	if (verbose)
	    System.out.println("JudanRMIServerImpl.isSurface(String) method invoked...");
	return ((JgclGeometry)getGeometry(name)).isSurface();
    }

    /**
     * $B0z?t$K$h$jM?$($i$l$?L>A0$N4v2?%*%V%8%'%/%H$rJV$9(B
     *
     * @param name $B4v2?%*%V%8%'%/%H$NL>A0(B
     * @return     $BL>A0$KBP1~$9$k4v2?%*%V%8%'%/%H(B
     */
    public JgclGeometry getGeometry(String name) {
	if (verbose)
	    System.out.println("JudanRMIServerImpl.getGeometry(String) method invoked...");
	return (JgclGeometry)table.get(name);
    }

    /**
     * $B2r@O$5$l$?4v2?%*%V%8%'%/%H$NL>A0$N=89g$rJV$9(B
     *
     * @return     $B4v2?%*%V%8%'%/%H$NL>A0$N=89g(B
     */
    public Vector getNameList() {
	if (verbose)
	    System.out.println("JudanRMIServerImpl.getNameList() method invoked...");
	return nameList;
    }

    /**
     * $B2r@O:Q$_$+$I$&$+$rJV$9(B
     *
     * @return     $B$9$G$K2r@O:Q$_%*%V%8%'%/%H$,B8:_$9$k$+$I$&$+(B
     */
    public boolean isParsed() {
	if (verbose)
	    System.out.println("JudanRMIServerImpl.isParsed() method invoked...");
	return (nameList != null);
    }

    /**
     * $BL>A0$G;XDj$5$l$?4v2?%*%V%8%'%/%H$rI>2A$9$k(B
     *
     * @param name  $B4v2?%*%V%8%'%/%H$NL>A0(B
     * @param param $BI>2A$9$k;~$N%Q%i%a!<%?(B
     * @return      $BI>2A7k2L(B
     */
    public JgclGeometry evaluate(String name, double[] params) {
	if (verbose)
	    System.out.println("JudanRMIServerImpl.evaluate(String, double[]) method invoked...");
	JgclGeometry geom = (JgclGeometry)table.get(name);
	JgclGeometry result;

	if (geom instanceof jp.go.ipa.jgcl.JgclParametricCurve2D) {
	    result = ((JgclParametricCurve2D)geom).coordinates(params[0]);
	}
	else if (geom instanceof jp.go.ipa.jgcl.JgclParametricCurve3D) {
	    result = ((JgclParametricCurve3D)geom).coordinates(params[0]);
	}
	else if (geom instanceof jp.go.ipa.jgcl.JgclParametricSurface3D) {
	    result = ((JgclParametricSurface3D)geom).coordinates(params[0], params[1]);
	}
	else {
	    throw new JgclFatal();
	}
	if (verbose)
	    result.output(System.out);
	return result;
    }

    /**
     * $BL>A0$G;XDj$5$l$?4v2?%*%V%8%'%/%H$NFC0[E@$rF@$k(B
     *
     * @param name  $B4v2?%*%V%8%'%/%H$NL>A0(B
     * @return      $BFC0[E@(B
     */
    public JgclGeometry[] singular(String name) {
	if (verbose)
	System.out.println("JudanRMIServerImpl.singular(String) method invoked...");
	JgclGeometry geom = (JgclGeometry)table.get(name);
	JgclGeometry[] result;
	try {
	    if (geom instanceof jp.go.ipa.jgcl.JgclParametricCurve2D)
		result = ((JgclParametricCurve2D)geom).singular();
	    else if (geom instanceof jp.go.ipa.jgcl.JgclParametricCurve2D)
		result = ((JgclParametricCurve3D)geom).singular();
	    else
		throw new JgclFatal();
	}
	catch (JgclIndefiniteSolution ex) {
	    System.out.println("IndefiniteSolution is occured");
	    throw new JgclFatal();
	}

	if (verbose) {
	    for (int i = 0; i < result.length; i++) {
		result[i].output(System.out);
	    }
	}
	return result;
    }

    /**
     * $BL>A0$G;XDj$5$l$?4v2?%*%V%8%'%/%H$NJQ6JE@$rF@$k(B
     *
     * @param name  $B4v2?%*%V%8%'%/%H$NL>A0(B
     * @return      $BJQ6JE@(B
     */
    public JgclGeometry[] inflexion(String name) {
	if (verbose)
	System.out.println("JudanRMIServerImpl.inflexion(String) method invoked...");
	JgclGeometry geom = (JgclGeometry)table.get(name);
	JgclGeometry[] result;
	try {
	    if (geom instanceof jp.go.ipa.jgcl.JgclParametricCurve2D)
		result = ((JgclParametricCurve2D)geom).inflexion();
	    else if (geom instanceof jp.go.ipa.jgcl.JgclParametricCurve2D)
		result = ((JgclParametricCurve3D)geom).inflexion();
	    else
		throw new JgclFatal();
	}
	catch (JgclIndefiniteSolution ex) {
	    System.out.println("IndefiniteSolution is occured");
	    throw new JgclFatal();
	}

	if (verbose) {
	    for (int i = 0; i < result.length; i++) {
		result[i].output(System.out);
	    }
	}
	return result;
    }

    /**
     * $BL>A0$G;XDj$5$l$?4v2?%*%V%8%'%/%H$N8rE@!"8r@~$r5a$a$k(B
     *
     * @param name $B4v2?%*%V%8%'%/%H$NL>A0(B
     * @return     $B8rE@!"8r@~$r$H$C$?7k2L(B
     */
    public JgclGeometry[] intersect(String[] name) {
	if (verbose)
	System.out.println("JudanRMIServerImpl.intersect(String[]) method invoked...");
	JgclGeometry[] geom = new JgclGeometry[name.length];
	JgclGeometry[] result;
	for (int i = 0; i < name.length; i++) {
	    geom[i] = (JgclGeometry)table.get(name[i]);
	}

  	if (geom[0] instanceof jp.go.ipa.jgcl.JgclParametricCurve2D) {
	    JgclParametricCurve2D curve1 = (JgclParametricCurve2D)geom[0];
	    if (geom[1] instanceof jp.go.ipa.jgcl.JgclParametricCurve2D) {
		JgclParametricCurve2D curve2 = (JgclParametricCurve2D)geom[1];
		try {
		    result = curve1.intersect(curve2);
		}
		catch (JgclIndefiniteSolution ex) {
		    JgclGeometry[] obj = {ex.suitable()};
		    result = obj;
		}
	    }
	    else {
		System.out.println("not a suitable selection");
		throw new JgclFatal();
	    }
	}
	else if (geom[0] instanceof jp.go.ipa.jgcl.JgclParametricCurve3D) {
	    JgclParametricCurve3D curve1 = (JgclParametricCurve3D)geom[0];
	    if (geom[1] instanceof jp.go.ipa.jgcl.JgclParametricCurve3D) {
		JgclParametricCurve3D curve2 = (JgclParametricCurve3D)geom[1];
		try {
		    result = curve1.intersect(curve2);
		}
		catch (JgclIndefiniteSolution ex) {
		    JgclGeometry[] obj = {ex.suitable()};
		    result = obj;
		}
	    }
	    else if (geom[1] instanceof jp.go.ipa.jgcl.JgclParametricSurface3D) {
		JgclParametricSurface3D surface2 = (JgclParametricSurface3D)geom[1];
		try {
		    result = curve1.intersect(surface2);
		}
		catch (JgclIndefiniteSolution ex) {
		    JgclGeometry[] obj = {ex.suitable()};
		    result = obj;
		}
	    }
	    else {
		System.out.println("not a suitable selection");
		throw new JgclFatal();
	    }
	}
	else if (geom[0] instanceof jp.go.ipa.jgcl.JgclParametricSurface3D) {
	    JgclParametricSurface3D surface1 = (JgclParametricSurface3D)geom[0];
	    if (geom[1] instanceof jp.go.ipa.jgcl.JgclParametricCurve3D) {
		JgclParametricCurve3D curve2 = (JgclParametricCurve3D)geom[1];
		try {
		    result = surface1.intersect(curve2);
		}
		catch (JgclIndefiniteSolution ex) {
		    JgclGeometry[] obj = {ex.suitable()};
		    result = obj;
		}
	    }
	    else if (geom[1] instanceof jp.go.ipa.jgcl.JgclParametricSurface3D) {
		JgclParametricSurface3D surface2 = (JgclParametricSurface3D)geom[1];
		try {
		    JgclSurfaceSurfaceInterference3D[] intf = 
			surface1.intersect(surface2);

		    JgclIntersectionCurve3D[] curve = new JgclIntersectionCurve3D[intf.length];
		    for (int i = 0; i < intf.length; i++) {
			curve[i] = intf[i].toIntersectionCurve();
		    }
		    result = curve;
		}
		catch (JgclIndefiniteSolution ex) {
		    JgclGeometry[] obj = {ex.suitable()};
		    result = obj;
		}
	    }
	    else {
		System.out.println("not a suitable selection");
		throw new JgclFatal();
	    }
	}
	else {
	    System.out.println("not a suitable selection");
	    throw new JgclFatal();
	}

	if (verbose) {
	    for (int i = 0; i < result.length; i++) {
		result[i].output(System.out);
	    }
	}
	return result;
    }

    /**
     * $BL>A0$G;XDj$5$l$?4v2?%*%V%8%'%/%HEj1F$r5a$a$k(B
     *
     * @param name $B4v2?%*%V%8%'%/%H$NL>A0(B
     * @return     $BEj1F7k2L(B
     */
    public Vector projectFrom(String[] name) {
	if (verbose)
	    System.out.println("JudanRMIServerImpl.projectFrom(String[]) method invoked...");
	JgclGeometry[] geom = new JgclGeometry[name.length];
	for (int i = 0; i < name.length; i++) {
	    geom[i] = (JgclGeometry)table.get(name[i]);
	}

	Vector result = new Vector();
	JgclGeometry[] prjResult;

	if (((geom[0] instanceof jp.go.ipa.jgcl.JgclParametricCurve2D) &&
	     (geom[1] instanceof jp.go.ipa.jgcl.JgclPoint2D)) ||
	    ((geom[1] instanceof jp.go.ipa.jgcl.JgclParametricCurve2D) &&
	     (geom[0] instanceof jp.go.ipa.jgcl.JgclPoint2D))) {
	    JgclParametricCurve2D curve;
	    JgclPoint2D point;
	    if (geom[0] instanceof jp.go.ipa.jgcl.JgclParametricCurve2D) {
		curve = (JgclParametricCurve2D)geom[0];
		point = (JgclPoint2D)geom[1];
	    } else {
		curve = (JgclParametricCurve2D)geom[1];
		point = (JgclPoint2D)geom[0];
	    }
	    try {
		prjResult = curve.projectFrom(point);
		result.addElement(point);
	    } catch (JgclIndefiniteSolution excp) {
		System.out.println("Indefinite solution");
		JgclGeometry[] obj = {excp.suitable()};
		prjResult = obj;
		result.addElement(point);
	    }
	}
	else if (((geom[0] instanceof jp.go.ipa.jgcl.JgclParametricCurve3D) &&
		  (geom[1] instanceof jp.go.ipa.jgcl.JgclPoint3D)) ||
		 ((geom[1] instanceof jp.go.ipa.jgcl.JgclParametricCurve3D) &&
		  (geom[0] instanceof jp.go.ipa.jgcl.JgclPoint3D))) {
	    JgclParametricCurve3D curve;
	    JgclPoint3D point;
	    if (geom[0] instanceof jp.go.ipa.jgcl.JgclParametricCurve3D) {
		curve = (JgclParametricCurve3D)geom[0];
		point = (JgclPoint3D)geom[1];
	    } else {
		curve = (JgclParametricCurve3D)geom[1];
		point = (JgclPoint3D)geom[0];
	    }
	    try {
		prjResult = curve.projectFrom(point);
		result.addElement(point);
	    } catch (JgclIndefiniteSolution excp) {
		System.out.println("Indefinite solution");
		JgclGeometry[] obj = {excp.suitable()};
		prjResult = obj;
		result.addElement(point);
	    }
	}
	else if (((geom[0] instanceof jp.go.ipa.jgcl.JgclParametricSurface3D) &&
		  (geom[1] instanceof jp.go.ipa.jgcl.JgclPoint3D)) ||
		 ((geom[1] instanceof jp.go.ipa.jgcl.JgclParametricSurface3D) &&
		  (geom[0] instanceof jp.go.ipa.jgcl.JgclPoint3D))) {
	    JgclParametricSurface3D surface;
	    JgclPoint3D point;
	    if (geom[0] instanceof jp.go.ipa.jgcl.JgclParametricSurface) {
		surface = (JgclParametricSurface3D)geom[0];
		point = (JgclPoint3D)geom[1];
	    } else {
		surface = (JgclParametricSurface3D)geom[1];
		point = (JgclPoint3D)geom[0];
	    }
	    try {
		prjResult = surface.projectFrom(point);
		result.addElement(point);
	    }
	    catch (JgclIndefiniteSolution excp) {
		System.out.println("Indefinite solution");
		JgclGeometry[] obj = {excp.suitable()};
		prjResult = obj;
		result.addElement(point);
	    }
	}
	else {
	    System.out.println("not a suitable selection");
	    throw new JgclFatal();
	}

	if (verbose)
	    for (int i = 0; i < prjResult.length; i++) {
		prjResult[i].output(System.out);
	    }

	result.addElement(prjResult);
	return result;
    }

    /**
     * $BL>A0$G;XDj$5$l$?4v2?%*%V%8%'%/%H$N%U%#%l%C%H$r5a$a$k(B
     *
     * @param name  $B4v2?%*%V%8%'%/%H$NL>A0(B
     * @param param $B%U%#%l%C%H$r5a$a$k$H$-$N%Q%i%a!<%?(B
     * @return      $B%U%#%l%C%H7k2L(B
     */
    public JgclGeometry[] fillet(String[] name, double param) {
	if (verbose)
	System.out.println("JudanRMIServerImpl.fillet(String[], double) method invoked...");
	JgclGeometry[] geom = new JgclGeometry[2];
	JgclGeometry[] result;

	for (int i = 0; i < 2; i++) {
	    geom[i] = (JgclGeometry)(table.get(name[i]));
	}
	// 2D$B6J@~$N>l9g(B
	if ((geom[0] instanceof jp.go.ipa.jgcl.JgclParametricCurve2D) &&
	    (geom[1] instanceof jp.go.ipa.jgcl.JgclParametricCurve2D)) {

		JgclParameterSection pint1 = JudanSuitableParameterSection.asCurve(geom[0]);
		int side1 = JgclWhichSide.BOTH;
		JgclParameterSection pint2 = JudanSuitableParameterSection.asCurve(geom[1]);
		int side2 = JgclWhichSide.BOTH;
		double radius = param;

		try {
		    result = ((JgclParametricCurve2D)geom[0]).
			fillet(pint1, side1, (JgclParametricCurve2D)geom[1],
			       pint2, side2, radius);
		}
		catch (JgclIndefiniteSolution ex) {
		    System.out.println(ex.getMessage());
		    throw new JgclFatal();
		}
	    }
	// 3D$B6JLL$N>l9g(B
	else if (geom[0] instanceof jp.go.ipa.jgcl.JgclParametricSurface3D) {
	    JgclParameterSection[] secs = JudanSuitableParameterSection.asSurface(geom[0]);
	    JgclParameterSection uSect1 = secs[0];
	    JgclParameterSection vSect1 = secs[1];
	    int side1 = JgclWhichSide.BOTH;

	    secs = JudanSuitableParameterSection.asSurface(geom[1]);
	    JgclParameterSection uSect2 = secs[0];
	    JgclParameterSection vSect2  = secs[1];
	    int side2 = JgclWhichSide.BOTH;
	    double radius = param;

	    try {
		result = ((JgclParametricSurface3D)geom[0]).
		    fillet(uSect1, vSect2, side1,
			   (JgclParametricSurface3D)geom[1], uSect2, vSect2,
			   side2, radius);
	    }
	    catch (JgclIndefiniteSolution ex) {
		System.out.println(ex.getMessage());
		throw new JgclFatal();
	    }
	}
	// $B6JLL!"6J@~0J30(B
	else {
	    System.out.println("not a suitable selection");
	    throw new JgclFatal();
	}

	if (verbose) {
	    for (int i = 0; i < result.length; i++) {
		result[i].output(System.out);
	    }
	}
	return result;
    }

    /**
     * $BL>A0$G;XDj$5$l$?4v2?%*%V%8%'%/%H$N%*%U%;%C%H$r5a$a$k(B
     *
     * @param name  $B4v2?%*%V%8%'%/%H$NL>A0(B
     * @param param $B%*%U%;%C%H$r5a$a$k$H$-$N%Q%i%a!<%?(B
     * @return      $B%*%U%;%C%H7k2L(B
     */
    public JgclGeometry offset(String name, double param) {
	if (verbose) {
	    System.out.println("JudanRMIServerImpl.offset(String, double) method invoked...");
	}
	JgclGeometry geom = (JgclGeometry)(table.get(name));
	JgclGeometry result;

	// 2D$B6J@~$N>l9g(B
	if (geom instanceof jp.go.ipa.jgcl.JgclParametricCurve2D) {
	    JgclParameterSection pint = JudanSuitableParameterSection.asCurve(geom);
	    int side = JgclWhichSide.BOTH;
	    JgclToleranceForDistance tol = new JgclToleranceForDistance(0.01);
	    result = ((JgclParametricCurve2D)geom).
		offsetByBsplineCurve(pint, param, side, tol);
	}
	// $B6JLL$N>l9g(B
	else if (geom instanceof jp.go.ipa.jgcl.JgclParametricSurface3D) {
	    JgclParameterSection[] secs = JudanSuitableParameterSection.asSurface(geom);
	    int side = JgclWhichSide.FRONT;
	    JgclToleranceForDistance tol = new JgclToleranceForDistance(0.01);
	    result = ((JgclParametricSurface3D)geom).
		offsetByBsplineSurface(secs[0], secs[1], param, side, tol);
	}
	// $B6JLL!"6J@~0J30(B
	else {
	    System.out.println("not a suitable selection");
	    throw new JgclFatal();
	}
	if (verbose)
	    result.output(System.out);
	return result;
    }

    /**
     * $BL>A0$G;XDj$5$l$?4v2?%*%V%8%'%/%H$N%?%V%7%kLL$r5a$a$k(B
     *
     * @param name  $B4v2?%*%V%8%'%/%H$NL>A0(B
     * @param param $B%?%V%7%kLL$r5a$a$k$H$-$N%Q%i%a!<%?(B
     * @return      $B%?%V%7%kLL7k2L(B
     */
    public JgclGeometry tabcylSurface(String name1, String name2) {
	if (verbose)
	    System.out.println("JudanRMIServerImpl.tabcyl(String, String) method invoked...");
	JgclGeometry geom1 = (JgclGeometry)(table.get(name1));
	JgclGeometry geom2 = (JgclGeometry)(table.get(name2));
	JgclBsplineSurface3D result;

	// 3D$B6J@~$N>l9g(B
	if ((geom1 instanceof jp.go.ipa.jgcl.JgclBsplineCurve3D) &&
	    (geom2 instanceof jp.go.ipa.jgcl.JgclBsplineCurve3D)) {
	    result = ((JgclBsplineCurve3D)geom1).tabcylSurface((JgclBsplineCurve3D)geom2);
	}
	// 3D$B6J@~0J30(B
	else {
	    System.out.println("not a suitable selection");
	    throw new JgclFatal();
	}

	if (verbose)
	    result.output(System.out);
	return result;
    }

    /**
     * $BL>A0$G;XDj$5$l$?4v2?%*%V%8%'%/%H$N%*%U%HLL$r5a$a$k(B
     *
     * @param name  $B4v2?%*%V%8%'%/%H$NL>A0(B
     * @param param $B%m%U%HLL$r5a$a$k$H$-$N%Q%i%a!<%?(B
     * @return      $B%m%U%HLL7k2L(B
     */
    public JgclGeometry loftSurface(String name1, String name2, double param) {
	if (verbose)
	    System.out.println("JudanRMIServerImpl.loft(String, String, double) method invoked...");
	JgclGeometry geom1 = (JgclGeometry)(table.get(name1));
	JgclGeometry geom2 = (JgclGeometry)(table.get(name2));
	JgclBsplineSurface3D result;

	// 3D$B6J@~$N>l9g(B
	if ((geom1 instanceof jp.go.ipa.jgcl.JgclBsplineCurve3D) &&
	    (geom2 instanceof jp.go.ipa.jgcl.JgclVector3D)) {
	    result = ((JgclBsplineCurve3D)geom1).loftSurface((JgclVector3D)geom2, param);
	}
	else if ((geom1 instanceof jp.go.ipa.jgcl.JgclVector3D) &&
		 (geom2 instanceof jp.go.ipa.jgcl.JgclBsplineCurve3D)) {
	    result = ((JgclBsplineCurve3D)geom2).loftSurface((JgclVector3D)geom1, param);
	}
	// 3D$B6J@~0J30(B
	else {
	    System.out.println("not a suitable selection");
	    throw new JgclFatal();
	}

	if (verbose)
	    result.output(System.out);
	return result;
    }

    public static void main(String[] args) {
	// Create and install a security manager
	System.setSecurityManager(new RMISecurityManager());

	if (args.length > 2) {
	    System.out.println("Invalid argument");
	}

	try {
	    JudanRMIServer server = new JudanRMIServerImpl();
	    String host;
	    if (args.length == 2) {
		if (args[0].equals("-v")) {
		    host = args[1];
		    verbose = true;
		}
		else {
		    System.out.println("Invalid argument");
		    return;
		}
	    }
	    else if (args.length == 1) {
		if (args[0].equals("-v")) {
		    host = "localhost";
		    verbose = true;
		}
		else
		    host = args[0];
	    }
	    else {
		host = "localhost";
	    }
	    Naming.rebind("rmi://" + host + "/JudanRMIServer", server);
	    System.out.println("Judan Server bound in Registry");
	}
	catch (Exception e) {
	    System.out.println("Judan Server Error: " + e.getMessage());
	}
    }
}
