/*
 * Java Geometry Handling Library Test Environment
 * Parsed Information from input
 *
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 *
 * $Id: JudanParsedInfo.java,v 1.4 2000/08/15 09:36:09 shikano Exp $
 */
package jp.co.sra.judan;

import java.lang.*;
import java.util.*;
import jp.go.ipa.jgcl.*;
import jp.co.sra.judan.*;

/**
 * @version $Revision: 1.4 $
 * @author $Author: shikano $
 */

public class JudanParsedInfo extends java.lang.Object {
    /**
     * JgclGeometry IuWFNgɕtꂽȌW
     *
     * @see Vector
     */
    private Vector nameList = new Vector();

    /**
     * JgclGeometry IuWFNg̖OƎ̂
     * ΂ɂĊi[邽߂̃nbVe[u
     *
     * @see Hashtable
     */
    private Hashtable entityTable = new Hashtable();

    /**
     * JgclGeometry IuWFNgȊÕIuWFNg̖OƎ̂
     * ΂ɂĊi[邽߂̃nbVe[u
     *
     * @see Hashtable
     */
    private Hashtable propertyTable = new Hashtable();

    /**
     * JgclGeometry IuWFNgɑ΂鑀(\bh̃`FbN)
     * ̏Wi[邽߂ Vector
     *
     * @see Vector
     */
    private Vector commandTable = new Vector();

    /**
     * RXgN^
     *
     * @param nameList
     * @param propertyTable
     * @param commandTable
     */
    public JudanParsedInfo(Vector nameList,
			  Hashtable entityTable,
                          Hashtable propertyTable,
                          Vector commandTable) {
        this.nameList = nameList;
	this.entityTable = entityTable;
        this.propertyTable = propertyTable;
        this.commandTable = commandTable;
    }

    /**
     * R}h judan \bhIuWFNg𐶐
     *
     * @param command tBA͂ꂽR}h
     * @return        judan \bhIuWFNg
     */
    private JudanMethodWrapper makeMethod(Vector command) {
	// command(0) --- ΏۂƂȂ geometry ̖O
	// command(1) --- ΏۂƂȂ method ̖O
	// command(2...) --- ΏۂƂȂ method ̖̈O

	// ΏۂƂȂJgclGeometry ̏
	// R}h̐擪ɐ}`̖Oi[Ă
	String geometryName = (String)command.elementAt(0);

	// ΏۂƂȂJgclGeometry \bh̏
	// }`̖Opăe[uIuWFNg𓾂
	JgclGeometry geometry =
	    (JgclGeometry)entityTable.get(geometryName);
            
	// ΏۂƂȂ郁\bḧ̏
	int nArgument = command.size() - 2;
	Class[] argClasses = new Class[nArgument];
	Object[] argEntities = new Object[nArgument];
	for (int j = 0; j < nArgument; j++) {
	    String argName = (String)command.elementAt(j+2);
	    Object obj = (Object)propertyTable.get(argName);

	    // propertyTable ݂ȂꍇA
	    // entityTable T
	    if (obj == null) {
		obj = (Object)entityTable.get(argName);
	    }
	    // entityTable ȂꍇA
	    // [UɃG[ʒmāAXLbvB
	    if (obj == null) {
		System.out.println("No such Goemetry associated with " 
				   + argName);
	    }
	    argEntities[j] = obj;
	    argClasses[j] = argEntities[j].getClass();
	}
                    
	// method IuWFNg̐ɂ͒ӂKvŁA
	// ɗ^̌^YołȂƐłȂB
	// TuNX̃IuWFNgɗ^ꍇ́A
	// ~\bh̃IuWFNg𐶐łȂ̂ŁA
	// X[pNX cast KvB
	// (_TƂ?)

	// Ⴆ΁AprojectFrom(JgclPoint2D) ̃IuWFNg𐶐
	// Ƃɂ́AJgclCartesianPoint2D ɗ^Ă
	// łȂ̂ŁAJgclPoint2D  cast ĂKvB

	String methodName = (String)command.elementAt(1);

	return new JudanMethodWrapper(geometry, methodName,
				   argClasses, argEntities);
    }

    /**
     * commandTable Ɋi[ꂽƂɁAꂼsĂB
     *
     * @param isOutputCharacter
     * @param isOutputCharacter
     */
    public void execute(boolean isOutputCharacter,
			boolean isOutputLispSExpression,
			boolean isOutputVisual) {
        for (int i = 0; i < commandTable.size(); i++) {
	    // sR}he[u瓾
            Vector command = (Vector)commandTable.elementAt(i);

	    // R}h񂩂 judan ̃\bhIuWFNg𐶐
	    JudanMethodWrapper method = makeMethod(command);

	    // \bhs
  	    method.invoke();

	    // tOƂɌʂ\B
	    if (isOutputCharacter)
		method.output();
	    else if (isOutputLispSExpression)
		method.toLispSExpression();

	    if (isOutputVisual)
		method.view();
	}
    }
}
