/*
 * Java Geometry Handling Library Test Environment
 * JudanMethod Object for Method "intersect"
 *
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 *
 * $Id: JudanMethodIntersect.java,v 1.5 2000/04/20 13:27:53 ryo Exp $
 */
package jp.co.sra.judan;

import java.lang.reflect.*;
import jp.go.ipa.jgcl.*;
import jp.co.sra.judan.*;

import java.awt.Color;
import sra.jun.opengl.objects.*;

/**
 * @version $Revision: 1.5 $
 * @author $Author: ryo $
 */

public class JudanMethodIntersect extends JudanMethod {

    /**
     * RXgN^
     *
     * @param geometry    􉽃IuWFNg
     * @param methodName  \bh̖O
     * @param argClasses  \bh̃NX
     * @param argEntities \bhɗ^̃IuWFNg
     */
    public JudanMethodIntersect(JgclGeometry geometry,
			       String methodName,
			       Class[] argClasses,
			       Object[] argEntities) {
	// Jgcl*Curve2D   -> JgclParametricCurve2D ɕύX
	// Jgcl*Curve3D   -> JgclParametricCurve3D ɕύX
	// Jgcl*Surface3D -> JgclParametricSurface3D ɕύX
 	try {
	    Class cls;
	    if ((cls = Class.forName("jp.go.ipa.jgcl.JgclParametricCurve2D")).
		isAssignableFrom(argClasses[0])) {
	    }
	    else if ((cls = Class.forName("jp.go.ipa.jgcl.JgclParametricCurve3D")).
		     isAssignableFrom(argClasses[0])) {
	    }
	    else if ((cls = Class.forName("jp.go.ipa.jgcl.JgclParametricSurface3D")).
		     isAssignableFrom(argClasses[0])) {
	    }
	    else {
		throw new JgclFatal();
	    }
	    argClasses[0] = cls;
 	}
 	catch (ClassNotFoundException e) {
 	    throw new JgclFatal();
 	}
	setFields(geometry, methodName, argClasses, argEntities);
    }

    /**
     * sʂ𕶎Ƃďo͂
     */
    public void output() {
	Object[] res = (Object[])result;
    	if (res.length == 0) {
	    System.out.println("Number of solution is 0");
	    return;
	}

	for (int i = 0; i < res.length; i++) {
	    if (res[i] instanceof JgclIntersectionPoint2D) {
		JgclIntersectionPoint2D result2d =
		    (JgclIntersectionPoint2D)res[i];
		result2d.output(System.out);
	    }
	    else if (res[i] instanceof JgclIntersectionPoint3D) {
		JgclIntersectionPoint3D result3d =
		    (JgclIntersectionPoint3D)res[i];
		result3d.output(System.out);
	    }
	    else if (res[i] instanceof JgclIntersectionCurve3D) {
		JgclIntersectionCurve3D result3d =
		    (JgclIntersectionCurve3D)res[i];
		result3d.output(System.out);
	    }
	}
    }

    /**
     * sʂOtBbNƂďo͂
     */
    public static void view(Object result) {
	JudanTransformer resultView = makeView(result);
	resultView.show();
    }

    /**
     * sʂOtBbN
     */
    public static JudanTransformer makeView(Object result) {
  	Object[] res = (Object[])result;

	int nSolution = res.length;
	if (nSolution == 0) {
	    System.out.println("Number of solution is 0");
	    return null;
	}

	JudanTransformer resultView =
	    new JudanTransformer(new JudanTransformerJun());

	for (int i = 0; i < nSolution; i++) {
	    if (res[i] instanceof jp.go.ipa.jgcl.JgclIntersectionPoint2D) {
		// x[XƂȂ Geometry ̑gݍ킹̃p^[ɂ́A
		//  x 
		JgclIntersectionPoint2D result2d = (JgclIntersectionPoint2D)res[i];
		if (i == 0) {
		    JgclParametricCurve2D curve1 = result2d.pointOnCurve1().basisCurve();
		    JgclParametricCurve2D curve2 = result2d.pointOnCurve2().basisCurve();

		    resultView.transform(curve1, Color.blue);
		    resultView.transform(curve2, Color.green);
		}

    		JgclPoint2D point = result2d.coordinates();
  		resultView.transform(point, Color.red);
	    }
	    else if (res[i] instanceof jp.go.ipa.jgcl.JgclIntersectionPoint3D) {
		// x[XƂȂ Geometry ̑gݍ킹̃p^[ɂ́A
		//  x ,  x ,  x ,  x ʂ
		JgclIntersectionPoint3D result3d = (JgclIntersectionPoint3D)res[i];
		if (i == 0) {
		    JgclGeometry geometry1 = result3d.pointOnGeometry1().geometry();
		    JgclGeometry geometry2 = result3d.pointOnGeometry2().geometry();

		    resultView.transform(geometry1, Color.blue);
		    resultView.transform(geometry2, Color.green);
		}

		JgclGeometry geometry = result3d.coordinates();
  		resultView.transform(geometry, Color.red);
	    }
	    else if (res[i] instanceof jp.go.ipa.jgcl.JgclIntersectionCurve3D) {
		// x[XƂȂ Geometry ̑gݍ킹̃p^[ɂ́A
		// ( x ,  x ,  x )  x ʂ
		JgclSurfaceSurfaceInterference3D result3d =
		    (JgclSurfaceSurfaceInterference3D)res[i];
		if (i == 0) {
		    JgclParametricSurface3D surface1 =
			result3d.toIntersectionCurve().basisSurface();
		    JgclParametricSurface3D surface2 =
			result3d.toIntersectionCurve().basisSurface2();

		    resultView.transform(surface1, Color.blue, (float)1.0);
		    resultView.transform(surface2, Color.green, (float)1.0);
		}

		JgclParametricCurve3D curve = result3d.toIntersectionCurve().curve3d();
  		resultView.transform(curve, Color.red, (float)1.0);
	    }
	}
	return resultView;
    }

    /**
     * sʂOtBbN
     */
    public JudanTransformer makeView() {
	return makeView(result);
    }
}
