/*
 * Java Geometry Handling Library Test Environment
 * JudanMethod Object for Method "evaluation"
 *
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 *
 * $Id: JudanMethodEvaluation.java,v 1.4 2000/04/26 11:11:00 furuta Exp $
 */
package jp.co.sra.judan;

import java.lang.reflect.*;
import jp.go.ipa.jgcl.*;
import jp.co.sra.judan.*;

/**
 * @version $Revision: 1.4 $
 * @author $Author: furuta $
 */

public class JudanMethodEvaluation extends JudanMethod {

    /**
     * RXgN^
     *
     * @param geometry    􉽃IuWFNg
     * @param methodName  \bh̖O
     * @param argClasses  \bh̃NX
     * @param argEntities \bhɗ^̃IuWFNg
     */
    public JudanMethodEvaluation(JgclGeometry geometry,
				 String methodName,
				 Class[] argClasses,
				 Object[] argEntities) {
	if (geometry instanceof JgclParametricCurve)
	    argClasses[0] = double.class;
	else if (geometry instanceof JgclParametricSurface) {
	    argClasses[0] = double.class;
	    argClasses[1] = double.class;
	}
	else {
	    throw new JgclFatal();
	}
	setFields(geometry, methodName, argClasses, argEntities);
    }

    /**
     * sʂ𕶎Ƃďo͂
     */
    public void output(){
	// should be more reasonable output
	if (geometry.isCurve()) {
	    if (geometry.is2D()) {
		JgclCurveDerivative2D drv2d = (JgclCurveDerivative2D)result;
		drv2d.d0D().output(System.out);
		drv2d.d1D().output(System.out);
		drv2d.d2D().output(System.out);
	    } else {
		JgclCurveDerivative3D drv3d = (JgclCurveDerivative3D)result;
		drv3d.d0D().output(System.out);
		drv3d.d1D().output(System.out);
		drv3d.d2D().output(System.out);
		drv3d.d3D().output(System.out);
	    }
	} else {
	    JgclSurfaceDerivative3D sdrv3d = (JgclSurfaceDerivative3D)result;
	    sdrv3d.d0().output(System.out);
	    sdrv3d.du().output(System.out);
	    sdrv3d.dv().output(System.out);
	    sdrv3d.duu().output(System.out);
	    sdrv3d.duv().output(System.out);
	    sdrv3d.dvv().output(System.out);
	}
    }

    /**
     * sʂOtBbN
     */
    public JudanTransformer makeView() {
	return null;
    }
}
