/*
 * Java Geometry Handling Library Test Environment
 * JudanMethod Object for Method "curvature"
 *
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 *
 * $Id: JudanMethodCurvature.java,v 1.4 2000/04/26 11:10:59 furuta Exp $
 */
package jp.co.sra.judan;

import java.lang.reflect.*;
import jp.go.ipa.jgcl.*;
import jp.co.sra.judan.*;

/**
 * @version $Revision: 1.4 $
 * @author $Author: furuta $
 */

public class JudanMethodCurvature extends JudanMethod {

    /**
     * RXgN^
     *
     * @param geometry    􉽃IuWFNg
     * @param methodName  \bh̖O
     * @param argClasses  \bh̃NX
     * @param argEntities \bhɗ^̃IuWFNg
     */
    public JudanMethodCurvature(JgclGeometry geometry,
				String methodName,
				Class[] argClasses,
				Object[] argEntities) {
	if (geometry instanceof JgclParametricCurve)
	    argClasses[0] = double.class;
	else if (geometry instanceof JgclParametricSurface) {
	    argClasses[0] = double.class;
	    argClasses[1] = double.class;
	}
	else {
	    throw new JgclFatal();
	}
	setFields(geometry, methodName, argClasses, argEntities);
    }

    /**
     * sʂ𕶎Ƃďo͂
     */
    public void output(){
	// should be more reasonable output
	if (geometry.isCurve()) {
	    if (geometry.is2D()) {
		JgclCurveCurvature2D crv2d = (JgclCurveCurvature2D)result;
		System.out.println("// " + crv2d.curvature());
		crv2d.normal().output(System.out);
	    } else {
		JgclCurveCurvature3D crv3d = (JgclCurveCurvature3D)result;
		System.out.println("// " + crv3d.curvature());
		crv3d.normal().output(System.out);
	    }
	} else {
	    JgclSurfaceCurvature3D scrv3d = (JgclSurfaceCurvature3D)result;
	    System.out.println("// " + scrv3d.principalCurvature1());
	    scrv3d.principalDirection1().output(System.out);
	    System.out.println("// " + scrv3d.principalCurvature2());
	    scrv3d.principalDirection2().output(System.out);
	}
    }

    /**
     * sʂOtBbN
     */
    public JudanTransformer makeView() {
	return null;
    }
}
