/*
 * Java Geometry Handling Library Test Environment
 * abstract class for Method object
 *
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 *
 * $Id: JudanMethod.java,v 1.8 2000/08/15 09:36:09 shikano Exp $
 */
package jp.co.sra.judan;

import java.lang.reflect.*;
import java.util.Vector;
import jp.go.ipa.jgcl.*;
import jp.co.sra.judan.*;

/**
 * @version $Revision: 1.8 $
 * @author $Author: shikano $
 */
public abstract class JudanMethod extends java.lang.Object {

    /**
     * \bhIuWFNg
     */
    protected Method method;

    /**
     * \bh̎s
     */
    protected Object result;

    /**
     * \bhNX̃CX^X
     */
    protected JgclGeometry geometry;

    /**
     * \bhIuWFNg̃NX
     */
    protected Class[] argClasses;

    /**
     * \bhIuWFNgɗ^̃IuWFNg
     */
    protected Object[] argEntities;

    /**
     * Visual mode ̂߂
     * \bh̎s(ۂ JgclGeometry ̔z)
     */
//      protected Vector resultView = new Vector();

    /**
     * Visual mode ̂߂ View
     */
    protected JudanView view = new JudanView(new JudanViewWithJun());

    /**
     * \bh̎sʂ̃OtBbN\
     */
    protected JudanTransformer resultView;

    /**
     * tB[hݒ肷
     *
     * @param geometry    􉽃IuWFNg
     * @param methodName  \bh̖O
     * @param argClasses  \bh̃NX
     * @param argEntities \bhɗ^̃IuWFNg
     */
    protected void setFields(JgclGeometry geometry,
			     String methodName,
			     Class[] argClasses,
			     Object[] argEntities) {
	setFields(geometry.getClass(), geometry, methodName, argClasses, argEntities);
    }

    /**
     * tB[hݒ肷
     *
     * @param geomClass   􉽃IuWFNg̃NX
     * @param geometry    􉽃IuWFNg
     * @param methodName  \bh̖O
     * @param argClasses  \bh̃NX
     * @param argEntities \bhɗ^̃IuWFNg
     */
    protected void setFields(Class geomClass,
			     JgclGeometry geometry,
			     String methodName,
			     Class[] argClasses,
			     Object[] argEntities) {
	this.geometry = geometry;
	this.argEntities = argEntities;
	try {
	    this.method = geomClass.getMethod(methodName, argClasses);
	}
	catch (NoSuchMethodException e) {
		throw new JgclFatal();
	}
	this.argClasses = argClasses;
    }

    /**
     * RXgN^(Ȃ)
     */
    JudanMethod() {}

    /**
     * RXgN^
     *
     * @param geometry    􉽃IuWFNg
     * @param methodName  \bh̖O
     * @param argClasses  \bh̃NX
     * @param argEntities \bhɗ^̃IuWFNg
     */
    public JudanMethod(JgclGeometry geometry,
		      String methodName,
		      Class[] argClasses,
		      Object[] argEntities) {
	setFields(geometry, methodName, argClasses, argEntities);
    }

    /**
     * \bhs
     */
    public void invoke() {
	try {
	    result = method.invoke(geometry, argEntities);
	}
	catch (IllegalAccessException e) {
    	    throw new JgclFatal();
	}
	catch (InvocationTargetException e) {
	    e.getTargetException().printStackTrace();
  	    throw new JgclFatal();
	}
    }

    /**
     * sʂ𕶎Ƃďo͂
     */
    abstract public void output();

    /**
     * sʂOtBbNXƂďo͂
     */
    public void view() {
  	if (resultView == null)
	    resultView = makeView();

	if (resultView != null)
	    resultView.show();
    }

    /**
     * sʂ̃OtBbNLispSƂďo͂
     */
    public void toLispSExpression() {
  	if (resultView == null)
	    resultView = makeView();

	if (resultView != null)
	    resultView.toLispSExpression();
    }

    /**
     * sʂOtBbN
     */
    abstract public JudanTransformer makeView();
}
