/*
 * JGCL mF̂߂̃eXg(Up RMI-IIOP T[oC^tF[X)
 *
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 *
 * $Id: JudanIIOPServer.java,v 1.2 2000/04/26 21:08:31 ryo Exp $
 */
package jp.co.sra.judan;

import java.io.*;
import java.rmi.*;
import java.util.*;
import jp.go.ipa.jgcl.*;

/**
 * JGCL mF̂߂̃eXg(Up RMI-IIOP T[oC^tF[X)
 *
 * @version $Revision: 1.2 $
 * @author $Author: ryo $
 */
public interface JudanIIOPServer extends Remote {

    /**
     * ^ꂽ̃t@C͂āAʂԂB
     *
     * @param file ͂t@C̒g
     * @return     ͌(􉽃IuWFNg̖ȌW)
     */
    public Vector parse(String file) throws RemoteException;

    /**
     * ɂ^ꂽO̊􉽃IuWFNgԂ
     *
     * @param name 􉽃IuWFNg̖O
     * @return     OɑΉ􉽃IuWFNg
     */
    public JgclGeometry getGeometry(String name) throws RemoteException;

    /**
     * ɂ^ꂽO̊􉽃IuWFNgȐǂԂ
     *
     * @param name 􉽃IuWFNg̖O
     * @return     Ȑǂ
     */
    public boolean isCurve(String name) throws RemoteException;

    /**
     * ɂ^ꂽO̊􉽃IuWFNgȖʂǂԂ
     *
     * @param name 􉽃IuWFNg̖O
     * @return     Ȗʂǂ
     */
    public boolean isSurface(String name) throws RemoteException;

    /**
     * ͂ꂽ􉽃IuWFNg̖ȌWԂ
     *
     * @return     􉽃IuWFNg̖ȌW
     */
    public Vector getNameList() throws RemoteException;

    /**
     * w肳ꂽO̊􉽃IuWFNgo͂
     */
    public void show(String name) throws RemoteException;

    /**
     * ͍ς݂ǂԂ
     *
     * @return     łɉ͍ς݃IuWFNg݂邩ǂ
     */
    public boolean isParsed() throws RemoteException;

    /**
     * OŎw肳ꂽ􉽃IuWFNg]
     *
     * @param name  􉽃IuWFNg̖O
     * @param param ]鎞̃p[^
     * @return      ]
     */
    public void evaluate(String name, double[] param) throws RemoteException;

    /**
     * OŎw肳ꂽ􉽃IuWFNgٓ_𓾂
     *
     * @param name  􉽃IuWFNg̖O
     * @return      ٓ_
     */
    public void singular(String name) throws RemoteException;

    /**
     * OŎw肳ꂽ􉽃IuWFNgϋȓ_𓾂
     *
     * @param name  􉽃IuWFNg̖O
     * @return      ϋȓ_
     */
    public void inflexion(String name) throws RemoteException;

    /**
     * OŎw肳ꂽ􉽃IuWFNǧ_A߂
     *
     * @param name 􉽃IuWFNg̖O
     * @return     _AƂ
     */
    public void intersect(String[] name) throws RemoteException;

    /**
     * OŎw肳ꂽ􉽃IuWFNge߂
     *
     * @param name 􉽃IuWFNg̖O
     * @return     e
     */
    public void projectFrom(String[] name) throws RemoteException;

    /**
     * OŎw肳ꂽ􉽃IuWFNg̃tBbg߂
     *
     * @param name  􉽃IuWFNg̖O
     * @param param tBbg߂Ƃ̃p[^
     * @return      tBbg
     */
    public void fillet(String[] name, double param) throws RemoteException;

    /**
     * OŎw肳ꂽ􉽃IuWFNg̃ItZbg߂
     *
     * @param name  􉽃IuWFNg̖O
     * @param param ItZbg߂Ƃ̃p[^
     * @return      ItZbg
     */
    public void offset(String name, double param) throws RemoteException;

    /**
     * OŎw肳ꂽ􉽃IuWFNg̃^uVʂ߂
     *
     * @param name1  􉽃IuWFNg̖O(JgclBsplineCurve3D)
     * @param name2  􉽃IuWFNg̖O(JgclBsplineCurve3D)
     * @return       ʂ̃^uV
     */
    public void tabcylSurface(String name1, String name2) throws RemoteException;

    /**
     * OŎw肳ꂽ􉽃IuWFNg̃tgʂ߂
     *
     * @param name1  􉽃IuWFNg̖O(JgclBsplineCurve3D)
     * @param name2  􉽃IuWFNg̖O(JgclVector3D)
     * @param param  tgʂ߂Ƃ̃p[^
     * @return       ʂ̃tg
     */
    public void loftSurface(String name1, String name2, double param) throws RemoteException;
}
