/*
 * JGCL mF̂߂̃eXg(Up RMI-IIOP NCAg)
 *
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 *
 * $Id: JudanIIOPClient.java,v 1.3 2000/04/27 08:08:30 ryo Exp $
 */
package jp.co.sra.judan;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import java.rmi.*;
import jp.go.ipa.jgcl.*;

/**
 * JGCL mF̂߂̃eXg(Up RMI-IIOP NCAg)
 *
 * @version $Revision: 1.3 $
 * @author $Author: ryo $
 */
public class JudanIIOPClient extends JFrame {

    /**
     * j[o[
     * @see JMenuBar
     */
    private JMenuBar menuBar;

    /**
     * {^Ȃׂ邽߂̃pl
     * @see JPanel
     */
    JPanel buttonPanel;
    JButton[] buttons;

    /**
     * ͌ JgclGeometry IuWFNg\邽߂̃Xg
     * @see JList
     */
    JList list;
    JScrollPane listPane;

    /**
     * \`Ԃ̑Î߂̃`FbN{bNX
     */
//      JCheckBox checkOutput;
//      JCheckBox checkDisplay;

    /**
     * T[oIuWFNgւ̎Q
     */
    JudanIIOPServer server;

    /*
     * j[ɊւCiNX
     */

    /**
     * "Open" j[Î߂̃XiNX
     *
     * @see ActionListener
     * @see ActionEvent
     * @see File
     * @see Vector
     * @see InputStream
     * @see FileInputStream
     * @see DefaultListModel
     * @see JudanParser
     * @see JFileChooser
     * @see JgclGeometry
     * @exception FileNotFoundException
     * @exception IOException
     * @exception ParseException
     */
    class OpenMenu implements ActionListener {
      
        /**
         * eXg(g)
         */
        JudanIIOPClient cl;

        /**
         * t@CɋLqꂽ JgclGeometry IuWFNg̉͊
         * @see JudanParser
         */
        JudanParser parser = null;

        /**
         * RXgN^
         * @see JudanIIOPClient
         */
        OpenMenu(JudanIIOPClient cl) {
	    this.cl = cl;
        }

        /**
         * "OpenMenu" j[IꂽƂɍsANV
         * 
	 * @param e Cxg
         * @see ActionListener
         * @see ActionEvent
         * @see File
         * @see Vector
         * @see InputStream
         * @see FileInputStream
         * @see DefaultListModel
         * @see JudanParser
         * @see JFileChooser
         * @see JgclGeometry
         * @exception FileNotFoundException
         * @exception IOException
         */
        public void actionPerformed(ActionEvent e) {
	    try {
		JFileChooser fileChooser = new JFileChooser(".");
		int result = fileChooser.showOpenDialog(cl);
		File file = fileChooser.getSelectedFile();

		if (result != JFileChooser.APPROVE_OPTION
		    || file == null)
		    return;

  		FileReader reader = new FileReader(file);
  		StringWriter writer = new StringWriter();
  		int ch;
  		while ((ch = reader.read()) != -1) {
  		    writer.write(ch);
  		}
    		Vector nameList = cl.server.parse(writer.toString());
		cl.list.setListData(nameList);
  	    }
    	    catch (IOException ex){
    		System.out.println("IO error");
    	    }
        }
    }

    /**
     * "Exit" j[Î߂̃XiNX
     *
     * @see ActionListener
     * @see ActionEvent
     */
    public class ExitMenu implements ActionListener {

        /**
         * "ExitMenu" j[IꂽƂ̃ANV
	 *
	 * @param e Cxg
         * @see ActionEvent
         */
        public void actionPerformed(ActionEvent e){
	    System.exit(0);
        }
    }

    /*
     * XgɊւCiNX
     */

    /**
     * JList ̍ڂIƂ̂߂̃XiNX
     *
     * @see ListSelectionListener
     * @see ListSelectionEvent
     */
    public class ListSelect implements ListSelectionListener {
	JudanIIOPClient cl;

      /**
       * RXgN^
       *
       * @see JudanIIOPClient
       */
      ListSelect(JudanIIOPClient cl) {
  	  this.cl = cl;
      }

        /**
         * Xg̑IڂύXꂽƂ̃ANV
	 *
	 * @param e Cxg
         * @see ListSelectionEvent
         */
        public void valueChanged(ListSelectionEvent e) {
	    JList list = (JList)e.getSource();

              if (list.getSelectedValues().length < 1) {
		  cl.buttons[0].setEnabled(false);	// show
                  cl.buttons[1].setEnabled(false);	// Evaluation
                  cl.buttons[2].setEnabled(false);	// Singular
                  cl.buttons[3].setEnabled(false);	// Inflexion
		  cl.buttons[4].setEnabled(false);	// Intersection
                  cl.buttons[5].setEnabled(false);	// Projection
                  cl.buttons[6].setEnabled(false);	// Offset
                  cl.buttons[7].setEnabled(false);	// Fillet
                  cl.buttons[8].setEnabled(false);	// Tabcyl
                  cl.buttons[9].setEnabled(false);	// Loft
              }
	      else if (list.getSelectedValues().length == 1) {
		  cl.buttons[0].setEnabled(true);	// show
                  cl.buttons[1].setEnabled(true);	// Evaluation
                  cl.buttons[2].setEnabled(true);	// Singular
                  cl.buttons[3].setEnabled(true);	// Inflexion
		  cl.buttons[4].setEnabled(false);	// Intersection
                  cl.buttons[5].setEnabled(false);	// Projection
                  cl.buttons[6].setEnabled(true);	// Offset
                  cl.buttons[7].setEnabled(false);	// Fillet
                  cl.buttons[8].setEnabled(false);	// Tabcyl
                  cl.buttons[9].setEnabled(false);	// Loft
              }
              else if (list.getSelectedValues().length == 2) {
		  cl.buttons[0].setEnabled(true);	// show
                  cl.buttons[1].setEnabled(false);	// Evaluation
                  cl.buttons[2].setEnabled(false);	// Singular
                  cl.buttons[3].setEnabled(false);	// Inflexion
		  cl.buttons[4].setEnabled(true);	// Intersection
                  cl.buttons[5].setEnabled(true);	// Projection
                  cl.buttons[6].setEnabled(false);	// Offset
                  cl.buttons[7].setEnabled(true);	// Fillet
                  cl.buttons[8].setEnabled(true);	// Tabcyl
                  cl.buttons[9].setEnabled(true);	// Loft
              }
              else {
		  cl.buttons[0].setEnabled(true);	// show
                  cl.buttons[1].setEnabled(false);	// Evaluation
                  cl.buttons[2].setEnabled(false);	// Singular
                  cl.buttons[3].setEnabled(false);	// Inflexion
		  cl.buttons[4].setEnabled(false);	// Intersection
                  cl.buttons[5].setEnabled(false);	// Projection
                  cl.buttons[6].setEnabled(false);	// Offset
                  cl.buttons[7].setEnabled(false);	// Fillet
                  cl.buttons[8].setEnabled(false);	// Tabcyl
                  cl.buttons[9].setEnabled(false);	// Loft
              }
        }
    }

    /*
     * {^ɊւCiNX
     */

    /**
     * "Show" {^ꂽƂ̂߂̃XiNX
     *
     * @see ActionListener
     * @see ActionEvent
     * @see JudanIIOPClient
     * @see JgclGeometry
     */
    public class ShowButton implements ActionListener {
        /**
         * eXg(g)
         */
        JudanIIOPClient cl;

        /**
	 * ͂ꂽIuWFNg̖O\邽߂̃Xg
	 * @see JList
	 */
        JList list;

        /**
	 * ͂ꂽIuWFNgƂ̖Oi[邽߂̃nbVe[u
	 * @see Hashtable
	 */
        Hashtable table;

        /**
         * t@C͌ JgclGeometry IuWFNg̔z
	 * @see JgclGeometry
         */
        JgclGeometry[] geometries;

        /**
         * JgclGeometry IuWFNg\
	 * @see JudanView
         */
        JudanView view;

        /**
         * RXgN^
         */
        ShowButton(JudanIIOPClient cl) {
            this.cl = cl;
        }

        /**
         * "Show" {^ꂽƂ̃ANV
         *
	 * @param Cxg
         * @see ActionEvent
         * @see JgclGeometry
         * @see JudanView
         * @see JudanViewWithJun
         */
        public void actionPerformed(ActionEvent e) {
	    int numberOfElement = cl.list.getSelectedValues().length;
	    try {
		for (int i = 0; i < numberOfElement; i++) {
		    String name = (String)cl.list.getSelectedValues()[i];
		    cl.server.show(name);
		}
	    }
	    catch (RemoteException ex) {
		System.out.println("Server side error");
	    }
//    	    int numberOfElement = cl.list.getSelectedValues().length;
//  	    geometries = new JgclGeometry[numberOfElement];

//  	    try {
//  		for (int i = 0; i < numberOfElement; i++) {
//  		    geometries[i] =
//  			(JgclGeometry)cl.server.getGeometry
//  			((String)cl.list.getSelectedValues()[i]);
//  		}
//  	    }
//  	    catch (RemoteException ex) {
//  		System.out.println("Server side error.");
//  		throw new JgclFatal();
//  	    }

//  	    if (checkOutput.isSelected()) {
//  		for (int i = 0; i < geometries.length; i++)
//  		    geometries[i].output(System.out);
//  	    }

//  	    if (checkDisplay.isSelected()) {
//  		view = new JudanView(new JudanViewWithJun());
//  		view.display(geometries);
//  	    }
	}
    }

    /**
     * "Evaluation" {^ꂽƂ̂߂̃XiNX
     *
     * @see ActionListener
     * @see ActionEvent
     * @see JudanIIOPClient
     * @see JgclGeometry
     */
    public class EvaluationButton implements ActionListener {
        /**
         * eXg(g)
         */
        JudanIIOPClient cl;

        /**
         * RXgN^
         */
        EvaluationButton(JudanIIOPClient cl) {
            this.cl = cl;
        }

        /**
         * "Evaluation" {^ꂽƂ̃ANV
         *
	 * @param Cxg
         * @see ActionEvent
         * @see JgclGeometry
         */
        public void actionPerformed(ActionEvent e) {
	    Object[] textObj = null;
	    double[] params = null;
	    String name = (String)cl.list.getSelectedValues()[0];

	    // Ȑ̏ꍇ(p[^1)
	    try {
		if (cl.server.isCurve(name)) {
		    JTextField text = new JTextField();
		    text.setBorder(new TitledBorder("Parameter"));
		    textObj = new Object[] {text};
		    int ans =
			JOptionPane.showConfirmDialog(cl, textObj, "Coordinate",
						      JOptionPane.OK_CANCEL_OPTION);
		    if (ans != 0) return;

		    params = new double[1];
		    params[0] = Double.valueOf(text.getText()).doubleValue();
		}
		// Ȗʂ̏ꍇ(p[^2)
		else if (cl.server.isSurface(name)) {
		    JTextField text1 = new JTextField();
		    text1.setBorder(new TitledBorder("uParameter"));
		    JTextField text2 = new JTextField();
		    text2.setBorder(new TitledBorder("vParameter"));
		    textObj = new Object[] {text1, text2};
		    int ans =
			JOptionPane.showConfirmDialog(cl, textObj, "Coordinate",
						      JOptionPane.OK_CANCEL_OPTION);
		    if (ans != 0) return;
		    params = new double[2];
		    params[0] = Double.valueOf(text1.getText()).doubleValue();
		    params[1] = Double.valueOf(text2.getText()).doubleValue();
		}
		// ȖʁAȐȊO
		else {
		    System.out.println("not a suitable selection");
		    return;
		}

//  		JgclGeometry result = cl.server.evaluate(name, params);
  		cl.server.evaluate(name, params);

//  		if (checkOutput.isSelected()) {
//    		    result.output(System.out);
//  		}

//  		if (checkDisplay.isSelected()) {
//  		    JgclGeometry geom = (JgclGeometry)cl.server.getGeometry(name);
//  		    JudanTransformer transformer = new JudanTransformer(new JudanTransformerJun());
//  		    transformer.transform(result, Color.red);
//  		    transformer.transform(geom, Color.green);
//  		    transformer.show();
//  		}
	    }
	    catch (RemoteException ex) {
		System.out.println("Server side error.");
	    }
	}
    }

    /**
     * "Singular" {^ꂽƂ̂߂̃XiNX
     *
     * @see ActionListener
     * @see ActionEvent
     * @see JudanGeometryManager
     * @see JgclGeometry
     */
    public class SingularButton implements ActionListener {
        /**
         * eXg(g)
         */
        JudanIIOPClient cl;

        /**
         * RXgN^
         */
        SingularButton(JudanIIOPClient cl) {
            this.cl = cl;
        }

        /**
         * "Singular" {^ꂽƂ̃ANV
         *
	 * @param Cxg
         * @see ActionEvent
         * @see JgclGeometry
         */
        public void actionPerformed(ActionEvent e) {
	    String name = (String)cl.list.getSelectedValues()[0];
	    JgclGeometry[] result;

	    try {
		if (cl.server.isCurve(name)) {
//    		    result = (JgclGeometry[])cl.server.singular(name);
		    cl.server.singular(name);
		}
		else {
		    System.out.println("not a suitable selection");
		    return;
		}
//  		if (checkOutput.isSelected()) {
//  		    for (int i = 0; i < result.length; i++)
//  			result[i].output(System.out);
//  		}
//  		if (checkDisplay.isSelected()) {
//  		    JgclGeometry geom = (JgclGeometry)cl.server.getGeometry(name);
//    		    JudanTransformer transformer = new JudanTransformer(new JudanTransformerJun());
//  		    for (int i = 0; i < result.length; i++) {
//  			transformer.transform(result[i], Color.red);
//  		    }
//  		    transformer.transform(geom, Color.green);
//  		    transformer.show();
//  		}
	    }
	    catch (RemoteException ex) {
		System.out.println("Server side error.");
	    }
	}
    }

    /**
     * "Inflexion" {^ꂽƂ̂߂̃XiNX
     *
     * @see ActionListener
     * @see ActionEvent
     * @see JudanGeometryManager
     * @see JgclGeometry
     */
    public class InflexionButton implements ActionListener {
        /**
         * eXg(g)
         */
        JudanIIOPClient cl;

        /**
         * RXgN^
         */
        InflexionButton(JudanIIOPClient cl) {
            this.cl = cl;
        }

        /**
         * "Inflexion" {^ꂽƂ̃ANV
         *
	 * @param Cxg
         * @see ActionEvent
         * @see JgclGeometry
         */
        public void actionPerformed(ActionEvent e) {
	    String name = (String)cl.list.getSelectedValues()[0];
	    JgclGeometry[] result;

	    try {
		if (cl.server.isCurve(name)) {
//  		    result = (JgclGeometry[])cl.server.inflexion(name);
  		    cl.server.inflexion(name);
		}
		else {
		    System.out.println("not a suitable selection");
		    return;
		}
//  		if (checkOutput.isSelected()) {
//  		    for (int i = 0; i < result.length; i++)
//  			result[i].output(System.out);
//  		}
//  		if (checkDisplay.isSelected()) {
//  		    JgclGeometry geom = (JgclGeometry)cl.server.getGeometry(name);
//  		    JudanTransformer transformer = new JudanTransformer(new JudanTransformerJun());
//  		    for (int i = 0; i < result.length; i++) {
//  			transformer.transform(result[i], Color.red);
//  		    }
//  		    transformer.transform(geom, Color.green);
//  		    transformer.show();
//  		}
	    }
	    catch (RemoteException ex) {
		System.out.println("Server side error.");
	    }
	}
    }

    /**
     * "Intersection" {^ꂽƂ̂߂̃XiNX
     *
     * @see ActionListener
     * @see ActionEvent
     * @see JudanIIOPClient
     * @see JgclGeometry
     */
    public class IntersectionButton implements ActionListener {
        /**
         * eXg(g)
         */
        JudanIIOPClient cl;

        /**
         * RXgN^
         */
        IntersectionButton(JudanIIOPClient cl) {
            this.cl = cl;
        }

        /**
         * "Intersection" {^ꂽƂ̃ANV
         *
	 * @param Cxg
         * @see ActionEvent
         * @see JgclGeometry
         */
        public void actionPerformed(ActionEvent e) {
	    String[] name = new String[2];
	    for (int i = 0; i < name.length; i++)
		name[i] = (String)cl.list.getSelectedValues()[i];
	    JgclGeometry[] result;

    	    try {
//    		result = (JgclGeometry[])cl.server.intersect(name);
      		cl.server.intersect(name);
//    		if (checkOutput.isSelected()) {
//    		    for (int i = 0; i < result.length; i++) {
//    			result[i].output(System.out);
//    		    }
//    		}
//    		if (checkDisplay.isSelected()) {
//    		    JudanMethodIntersect.view(result);
//    		}
    	    }
    	    catch (RemoteException ex) {
    		System.out.println("Server side error.");
    	    }
        }
    }

    /**
     * "Projection" {^ꂽƂ̂߂̃XiNX
     *
     * @see ActionListener
     * @see ActionEvent
     * @see JudanIIOPClient
     * @see JgclGeometry
     */
    public class ProjectionButton implements ActionListener {
        /**
         * eXg(g)
         */
        JudanIIOPClient cl;

        /**
         * RXgN^
         */
        ProjectionButton(JudanIIOPClient cl) {
            this.cl = cl;
        }

        /**
         * "Projection" {^ꂽƂ̃ANV
         *
	 * @param Cxg
         * @see ActionEvent
         * @see JgclGeometry
         */
        public void actionPerformed(ActionEvent e) {
            String[] name = new String[2];

            for (int i = 0; i < 2; i++)
	        name[i] = (String)cl.list.getSelectedValues()[i];

	    Vector result;
	    try {
//  		result = cl.server.projectFrom(name);
  		cl.server.projectFrom(name);
//  		JgclGeometry[] poc = (JgclGeometry[])result.elementAt(0);
//  		if (checkOutput.isSelected()) {
//  		    for (int i = 0; i < poc.length; i++) {
//  			poc[i].output(System.out);
//  		    }
//  		}
//  		if (checkDisplay.isSelected()) {
//  		    JgclPoint point = (JgclPoint)result.elementAt(1);
//  		    JudanMethodProjectFrom.view(poc, point);
//  		}
	    }
	    catch (RemoteException ex) {
		System.out.println("Server side error.");
	    }
	    return;
        }
    }

    /**
     * "Fillet" {^ꂽƂ̂߂̃XiNX
     *
     * @see ActionListener
     * @see ActionEvent
     * @see JudanIIOPClient
     * @see JgclGeometry
     */
    public class FilletButton implements ActionListener {
        /**
         * eXg(g)
         */
	JudanIIOPClient cl;

        /**
         * RXgN^
         */
        FilletButton(JudanIIOPClient cl) {
            this.cl = cl;
        }

        /**
         * "Fillet" {^ꂽƂ̃ANV
         *
	 * @param Cxg
         * @see ActionEvent
         * @see JgclGeometry
         */
        public void actionPerformed(ActionEvent e) {
            String[] name = new String[2];
	    for (int i = 0; i < 2; i++)
		name[i] = (String)cl.list.getSelectedValues()[i];

	    JTextField text = new JTextField();
	    text.setBorder(new TitledBorder("Radius"));
	    Object[] textObj = new Object[] {text};
	    int ans =
		JOptionPane.showConfirmDialog(cl, textObj, "Fillet",
					      JOptionPane.OK_CANCEL_OPTION);
	    if (ans != 0) return;
	    double param = Double.valueOf(text.getText()).doubleValue();

	    JgclGeometry[] result;
	    try {
//  		result = cl.server.fillet(name, param);
  		cl.server.fillet(name, param);
//  		if (checkOutput.isSelected()) {
//  		    for (int i = 0; i < result.length; i++) {
//  			result[i].output(System.out);
//  		    }
//  		}
//  		if (checkDisplay.isSelected()) {
//  		    JudanMethodFillet.view(result, param);
//  		}
	    }
	    catch (RemoteException ex) {
		System.out.println("Server side error.");
	    }
	    return;
        }
    }

    /**
     * "Offset" {^ꂽƂ̂߂̃XiNX
     *
     * @see ActionListener
     * @see ActionEvent
     * @see JudanIIOPClient
     * @see JgclGeometry
     */
    public class OffsetButton implements ActionListener {
        /**
         * eXg(g)
         */
	JudanIIOPClient cl;

        /**
         * RXgN^
         */
        OffsetButton(JudanIIOPClient cl) {
            this.cl = cl;
        }

        /**
         * "Offset" {^ꂽƂ̃ANV
         *
	 * @param Cxg
         * @see ActionEvent
         * @see JgclGeometry
         */
        public void actionPerformed(ActionEvent e) {
	    String name = (String)cl.list.getSelectedValues()[0];

	    JTextField text = new JTextField();
	    text.setBorder(new TitledBorder("magni"));
	    Object[] textObj = new Object[] {text};
	    int ans =
		JOptionPane.showConfirmDialog(cl, textObj, "Offset",
					      JOptionPane.OK_CANCEL_OPTION);
	    if (ans != 0) return;
	    double param = Double.valueOf(text.getText()).doubleValue();

	    JgclGeometry result;
	    JgclGeometry geom;
	    try {
    		cl.server.offset(name, param);
  		//result = cl.server.offset(name, param);
//    		geom = cl.server.getGeometry(name);
//    		if (checkOutput.isSelected()) {
//    		    result.output(System.out);
//    		}
//    		if (checkDisplay.isSelected()) {
//    		    if (result.is2D())
//    			JudanMethodOffset2D.view(result, geom);
//    		    else if (result.is3D())
//    			JudanMethodOffset3D.view(result, geom);
//    		    else
//    			throw new JgclFatal();
//    		}
	    }
	    catch (RemoteException ex) {
		System.out.println("Server side error.");
	    }
	    return;
        }
    }

    /**
     * "Tabcyl" {^ꂽƂ̂߂̃XiNX
     *
     * @see ActionListener
     * @see ActionEvent
     * @see JudanIIOPClient
     * @see JgclGeometry
     */
    public class TabcylButton implements ActionListener {
        /**
         * eXg(g)
         */
	JudanIIOPClient cl;

        /**
         * RXgN^
         */
        TabcylButton(JudanIIOPClient cl) {
            this.cl = cl;
        }

        /**
         * "Tabcyl" {^ꂽƂ̃ANV
         *
	 * @param Cxg
         * @see ActionEvent
         * @see JgclGeometry
         */
        public void actionPerformed(ActionEvent e) {
	    String name1 = (String)cl.list.getSelectedValues()[0];
	    String name2 = (String)cl.list.getSelectedValues()[1];

	    JgclGeometry result;
	    JgclGeometry geom1;
	    JgclGeometry geom2;
	    try {
//    		result = cl.server.tabcylSurface(name1, name2);
		cl.server.tabcylSurface(name1, name2);
//  		geom1 = cl.server.getGeometry(name1);
//  		geom2 = cl.server.getGeometry(name2);
//  		if (checkOutput.isSelected()) {
//  		    result.output(System.out);
//  		}
//  		if (checkDisplay.isSelected()) {
//  		    JudanMethodTabcyl.view((JgclBsplineSurface3D)result,
//  					   (JgclBsplineCurve3D)geom1,
//  					   (JgclBsplineCurve3D)geom2);
//  		}
	    }
	    catch (RemoteException ex) {
		System.out.println("Server side error.");
	    }
	    return;
        }
    }

    /**
     * "Loft" {^ꂽƂ̂߂̃XiNX
     *
     * @see ActionListener
     * @see ActionEvent
     * @see JudanIIOPClient
     * @see JgclGeometry
     */
    public class LoftButton implements ActionListener {
        /**
         * eXg(g)
         */
	JudanIIOPClient cl;

        /**
         * RXgN^
         */
        LoftButton(JudanIIOPClient cl) {
            this.cl = cl;
        }

        /**
         * "Loft" {^ꂽƂ̃ANV
         *
	 * @param Cxg
         * @see ActionEvent
         * @see JgclGeometry
         */
        public void actionPerformed(ActionEvent e) {
	    String name1 = (String)cl.list.getSelectedValues()[0];
	    String name2 = (String)cl.list.getSelectedValues()[1];

	    JTextField text = new JTextField();
	    text.setBorder(new TitledBorder("length"));
	    Object[] textObj = new Object[] {text};
	    int ans =
		JOptionPane.showConfirmDialog(cl, textObj, "Loft",
					      JOptionPane.OK_CANCEL_OPTION);
	    if (ans != 0) return;
	    double param = Double.valueOf(text.getText()).doubleValue();

	    JgclGeometry result;
	    JgclGeometry geom1;
	    JgclGeometry geom2;
	    try {
//  		result = cl.server.loftSurface(name1, name2, param);
  		cl.server.loftSurface(name1, name2, param);
//  		geom1 = cl.server.getGeometry(name1);
//  		geom2 = cl.server.getGeometry(name2);
//  		if (checkOutput.isSelected()) {
//  		    result.output(System.out);
//  		}
//  		if (checkDisplay.isSelected()) {
//  		    if (geom1 instanceof JgclBsplineCurve3D)
//  			JudanMethodLoft.view((JgclBsplineSurface3D)result,
//  					     (JgclBsplineCurve3D)geom1,
//  					     (JgclVector3D)geom2,
//  					     param);
//  		    else
//  			JudanMethodLoft.view((JgclBsplineSurface3D)result,
//  					     (JgclBsplineCurve3D)geom2,
//  					     (JgclVector3D)geom1,
//  					     param);
//  		}
	    }
	    catch (RemoteException ex) {
		System.out.println("Server side error.");
	    }
	    return;
        }
    }

    /**
     * RXgN^
     *
     * @param title ^Cgo[̖O
     * @see JMenuBar
     * @see JMenu
     * @see JMenuItem
     * @see ActionListener
     * @see BorderLayout
     * @see ListSelect
     * @see DisplayButton
     * @see OpenMenu
     * @see ExitMenu
     */
    public JudanIIOPClient(String title, String host) {
        /*
	 * ^Cgݒ肷
	 */
        setTitle(title);

        /*
         * j[o[ݒ肷
         */
        menuBar = new JMenuBar();
        setJMenuBar(menuBar);

        /*
         * j[ݒ肷 
         */
        JMenu menuFile = addMenu("File");
        JMenuItem menuItemFileOpen = addMenuItem("Open", new OpenMenu(this));
        menuFile.add(menuItemFileOpen);
        menuFile.addSeparator();
        JMenuItem menuItemFileExit = addMenuItem("Exit", new ExitMenu());
        menuFile.add(menuItemFileExit);

        /*
         * IXgݒ肷
         */
	setList(new ListSelect(this));

        /*
         * {^ݒ肷
         */
	String[] buttonName = {"Show", "Evaluation", "Singular", "Inflexion", "Intersection", "Projection", "Offset", "Fillet", "Tabcyl", "Loft"};
	ActionListener[] listenerList = { new ShowButton(this),
					  new EvaluationButton(this),
					  new SingularButton(this),
					  new InflexionButton(this),
					  new IntersectionButton(this),
					  new ProjectionButton(this),
					  new OffsetButton(this),
					  new FilletButton(this),
					  new TabcylButton(this),
					  new LoftButton(this)};

	/*
	 * `FbN{bNXݒ肷
	 */
//  	checkOutput = new JCheckBox("ASCII", true);
//  	checkDisplay = new JCheckBox("Jun", true);
//  	JPanel checkPanel = new JPanel(new GridLayout(1, 2));
//  	checkPanel.add(checkOutput);
//  	checkPanel.add(checkDisplay);

        /*
         * eĩCAEg߂Ĕzu
         */
	// `FbN{bNX{^̏ɔzu
//    	buttonPanel = new JPanel(new GridLayout(buttonName.length + 1, 1));
//  	buttonPanel.add(checkPanel);

    	buttonPanel = new JPanel(new GridLayout(buttonName.length, 1));

	// {^1ɕׂ
        setButtonPanel(buttonName, listenerList);

	// Xgƃ{^̔zu
        getContentPane().add(listPane, BorderLayout.CENTER);
        getContentPane().add(buttonPanel, BorderLayout.EAST);

	// EBhETCYƎo
        setSize(500,300);
        setVisible(true);

	/*
	 * T[oւ̎QƂ𓾂
	 */
	String factory = System.getProperty("java.naming.factory.initial");
	try {
	    if (System.getSecurityManager() == null)
		System.setSecurityManager(new RMISecurityManager());

	    Properties env = new Properties();

	    if (factory.equals("com.sun.jndi.cosnaming.CNCtxFactory")) {
		env.put("java.naming.provider.url", "iiop://" + host);
	    }
	    else {
		env.put("java.naming.provider.url", "rmi://" + host);
	    }

	    InitialContext context = new InitialContext(env);
	    Object o = context.lookup("JudanIIOPServer");
  	    server = (JudanIIOPServer)PortableRemoteObject
		.narrow(o, JudanIIOPServer.class);

	    if (server.isParsed()) {
		Vector nameList = server.getNameList();
		list.setListData(nameList);
	    }
	}
	catch (Exception e) {
	    System.out.println("JudanIIOPClient exception; " +
			       e.getMessage());
	}
    }

    /**
     * plݒ肷
     *
     * @param buttons		{^̔z
     * @see JButton
     */
    public void setButtonPanel(JButton[] buttons) {
        for (int i = 0; i < buttons.length; i++) {
            buttonPanel.add(buttons[i]);
        }
    }

    /**
     * plݒ肷
     *
     * @param buttonNames {^̖O̔z
     * @param listenerClasses	Xi̔z
     * @see JButton
     * @see GridLayout
     * @see ActionListener
     */
    public void setButtonPanel(String[] buttonNames,
			       ActionListener[] listenerClasses) {
        int numberOfButtons = buttonNames.length;
	buttons = new JButton[numberOfButtons];
	for (int i = 0; i < numberOfButtons; i++) {
	    buttons[i] = new JButton(buttonNames[i]);
	    buttons[i].addActionListener(listenerClasses[i]);
	    buttons[i].setEnabled(false);
	    buttonPanel.add(buttons[i]);
	}
    }

    /**
     * {^쐬
     *
     * @param name {^̖O
     * @param listener	Xi
     * @return ꂽ{^
     * @see JButton
     * @see ActionListener
     */
    public JButton createButton(String name, ActionListener listener) {
        JButton button = new JButton(name);
        button.addActionListener(listener);
        return button;
    }

    public void addName(String name){
        ((DefaultListModel)list.getModel()).addElement(name);        
    }

    /**
     * Xgݒ肷
     *
     * @param listModel		 Xĝ߂̃f
     * @param listSelectionModel IXĝ߂̃f
     * @param listener		 Xg̑Im邽߂̃Xi
     * @see JList
     * @see JScrollPane
     * @see ListModel
     * @see LiseSelectionModel
     * @see ListSelectionListener
     */
    public void setList(ListModel listModel, 
			ListSelectionModel listSelectionModel,
			ListSelectionListener listener) {
        list = new JList(listModel);
	list.setSelectionModel(listSelectionModel);
        list.addListSelectionListener(listener);
        listPane = new JScrollPane(list);
    }

    /**
     * Xgݒ肷
     *
     * @param listModel               Xĝ߂̃f
     * @param listener		      Xg̑Im邽߂̃Xi
     * @see DefaultListSelectionModel
     * @see ListSelectionListener
     */
    public void setList(ListModel listModel, ListSelectionListener listener) {
        setList(listModel, new DefaultListSelectionModel(), listener);
    }

    /**
     * Xgݒ肷
     *
     * @param listener		Xg̑Im邽߂̃Xi
     * @see DefaultListModel
     * @see ListSelectionListener
     */
    public void setList(ListSelectionListener listener) {
        setList(new DefaultListModel(), listener);
    }

    /**
     * j[̒ǉs
     *
     * @param menuName	j[̖O
     * @return			j[o[ɒǉꂽj[
     * @see JMenu
     */
    protected JMenu addMenu(String menuName) {
        JMenu menu = new JMenu(menuName);
        menuBar.add(menu);

        return menu;
    }

    /**
     * j[ڂ̒ǉs
     *
     * @param itemName	j[ڂ̖O
     * @param listener	j[ڑĨANVXi
     * @return			ꂽj[
     * @see JMenuItem
     * @see ActionListener
     */
    protected JMenuItem addMenuItem(String itemName,
                                    ActionListener listener){
        JMenuItem menuItem = new JMenuItem(itemName);
        menuItem.addActionListener(listener);

        return menuItem;
    }

    /**
     * main \bh
     */
    public static void main(String[] args){
	String host = args[0];
	JudanIIOPClient cl = new JudanIIOPClient("Judan Client", host);
    }
}
