/*
 * JGCL mF̂߂̃eXg
 *
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 *
 * $Id: JudanGeometryManager.java,v 1.11 2000/08/15 09:36:09 shikano Exp $
 */

package jp.co.sra.judan;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;

import jp.go.ipa.jgcl.*;
import jp.co.sra.judan.*;

/**
 * JGCL mF̂߂̃eXg
 *
 * @version $Revision: 1.11 $, $Date: 2000/08/15 09:36:09 $
 * @author $Author: shikano $
 */
public class JudanGeometryManager extends JFrame {

    /**
     * j[o[
     * @see JMenuBar
     */
    private JMenuBar menuBar;

    /**
     * {^Ȃׂ邽߂̃pl
     * @see JPanel
     */
    JPanel buttonPanel;
    JButton[] buttons;

    /**
     * ͌ JgclGeometry IuWFNg\邽߂̃Xg
     * @see JList
     */
    JList list;
    JScrollPane listPane;

    /*
     * \`Ԃ̑Î߂̃`FbN{bNX
     */
    JCheckBox checkOutput;
    JCheckBox checkDisplay;

    /**
     * ͌ JgclGeometry IuWFNgi[邽߂̃nbVe[u
     * @see Hashtable
     */
    Hashtable table;

    /*
     * j[ɊւCiNX
     */

    /**
     * "Open" j[Î߂̃XiNX
     *
     * @see ActionListener
     * @see ActionEvent
     * @see File
     * @see Vector
     * @see InputStream
     * @see FileInputStream
     * @see DefaultListModel
     * @see JudanParser
     * @see JFileChooser
     * @see JgclGeometry
     * @exception FileNotFoundException
     * @exception IOException
     * @exception ParseException
     */
    class OpenMenu implements ActionListener {
      
        /**
         * eXg(g)
         */
        JudanGeometryManager gm;

        /**
         * t@CɋLqꂽ JgclGeometry IuWFNg̉͊
         * @see JudanParser
         */
        JudanParser parser = null;

        /**
         * RXgN^
         * @see JudanGeometryManager
         */
        OpenMenu(JudanGeometryManager gm) {
	    this.gm = gm;
        }

        /**
         * "OpenMenu" j[IꂽƂɍsANV
         * 
	 * @param e Cxg
         * @see ActionListener
         * @see ActionEvent
         * @see File
         * @see Vector
         * @see InputStream
         * @see FileInputStream
         * @see DefaultListModel
         * @see JudanParser
         * @see JFileChooser
         * @see JgclGeometry
         * @exception FileNotFoundException
         * @exception IOException
         */
        public void actionPerformed(ActionEvent e) {
	    JFileChooser fileChooser = new JFileChooser(".");
            int result = fileChooser.showOpenDialog(gm);
            File file = fileChooser.getSelectedFile();

            if (result != JFileChooser.APPROVE_OPTION
                || file == null)
	        return;
            try {
  	        InputStream inputStream = new FileInputStream(file);
                if (parser != null){
		    parser.ReInit();
		    parser.ReInit(inputStream);
                }
                else{
		    parser = new JudanParser(inputStream);
		}
// 		JgclGeometry[] geometries = parser.jgclFile();
 		JudanParsedInfo parsedInfo = parser.jgclFile();

		Vector nameList = parser.getNameList();
		gm.list.setListData(nameList);
		gm.table = parser.getEntityTable();
		parsedInfo.execute(checkOutput.isSelected(),
		                   false, // checkLispSExpression().isSelected(),
		                   checkDisplay.isSelected());
	    }
	    catch (FileNotFoundException ex){
	    }
	    catch (IOException ex){
	    }
	    catch (ParseException ex){
	    }
        }
    }

    /**
     * "Exit" j[Î߂̃XiNX
     *
     * @see ActionListener
     * @see ActionEvent
     */
    public class ExitMenu implements ActionListener {

        /**
         * "ExitMenu" j[IꂽƂ̃ANV
	 *
	 * @param e Cxg
         * @see ActionEvent
         */
        public void actionPerformed(ActionEvent e){
	    System.exit(0);
        }
    }

    /*
     * XgɊւCiNX
     */

    /**
     * JList ̍ڂIƂ̂߂̃XiNX
     *
     * @see ListSelectionListener
     * @see ListSelectionEvent
     */
    public class ListSelect implements ListSelectionListener {
        JudanGeometryManager gm;

      /**
       * RXgN^
       *
       * @see JudanGeometryManager
       */
      ListSelect(JudanGeometryManager gm) {
	  this.gm = gm;
      }

        /**
         * Xg̑IڂύXꂽƂ̃ANV
	 *
	 * @param e Cxg
         * @see ListSelectionEvent
         */
        public void valueChanged(ListSelectionEvent e) {
	    JList list = (JList)e.getSource();

            if (list.getSelectedValues().length < 1) {
                gm.buttons[0].setEnabled(false);	// show
                gm.buttons[1].setEnabled(false);	// Evaluation
                gm.buttons[2].setEnabled(false);	// Singular
                gm.buttons[3].setEnabled(false);	// Inflexion
                gm.buttons[4].setEnabled(false);	// Intersection
                gm.buttons[5].setEnabled(false);	// Projection
                gm.buttons[6].setEnabled(false);	// Offset
                gm.buttons[7].setEnabled(false);	// Fillet
                gm.buttons[8].setEnabled(false);	// Tabcyl
                gm.buttons[9].setEnabled(false);	// Loft
            }
            else if (list.getSelectedValues().length == 1) {
                gm.buttons[0].setEnabled(true);		// show
                gm.buttons[1].setEnabled(true);		// Evaluation
                gm.buttons[2].setEnabled(true);         // Intersection
                gm.buttons[3].setEnabled(true);         // Singular
                gm.buttons[4].setEnabled(false);	// Inflexion
                gm.buttons[5].setEnabled(false);	// Projection
                gm.buttons[6].setEnabled(true);		// Offset
                gm.buttons[7].setEnabled(false);	// Fillet
                gm.buttons[8].setEnabled(true);         // Tabcyl
                gm.buttons[9].setEnabled(true);         // Loft
            }
            else if (list.getSelectedValues().length == 2) {
                gm.buttons[0].setEnabled(true);		// show
                gm.buttons[1].setEnabled(false);	// Evaluation
                gm.buttons[2].setEnabled(false);	// Singular
                gm.buttons[3].setEnabled(false);	// Inflexion
                gm.buttons[4].setEnabled(true);		// Intersection
                gm.buttons[5].setEnabled(true);		// Projection
                gm.buttons[6].setEnabled(false);	// Offset
                gm.buttons[7].setEnabled(true);		// Fillet
                gm.buttons[8].setEnabled(false);	// Tabcyl
                gm.buttons[9].setEnabled(false);	// Loft
            }
            else {
                gm.buttons[0].setEnabled(true);		// show
                gm.buttons[1].setEnabled(false);	// Evaluation
                gm.buttons[2].setEnabled(false);	// Singular
                gm.buttons[3].setEnabled(false);	// Inflexion
                gm.buttons[4].setEnabled(false);	// Intersection
                gm.buttons[5].setEnabled(false);	// Projection
                gm.buttons[6].setEnabled(false);	// Offset
                gm.buttons[7].setEnabled(false);	// Fillet
                gm.buttons[8].setEnabled(false);	// Tabcyl
                gm.buttons[9].setEnabled(false);	// Loft
            }
        }
    }

    /*
     * {^ɊւCiNX
     */
    /**
     * "Show" {^ꂽƂ̂߂̃XiNX
     *
     * @see ActionListener
     * @see ActionEvent
     * @see JudanGeometryManager
     * @see JgclGeometry
     */
    public class ShowButton implements ActionListener {
        /**
         * eXg(g)
         */
        JudanGeometryManager gm;

        /**
	 * ͂ꂽIuWFNg̖O\邽߂̃Xg
	 * @see JList
	 */
        JList list;

        /**
	 * ͂ꂽIuWFNgƂ̖Oi[邽߂̃nbVe[u
	 * @see Hashtable
	 */
        Hashtable table;

        /**
         * t@C͌ JgclGeometry IuWFNg̔z
	 * @see JgclGeometry
         */
        JgclGeometry[] geometries;

        /**
         * JgclGeometry IuWFNg\
	 * @see JudanView
         */
        JudanView view;

        /**
         * RXgN^
         */
        ShowButton(JudanGeometryManager gm) {
            this.gm = gm;
        }

        /**
         * "Show" {^ꂽƂ̃ANV
         *
	 * @param Cxg
         * @see ActionEvent
         * @see JgclGeometry
         * @see JudanView
         * @see JudanViewWithJun
         */
        public void actionPerformed(ActionEvent e) {
	    int numberOfElement = gm.list.getSelectedValues().length;
            geometries = new JgclGeometry[numberOfElement];

	    for (int i = 0; i < numberOfElement; i++) {
		geometries[i] = (JgclGeometry)
		    (gm.table.get((String)gm.list.getSelectedValues()[i]));
	    }

	    if (checkOutput.isSelected())
		for (int i = 0; i < geometries.length; i++)
		    geometries[i].output(System.out);

	    if (checkDisplay.isSelected()) {
		view = new JudanView(new JudanViewWithJun()); 
		view.display(geometries);
	    }
        }
    }

    /**
     * "Evaluation" {^ꂽƂ̂߂̃XiNX
     *
     * @see ActionListener
     * @see ActionEvent
     * @see JudanGeometryManager
     * @see JgclGeometry
     */
    public class EvaluationButton implements ActionListener {
        /**
         * eXg(g)
         */
        JudanGeometryManager gm;

        /**
         * RXgN^
         */
        EvaluationButton(JudanGeometryManager gm) {
            this.gm = gm;
        }

        /**
         * "Evaluation" {^ꂽƂ̃ANV
         *
	 * @param Cxg
         * @see ActionEvent
         * @see JgclGeometry
         */
        public void actionPerformed(ActionEvent e) {
	    try {
		JgclGeometry geometry =
		    (JgclGeometry)(gm.table.get((String)gm.list.getSelectedValues()[0]));
		Object[] textObj = null;
		Class[] argClasses = null;
		Object[] argEntities = null;

		// Ȑ̏ꍇ(p[^1)
		if ((geometry instanceof jp.go.ipa.jgcl.JgclParametricCurve2D) ||
		    (geometry instanceof jp.go.ipa.jgcl.JgclParametricCurve3D)) {
		    JTextField text = new JTextField();
		    text.setBorder(new TitledBorder("Parameter"));
		    textObj = new Object[] {text};
		    int ans =
			JOptionPane.showConfirmDialog(gm, textObj, "Coordinate",
						      JOptionPane.OK_CANCEL_OPTION);
		    if (ans != 0) return;
		    
		    argClasses = new Class[] {Class.forName("java.lang.Double")};
		    argEntities = new Double[] {Double.valueOf(text.getText())};
		}
		// Ȗʂ̏ꍇ(p[^2)
		else if (geometry instanceof jp.go.ipa.jgcl.JgclParametricSurface3D) {
		    JTextField text1 = new JTextField();
		    text1.setBorder(new TitledBorder("uParameter"));
		    JTextField text2 = new JTextField();
		    text2.setBorder(new TitledBorder("vParameter"));
		    textObj = new Object[] {text1, text2};
		    int ans =
			JOptionPane.showConfirmDialog(gm, textObj, "Coordinate",
						      JOptionPane.OK_CANCEL_OPTION);
		    if (ans != 0) return;

		    argClasses = new Class[] {Class.forName("java.lang.Double"),
					      Class.forName("java.lang.Double")};
		    argEntities = new Double[] {Double.valueOf(text1.getText()),
						Double.valueOf(text2.getText())};
		}
		// ȖʁAȐȊO
		else {
		    System.out.println("not a suitable selection");
		    return;
		}
		// \bhIuWFNg̐
		JudanMethodWrapper method =
		    new JudanMethodWrapper(geometry, "coordinates",
					   argClasses, argEntities);
		// \bh̎sƌʂ̕\
		// KvɉāAo͂͐؂ւĂB
		method.invoke();
		if (checkOutput.isSelected())
		    method.output();
		if (checkDisplay.isSelected())
		    method.view();
	    }
	    catch (NumberFormatException ex){
		System.out.println("Number Format Exception!!");
	    }
	    catch (ClassNotFoundException ex) {
		System.out.println("Class Not Found Exception!!");
	    }
        }
    }

    /**
     * "Singular" {^ꂽƂ̂߂̃XiNX
     *
     * @see ActionListener
     * @see ActionEvent
     * @see JudanGeometryManager
     * @see JgclGeometry
     */
    public class SingularButton implements ActionListener {
        /**
         * eXg(g)
         */
        JudanGeometryManager gm;

        /**
         * RXgN^
         */
        SingularButton(JudanGeometryManager gm) {
            this.gm = gm;
        }

        /**
         * "Singular" {^ꂽƂ̃ANV
         *
	 * @param Cxg
         * @see ActionEvent
         * @see JgclGeometry
         */
        public void actionPerformed(ActionEvent e) {
	    JgclGeometry geometry =
		(JgclGeometry)(gm.table.get((String)gm.list.getSelectedValues()[0]));
	    Class[] argClasses = null;
	    Object[] argEntities = null;
	    if (geometry instanceof jp.go.ipa.jgcl.JgclParametricCurve) {
		argClasses = new Class[0];
		argEntities = new Double[0];
	    }
	    else {
		System.out.println("not a suitable selection");
		return;
	    }
	    JudanMethodWrapper method =
		new JudanMethodWrapper(geometry, "singular",
				       argClasses, argEntities);
	    // \bh̎sƌʂ̕\
	    // KvɉāAo͂͐؂ւĂB
	    method.invoke();
	    if (checkOutput.isSelected())
		method.output();
	    if (checkDisplay.isSelected())
		method.view();
	}
    }

    /**
     * "Inflexion" {^ꂽƂ̂߂̃XiNX
     *
     * @see ActionListener
     * @see ActionEvent
     * @see JudanGeometryManager
     * @see JgclGeometry
     */
    public class InflexionButton implements ActionListener {
        /**
         * eXg(g)
         */
        JudanGeometryManager gm;

        /**
         * RXgN^
         */
        InflexionButton(JudanGeometryManager gm) {
            this.gm = gm;
        }

        /**
         * "Inflexion" {^ꂽƂ̃ANV
         *
	 * @param Cxg
         * @see ActionEvent
         * @see JgclGeometry
         */
        public void actionPerformed(ActionEvent e) {
	    JgclGeometry geometry =
		(JgclGeometry)(gm.table.get((String)gm.list.getSelectedValues()[0]));
	    Class[] argClasses = null;
	    Object[] argEntities = null;
	    if (geometry instanceof jp.go.ipa.jgcl.JgclParametricCurve) {
		argClasses = new Class[0];
		argEntities = new Double[0];
	    }
	    else {
		System.out.println("not a suitable selection");
		return;
	    }
	    JudanMethodWrapper method =
		new JudanMethodWrapper(geometry, "inflexion",
				       argClasses, argEntities);
	    // \bh̎sƌʂ̕\
	    // KvɉāAo͂͐؂ւĂB
	    method.invoke();
	    if (checkOutput.isSelected())
		method.output();
	    if (checkDisplay.isSelected())
		method.view();
	}
    }

    /**
     * "Intersection" {^ꂽƂ̂߂̃XiNX
     *
     * @see ActionListener
     * @see ActionEvent
     * @see JudanGeometryManager
     * @see JgclGeometry
     */
    public class IntersectionButton implements ActionListener {
        /**
         * eXg(g)
         */
        JudanGeometryManager gm;

        /**
         * RXgN^
         */
        IntersectionButton(JudanGeometryManager gm) {
            this.gm = gm;
        }

        /**
         * "Intersection" {^ꂽƂ̃ANV
         *
	 * @param Cxg
         * @see ActionEvent
         * @see JgclGeometry
         */
        public void actionPerformed(ActionEvent e) {
            JgclGeometry[] geometries = new JgclGeometry[2];

            for (int i = 0; i < 2; i++) {
	        geometries[i] = (JgclGeometry)(gm.table.get(
                    (String)gm.list.getSelectedValues()[i]));
            }

	    Class[] argClasses = new Class[1];
	    Object[] argEntities = new Object[1];

	    try {
		if (geometries[0] instanceof jp.go.ipa.jgcl.JgclParametricCurve2D) {
		    argClasses[0] = Class.forName("jp.go.ipa.jgcl.JgclParametricCurve2D");
		    argEntities[0] = (JgclParametricCurve2D)geometries[1];
		}
		else if (geometries[0] instanceof jp.go.ipa.jgcl.JgclParametricCurve3D) {
		    if (geometries[1] instanceof jp.go.ipa.jgcl.JgclParametricCurve3D) {
			argClasses[0] = Class.forName("jp.go.ipa.jgcl.JgclParametricCurve3D");
			argEntities[0] = (JgclParametricCurve3D)geometries[1];
		    }
		    else if (geometries[1] instanceof jp.go.ipa.jgcl.JgclParametricSurface3D) {
			argClasses[0] = Class.forName("jp.go.ipa.jgcl.JgclParametricSurface3D");
			argEntities[0] = (JgclParametricSurface3D)geometries[1];
		    }
		    else {
			System.out.println("not a suitable selection");
		    }
		}
		else if (geometries[0] instanceof jp.go.ipa.jgcl.JgclParametricSurface3D) {
		    if (geometries[1] instanceof jp.go.ipa.jgcl.JgclParametricCurve3D) {
			argClasses[0] = Class.forName("jp.go.ipa.jgcl.JgclParametricCurve3D");
			argEntities[0] = (JgclParametricCurve3D)geometries[1];
		    }
		    else if (geometries[1] instanceof jp.go.ipa.jgcl.JgclParametricSurface3D) {
			argClasses[0] = Class.forName("jp.go.ipa.jgcl.JgclParametricSurface3D");
			argEntities[0] = (JgclParametricSurface3D)geometries[1];
		    }
		    else {
			System.out.println("not a suitable selection");
		    }
		}
		else {
		    System.out.println("not a suitable selection");
		}

		JudanMethodWrapper method =
		    new JudanMethodWrapper(geometries[0], "intersect",
					   argClasses, argEntities);
		// \bh̎sƌʂ̕\
		// KvɉāAo͂͐؂ւĂB
		method.invoke();
		if (checkOutput.isSelected())
		    method.output();
		if (checkDisplay.isSelected())
		    method.view();
	    }
	    catch (ClassNotFoundException ex) {
		System.out.println("Class Not Found Exception!!");
	    }
	}	
    }
	
    /**
     * "Projection" {^ꂽƂ̂߂̃XiNX
     *
     * @see ActionListener
     * @see ActionEvent
     * @see JudanGeometryManager
     * @see JgclGeometry
     */
    public class ProjectionButton implements ActionListener {
        /**
         * eXg(g)
         */
        JudanGeometryManager gm;

        /**
         * RXgN^
         */
        ProjectionButton(JudanGeometryManager gm) {
            this.gm = gm;
        }

        /**
         * "Projection" {^ꂽƂ̃ANV
         *
	 * @param Cxg
         * @see ActionEvent
         * @see JgclGeometry
         */
        public void actionPerformed(ActionEvent e) {
            JgclGeometry[] geometries = new JgclGeometry[2];

            for (int i = 0; i < 2; i++) {
	        geometries[i] = (JgclGeometry)(gm.table.get(
                    (String)gm.list.getSelectedValues()[i]));
            }

	    Class[] argClasses = new Class[1];
	    Object[] argEntities = new Object[1];
	    JudanMethodWrapper method = null;
	    try {
		if (((geometries[0] instanceof jp.go.ipa.jgcl.JgclParametricCurve2D) &&
		     (geometries[1] instanceof jp.go.ipa.jgcl.JgclPoint2D)) ||
		    ((geometries[1] instanceof jp.go.ipa.jgcl.JgclParametricCurve2D) &&
		     (geometries[0] instanceof jp.go.ipa.jgcl.JgclPoint2D))) {
		    JgclParametricCurve2D curve;
		    JgclPoint2D point;
		    if (geometries[0] instanceof jp.go.ipa.jgcl.JgclParametricCurve2D) {
			curve = (JgclParametricCurve2D)geometries[0];
			point = (JgclPoint2D)geometries[1];
		    } else {
			curve = (JgclParametricCurve2D)geometries[1];
			point = (JgclPoint2D)geometries[0];
		    }
		    argClasses[0] = Class.forName("jp.go.ipa.jgcl.JgclPoint2D");
		    argEntities[0] = point;
		    method = new JudanMethodWrapper(curve, "projectFrom",
						    argClasses, argEntities);
		}
		else if (((geometries[0] instanceof jp.go.ipa.jgcl.JgclParametricCurve3D) &&
			  (geometries[1] instanceof jp.go.ipa.jgcl.JgclPoint3D)) ||
			 ((geometries[1] instanceof jp.go.ipa.jgcl.JgclParametricCurve3D) &&
			  (geometries[0] instanceof jp.go.ipa.jgcl.JgclPoint3D))) {
		    JgclParametricCurve3D curve;
		    JgclPoint3D point;
		    if (geometries[0] instanceof jp.go.ipa.jgcl.JgclParametricCurve3D) {
			curve = (JgclParametricCurve3D)geometries[0];
			point = (JgclPoint3D)geometries[1];
		    } else {
			curve = (JgclParametricCurve3D)geometries[1];
			point = (JgclPoint3D)geometries[0];
		    }
		    argClasses[0] = Class.forName("jp.go.ipa.jgcl.JgclPoint3D");
		    argEntities[0] = point;
		    method = new JudanMethodWrapper(curve, "projectFrom",
						    argClasses, argEntities);
		}
		else if (((geometries[0] instanceof jp.go.ipa.jgcl.JgclParametricSurface3D) &&
			  (geometries[1] instanceof jp.go.ipa.jgcl.JgclPoint3D)) ||
			 ((geometries[1] instanceof jp.go.ipa.jgcl.JgclParametricSurface3D) &&
			  (geometries[0] instanceof jp.go.ipa.jgcl.JgclPoint3D))) {
		    JgclParametricSurface3D surface;
		    JgclPoint3D point;
		    if (geometries[0] instanceof jp.go.ipa.jgcl.JgclParametricSurface3D) {
			surface = (JgclParametricSurface3D)geometries[0];
			point = (JgclPoint3D)geometries[1];
		    } else {
			surface = (JgclParametricSurface3D)geometries[1];
			point = (JgclPoint3D)geometries[0];
		    }
		    argClasses[0] = Class.forName("jp.go.ipa.jgcl.JgclPoint3D");
		    argEntities[0] = point;
		    method = new JudanMethodWrapper(surface, "projectFrom",
						    argClasses, argEntities);
		}
		else {
		    System.out.println("not a suitable selection");
		}
		// \bh̎sƌʂ̕\
		// KvɉāAo͂͐؂ւĂB
		method.invoke();
		if (checkOutput.isSelected())
		    method.output();
		if (checkDisplay.isSelected())
		    method.view();
	    }
	    catch (ClassNotFoundException ex) {
		System.out.println("Class Not Found Exception!!");
	    }
        }
    }

    /**
     * "Fillet" {^ꂽƂ̂߂̃XiNX
     *
     * @see ActionListener
     * @see ActionEvent
     * @see JudanGeometryManager
     * @see JgclGeometry
     */
    public class FilletButton implements ActionListener {
        /**
         * eXg(g)
         */
        JudanGeometryManager gm;

        /**
         * RXgN^
         */
        FilletButton(JudanGeometryManager gm) {
            this.gm = gm;
        }

        /**
         * "Fillet" {^ꂽƂ̃ANV
         *
	 * @param Cxg
         * @see ActionEvent
         * @see JgclGeometry
         */
        public void actionPerformed(ActionEvent e) {
            JgclGeometry[] geometries = new JgclGeometry[2];

            for (int i = 0; i < 2; i++) {
	        geometries[i] = (JgclGeometry)(gm.table.get((String)gm.list.getSelectedValues()[i]));
            }
	    try {
		Object[] textObj = null;
		Class[] argClasses = null;
		Object[] argEntities = null;

		// 2DȐ̏ꍇ(p[^1)
		if ((geometries[0] instanceof jp.go.ipa.jgcl.JgclParametricCurve2D) &&
		    (geometries[1] instanceof jp.go.ipa.jgcl.JgclParametricCurve2D)) {
		    JTextField text = new JTextField();
		    JRadioButton rb1 = new JRadioButton("Left", true);
		    JRadioButton rb2 = new JRadioButton("Right");
		    ButtonGroup bg1 = new ButtonGroup();
		    JRadioButton rb3 = new JRadioButton("Left", true);
		    JRadioButton rb4 = new JRadioButton("Right");
		    ButtonGroup bg2 = new ButtonGroup();
		    JPanel bp = new JPanel(new GridLayout(2, 2));
		    bg1.add(rb1); bg1.add(rb2);
		    bg2.add(rb3); bg2.add(rb4);
		    bp.add(rb1); bp.add(rb3);
		    bp.add(rb2); bp.add(rb4);
		    text.setBorder(new TitledBorder("Radius"));
		    textObj = new Object[] {text, bp};

		    int ans =
			JOptionPane.showConfirmDialog(gm, textObj, "Fillet",
						      JOptionPane.OK_CANCEL_OPTION);
		    if (ans != 0) return;
		    
		    argClasses = new Class[] {Class.forName("jp.go.ipa.jgcl.JgclParameterSection"),
					      int.class,
					      Class.forName("jp.go.ipa.jgcl.JgclParametricCurve2D"),
					      Class.forName("jp.go.ipa.jgcl.JgclParameterSection"),
					      int.class,
					      double.class};
		    argEntities = new Object[6];
		    argEntities[0] = JudanSuitableParameterSection.asCurve(geometries[0]);
		    if (rb1.isSelected())
			argEntities[1] = new Integer(JgclWhichSide.LEFT);
		    else 
			argEntities[1] = new Integer(JgclWhichSide.RIGHT);
		    argEntities[2] = geometries[1];
		    argEntities[3] = JudanSuitableParameterSection.asCurve(geometries[1]);
		    if (rb3.isSelected())
			argEntities[4] = new Integer(JgclWhichSide.LEFT);
		    else 
			argEntities[4] = new Integer(JgclWhichSide.RIGHT);
		    argEntities[5] = Double.valueOf(text.getText());
		}
		// Ȗʂ̏ꍇ(p[^2)
		else if (geometries[0] instanceof jp.go.ipa.jgcl.JgclParametricSurface3D) {
		    JTextField text = new JTextField();
		    JRadioButton rb1 = new JRadioButton("Front", true);
		    JRadioButton rb2 = new JRadioButton("Back");
		    ButtonGroup bg1 = new ButtonGroup();
		    JRadioButton rb3 = new JRadioButton("Front", true);
		    JRadioButton rb4 = new JRadioButton("Back");
		    ButtonGroup bg2 = new ButtonGroup();
		    JPanel bp = new JPanel(new GridLayout(2, 2));
		    bg1.add(rb1); bg1.add(rb2);
		    bg2.add(rb3); bg2.add(rb4);
		    bp.add(rb1); bp.add(rb3);
		    bp.add(rb2); bp.add(rb4);
		    text.setBorder(new TitledBorder("Radius"));
		    textObj = new Object[] {text, bp};

		    int ans =
			JOptionPane.showConfirmDialog(gm, textObj, "Fillet",
						      JOptionPane.OK_CANCEL_OPTION);
		    if (ans != 0) return;

		    argClasses = new Class[] {Class.forName("jp.go.ipa.jgcl.JgclParameterSection"),
					      Class.forName("jp.go.ipa.jgcl.JgclParameterSection"),
					      int.class,
					      Class.forName("jp.go.ipa.jgcl.JgclParametricSurface3D"),
					      Class.forName("jp.go.ipa.jgcl.JgclParameterSection"),
					      Class.forName("jp.go.ipa.jgcl.JgclParameterSection"),
					      int.class,
					      double.class};
		    argEntities = new Object[8];
		    JgclParameterSection[] secs = JudanSuitableParameterSection.asSurface(geometries[0]);
		    argEntities[0] = secs[0];
		    argEntities[1] = secs[1];
		    if (rb1.isSelected())
			argEntities[2] = new Integer(JgclWhichSide.FRONT);
		    else 
			argEntities[2] = new Integer(JgclWhichSide.BACK);
		    argEntities[3] = geometries[1];
		    secs = JudanSuitableParameterSection.asSurface(geometries[1]);
		    argEntities[4] = secs[0];
		    argEntities[5] = secs[1];
		    if (rb1.isSelected())
			argEntities[6] = new Integer(JgclWhichSide.FRONT);
		    else 
			argEntities[6] = new Integer(JgclWhichSide.BACK);
		    argEntities[7] = Double.valueOf(text.getText());
		}
		// ȖʁAȐȊO
		else {
		    System.out.println("not a suitable selection");
		    return;
		}
		// \bhIuWFNg̐
		JudanMethodWrapper method = new JudanMethodWrapper(geometries[0], "fillet",
							     argClasses, argEntities);
		// \bh̎sƌʂ̕\
		// KvɉāAo͂͐؂ւĂB
		method.invoke();
		if (checkOutput.isSelected())
		    method.output();
		if (checkDisplay.isSelected())
		    method.view();
	    }
	    catch (NumberFormatException ex){
		System.out.println("Number Format Exception!!");
	    }
	    catch (ClassNotFoundException ex) {
		System.out.println("Class Not Found Exception!!");
	    }
        }
    }

    /**
     * "Offset" {^ꂽƂ̂߂̃XiNX
     *
     * @see ActionListener
     * @see ActionEvent
     * @see JudanGeometryManager
     * @see JgclGeometry
     */
    public class OffsetButton implements ActionListener {
        /**
         * eXg(g)
         */
        JudanGeometryManager gm;

        /**
         * RXgN^
         */
        OffsetButton(JudanGeometryManager gm) {
            this.gm = gm;
        }

        /**
         * "Offset" {^ꂽƂ̃ANV
         *
	 * @param Cxg
         * @see ActionEvent
         * @see JgclGeometry
         */
        public void actionPerformed(ActionEvent e) {
            JgclGeometry geometry;

	    geometry = (JgclGeometry)(gm.table.get((String)gm.list.getSelectedValues()[0]));
            
	    try {
		Object[] textObj = null;
		Class[] argClasses = null;
		Object[] argEntities = null;
		String functionName;

		// 2DȐ̏ꍇ(p[^1)
		if ((geometry instanceof jp.go.ipa.jgcl.JgclParametricCurve2D)){
		    JTextField text = new JTextField();
		    JRadioButton rb1 = new JRadioButton("Left", true);
		    JRadioButton rb2 = new JRadioButton("Right");
		    ButtonGroup bg = new ButtonGroup();
		    bg.add(rb1);
		    bg.add(rb2);
		    text.setBorder(new TitledBorder("Magni"));
		    textObj = new Object[] {text, rb1, rb2};
		    int ans =
			JOptionPane.showConfirmDialog(gm, textObj, "offset",
						      JOptionPane.OK_CANCEL_OPTION);

		    functionName = "offsetByBsplineCurve";
		    if (ans != 0) return;
		    
		    argClasses = new Class[] {Class.forName("jp.go.ipa.jgcl.JgclParameterSection"),
					      double.class,
					      int.class,
					      Class.forName("jp.go.ipa.jgcl.JgclToleranceForDistance")};
		    
		    argEntities = new Object[4];

		    JgclParameterSection pint = JudanSuitableParameterSection.asCurve(geometry);
		    argEntities[0] = pint;
		    argEntities[1] = Double.valueOf(text.getText());
		    if (rb1.isSelected()) {
			argEntities[2] = new Integer(JgclWhichSide.LEFT);
		    }
		    else {
			argEntities[2] = new Integer(JgclWhichSide.RIGHT);
		    }
		    argEntities[3] = new JgclToleranceForDistance(0.01);
		}
		// Ȗʂ̏ꍇ(p[^2)
		else if (geometry instanceof jp.go.ipa.jgcl.JgclParametricSurface3D) {
		    JTextField text = new JTextField();
		    JRadioButton rb1 = new JRadioButton("Front", true);
		    JRadioButton rb2 = new JRadioButton("Back");
		    ButtonGroup bg = new ButtonGroup();
		    bg.add(rb1);
		    bg.add(rb2);		    
		    text.setBorder(new TitledBorder("Magni"));
		    textObj = new Object[] {text, rb1, rb2};
		    int ans =
			JOptionPane.showConfirmDialog(gm, textObj, "Offset",
						      JOptionPane.OK_CANCEL_OPTION);
		    functionName = "offsetByBsplineSurface";
		    if (ans != 0) return;

		    argClasses = new Class[] {Class.forName("jp.go.ipa.jgcl.JgclParameterSection"),
					      Class.forName("jp.go.ipa.jgcl.JgclParameterSection"),
					      double.class,
					      int.class,
					      Class.forName("jp.go.ipa.jgcl.JgclToleranceForDistance")};
		    argEntities = new Object[5];
		    JgclParameterSection[] secs = JudanSuitableParameterSection.asSurface(geometry);
		    argEntities[0] = secs[0];
		    argEntities[1] = secs[1];

		    argEntities[2] = Double.valueOf(text.getText());
		    if (rb1.isSelected()) {
			argEntities[3] = new Integer(JgclWhichSide.FRONT);
		    }
		    else {
			argEntities[3] = new Integer(JgclWhichSide.BACK);
		    }
		    argEntities[4] = new JgclToleranceForDistance(0.01);
		}
		// ȖʁAȐȊO
		else {
		    System.out.println("not a suitable selection");
		    return;
		}

		// \bhIuWFNg̐
		JudanMethodWrapper method = 
		    new JudanMethodWrapper(geometry,
					functionName,
					argClasses,
					argEntities);

		// \bh̎sƌʂ̕\
		// KvɉāAo͂͐؂ւĂB
		method.invoke();
		if (checkOutput.isSelected())
		    method.output();
		if (checkDisplay.isSelected())
		    method.view();
	    }
	    catch (NumberFormatException ex){
		System.out.println("Number Format Exception!!");
	    }
	    catch (ClassNotFoundException ex) {
		System.out.println("Class Not Found Exception!!");
	    }
        }
    }

    /**
     * "Tabcyl" {^ꂽƂ̂߂̃XiNX
     *
     * @see ActionListener
     * @see ActionEvent
     * @see JudanGeometryManager
     * @see JgclGeometry
     */
    public class TabcylButton implements ActionListener {
        /**
         * eXg(g)
         */
        JudanGeometryManager gm;

        /**
         * RXgN^
         */
        TabcylButton(JudanGeometryManager gm) {
            this.gm = gm;
        }

        /**
         * "Tabcyl" {^ꂽƂ̃ANV
         *
	 * @param Cxg
         * @see ActionEvent
         * @see JgclGeometry
         */
        public void actionPerformed(ActionEvent e) {
            JgclGeometry[] geometries = new JgclGeometry[2];

            for (int i = 0; i < 2; i++) {
	        geometries[i] = (JgclGeometry)(gm.table.get(
                    (String)gm.list.getSelectedValues()[i]));
            }

	    Class[] argClasses = new Class[1];
	    Object[] argEntities = new Object[1];

	    try {
		if ((geometries[0] instanceof jp.go.ipa.jgcl.JgclBsplineSurface3D) &&
		    (geometries[1] instanceof jp.go.ipa.jgcl.JgclBsplineSurface3D)) {
		    argClasses = new Class[] { Class.forName("jp.go.ipa.jgcl.JgclBsplineCurve3D") };
		    argEntities[0] = (JgclBsplineCurve3D)geometries[1];
		}
		// BsplineCurve3D m̑gݍ킹ȊO
		else {
		    System.out.println("not a suitable selection");
		    return;
		}

		// \bhIuWFNg̐
		JudanMethodWrapper method = 
		    new JudanMethodWrapper(geometries[0],
					   "tabcylSurface",
					   argClasses,
					   argEntities);

		// \bh̎sƌʂ̕\
		// KvɉāAo͂͐؂ւĂB
		method.invoke();
		if (checkOutput.isSelected())
		    method.output();
		if (checkDisplay.isSelected())
		    method.view();
	    }
	    catch (ClassNotFoundException ex) {
		System.out.println("Class Not Found Exception!!");
	    }
        }
    }

    /**
     * "Loft" {^ꂽƂ̂߂̃XiNX
     *
     * @see ActionListener
     * @see ActionEvent
     * @see JudanGeometryManager
     * @see JgclGeometry
     */
    public class LoftButton implements ActionListener {
        /**
         * eXg(g)
         */
        JudanGeometryManager gm;

        /**
         * RXgN^
         */
        LoftButton(JudanGeometryManager gm) {
            this.gm = gm;
        }

        /**
         * "Loft" {^ꂽƂ̃ANV
         *
	 * @param Cxg
         * @see ActionEvent
         * @see JgclGeometry
         */
        public void actionPerformed(ActionEvent e) {
            JgclGeometry[] geometries = new JgclGeometry[2];

            for (int i = 0; i < 2; i++) {
	        geometries[i] = (JgclGeometry)(gm.table.get(
                    (String)gm.list.getSelectedValues()[i]));
            }

	    try {
		Object[] textObj = null;
		Class[] argClasses = null;
		Object[] argEntities = null;

		JgclBsplineCurve3D curve = null;
		JgclVector3D vector = null;
		if ((geometries[0] instanceof jp.go.ipa.jgcl.JgclBsplineCurve3D) &&
		    (geometries[1] instanceof jp.go.ipa.jgcl.JgclVector3D)) {
		    curve = (JgclBsplineCurve3D)geometries[0];
		    vector = (JgclVector3D)geometries[1];
		}
		else if ((geometries[1] instanceof jp.go.ipa.jgcl.JgclBsplineCurve3D) &&
			 (geometries[0] instanceof jp.go.ipa.jgcl.JgclVector3D)) {
		    curve = (JgclBsplineCurve3D)geometries[1];
		    vector = (JgclVector3D)geometries[0];
		}
		// BsplineCurve3D, Vector3D̑gݍ킹ȊO
		else {
		    System.out.println("not a suitable selection");
		    return;
		}

		JTextField text1 = new JTextField();
		text1.setBorder(new TitledBorder("parameter"));
		textObj = new Object[] {text1};
		int ans =
		    JOptionPane.showConfirmDialog(gm, textObj, "Loft",
						  JOptionPane.OK_CANCEL_OPTION);
		if (ans != 0) return;
		argClasses = new Class[] {Class.forName("jp.go.ipa.jgcl.JgclVector3D"),
					  Class.forName("java.lang.Double")};
		argEntities = new Object[] {vector,
					    Double.valueOf(text1.getText())};
		// \bhIuWFNg̐
		JudanMethodWrapper method =
		    new JudanMethodWrapper(curve, "loftSurface",
					   argClasses, argEntities);
		// \bh̎sƌʂ̕\
		// KvɉāAo͂͐؂ւĂB
		method.invoke();
		if (checkOutput.isSelected())
		    method.output();
		if (checkDisplay.isSelected())
		    method.view();
	    }
	    catch (NumberFormatException ex){
		System.out.println("Number Format Exception!!");
	    }
	    catch (ClassNotFoundException ex) {
		System.out.println("Class Not Found Exception!!");
	    }
        }
    }

    /**
     * RXgN^
     *
     * @param title ^Cgo[̖O
     * @see JMenuBar
     * @see JMenu
     * @see JMenuItem
     * @see ActionListener
     * @see BorderLayout
     * @see ListSelect
     * @see OpenMenu
     * @see ExitMenu
     */
    public JudanGeometryManager(String title) {
        /*
	 * ^Cgݒ肷
	 */
        setTitle(title);

        /*
         * j[o[ݒ肷
         */
        menuBar = new JMenuBar();
        setJMenuBar(menuBar);

        /*
         * j[ݒ肷 
         */
        JMenu menuFile = addMenu("File");
        JMenuItem menuItemFileOpen = addMenuItem("Open", new OpenMenu(this));
        menuFile.add(menuItemFileOpen);
        menuFile.addSeparator();
        JMenuItem menuItemFileExit = addMenuItem("Exit", new ExitMenu());
        menuFile.add(menuItemFileExit);

        /*
         * IXgݒ肷
         */
        setList(new ListSelect(this));

        /*
         * {^ݒ肷
         */
        String[] buttonName = {"Show", "Evaluation", "Singular", "Inflexion",
                               "Intersection", "Projection", "Offset", "Fillet",
			       "Tabcyl", "Loft" };
        ActionListener[] listenerList = { new ShowButton(this),
                                          new EvaluationButton(this),
                                          new SingularButton(this),
                                          new InflexionButton(this),
                                          new IntersectionButton(this),
                                          new ProjectionButton(this),
                                          new OffsetButton(this),
                                          new FilletButton(this),
                                          new TabcylButton(this),
                                          new LoftButton(this) };

	/*
	 * `FbN{bNXݒ肷
	 */
	checkOutput = new JCheckBox("ASCII", true);
	checkDisplay = new JCheckBox("Jun", true);
	JPanel checkPanel = new JPanel(new GridLayout(1, 2));
	checkPanel.add(checkOutput);
	checkPanel.add(checkDisplay);

        /*
         * eĩCAEg߂Ĕzu
         */
	// `FbN{bNX{^̏ɔzu
	buttonPanel = new JPanel(new GridLayout(buttonName.length + 1, 1));
	buttonPanel.add(checkPanel);

	// {^1ɕׂ
        setButtonPanel(buttonName, listenerList);

	// Xgƃ{^̔zu
        getContentPane().add(listPane, BorderLayout.CENTER);
        getContentPane().add(buttonPanel, BorderLayout.EAST);

	// EBhETCYƎo
        setSize(500,300);
        setVisible(true);
    }

    /**
     * plݒ肷
     *
     * @param buttons		{^̔z
     * @see JButton
     */
    public void setButtonPanel(JButton[] buttons) {
        for (int i = 0; i < buttons.length; i++) {
            buttonPanel.add(buttons[i]);
        }
    }

    /**
     * plݒ肷
     *
     * @param buttonNames {^̖O̔z
     * @param listenerClasses	Xi̔z
     * @see JButton
     * @see GridLayout
     * @see ActionListener
     */
    public void setButtonPanel(String[] buttonNames,
			       ActionListener[] listenerClasses) {
        int numberOfButtons = buttonNames.length;
	buttons = new JButton[numberOfButtons];
	for (int i = 0; i < numberOfButtons; i++) {
	    buttons[i] = new JButton(buttonNames[i]);
	    buttons[i].addActionListener(listenerClasses[i]);
	    buttons[i].setEnabled(false);
	    buttonPanel.add(buttons[i]);
	}
    }

    /**
     * {^쐬
     *
     * @param name {^̖O
     * @param listener	Xi
     * @return ꂽ{^
     * @see JButton
     * @see ActionListener
     */
    public JButton createButton(String name, ActionListener listener) {
        JButton button = new JButton(name);
        button.addActionListener(listener);
        return button;
    }

    public void addName(String name){
        ((DefaultListModel)list.getModel()).addElement(name);        
    }

    /**
     * Xgݒ肷
     *
     * @param listModel		 Xĝ߂̃f
     * @param listSelectionModel IXĝ߂̃f
     * @param listener		 Xg̑Im邽߂̃Xi
     * @see JList
     * @see JScrollPane
     * @see ListModel
     * @see LiseSelectionModel
     * @see ListSelectionListener
     */
    public void setList(ListModel listModel, 
			ListSelectionModel listSelectionModel,
			ListSelectionListener listener) {
        list = new JList(listModel);
	list.setSelectionModel(listSelectionModel);
        list.addListSelectionListener(listener);
        listPane = new JScrollPane(list);
    }

    /**
     * Xgݒ肷
     *
     * @param listModel               Xĝ߂̃f
     * @param listener		      Xg̑Im邽߂̃Xi
     * @see DefaultListSelectionModel
     * @see ListSelectionListener
     */
    public void setList(ListModel listModel, ListSelectionListener listener) {
        setList(listModel, new DefaultListSelectionModel(), listener);
    }

    /**
     * Xgݒ肷
     *
     * @param listener		Xg̑Im邽߂̃Xi
     * @see DefaultListModel
     * @see ListSelectionListener
     */
    public void setList(ListSelectionListener listener) {
        setList(new DefaultListModel(), listener);
    }

    /**
     * j[̒ǉs
     *
     * @param menuName	j[̖O
     * @return			j[o[ɒǉꂽj[
     * @see JMenu
     */
    protected JMenu addMenu(String menuName) {
        JMenu menu = new JMenu(menuName);
        menuBar.add(menu);

        return menu;
    }

    /**
     * j[ڂ̒ǉs
     *
     * @param itemName	j[ڂ̖O
     * @param listener	j[ڑĨANVXi
     * @return			ꂽj[
     * @see JMenuItem
     * @see ActionListener
     */
    protected JMenuItem addMenuItem(String itemName,
                                    ActionListener listener){
        JMenuItem menuItem = new JMenuItem(itemName);
        menuItem.addActionListener(listener);

        return menuItem;
    }

    /**
     * main \bh
     */
    public static void main(String[] args){
        JudanGeometryManager gm =
	    new JudanGeometryManager("JGCL Geometry Manager");
//          gm.setSize(400,200);
//          gm.setVisible(true);
    }
}
