/*
 * Q Voronoi }\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclVoronoiDiagram2D.java,v 1.11 2000/04/26 09:39:28 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * Q Voronoi }\NXB
 * <br><br>
 * ̃NX̃CX^X́A
 * Voronoi }̈ʑێ
 * {@link JgclEmbeddedGraph JgclEmbeddedGraph}
 * ̃CX^X graph B
 * <br><br>
 * graph ̊e {@link JgclEmbeddedGraph.Face JgclEmbeddedGraph.Face}  userData ɂ́A
 * {@link JgclVoronoiDiagram2D.VRegion JgclVoronoiDiagram2D.VRegion} ̃CX^X֘AtB
 * <br><br>
 * lɁA
 * graph ̊e_ {@link JgclEmbeddedGraph.Vertex JgclEmbeddedGraph.Vertex}  userData ɂ́A
 * {@link JgclVoronoiDiagram2D.VPoint JgclVoronoiDiagram2D.VPoint} ̃CX^X֘AtB
 *
 * @version $Revision: 1.11 $, $Date: 2000/04/26 09:39:28 $
 * @author Information-technology Promotion Agency, Japan
 */
public class JgclVoronoiDiagram2D extends java.lang.Object {
    /**
     * _̐߂̈ (Voronoi ̈) \NXB
     */
    public class VRegion {
	/**
	 * _̔ԍB
	 */
	private int index;

	/**
	 * _̍WlB
	 * <p>
	 * ^ꂽWl xScale, yScale lB
	 * </p>
	 */
	private JgclPoint2D coordinates;

	/**
	 * _̐߂̈\ʁB
	 * <p>
	 * Face  userData ɂ Voronoi ̈֘AtB
	 * </p>
	 */
	private JgclEmbeddedGraph.Face face;

	/**
	 * [U̗^Cӂ̃f[^B
	 */
	private java.lang.Object userData;

	/**
	 * _̏^ăIuWFNg\zB
	 *
	 * @param index	_̔ԍ
	 * @param coordinates	_̍Wl
	 */
	VRegion(int index,
		JgclPoint2D coordinates) {
	    this.index = index;
	    this.coordinates = coordinates;
	    this.face = null;
	    this.userData = null;
	}

	/**
	 * ̗̈̕_̔ԍԂB
	 *
	 * @return	_̔ԍ
	 */
	public int getIndex() {
	    return this.index;
	}

	/**
	 * ̗̈̕_̍WlԂB
	 *
	 * @return	_̍Wl
	 */
	public JgclPoint2D getCoordinates() {
	    return this.coordinates;
	}

	/**
	 * ̗̈ɑΉuOt̖ʁvݒ肷B
	 *
	 * @param face	Ot̖
	 */
	void setFace(JgclEmbeddedGraph.Face face) {
	    this.face = face;
	}

	/**
	 * ̗̈ɑΉuOt̖ʁvԂB
	 *
	 * @return	Ot̖
	 */
	public JgclEmbeddedGraph.Face getFace() {
	    return this.face;
	}

	/**
	 * ^ꂽIuWFNgÄ̗Ɋ֌Wf[^ƂĐݒ肷B
	 *
	 * @param userData	Cӂ̃IuWFNg
	 */
	public void setUserData(java.lang.Object userData) {
	    this.userData = userData;
	}

	/**
	 * ̗̈Ɋ֌Wf[^ƂĐݒ肳ĂIuWFNgԂB
	 *
	 * @return	Cӂ̃IuWFNg
	 */
	public java.lang.Object getUserData() {
	    return this.userData;
	}

	/**
	 * ̗̈̎͂ Voronoi _ Enumeration (CCWA) ԂB
	 * <p>
	 * ʂƂē Enumeration ܂ޗvf
	 * {@link JgclVoronoiDiagram2D.VPoint JgclVoronoiDiagram2D.VPoint}
	 * ̃CX^XłB
	 * </p>
	 *
	 * @return	͂ Voronoi _ Enumeration
	 */
	public Enumeration getVPointCycleInCCW() {
	    return new Enumeration() {
		Enumeration e = face.getVertexCycleInCCW().elements();

		public boolean hasMoreElements() {
		    return e.hasMoreElements();
		}

		public java.lang.Object nextElement() {
		    return ((JgclEmbeddedGraph.Vertex)e.nextElement()).getUserData();
		}
	    };
	}
    }

    /**
     * Voronoi ̈͂ޒ_ (Voronoi _) \NXB
     */
    public class VPoint {
	/**
	 * _̍WlB
	 */
	private JgclPoint2D coordinates;

	/**
	 * _ɍł߂_̋B
	 */
	private double distance;

	/**
	 * [U̗^Cӂ̃f[^B
	 */
	private java.lang.Object userData;

	/**
	 * _̍Wl^ăIuWFNg\zB
	 *
	 * @param coordinates	_̍Wl
	 */
	VPoint(JgclPoint2D coordinates) {
	    this.coordinates = coordinates;
	    this.distance = (- 1.0);
	    this.userData = null;
	}

	/**
	 * ̒_̍WlԂB
	 *
	 * @return	_̍Wl
	 */
	public JgclPoint2D getCoordinates() {
	    return this.coordinates;
	}

	/**
	 * ̒_ɍł߂_̋ݒ肷B
	 *
	 * @param distance	_ɍł߂_̋
	 */
	void setDistance(double distance) {
	    this.distance = distance;
	}

	/**
	 * ̒_ɍł߂_̋ԂB
	 *
	 * @return	_ɍł߂_̋
	 */
	public double getDistance() {
	    return this.distance;
	}

	/**
	 * ^ꂽIuWFNgA̒_Ɋ֌Wf[^ƂĐݒ肷B
	 *
	 * @param userData	Cӂ̃IuWFNg
	 */
	public void setUserData(java.lang.Object userData) {
	    this.userData = userData;
	}

	/**
	 * ̒_Ɋ֌Wf[^ƂĐݒ肳ĂIuWFNgԂB
	 *
	 * @return	Cӂ̃IuWFNg
	 */
	public java.lang.Object getUserData() {
	    return this.userData;
	}
    }

    /**
     * Voronoi }̈ʑێOtB
     */
    private JgclEmbeddedGraph graph;

    /**
     * Voronoi ̈̔zB
     * <p>
     * regions[i]  i Ԗڂ̕_ɑΉB
     * </p>
     */
    private VRegion[] regions;

    /**
     * d_ (= Voronoi ̈) ̃XgB
     */
    private Vector coincidingRegions;

    /**
     * _̍Wl X ̏kڔ{B
     */
    private double xScale;

    /**
     * _̍Wl Y ̏kڔ{B
     */
    private double yScale;

    /**
     * oオ Voronoi }͂މ~̔ȃ傫K肷{B
     * <p>
     * ̒l傫肷͂łB
     * </p>
     */
    private double radiusScale;

    /**
     * oオ Voronoi }͂މ~̔ȃ傫K肷{̃ftHglB
     */
    public static final double radiusScaleDefault = 100.0;

    /**
     * _̋K肷{B
     */
    private static final double farScale = 30.0;

    /**
     * GbW𕪊ۂ̌_ZɓKp鉉ZB
     */
    private static JgclConditionOfOperation conditionWithSmallDTol = null;

    /**
     * ^ꂽ_ȓ_Q̊e__Ƃ Voronoi }ƂăIuWFNg\zB
     * <p>
     * seed ɂ́A\z΂̋̃Ot^B
     * </p>
     *
     * @param seed	ꂽ Voronoi }̈ʑێ邽߂̃Ot
     * @param points	_̏W (_ȓ_Q)
     */
    public JgclVoronoiDiagram2D(JgclEmbeddedGraph seed,
				Enumeration points) {
	super();
	createDiagram(seed, points, 1.0, 1.0, radiusScaleDefault);
    }

    /**
     * ^ꂽ_ȓ_Q̊e__Ƃ Voronoi }ƂăIuWFNg\zB
     * <p>
     * e_ points[i] ̍WĺA
     * points[i].x() * xScale, points[i].y() * yScale
     * ƂȂB
     * </p><p>
     * seed ɂ́A\z΂̋̃Ot^B
     * </p>
     *
     * @param seed	ꂽ Voronoi }̈ʑێ邽߂̃Ot
     * @param points	_̏W (_ȓ_Q)
     * @param xScale	_̍Wl X ̏kڔ{
     * @param yScale	_̍Wl Y ̏kڔ{
     */
    public JgclVoronoiDiagram2D(JgclEmbeddedGraph seed,
				Enumeration points,
				double xScale,
				double yScale) {
	super();
	createDiagram(seed, points, xScale, yScale, radiusScaleDefault);
    }

    /**
     * ^ꂽ_ȓ_Q̊e__Ƃ Voronoi }ƂăIuWFNg\zB
     * <p>
     * e_ points[i] ̍WĺA
     * points[i].x() * xScale, points[i].y() * yScale
     * ƂȂB
     * </p><p>
     * seed ɂ́A\z΂̋̃Ot^B
     * </p>
     *
     * @param seed	ꂽ Voronoi }̈ʑێ邽߂̃Ot
     * @param points	_̏W (_ȓ_Q)
     * @param xScale	_̍Wl X ̏kڔ{
     * @param yScale	_̍Wl Y ̏kڔ{
     * @param radiusScale	oオ Voronoi }͂މ~̔ȃ傫K肷{
     */
    public JgclVoronoiDiagram2D(JgclEmbeddedGraph seed,
				Enumeration points,
				double xScale,
				double yScale,
				double radiusScale) {
	super();
	createDiagram(seed, points, xScale, yScale, radiusScale);
    }

    /**
     * ^ꂽ_ȓ_Q̊e__Ƃ Voronoi }쐬B
     * <p>
     * seed ɂ́A\z΂̋̃Ot^B
     * </p>
     *
     * @param seed	ꂽ Voronoi }̈ʑێ邽߂̃Ot
     * @param givenPoints	_̏W (_ȓ_Q)
     * @param xScale	_̍Wl X ̏kڔ{
     * @param yScale	_̍Wl Y ̏kڔ{
     * @param radiusScale	oオ Voronoi }͂މ~̔ȃ傫K肷{
     */
    private void createDiagram(JgclEmbeddedGraph seed,
			       Enumeration givenPoints,
			       double xScale,
			       double yScale,
			       double radiusScale) {
	/*
	 * Óǂ`FbN
	 */
	if (!(xScale > 0.0))
	    throw new JgclInvalidArgumentValue("xScale should be positive.");

	if (!(yScale > 0.0))
	    throw new JgclInvalidArgumentValue("yScale should be positive.");

	if (!(radiusScale > 0.0))
	    throw new JgclInvalidArgumentValue("radiusScale should be positive.");

	/*
	 * givenPoints  Vector ɕϊ
	 */
	Vector points = new Vector();
	for (;givenPoints.hasMoreElements();)
	    points.addElement(givenPoints.nextElement());

	int nPoints = points.size();
	if (nPoints < 2)
	    throw new JgclInvalidArgumentValue("The number of given points is too small.");

	/*
	 * CX^X̃tB[hɒlݒ肷
	 */
	this.graph = seed;

	this.regions = new VRegion[nPoints];
	this.coincidingRegions = new Vector();

	this.xScale = xScale;
	this.yScale = yScale;
	this.radiusScale = radiusScale;

	/*
	 * e_̍Wl𓾂āAXP[O{
	 */
	JgclPoint2D[] scaledPoints = new JgclPoint2D[nPoints];

	for (int i = 0; i < nPoints; i++) {
	    JgclPoint2D givenPoint = (JgclPoint2D)points.elementAt(i);
	    scaledPoints[i] = new JgclCartesianPoint2D(givenPoint.x() * this.xScale,
						       givenPoint.y() * this.yScale);
	    this.regions[i] = this.new VRegion(i, scaledPoints[i]);
	}

	/*
	 * }邽߂ɁAoオ Voronoi }mɈ͂ނ悤ȉ~߂
	 */
	JgclEnclosingBox2D box = new JgclEnclosingBox2D(scaledPoints);
	JgclPoint2D center = box.min().linearInterpolate(box.max(), 0.5);
	double radius = this.radiusScale *
	    center.distance(center.longestPoint(scaledPoints));

	/*
	 * ⏕̎O_ŏ}
	 */
	JgclEmbeddedGraph.Vertex[] extraPoints = new JgclEmbeddedGraph.Vertex[3];
	VRegion[] extraRegions = new VRegion[3];
	VRegion lastAddedRegion;

	lastAddedRegion = makeInitialDiagram(center, radius,
					     extraPoints, extraRegions);

	/*
	 * }ɁAe_𑫂Ă
	 */
	for (int i = 0; i < nPoints; i++)
	    lastAddedRegion = addPoint(i, null, lastAddedRegion);

	/*
	 * }̎c[폜
	 */
	removeExtraFaces(extraPoints, extraRegions);
    }

    /**
     * ⏕̎O_ŏ}B
     *
     * @param center	oオ Voronoi }͂މ~̒S
     * @param radius	oオ Voronoi }͂މ~̔a
     * @param extraPoints	 Voronoi _Ԃ߂̔z (o)
     * @param extraRegions	 Voronoi ̈Ԃ߂̔z (o)
     */
    private VRegion makeInitialDiagram(JgclPoint2D center,
				       double radius,
				       JgclEmbeddedGraph.Vertex[] extraPoints,
				       VRegion[] extraRegions) {
	double degree30;	// 30 x
	double cos30;		// cos(30 x)
	double sin30;		// sin(30 x)

	double farDist;		// S牓_ (Voronoi _) ܂ł̋

	double rr;		// _̐
	double qq;		// _̐

	JgclEmbeddedGraph.Result opResult;	// Euler ̌
	JgclEmbeddedGraph.Vertex origVrtx;	// S (Voronoi _)
	JgclEmbeddedGraph.Face outerFace;	// O̖

	VPoint vpnt;	// Voronoi _

	JgclVector2D vectorInitialPoint = null;	// S珉_ւ̃xNg
	JgclVector2D vectorFarPoint = null;	// S牓_ւ̃xNg

	/*
	 * O̏_̍Wl߂邽߂ɕKvȒlpӂ
	 */
	degree30 = Math.PI / 6.0;
	cos30 = Math.cos(degree30);
	sin30 = Math.sin(degree30);
	farDist = radius * farScale;

	rr = (3.0 * Math.sqrt(2.0) * radius) / 4.0;
	qq = Math.sqrt(3.0) * rr;

	/*
	 * ܂uSv Voronoi _u
	 */
	opResult = this.graph.makeVertexFace();
	origVrtx = opResult.vrtx;
	outerFace = opResult.face;

	vpnt = new VPoint(center);
	vpnt.setDistance(2.0 * rr);	// S|_Ԃ̋
	origVrtx.setUserData(vpnt);

	// O̖ʂɑΉ Voronoi ̈͂Ȃ
	outerFace.setUserData(null);

	/*
	 * O̏_ (Voronoi ̈) & Voronoi _
	 */
	for (int i = 0; i < 3; i++) {
	    /*
	     * ϓȊԊuōWl߂
	     */
	    switch (i) {
	    case 0:
		vectorInitialPoint = new JgclLiteralVector2D(0.0, (2.0 * rr));
		vectorFarPoint = new JgclLiteralVector2D((farDist * cos30),
							 (farDist * sin30));
		break;

	    case 1:
		vectorInitialPoint = new JgclLiteralVector2D((- qq), (- rr));
		vectorFarPoint = new JgclLiteralVector2D((- farDist * cos30),
							 (farDist * sin30));
		break;

	    case 2:
		vectorInitialPoint = new JgclLiteralVector2D(qq, (- rr));
		vectorFarPoint = new JgclLiteralVector2D(0.0, (- farDist));
		break;
	    }

	    /*
	     * Voronoi _
	     */
	    opResult = this.graph.makeEdgeVertex(outerFace, origVrtx);
	    extraPoints[i] = opResult.vrtx;

	    vpnt = new VPoint(center.add(vectorFarPoint));
	    vpnt.setDistance(- 1.0);
	    extraPoints[i].setUserData(vpnt);

	    /*
	     *  Voronoi ̈
	     */
	    extraRegions[i] = new VRegion((- (i + 101)),
					  center.add(vectorInitialPoint));

	    switch (i) {
	    case 0:	// ܂Ȃ
		break;

	    case 1:	// 
		opResult = this.graph.makeEdgeFace(outerFace, extraPoints[1], extraPoints[0]);
		extraRegions[0].setFace(opResult.face);
		opResult.face.setUserData(extraRegions[0]);
		break;

	    case 2:	// 
		opResult = this.graph.makeEdgeFace(outerFace, extraPoints[2], extraPoints[1]);
		extraRegions[1].setFace(opResult.face);
		opResult.face.setUserData(extraRegions[1]);

		opResult = this.graph.makeEdgeFace(outerFace, extraPoints[0], extraPoints[2]);
		extraRegions[2].setFace(opResult.face);
		opResult.face.setUserData(extraRegions[2]);
		break;
	    }
	}

	/*
	 * (芸) Ōɍ Voronoi ̈Ԃ
	 */
	return extraRegions[2];
    }

    /**
     * ̈̈ꕔ Voronoi ̈ƁA
     *  Voronoi ̈𕪊 Euler 
     * Vɂł̖ʂ̑g\NXB
     */
    private class RegionAndFace {
	/**
	 * ̈̈ꕔ Voronoi ̈B
	 */
	VRegion rgn;

	/**
	 * rgn 𕪊 Euler ŁAVɂł̖ʁB
	 */
	JgclEmbeddedGraph.Face face;

	/**
	 * rgn 𕪊 Euler ȍ~Aface 폜ꂽۂB
	 */
	boolean faceKilled;

	/**
	 * IuWFNg\zB
	 *
	 * @param rgn	 Voronoi ̈
	 * @param face	rgn 𕪊 Euler ŁAVɂł̖
	 */
	RegionAndFace(VRegion rgn,
		      JgclEmbeddedGraph.Face face) {
	    this.rgn = rgn;
	    this.face = face;
	    this.faceKilled = false;
	}

	/**
	 * ^ꂽʂÃCX^XɊ֌WʂłȂ΁A
	 * faceKilled ^ɂB
	 *
	 * @param face	
	 * @return	face ̃CX^XɊ֌WȂ^
	 */
	boolean killFaceIfGivenIsIt(JgclEmbeddedGraph.Face face) {
	    if (this.face != face)
		return false;

	    this.faceKilled = true;
	    return true;
	}

	/**
	 * ʂ𕪊ۂɐVɂł̖ʂcĂāA
	 * ̖ʂuVɂł Voronoi ̈vłȂȂ΁A
	 * ꕔꂽ Voronoi ̈ƃOt̖ʂ̑ΉB
	 *
	 * @param newFace	Vɂł Voronoi ̈\
	 */
	void reAssociate(JgclEmbeddedGraph.Face newFace) {
	    if ((this.faceKilled == true) || (this.face == newFace))
		return;

	    /*
	     * d_̂ꂼ (ccr) ɂ
	     * ccr ֌Wʂ rgn ֌WʂȂ΁A
	     * ccr ֌Wʂ face ɂ
	     */
	    VRegion ccr;
	    for (Enumeration e = JgclVoronoiDiagram2D.this.coincidingRegions.elements();
		 e.hasMoreElements();) {
		ccr = (VRegion)e.nextElement();
		if (ccr.getFace() == this.rgn.getFace())
		    ccr.setFace(this.face);
	    }

	    /*
	     * rgn  face ̑Ή
	     */
	    this.rgn.setFace(this.face);
	    this.face.setUserData(this.rgn);
	}
    }

    /**	
     * GbW̗ʂۂAԂB
     *
     * @param edge	GbW
     * @return	ʂȂ΁A̖ʁAłȂ null
     */
    private JgclEmbeddedGraph.Face edgeHasSameFace(JgclEmbeddedGraph.Edge edge) {
	JgclEmbeddedGraph.Face[] faces = edge.getFaces();

	if (faces[0] == faces[1])
	    return faces[0];	// ̖

	return null;
    }

    /**
     * GbŴǂ炩̒[Ǘ_ۂAԂB
     *
     * @param edge	GbW
     * @return	Ǘ_ȂA̒_AłȂ null
     */
    private JgclEmbeddedGraph.Vertex edgeHasIsolateVertex(JgclEmbeddedGraph.Edge edge) {
	JgclEmbeddedGraph.Vertex[] v = edge.getVertices();

	for (int i = 0; i < 2; i++) {
	    if (v[i].getEdgeCycleInCCW().size() == 1)
		return v[i];
	}

	return null;
    }

    /**
     * ^ꂽGbW폜B
     *
     * @param edges	폜GbW̃Xg
     * @param RandF	̈̈ꕔ Voronoi ̈ƁAVɂłʂ̑g̃Xg
     * @return	폜ׂGbW폜ʁAV Voronoi ̈ƂĎc
     */
    private JgclEmbeddedGraph.Face killEdges(Vector edges,
					     Vector RandF) {
	JgclEmbeddedGraph.Face lastFace = null;

	// 폜ׂGbW邠
	while (edges != null) {
	    Vector remainedEdges = null;

	    // 폜ׂGbŴꂼɂ
	    for (Enumeration e = edges.elements(); e.hasMoreElements();) {
		JgclEmbeddedGraph.Edge edge = (JgclEmbeddedGraph.Edge)e.nextElement();
		if ((lastFace = edgeHasSameFace(edge)) != null) {
		    // GbW̗ʂȂA
		    if (edgeHasIsolateVertex(edge) != null) {
			// ̃GbŴǂ炩̒[Ǘ_Ȃ
			// ̃GbW폜
			this.graph.killEdgeVertex(edge);
			// Ȃ݂Ƀ[v̍Ō͕Kʂ
		    } else {
			// ̃GbW̗[ɑ̃GbWȂĂȂ
			// ̃GbW̍폜͐ɉ΂
			if (remainedEdges == null)
			    remainedEdges = new Vector();
			remainedEdges.addElement(edge);
		    }
		} else {
		    // GbW̗ႤʂȂA
		    //  (Ƃ肠AE̖ʂƋ) ̃GbW폜
		    JgclEmbeddedGraph.Face rightFace = edge.getRightFace();
		    for (Enumeration e1 = RandF.elements(); e1.hasMoreElements();) {
			RegionAndFace RF = (RegionAndFace)e1.nextElement();
			if (RF.killFaceIfGivenIsIt(rightFace) == true)
			    break;
		    }
		    this.graph.killEdgeFace(edge, rightFace);
		}
	    }

	    edges = remainedEdges;
	}

	// 폜ׂGbW폜ʁAV Voronoi ̈Ƃ
	// cʂԂ
	return lastFace;
    }

    /**
     * Voronoi }ɐV Voronoi ̈͂ߍށB
     *
     * @param newRegion	V Voronoi ̈
     * @param T	폜ׂ Voronoi _̃Xg
     */
    private void addRegion(VRegion newRegion,
			   Vector T) {
	JgclPoint2D newRegionCoord = newRegion.getCoordinates();

	Vector newVrtcs = new Vector();	// GbW𕪊ĂłVȒ_
	Vector rmvEdges = new Vector();	// 폜ׂGbW
	Vector dvdFaces = new Vector();	// 
	Vector dvdRandF = new Vector();	// ̈ƐVɂłʂ̑g

	JgclEmbeddedGraph.Result opResult;	// Euler ̌

	/*
	 * T  폜ׂ Voronoi _̂ꂼ
	 */
	for (Enumeration e0 = T.elements(); e0.hasMoreElements();) {
	    JgclEmbeddedGraph.Vertex vrtx =
		(JgclEmbeddedGraph.Vertex)e0.nextElement();

	    // ͂̃GbŴꂼɂ
	    for (Enumeration e1 = vrtx.getEdgeCycleInCCW().elements();
		 e1.hasMoreElements();) {
		JgclEmbeddedGraph.Edge edge =
		    (JgclEmbeddedGraph.Edge)e1.nextElement();

		// GbW̗[ T Ɋ܂܂Ă΁A
		// 폜GbW̃Xgɉ
		JgclEmbeddedGraph.Vertex anotherVrtx = anotherEnd(edge, vrtx);
		if (T.contains(anotherVrtx) == true) {
		    if (edgeIsContained(rmvEdges, edge) != true)
			rmvEdges.addElement(edge);
		    continue;
		}

		// GbW𕪊 : GbW̒ԂɐV Voronoi _
		opResult = this.graph.makeVertexEdge(edge);
		JgclEmbeddedGraph.Vertex newVrtx = opResult.vrtx;
		JgclEmbeddedGraph.Edge newEdge = opResult.edge;
		setMiddlePoint(edge, vrtx, anotherVrtx, newVrtx, newRegionCoord);

		newVrtcs.addElement(newVrtx);

		// GbẄ (폜 Voronoi _܂ޕ) 
		// 폜GbW̃Xgɉ
		JgclEmbeddedGraph.Edge rmvEdge =
		    (anotherEnd(edge, newVrtx) == vrtx) ? edge : newEdge;
		if (edgeIsContained(rmvEdges, rmvEdge) != true)
		    rmvEdges.addElement(rmvEdge);

		// GbW̗̖ʂuʂ̃Xgvɉ
		JgclEmbeddedGraph.Face[] twoFaces = edge.getFaces();
		if (dvdFaces.contains(twoFaces[0]) != true)
		    dvdFaces.addElement(twoFaces[0]);
		if (dvdFaces.contains(twoFaces[1]) != true)
		    dvdFaces.addElement(twoFaces[1]);
	    }
	}

	/*
	 * GbW𕪊čV Voronoi _ԃGbW
	 * ܂Aׂʂ𕪊
	 */

	// ׂʂ̂ꂼɂ
	for (Enumeration e0 = dvdFaces.elements(); e0.hasMoreElements();) {
	    JgclEmbeddedGraph.Face face = (JgclEmbeddedGraph.Face)e0.nextElement();

	    // ̖ʂɑΉuV Voronoi _ ()vTo
	    JgclEmbeddedGraph.Vertex tgtVrtx0 = null;
	    JgclEmbeddedGraph.Vertex tgtVrtx1 = null;

	    for (Enumeration e1 = newVrtcs.elements(); e1.hasMoreElements();) {
		JgclEmbeddedGraph.Vertex vrtx =
		    (JgclEmbeddedGraph.Vertex)e1.nextElement();
		Vector faces = vrtx.getFaceCycleInCCW();
		if (faces.contains(face) == true) {
		    if (tgtVrtx0 == null)
			tgtVrtx0 = vrtx;
		    else
			tgtVrtx1 = vrtx;
		}
		if ((tgtVrtx0 != null) && (tgtVrtx1 != null))
		    break;
	    }

	    // V Voronoi _Ȃ͂͂Ȃ񂾂ǁAAA
	    if ((tgtVrtx0 == null) || (tgtVrtx1 == null))
		continue;

	    // To Voronoi _ԃGbWāAʂ𕪊
	    opResult = this.graph.makeEdgeFace(face, tgtVrtx0, tgtVrtx1);
	    dvdRandF.addElement(new RegionAndFace((VRegion)face.getUserData(),
						  opResult.face));
	}

	/*
	 * 폜ׂGbW폜
	 */
	JgclEmbeddedGraph.Face newFace = killEdges(rmvEdges, dvdRandF);

	/*
	 * Ďc̖ʂƊ Voronoi ̈̑Ή𐮗
	 */
	for (Enumeration e = dvdRandF.elements(); e.hasMoreElements();)
	    ((RegionAndFace)e.nextElement()).reAssociate(newFace);

	/*
	 * V Voronoi ̈ƖʂΉÂ
	 */
	newRegion.setFace(newFace);
	newFace.setUserData(newRegion);
    }

    /**
     * Voronoi }ɕ_𑫂B
     *
     * @param index	_̔ԍ
     * @param nearRegionHint	_ɋ߂͂ Voronoi ̈
     * @param lastAddedRegion	Ōɒǉꂽ Voronoi ̈
     * @return	_ɑΉĐVɒǉꂽ Voronoi ̈
     */
    private VRegion addPoint(int index,
			     VRegion nearRegionHint,
			     VRegion lastAddedRegion) {
	JgclEmbeddedGraph.Face nearestFace;	// _Ɉԋ߂ Voronoi ̈
	Vector T = new Vector();		// 폜ׂ Voronoi _̃Xg

	/*
	 * Voronoi }ɐVȕ_邱ƂŁA폜 Voronoi _߂
	 */
	nearestFace = findT(this.regions[index].getCoordinates(),
			    nearRegionHint, lastAddedRegion, T);

	if (T.size() > 0) {
	    /*
	     * 폜ׂ Voronoi _ȂAOtҏW
	     */
	    addRegion(this.regions[index], T);
	    lastAddedRegion = this.regions[index];

	} else {
	    /*
	     * 폜ׂ Voronoi _ȂȂA
	     * _̕_ƏdĂ̂ŁAdXgɉ
	     */
	    this.regions[index].setFace(nearestFace);
	    this.coincidingRegions.addElement(this.regions[index]);
	}

	return lastAddedRegion;
    }

    /**
     * 폜ׂ_̃Xg\NXB
     */
    private class TVertexInfo {
	/**
	 * 폜ׂ_B
	 */
	JgclEmbeddedGraph.Vertex v;

	/**
	 * v ɗאڂ钸_łɕ]ς݂ۂB
	 */
	private boolean neighborsAreEvaluated;

	/**
	 * 폜ׂ̒_B
	 */
	TVertexInfo next;

	/**
	 * IuWFNg\zB
	 *
	 * @param v	_
	 * @param e	אڂ钸_łɕ]ς݂ǂ
	 * @param next	܂ł̃Xg
	 */
	TVertexInfo(JgclEmbeddedGraph.Vertex v,
		    TVertexInfo next) {
	    this.v = v;
	    this.next = next;
	    this.neighborsAreEvaluated = false;
	}

	/**
	 * אڂ钸_̕]܂ςłȂ_ԂB
	 */
	private TVertexInfo getTviHasUnevaledNeighbors() {
	    for (TVertexInfo tvi = this; tvi != null; tvi = tvi.next) {
		if (tvi.neighborsAreEvaluated != true) {
		    tvi.neighborsAreEvaluated = true;
		    return tvi;
		}
	    }

	    return null;
	}

	/**
	 * ^ꂽ_Xgɑ݂邩ۂԂB
	 *
	 * @param tgt	_
	 */
	private boolean listHasThisVrtx(JgclEmbeddedGraph.Vertex tgt) {
	    for (TVertexInfo tvi = this; tvi != null; tvi = tvi.next) {
		if (tvi.v == tgt)
		    return true;
	    }

	    return false;
	}

	/**
	 * ^ꂽ_폜ׂ_̃XgɉƂA
	 * ̌ʂʑIɐ̂ł邩ۂԂB
	 *
	 * @param tgt	_
	 */
	private boolean inspectTopologicalValidity(JgclEmbeddedGraph.Vertex tgt) {
	    Vector inspectedFaces = new Vector();

	    /*
	     * P5.5 & P5.6
	     */
	    for (TVertexInfo tvi = this; tvi != null; tvi = tvi.next) {
		for (Enumeration e = tvi.v.getFaceCycleInCCW().elements();
		     e.hasMoreElements();) {
		    JgclEmbeddedGraph.Face face =
			(JgclEmbeddedGraph.Face)e.nextElement();
		    if (inspectedFaces.contains(face) == true)
			continue;

		    boolean allAreHaved = true;
		    boolean havedByT = false;
		    boolean headIsHaved = false;
		    int connectionCount = 0;

		    Vector vrtcs = face.getVertexCycleInCCW();
		    int nVrtcs = vrtcs.size();

		    for (int i = 0; i < nVrtcs; i++) {
			JgclEmbeddedGraph.Vertex vrtx =
			    (JgclEmbeddedGraph.Vertex)vrtcs.elementAt(i);
			if ((this.listHasThisVrtx(vrtx) != true) && (vrtx != tgt)) {
			    /*
			     * vrtx is not included in (T & tgt)
			     */
			    allAreHaved = false;
			    havedByT = false;
			} else {
			    /*
			     * vrtx is included in (T & tgt)
			     */
			    if (havedByT == false)
				connectionCount++;
			    havedByT = true;
			    if (i == 0)
				headIsHaved = true;
			    if (i == (nVrtcs - 1)) {
				if ((headIsHaved == true) && (connectionCount > 1))
				    connectionCount--;
			    }
			}
		    }

		    if ((allAreHaved == true) || (connectionCount > 1))
			return false;

		    inspectedFaces.addElement(face);
		}
	    }

	    return true;
	}
    }

    /**
     * Voronoi }ɐVɕ_邱ƂŁA
     * 폜邱ƂɂȂ Voronoi _߂B
     *
     * @param tgt	Vȕ_
     * @param nearRegionHint	_ɋ߂͂ Voronoi ̈
     * @param lastAddedRegion	Ōɒǉꂽ Voronoi ̈
     * @param TV	폜ׂ Voronoi _̃Xg (o)
     * @return	_Ɉԋ߂ Voronoi ̈
     */
    private JgclEmbeddedGraph.Face findT(JgclPoint2D tgt,
					 VRegion nearRegionHint,
					 VRegion lastAddedRegion,
					 Vector TV) {
	JgclEmbeddedGraph.Face nearestFace;
					// _Ɉԋ߂ Voronoi ̈

	JgclEmbeddedGraph.Vertex smallestV;	// H ŏƂȂ钸_
	double smallestH;		// ŏ H

	TVertexInfo T;			// 폜ׂ_̃Xg

	JgclEmbeddedGraph.Vertex  vrtx;	// 钸_
	TVertexInfo tvi;		// 폜ׂ_

	/*
	 * Step 2.1 : Vȕ_Ɉԋ߂ Voronoi ̈
	 *
	 * Vȕ_ƂɈԋ߂ Voronoi ̈̕_Ƃ̋𒲂ׁA
	 * 炪dĂȂA폜ׂ Voronoi _͖ƂɂȂ
	 */
	nearestFace = findNearestRegion(tgt, nearRegionHint, lastAddedRegion);

	JgclVector2D diff =
	    tgt.subtract(((VRegion)nearestFace.getUserData()).getCoordinates());
	diff = new JgclLiteralVector2D((diff.x() / this.xScale),
				       (diff.y() / this.yScale));
	if (diff.length() < 
	    JgclConditionOfOperation.getCondition().getToleranceForDistance())
	    return nearestFace;

	/*
	 * Step 2.2 : Vȕ_ɑ΂āAԏ H _ T ɉ
	 */
	smallestV = null;
	smallestH = Double.MAX_VALUE;

	for (Enumeration e = nearestFace.getVertexCycleInCCW().elements();
	     e.hasMoreElements();) {
	    vrtx = (JgclEmbeddedGraph.Vertex)e.nextElement();
	    try {
		double H = evaluateH(vrtx, tgt);
		if ((smallestV == null) || (H < smallestH)) {
		    smallestV = vrtx;
		    smallestH = H;
		}
	    } catch (PointIsExtra exp) {
		continue;
	    }
	}

	T = new TVertexInfo(smallestV, null);

	/*
	 * Step 2.3 : ȉ̏𖞂_ V  T ɉ
	 *
	 *	0. V ̗אړ_ł T ɑ݂
	 *	1. Vȕ_ V Ƃ H ̒lł
	 *	2. V  T ɉĂAT ׂ̂ʑ̏󂳂Ȃ
	 */

	/*
	 * T ŁAאړ_̕]ςłȂ_̂ꂼ
	 */
	while ((tvi = T.getTviHasUnevaledNeighbors()) != null) {
	    // אړ_̂ꂼɑ΂
	    for (Enumeration e = tvi.v.getEdgeCycleInCCW().elements();
		 e.hasMoreElements();) {
		vrtx = anotherEnd((JgclEmbeddedGraph.Edge)e.nextElement(), tvi.v);

		// ꂪł T ɑ݂΁AXLbv
		if (T.listHasThisVrtx(vrtx) == true)
		    continue;

		// H łȂ΁AXLbv
		try {
		    if (!(evaluateH(vrtx, tgt) < 0.0))
			continue;
		} catch (PointIsExtra exp) {
		    continue;
		}

		// T ̈ʑ𗐂Ȃ΁AXLbv
		if (T.inspectTopologicalValidity(vrtx) != true)
		    continue;

		// łȂ΁AT ɉ
		T = new TVertexInfo(vrtx, T);
	    }
	}

	for (tvi = T; tvi != null; tvi = tvi.next)
	    TV.addElement(tvi.v);

	return nearestFace;
    }

    /**
     * Vȕ_ɍł߂ Voronoi ̈𓾂B
     *
     * @param tgt	Vȕ_
     * @param nearRegionHint	Vȕ_ɋ߂͂ Voronoi ̈
     * @param lastAddedRegion	Ōɒǉꂽ Voronoi ̈
     * @return	Vȕ_Ɉԋ߂ Voronoi ̈
     */
    private JgclEmbeddedGraph.Face findNearestRegion(JgclPoint2D tgt,
						     VRegion nearRegionHint,
						     VRegion lastAddedRegion) {
	/*
	 * ߂ Voronoi ̈I
	 */
	JgclEmbeddedGraph.Face nearFace;
	double nearDist2;

	if (nearRegionHint != null) {
	    nearFace  = nearRegionHint.getFace();
	    nearDist2 = tgt.distance2(nearRegionHint.getCoordinates());
	} else {
	    nearFace  = lastAddedRegion.getFace();
	    nearDist2 = tgt.distance2(lastAddedRegion.getCoordinates());
	}

	while (true) {
	    JgclEmbeddedGraph.Face crntFace = nearFace;

	    /*
	     * b nearest (crntFace) ̎͂̃GbW̔Α̖ʂ
	     * Vȕ_Ƃ̋𒲂ׂāA
	     * b nearest ߂ Voronoi ̈
	     */
	    Vector edges = crntFace.getEdgeCycleInCCW();
	    for (Enumeration e = edges.elements(); e.hasMoreElements();) {
		JgclEmbeddedGraph.Edge edge = (JgclEmbeddedGraph.Edge)e.nextElement();
		JgclEmbeddedGraph.Face face = getAnotherFace(edge, crntFace);
		VRegion rgn = (VRegion)(face.getUserData());
		if (rgn == null) // O̖ʂ̓XLbv
		    continue;

		double dist2 = tgt.distance2(rgn.getCoordinates());
		if (dist2 < nearDist2) {
		    nearFace  = face;
		    nearDist2 = dist2;
		}
	    }

	    /*
	     * crntFace ԋ߂΁A[v𔲂
	     */
	    if (crntFace == nearFace)
		break;
	}

	return nearFace;
    }

    /**
     * GbW̑̒_ԂB
     *
     * @param e	GbW
     * @param v GbẄ̒_
     * @return	GbW̑̒_
     */
    private JgclEmbeddedGraph.Vertex anotherEnd(JgclEmbeddedGraph.Edge e,
						JgclEmbeddedGraph.Vertex v) {
	JgclEmbeddedGraph.Vertex[] vertices = e.getVertices();

	if (v == vertices[0]) return vertices[1];
	if (v == vertices[1]) return vertices[0];

	return null;
    }

    /**
     * GbW̖̑ʂԂB
     *
     * @param e	GbW
     * @param f GbẄ̖
     * @return	GbW̖̑
     */
    private JgclEmbeddedGraph.Face getAnotherFace(JgclEmbeddedGraph.Edge e,
						  JgclEmbeddedGraph.Face f) {
	JgclEmbeddedGraph.Face[] faces = e.getFaces();

	if (f == faces[0]) return faces[1];
	if (f == faces[1]) return faces[0];

	return null;
    }

    /**
     * Voronoi _u⏕vł邱ƂOB
     */
    private class PointIsExtra extends JgclException {
	/**
	 * IuWFNg\z
	 */
	protected PointIsExtra() {
	    super();
	}

	/**
	 * ^ăIuWFNg\z
	 */
	public PointIsExtra(String s) {
	    super(s);
	}
    }

    /**
     * H ߂B
     * <p>
     * H = (vrtx  addedPoint ւ̋) - (vrtx ł߂_ւ̋)
     * </p>
     *
     * @param vrtx	Voronoi _
     * @param addedPoint	Vȕ_
     * @return	H
     * @exception PointIsExtra	Voronoi _u⏕vł
     */
    private double evaluateH(JgclEmbeddedGraph.Vertex vrtx,
			     JgclPoint2D addedPoint) throws PointIsExtra {
	VPoint pnt = (VPoint)vrtx.getUserData();

	// ԋ߂_Ƃ̋}CiX̓_́A⏕ Voronoi _
	if (pnt.getDistance() < 0.0)
	    throw new PointIsExtra();

	return addedPoint.distance(pnt.getCoordinates()) - pnt.getDistance();
    }

    /**
     * GbW^ꂽXgɊ܂܂Ă邩ۂAԂB
     *
     * @param list	GbW̃Xg
     * @param edge	ׂ̑ΏۂƂȂGbW
     * @return	edge  list Ɋ܂܂Ă true
     */
    private boolean edgeIsContained(Vector list,
				    JgclEmbeddedGraph.Edge edge) {
	for (Enumeration e = list.elements(); e.hasMoreElements();)
	    if (edge.isIdentWith((JgclEmbeddedGraph.Edge)e.nextElement()) == true)
		return true;

	return false;
    }

    /**
     * V Voronoi _̍Wl߂B
     * <p>
     * ߂WĺÃ\bh̓ VPoint Ƃ
     * newVrtx ɐݒ肷B
     * </p>
     *
     * @param edge	GbW
     * @param vrtx1	GbW̒[_
     * @param vrtx2	GbW̒[_
     * @param newVrtx	GbW𕪊_ (V Voronoi _)
     * @param tgt	Voronoi }ɉ悤ƂĂ_
     */
    private void setMiddlePoint(JgclEmbeddedGraph.Edge edge,
				JgclEmbeddedGraph.Vertex vrtx1,
				JgclEmbeddedGraph.Vertex vrtx2,
				JgclEmbeddedGraph.Vertex newVrtx,
				JgclPoint2D tgt) {
	// bln1 : GbW̊􉽏ł
	VPoint xy1 = (VPoint)vrtx1.getUserData();
	VPoint xy2 = (VPoint)vrtx2.getUserData();
	JgclBoundedLine2D bln1 =
	    new JgclBoundedLine2D(xy1.getCoordinates(), xy2.getCoordinates());

	// lin2 : ^ꂽ_ƁuGbŴꂩ̖̑ʂ̕_vƂ̐񓙕
	JgclEmbeddedGraph.Face[] faces = edge.getFaces();
	JgclLine2D lin2 = null;
	JgclPoint2D old = null;

	for (int i = 0; i < 2; i++) {
	    VRegion rgn = (VRegion)faces[i].getUserData();
	    old = rgn.getCoordinates();
	    JgclVector2D dir = old.subtract(tgt);
	    if (dir.length() <
		JgclConditionOfOperation.getCondition().getToleranceForDistance())
		continue;

	    lin2 = new JgclLine2D(old.linearInterpolate(tgt, 0.5),
				  dir.verticalVector());
	    break;
	}

	if (lin2 == null) // _dĂ : ł͂蓾Ȃ
	    return;

	// bln1  lin2 ̌_߂
	JgclIntersectionPoint2D ints;

	if (conditionWithSmallDTol == null) {
	    conditionWithSmallDTol =
		JgclConditionOfOperation.getDefaultCondition().
		makeCopyWithToleranceForDistance(1.0e-8);
	}
	conditionWithSmallDTol.push();

	try {
	    ints = bln1.intersect1AsInfiniteLine(lin2);
	} catch (JgclIndefiniteSolution e) {
	    ints = null;
	}

	JgclConditionOfOperation.pop();

	JgclPoint2D middlePoint;

	if (ints != null) {
	    // _V Voronoi _̍WƂ
	    middlePoint = ints.coordinates();
	} else {
	    // (xy1  xy2 ̋ƂĂ)  (񒼐s)
	    // ̃P[X͋NȂ͂AAA
	    // xy1  xy 2 ̒_V Voronoi _̍WƂ
	    middlePoint = xy1.getCoordinates().
		linearInterpolate(xy2.getCoordinates(), 0.5);
	}

	VPoint vpnt = new VPoint(middlePoint);
	newVrtx.setUserData(vpnt);
	vpnt.setDistance(Math.sqrt((tgt.distance2(middlePoint) +
				    old.distance2(middlePoint)) / 2.0));
    }

    /**
     * }̎c[폜B
     *
     * @param extraPoints	 Voronoi _̔z
     * @param extraRegions	 Voronoi ̈̔z
     */
    private void removeExtraFaces(JgclEmbeddedGraph.Vertex[] extraPoints,
				  VRegion[] extraRegions) {
	Vector RandF = new Vector();
	int i;

	for (i = 0; i < 3; i++)
	    RandF.addElement(new RegionAndFace(extraRegions[i],
					       extraRegions[i].getFace()));

	for (i = 0; i < 3; i++)
	    killEdges(extraPoints[i].getEdgeCycleInCCW(), RandF);

	// O̖ʂƂĎcʂ userData NA
	for (Enumeration e = RandF.elements(); e.hasMoreElements();) {
	    RegionAndFace RF = (RegionAndFace)e.nextElement();
	    if (RF.faceKilled != true)
		RF.face.setUserData(null);
	}
    }

    // I N S T A N C E   M E T H O D S

    /**
     * Voronoi }̈ʑێOtԂB
     *
     * @return	Voronoi }̈ʑێOt
     */
    public JgclEmbeddedGraph getGraph() {
	return graph;
    }

    /**
     * d_̑g̐ԂB
     *
     * @return	d_̑g̐
     */
    public int getNumberOfPairsOfCoincidingRegions() {
	return coincidingRegions.size();
    }

    /**
     * d_ Enumeration ԂB
     *
     * @return d_ (JgclVoronoiDiagram2D.VRegion)  Enumeration
     */
    public Enumeration coincidingRegionElements() {
	return coincidingRegions.elements();
    }

    /**
     * (d) Voronoi ̈ Enumeration ԂB
     *
     * @return Voronoi ̈ (JgclVoronoiDiagram2D.VRegion)  Enumeration
     */
    public Enumeration regionElements() {
	return new Enumeration() {
	    Enumeration e = graph.faceElements();
	    Object nextNonOuterFace = null;

	    public boolean hasMoreElements() {
		if (nextNonOuterFace != null)
		    return true;

		if (e.hasMoreElements() == false)
		    return false;

		Object obj = e.nextElement();
		if (((JgclEmbeddedGraph.Face)obj).getUserData() != null) {
		    nextNonOuterFace = obj;
		    return true;
		} else {
		    nextNonOuterFace = null;
		    return e.hasMoreElements();
		}
	    }

	    public java.lang.Object nextElement() {
		Object obj;

		if (nextNonOuterFace != null) {
		    obj = nextNonOuterFace;
		    nextNonOuterFace = null;
		    return ((JgclEmbeddedGraph.Face)obj).getUserData();
		}

		obj = e.nextElement();
		if (((JgclEmbeddedGraph.Face)obj).getUserData() != null) {
		    return ((JgclEmbeddedGraph.Face)obj).getUserData();
		} else {
		    return ((JgclEmbeddedGraph.Face)e.nextElement()).getUserData();
		}
	    }
	};
    }

    /**
     * Voronoi _ Enumeration ԂB
     *
     * @return	Voronoi _ (JgclVoronoiDiagram2D.VPoint)  Enumeration
     */
    public Enumeration pointElements() {
	return new Enumeration() {
	    Enumeration e = graph.vertexElements();

	    public boolean hasMoreElements() {
		return e.hasMoreElements();
	    }

	    public java.lang.Object nextElement() {
		return ((JgclEmbeddedGraph.Vertex)e.nextElement()).getUserData();
	    }
	};
    }

    /**
     * 􉽏폜B
     * <p>
     * _̍Wl^d Voronoi _̍WlȂǂ̊􉽏폜A
     *  Voronoi }̈ʑ񂾂^ߍ݃OtƂĎcB
     * ̃\bhĂяóÃCX^XɃANZX邱Ƃ͂łȂB
     * </p>
     *
     * @return	cʑ
     */
    public JgclEmbeddedGraph stripGeometries() {

	// Ot̒_ Voronoi _̏폜
	for (Enumeration e = this.graph.vertexElements();
	     e.hasMoreElements();) {
	    JgclEmbeddedGraph.Vertex vrtx =
		(JgclEmbeddedGraph.Vertex)e.nextElement();
	    VPoint pnt = (VPoint)vrtx.getUserData();
	    if (pnt != null)
		vrtx.setUserData(pnt.getUserData());
	}

	// Ot̖ʂ Voronoi ̈̏폜
	for (Enumeration e = this.graph.faceElements();
	     e.hasMoreElements();) {
	    JgclEmbeddedGraph.Face face =
		(JgclEmbeddedGraph.Face)e.nextElement();
	    VRegion rgn = (VRegion)face.getUserData();
	    if (rgn != null)
		face.setUserData(rgn.getUserData());
	}

	// Voronoi ̈̔z폜
	this.regions = null;

	// d Voronoi ̈̃Xg폜
	this.coincidingRegions = null;

	return this.graph;
    }

    /**
     * GbWvgB
     *
     * @param message	bZ[W
     */
    private void debugPrint(String message) {
	System.out.println("// Start of " + message);

	int i = 0;
	for (Enumeration e = this.graph.vertexElements();
	     e.hasMoreElements();) {
	    JgclEmbeddedGraph.Vertex vrtx = (JgclEmbeddedGraph.Vertex)e.nextElement();
	    JgclVoronoiDiagram2D.VPoint vpnt =
		(JgclVoronoiDiagram2D.VPoint)vrtx.getUserData();
	    JgclPoint2D crd = vpnt.getCoordinates();

	    System.out.println("JgclCartesianPoint2D	pnt" + i);
	    System.out.println(crd.x() + " " + crd.y());
	    System.out.println("End");
	    i++;
	}

	i = 0;
	for (Enumeration e = this.graph.edgeElements();
	     e.hasMoreElements();) {
	    JgclEmbeddedGraph.Edge edge = (JgclEmbeddedGraph.Edge)e.nextElement();
	    JgclEmbeddedGraph.Vertex[] vrtcs = edge.getVertices();
	    JgclVoronoiDiagram2D.VPoint vpnt0 =
		(JgclVoronoiDiagram2D.VPoint)vrtcs[0].getUserData();
	    JgclVoronoiDiagram2D.VPoint vpnt1 =
		(JgclVoronoiDiagram2D.VPoint)vrtcs[1].getUserData();
	    JgclPoint2D crd0 = vpnt0.getCoordinates();
	    JgclPoint2D crd1 = vpnt1.getCoordinates();

	    if (crd0.identical(crd1) != true) {
		System.out.println("JgclLine2D	lin" + i);
		System.out.println("\tpnt\t" + crd0.x() + " " + crd0.y());
		System.out.println("\tpnt\t" + crd1.x() + " " + crd1.y());
		System.out.println("End");
	    }
	    i++;
	}

	System.out.println("// End of " + message);
    }

    // Main Programs for Debugging
    /**
     * fobOpCvOB
     */
    public static void main(String[] args) {
	Vector points = new Vector();

	points.addElement(new JgclCartesianPoint2D(-0.5, -0.5));
	points.addElement(new JgclCartesianPoint2D(0.5, -0.5));
	points.addElement(new JgclCartesianPoint2D(0.5, 0.5));
	points.addElement(new JgclCartesianPoint2D(-0.5, 0.5));

	JgclVoronoiDiagram2D voronoi =
	    new JgclVoronoiDiagram2D(new JgclEmbeddedGraph(),
				     points.elements());

	System.out.println("# Regions");
	for (Enumeration e = voronoi.regionElements(); e.hasMoreElements();) {
	    VRegion rgn = (VRegion)e.nextElement();
	    int         idx = rgn.getIndex();
	    JgclPoint2D crd = rgn.getCoordinates();
	    System.out.println("# [" + idx + "] " + crd.x() + ", " + crd.y());

	    for (Enumeration e1 = rgn.getVPointCycleInCCW();
		 e1.hasMoreElements();) {
		VPoint      pnt1 = (VPoint)e1.nextElement();
		JgclPoint2D crd1 = pnt1.getCoordinates();
		System.out.println("#\t" + crd1.x() + ", " + crd1.y());
	    }
	}

	System.out.println("# Coinciding Regions");
	for (Enumeration e = voronoi.coincidingRegionElements(); e.hasMoreElements();) {
	    VRegion rgn = (VRegion)e.nextElement();
	    int         idx = rgn.getIndex();
	    JgclPoint2D crd = rgn.getCoordinates();
	    System.out.println("# [" + idx + "] " + crd.x() + ", " + crd.y());

	    for (Enumeration e1 = rgn.getVPointCycleInCCW();
		 e1.hasMoreElements();) {
		VPoint      pnt1 = (VPoint)e1.nextElement();
		JgclPoint2D crd1 = pnt1.getCoordinates();
		System.out.println("#\t" + crd1.x() + ", " + crd1.y());
	    }
	}

	System.out.println("# Points");
	for (Enumeration e = voronoi.pointElements(); e.hasMoreElements();) {
	    VPoint pnt = (VPoint)e.nextElement();
	    JgclPoint2D crd = pnt.getCoordinates();
	    System.out.println("# " + crd.x() + ", " + crd.y());
	}

	JgclEmbeddedGraph graph = voronoi.getGraph();
	int i = 0;

	for (Enumeration e = graph.edgeElements(); e.hasMoreElements();) {
	    JgclEmbeddedGraph.Edge edge = (JgclEmbeddedGraph.Edge)e.nextElement();
	    JgclEmbeddedGraph.Vertex[] vrtcs = edge.getVertices();

	    JgclVoronoiDiagram2D.VPoint vpnt0 =
		(JgclVoronoiDiagram2D.VPoint)vrtcs[0].getUserData();
	    JgclVoronoiDiagram2D.VPoint vpnt1 =
		(JgclVoronoiDiagram2D.VPoint)vrtcs[1].getUserData();

	    JgclPoint2D pnt0 = vpnt0.getCoordinates();
	    JgclPoint2D pnt1 = vpnt1.getCoordinates();

	    System.out.println("JgclLine2D	lin" + i);
	    System.out.println("\tpnt\t" + pnt0.x() + " " + pnt0.y());
	    System.out.println("\tpnt\t" + pnt1.x() + " " + pnt1.y());
	    System.out.println("End");
	    i++;
	}
    }
}

// end of file
