/*
 * R̃xNg\ۃNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclVector3D.java,v 1.36 2000/08/11 06:19:04 shikano Exp $
 */

package jp.go.ipa.jgcl;

/**
 * R̃xNg\ۃNXB
 *
 * @version $Revision: 1.36 $, $Date: 2000/08/11 06:19:04 $
 * @author Information-technology Promotion Agency, Japan
 * @see JgclPoint3D
 */

public abstract class JgclVector3D extends JgclVector {

    /**
     * R̃[xNgB
     */
    public static final JgclVector3D zeroVector;

    /**
     * R̃O[oȒWn X ̒PʃxNgB
     */
    public static final JgclVector3D xUnitVector;

    /**
     * R̃O[oȒWn Y ̒PʃxNgB
     */
    public static final JgclVector3D yUnitVector;

    /**
     * R̃O[oȒWn Z ̒PʃxNgB
     */
    public static final JgclVector3D zUnitVector;

    /**
     * static ȃtB[hɒlݒ肷B
     */
    static {
	zeroVector  = new JgclLiteralVector3D(0.0, 0.0, 0.0);
	xUnitVector = new JgclLiteralVector3D(1.0, 0.0, 0.0, true);
	yUnitVector = new JgclLiteralVector3D(0.0, 1.0, 0.0, true);
	zUnitVector = new JgclLiteralVector3D(0.0, 0.0, 1.0, true);
    }

    /**
     * PʃxNg
     * @serial
     */
    private JgclVector3D unitized;

    /**
     * IuWFNg\zB
     * <p>
     * 悤ƂxNg
     * PʃxNgł邩ǂȂꍇA
     * PʃxNgłȂƂۏ؂Ăꍇɂ́A
     * ̃RXgN^gpB
     * </p>
     */
    protected JgclVector3D() {
	super();

	unitized = null;
    }

    /**
     * IuWFNg\zB
     * <p>
     * 悤ƂxNg
     * PʃxNgł邩ǂꍇɂ́A
     * ̃RXgN^gpB
     * </p>
     * 
     * @param confirmedAsUnitized	悤ƂxNg
     *					PʃxNgłȂ <code>true</code>A
     *					Ȃ <code>false</code>
     */
    protected JgclVector3D(boolean confirmedAsUnitized) {
	super();
	unitized = (confirmedAsUnitized) ? this : null;
    }

    /**
     * R̃[xNgԂB
     *
     * @return	R̃[xNg
     */
    public static JgclVector3D zeroVector() {
	return zeroVector;
    }

    /**
     * R̃O[oȒWn X ̒PʃxNgԂB
     *
     * @return	R̃O[oȒWn X ̒PʃxNg
     */
    public static JgclVector3D xUnitVector() {
	return xUnitVector;
    }

    /**
     * R̃O[oȒWn Y ̒PʃxNgԂB
     *
     * @return	R̃O[oȒWn Y ̒PʃxNg
     */
    public static JgclVector3D yUnitVector() {
	return yUnitVector;
    }

    /**
     * R̃O[oȒWn Z ̒PʃxNgԂB
     *
     * @return	R̃O[oȒWn Z ̒PʃxNg
     */
    public static JgclVector3D zUnitVector() {
	return zUnitVector;
    }

    /**
     * ԂB
     * <p>
     *  3 ԂB
     * </p>
     * 
     * @return	RȂ̂ŁA 3
     */
    public int dimension() {
	return 3;
    }

    /**
     * RۂԂB
     * <p>
     *  true ԂB
     * </p>
     * 
     * @return		RȂ̂ŁA <code>true</code>
     */
    public boolean is3D() {
	return true;
    }

    /**
     * xNg X Ԃۃ\bhB
     * 
     * @return	xNg X 
     */
    public abstract double x();

    /**
     * xNg Y Ԃۃ\bhB
     * 
     * @return	xNg Y 
     */
    public abstract double y();

    /**
     * xNg Z Ԃۃ\bhB
     * 
     * @return	xNg Z 
     */
    public abstract double z();

    /**
     * PʉxNgԂB
     * <p>
     * ȂxNgɑ΂Ẵ\bhĂ񂾏ꍇA
     * ł̓[xNgԂ悤ɂȂĂB
     * A{͗O JgclZeroLength 𓊂ׂłB
     * </p>
     * 
     * @return	PʉxNg
     */
    public JgclVector3D unitized() {
	if (unitized != null)
	    return unitized;

	double leng = length();
	if (!JgclUtil.isDividable(JgclMath.maxOf3(x(), y(), z()), leng)) {
	    // throw new JgclZeroLength();
	    return (unitized = zeroVector);
	}

	return (unitized = new JgclLiteralVector3D(x()/leng, y()/leng, z()/leng, true));
    }
	
    /**
     * e̕𔽓]xNgԂB
     *
     * @return	this 𔽓]xNg
     */
    public JgclVector3D reverse() {
	return new JgclLiteralVector3D(-x(), -y(), -z());
    }

    /**
     * ɐȃxNgɑIŕԂB
     *
     * @return	this ɐȃxNg
     */
    public JgclVector3D verticalVector() {
	return crossProduct((parallelDirection(yUnitVector)) ? zUnitVector : yUnitVector);
    }

    /**
     * ςԂB
     * 
     * @param mate	ς鑊̃xNg
     * @return		
     */
    public double dotProduct(JgclVector3D mate) {
	return x() * mate.x() + y() * mate.y() + z() * mate.z();
    }

    /**
     * OςԂB
     * 
     * @param mate	Oς鑊̃xNg
     * @return		mate Ƃ̊O
     */
    public JgclVector3D crossProduct(JgclVector3D mate) {
	return new JgclLiteralVector3D(y() * mate.z() - z() * mate.y(),
				       z() * mate.x() - x() * mate.z(),
				       x() * mate.y() - y() * mate.x());
    }

    /**
     * xNgm̘aԂB
     * 
     * @param mate	a鑊̃xNg
     * @return		xNg̘a (this + mate)
     */
    public JgclVector3D add(JgclVector3D mate) {
	return new JgclLiteralVector3D(x()+mate.x(),
				       y()+mate.y(),
				       z()+mate.z());
    }

    /**
     * xNgm̍ԂB
     * 
     * @param mate	鑊̃xNg
     * @return		xNg̍ (this - mate)
     */
    public JgclVector3D subtract(JgclVector3D mate) {
	return new JgclLiteralVector3D(x()-mate.x(), 
				       y()-mate.y(),
				       z()-mate.z());
    }

    /**
     * ^ꂽXP[悶xNgԂB
     * 
     * @param scale	XP[
     * @return		(this * scale)
     */
    public JgclVector3D multiply(double scale) {
	return new JgclLiteralVector3D(x() * scale, 
				       y() * scale,
				       z() * scale);
    }

    /**
     * ^ꂽXP[ŊxNgԂB
     * 
     * @param scale	XP[
     * @return		(this / scale)
     */
    public JgclVector3D divide(double scale) {
	return new JgclLiteralVector3D(x() / scale,
				       y() / scale,
				       z() / scale);
    }

    /**
     * xNg̓ꐫ𔻒肷B
     * <p>
     * ̃xNg̍̑傫A
     * ݐݒ肳Ă鉉Źűe덷v菬΁A
     * ̃xNg͓ł̂ƔfB
     * </p>
     * 
     * @param mate	̑ΏۂƂȂxNg
     * @return	̃xNg̃xNgłƂ݂Ȃ trueAȂ false
     * @see	JgclConditionOfOperation
     * @see	#identicalDirection(JgclVector3D)
     */
    public boolean identical(JgclVector3D mate) {
	double dTol2 = getToleranceForDistance2();
	double xv, yv, zv;

	xv = x() - mate.x();
	yv = y() - mate.y();
	zv = z() - mate.z();

	return xv * xv + yv * yv + zv * zv < dTol2;
    }

    /**
     * xNg̓𔻒肷B
     * <p>
     * ̃xNĝȂpxA
     * ݐݒ肳Ă鉉Źupx̋e덷v菬΁A
     * ̃xNg͓ł̂ƔfB
     * </p>
     * 
     * @param mate	̑ΏۂƂȂxNg
     * @param allowReversed	]ĂԂ𓯈ƌȂȂ true
     * @return	̃xNg̃xNgƂ݂Ȃ trueAȂ false
     * @see	JgclConditionOfOperation
     * @see	#identical(JgclVector3D)
     * @see	#identicalDirection(JgclVector3D)
     * @see	#parallelDirection(JgclVector3D)
     */
    private boolean identicalDirection(JgclVector3D mate, boolean allowReversed) {
	double aTol = getToleranceForAngle();
	double dTol2 = getToleranceForDistance2();
	double dotProd, crossProd;
	boolean result; // return value

	if (this.norm() < dTol2 || mate.norm() < dTol2) {
	    result = true;
	} else {
	    dotProd = dotProduct(mate); // cos(theta)*|this|*|mate|
	    if (allowReversed)
		dotProd = Math.abs(dotProd);
	    crossProd = crossProduct(mate).length(); // sin(theta)*|this|*|mate|
	    result = Math.abs(Math.atan2(crossProd, dotProd)) < aTol;
	}

	return result;
    }

    /**
     * xNg̓𔻒肷B
     * <p>
     * ̃xNĝȂpxA
     * ݐݒ肳Ă鉉Źupx̋e덷v菬΁A
     * ̃xNg͓ł̂ƔfB
     * </p>
     * <p>
     * ȂA]Ԃ͓Ƃ݂ȂȂB
     * </p>
     * 
     * @param mate	̑ΏۂƂȂxNg
     * @return	̃xNg̃xNgƂ݂Ȃ trueAȂ false
     * @see	JgclConditionOfOperation
     * @see	#identical(JgclVector3D)
     * @see	#parallelDirection(JgclVector3D)
     */
    public boolean identicalDirection(JgclVector3D mate) {
	return identicalDirection(mate, false);
    }

    /**
     * xNg̓𔻒肷B
     * <p>
     * ̃xNĝȂpxA
     * ݐݒ肳Ă鉉Źupx̋e덷v菬΁A
     * ̃xNg͓ł̂ƔfB
     * </p>
     * <p>
     * ȂA]ԂƂ݂ȂB
     * </p>
     * 
     * @param mate	̑ΏۂƂȂxNg
     * @return	̃xNg̃xNgƂ݂Ȃ trueAȂ false
     * @see	JgclConditionOfOperation
     * @see	#identicalDirection(JgclVector3D)
     */
    public boolean parallelDirection(JgclVector3D mate) {
	return identicalDirection(mate, true);
    }

    /**
     * xNg̃mԂB
     * 
     * @return		xNg̃m (x^2) + (y^2) + (z^2)
     */
    public double norm() {
	double xv = x();
	double yv = y();
	double zv = z();

	return xv * xv + yv * yv + zv * zv;
    }

    /**
     * ^ꂽǏWZ̎ɁA^ꂽpx]xNgԂB
     * <p>
     * ĂяóA(rCos * rCos + rSin * rSin) ̒l 1 ł邱Ƃ
     * ۏ؂Ȃ΂ȂȂB
     * </p>
     *
     * @param trns	ǏW瓾ꂽWϊ
     * @param rCos	cos(]px)
     * @param rSin	sin(]px)
     * @return		]̃xNg
     * @see	JgclPoint3D#rotateZ(JgclCartesianTransformationOperator3D, double, double)
     * @see	JgclAxis2Placement3D#rotateZ(JgclCartesianTransformationOperator3D, double, double)
     */
    JgclVector3D rotateZ(JgclCartesianTransformationOperator3D trns,
			 double rCos, double rSin) {
	JgclVector3D lvec, rvec;
	double x, y, z;

	lvec = trns.toLocal(this);
	x = (rCos * lvec.x()) - (rSin * lvec.y());
	y = (rSin * lvec.x()) + (rCos * lvec.y());
	z = lvec.z();
	rvec = new JgclLiteralVector3D(x, y, z);
	return trns.toEnclosed(rvec);
    }

    /**
     * xNg𕽖ʂɓeB
     *
     * @param dNorm	ʂ̖@xNg
     * @return		ʏɓeꂽxNg
     */
    public JgclVector3D project(JgclVector3D dNorm) {
	JgclVector3D uNorm;
	double d;

	/*
	 * uNorm <- unit(dNorm)
	 * dDvec <- dSvec - dot(uNorm, dSvec) * uNorm
	 */
	uNorm = dNorm.unitized();
	d = uNorm.dotProduct(this);
	return this.subtract(uNorm.multiply(d));
    }

    /**
     * xNg XY ʂɎˉe 2D B
     *
     * @return		2D xNg
     * @see	JgclVector2D
     */
    JgclVector2D to2D() {
	return new JgclLiteralVector2D(x(), y());
    }

    /**
     * xNgǏWn XY ʂɎˉe 2D B
     *
     * @return		2D xNg
     * @see	JgclCartesianTransformationOperator3D
     * @see	JgclVector2D
     */
    JgclVector2D to2D(JgclCartesianTransformationOperator3D transform) {
	return transform.toLocal(this).to2D();
    }

    /**
     * R̓_ (JgclPoint3D) ɕϊB
     *
     * @return	_̈ʒuxNgƂ݂Ȃ_
     */
    public JgclPoint3D toPoint3D() {
        return new JgclCartesianPoint3D(x(), y(), z());
    }

    /**
     * xNg̔zR̓_ (JgclPoint3D) ̔zɕϊB
     *
     * @return _̈ʒuxNgƂ݂Ȃ_̔z
     */
    public static JgclPoint3D[] toPoint3D(JgclVector3D[] vecs) {
	JgclPoint3D[] pnts = new JgclPoint3D[vecs.length];
	for (int i = 0; i < vecs.length; i++)
	    pnts[i] = vecs[i].toPoint3D();
	return pnts;
    }

    /**
     * double̔zɕϊB
     *
     * @return Wldouble̔z
     */
    public double[] toDoubleArray() {
        double[] array = {x(), y(), z()};
	return array;
    }

    /**
     * ̃xNgƂ̊px (WA) ߂B
     * <p>
     * this  mate ւ̍̊px (0 ` 2pi)
     * <br>
     * ł̍Ƃ́Anorm Ă猩Ƃ̍
     * </p>
     *
     * @param  mate ̃xNg
     * @param  norm uv߂ƂȂxNg
     * @return ̃xNgƂ̊px
     */
    public double angleWith(JgclVector3D mate, JgclVector3D norm) {
	JgclVector3D thisUnitVec; 
	JgclVector3D mateUnitVec;

	try {
	    thisUnitVec = this.unitized();
	    mateUnitVec = mate.unitized();
	}
	catch (JgclZeroLength e) {
	    return 0.0;
	}

	double dot = thisUnitVec.dotProduct(mateUnitVec);
	if (dot > 1.0) dot = 1.0;
	if (dot < -1.0) dot = -1.0;
	double theta = Math.acos(dot);

	JgclVector3D crsVec = thisUnitVec.crossProduct(mateUnitVec);
	JgclVector3D crsUnitVec;

	try {
	    crsUnitVec = crsVec.unitized();
	}
	catch (JgclZeroLength e) {
	    return (dot < 0.0) ? Math.PI : 0.0;
	}

	if (crsUnitVec.dotProduct(norm) < 0.0)
	    theta = Math.PI * 2 - theta;

	return theta;
    }

    /**
     * ̃xNgA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected abstract JgclVector3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries);

    /**
     * ̃xNgA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    public synchronized JgclVector3D
    transformBy(boolean reverseTransform,
		JgclCartesianTransformationOperator3D transformationOperator,
		java.util.Hashtable transformedGeometries)
    {
	if (transformedGeometries == null)
	    return this.doTransformBy(reverseTransform,
				      transformationOperator,
				      transformedGeometries);

	JgclVector3D transformed = (JgclVector3D)transformedGeometries.get(this);
	if (transformed == null) {
	    transformed = this.doTransformBy(reverseTransform,
					     transformationOperator,
					     transformedGeometries);
	    transformedGeometries.put(this, transformed);
	}
	return transformed;
    }

    /**
     * ̃xNgA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    public synchronized JgclVector3D
    transformBy(JgclCartesianTransformationOperator3D transformationOperator,
		java.util.Hashtable transformedGeometries)
    {
	return this.transformBy(false,
				transformationOperator,
				transformedGeometries);
    }

    /**
     * ̃xNgA^ꂽ􉽓IϊZqŋtϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŋtϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŋtϊ̂ԂB
     * </p>
     *
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	tϊ̊􉽗vf
     */
    public synchronized JgclVector3D
    reverseTransformBy(JgclCartesianTransformationOperator3D transformationOperator,
		       java.util.Hashtable transformedGeometries)
    {
	return this.transformBy(true,
				transformationOperator,
				transformedGeometries);
    }

    /**
     * JgclLiteralVector3D ̃CX^X𐶐B
     *
     * @param x	X 
     * @param y	Y 
     * @param z	Z 
     * @return	JgclLiteralVector3D ̃CX^X
     */
    public static JgclLiteralVector3D of(double x,
					 double y,
					 double z) {
	return new JgclLiteralVector3D(x, y, z);
    }

    /**
     * JgclLiteralVector3D ̃CX^X𐶐B
     *
     * @param components	X, Y̔z (vf 3)
     * @return	JgclLiteralVector3D ̃CX^X
     */
    public static JgclLiteralVector3D of(double[] components) {
	return new JgclLiteralVector3D(components);
    }
}
