/*
 * Q̃xNg\ۃNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclVector2D.java,v 1.32 2000/08/11 06:19:04 shikano Exp $
 */

package jp.go.ipa.jgcl;

/**
 * Q̃xNg\ۃNXB
 *
 * @version $Revision: 1.32 $, $Date: 2000/08/11 06:19:04 $
 * @author Information-technology Promotion Agency, Japan
 * @see JgclPoint2D
 */

public abstract class JgclVector2D extends JgclVector {

    /**
     * Q̃[xNgB
     */
    public static final JgclVector2D zeroVector;

    /**
     * Q̃O[oȒWn X ̒PʃxNgB
     */
    public static final JgclVector2D xUnitVector;

    /**
     * Q̃O[oȒWn Y ̒PʃxNgB
     */
    public static final JgclVector2D yUnitVector;

    /**
     * static ȃtB[hɒlݒ肷B
     */
    static {
	zeroVector  = new JgclLiteralVector2D(0.0, 0.0);
	xUnitVector = new JgclLiteralVector2D(1.0, 0.0, true);
	yUnitVector = new JgclLiteralVector2D(0.0, 1.0, true);
    }

    /**
     * PʃxNg
     * @serial
     */
    private JgclVector2D unitized;

    /**
     * IuWFNg\zB
     * <p>
     * 悤ƂxNg
     * PʃxNgł邩ǂȂꍇA
     * PʃxNgłȂƂۏ؂Ăꍇɂ́A
     * ̃RXgN^gpB
     * </p>
     */
    protected JgclVector2D() {
	super();

	unitized = null;
    }

    /**
     * IuWFNg\zB
     * <p>
     * 悤ƂxNg
     * PʃxNgł邩ǂꍇɂ́A
     * ̃RXgN^gpB
     * </p>
     * 
     * @param confirmedAsUnitized	悤ƂxNg
     *					PʃxNgłȂ <code>true</code>A
     *					Ȃ <code>false</code>
     */
    protected JgclVector2D(boolean confirmedAsUnitized) {
	super();
	unitized = (confirmedAsUnitized) ? this : null;
    }

    /**
     * Q̃[xNgԂB
     *
     * @return	Q̃[xNg
     */
    public static JgclVector2D zeroVector() {
	return zeroVector;
    }

    /**
     * Q̃O[oȒWn X ̒PʃxNgԂB
     *
     * @return	Q̃O[oȒWn X ̒PʃxNg
     */
    public static JgclVector2D xUnitVector() {
	return xUnitVector;
    }

    /**
     * Q̃O[oȒWn Y ̒PʃxNgԂB
     *
     * @return	Q̃O[oȒWn Y ̒PʃxNg
     */
    public static JgclVector2D yUnitVector() {
	return yUnitVector;
    }

    /**
     * ԂB
     * <p>
     *  2 ԂB
     * </p>
     * 
     * @return	QȂ̂ŁA 2
     */
    public int dimension() {
	return 2;
    }

    /**
     * QۂԂB
     * <p>
     *  true ԂB
     * </p>
     * 
     * @return		QȂ̂ŁA <code>true</code>
     */
    public boolean is2D() {
	return true;
    }

    /**
     * xNg X Ԃۃ\bhB
     * 
     * @return	xNg X 
     */
    public abstract double x();

    /**
     * xNg Y Ԃۃ\bhB
     * 
     * @return	xNg Y 
     */
    public abstract double y();

    /**
     * PʉxNgԂB
     * <p>
     * ȂxNgɑ΂Ẵ\bhĂ񂾏ꍇA
     * ł̓[xNgԂ悤ɂȂĂB
     * A{͗O JgclZeroLength 𓊂ׂłB
     * </p>
     * 
     * @return	PʉxNg
     */
    public JgclVector2D unitized() {
	if (unitized != null)
	    return unitized;

	double leng = length();
	if (!JgclUtil.isDividable(Math.max(x(), y()), leng)) {
	    // throw new JgclZeroLength();
	    return (unitized = zeroVector);
	}

	return (unitized = new JgclLiteralVector2D(x()/leng, y()/leng, true));
    }
	
    /**
     * e̕𔽓]xNgԂB
     *
     * @return	this 𔽓]xNg
     */
    public JgclVector2D reverse() {
	return new JgclLiteralVector2D(-x(), -y());
    }

    /**
     * gɐȃxNgɑIŕԂB
     *
     * @return	this ɐȃxNg
     */
    public JgclVector2D verticalVector() {
	return new JgclLiteralVector2D(-y(), x());
    }

    /**
     * ςԂB
     * 
     * @param mate	ς鑊̃xNg
     * @return	
     */
    public double dotProduct(JgclVector2D mate) {
	return x() * mate.x() + y() * mate.y();
    }

    /**
     * Oς Z ԂB
     * 
     * @param mate	Oς鑊̃xNg
     * @return		mate Ƃ̊Oς Z 
     */
    public double zOfCrossProduct(JgclVector2D mate) {
	return x() * mate.y() - y() * mate.x();
    }

    /**
     * xNgm̘aԂB
     * 
     * @param mate	a鑊̃xNg
     * @return		xNg̘a (this + mate)
     */
    public JgclVector2D add(JgclVector2D mate) {
	return new JgclLiteralVector2D(x()+mate.x(), y()+mate.y());
    }

    /**
     * xNgm̍ԂB
     * 
     * @param mate	鑊̃xNg
     * @return		xNg̍ (this - mate)
     */
    public JgclVector2D subtract(JgclVector2D mate) {
	return new JgclLiteralVector2D(x()-mate.x(), y()-mate.y());
    }

    /**
     * ^ꂽXP[悶xNgԂB
     * 
     * @param scale	XP[
     * @return		(this * scale)
     */
    public JgclVector2D multiply(double scale) {
	return new JgclLiteralVector2D(x() * scale, y() * scale);
    }

    /**
     * ^ꂽXP[ŊxNgԂB
     * 
     * @param scale	XP[
     * @return		(this / scale)
     */
    public JgclVector2D divide(double scale) {
	return new JgclLiteralVector2D(x() / scale, y() / scale);
    }

    /**
     * xNg̓ꐫ𔻒肷B
     * <p>
     * ̃xNg̍̑傫A
     * ݐݒ肳Ă鉉Źűe덷v菬΁A
     * ̃xNg͓ł̂ƔfB
     * </p>
     * 
     * @param mate	̑ΏۂƂȂxNg
     * @return	̃xNg̃xNgłƂ݂Ȃ trueAȂ false
     * @see	JgclConditionOfOperation
     * @see	#identicalDirection(JgclVector2D)
     */
    public boolean identical(JgclVector2D mate) {
	double dTol2 = getToleranceForDistance2();
	double xv, yv;

	xv = x() - mate.x();
	yv = y() - mate.y();

	return xv * xv + yv * yv < dTol2;
    }

    /**
     * xNg̓𔻒肷B
     * <p>
     * ̃xNĝȂpxA
     * ݐݒ肳Ă鉉Źupx̋e덷v菬΁A
     * ̃xNg͓ł̂ƔfB
     * </p>
     * 
     * @param mate	̑ΏۂƂȂxNg
     * @param allowReversed	]ĂԂ𓯈ƌȂȂ true
     * @return	̃xNg̃xNgƂ݂Ȃ trueAȂ false
     * @see	JgclConditionOfOperation
     * @see	#identical(JgclVector2D)
     * @see	#identicalDirection(JgclVector2D)
     * @see	#parallelDirection(JgclVector2D)
     */
    private boolean identicalDirection(JgclVector2D mate, boolean allowReversed) {
	double aTol = getToleranceForAngle();
	double dTol2 = getToleranceForDistance2();
	double dotProd, zOfCrossProd;
	boolean result; // return value

	if (this.norm() < dTol2 || mate.norm() < dTol2) {
	    result = true;
	} else {
	    dotProd = dotProduct(mate); // cos(theta)*|this|*|mate|
	    if (allowReversed)
		dotProd = Math.abs(dotProd);
	    zOfCrossProd = zOfCrossProduct(mate); // sin(theta)*|this|*|mate|
	    result = Math.abs(Math.atan2(zOfCrossProd, dotProd)) < aTol;
	}

	return result;
    }

    /**
     * xNg̓𔻒肷B
     * <p>
     * ̃xNĝȂpxA
     * ݐݒ肳Ă鉉Źupx̋e덷v菬΁A
     * ̃xNg͓ł̂ƔfB
     * </p>
     * <p>
     * ȂA]Ԃ͓Ƃ݂ȂȂB
     * </p>
     * 
     * @param mate	̑ΏۂƂȂxNg
     * @return	̃xNg̃xNgƂ݂Ȃ trueAȂ false
     * @see	JgclConditionOfOperation
     * @see	#identical(JgclVector2D)
     * @see	#parallelDirection(JgclVector2D)
     */
    public boolean identicalDirection(JgclVector2D mate) {
	return identicalDirection(mate, false);
    }

    /**
     * xNg̓𔻒肷B
     * <p>
     * ̃xNĝȂpxA
     * ݐݒ肳Ă鉉Źupx̋e덷v菬΁A
     * ̃xNg͓ł̂ƔfB
     * </p>
     * <p>
     * ȂA]ԂƂ݂ȂB
     * </p>
     * 
     * @param mate	̑ΏۂƂȂxNg
     * @return	̃xNg̃xNgƂ݂Ȃ trueAȂ false
     * @see	JgclConditionOfOperation
     * @see	#identicalDirection(JgclVector2D)
     */
    public boolean parallelDirection(JgclVector2D mate) {
	return identicalDirection(mate, true);
    }

    /**
     * xNg̃mԂB
     * 
     * @return	xNg̃m (x^2) + (y^2)
     */
    public double norm() {
	double xv = x();
	double yv = y();

	return xv * xv + yv * yv;
    }

    /**
     * Q̓_ (JgclPoint2D) ɕϊB
     *
     * @return	_̈ʒuxNgƂ݂Ȃ_
     */
    public JgclPoint2D toPoint2D() {
        return JgclPoint2D.of(x(), y());
    }

    /**
     * double̔zɕϊB
     *
     * @return ldouble̔z
     */
    public double[] toDoubleArray() {
        double[] array = {x(), y()};
	return array;
    }

    /*
     * ̃xNgƂ̊px (WA) ԂB
     * <p>
     * this  mate ւ̍̊px (0 ` 2pi)
     * </p>
     *
     * @param mate	̃xNg
     * @return	̃xNgƂ̊px
     */
    public double angleWith(JgclVector2D mate) {
	JgclVector2D thisUnitVec;
	JgclVector2D mateUnitVec;

	try {
	    thisUnitVec = this.unitized();
	    mateUnitVec = mate.unitized();
	}
	catch (JgclZeroLength e) {
	    return 0.0;
	}

	/*
	 * dot product --> radian
	 */
	double dotProduct = thisUnitVec.dotProduct(mateUnitVec);
	if (dotProduct >   1.0)  dotProduct = 1.0;
	if (dotProduct < (-1.0)) dotProduct = (- 1.0);

	double theta = Math.acos(dotProduct);

	if (thisUnitVec.zOfCrossProduct(mateUnitVec) < 0.0)
	    theta = (Math.PI * 2) - theta;

	return theta;
    }

    /**
     * ̃xNgA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected abstract JgclVector2D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator2D transformationOperator,
		  java.util.Hashtable transformedGeometries);

    /**
     * ̃xNgA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    public synchronized JgclVector2D
    transformBy(boolean reverseTransform,
		JgclCartesianTransformationOperator2D transformationOperator,
		java.util.Hashtable transformedGeometries)
    {
	if (transformedGeometries == null)
	    return this.doTransformBy(reverseTransform,
				      transformationOperator,
				      transformedGeometries);

	JgclVector2D transformed = (JgclVector2D)transformedGeometries.get(this);
	if (transformed == null) {
	    transformed = this.doTransformBy(reverseTransform,
					     transformationOperator,
					     transformedGeometries);
	    transformedGeometries.put(this, transformed);
	}
	return transformed;
    }

    /**
     * ̃xNgA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    public synchronized JgclVector2D
    transformBy(JgclCartesianTransformationOperator2D transformationOperator,
		java.util.Hashtable transformedGeometries)
    {
	return this.transformBy(false,
				transformationOperator,
				transformedGeometries);
    }

    /**
     * ̃xNgA^ꂽ􉽓IϊZqŋtϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŋtϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŋtϊ̂ԂB
     * </p>
     *
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	tϊ̊􉽗vf
     */
    public synchronized JgclVector2D
    reverseTransformBy(JgclCartesianTransformationOperator2D transformationOperator,
		       java.util.Hashtable transformedGeometries)
    {
	return this.transformBy(true,
				transformationOperator,
				transformedGeometries);
    }

    /**
     * JgclLiteralVector2D ̃CX^X𐶐B
     *
     * @param x	X 
     * @param y	Y 
     * @return	JgclLiteralVector2D ̃CX^X
     */
    public static JgclLiteralVector2D of(double x,
					 double y) {
	return new JgclLiteralVector2D(x, y);
    }

    /**
     * JgclLiteralVector2D ̃CX^X𐶐B
     *
     * @param components	X, Y̔z (vf 2)
     * @return	JgclLiteralVector2D ̃CX^X
     */
    public static JgclLiteralVector2D of(double[] components) {
	return new JgclLiteralVector2D(components);
    }
}
