/*
 * R : Ȗʂ̓֐l\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclSurfaceDerivative3D.java,v 1.20 2000/08/11 06:19:02 shikano Exp $
 */

package jp.go.ipa.jgcl;

/**
 * R : Ȗʂ̓֐l\NXB
 * <p>
 * ̃NX̃CX^X́A
 * Ȗ P ̂p[^l (u, v) ɂ
 * Ȗʏ̓_ P(u, v) ̒l (뎟֐l) d0A
 * U/V ꂼ̈̕ꎟΓ֐̒l du/dvA
 * U/V ꂼ̓̕񎟕Γ֐̒l duu/dvvA
 * UV ̈ꎟΓ֐̒l duv
 * ێB
 * </p>
 *
 * @version $Revision: 1.20 $, $Date: 2000/08/11 06:19:02 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclSurfaceDerivative3D extends JgclSurfaceDerivative {
    /**
     * Ȗʏ̓_ (뎟֐l) B
     */
    private final JgclPoint3D d0;

    /**
     * U ̈ꎟΓ֐lB
     */
    private final JgclVector3D du;

    /**
     * V ̈ꎟΓ֐lB
     */
    private final JgclVector3D dv;

    /**
     * U ̓񎟕Γ֐lB
     */
    private final JgclVector3D duu;

    /**
     * UV ̈ꎟΓ֐lB
     */
    private final JgclVector3D duv;

    /**
     * V ̓񎟕Γ֐lB
     */
    private final JgclVector3D dvv;

    /**
     * eΓ֐̒l^ăIuWFNg\z
     * 
     * @param d0	Ȗʏ̓_ (뎟֐l)
     * @param du	U ̈ꎟΓ֐l
     * @param dv	V ̈ꎟΓ֐l
     * @param duu	U ̓񎟕Γ֐l
     * @param duv	UV ̈ꎟΓ֐l
     * @param dvv	V ̓񎟕Γ֐l
     */
    public JgclSurfaceDerivative3D(JgclPoint3D d0,
				   JgclVector3D du,
				   JgclVector3D dv,
				   JgclVector3D duu,
				   JgclVector3D duv,
				   JgclVector3D dvv) {
        super();
	this.d0 = d0;
	this.du = du;
	this.dv = dv;
	this.duu = duu;
	this.duv = duv;
	this.dvv = dvv;
    }

    /**
     * ̓֐lIuWFNg̋Ȗʏ̓_ (뎟֐l) ԂB
     * 
     * @return	Ȗʏ̓_ (뎟֐l)
     */
    public JgclPoint3D d0() {
	return d0;
    }

    /**
     * ̓֐lIuWFNg U ̈ꎟΓ֐lԂB
     * 
     * @return	U ̈ꎟΓ֐l
     */
    public JgclVector3D du() {
	return du;
    }

    /**
     * ̓֐lIuWFNg V ̈ꎟΓ֐lԂB
     * 
     * @return	V ̈ꎟΓ֐l
     */
    public JgclVector3D dv() {
	return dv;
    }

    /**
     * ̓֐lIuWFNg U ̓񎟕Γ֐lԂB
     * 
     * @return	U ̓񎟕Γ֐l
     */
    public JgclVector3D duu() {
	return duu;
    }

    /**
     * ̓֐lIuWFNg UV ̈ꎟΓ֐lԂB
     * 
     * @return	UV ̈ꎟΓ֐l
     */
    public JgclVector3D duv() {
	return duv;
    }

    /**
     * ̓֐lIuWFNg V ̓񎟕Γ֐lԂB
     * 
     * @return	V ̓񎟕Γ֐l
     */
    public JgclVector3D dvv() {
	return dvv;
    }

    /**
     * ̓֐lIuWFNg̎ȗԂB
     *
     * @return	ȗƎ
     */
    public JgclSurfaceCurvature3D principalCurvature() {
	JgclVector3D UNV;
	double EEE, FFF, GGG;
	double LLL, MMM, NNN;
	double[] AAA = new double[3];
	int icnt;			// number of solution of the 2nd degree polynomial
	double XI, ETA;			// ratio of Xu & Xv
	double[] pcv;			// principle curvature [0]:max [1]:min
	JgclVector3D[] dir = new JgclVector3D[2];
	                                // direction of principle curvature [0]:max [1]:min
	int i;
	double m_eps = JgclMachineEpsilon.DOUBLE;
	JgclRealPolynomial poly;

	UNV = du.crossProduct(dv).unitized();
	LLL = UNV.x() * duu.x() + UNV.y() * duu.y() + UNV.z() * duu.z();
	MMM = UNV.x() * duv.x() + UNV.y() * duv.y() + UNV.z() * duv.z();
	NNN = UNV.x() * dvv.x() + UNV.y() * dvv.y() + UNV.z() * dvv.z();

	EEE = du.x() * du.x() + du.y() * du.y() + du.z() * du.z();
	FFF = du.x() * dv.x() + du.y() * dv.y() + du.z() * dv.z();
	GGG = dv.x() * dv.x() + dv.y() * dv.y() + dv.z() * dv.z();

	/*
	 * principal curvatures	- make & resolve the 2nd degree equation
	 */
	AAA[2] = EEE * GGG - FFF * FFF;
	if (Math.abs(AAA[2]) < m_eps) {
	    pcv = new double[2];
	    pcv[0] = pcv[1] = 0.0;
	    dir[0] = dir[1] = JgclVector3D.zeroVector;
	    return new JgclSurfaceCurvature3D(pcv, dir);
	}
	AAA[1] = 2.0 * FFF * MMM - EEE * NNN - GGG * LLL;
	AAA[0] = LLL * NNN - MMM * MMM;

	try {
	    poly = new JgclRealPolynomial(AAA);
	} catch (JgclInvalidArgumentValue e) {
	    throw new JgclFatal();
	}
	pcv = poly.getRootsIfQuadric();
	if ((pcv.length != 2) || (JgclCurveCurvature.identical(pcv[0], pcv[1]))) {
	    if (pcv.length != 2) pcv = new double[2];
	    /* umbilic point */
	    pcv[0] = pcv[1] = - AAA[1] / (2.0 * AAA[2]);
	    dir[0] = dir[1] = JgclVector3D.zeroVector;
	    return new JgclSurfaceCurvature3D(pcv, dir);
	}

	/*
	 * principal directions
	 */
	if ((Math.abs(MMM) < m_eps) && (Math.abs(FFF) < m_eps)) {
	    /*
	     * special case (when the execution reachs here, EEE & GGG are NOT zero)
	     */
	    double pcv_val = LLL / EEE;

	    if (Math.abs(pcv[0] - pcv_val) < Math.abs(pcv[1] - pcv_val)) {
		dir[0] = du;
		dir[1] = dv;
	    } else {
		dir[0] = dv;
		dir[1] = du;
	    }
	    for (i = 0; i < 2; i++)
		dir[i] = dir[i].unitized();

	} else {
	    /*
	     * general case
	     */
	    for (i = 0; i < 2; i++) {
		if (Math.abs(MMM - pcv[i] * FFF) > m_eps) {
		    XI = 1.0;
		    ETA = - (LLL - pcv[i] * EEE) / (MMM - pcv[i] * FFF);
		    dir[i] = new JgclLiteralVector3D(XI * du.x() + ETA * dv.x(),
						     XI * du.y() + ETA * dv.y(),
						     XI * du.z() + ETA * dv.z());
		} else {
		    dir[i] = dv;
		}
		dir[i] = dir[i].unitized();
	    }
	}

	if (Math.abs(pcv[0]) < Math.abs(pcv[1])) {
	    double swap1;
	    JgclVector3D swap2;
	    swap1 = pcv[0]; pcv[0] = pcv[1]; pcv[1] = swap1;
	    swap2 = dir[0]; dir[0] = dir[1]; dir[1] = swap2;
	}
	return new JgclSurfaceCurvature3D(pcv, dir);
    }
}

