/*
 * R : Ȗʂ̋ȗ\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclSurfaceCurvature3D.java,v 1.9 2000/08/11 06:19:02 shikano Exp $
 */

package jp.go.ipa.jgcl;

/**
 * R : Ȗʂ̋ȗ\NXB
 * <p>
 * ̃NX̃CX^X
 * ̎ȗɑΉ
 * PʉꂽxNg principalDirection1, principalDirection2
 * B
 * </p>
 *
 * @version $Revision: 1.9 $, $Date: 2000/08/11 06:19:02 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclSurfaceCurvature3D extends JgclSurfaceCurvature {
    /**
     * PʉꂽxNg1 (Ήȗ̐Βl傫) B
     */
    private JgclVector3D principalDirection1;

    /**
     * PʉꂽxNg2 (Ήȗ̐Βl) B
     */
    private JgclVector3D principalDirection2;

    /**
     * tB|hɒlݒ肷B
     * <p>
     * principalDirection1  principalDirection2 
     * ̃\bh̓ŒPʉĐݒ肳B
     * </p>
     * <p>
     * ȂAprincipalDirection1  principalDirection2 ̂ꂩ null łꍇɂ
     * JgclNullArgument ̗O𔭐B
     * <p>
     * 
     * @param principalDirection1	xNg1 (Ήȗ̐Βl傫)
     * @param principalDirection2	xNg2 (Ήȗ̐Βl)
     * @see	JgclNullArgument
     */
    private void setData(JgclVector3D principalDirection1,
			 JgclVector3D principalDirection2) {
	if (principalDirection1 == null || principalDirection2 == null)
	    throw new JgclNullArgument();

	this.principalDirection1 = principalDirection1.unitized();
	this.principalDirection2 = principalDirection2.unitized();
    }

    /**
     * ̎ȗƓ̎xNg^ăIuWFNg\zB
     * <p>
     * |principalCurvature1| &lt; |principalCurvature2| łꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * principalDirection1  principalDirection2 
     * ̃RXgN^̓ŒPʉĐݒ肳B
     * </p>
     * <p>
     * ȂAprincipalDirection1  principalDirection2 ̂ꂩ null łꍇɂ
     * JgclNullArgument ̗O𔭐B
     * <p>
     * 
     * @param principalCurvature1	ȗ1 (Βl̑傫)
     * @param principalDirection1	xNg1 (Ήȗ̐Βl傫)
     * @param principalCurvature2	ȗ2 (Βl̏)
     * @param principalDirection2	xNg2 (Ήȗ̐Βl)
     * @see	JgclInvalidArgumentValue
     * @see	JgclNullArgument
     */
    JgclSurfaceCurvature3D(double principalCurvature1,
			   JgclVector3D principalDirection1,
			   double principalCurvature2,
			   JgclVector3D principalDirection2) {
	super(principalCurvature1, principalCurvature2);
	setData(principalDirection1, principalDirection2);
    }

    /**
     * ̎ȗƓ̎xNg^ăIuWFNg\zB
     * <p>
     * principalCurvature ͓̗vfzłȂ΂ȂȂB
     * ̔z̗vf̐ 2 ȊOłꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * ܂AprincipalCurvature  null ̏ꍇɂ
     * JgclNullArgument ̗O𔭐B
     * ɁAŏ̗vf̐ΒlԖڂ̗vf̐Βlꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * principalDirection ̗vfzłȂ΂ȂȂB
     * ̔z̗vf̐ 2 ȊOłꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * ܂AprincipalDirection null łꍇɂ
     * JgclNullArgument ̗O𔭐B
     * z̃xNg͂ꂼꂪ
     * ̃RXgN^̓ŒPʉĐݒ肳B
     * </p>
     * <p>
     * ȂAprincipalDirection[i]  principalCurvature[i] ɑΉB
     * </p>
     * 
     * @param principalCurvature	ȗ̔z
     * @param principalDirection	xNg̔z
     * @see	JgclInvalidArgumentValue
     * @see	JgclNullArgument
     */
    JgclSurfaceCurvature3D(double[] principalCurvature,
			   JgclVector3D[] principalDirection) {
	super(principalCurvature);

	if (principalDirection == null)
	    throw new JgclNullArgument();

	if (principalDirection.length != 2)
	    throw new JgclInvalidArgumentValue();

	setData(principalDirection[0], principalDirection[1]);
    }

    /**
     * xNg1 (Ήȗ̐Βl傫) ԂB
     * 
     * @return	PʉꂽxNg1 (Ήȗ̐Βl傫)
     */
    public JgclVector3D principalDirection1() {
	return principalDirection1;
    }

    /**
     * xNg2 (Ήȗ̐Βl) ԂB
     * 
     * @return	PʉꂽxNg2 (Ήȗ̐Βl)
     */
    public JgclVector3D principalDirection2() {
	return principalDirection2;
    }
}

