/*
 * Ȗʂ̋ȗ\ۃNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclSurfaceCurvature.java,v 1.6 2000/04/26 09:39:24 hideit Exp $
 */

package jp.go.ipa.jgcl;

/**
 * Ȗʂ̋ȗ\ۃNXB
 * <p>
 * ̃NX̃CX^X
 * ̎ȗ̒l (l) principalCurvature1, principalCurvature2
 * B
 * A|principalCurvature1| &gt; |principalCurvature2| łB
 * </p>
 *
 * @version $Revision: 1.6 $, $Date: 2000/04/26 09:39:24 $
 * @author Information-technology Promotion Agency, Japan
 */

public abstract class JgclSurfaceCurvature {
    /**
     * ȗl1 (Βl̑傫) B
     */
    private double principalCurvature1;
 
    /**
     * ȗl2 (Βl̏) B
     */
    private double principalCurvature2;

    /**
     * tB|hɒlݒ肷B
     * <p>
     * |principalCurvature1| &lt; |principalCurvature2| łꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param principalCurvature1	ȗ1 (Βl̑傫)
     * @param principalCurvature2	ȗ2 (Βl̏)
     * @see	JgclInvalidArgumentValue
     */
    private void setData(double principalCurvature1, double principalCurvature2) {
	if (Math.abs(principalCurvature1) < Math.abs(principalCurvature2))
	    throw new JgclInvalidArgumentValue("|principalCurvature1| is less than |principalCurvature2|.");

	this.principalCurvature1 = principalCurvature1;
	this.principalCurvature2 = principalCurvature2;
    }

    /**
     * ̎ȗ̒l^ăIuWFNg\zB
     * <p>
     * |principalCurvature1| &lt; |principalCurvature2| łꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param principalCurvature1	ȗ1(Βl̑傫)
     * @param principalCurvature2	ȗ2(Βl̏)
     * @see	JgclInvalidArgumentValue
     */
    protected JgclSurfaceCurvature(double principalCurvature1,
                                   double principalCurvature2) {
	super();
	setData(principalCurvature1, principalCurvature2);
    }

    /**
     * ̎ȗ̒l^ăIuWFNg\zB
     * <p>
     * principalCurvature ͓̗vfzłȂ΂ȂȂB
     * ̔z̗vf̐ 2 ȊOłꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * ܂AprincipalCurvature  null ̏ꍇɂ
     * JgclNullArgument ̗O𔭐B
     * </p>
     * <p>
     * ŏ̗vf̐ΒlԖڂ̗vf̐Βlꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param principalCurvature	ȗ̔z
     * @see	JgclInvalidArgumentValue
     * @see	JgclNullArgument
     */
    protected JgclSurfaceCurvature(double[] principalCurvature) {
	super();

	if (principalCurvature == null)
	    throw new JgclNullArgument();

	if (principalCurvature.length != 2)
	    throw new JgclInvalidArgumentValue();

	setData(principalCurvature[0], principalCurvature[1]);
    }

    /**
     * ̋ȗIuWFNg̎ȗl1 (Βl̑傫) ԂB
     * 
     * @return	ȗl1 (Βl̑傫)
     */
    public double principalCurvature1() {
	return principalCurvature1;
    }

    /**
     * ̋ȗIuWFNg̎ȗl2 (Βl̏) ԂB
     * 
     * @return	ȗl2 (Βl̏)
     */
    public double principalCurvature2() {
	return principalCurvature2;
    }
}

