/*
 * R : `̃gȖʂ\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclRectangularTrimmedSurface3D.java,v 1.34 2000/08/11 06:19:02 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.*;

/**
 * R : `̃gȖʂ\NXB
 * <p>
 * `̃gȖʂ́AȖʂ (u, v) p[^Iɋ`ȈꕔLƂLȖʂłB
 * ꕔLƂ邱Ƃg~OA
 * LƂԂ̂Ƃg~OԂƂB
 * </p>
 * <p>
 * ̃NX̃CX^X́A
 * <ul>
 * <li> g~ȎΏۂƂȂȖ basisSurface
 * <li> g~OԂ U ̎n_\Ȗʏ̃p[^l uParam1
 * <li> g~OԂ U ̏I_\Ȗʏ̃p[^l uParam2
 * <li>	gȖʂ U isȖʂƓۂtO uSense
 * <li> g~OԂ V ̎n_\Ȗʏ̃p[^l vParam1
 * <li> g~OԂ V ̏I_\Ȗʏ̃p[^l vParam2
 * <li>	gȖʂ V isȖʂƓۂtO vSense
 * </ul>
 * ێB
 * </p>
 * <p>
 * gȖʂ̂̂ U ̒`͗LŔIȂ̂łA
 * p[^Ԃ [0, |uParam2 - uParam1|] ƂB
 * lɁA
 * V ̒`LŔIȂ̂łA
 * p[^Ԃ [0, |vParam2 - vParam1|] ƂB
 * </p>
 * <p>
 * <a name="CONSTRAINTS">[Ԃ̍S]</a>
 * </p>
 * <p>
 * basisSurface ͊J`ł邩A
 * g~OԂ`̎̋̕EׂłȂ̂ƂB
 * </p>
 * <p>
 * uParam1, uParam2  vParam1, vParam2 
 * basisSurface ̃p[^`Ɏ܂ĂȂ΂ȂȂB
 * </p>
 * <p>
 * Ȗʂ U IłꍇA
 * uSense  true  ł (uParam1 &lt; uParam2)
 * uSense  false ł (uParam1 &gt; uParam2)
 * łȂ΂ȂȂB
 * <br>
 * V ɂĂ̒lɂl݂̏B
 * </p>
 * <p>
 * Ȗʂ U IłꍇA
 * uSense  true  ł
 * uParam2 ̒l (uParam1 &lt; uParam2) 𖞂悤
 * ̃CX^X̓ŎIɏCB
 * l
 * uSense  false ł
 * uParam1 ̒l (uParam1 &gt; uParam2) 𖞂悤
 * ̃CX^X̓ŎIɏCB
 * <br>
 * V ɂĂ̒lɂl݂̏B
 * </p>
 *
 * @version $Revision: 1.34 $, $Date: 2000/08/11 06:19:02 $
 * @author Information-technology Promotion Agency, Japan
 */
public class JgclRectangularTrimmedSurface3D extends JgclBoundedSurface3D {
    /**
     * ȖʁB
     * @serial
     */
    JgclParametricSurface3D basisSurface;

    /**
     * g~OԂ U ̎n_\Ȗʏ̃p[^lB
     * @serial
     */
    private double uParam1;

    /**
     * g~OԂ U ̏I_\Ȗʏ̃p[^lB
     * @serial
     */
    private double uParam2;

    /**
     * gȖʂ U ̐isȖʂƓۂtOB
     * <p>
     * true ȂΓAfalse Ȃ΋tB
     * </p>
     * @serial
     */
    boolean uSense;

    /**
     * g~OԂ V ̎n_\Ȗʏ̃p[^lB
     * @serial
     */
    private double vParam1;

    /**
     * g~OԂ V ̏I_\Ȗʏ̃p[^lB
     * @serial
     */
    private double vParam2;

    /**
     * gȖʂ V ̐isȖʂƓۂtOB
     * <p>
     * true ȂΓAfalse Ȃ΋tB
     * </p>
     * @serial
     */
    boolean vSense;

    /**
     * g~O  U ̕Ȗʏł̃p[^ԁB
     * <p>
     * ̃tB[h́ÃNX̓ł̂ݗpB
     * </p>
     * @serial
     */
    private JgclParameterSection uTrimmingSectionOnBasis;

    /**
     * g~O  V ̕Ȗʏł̃p[^ԁB
     * <p>
     * ̃tB[h́ÃNX̓ł̂ݗpB
     * </p>
     * @serial
     */
    private JgclParameterSection vTrimmingSectionOnBasis;

    /**
     * g~OԂ̕Ȗʏł̋`ȃp[^Ԃ\
     * Q̃|CB
     * <p>
     * ̃tB[h́ÃNX̓ł̂ݗpB
     * </p>
     * @serial
     */
    private JgclPolyline2D boundaryCurve;

    /**
     * Ȗʂɑ΂p[^lgȖʂɑ΂p[^lɕϊ邽߂̕ϊZqB
     * @serial
     */
    private JgclCartesianTransformationOperator2D paramTransformer;

    /**
     * ^ꂽp[^lÃgȖʂ̕Ȗʂ U ̒`ɑ΂ėLۂ𒲂ׂB
     * <p>
     * ^ꂽp[^l̋Ȗʂ U ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * <p>
     * Ȗʂ U `łꍇɂ́A
     * ʂƂēp[^ĺAKvɉāAȖʂ U ̃p[^Ő܂܂B
     * </p>
     *
     * @param	uParam	U ̃p[^l
     * @return		KvɉāAȖʂ U ̃p[^Ő܂܂ꂽl
     * @see	JgclParameterDomain#wrap(double)
     * @see	JgclParameterOutOfRange
     */
    private double checkUParamValidity(double uParam)
    {
	if (basisSurface.isUPeriodic()) {
	    JgclParameterDomain domain = basisSurface.uParameterDomain();
	    return domain.wrap(uParam);
	}
	basisSurface.checkUValidity(uParam);

	return uParam;
    }

    /**
     * ^ꂽp[^lÃgȖʂ̕Ȗʂ V ̒`ɑ΂ėLۂ𒲂ׂB
     * <p>
     * ^ꂽp[^l̋Ȗʂ V ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * <p>
     * Ȗʂ V `łꍇɂ́A
     * ʂƂēp[^ĺAKvɉāAȖʂ V ̃p[^Ő܂܂B
     * </p>
     *
     * @param	vParam	V ̃p[^l
     * @return		KvɉāAȖʂ V ̃p[^Ő܂܂ꂽl
     * @see	JgclParameterDomain#wrap(double)
     * @see	JgclParameterOutOfRange
     */
    private double checkVParamValidity(double vParam)
    {
	if (basisSurface.isVPeriodic()) {
	    JgclParameterDomain domain = basisSurface.vParameterDomain();
	    return domain.wrap(vParam);
	}
	basisSurface.checkVValidity(vParam);

	return vParam;
    }

    /**
     * etB[hɒlݒ肷B
     * <p>
     * ̒l <a href="#CONSTRAINTS">[Ԃ̍S]</a> 𖞂Ȃꍇɂ́A
     * JgclParameterOutOfRange  JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param basisSurface	Ȗ
     * @param uParam1		U ̎n_\p[^l
     * @param uParam2		U ̏I_\p[^l
     * @param vParam1		V ̎n_\p[^l
     * @param vParam2		V ̏I_\p[^l
     * @param uSense		U ȖʂƓۂtO
     * @param vSense		V ȖʂƓۂtO
     * @see	JgclParameterOutOfRange
     * @see	JgclInvalidArgumentValue
     */
    private void setFields(JgclParametricSurface3D basisSurface,
			   double uParam1,
			   double uParam2,
			   double vParam1,
			   double vParam2,
			   boolean uSense,
			   boolean vSense)
    {
	this.basisSurface = basisSurface;

	uParam1 = checkUParamValidity(uParam1); this.uParam1 = uParam1;
	uParam2 = checkUParamValidity(uParam2); this.uParam2 = uParam2;
	vParam1 = checkVParamValidity(vParam1); this.vParam1 = vParam1;
	vParam2 = checkVParamValidity(vParam2); this.vParam2 = vParam2;
	double pTol = this.getToleranceForParameter();

	if ((Math.abs(uParam2 - uParam1) < pTol) ||
	    (Math.abs(vParam2 - vParam1) < pTol))
	    throw new JgclInvalidArgumentValue();

	if (basisSurface.isUPeriodic()) {
	    JgclParameterSection sec = basisSurface.uParameterDomain().section();
	    if (uSense == true) {
		if (uParam1 > uParam2)
		    this.uParam2 = uParam2 += sec.increase();
	    } else {
		if (uParam1 < uParam2)
		    this.uParam1 = uParam1 += sec.increase();
	    }
	} else {
	    if (uSense == true) {
		if (uParam1 > uParam2)
		    throw new JgclInvalidArgumentValue();
	    } else {
		if (uParam1 < uParam2)
		    throw new JgclInvalidArgumentValue();
	    }
	}

	if (basisSurface.isVPeriodic()) {
	    JgclParameterSection sec = basisSurface.vParameterDomain().section();
	    if (vSense == true) {
		if (vParam1 > vParam2)
		    this.vParam2 = vParam2 += sec.increase();
	    } else {
		if (vParam1 < vParam2)
		    this.uParam1 = vParam1 += sec.increase();
	    }
	} else {
	    if (vSense == true) {
		if (vParam1 > vParam2)
		    throw new JgclInvalidArgumentValue();
	    } else {
		if (vParam1 < vParam2)
		    throw new JgclInvalidArgumentValue();
	    }
	}

	this.uSense = uSense;
	this.vSense = vSense;

	this.uTrimmingSectionOnBasis =
	    new JgclParameterSection(this.uParam1, (this.uParam2 - this.uParam1));
	this.vTrimmingSectionOnBasis =
	    new JgclParameterSection(this.vParam1, (this.vParam2 - this.vParam1));

	JgclPoint2D[] boudnaryPoints = new JgclPoint2D[4];
	boudnaryPoints[0] = JgclPoint2D.of(this.uParam1, this.vParam1);
	boudnaryPoints[1] = JgclPoint2D.of(this.uParam2, this.vParam1);
	boudnaryPoints[2] = JgclPoint2D.of(this.uParam2, this.vParam2);
	boudnaryPoints[3] = JgclPoint2D.of(this.uParam1, this.vParam2);
	this.boundaryCurve = new JgclPolyline2D(boudnaryPoints, true);

	double diffU = - this.uParam1;
	JgclVector2D axisU = JgclVector2D.xUnitVector;
	if (this.uSense != true) {
	    diffU = - diffU;
	    axisU = axisU.reverse();
	}

	double diffV = - this.vParam1;
	JgclVector2D axisV = JgclVector2D.yUnitVector;
	if (this.vSense != true) {
	    diffV = - diffV;
	    axisV = axisV.reverse();
	}

	paramTransformer =
	    new JgclCartesianTransformationOperator2D(axisU, axisV,
						      JgclPoint2D.of(diffU, diffV),
						      1.0);
    }

    /**
     * etB[hɐݒ肷l^ăIuWFNg\zB
     * <p>
     * ̒l <a href="#CONSTRAINTS">[Ԃ̍S]</a> 𖞂Ȃꍇɂ́A
     * JgclParameterOutOfRange  JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param basisSurface	Ȗ
     * @param uParam1		U ̎n_\p[^
     * @param uParam2		U ̏I_\p[^
     * @param vParam1		V ̎n_\p[^
     * @param vParam2		V ̏I_\p[^
     * @param uSense		U ȖʂƓۂtO
     * @param vSense		V ȖʂƓۂtO
     * @see	JgclParameterOutOfRange
     * @see	JgclInvalidArgumentValue
     */
    public JgclRectangularTrimmedSurface3D(JgclParametricSurface3D basisSurface,
					   double uParam1,
					   double uParam2,
					   double vParam1,
					   double vParam2,
					   boolean uSense,
					   boolean vSense)
    {
	super();
	setFields(basisSurface,
		  uParam1, uParam2,
		  vParam1, vParam2,
		  uSense, vSense);
    }

    /**
     * Ȗʂ U/V õp[^Ԃ^ăIuWFNg\zB
     * <p>
     * ̒l <a href="#CONSTRAINTS">[Ԃ̍S]</a> 𖞂Ȃꍇɂ́A
     * JgclParameterOutOfRange  JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param basicSurface Ȗ
     * @param uPint	U ̃g~OԂ\p[^
     * @param vPint	V ̃g~OԂ\p[^
     * @see	JgclParameterOutOfRange
     * @see	JgclInvalidArgumentValue
     */
    public JgclRectangularTrimmedSurface3D(JgclParametricSurface3D basisSurface,
					   JgclParameterSection uPint,
					   JgclParameterSection vPint)
    {
	super();
	setFields(basisSurface,
		  uPint.start(), uPint.end(),
		  vPint.start(), vPint.end(),
		  (uPint.increase() > 0.0),
		  (vPint.increase() > 0.0));
    }

    /**
     * ̃gȖʂ̕ȖʂԂB
     *
     * @return	Ȗ
     */
    public JgclParametricSurface3D basisSurface() {
	return this.basisSurface;
    }

    /**
     * ̃gȖʂ̃g~OԂ U ̎n_\Ȗʏ̃p[^lԂB
     * 
     * @return	g~OԂ U ̎n_\Ȗʏ̃p[^l
     */
    public double uParam1() {
	return this.uParam1;
    }

    /**
     * ̃gȖʂ̃g~OԂ U ̏I_\Ȗʏ̃p[^lԂB
     * 
     * @return	g~OԂ U ̏I_\Ȗʏ̃p[^l
     */
    public double uParam2() {
	return this.uParam2;
    }

    /**
     * ̃gȖʂ̃g~OԂ V ̎n_\Ȗʏ̃p[^lԂB
     * 
     * @return	g~OԂ V ̎n_\Ȗʏ̃p[^l
     */
    public double vParam1() {
	return this.vParam1;
    }

    /**
     * ̃gȖʂ̃g~OԂ V ̏I_\Ȗʏ̃p[^lԂB
     * 
     * @return	g~OԂ V ̏I_\Ȗʏ̃p[^l
     */
    public double vParam2() {
	return this.vParam2;
    }

    /**
     * ̃gȖʂ U isȖʂƓۂԂB
     * 
     * @return		U ̐isȖʂƓȂ trueAȂ false
     */
    public boolean uSense() {
	return this.uSense;
    }

    /**
     * ̃gȖʂ V isȖʂƓۂԂB
     * 
     * @return		V ̐isȖʂƓȂ trueAȂ false
     */
    public boolean vSense() {
	return this.vSense;
    }

    /**
     * ̋Ȗʂ U ̃p[^`ԂB
     * <p>
     * [0, |uParam2 - uParam1|] ԂB
     * </p>
     * 
     * @return	LŔIȃp[^`
     */
    JgclParameterDomain getUParameterDomain()
    {
	try {
	    return new JgclParameterDomain(false, 0,
					   Math.abs(uParam2 - uParam1));
	}
	catch (JgclInvalidArgumentValue e) {
	    // should never be occurred
	    throw new JgclFatal();
	}
    }

    /**
     * ̋Ȗʂ V ̃p[^`ԂB
     * <p>
     * [0, |vParam2 - vParam1|] ԂB
     * </p>
     * 
     * @return	LŔIȃp[^`
     */
    JgclParameterDomain getVParameterDomain()
    {
	try {
	    return new JgclParameterDomain(false, 0,
					   Math.abs(vParam2 - vParam1));
	}
	catch (JgclInvalidArgumentValue e) {
	    // should never be occurred
	    throw new JgclFatal();
	}
    }

    /**
     * gȖʂ U ̃p[^lȖʂ̂ɕϊB
     * <p>
     * uParam ÃgȖʂ U ̃p[^`Oꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param uParam	gȖʂ U ̃p[^l
     * @return		Ȗʂ U ̃p[^l
     * @see	JgclParameterOutOfRange
     */
    public double toBasisUParameter(double uParam) {
	checkUValidity(uParam);

	return (uSense == true) ? (uParam1 + uParam) : (uParam1 - uParam);
    }

    /**
     * gȖʂ V ̃p[^lȖʂ̂ɕϊB
     * <p>
     * vParam ÃgȖʂ V ̃p[^`Oꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param uParam	gȖʂ V ̃p[^l
     * @return		Ȗʂ V ̃p[^l
     * @see	JgclParameterOutOfRange
     */
    public double toBasisVParameter(double vParam) {
	checkVValidity(vParam);

	return (vSense == true) ? (vParam1 + vParam) : (vParam1 - vParam);
    }

    /**
     * gȖʂ U ̃p[^ԂȖʂ̂ɕϊB
     * <p>
     * uPint ÃgȖʂ U ̃p[^`Oꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param uPint	gȖʂ U ̃p[^
     * @return		Ȗʂ U ̃p[^
     * @see	JgclParameterOutOfRange
     */
    public JgclParameterSection toBasisUParameter(JgclParameterSection uPint) {
	double sp = toBasisUParameter(uPint.start());
	double ep = toBasisUParameter(uPint.end());

	return new JgclParameterSection(sp, ep - sp);
    }

    /**
     * gȖʂ V ̃p[^ԂȖʂ̂ɕϊB
     * <p>
     * vPint ÃgȖʂ V ̃p[^`Oꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param vPint	gȖʂ V ̃p[^
     * @return		Ȗʂ V ̃p[^
     * @see	JgclParameterOutOfRange
     */
    public JgclParameterSection toBasisVParameter(JgclParameterSection vPint) {
	double sp = toBasisVParameter(vPint.start());
	double ep = toBasisVParameter(vPint.end());

	return new JgclParameterSection(sp, ep - sp);
    }

    /**
     * Ȗʂ U ̃p[^lgȖʂ̂ɕϊB
     * 
     * @param uParam	Ȗʂ U ̃p[^l
     * @return		gȖʂ U ̃p[^l
     */
    public double toOwnUParameter(double uParam) {
	return (uSense == true) ? (uParam - uParam1) : (uParam1 - uParam);
    }

    /**
     * Ȗʂ V ̃p[^lgȖʂ̂ɕϊB
     * 
     * @param vParam	Ȗʂ V ̃p[^l
     * @return		gȖʂ V ̃p[^l
     */
    public double toOwnVParameter(double vParam) {
	return (vSense == true) ? (vParam - vParam1) : (vParam1 - vParam);
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricSurface3D#RECTANGULAR_TRIMMED_SURFACE_3D JgclParametricSurface3D.RECTANGULAR_TRIMMED_SURFACE_3D}
     */
    int type()
    {
	return JgclParametricSurface3D.RECTANGULAR_TRIMMED_SURFACE_3D;
    }

    /**
     * ̊􉽗vfR`󂩔ۂԂB
     *
     * @return	ȖʂR`ł trueAłȂ false
     */
    public boolean isFreeform() {
	return this.basisSurface.isFreeform();
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̍WlԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param uParam	U ̃p[^l
     * @param vParam	V ̃p[^l
     * @return		Wl
     * @see	JgclParameterOutOfRange
     */
    public JgclPoint3D coordinates(double uParam,
				  double vParam)
    {
	return basisSurface.coordinates(toBasisUParameter(uParam),
					toBasisVParameter(vParam));
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̐ڃxNgԂB
     * <p>
     * ł̐ڃxNgƂ́Ap[^ U/V ̊eXɂĂ̈ꎟΓ֐łB
     * </p>
     * <p>
     * ʂƂĕԂz̗vf 2 łB
     * z̍ŏ̗vfɂ U p[^ɂĂ̐ڃxNgA
     * Ԗڂ̗vfɂ V p[^ɂĂ̐ڃxNg܂ށB
     * </p>
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param	uParam	U ̃p[^l
     * @param	vParam	V ̃p[^l
     * @return		ڃxNg
     * @see	JgclParameterOutOfRange
     */
    public JgclVector3D[] tangentVector(double uParam,
					double vParam)
    {
	return basisSurface.tangentVector(toBasisUParameter(uParam),
					  toBasisVParameter(vParam));
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̕Γ֐ԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param uParam	U ̃p[^l
     * @param vParam	V ̃p[^l
     * @return		Γ֐
     * @see	JgclParameterOutOfRange
     */
    public JgclSurfaceDerivative3D evaluation(double uParam,
					      double vParam)
    {
	return basisSurface.evaluation(toBasisUParameter(uParam),
				       toBasisVParameter(vParam));
    }

    /**
     * ^ꂽ_炱̋Ȗʂւ̓e_߂B
     * <p>
     * e_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ^ꂽ_炱̋Ȗʂ̕Ȗʂւ̓e_߁A
     * ̓ł̋Ȗʂ̃g~OԂOĂȂ̂̋Ȗʂւ̓e_ƂĂB
     * </p>
     * 
     * @param point	e̓_
     * @return		e_̔z
     * @exception JgclIndefiniteSolution	sł
     */
    public JgclPointOnSurface3D[] projectFrom(JgclPoint3D point)
	 throws JgclIndefiniteSolution
    {
	JgclPointOnSurface3D[] basisResults = basisSurface.projectFrom(point);

	Vector thisResults = new Vector();

	for (int i = 0; i < basisResults.length; i++) {
 	    double uParam = toOwnUParameter(basisResults[i].uParameter());
 	    double vParam = toOwnVParameter(basisResults[i].vParameter());

	    if (this.contains(uParam, vParam) == true)
		thisResults.addElement(new JgclPointOnSurface3D(this, uParam, vParam, doCheckDebug));
	}

 	JgclPointOnSurface3D[] results = new JgclPointOnSurface3D[thisResults.size()];
	thisResults.copyInto(results);

	return results;
    }

    /**
     *  (`̃p[^`) LȖʑŜA^ꂽ덷ŕʋߎ
     * iq_QԂB
     * <p>
     * ʂƂĕԂiq_Q\_́A
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D 
     * 邱Ƃ҂łB
     * </p>
     * 
     * @param tol	̋e덷
     * @return		̗LȖʑŜ𕽖ʋߎiq_Q
     * @see		JgclPointOnSurface3D
     */
    public JgclMesh3D toMesh(JgclToleranceForDistance tol)
    {
	return this.toMesh(true,
			   this.uTrimmingSectionOnBasis,
			   this.vTrimmingSectionOnBasis,
			   tol);
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂA^ꂽ덷ŕʋߎ
     * iq_QԂB
     * <p>
     * ʂƂĕԂiq_Q\_́A
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D 
     * 邱Ƃ҂łB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @param tol	̋e덷
     * @return		̋Ȗʂ̎w̋Ԃ𕽖ʋߎiq_Q
     * @see	JgclPointOnSurface3D
     * @see	JgclParameterOutOfRange
     */
    public JgclMesh3D toMesh(JgclParameterSection uPint,
			     JgclParameterSection vPint,
			     JgclToleranceForDistance tol)
    {
	return this.toMesh(false, uPint, vPint, tol);
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂA^ꂽ덷ŕʋߎ
     * iq_QԂB
     * <p>
     * ʂƂĕԂiq_Q\_́A
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D 
     * 邱Ƃ҂łB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param parametersAreOnBasis	p[^ԂȖʂɑ΂Ăۂ
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @param tol	̋e덷
     * @return		̋Ȗʂ̎w̋Ԃ𕽖ʋߎiq_Q
     * @see	JgclPointOnSurface3D
     * @see	JgclParameterOutOfRange
     * @see	#toMesh(JgclToleranceForDistance)
     * @see	#toMesh(JgclParameterSection, JgclParameterSection, JgclToleranceForDistance)
     */
    private JgclMesh3D toMesh(boolean parametersAreOnBasis,
			      JgclParameterSection uPint,
			      JgclParameterSection vPint,
			      JgclToleranceForDistance tol)
    {
	if (parametersAreOnBasis != true) {
	    uPint = toBasisUParameter(uPint);
	    vPint = toBasisUParameter(vPint);
	}

	JgclMesh3D basisMesh = basisSurface.toMesh(uPint, vPint, tol);

	JgclPoint3D[][] thisPoints = new JgclPoint3D[basisMesh.uNPoints()][basisMesh.vNPoints()];

	for (int u = 0; u < basisMesh.uNPoints(); u++) {
	    for (int v = 0; v < basisMesh.vNPoints(); v++) {
		JgclPointOnSurface3D basisPoint =
		    (JgclPointOnSurface3D)basisMesh.pointAt(u, v);
		thisPoints[u][v] =
		    new JgclPointOnSurface3D(this,
					     toOwnUParameter(basisPoint.uParameter()),
					     toOwnVParameter(basisPoint.vParameter()),
					     doCheckDebug);
	    }
	}

	return new JgclMesh3D(thisPoints, basisMesh.uClosed(), basisMesh.vClosed());
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂɍČ
     * L Bspline ȖʂԂB
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @return		̋Ȗʂ̎w̋ԂČL Bspline Ȗ
     * @see	JgclParameterOutOfRange
     */
    public JgclBsplineSurface3D toBsplineSurface(JgclParameterSection uPint,
						 JgclParameterSection vPint)
    {
	return basisSurface.toBsplineSurface(toBasisUParameter(uPint),
					     toBasisVParameter(vPint));
    }

    /**
     * ̋ȖʂƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̋Ȗʂ̕ȖʂƑ̋ȐƂ̌_߁A
     * ̓ł̋Ȗʂ̃g~OԂOĂȂ̂̋ȖʂƑ̋Ȑ̌_ƂĂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		_̔z
     * @exception JgclIndefiniteSolution	sł
     */
    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate)
	throws JgclIndefiniteSolution
    {
	JgclIntersectionPoint3D[] results = this.basisSurface.intersect(mate);

	return this.selectInternalIntersections(results, false);
    }

    /**
     * ̋ȖʂƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̋Ȗʂ̕ȖʂƑ̋ȐƂ̌_߁A
     * ̓ł̋Ȗʂ̃g~OԂOĂȂ̂̋ȖʂƑ̋Ȑ̌_ƂĂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception JgclIndefiniteSolution	sł
     */
    JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate, boolean doExchange)
	throws JgclIndefiniteSolution
    {
	JgclIntersectionPoint3D[] results = this.basisSurface.intersect(mate);

	return this.selectInternalIntersections(results, doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̋Ȗʂ̕ȖʂƑ̋ȐƂ̌_߁A
     * ̓ł̋Ȗʂ̃g~OԂOĂȂ̂̋ȖʂƑ̋Ȑ̌_ƂĂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception JgclIndefiniteSolution	sł
     */
    JgclIntersectionPoint3D[] intersect(JgclLine3D mate,
					boolean doExchange)
	 throws JgclIndefiniteSolution
    {
	JgclIntersectionPoint3D[] results = this.basisSurface.intersect(mate, doExchange);
	return this.selectInternalIntersections(results, doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȑ (~Ȑ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̋Ȗʂ̕ȖʂƑ̋ȐƂ̌_߁A
     * ̓ł̋Ȗʂ̃g~OԂOĂȂ̂̋ȖʂƑ̋Ȑ̌_ƂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (~Ȑ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception JgclIndefiniteSolution	sł
     */
    JgclIntersectionPoint3D[] intersect(JgclConic3D mate,
					boolean doExchange)
	 throws JgclIndefiniteSolution
    {
	JgclIntersectionPoint3D[] results = this.basisSurface.intersect(mate, doExchange);
	return this.selectInternalIntersections(results, doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȑ (xWGȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̋Ȗʂ̕ȖʂƑ̋ȐƂ̌_߁A
     * ̓ł̋Ȗʂ̃g~OԂOĂȂ̂̋ȖʂƑ̋Ȑ̌_ƂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (xWGȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception JgclIndefiniteSolution	sł
     */
    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate,
					boolean doExchange)
	 throws JgclIndefiniteSolution
    {
	JgclIntersectionPoint3D[] results = this.basisSurface.intersect(mate, doExchange);
	return this.selectInternalIntersections(results, doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȑ (aXvCȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̋Ȗʂ̕ȖʂƑ̋ȐƂ̌_߁A
     * ̓ł̋Ȗʂ̃g~OԂOĂȂ̂̋ȖʂƑ̋Ȑ̌_ƂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (aXvCȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception JgclIndefiniteSolution	sł
     */
    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate,
					boolean doExchange)
	 throws JgclIndefiniteSolution
    {
	JgclIntersectionPoint3D[] results = this.basisSurface.intersect(mate, doExchange);
	return this.selectInternalIntersections(results, doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗʂ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ȖʂӏɂẮA (JgclIntersectionCurve3D) ԂB
     * </p>
     * <p>
     * ȖʂڂӏɂẮA_ (JgclIntersectionPoint3D) Ԃ邱ƂB
     * </p>
     * 
     * @param mate	̋Ȗ
     * @return		 (܂͌_) ̔z
     * @see		JgclIntersectionCurve3D
     * @see		JgclIntersectionPoint3D
     * @exception JgclIndefiniteSolution	sł
     */
    public JgclSurfaceSurfaceInterference3D[] intersect(JgclParametricSurface3D mate)
	 throws JgclIndefiniteSolution
    {
	JgclSurfaceSurfaceInterference3D[] results;
	int basisType = this.basisSurface.type();
	if ((basisType == JgclParametricSurface3D.SURFACE_OF_LINEAR_EXTRUSION_3D) ||
	    (basisType == JgclParametricSurface3D.SURFACE_OF_REVOLUTION_3D)) {
	    results = ((JgclSweptSurface3D)this.basisSurface).
		intersect(this.uTrimmingSectionOnBasis, this.vTrimmingSectionOnBasis, mate);
	} else {
	    results = this.basisSurface.intersect(mate);
	}

	return this.trimIntersectionsWithBoundaries(mate, results, false);
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂItZbgȖʂ
     * ^ꂽ덷ŋߎ Bspline Ȗʂ߂B
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.FRONT/BACK)
     * @param tol     	̋e덷
     * @return		̋Ȗʂ̎w̋`Ԃ̃ItZbgȖʂߎ Bspline Ȗ
     * @see	JgclWhichSide
     */
    public JgclBsplineSurface3D offsetByBsplineSurface(JgclParameterSection uPint,
						       JgclParameterSection vPint,
						       double magni,
						       int side,
						       JgclToleranceForDistance tol)
    {
	JgclBsplineSurface3D convertedBspline =
	    this.toBsplineSurface(uPint, vPint);

  	return convertedBspline.offsetByBsplineSurface(
  			convertedBspline.uParameterDomain().section(),
  			convertedBspline.vParameterDomain().section(),
  			magni,side, tol);
    }

    /*
     * ̋Ȗʂ U p[^̈ʒuɂ铙p[^ȐԂB
     *
     * @param uParam	U ̃p[^l
     * @return	w U p[^lł̓p[^Ȑ
     */
    public JgclParametricCurve3D uIsoParametricCurve(double uParam)
	throws JgclReducedToPoint
    {
	JgclParametricCurve3D basisCurve = basisSurface.uIsoParametricCurve(toBasisUParameter(uParam));
	return new JgclTrimmedCurve3D(basisCurve, vTrimmingSectionOnBasis);
    }

    /*
     * ̋Ȗʂ V p[^̈ʒuɂ铙p[^ȐԂB
     *
     * @param vParam	V ̃p[^l
     * @return	w V p[^lł̓p[^Ȑ
     */
    public JgclParametricCurve3D vIsoParametricCurve(double vParam)
	throws JgclReducedToPoint
    {
	JgclParametricCurve3D basisCurve = basisSurface.vIsoParametricCurve(toBasisVParameter(vParam));
	return new JgclTrimmedCurve3D(basisCurve, uTrimmingSectionOnBasis);
    }

    /**
     * ̋ȖʂƑ̋Ȗ () ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̋Ȗʂ̕ȖʂƑ̋ȖʂƂ̊Ԃŋ߂
     * ̋Ȗʂ̃g~OԂŃg~Ô̋ȖʂƑ̋Ȗʂ̌ƂĂB
     * </p>
     * 
     * @param mate	̋Ȗ ()
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     * @exception JgclIndefiniteSolution	sł
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclPlane3D mate,
						 boolean doExchange)
	 throws JgclIndefiniteSolution
    {
	JgclSurfaceSurfaceInterference3D[] results = this.basisSurface.intersect(mate, doExchange);
	return this.trimIntersectionsWithBoundaries(mate, results, doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ () ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̋Ȗʂ̕ȖʂƑ̋ȖʂƂ̊Ԃŋ߂
     * ̋Ȗʂ̃g~OԂŃg~Ô̋ȖʂƑ̋Ȗʂ̌ƂĂB
     * </p>
     * 
     * @param mate	̋Ȗ ()
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     * @exception JgclIndefiniteSolution	sł
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclSphericalSurface3D mate,
						 boolean doExchange)
	 throws JgclIndefiniteSolution
    {
	JgclSurfaceSurfaceInterference3D[] results = this.basisSurface.intersect(mate, doExchange);
	return this.trimIntersectionsWithBoundaries(mate, results, doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ (~) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̋Ȗʂ̕ȖʂƑ̋ȖʂƂ̊Ԃŋ߂
     * ̋Ȗʂ̃g~OԂŃg~Ô̋ȖʂƑ̋Ȗʂ̌ƂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (~)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     * @exception JgclIndefiniteSolution	sł
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclCylindricalSurface3D mate,
						 boolean doExchange)
	 throws JgclIndefiniteSolution
    {
	JgclSurfaceSurfaceInterference3D[] results = this.basisSurface.intersect(mate, doExchange);
	return this.trimIntersectionsWithBoundaries(mate, results, doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ (~) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̋Ȗʂ̕ȖʂƑ̋ȖʂƂ̊Ԃŋ߂
     * ̋Ȗʂ̃g~OԂŃg~Ô̋ȖʂƑ̋Ȗʂ̌ƂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (~)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     * @exception JgclIndefiniteSolution	sł
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclConicalSurface3D mate,
						 boolean doExchange)
	 throws JgclIndefiniteSolution
    {
	JgclSurfaceSurfaceInterference3D[] results = this.basisSurface.intersect(mate, doExchange);
	return this.trimIntersectionsWithBoundaries(mate, results, doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ (xWGȖ) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̋Ȗʂ̕ȖʂƑ̋ȖʂƂ̊Ԃŋ߂
     * ̋Ȗʂ̃g~OԂŃg~Ô̋ȖʂƑ̋Ȗʂ̌ƂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (xWGȖ)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclPureBezierSurface3D mate,
						 boolean doExchange)
    {
	JgclSurfaceSurfaceInterference3D[] results = this.basisSurface.intersect(mate, doExchange);
	return this.trimIntersectionsWithBoundaries(mate, results, doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ (aXvCȖ) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̋Ȗʂ̕ȖʂƑ̋ȖʂƂ̊Ԃŋ߂
     * ̋Ȗʂ̃g~OԂŃg~Ô̋ȖʂƑ̋Ȗʂ̌ƂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (aXvCȖ)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclBsplineSurface3D mate,
						 boolean doExchange)
    {
	JgclSurfaceSurfaceInterference3D[] results = this.basisSurface.intersect(mate, doExchange);
	return this.trimIntersectionsWithBoundaries(mate, results, doExchange);
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂA
     * ^ꂽ덷ŕʋߎ_QԂB
     * <p>
     * ʂƂē_Q͈ʂɁAʑIɂ􉽓IɂAiqł͂ȂB
     * </p>
     * <p>
     * scalingFactor ́A͗pł͂ȂAo͗p̈łB
     * scalingFactor ɂ́Avf 2 ̔z^B
     * scalingFactor[0] ɂ U ̏kڔ{A
     * scalingFactor[1] ɂ V ̏kڔ{ԂB
     * ̒l͉炩̐Βlł͂ȂA
     * p[^̐iޑx T ɑ΂āA
     * U/V ɂĎԏŋȖʏ̓_iޑx Pu/Pv \ΒlłB
     * ܂Ap[^ T iނƁA
     * ԏł̋Ȗʏ̓_ U ł Pu (scalingFactor[0])A
     * V ł Pv (scalingFactor[1]) iނƂ\ĂB
     * T ̑傫͖Ȃ̂ŁA̒lQƂۂɂ́A
     * scalingFactor[0]  scalingFactor[1] ̔䂾pׂłB
     * ȂA̒l͂܂łڈłAȑx̂ł͂ȂB
     * </p>
     * <p>
     * ʂƂĕԂ Vector Ɋ܂܂evf
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D
     * ł邱Ƃ҂łB
     * </p>
     *
     * @param uParameterSection	U ̃p[^
     * @param vParameterSection	V ̃p[^
     * @param tolerance	̋e덷
     * @param scalingFactor	_QOp`ۂɗLpƎv U/V ̏kڔ{
     * @return	_Q܂ Vector
     * @see	JgclPointOnSurface3D
     */
    public Vector toNonStructuredPoints(JgclParameterSection uParameterSection,
					JgclParameterSection vParameterSection,
					double tolerance,
					double[] scalingFactor) {
	Vector basisResults =
	    basisSurface.toNonStructuredPoints(toBasisUParameter(uParameterSection),
					       toBasisVParameter(vParameterSection),
					       tolerance,
					       scalingFactor);
	Vector results = new Vector();
	for (Enumeration e = basisResults.elements(); e.hasMoreElements();) {
	    JgclPointOnSurface3D pos = (JgclPointOnSurface3D)e.nextElement();
	    results.addElement(new JgclPointOnSurface3D(this,
							toOwnUParameter(pos.uParameter()),
							toOwnVParameter(pos.vParameter()),
							doCheckDebug));
	}

	return results;
    }

    /**
     * ^ꂽp[^lA̋Ȗʂ̋E̓ɂ邩ۂԂB
     * <p>
     * ^ꂽp[^lEɂꍇɂ́uvƔfB
     * </p>
     *
     * @param uParam	U ̃p[^l
     * @param vParam	V ̃p[^l
     * @return	p[^lE̓ł trueAłȂ false
     */
    public boolean contains(double uParam,
			    double vParam) {
	if (this.isValidUParameter(uParam) != true) {
	    return false;
	}

	if (this.isValidVParameter(vParam) != true) {
	    return false;
	}

	return true;
    }

    /**
     * ^ꂽp[^lA̋Ȗʂ̋E̓ɂ邩ۂԂB
     * <p>
     * point2D Eɂꍇɂ́uvƔfB
     * </p>
     *
     * @param point2D	(u, v) p[^l
     * @return	point2D E̓ł trueAłȂ false
     */
    public boolean contains(JgclPoint2D point2D) {
	return this.contains(point2D.x(), point2D.y());
    }

    /**
     * ^ꂽuȖʂɑ΂vp[^lA̋Ȗʂ̋E̓ɂ邩ۂԂB
     * <p>
     * ^ꂽp[^lEɂꍇɂ́uvƔfB
     * </p>
     *
     * @param uParam	Ȗʂɑ΂ U ̃p[^l
     * @param vParam	Ȗʂɑ΂ V ̃p[^l
     * @return	p[^lE̓ł trueAłȂ false
     */
    public boolean containsBasis(double uParam,
				 double vParam) {
	if (uTrimmingSectionOnBasis.isValid(uParam) != true)
	    return false;

	if (vTrimmingSectionOnBasis.isValid(vParam) != true)
	    return false;

	return true;
    }

    /**
     * ^ꂽuȖʂɑ΂vp[^lA̋Ȗʂ̋E̓ɂ邩ۂԂB
     * <p>
     * point2D Eɂꍇɂ́uvƔfB
     * </p>
     *
     * @param point2D	Ȗʂɑ΂ (u, v) p[^l
     * @return	point2D E̓ł trueAłȂ false
     */
    public boolean containsBasis(JgclPoint2D point2D) {
	return this.containsBasis(point2D.x(), point2D.y());
    }

    /**
     * ^ꂽuȖʂɑ΂vp[^lE̓ɂ邩ۂԂB
     * <p>
     * ^ꂽp[^lȖʂ̃p[^` wrap ɁA
     * {@link #containsBasis(double, double) containsBasis(double, double)}
     * ĂяoB
     * </p>
     *
     * @param uParam	Ȗʂɑ΂ U ̃p[^l
     * @param vParam	Ȗʂɑ΂ V ̃p[^l
     * @return	p[^lE̓ł trueAłȂ false
     * @see	#containsBasis(double, double)
     * @see	JgclParameterDomain#wrap(double)
     */
    private boolean containsBasisWithWrapping(double uParam,
					      double vParam) {
	return this.containsBasis(basisSurface.uParameterDomain().wrap(uParam),
				  basisSurface.vParameterDomain().wrap(vParam));
    }

    /**
     * ^ꂽuȖʂɑ΂vp[^lE̓ɂ邩ۂԂB
     * <p>
     * ^ꂽp[^lȖʂ̃p[^` wrap ɁA
     * {@link #containsBasis(double, double) containsBasis(double, double)}
     * ĂяoB
     * </p>
     *
     * @param point2D	Ȗʂɑ΂ (u, v) p[^l
     * @return	point2D E̓ł trueAłȂ false
     * @see	#containsBasis(double, double)
     * @see	JgclParameterDomain#wrap(double)
     */
    private boolean containsBasisWithWrapping(JgclPoint2D point2D) {
	return this.containsBasis(basisSurface.uParameterDomain().wrap(point2D.x()),
				  basisSurface.vParameterDomain().wrap(point2D.y()));
    }

    /**
     * ^ꂽuȖʂɑ΂v_A̋Ȗʂ̋E̓ɂ邩ۂԂB
     *
     * @param ints	Ȗʂɑ΂_
     * @param doExchange	_ pointOnGeometry1/2 邩
     * @return	_Eɓɂ trueAłȂ false
     * @see	#containsBasisWithWrapping(double, double)
     * @see	#selectInternalIntersections(JgclIntersectionPoint3D[], boolean)
     */
    private boolean
    intersectionIsInternal(JgclIntersectionPoint3D ints,
			   boolean doExchange)
    {
	JgclPointOnSurface3D pointOnSurface;
	if (doExchange == false) {
	    pointOnSurface = (JgclPointOnSurface3D)ints.pointOnGeometry1();
	} else {
	    pointOnSurface = (JgclPointOnSurface3D)ints.pointOnGeometry2();
	}
	return this.containsBasisWithWrapping(pointOnSurface.uParameter(),
					      pointOnSurface.vParameter());
    }

    /**
     * ^ꂽuȖʂɑ΂v_A̋Ȗʂɑ΂_ɕϊB
     * <p>
     * ̃\bhԂ_́ȂΏۂłȂ
     * p[^l̋Ȗʂɑ΂̂ɕϊĂB
     * </p>
     *
     * @param ints	Ȗʂɑ΂_
     * @param doExchange	_ pointOnGeometry1/2 邩
     * @return	Ώۂ̋ȖʂɕύX_
     * @see	#intersectionIsInternal(JgclIntersectionPoint3D, boolean)
     * @see	#changeTargetOfIntersection(JgclIntersectionCurve3D, boolean)
     * @see	#selectInternalIntersections(JgclIntersectionPoint3D[], boolean)
     */
    private JgclIntersectionPoint3D
    changeTargetOfIntersection(JgclIntersectionPoint3D ints,
			       boolean doExchange)
    {
	JgclPointOnGeometry3D pog1 = ints.pointOnGeometry1();
	JgclPointOnGeometry3D pog2 = ints.pointOnGeometry2();
	JgclPointOnSurface3D pos;
	double uParam;
	double vParam;
	if (doExchange == false) {
	    pos = (JgclPointOnSurface3D)pog1;
	    uParam = basisSurface.uParameterDomain().wrap(pos.uParameter());
	    vParam = basisSurface.vParameterDomain().wrap(pos.vParameter());
	    pog1 = new JgclPointOnSurface3D(this,
					    toOwnUParameter(uParam),
					    toOwnVParameter(vParam),
					    doCheckDebug);
	} else {
	    pos = (JgclPointOnSurface3D)pog2;
	    uParam = basisSurface.uParameterDomain().wrap(pos.uParameter());
	    vParam = basisSurface.vParameterDomain().wrap(pos.vParameter());
	    pog2 = new JgclPointOnSurface3D(this,
					    toOwnUParameter(uParam),
					    toOwnVParameter(vParam),
					    doCheckDebug);
	}
	return new JgclIntersectionPoint3D(ints.coordinates(),
					   pog1, pog2, doCheckDebug);
    }

    /**
     * ^ꂽuȖʂɑ΂vA̋Ȗʂɑ΂ɕϊB
     * <p>
     * ̃\bhԂ́ȂΏۂύXꂽŁA
     * p[^l͕Ȗʂɑ΂̂̂܂܂ł邱ƂɒӁB
     * </p>
     *
     * @param ints	Ȗʂɑ΂
     * @param doExchange	 basisSurface1/2 邩
     * @return	Ώۂ̋ȖʂɕύX
     * @see	#changeTargetOfIntersection(JgclIntersectionPoint3D, boolean)
     */
    private JgclIntersectionCurve3D
    changeTargetOfIntersection(JgclIntersectionCurve3D ints,
			       boolean doExchange)
    {
	JgclParametricSurface3D basisSurface1;
	JgclParametricSurface3D basisSurface2;
	if (doExchange == false) {
	    basisSurface1 = this;
	    basisSurface2 = ints.basisSurface2();
	} else {
	    basisSurface1 = ints.basisSurface1();
	    basisSurface2 = this;
	}
	return new JgclIntersectionCurve3D(ints.curve3d(),
					   basisSurface1, ints.curve2d1(),
					   basisSurface2, ints.curve2d2(),
					   ints.masterRepresentation());
    }

    /**
     * ^ꂽuȖʂɑ΂v_̓ŁA̋Ȗʂ̋E̓ɂ_ԂB
     * <p>
     * ʂƂē_́A
     * ̑Ώۂƃp[^l̋Ȗʂɑ΂̂ɕϊĂB
     * </p>
     *
     * @param intersections	ȖʂƂ̌_Zœꂽ_̔z
     * @param doExchange	_ pointOnGeometry1/2 邩
     * @return	̋Ȗʂ̋E̓ɂ_̔z
     * @see	#intersectionIsInternal(JgclIntersectionPoint3D, boolean)
     * @see	#changeTargetOfIntersection(JgclIntersectionPoint3D, boolean)
     */
    JgclIntersectionPoint3D[]
    selectInternalIntersections(JgclIntersectionPoint3D[] intersections,
				boolean doExchange)
    {
	Vector innerPoints = new Vector();
	JgclIntersectionPoint3D ints;

	for (int i = 0; i < intersections.length; i++) {
	    if (this.intersectionIsInternal(intersections[i], doExchange) == true) {
		ints = this.changeTargetOfIntersection(intersections[i], doExchange);
		innerPoints.addElement(ints);
	    }
	}

	JgclIntersectionPoint3D[] results =
	    new JgclIntersectionPoint3D[innerPoints.size()];
	innerPoints.copyInto(results);
	return results;
    }

    /**
     * Ȗʏ̋ȐƂ̋Ȗʂ̋EƂ̌_\NXB
     */
    private class IntersectionWithBoundaryInfo {
	/**
	 * EォۂB
	 */
	boolean onBoundary;

	/**
	 * Ȗʏ̋Ȑ̃p[^lB
	 */
	double curveParameter;

	/**
	 * ^ɃIuWFNg\zB
	 */
	IntersectionWithBoundaryInfo() {
	}

	/**
	 * etB[hɐݒ肷l^ăIuWFNg\zB
	 *
	 * @param onBoundary	Eォۂ
	 * @param curveParameter	Ȗʏ̋Ȑ̃p[^l
	 */
	IntersectionWithBoundaryInfo(boolean onBoundary,
				     double curveParameter) {
	    this.onBoundary = onBoundary;
	    this.curveParameter = curveParameter;
	}
    }

    /**
     * ^ꂽ􉽓IɕĂ΁AʑIɂ`ɂB
     *
     * @param theIntersection 
     * @return	ʑIȊJԂ􉽓IȊJԂɍ킹
     */
    private JgclIntersectionCurve3D
    makeIntersectionClose(JgclIntersectionCurve3D theIntersection) {
	boolean changed = false;

	/*
	 * curve3d
	 */
	JgclParametricCurve3D curve3d = theIntersection.curve3d();
	if ((curve3d.isClosed() == true) &&
	    (curve3d.isPeriodic() != true) &&
	    (curve3d.type() == JgclParametricCurve3D.POLYLINE_3D)) {
	    JgclPolyline3D polyline3d = (JgclPolyline3D)curve3d;
	    int nPoints = polyline3d.nPoints() - 1;
	    JgclPoint3D[] points = new JgclPoint3D[nPoints];
	    for (int i = 0; i < nPoints; i++)
		points[i] = polyline3d.pointAt(i);
	    curve3d = new JgclPolyline3D(points, true);
	    changed = true;
	}

	/*
	 * curve2d1
	 */
	JgclParametricCurve2D curve2d1 = theIntersection.curve2d1();
	if ((curve2d1.isClosed() == true) &&
	    (curve2d1.isPeriodic() != true) &&
	    ((curve2d1 instanceof JgclPolyline2D) == true)) {
	    JgclPolyline2D polyline2d = (JgclPolyline2D)curve2d1;
	    int nPoints = polyline2d.nPoints() - 1;
	    JgclPoint2D[] points = new JgclPoint2D[nPoints];
	    for (int i = 0; i < nPoints; i++)
		points[i] = polyline2d.pointAt(i);
	    curve2d1 = new JgclPolyline2D(points, true);
	    changed = true;
	}

	/*
	 * curve2d2
	 */
	JgclParametricCurve2D curve2d2 = theIntersection.curve2d2();
	if ((curve2d2.isClosed() == true) &&
	    (curve2d2.isPeriodic() != true) &&
	    ((curve2d2 instanceof JgclPolyline2D) == true)) {
	    JgclPolyline2D polyline2d = (JgclPolyline2D)curve2d2;
	    int nPoints = polyline2d.nPoints() - 1;
	    JgclPoint2D[] points = new JgclPoint2D[nPoints];
	    for (int i = 0; i < nPoints; i++)
		points[i] = polyline2d.pointAt(i);
	    curve2d2 = new JgclPolyline2D(points, true);
	    changed = true;
	}

	if (changed != true)
	    return theIntersection;

	return new JgclIntersectionCurve3D(curve3d,
					   theIntersection.basisSurface1(), curve2d1,
					   theIntersection.basisSurface2(), curve2d2,
					   theIntersection.masterRepresentation());
    }

    /**
     * Ȗʏ̋ȐEƂ̌_Ńg~OԂ\NXB
     */
    private class TrimmingInterval {
	/**
	 * Jn_̃Xgł̈ʒuB
	 */
	int sIdx;

	/**
	 * I_̃Xgł̈ʒuB
	 */
	int eIdx;

	/**
	 * Jn_^I_̃Xgł̈ʒu^ăIuWFNg\zB
	 *
	 * @param sIdx	Jn_̃Xgł̈ʒu
	 * @param eIdx	I_̃Xgł̈ʒu
	 */
	TrimmingInterval(int sIdx,
			 int eIdx) {
	    this.sIdx = sIdx;
	    this.eIdx = eIdx;
	}
    }

    /**
     * _̂Ȑł̃p[^l߂B
     * <p>
     * point3d  curve3d ɏĂ̂ƂāA
     * point3d  curve3d ł̃p[^lԂB
     * </p>
     * <p>
     * p[^l܂߂Ȃꍇɂ
     * JgclFatal ̗O𔭐B
     * </p>
     *
     * @param curve3d	Ȑ
     * @param point3d	_
     * @return	p[^l
     * @see	JgclFatal
     * @see	JgclParametricCurve3D#hasPolyline()
     * @see	JgclBoundedCurve3D#toPolyline(JgclToleranceForDistance)
     * @see	JgclParametricCurve3D#nearestProjectFrom(JgclPoint3D)
     */
    private double getParameterWithCurve3D(JgclParametricCurve3D curve3d,
					   JgclPoint3D point3d)
    {
	JgclPointOnCurve3D nearProj3d;
	double nearDist;
	JgclPointOnCurve3D nearestProj3d = null;
	double nearestDist = Double.NaN;

	JgclPointOnCurve3D lowerPoint = null;
	JgclPointOnCurve3D upperPoint = null;
	if (curve3d.isFinite() && curve3d.isOpen()) {
	    lowerPoint = new JgclPointOnCurve3D(curve3d, curve3d.parameterDomain().section().lower());
	    upperPoint = new JgclPointOnCurve3D(curve3d, curve3d.parameterDomain().section().upper());
	}

	JgclPolyline3D polyline3d = null;
	if (curve3d.hasPolyline() == true) {
	    // curve3d ͗LłɌ܂Ă
	    JgclBoundedCurve3D bounded3d = (JgclBoundedCurve3D)curve3d;
	    polyline3d = bounded3d.toPolyline(getToleranceForDistanceAsObject());
	}

	nearProj3d = curve3d.nearestProjectFrom(point3d);
	if (nearProj3d != null) {
	    nearDist = nearProj3d.distance(point3d);
	    if ((nearestProj3d == null) || (nearDist < nearestDist)) {
		nearestProj3d = nearProj3d;
		nearestDist = nearDist;
	    }
	}

	if (lowerPoint != null) {
	    nearDist = lowerPoint.distance(point3d);
	    if ((nearestProj3d == null) || (nearDist < nearestDist)) {
		nearestProj3d = lowerPoint;
		nearestDist = nearDist;
	    }
	}
	if (upperPoint != null) {
	    nearDist = upperPoint.distance(point3d);
	    if ((nearestProj3d == null) || (nearDist < nearestDist)) {
		nearestProj3d = upperPoint;
		nearestDist = nearDist;
	    }
	}
	if (polyline3d != null) {
	    for (int i = 0; i < polyline3d.nPoints(); i++) {
		nearDist = polyline3d.pointAt(i).distance(point3d);
		if ((nearestProj3d == null) || (nearDist < nearestDist)) {
		    nearestProj3d = (JgclPointOnCurve3D)polyline3d.pointAt(i);
		    nearestDist = nearDist;
		}
	    }
	}

	if (nearestProj3d == null)	// ǂႢ̂
	    throw new JgclFatal("No projection.");

	return nearestProj3d.parameter();
    }

    /**
     * _́uȖʏ̂Ȑvł̃p[^l߂B
     * <p>
     * curve2d  surface3d ̋Ȑ C ̃p[^Ԃł̂Q\ł̂ƂB
     * </p>
     * <p>
     * point3d  C ɏĂ̂ƂāA
     * point3d  C ł̃p[^lԂB
     * </p>
     * <p>
     * p[^l܂߂Ȃꍇɂ
     * JgclFatal ̗O𔭐B
     * </p>
     *
     * @param surface3d	Ȗ
     * @param curve2d	Ȑ
     * @param point3d	_
     * @return	p[^l
     * @see	JgclFatal
     * @see	JgclParametricSurface3D#nearestProjectFrom(JgclPoint3D)
     * @see	JgclParametricCurve2D#hasPolyline()
     * @see	JgclBoundedCurve2D#toPolyline(JgclToleranceForDistance)
     * @see	JgclParametricCurve2D#nearestProjectFrom(JgclPoint2D)
     */
    private double getParameterWithCurveOnSurface3D(JgclParametricSurface3D surface3d,
						    JgclParametricCurve2D curve2d,
						    JgclPoint3D point3d)
    {
	JgclPointOnSurface3D nearestProj3d = surface3d.nearestProjectFrom(point3d);
	if (nearestProj3d == null)	// ǂႢ̂
	    throw new JgclFatal("No projection in 3d.");
	double[] param3d = nearestProj3d.parameters();

	JgclPointOnCurve2D lowerPoint = null;
	JgclPointOnCurve2D upperPoint = null;
	if (curve2d.isFinite() && curve2d.isOpen()) {
	    lowerPoint = new JgclPointOnCurve2D(curve2d, curve2d.parameterDomain().section().lower());
	    upperPoint = new JgclPointOnCurve2D(curve2d, curve2d.parameterDomain().section().upper());
	}

	JgclPolyline2D polyline2d = null;
	if (curve2d.hasPolyline() == true) {
	    // curve2d ͗LłɌ܂Ă
	    JgclBoundedCurve2D bounded2d = (JgclBoundedCurve2D)curve2d;
	    polyline2d = bounded2d.toPolyline(getToleranceForDistanceAsObject());
	}

	int nU = 1;
	double dU = Double.NaN;

	int nV = 1;
	double dV = Double.NaN;

	if (surface3d.type() != JgclParametricSurface3D.CURVE_BOUNDED_SURFACE_3D) {
	    if (surface3d.isUPeriodic() == true) {
		nU = 3;
		dU = surface3d.uParameterDomain().section().increase();
	    }

	    if (surface3d.isVPeriodic() == true) {
		nV = 3;
		dV = surface3d.vParameterDomain().section().increase();
	    }
	}

	double pU;
	double pV;
	JgclPoint2D point2d;
	JgclPointOnCurve2D nearProj2d;
	double nearDist;
	JgclPointOnCurve2D nearestProj2d = null;
	double nearestDist = Double.NaN;

	for (int iU = 0; iU < nU; iU++) {
	    switch (iU) {
	    case 1:	pU = param3d[0] - dU;	break;
	    case 2:	pU = param3d[0] + dU;	break;
	    default:	pU = param3d[0];	break;
	    }

	    for (int iV = 0; iV < nV; iV++) {
		switch (iV) {
		case 1:		pV = param3d[1] - dV;	break;
		case 2:		pV = param3d[1] + dV;	break;
		default:	pV = param3d[1];	break;
		}

		point2d = JgclPoint2D.of(pU, pV);
		nearProj2d = curve2d.nearestProjectFrom(point2d);
		if (nearProj2d != null) {
		    nearDist = nearProj2d.distance(point2d);
		    if ((nearestProj2d == null) || (nearDist < nearestDist)) {
			nearestProj2d = nearProj2d;
			nearestDist = nearDist;
		    }
		}

		if (lowerPoint != null) {
		    nearDist = lowerPoint.distance(point2d);
		    if ((nearestProj2d == null) || (nearDist < nearestDist)) {
			nearestProj2d = lowerPoint;
			nearestDist = nearDist;
		    }
		}

		if (upperPoint != null) {
		    nearDist = upperPoint.distance(point2d);
		    if ((nearestProj2d == null) || (nearDist < nearestDist)) {
			nearestProj2d = upperPoint;
			nearestDist = nearDist;
		    }
		}

		if (polyline2d != null) {
		    for (int i = 0; i < polyline2d.nPoints(); i++) {
			nearDist = polyline2d.pointAt(i).distance(point2d);
			if ((nearestProj2d == null) || (nearDist < nearestDist)) {
			    nearestProj2d = (JgclPointOnCurve2D)polyline2d.pointAt(i);
			    nearestDist = nearDist;
			}
		    }
		}
	    }
	}

	if (nearestProj2d == null)	// ǂႢ̂
	    throw new JgclFatal("No projection in 2d.");

	return nearestProj2d.parameter();
    }

    /**
     * ̋Ȗʂ̋EƁuȖʂɑ΂v̌_߂B
     *
     * @param boundaryCurve	̋Ȗʂ̋E
     * @param intsT	Ȗʂɑ΂̂Q\
     * @return	boundaryCurve  intsT ̌_̔z
     * @see	#trimIntersectionsWithBoundaries(JgclParametricSurface3D, JgclSurfaceSurfaceInterference3D[], boolean)
     */
    private JgclIntersectionPoint2D[]
    getIntersectionsWithBoundary(JgclPolyline2D boundaryCurve,
				 JgclParametricCurve2D intsT)
    {
	int nU = 1;
	double dU = Double.NaN;

	int nV = 1;
	double dV = Double.NaN;

	if (basisSurface.type() != JgclParametricSurface3D.CURVE_BOUNDED_SURFACE_3D) {
	    if (basisSurface.isUPeriodic() == true) {
		nU = 3;
		dU = basisSurface.uParameterDomain().section().increase();
	    }

	    if (basisSurface.isVPeriodic() == true) {
		nV = 3;
		dV = basisSurface.vParameterDomain().section().increase();
	    }
	}

	double pU;
	double pV;
	JgclPolyline2D tBoundaryCurve;
	JgclIntersectionPoint2D[] intsWithBoundary;
	Vector intsWithBoundaryList = new Vector();
	int nInts = 0;

	for (int iU = 0; iU < nU; iU++) {
	    switch (iU) {
	    case 1:	pU = - dU;	break;
	    case 2:	pU = dU;	break;
	    default:	pU = 0.0;	break;
	    }

	    for (int iV = 0; iV < nV; iV++) {
		switch (iV) {
		case 1:		pV = - dV;	break;
		case 2:		pV = dV;	break;
		default:	pV = 0.0;	break;
		}

		if ((iU == 0) && (iV == 0)) {
		    tBoundaryCurve = boundaryCurve;
		} else {
		    JgclCartesianTransformationOperator2D transformer =
			new JgclCartesianTransformationOperator2D(null, null,
								  JgclPoint2D.of(pU, pV),
								  1.0);
		    tBoundaryCurve = (JgclPolyline2D)boundaryCurve.transformBy(transformer, null);
		}
		intsWithBoundary = tBoundaryCurve.intersect(intsT);

		if (intsWithBoundary.length > 0) {
		    intsWithBoundaryList.addElement(intsWithBoundary);
		    nInts += intsWithBoundary.length;
		}
	    }
	}

	JgclIntersectionPoint2D[] result = new JgclIntersectionPoint2D[nInts];
	int iResult = 0;
	for (Enumeration e = intsWithBoundaryList.elements(); e.hasMoreElements();) {
	    intsWithBoundary = (JgclIntersectionPoint2D[])e.nextElement();
	    for (int i = 0; i < intsWithBoundary.length; i++)
		result[iResult++] = intsWithBoundary[i];
	}

	return result;
    }

    /**
     * ^ꂽp[^lAJ`̒ɓ悤Ɋۂ߂B
     *
     * @param param	p[^l
     * @param section	(J`) p[^
     */
    private double wrapParameterIntoOpenSection(double param,
						JgclParameterSection section) {
	while (param < section.lower())
	    param += section.absIncrease();
	while (param > section.upper())
	    param -= section.absIncrease();

	return param;
    }

    /**
     * ^ꂽȐg~ÔɁAKɓq悤ɂăg~OB
     * <p>
     * curve ͊JȐŁA(sp &gt; ep) ł邱Ƃz肵ĂB
     * </p>
     *
     * @param curve	(J) Ȑ
     * @param sp	g~OĎcԂ̊Jnp[^l
     * @param ep	g~OĎcԂ̏Ip[^l
     * @see	#wrapParameterIntoOpenSection(double, JgclParameterSection)
     */
    private JgclParametricCurve2D connectHeadToTail(JgclParametricCurve2D curve,
						    double sp,
						    double ep) {
	JgclParameterSection section = curve.parameterDomain().section();

	double sp1 = wrapParameterIntoOpenSection(sp, section);
	double ep1 = section.upper();
	double sp2 = section.lower();
	double ep2 = wrapParameterIntoOpenSection(ep, section);

	JgclPoint2D lowerCoord = curve.coordinates(section.lower());
	JgclPoint2D upperCoord = curve.coordinates(section.upper());
	JgclVector2D period = upperCoord.subtract(lowerCoord);
	JgclCartesianTransformationOperator2D transformer =
	    new JgclCartesianTransformationOperator2D(null, null,
						      period.toPoint2D(),
						      1.0);

	JgclParametricCurve2D curve1 = curve;
	JgclParametricCurve2D curve2 = curve.transformBy(transformer, null);

	JgclTrimmedCurve2D tCurve1 = new JgclTrimmedCurve2D(curve1, sp1, ep1, true);
	JgclTrimmedCurve2D tCurve2 = new JgclTrimmedCurve2D(curve2, sp2, ep2, true);
	JgclCompositeCurveSegment2D[] segments =
	    new JgclCompositeCurveSegment2D[2];
	segments[0] = new JgclCompositeCurveSegment2D(JgclTransitionCode.CONTINUOUS,
						      true, tCurve1);
	segments[1] = new JgclCompositeCurveSegment2D(JgclTransitionCode.DISCONTINUOUS,
						      true, tCurve2);
	return new JgclCompositeCurve2D(segments, false);
    }

    /**
     * |Cō\ꂽw̃p[^ԂŃg~OB
     *
     * @param doExchange  basisSurface1/2 邩ǂ
     * @param theIntersection	g~O
     * @param isOpenT	g~O this ̕\JĂ邩ۂ
     * @param isOpenM	g~O mate ̕\JĂ邩ۂ
     * @param crossBoundary	g~OԂ (RIɕ) ׂ̎ۂ
     * @param spT	g~O̊Jnp[^l (this ̕\̃p[^l)
     * @param ipT	g~Ȏp[^l (this ̕\̃p[^l)
     * @return	g~Ǒ
     * @see	#trimIntersection(boolean, JgclIntersectionCurve3D, JgclParametricCurve2D, JgclParameterSection, boolean, boolean, boolean, double, double)
     * @see	#wrapParameterIntoOpenSection(double, JgclParameterSection)
     * @see	#connectHeadToTail(JgclParametricCurve2D, double, double)
     */
    private JgclIntersectionCurve3D
    trimIntersection2(boolean doExchange,
		      JgclIntersectionCurve3D theIntersection,
		      boolean isOpenT,
		      boolean isOpenM,
		      boolean crossBoundary,
		      double spT,
		      double ipT) {
	double epT = spT + ipT;

	JgclParameterSection section;
	double sp;
	double ep;
	boolean isOpen;

	/*
	 * curve3d
	 */
	JgclParametricCurve3D curve3d = theIntersection.curve3d();
	sp = spT;
	ep = epT;
	curve3d = new JgclTrimmedCurve3D(curve3d, sp, ep, true);

	/*
	 * curve2d1
	 */
	JgclParametricCurve2D curve2d1 = theIntersection.curve2d1();
	sp = spT;
	ep = epT;
	isOpen = (doExchange == false) ? isOpenT : isOpenM;
	if ((crossBoundary == true) && (isOpen == true)) {
	    section = curve2d1.parameterDomain().section();
	    sp = wrapParameterIntoOpenSection(sp, section);
	    ep = wrapParameterIntoOpenSection(ep, section);
	}
	if ((sp < ep) || (isOpen == false)) {
	    curve2d1 = new JgclTrimmedCurve2D(curve2d1, sp, ep, true);
	} else {
	    curve2d1 = connectHeadToTail(curve2d1, sp, ep);
	}

	/*
	 * curve2d2
	 */
	JgclParametricCurve2D curve2d2 = theIntersection.curve2d2();
	sp = spT;
	ep = epT;
	isOpen = (doExchange == false) ? isOpenM : isOpenT;
	if ((crossBoundary == true) && (isOpen == true)) {
	    section = curve2d2.parameterDomain().section();
	    sp = wrapParameterIntoOpenSection(sp, section);
	    ep = wrapParameterIntoOpenSection(ep, section);
	}
	if ((sp < ep) || (isOpen == false)) {
	    curve2d2 = new JgclTrimmedCurve2D(curve2d2, sp, ep, true);
	} else {
	    curve2d2 = connectHeadToTail(curve2d2, sp, ep);
	}

	return new JgclIntersectionCurve3D(curve3d,
					   theIntersection.basisSurface1(), curve2d1,
					   theIntersection.basisSurface2(), curve2d2,
					   theIntersection.masterRepresentation());
    }

    /**
     * w̃p[^ԂŃg~OB
     *
     * @param doExchange basisSurface1,2邩ǂ
     * @param theIntersection	g~O
     * @param intsT	g~O this ̕\
     * @param sectionOfIntsT	intsT ̃p[^`̋
     * @param isOpenT	g~O this ̕\JĂ邩ۂ
     * @param isOpenM	g~O mate ̕\JĂ邩ۂ
     * @param crossBoundary	g~OԂ (RIɕ) ׂ̎ۂ
     * @param spT	g~O̊Jnp[^l (this ̕\̃p[^l)
     * @param ipT	g~Ȏp[^l (this ̕\̃p[^l)
     * @return	g~Ǒ
     * @see	JgclParametricCurve3D#isComposedOfOnlyPolylines()
     * @see	JgclParametricCurve2D#isComposedOfOnlyPolylines()
     * @see	#trimIntersection2(boolean, JgclIntersectionCurve3D, boolean, boolean, boolean, double, double)
     * @see	#wrapParameterIntoOpenSection(double, JgclParameterSection)
     * @see	#getParameterWithCurve3D(JgclParametricCurve3D, JgclPoint3D)
     * @see	#getParameterWithCurveOnSurface3D(JgclParametricSurface3D, JgclParametricCurve2D, JgclPoint3D)
     * @see	#connectHeadToTail(JgclParametricCurve2D, double, double)
     */
    private JgclIntersectionCurve3D
    trimIntersection(boolean doExchange,
		     JgclIntersectionCurve3D theIntersection,
		     JgclParametricCurve2D intsT,
		     JgclParameterSection sectionOfIntsT,
		     boolean isOpenT,
		     boolean isOpenM,
		     boolean crossBoundary,
		     double spT,
		     double ipT) {
	if ((theIntersection.curve3d().isComposedOfOnlyPolylines() == true) &&
	    (theIntersection.curve2d1().isComposedOfOnlyPolylines() == true) &&
	    (theIntersection.curve2d2().isComposedOfOnlyPolylines() == true)) {
	    JgclParameterSection section3d =
		theIntersection.curve3d().parameterDomain().section();
	    JgclParameterSection section2d1 =
		theIntersection.curve2d1().parameterDomain().section();
	    JgclParameterSection section2d2 =
		theIntersection.curve2d2().parameterDomain().section();

	    if ((section3d.identical(section2d1) == true) &&
		(section3d.identical(section2d2) == true))
		return trimIntersection2(doExchange,
					 theIntersection,
					 isOpenT, isOpenM,
					 crossBoundary, spT, ipT);
	}

	double epT = spT + ipT;

	if ((crossBoundary == true) && (isOpenT == true)) {
	    spT = wrapParameterIntoOpenSection(spT, sectionOfIntsT);
	    epT = wrapParameterIntoOpenSection(epT, sectionOfIntsT);
	}

	JgclPoint2D spnt2d = intsT.coordinates(spT);
	JgclPoint2D epnt2d = intsT.coordinates(epT);
	JgclPoint3D spnt3d = this.basisSurface.coordinates(spnt2d.x(), spnt2d.y());
	JgclPoint3D epnt3d = this.basisSurface.coordinates(epnt2d.x(), epnt2d.y());

	double sp;
	double ep;
	boolean isOpen;

	/*
	 * curve3d
	 */
	JgclParametricCurve3D curve3d = theIntersection.curve3d();
	sp = getParameterWithCurve3D(curve3d, spnt3d);
	ep = getParameterWithCurve3D(curve3d, epnt3d);
	curve3d = new JgclTrimmedCurve3D(curve3d, sp, ep, true);

	/*
	 * curve2d1
	 */
	JgclParametricCurve2D curve2d1 = theIntersection.curve2d1();
	if (doExchange == false) {
	    sp = spT;
	    ep = epT;
	    isOpen = isOpenT;
	} else {
	    sp = getParameterWithCurveOnSurface3D(theIntersection.basisSurface1(),
						  curve2d1, spnt3d);
	    ep = getParameterWithCurveOnSurface3D(theIntersection.basisSurface1(),
						  curve2d1, epnt3d);
	    isOpen = isOpenM;
	}
	if ((sp < ep) || (isOpen == false)) {
	    curve2d1 = new JgclTrimmedCurve2D(curve2d1, sp, ep, true);
	} else {
	    curve2d1 = connectHeadToTail(curve2d1, sp, ep);
	}

	/*
	 * curve2d2
	 */
	JgclParametricCurve2D curve2d2 = theIntersection.curve2d2();
	if (doExchange == false) {
	    sp = getParameterWithCurveOnSurface3D(theIntersection.basisSurface2(),
						  curve2d2, spnt3d);
	    ep = getParameterWithCurveOnSurface3D(theIntersection.basisSurface2(),
						  curve2d2, epnt3d);
	    isOpen = isOpenM;
	} else {
	    sp = spT;
	    ep = epT;
	    isOpen = isOpenT;
	}
	if ((sp < ep) || (isOpen == false)) {
	    curve2d2 = new JgclTrimmedCurve2D(curve2d2, sp, ep, true);
	} else {
	    curve2d2 = connectHeadToTail(curve2d2, sp, ep);
	}

	return new JgclIntersectionCurve3D(curve3d,
					   theIntersection.basisSurface1(), curve2d1,
					   theIntersection.basisSurface2(), curve2d2,
					   theIntersection.masterRepresentation());
    }

    /**
     * ̋Ȗʂ̕Ȗʂ̃p[^ԏ̋Ȑ
     * Ȗʂ̃vC}ȗLԓɈړB
     *
     * @param curve	Ȗʂ̃p[^ԏ̋Ȑ
     * @return	Ȗʂ̃vC}ȗLԓɂȐ
     */
    private JgclParametricCurve2D
    moveIntoPrimarySections(JgclParametricCurve2D curve)
    {
	double lower = curve.parameterDomain().section().lower();
	double upper = curve.parameterDomain().section().upper();
	double middle = (lower + upper) / 2.0;
	JgclPoint2D lowerPoint = curve.coordinates(lower);
	JgclPoint2D upperPoint = curve.coordinates(upper);
	JgclPoint2D middlePoint = curve.coordinates(middle);

	int nU = 1;
	double dU = Double.NaN;

	int nV = 1;
	double dV = Double.NaN;

	if (basisSurface.type() != JgclParametricSurface3D.CURVE_BOUNDED_SURFACE_3D) {
	    if (basisSurface.isUPeriodic() == true) {
		nU = 3;
		dU = basisSurface.uParameterDomain().section().increase();
	    }

	    if (basisSurface.isVPeriodic() == true) {
		nV = 3;
		dV = basisSurface.vParameterDomain().section().increase();
	    }
	}

	double pU;
	double pV;
	JgclCartesianTransformationOperator2D transformer;
	JgclPoint2D tLowerPoint;
	JgclPoint2D tUpperPoint;
	JgclPoint2D tMiddlePoint;

	for (int iU = 0; iU < nU; iU++) {
	    switch (iU) {
	    case 1:	pU = - dU;	break;
	    case 2:	pU = dU;	break;
	    default:	pU = 0.0;	break;
	    }

	    for (int iV = 0; iV < nV; iV++) {
		switch (iV) {
		case 1:		pV = - dV;	break;
		case 2:		pV = dV;	break;
		default:	pV = 0.0;	break;
		}

		if ((iU == 0) && (iV == 0)) {
		    transformer = null;
		    tLowerPoint = lowerPoint;
		    tUpperPoint = upperPoint;
		    tMiddlePoint = middlePoint;
		} else {
		    transformer =
			new JgclCartesianTransformationOperator2D(null, null,
								  JgclPoint2D.of(pU, pV),
								  1.0);
		    tLowerPoint = lowerPoint.transformBy(transformer, null);
		    tUpperPoint = upperPoint.transformBy(transformer, null);
		    tMiddlePoint = middlePoint.transformBy(transformer, null);
		}

		if ((containsBasis(tLowerPoint) == true) &&
		    (containsBasis(tUpperPoint) == true) &&
		    (containsBasis(tMiddlePoint) == true)) {
		    if (transformer == null)
			return curve;
		    else
			return curve.transformBy(transformer, null);
		}
	    }
	}

	return null;
    }

    /**
     * ̋Ȗʂ̕Ȗʂɑ΂p[^l
     * ̋Ȗʂɑ΂p[^lɕϊB
     * <p>
     * ł͕ϊ~[O܂ޏꍇɖ肪N蓾B
     * </p>
     *
     * @param ints	̋Ȗʂ̕Ȗʂɑ΂p[^l
     * @param doExchange	 pointOnSurface1/2 邩
     * @return	̋Ȗʂɑ΂p[^l
     * @see	#moveIntoPrimarySections(JgclParametricCurve2D)
     */
    private JgclIntersectionCurve3D
    changeParameterSpaceOfIntersection(JgclIntersectionCurve3D ints,
				       boolean doExchange)
    {
	JgclParametricCurve2D curve2d1 = ints.curve2d1();
	JgclParametricCurve2D curve2d2 = ints.curve2d2();
	if (doExchange == false) {
	    curve2d1 = moveIntoPrimarySections(curve2d1).transformBy(paramTransformer, null);
	} else {
	    curve2d2 = moveIntoPrimarySections(curve2d2).transformBy(paramTransformer, null);
	}
	return new JgclIntersectionCurve3D(ints.curve3d(),
					   ints.basisSurface1(), curve2d1,
					   ints.basisSurface2(), curve2d2,
					   ints.masterRepresentation());
    }

    /**
     * ̋Ȗʂ̕ȖʂƑ̋Ȗʂ̌A
     * ̋Ȗʂ̋EŃg~OB
     * <p>
     * ^ꂽɂāA̋Ȗʂ̋E̓ɂ镔ƂĕԂB
     * </p>
     *
     * @param mate	̋Ȗ
     * @param intersections	ȖʂƂ̌Zœꂽ̔z
     * @param doExchange	 pointOnSurface1/2 邩
     * @return	̋Ȗʂ̋EŃg~O̔z
     * @see	#changeTargetOfIntersection(JgclIntersectionPoint3D, boolean)
     * @see	#changeTargetOfIntersection(JgclIntersectionCurve3D, boolean)
     * @see	#intersectionIsInternal(JgclIntersectionPoint3D, boolean)
     * @see	#makeIntersectionClose(JgclIntersectionCurve3D)
     * @see	#getIntersectionsWithBoundary(JgclPolyline2D, JgclParametricCurve2D)
     * @see	JgclRectangularTrimmedSurface3D.IntersectionWithBoundaryInfo
     * @see	#containsBasisWithWrapping(double, double)
     * @see	#containsBasisWithWrapping(JgclPoint2D)
     * @see	#trimIntersection(boolean, JgclIntersectionCurve3D, JgclParametricCurve2D, JgclParameterSection, boolean, boolean, boolean, double, double)
     * @see	#changeParameterSpaceOfIntersection(JgclIntersectionCurve3D, boolean)
     */
    JgclSurfaceSurfaceInterference3D[]
    trimIntersectionsWithBoundaries(JgclParametricSurface3D mate,
				    JgclSurfaceSurfaceInterference3D[] intersections,
				    boolean doExchange)
    {
	// ̑ΏۂȖʂ玩gɕύX
	for (int i = 0; i < intersections.length; i++) {
	    if (intersections[i].isIntersectionPoint() == true) {
		// _
		JgclIntersectionPoint3D ints =
		    intersections[i].toIntersectionPoint();
		intersections[i] = changeTargetOfIntersection(ints, doExchange);
	    } else {
		// 
		JgclIntersectionCurve3D ints =
		    intersections[i].toIntersectionCurve();
		intersections[i] = changeTargetOfIntersection(ints, doExchange);
	    }
	}

	Vector results = new Vector();

	// final ł̂́AiwbiBothEnds  comparator QƂ邽
	final IntersectionWithBoundaryInfo[] iwbiBothEnds =
	    new IntersectionWithBoundaryInfo[2];

	// EƂ̌_́u傫ṽp[^lŔfIuWFNg
	JgclListSorter.ObjectComparator comparator =
	    new JgclListSorter.ObjectComparator() {
	    public boolean latterIsGreaterThanFormer(java.lang.Object former,
						     java.lang.Object latter) {
		IntersectionWithBoundaryInfo f = (IntersectionWithBoundaryInfo)former;
		IntersectionWithBoundaryInfo l = (IntersectionWithBoundaryInfo)latter;
		if (f == l)
		    return false;

		if ((f == iwbiBothEnds[0]) || (l == iwbiBothEnds[1]))
		    return true;

		if ((l == iwbiBothEnds[0]) || (f == iwbiBothEnds[1]))
		    return false;

		return (f.curveParameter < l.curveParameter) ? true : false;
	    }
	};

	/*
	 * ̂ꂼɂ
	 */
	for (int i = 0; i < intersections.length; i++) {
	    /*
	     * _̏ꍇAꂪE̓ɂȂ results ɉ
	     */
	    if (intersections[i].isIntersectionPoint() == true) {
		JgclIntersectionPoint3D ints =
		    intersections[i].toIntersectionPoint();
		if (this.intersectionIsInternal(ints, doExchange) == true)
		    results.addElement(ints);
		continue;
	    }

	    /*
	     * ȉȀꍇ
	     */
	    JgclIntersectionCurve3D theIntersection =
		intersections[i].toIntersectionCurve();
	    theIntersection = makeIntersectionClose(theIntersection);

	    /*
	     * Ȗʏ̃p[^Ȑ𓾂
	     */
	    JgclParametricCurve2D intsT;
	    JgclParametricCurve2D intsM;

	    if (doExchange == false) {
		intsT = theIntersection.curve2d1();
		intsM = theIntersection.curve2d2();
	    } else {
		intsT = theIntersection.curve2d2();
		intsM = theIntersection.curve2d1();
	    }

	    boolean isOpen3 = theIntersection.curve3d().isOpen();
	    boolean isOpenT = intsT.isOpen();
	    boolean isOpenM = intsM.isOpen();

	    JgclParameterDomain domainOfIntsT = intsT.parameterDomain();
	    JgclParameterSection sectionOfIntsT = domainOfIntsT.section();

	    /*
	     * EƂ̌_𓾂
	     */
	    Vector listOfIntersectionsWithBoundaries = new Vector();
	    JgclIntersectionPoint2D[] intsWithBoundary =
		getIntersectionsWithBoundary(boundaryCurve, intsT);

	    for (int k = 0; k < intsWithBoundary.length; k++) {
		IntersectionWithBoundaryInfo iwbi =
		    new IntersectionWithBoundaryInfo(true,
			     intsWithBoundary[k].pointOnCurve2().parameter());
		listOfIntersectionsWithBoundaries.addElement(iwbi);
	    }

	    /*
	     * _̐𐮂
	     */
	    iwbiBothEnds[0] = null;
	    iwbiBothEnds[1] = null;
	    boolean addEndPoints = false;

	    if (isOpen3 == true) {
		/*
		 * JĂȂ΁A̗[EƂ̌_ɉ
		 */
		if (intsT.isFinite() == true) {
		    iwbiBothEnds[0] =
			new IntersectionWithBoundaryInfo(false,
			sectionOfIntsT.start());
		    iwbiBothEnds[1] =
			new IntersectionWithBoundaryInfo(false,
			sectionOfIntsT.end());

		    listOfIntersectionsWithBoundaries.addElement(iwbiBothEnds[0]);
		    listOfIntersectionsWithBoundaries.addElement(iwbiBothEnds[1]);
		    addEndPoints = true;
		}
	    } else if (listOfIntersectionsWithBoundaries.size() == 1) {
		/*
		 * ĂāAEƂ̌_Ȃ΁A
		 * ̌_Ⴄ_Ƃĉ
		 */
		IntersectionWithBoundaryInfo iwbi =
		    (IntersectionWithBoundaryInfo)listOfIntersectionsWithBoundaries.elementAt(0);
		IntersectionWithBoundaryInfo iwbi2 =
		    new IntersectionWithBoundaryInfo(iwbi.onBoundary,
						     iwbi.curveParameter);
		listOfIntersectionsWithBoundaries.addElement(iwbi2);
	    }

	    /*
	     * EƂ̌_ȂꍇA
	     * ̂_ (Jn_) E̓ɂ΁A
	     * ̌̂܂܁uo͂̃Xgvɉ
	     */
	    if (listOfIntersectionsWithBoundaries.size() == 0) {
		double aParameter = (intsT.isFinite() == true) ?
		    sectionOfIntsT.start() : 0.0;
		if (this.containsBasisWithWrapping(intsT.coordinates(aParameter)) == true) {
		    results.addElement(changeParameterSpaceOfIntersection(theIntersection, doExchange));
		}
		continue;
	    }

	    /*
	     * ȉAEƂ̌_ꍇ
	     */

	    /*
	     * EƂ̌_̃p[^lŃ\[g
	     */
	    JgclListSorter.doSorting(listOfIntersectionsWithBoundaries, comparator);

	    int nIntervals;
	    if (isOpen3 == true) {
		nIntervals = listOfIntersectionsWithBoundaries.size() - 1;
	    } else {
		nIntervals = listOfIntersectionsWithBoundaries.size();
	    }

	    /*
	     * ׂ荇uEƂ̌_v̒_E̓ɂ΁A
	     * ̋ԂĉƂ
	     */
	    Vector listOfTrimmingIntervals = new Vector();
	    TrimmingInterval trimmingInterval = null;

	    int sIdx;
	    int eIdx;
	    IntersectionWithBoundaryInfo sIwb;
	    IntersectionWithBoundaryInfo eIwb;

	    double sp;
	    double ip;
	    double mp;

	    boolean crossBoundary;

	    sIdx = 0;
	    sIwb = (IntersectionWithBoundaryInfo)
		listOfIntersectionsWithBoundaries.elementAt(0);

	    for (int j = 1; j <= nIntervals; j++) {
		sp = sIwb.curveParameter;
		if ((isOpen3 == true) || (j < nIntervals)) {
		    eIdx = j;
		    eIwb = (IntersectionWithBoundaryInfo)
			listOfIntersectionsWithBoundaries.elementAt(j);
		    crossBoundary = false;
		    ip = eIwb.curveParameter - sIwb.curveParameter;

		    if (((sIwb == iwbiBothEnds[0]) ||
			 (eIwb == iwbiBothEnds[1])) &&
			(Math.abs(ip) < getToleranceForParameter())) {
			sIdx = eIdx;
			sIwb = eIwb;
			continue;
		    }
		} else {
		    eIdx = 0;
		    eIwb = (IntersectionWithBoundaryInfo)
			listOfIntersectionsWithBoundaries.elementAt(0);
		    crossBoundary = true;
		    ip = eIwb.curveParameter - sIwb.curveParameter +
			sectionOfIntsT.increase();

		    if (Math.abs(ip) < getToleranceForParameter()) {
			// no cross boundary
			sIdx = eIdx;
			sIwb = eIwb;
			continue;
		    }
		}

		mp = sp + (ip / 2.0);

		if (addEndPoints == true) {
		    if (j == 1) {
			mp = sp;
		    } else if (j == nIntervals) {
			mp = sp + ip;
		    }
		}

		if ((crossBoundary == true) && (isOpenT == true)) {
		    if (mp < sectionOfIntsT.lower())
			mp += sectionOfIntsT.absIncrease();
		    if (mp > sectionOfIntsT.upper())
			mp -= sectionOfIntsT.absIncrease();
		}

		if (this.containsBasisWithWrapping(intsT.coordinates(mp)) == true) {
		    if ((trimmingInterval != null) &&
			(trimmingInterval.eIdx == sIdx)) {
			trimmingInterval.eIdx = eIdx;
		    } else {
			trimmingInterval = new TrimmingInterval(sIdx, eIdx);
			listOfTrimmingIntervals.addElement(trimmingInterval);
		    }
		}

		sIdx = eIdx;
		sIwb = eIwb;
	    }

	    if ((nIntervals = listOfTrimmingIntervals.size()) > 1) {
		TrimmingInterval head =
		    (TrimmingInterval)listOfTrimmingIntervals.firstElement();
		TrimmingInterval tail =
		    (TrimmingInterval)listOfTrimmingIntervals.lastElement();
		if (head.sIdx == tail.eIdx) {
		    head.sIdx = tail.sIdx;
		    nIntervals--;
		}
	    }

	    /*
	     * ucƔfԁvŃg~O
	     */
	    for (int j = 0; j < nIntervals; j++) {
		trimmingInterval = (TrimmingInterval)listOfTrimmingIntervals.elementAt(j);
		sIwb = (IntersectionWithBoundaryInfo)
		    listOfIntersectionsWithBoundaries.elementAt(trimmingInterval.sIdx);
		eIwb = (IntersectionWithBoundaryInfo)
		    listOfIntersectionsWithBoundaries.elementAt(trimmingInterval.eIdx);

		sp = sIwb.curveParameter;
		if (trimmingInterval.sIdx < trimmingInterval.eIdx) {
		    crossBoundary = false;
		    ip = eIwb.curveParameter - sIwb.curveParameter;
		} else {
		    crossBoundary = true;
		    ip = eIwb.curveParameter - sIwb.curveParameter +
			sectionOfIntsT.increase();
		}

		if (ip < getToleranceForParameter())
		    continue;

		JgclIntersectionCurve3D theTrimmedIntersection =
		    trimIntersection(doExchange,
				     theIntersection, intsT, sectionOfIntsT,
				     isOpenT, isOpenM,
				     crossBoundary, sp, ip);

		JgclBoundedCurve3D theTrimmedIntersection3 = 
		    (JgclBoundedCurve3D)theTrimmedIntersection.curve3d();
		if (theTrimmedIntersection3.length() < getToleranceForDistance())
		    continue;

		/*
		 * g~Oʂ̒[_A̋Ȗʂ̋EɂȂ΁A
		 * ̒[_ZŃt@C
		 */
		// KOKO
		;

		/*
		 * g~OԂuo͂̃Xgvɉ
		 */
		results.addElement(changeParameterSpaceOfIntersection(theTrimmedIntersection,
								      doExchange));
	    }
	}

	/*
	 * uo͂̃XgvԂ
	 */
	intersections = new JgclSurfaceSurfaceInterference3D[results.size()];
	results.copyInto(intersections);
	return intersections;
    }

    /**
     * ̋ȖʂA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricSurface3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclParametricSurface3D tBasisSurface =
	    this.basisSurface.transformBy(reverseTransform,
					  transformationOperator,
					  transformedGeometries);
	return new  JgclRectangularTrimmedSurface3D(tBasisSurface,
						    this.uParam1, this.uParam2,
						    this.vParam1, this.vParam2,
						    this.uSense,
						    this.vSense);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     */
    protected void output(PrintWriter writer,
			  int indent)
    {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tbasisSurface");
        basisSurface.output(writer, indent + 2);
        writer.println(indent_tab + "\tuParam1\t" + uParam1);
        writer.println(indent_tab + "\tuParam2\t" + uParam2);
        writer.println(indent_tab + "\tvParam1\t" + vParam1);
        writer.println(indent_tab + "\tvParam2\t" + vParam2);
        writer.println(indent_tab + "\tuSense\t"  + uSense);
        writer.println(indent_tab + "\tvSense\t"  + vSense);
        writer.println(indent_tab + "End");
    }
}

// end of file
