/*
 * Q : Ȑ\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclPolynomialCurve2D.java,v 1.27 2000/04/26 13:21:15 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * Q : Ȑ\NXB
 * <p>
 * ̃NX̃CX^Xɂ́AQ X, Y 
 * ̑ (X, Y) ŕ\ȐƁA
 * O̑ (WX, WY, W) ŕ\LȐB
 * </p>
 * <p>
 * X, Y  WX, XY, W ̊e\͓ł̂ƂB
 * </p>
 *
 * @version $Revision: 1.27 $, $Date: 2000/04/26 13:21:15 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclPolynomialCurve2D extends JgclParametricCurve2D {
    /**
     * Ȑ X \ (L̏ꍇ WX ) B
     * @serial
     */
    private final JgclRealPolynomial polyX;

    /**
     * Ȑ Y \ (L̏ꍇ WY ) B
     * @serial
     */
    private final JgclRealPolynomial polyY;

    /**
     * Ȑ W \ (L̏ꍇ̂) B
     * @serial
     */
    private final JgclRealPolynomial polyW;

    /**
     * ꎟ֐\ȐB
     * <p>
     * ̃tB[h̓CX^X̓ł̂ݗpB
     * </p>
     * @serial
     */
    private JgclPolynomialCurve2D derivativeCurve;

    /**
     * ^ɃIuWFNg\z邱Ƃ͂łȂB
     */
    private JgclPolynomialCurve2D() {
	super();
	polyX = null;
	polyY = null;
	polyW = null;
    }

    /**
     *  (integral polynomial) ȐƂăIuWFNg\zB
     *
     * @param	xPoly	X \
     * @param	yPoly	Y \
     */
    public JgclPolynomialCurve2D(JgclRealPolynomial xPoly,
				  JgclRealPolynomial yPoly)
    {
	if ((xPoly == null) || (yPoly == null))
	    throw new JgclFatal("one of arguments is null");

	if (xPoly.degree() != yPoly.degree())
	    throw new JgclFatal("given polynomials have different degrees");

	polyX = xPoly;
	polyY = yPoly;
	polyW = null;

	derivativeCurve = null;
    }

    /**
     * L (rational polynomial) ȐƂăIuWFNg\zB
     * <p>
     * Ȑ̑ꐬɂĂ̑̒l X ł͂Ȃ WX \ƂɒӁB
     * 񐬕ɂĂ̑̒lAlɁAY ł͂Ȃ WY \B
     * </p>
     *
     * @param	wxPoly	WX \
     * @param	wyPoly	WY \
     * @param	wPoly	W  \
     */
    public JgclPolynomialCurve2D(JgclRealPolynomial wxPoly,
				  JgclRealPolynomial wyPoly,
				  JgclRealPolynomial wPoly)
    {
	if ((wxPoly == null) || (wyPoly == null) || (wPoly == null))
	    throw new JgclFatal("one of arguments is null");

	if ((wxPoly.degree() != wPoly.degree()) || 
	    (wyPoly.degree() != wPoly.degree()))
	    throw new JgclFatal("given polynomials have different degrees");

	polyX = wxPoly;
	polyY = wyPoly;
	polyW = wPoly;

	derivativeCurve = null;
    }

    /**
     * ̑Ȑ̎ԂB
     * 
     * @return	Ȑ̎
     */
    public int degree() {
	return polyX.degree();
    }

    /**
     * ̋Ȑ`ۂԂB
     *
     * @return	`Ȃ trueAłȂ false
     */
    public boolean isIntegral() {
	return (polyW == null);
    }

    /**
     * ̋ȐL`ۂԂB
     *
     * @return	L`Ȃ trueAłȂ false
     */
    public boolean isRational() {
	return (polyW != null);
    }

    /**
     * ̋Ȑ̓֐\ȐԂB
     *
     * @return	֐\Ȑ
     */
    private JgclPolynomialCurve2D derivative() {
	if (derivativeCurve == null) {
	    if (isIntegral()) {
		derivativeCurve =
		    new JgclPolynomialCurve2D(polyX.derive(), polyY.derive());
	    } else {
		derivativeCurve =
		    new JgclPolynomialCurve2D(polyX.derive(), polyY.derive(), polyW.derive());
	    }
	}

	return derivativeCurve;
    }

    /**
     * ̋Ȑ̃p[^`ԂB
     * 
     * @return	ŔIȃp[^`
     */
    JgclParameterDomain getParameterDomain() {
	return new JgclParameterDomain();
    }

    /**
     * ̋Ȑ􉽓IɕĂ邩ۂԂB
     *
     * @return	 false
     */
    boolean getClosedFlag() {
	return false;	// ???
    }

    /**
     * ̊􉽗vfR`󂩔ۂԂB
     *
     * @return	 true
     */
    public boolean isFreeform() {
	return true;
    }

    /**
     * ̋Ȑ𐮑ȐłƂāA^ꂽp[^lŕ]B
     * 
     * @param	param	p[^l
     * @return		Wl
     */
    private JgclLiteralVector2D evaluateAsIntegral(double param) {
	return new JgclLiteralVector2D(polyX.evaluate(param),
				       polyY.evaluate(param));
    }

    /**
     * ̋ȐLȐłƂāA^ꂽp[^lŕ]B
     * 
     * @param	param	p[^l
     * @return		Wl
     */
    private JgclHomogeneousVector2D evaluateAsRational(double param) {
	return new JgclHomogeneousVector2D(polyX.evaluate(param),
					   polyY.evaluate(param),
					   polyW.evaluate(param));
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̍WlԂB
     * 
     * @param	param	p[^l
     * @return		Wl
     */
    private JgclPoint2D evaluateD0(double param) {
	JgclPoint2D result;

	if (isIntegral()) {
	    JgclLiteralVector2D D0 = evaluateAsIntegral(param);
	    result = new JgclCartesianPoint2D(D0.x(), D0.y());
	} else {
	    JgclHomogeneousVector2D D0H = evaluateAsRational(param);
	    result = new JgclHomogeneousPoint2D(D0H.wx(), D0H.wy(), D0H.w());
	}

	return result;
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̈ꎟ֐ԂB
     * 
     * @param	param	p[^
     * @return		ꎟ֐
     */
    private JgclVector2D evaluateD1(double param) {
	JgclVector2D result;

	if (isIntegral()) {
	    result = derivative().evaluateAsIntegral(param);
	} else {
	    /*
	     * p(t)  = h(t)  / w(t)	: h = (wx, wy)
	     * h(t)  = w(t)  * p(t)
	     * h'(t) = w'(t) * p(t) + w(t) * p'(t)
	     * p'(t) = (h'(t) - w'(t) * p(t)) / w(t)
	     */
	    JgclHomogeneousVector2D D0H = evaluateAsRational(param);
	    JgclHomogeneousVector2D D1H = derivative().evaluateAsRational(param);

	    JgclVector2D D0 = D0H;
	    JgclVector2D D1 = new JgclHomogeneousVector2D
		((D1H.wx() - (D1H.w() * D0.x())),
		 (D1H.wy() - (D1H.w() * D0.y())),
		 D0H.w());
	    result = D1;
	}

	return result;
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̈ꎟ/񎟓֐ԂB
     * <p>
     * ʂƂēz̗vf 2 ŁA
     * ŏ̗vfɈꎟ֐A
     * Ԗڂ̗vfɓ񎟓֐
     * B
     * </p>
     * 
     * @param	param	p[^
     * @return		֐̔z
     */
    private JgclVector2D[] evaluateD1D2(double param) {
	JgclVector2D[] result = new JgclVector2D[2];

	if (isIntegral()) {
	    result[0] = derivative().evaluateAsIntegral(param);
	    result[1] = derivative().derivative().evaluateAsIntegral(param);
	} else {
	    JgclHomogeneousVector2D D0H = evaluateAsRational(param);
	    JgclHomogeneousVector2D D1H = derivative().evaluateAsRational(param);
	    JgclHomogeneousVector2D D2H = derivative().derivative().evaluateAsRational(param);

	    JgclVector2D D0 = D0H;
	    JgclVector2D D1 = new JgclHomogeneousVector2D
		((D1H.wx() - (D1H.w() * D0.x())),
		 (D1H.wy() - (D1H.w() * D0.y())),
		 D0H.w());
	    JgclVector2D D2 = new JgclHomogeneousVector2D
		((D2H.wx() - ((2.0 * D1H.w() * D1.x()) + (D2H.w() * D0.x()))),
		 (D2H.wy() - ((2.0 * D1H.w() * D1.y()) + (D2H.w() * D0.y()))),
		 D0H.w());
	    result[0] = D1;
	    result[1] = D2;
	}

	return result;
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̍WlԂB
     * 
     * @param	param	p[^l
     * @return		Wl
     */
    public JgclPoint2D coordinates(double param) {
	return evaluateD0(param);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̐ڃxNgԂB
     * 
     * @param	param	p[^l
     * @return		ڃxNg
     */
    public JgclVector2D tangentVector(double param) {
	return evaluateD1(param);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̋ȗԂB
     * 
     * @param	param	p[^l
     * @return		ȗ
     */
    public JgclCurveCurvature2D curvature(double param) {
	JgclVector2D[] D1D2 = evaluateD1D2(param);
	JgclVector2D     D1 = D1D2[0];
	JgclVector2D     D2 = D1D2[1];
	double       D1Leng = D1.length();
	double      crsProd = D1.zOfCrossProduct(D2);
	double    curvature = Math.abs(crsProd) / (D1Leng * D1Leng * D1Leng);
	JgclVector2D normal;

	if (crsProd < 0.0) {
	    normal = new JgclLiteralVector2D(D1.y(), (- D1.x()));
	} else {
	    normal = new JgclLiteralVector2D((- D1.y()), D1.x());
	}
	normal = normal.unitized();

	return new JgclCurveCurvature2D(curvature, normal);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̓֐ԂB
     *
     * @param	param	p[^l
     * @return		֐
     */
    public JgclCurveDerivative2D evaluation(double param) {
	JgclPoint2D      D0 = evaluateD0(param);
	JgclVector2D[] D1D2 = evaluateD1D2(param);
	return new JgclCurveDerivative2D(D0, D1D2[0], D1D2[1]);
    }

    /**
     * ̋Ȑ̓ٓ_ԂB
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @return		ٓ_̔z
     * @see	JgclNotSupported
     */
    public JgclPointOnCurve2D[] singular() {
	throw new JgclNotSupported();
    }

    /**
     * ̋Ȑ̕ϋȓ_ԂB
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @return		ϋȓ_̔z
     * @see	JgclNotSupported
     */
    public JgclPointOnCurve2D[] inflexion() {
	throw new JgclNotSupported();
    }

    /**
     * ^ꂽ_炱̋Ȑւ̓e_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param point	e̓_
     * @return		e_̔z
     * @see	JgclNotSupported
     */
    public JgclPointOnCurve2D[] projectFrom(JgclPoint2D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̋Ȑ̎w̋ԂA^ꂽ덷Œߎ|CԂB
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     *
     * @param section	ߎp[^
     * @param tolerance	̋e덷
     * @return		̋Ȑ̎w̋Ԃ𒼐ߎ|C
     * @see	JgclNotSupported
     */
    public JgclPolyline2D toPolyline(JgclParameterSection section,
				     JgclToleranceForDistance tolerance) {
	throw new JgclNotSupported();
    }

    /**
     * ̋Ȑ̎w̋ԂɍČL Bspline ȐԂB
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param section	L Bspline ȐōČp[^
     * @return		̋Ȑ̎w̋ԂČL Bspline Ȑ
     * @see	JgclNotSupported
     */
    public JgclBsplineCurve2D toBsplineCurve(JgclParameterSection section) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param	mate	̋Ȑ
     * @return		_̔z
     * @see	JgclNotSupported
     */
    public JgclIntersectionPoint2D[] intersect(JgclParametricCurve2D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param	mate	̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint2D[] intersect(JgclLine2D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (~) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param	mate	̋Ȑ (~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint2D[] intersect(JgclCircle2D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (ȉ~) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param	mate	̋Ȑ (ȉ~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint2D[] intersect(JgclEllipse2D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param	mate	̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint2D[] intersect(JgclParabola2D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (oȐ) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param	mate	̋Ȑ (oȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint2D[] intersect(JgclHyperbola2D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (|C) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param	mate	̋Ȑ (|C)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint2D[] intersect(JgclPolyline2D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (xWGȐ) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param	mate	̋Ȑ (xWGȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint2D[] intersect(JgclPureBezierCurve2D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (aXvCȐ) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param	mate	̋Ȑ (aXvCȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint2D[] intersect(JgclBsplineCurve2D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (gȐ) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param	mate	̋Ȑ (gȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint2D[] intersect(JgclTrimmedCurve2D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (ȐȐZOg) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param	mate	̋Ȑ (ȐȐZOg)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint2D[] intersect(JgclCompositeCurveSegment2D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (ȐȐ) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param	mate	̋Ȑ (ȐȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint2D[] intersect(JgclCompositeCurve2D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋Ȑ̎w̋ԂItZbgȐA
     * ^ꂽ덷ŋߎ Bspline Ȑ߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param pint	ItZbgp[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.LEFT/RIGHT)
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ̃ItZbgȐߎ Bspline Ȑ
     * @see	JgclWhichSide
     * @see	JgclNotSupported
     */
    public JgclBsplineCurve2D offsetByBsplineCurve(JgclParameterSection pint,
						   double magni,
                                                   int side,
                                                   JgclToleranceForDistance tol) {
	throw new JgclNotSupported();
    }

    /**
     * ̋Ȑ̎w̋ԂƁA̋Ȑ̎w̋ԂɂtBbg߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param pint1	̋Ȑ̃p[^
     * @param side1	̋Ȑ̂ǂ瑤ɃtBbg߂邩tO
     *			(JgclWhichSide.LEFTȂ΍ARIGHTȂΉEABOTHȂΗ)
     * @param mate	̋Ȑ
     * @param pint2	̋Ȑ̃p[^
     * @param side2	̋Ȑ̂ǂ瑤ɃtBbg߂邩tO
     *			(JgclWhichSide.LEFTȂ΍ARIGHTȂΉEABOTHȂΗ)
     * @param radius	tBbga
     * @return		tBbg̔z
     * @see	JgclWhichSide
     * @see	JgclNotSupported
     */
    public JgclFilletObject2D[] fillet(JgclParameterSection pint1, int side1,
				       JgclParametricCurve2D mate, JgclParameterSection pint2, int side2,
				       double radius) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋ȐƂ̋ʐڐ߂B
     * <p>
     * ʐڐ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * _ł͎ĂȂ߁A
     * JgclNotSupported	̗O𔭐B
     * </p>
     *
     * @param mate	̋Ȑ
     * @return		ʐڐ̔z
     * @exception	JgclNotSupported	܂̂ƂAȂ@\ł
     */
    public JgclCommonTangent2D[] commonTangent(JgclParametricCurve2D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋ȐƂ̋ʖ@߂B
     * <p>
     * ʖ@݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * _ł͎ĂȂ߁A
     * JgclNotSupported	̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		ʖ@̔z
     * @exception	JgclNotSupported	܂̂ƂAȂ@\ł
     */
    public JgclCommonNormal2D[]	commonNormal(JgclParametricCurve2D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ^ꂽp[^Ԃɂ邱̋Ȑ̎ԏł̒ (̂) ԂB
     * 
     * @param pint	Ȑ̒߂p[^
     * @return	w肳ꂽp[^ԂɂȐ̒
     */
    public double length(JgclParameterSection pint) {
	// p[^̃`FbNKvH
	double dTol = getToleranceForDistance() / 2.0;
	return JgclMath.getDefiniteIntegral
	    (new JgclRealFunctionWithOneVariable() {
		public double evaluate(double parameter) {
		    return tangentVector(parameter).length();
		}
	    },
		pint, dTol);
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricCurve2D#POLYNOMIAL_CURVE_2D JgclParametricCurve2D.POLYNOMIAL_CURVE_2D}
     */
    int type() {
	return POLYNOMIAL_CURVE_2D;
    }

    /**
     * ̋Ȑ\Ă鑽zɓĕԂB
     *
     * @return    ̔z
     */
    private JgclRealPolynomial[] toPolynomialArray() {
	if (isIntegral()) {
	    JgclRealPolynomial[] polyArray = {polyX, polyY};
	    return polyArray;
	}
	else {
	    JgclRealPolynomial[] polyArray = {polyX, polyY, polyW};
	    return polyArray;			
	}
    }

    /**
     * ̋Ȑ̈ꎟ֐Ɠ񎟓֐̊Oς\߂B
     *
     * @return    ꎟ֐Ɠ񎟓֐̊Oς\鑽
     */
    public JgclRealPolynomial crossProductD1D2() {
	JgclPolynomialCurve2D d1 = derivative();
	JgclPolynomialCurve2D d2 = d1.derivative();
	JgclRealPolynomial[] d1Poly;
	JgclRealPolynomial[] d2Poly;
	JgclRealPolynomial crossPoly1;
	JgclRealPolynomial crossPoly2;

	if (isIntegral()) {
	    d1Poly = d1.toPolynomialArray();
	    d2Poly = d2.toPolynomialArray();
	}
	else {
	    JgclRealPolynomial workPoly;
	    JgclRealPolynomial workPoly1;
	    JgclRealPolynomial workPoly2;
	    JgclRealPolynomial workPoly3;
	    JgclRealPolynomial workPoly4;;
	    JgclRealPolynomial[] d0WPoly = toPolynomialArray();			
	    JgclRealPolynomial[] d1WPoly = d1.toPolynomialArray();
	    JgclRealPolynomial[] d2WPoly = d2.toPolynomialArray();

	    d1Poly = new JgclRealPolynomial[2];
	    d2Poly = new JgclRealPolynomial[2];

	    for (int klm = 0; klm < 2; klm++) {
		workPoly1 = polyW.multiply(d1WPoly[klm]);
		workPoly2 = d1.polyW.multiply(d0WPoly[klm]);
		d1Poly[klm] = workPoly1.subtract(workPoly2);

		workPoly = polyW.multiply(polyW);
		workPoly1 = workPoly.multiply(d2WPoly[klm]);
		workPoly = d1.polyW.multiply(d0WPoly[klm]);
		workPoly2 = workPoly.multiply(d1WPoly[klm]);
		workPoly = d1.polyW.multiply(d1.polyW);
		workPoly3 = workPoly.multiply(d0WPoly[klm]);
		workPoly = d2.polyW.multiply(polyW);
		workPoly4 = workPoly.multiply(d0WPoly[klm]);

		workPoly = workPoly2.subtract(workPoly3).multiply(2.0);
		d2Poly[klm] = workPoly1.subtract(workPoly).subtract(workPoly4);
	    }
	}

	crossPoly1 = d1Poly[0].multiply(d2Poly[1]);
	crossPoly2 = d1Poly[1].multiply(d2Poly[0]);

	return crossPoly1.subtract(crossPoly2);
    }

    /**
     * ̋ȐA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     * @see	JgclNotSupported
     */
    protected synchronized JgclParametricCurve2D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator2D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	throw new JgclNotSupported();
    }

    /**
     * o̓Xg[Ɍ`o͂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     *
     * @param	writer	o̓Xg[
     * @param	indent	Cfg̐[
     * @see	JgclNotSupported
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);
	StringBuffer buf = new StringBuffer();

        writer.println(indent_tab + getClassName());
	if (this.polyW == null) {
	    writer.print(indent_tab + "\tpolyX");
	    writer.print(" [" + this.polyX.coefficientAt(0));
	    for (int i = 1; i <= this.polyX.degree(); i++)
		writer.print(", " + this.polyX.coefficientAt(i));
	    writer.println("]");

	    writer.print(indent_tab + "\tpolyY");
	    writer.print(" [" + this.polyY.coefficientAt(0));
	    for (int i = 1; i <= this.polyY.degree(); i++)
		writer.print(", " + this.polyY.coefficientAt(i));
	    writer.println("]");
	} else {
	    writer.print(indent_tab + "\tpolyWX");
	    writer.print(" [" + this.polyX.coefficientAt(0));
	    for (int i = 1; i <= this.polyX.degree(); i++)
		writer.print(", " + this.polyX.coefficientAt(i));
	    writer.println("]");

	    writer.print(indent_tab + "\tpolyWY");
	    writer.print(" [" + this.polyY.coefficientAt(0));
	    for (int i = 1; i <= this.polyY.degree(); i++)
		writer.print(", " + this.polyY.coefficientAt(i));
	    writer.println("]");

	    writer.print(indent_tab + "\tpolyW");
	    writer.print(" [" + this.polyW.coefficientAt(0));
	    for (int i = 1; i <= this.polyW.degree(); i++)
		writer.print(", " + this.polyW.coefficientAt(i));
	    writer.println("]");
	}
    }

    // Debug : integral
    /**
     * fobOp\bh 1
     */
    private static void test1(String argv[]) throws JgclInvalidArgumentValue {
	JgclPoint2D[] cntrlPoints = new JgclPoint2D[4];
	cntrlPoints[0] = new JgclCartesianPoint2D( 0.0,  0.0);
	cntrlPoints[1] = new JgclCartesianPoint2D(10.0, 10.0);
	cntrlPoints[2] = new JgclCartesianPoint2D(20.0, 10.0);
	cntrlPoints[3] = new JgclCartesianPoint2D(30.0,  0.0);
	JgclRealPolynomial[] polynomial =
	    (new JgclPureBezierCurve2D(cntrlPoints)).polynomial(true);
	JgclPolynomialCurve2D polynomialCurve =
	    new JgclPolynomialCurve2D(polynomial[0], polynomial[1]);

	for (int i = 0; i <= 100; i++) {
	    double param = 0.01 * i;
	    JgclPoint2D          crd = polynomialCurve.coordinates(param);
	    JgclVector2D         tng = polynomialCurve.tangentVector(param);
	    JgclCurveCurvature2D crv = polynomialCurve.curvature(param);
	    System.out.println(crd.x() + "\t" + crd.y() + "\t" +
			       tng.x() + "\t" + tng.y() + "\t" +
			       crv.curvature());
	}
    }

    // Debug : rational
    /**
     * fobOp\bh 2
     */
    private static void test2(String argv[]) throws JgclInvalidArgumentValue {
	JgclPoint2D[] cntrlPoints = new JgclPoint2D[4];
	cntrlPoints[0] = new JgclCartesianPoint2D( 0.0,  0.0);
	cntrlPoints[1] = new JgclCartesianPoint2D(10.0, 10.0);
	cntrlPoints[2] = new JgclCartesianPoint2D(20.0, 10.0);
	cntrlPoints[3] = new JgclCartesianPoint2D(30.0,  0.0);
	double[] weights = new double[4];
	weights[0] = 1.0;
	weights[1] = 1.0;
	weights[2] = 1.0;
	weights[3] = 1.0;
	JgclRealPolynomial[] polynomial =
	    (new JgclPureBezierCurve2D(cntrlPoints, weights)).polynomial(false);
	JgclPolynomialCurve2D polynomialCurve =
	    new JgclPolynomialCurve2D(polynomial[0], polynomial[1],
				      polynomial[2]);

	for (int i = 0; i <= 100; i++) {
	    double param = 0.01 * i;
	    JgclPoint2D          crd = polynomialCurve.coordinates(param);
	    JgclVector2D         tng = polynomialCurve.tangentVector(param);
	    JgclCurveCurvature2D crv = polynomialCurve.curvature(param);
	    System.out.println(crd.x() + "\t" + crd.y() + "\t" +
			       tng.x() + "\t" + tng.y() + "\t" +
			       crv.curvature());
	}
    }

    // Debug
    /**
     * fobOpCvOB
     */
    public static void main(String argv[]) {
	try {
	    // test1(argv);
	    test2(argv);
	}
	catch (JgclInvalidArgumentValue e) {
	}
    }
}

/* end of file */
