/*
 * R : |C\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclPolyline3D.java,v 1.79 2000/08/11 06:19:00 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.Vector;
import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * R : |C\NXB
 * <p>
 * |ĆAߓ_̗ points 
 * `ۂ\tO closed
 * Œ`B
 * </p>
 * <p>
 * closed ̒l true łΕ`ƂāAfalse łΊJ`ƂĈB
 * `̃|ĆA
 * ɍŏƍŌ̐ߓ_Ԑ̂ƂĈB
 * </p>
 * <p>
 * |C̃p[^`́A
 * אڂߓ_̊Ԃ̃p[^Ԃ̑傫 1 ƂāA
 * ȐSł [0, N] ƂȂB
 *  N ́A
 * |CJ`ł (ߓ_̐ - 1)A
 * `ł (ߓ_̐) ɂȂB
 * </p>
 * <p>
 * t p[^Ƃ|C P(t) ̃pgbN\́Aȉ̒ʂB
 * <pre>
 *	P(t) = (1 - (t - s)) * points[s] + (t - s) * points[s + 1]
 * </pre>
 *  s  t zȂő̐B
 * </p>
 *
 * @version $Revision: 1.79 $, $Date: 2000/08/11 06:19:00 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclPolyline3D extends JgclBoundedCurve3D {
    /**
     * ʑIɗאڂߓ_̊􉽓Iȓꐫ`FbN邩ǂtO
     * <p>
     * ܂̂Ƃ false (ꐫ`FbNȂ) ƂĂB
     * </p>
     */
    private static final boolean CHECK_SAME_POINTS = false;

    /**
     * p[^lɑΉZOgƋǏIȃp[^l\NX
     */
    private class PolyParam {
	/**
	 * ZOg̊Jn_
	 */
	JgclPoint3D sp;

	/**
	 * ZOg̏I_
	 */
	JgclPoint3D ep;

	/**
	 * ǏIȃp[^l
	 */
	double weight;

	/**
	 * (Kꂽ) Iȃp[^l
	 */
	double param;

	/**
	 * ZOg̔ԍ (0 x[X)
	 */
        int index;
    }

    /**
     * ߓ_̔zB
     * @serial
     */
    private JgclPoint3D[] points;


    /**
     * `ۂ\tOB
     * @serial
     */
    private boolean closed;

    /**
     * ̃CX^X̃tB[h̒lݒ肷B
     * <p>
     * closed  false ̏ꍇA
     * points ̗vf 2 菬
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * closed  true ̏ꍇA
     * points ̗vf 3 菬
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param points	ߓ_̔z
     * @param closed	Ă邩ۂ\tO
     * @see	JgclInvalidArgumentValue
     */
    private void setPoints(JgclPoint3D[] points, boolean closed) {
	if (!closed && points.length < 2 ||
	    closed && points.length < 3)
	    throw new JgclInvalidArgumentValue();

	this.closed = closed;
	this.points = new JgclPoint3D[points.length];

	this.points[0] = points[0];
	for (int i = 1; i < points.length; i++) {
	    if (CHECK_SAME_POINTS) {
		if (points[i].identical(points[i-1]))
		    throw new JgclInvalidArgumentValue();
	    }
	    this.points[i] = points[i];
	}
	if (CHECK_SAME_POINTS) {
	    if (closed && points[0].identical(points[points.length-1]))
		throw new JgclInvalidArgumentValue();
	}
    }

    /**
     * ߓ_ƕ`ۂ\tO^ăIuWFNg\zB
     * <p>
     * closed  false ̏ꍇA
     * points ̗vf 2 菬
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * closed  true ̏ꍇA
     * points ̗vf 3 菬
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param points	ߓ_̔z
     * @param closed	Ă邩ۂ\tO
     * @see	JgclInvalidArgumentValue
     */
    public JgclPolyline3D(JgclPoint3D[] points, boolean closed) {
	super();
	setPoints(points, closed);
    }

    /**
     * ߓ_^ĊJ`ƂăIuWFNg\zB
     * <p>
     * points ̗vf 2 菬
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param points	ߓ_̔z
     * @see	JgclInvalidArgumentValue
     */
    public JgclPolyline3D(JgclPoint3D[] points) {
	super();
	setPoints(points, false);
    }

    /**
     * ^ꂽLȐw̋e덷Œߎ̂ƂăIuWFNg\zB
     * 
     * @param curve	Ȑ
     * @param tol	̋e덷
     * @see JgclBoundedCurve3D#toPolyline(JgclToleranceForDistance)
     */
    public JgclPolyline3D(JgclBoundedCurve3D curve,
			  JgclToleranceForDistance tol) {
	super();
	JgclPolyline3D pl = curve.toPolyline(tol);
	this.points = pl.points;
	this.closed = pl.closed;
    }

    /**
     * ^ꂽȐ̎w̋Ԃw̋e덷Œߎ̂ƂăIuWFNg\zB
     * 
     * @param curve	Ȑ
     * @param pint	ߎp[^
     * @param tol	̋e덷
     * @see JgclParametricCurve3D#toPolyline(JgclParameterSection, JgclToleranceForDistance)
     */
    public JgclPolyline3D(JgclParametricCurve3D curve,
			  JgclParameterSection pint,
			  JgclToleranceForDistance tol) 
    {
	super();
	JgclPolyline3D pl = curve.toPolyline(pint, tol);
	this.points = pl.points;
	this.closed = pl.closed;
    }

    /**
     * ̃|C̐ߓ_̔zԂB
     * 
     * @return	ߓ_̔z
     */
    public JgclPoint3D[] points() {
	JgclPoint3D[] pnts = new JgclPoint3D[points.length];

	for (int i = 0; i < points.length; i++)
	    pnts[i] = points[i];
	return pnts;
    }

    /**
     * ̃|C i Ԃ߂̐ߓ_ԂB
     * <p>
     * ̃|C`ŁAi ߓ_̐ɓꍇ́A0 Ԗڂ̐ߓ_ԂB
     * </p>
     *
     * @return	i Ԃ߂̐ߓ_
     */
    public JgclPoint3D pointAt(int i) {
	if (closed() && i == nPoints())
	    return points[0];

	return points[i];
    }

    /**
     * ̃|C`ł邩ۂԂB
     * 
     * @return	`ł trueAȂ false
     */
    public boolean closed() {
	return this.closed;
    }

    /**
     * ̃|C̐ߓ_̐ԂB
     * 
     * @return	ߓ_̐
     */
    public int nPoints() {
	return points.length;
    }

    /**
     * ̃|C̃ZOg̐ԂB
     * <p>
     * ̃|C`ł΁A
     * ZOg̐͐ߓ_̐ɓB
     * J`ł (ߓ_̐ - 1) ԂB
     * </p>
     *
     * @return	ZOg̐
     */
    public int nSegments() {
	if (closed())
	    return nPoints();

	return nPoints() - 1;
    }

    /**
     * ^ꂽp[^lɑΉZOgƋǏIȃp[^l̏ԂB
     * <p>
     * param ̒l i.0 ̏ꍇɂ i Ԗڂ̃ZOg̏ԂB
     * Ai ZOg̐ɓꍇɂ (i - 1) Ԗڂ̃ZOg̏ԂB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return	param ɑΉZOgƋǏIȃp[^l̏
     * @see	JgclParametricCurve#checkValidity(double)
     * @see	JgclParameterOutOfRange
     */
    private PolyParam checkParameter(double param)
    {
	PolyParam p = new PolyParam();

	int n = closed ? points.length : points.length-1;

	if (closed) {
	    param = parameterDomain().wrap(param);
	}
	else {
	    checkValidity(param);
	}

	int idx = (int)Math.floor(param);
	if (idx < 0)
	    idx = 0;
	if (n-1 < idx)
	    idx = n-1;

	p.sp = points[idx];
	if (idx+1 == points.length)
	    p.ep = points[0];	// only closed case
	else
	    p.ep = points[idx+1];

	p.weight = param - idx;
	p.param = param;
	p.index = idx;
	return p;
    }

    /**
     * ΏۂƂȂp[^ԂɊ܂܂ZOgɔCӂ̏{߂̒ۃNXB
     */
    private abstract class LineSegmentAccumulator {

	/**
	 * ^ꂽ_ɂāA炩̏sȂۃ\bhB
	 * <p>
	 * ̃\bh
	 * {@link #accumulate(JgclParameterSection) accumulate(JgclParameterSection)}
	 * ̒ŌĂяoB
	 * </p>
	 * <p>
	 * ^ꂽ_́A
	 * ɂZOg̒[_ł킯ł͂ȂA
	 * ZOg̒ԓ_ł邩ȂB
	 * </p>
	 *
	 * @param sp	Jn_
	 * @param ep	I_
	 * @param sParam	sp ɑΉp[^l
	 * @param eParam	ep ɑΉp[^l
	 */
	abstract void doit(JgclPoint3D sp, JgclPoint3D ep,
			   double sParam, double eParam);

	/**
	 * 炩̏n߂邽߂̏sȂۃ\bhB
	 * <p>
	 * ̃\bh
	 * {@link #accumulate(JgclParameterSection) accumulate(JgclParameterSection)}
	 * ̒
	 * {@link #doit(JgclPoint3D, JgclPoint3D, double, double)
	 * doit(JgclPoint3D, JgclPoint3D, double, double)}
	 * ĂяoOɌĂяoB
	 * </p>
	 */
	abstract void allocate(int nsegs);

	/**
	 * ^ꂽp[^ԂɊ܂܂ZOg 
	 * {@link #doit(JgclPoint3D, JgclPoint3D, double, double)
	 * doit(JgclPoint3D, JgclPoint3D, double, double)}
	 * ĂяoB
	 */
	void accumulate(JgclParameterSection pint)
	{
	    PolyParam sPolyParam = checkParameter(pint.start());
	    PolyParam ePolyParam = checkParameter(pint.end());
	    JgclPoint3D sPoint;
	    JgclPoint3D ePoint;
	    JgclParameterDomain domain = parameterDomain();
	    boolean wrapAround;

	    if (domain.isPeriodic())
		wrapAround = (sPolyParam.param > ePolyParam.param);
	    else
		wrapAround = false;

	    if (wrapAround) {
		allocate(nPoints() - sPolyParam.index + ePolyParam.index);

		sPoint = coordinates(sPolyParam.param);
		ePoint = sPolyParam.ep;
		doit(sPoint, ePoint,
		     sPolyParam.param, (double)sPolyParam.index+1);
	    
		for (int seg = sPolyParam.index + 1; seg < nPoints(); seg++) {
		    int wrappedSeg1 = (seg + 1) % nPoints();
		    doit(points[seg], points[wrappedSeg1],
			 (double)seg, (double)(seg+1));
		}

		for (int seg = 0; seg < ePolyParam.index; seg++) {
		    int wrappedSeg1 = (seg + 1) % nPoints();
		    doit(points[seg], points[wrappedSeg1],
			 (double)seg, (double)(seg+1));
		}

		sPoint = ePolyParam.sp;
		ePoint = coordinates(ePolyParam.param);
		doit(sPoint, ePoint,
		     (double)ePolyParam.index, ePolyParam.param);
	    }
	    else if (sPolyParam.index == ePolyParam.index) {
		allocate(1);

		sPoint = coordinates(sPolyParam.param);
		ePoint = coordinates(ePolyParam.param);
		doit(sPoint, ePoint, sPolyParam.param, ePolyParam.param);
	    }
	    else {
		allocate(ePolyParam.index - sPolyParam.index + 1);

		sPoint = coordinates(sPolyParam.param);
		ePoint = sPolyParam.ep;
		doit(sPoint, ePoint,
		     sPolyParam.param, (double)sPolyParam.index+1);

		for (int seg = sPolyParam.index + 1;
		     seg < ePolyParam.index; seg++)
		    doit(points[seg], points[seg + 1],
			 (double)seg, (double)(seg+1));

		sPoint = ePolyParam.sp;
		ePoint = coordinates(ePolyParam.param);
		doit(sPoint, ePoint,
		     (double)ePolyParam.index, ePolyParam.param);
	    }
	}
    }

    /**
     * {@link #length(JgclParameterSection) length(JgclParameterSection)}
     * 邽߂ LineSegmentAccumulator ̎B
     */
    private class LengthAccumulator extends LineSegmentAccumulator {
	/**
	 * Ȑ̎w̋Ԃ̒B
	 */
	double leng;

	/**
	 * leng  0 ɏB
	 *
	 * @param nsegs	ΏۂƂȂZOg̐
	 */
	void allocate(int nsegs) {
	    leng = 0.0;
	}

	/**
	 * ^ꂽ_Ԃ̋ leng ɑB
	 *
	 * @param sp	Jn_
	 * @param ep	I_
	 * @param sParam	sp ɑΉp[^l
	 * @param eParam	ep ɑΉp[^l
	 */
	void doit(JgclPoint3D sp, JgclPoint3D ep,
		  double sParam, double eParam) {
	    leng += sp.distance(ep);
	}

	/**
	 * Ȑ̎w̋Ԃ̒ԂB
	 *
	 * @param leng ̒l
	 */
	double extract() {
	    return leng;
	}
    }

    /**
     * ^ꂽp[^Ԃɂ邱̋Ȑ̎ԏł̒ (̂) ԂB
     * <p>
     * pint ̑l͕ł܂ȂB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param pint	Ȑ̒߂p[^
     * @return	w肳ꂽp[^ԂɂȐ̒
     * @see	JgclParameterOutOfRange
     */
    public double length(JgclParameterSection pint)
    {
	if (pint.increase() < 0.0) {
	    return length(new JgclParameterSection(pint.end(),
						   -pint.increase())
			  );
	}

	LengthAccumulator acc = new LengthAccumulator();

	acc.accumulate(pint);
	return acc.extract();
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̍WlԂB
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		Wl
     * @see	JgclParametricCurve#checkValidity(double)
     * @see	JgclParameterOutOfRange
     */
    public JgclPoint3D coordinates(double param)
    {
	PolyParam p = checkParameter(param);
	return p.ep.linearInterpolate(p.sp, p.weight);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̐ڃxNgԂB
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		ڃxNg
     * @see	JgclParametricCurve#checkValidity(double)
     * @see	JgclParameterOutOfRange
     */
    public JgclVector3D tangentVector(double param) 
    {
	PolyParam p = checkParameter(param);
	return p.ep.subtract(p.sp);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̋ȗԂB
     * <p>
     * |C̋ȗ́A 0 łB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		ȗ
     * @see	JgclParametricCurve#checkValidity(double)
     * @see	JgclParameterOutOfRange
     */
    public JgclCurveCurvature3D curvature(double param)
    {
	checkParameter(param);

	return new JgclCurveCurvature3D(0.0, JgclVector3D.zeroVector());
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̃CԂB
     * <p>
     * |C̃ĆA 0 łB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		C
     * @see	JgclParametricCurve#checkValidity(double)
     * @see	JgclParameterOutOfRange
     */
    public double torsion(double param)
    {
	checkParameter(param);
	return 0.0;
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̓֐ԂB
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		֐
     * @see	JgclParametricCurve#checkValidity(double)
     * @see	JgclParameterOutOfRange
     */
    public JgclCurveDerivative3D evaluation(double param)
    {
	return new JgclCurveDerivative3D(coordinates(param),
					 tangentVector(param),
					 JgclVector3D.zeroVector(),
					 JgclVector3D.zeroVector());
    }

    /**
     * {@link #singular() singular()}
     * 邽߂ LineSegmentAccumulator ̎B
     */
    private class SingularAccumulator extends LineSegmentAccumulator {
        private JgclParametricCurve3D curve;
        private Vector singularVec;
        private JgclVector3D prevTangVec;

        SingularAccumulator(JgclParametricCurve3D curve) {
            this.curve = curve;
        }

        void allocate(int nsegs) {
            singularVec = new Vector();
            prevTangVec = null;
        }

        void doit(JgclPoint3D sp, JgclPoint3D ep,
                  double sParam, double eParam) {
            JgclVector3D tangVec = ep.subtract(sp);
            if (prevTangVec != null) {
                if (!tangVec.identicalDirection(prevTangVec)) {
                    JgclPointOnCurve3D candidate =
                        new JgclPointOnCurve3D(curve, sParam, doCheckDebug);
                    singularVec.addElement(candidate);
                }
            }
            prevTangVec = tangVec;
        }

        JgclPointOnCurve3D[] extract() {
            JgclPointOnCurve3D[] singular =
                new JgclPointOnCurve3D[singularVec.size()];
            singularVec.copyInto(singular);
            return singular;
        }
    }

    /**
     * ̋Ȑ̓ٓ_ԂB
     * <p>
     * ٓ_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @return		ٓ_̔z
     */
    public JgclPointOnCurve3D[] singular() {
         SingularAccumulator acc = new SingularAccumulator(this);
         acc.accumulate(parameterDomain().section());

         return acc.extract();
    }

    /**
     * ̋Ȑ̕ϋȓ_ԂB
     * <p>
     * |Cɂ͕ϋȓ_݂͑Ȃ̂ƂāA 0 ̔zԂB
     * </p>
     * 
     * @return	ϋȓ_̔z
     */
    public JgclPointOnCurve3D[] inflexion() {
         return new JgclPointOnCurve3D[0];
    }

    /**
     * {@link #projectFrom(JgclPoint3D) projectFrom(JgclPoint3D)}
     * 邽߂ LineSegmentAccumulator ̎B
     */
    private class ProjectionAccumulator extends LineSegmentAccumulator {
	JgclPointOnGeometryList projList;
	JgclPoint3D point;
	double dTol;
	JgclPolyline3D curv;

	ProjectionAccumulator(JgclPolyline3D curv, JgclPoint3D point,
			      double dTol) {
	    this.point = point;
	    this.dTol = dTol;
	    this.curv = curv;
	}

	void allocate(int nsegs) {
	    projList = new JgclPointOnGeometryList();
	}

	void doit(JgclPoint3D sp, JgclPoint3D ep,
		  double sParam, double eParam) {
	    JgclLine3D line;
	    try {
		line = new JgclLine3D(sp, ep);
	    } catch (JgclInvalidArgumentValue e) {	// segment is reduced
		return;
	    }
 	    JgclPointOnCurve3D proj = line.project1From(point);
	    double length = line.dir().length();
	    double param = proj.parameter();
	    double fromSp = param * length;

	    if (-dTol <= fromSp && fromSp <= length+dTol) {
		// parameter on Polyline
		if (param < 0.0) param = 0.0;
		else if (param > 1.0) param = 1.0;
		double p2 = sParam + (eParam - sParam) * param;
 		JgclPointOnCurve3D proj2 = new JgclPointOnCurve3D(curv, p2, doCheckDebug);
		projList.addPoint(curv, p2);
	    }
	}

	JgclPointOnCurve3D[] extract() {
	    return projList.toJgclPointOnCurve3DArray();
	}
    }

    /**
     * ^ꂽ_炱̋Ȑւ̓e_߂B
     * <p>
     * e_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param point	e̓_
     * @return	e_
     */
    public JgclPointOnCurve3D[] projectFrom(JgclPoint3D point) {
	double dTol = getToleranceForDistance();

	ProjectionAccumulator acc =
	    new ProjectionAccumulator(this, point, dTol);

	try {
	    acc.accumulate(parameterDomain().section());
	}
	catch(JgclParameterOutOfRange e) {
	    throw new JgclFatal();
	}
	return acc.extract();
    }

    /**
     * {@link #toPolyline(JgclParameterSection, JgclToleranceForDistance)
     * toPolyline(JgclParameterSection, JgclToleranceForDistance)}
     * 邽߂ LineSegmentAccumulator ̎B
     */
    private class ToPolylineAccumulator extends LineSegmentAccumulator {
	Vector pntVec;
	JgclPoint3D lastPoint;
	JgclPolyline3D curv;

	ToPolylineAccumulator(JgclPolyline3D curv) {
	    this.curv = curv;
	}

	void allocate(int nsegs) {
	    pntVec = new Vector();
	    lastPoint = null;
	}

	void doit(JgclPoint3D sp, JgclPoint3D ep,
		  double sParam, double eParam) {
	    if (lastPoint == null) {
		lastPoint = new JgclPointOnCurve3D(curv, sParam, doCheckDebug);
		pntVec.addElement(lastPoint);
	    }

	    JgclPoint3D newPoint = new JgclPointOnCurve3D(curv, eParam, doCheckDebug);
	    if (!newPoint.identical(lastPoint)) {
		pntVec.addElement(newPoint);
		lastPoint = newPoint;
	    }
	}

	JgclPolyline3D extract() {
	    int nPnts = pntVec.size();
	    if (nPnts < 2)
		throw new JgclZeroLength();

	    JgclPoint3D[] pntsArray = new JgclPoint3D[nPnts];
	    pntVec.copyInto(pntsArray);
	    return new JgclPolyline3D(pntsArray);
	}
    }

    /**
     * ̋Ȑ̎w̋ԂA^ꂽ덷Œߎ|CԂB
     * <p>
     * ʂƂĕԂ|C\_
     * ̋Ȑx[XƂ JgclPointOnCurve3D 
     * 邱Ƃ҂łB
     * </p>
     * 
     * @param pint	ߎp[^
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ𒼐ߎ|C
     */
    public JgclPolyline3D toPolyline(JgclParameterSection pint,
				     JgclToleranceForDistance tol) 
    {
	if (pint.increase() < 0.0) {
	    return toPolyline(pint.reverse(), tol).reverse();
	}

	ToPolylineAccumulator acc = new ToPolylineAccumulator(this);

	acc.accumulate(pint);
	return acc.extract();
    }

    /**
     * ̗LȐŜɍČL Bspline ȐԂB
     * 
     * @return	̋ȐŜČL Bspline Ȑ
     */
    public JgclBsplineCurve3D toBsplineCurve() {
	int degree = 1;
	boolean periodic = this.closed();
	int uicp = this.nPoints();
	int uik = (periodic == false) ? uicp : (uicp + 2);
	int[] knotMultiplicities = new int[uik];
	double[] knots = new double[uik];
	JgclPoint3D[] controlPoints = new JgclPoint3D[uicp];
	double[] weights = new double[uicp];

	int ik = (periodic == false) ? 0 : 1;
	if (periodic == false) {
	    ik = 0;
	} else {
	    ik = 1;
	    knots[0]       = (- 1.0);
	    knots[uik - 1] = uicp + 1;
	    knotMultiplicities[0]       = 1;
	    knotMultiplicities[uik - 1] = 1;
	}
	for (int i = 0; i < uicp; i++, ik++) {
	    knots[ik] = i;
	    if ((periodic == false) &&
		((i == 0) || (i == (this.nPoints() - 1))))
		knotMultiplicities[ik] = 2;
	    else
		knotMultiplicities[ik] = 1;

	    controlPoints[i] = this.pointAt(i);
	    weights[i] = 1.0;
	}

	return new JgclBsplineCurve3D(degree, periodic,
				      knotMultiplicities, knots,
				      controlPoints,
				      weights);
    }

    /**
     * ̋Ȑ̎w̋ԂɍČL Bspline ȐԂB
     * 
     * @param pint	L Bspline ȐōČp[^
     * @return		̋Ȑ̎w̋ԂČL Bspline Ȑ
     */
    public JgclBsplineCurve3D toBsplineCurve(JgclParameterSection pint) {
	JgclPolyline3D target;
	if (this.closed() == true) {
	    if (pint.absIncrease() >= this.parameterDomain().section().absIncrease()) {
		target = this;
		if (pint.increase() < 0.0)
		    target = target.reverse();
	    } else {
		target = this.toPolyline(pint, this.getToleranceForDistanceAsObject());
	    }
	} else {
	    target = this.toPolyline(pint, this.getToleranceForDistanceAsObject());
	}
	return target.toBsplineCurve();
    }

    /**
     * ̋ȐƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		_̔z
     * @exception JgclIndefiniteSolution sł
     */
    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate)
    throws JgclIndefiniteSolution {
	return mate.intersect(this, true);
    }

    /**
     * ̃|C̎w̃ZOg̒߂B
     *
     * @param nseg	ZOg̐
     * @param segIdx	߂ZOg̔ԍ (0 x[X)
     * @return	w̃ZOg̒
     */
    private double segLength(int nseg, int segIdx) {
	int head_pnt_idx;
	int tail_pnt_idx;

	if (closed()) {
	    while (segIdx < 0)
		segIdx += nseg;
	    while (segIdx > (nseg - 1))
		segIdx -= nseg;
	}

	head_pnt_idx = segIdx;

	if (closed() && (head_pnt_idx == nSegments())) {
	    tail_pnt_idx = 0;
	} else {
	    tail_pnt_idx = head_pnt_idx + 1;
	}

	return points[head_pnt_idx].distance(points[tail_pnt_idx]);
    }

    /**
     * ̋ȐƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * <ul>
     * <li>	eZOgɂāA[_ʂ钼lA̒Ƒ̋ȐƂ̌_߂B
     * <li>	̏ŋ߂_̓ŁAΉZOg̓ɂ̂u_vƂB
     * </ul>
     * </p>
     * 
     * @param mate	̋Ȑ
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    private JgclIntersectionPoint3D[] doIntersect(JgclParametricCurve3D mate, boolean doExchange) {
  	int nSeg = nSegments();
	JgclCurveCurveInterferenceList intf =
	    new JgclCurveCurveInterferenceList(this, mate);

	for (int i = 0; i < nSeg; i++) {
	    JgclLine3D realSegment;
	    JgclBoundedLine3D segment;
	    try {
		realSegment = new JgclLine3D(pointAt(i), pointAt(i+1));
		segment = new JgclBoundedLine3D(pointAt(i), pointAt(i+1));
	    } catch (JgclInvalidArgumentValue e) {	// segment is reduced
		continue;
	    }

	    JgclIntersectionPoint3D[] segIntersect;
	    try {
		segIntersect = realSegment.intersect(mate);
	    } catch (JgclIndefiniteSolution e) {
		// ZOg̒_ǉĂ
  		segIntersect = new JgclIntersectionPoint3D[1];
 		JgclPoint3D segmentMidPoint = realSegment.coordinates(0.5);
  		double paramOnMate = mate.pointToParameter(segmentMidPoint);
  		segIntersect[0] =
  		    new JgclIntersectionPoint3D(realSegment, 0.5,
  						mate, paramOnMate, doCheckDebug);
	    }
	    if ((segIntersect == null) || (segIntersect.length == 0))
		continue;

	    int segResolution = segIntersect.length;
	    for (int j = 0; j < segResolution; j++) {
		JgclPoint3D point = segIntersect[j].coordinates();
		double segParam = segIntersect[j].pointOnCurve1().parameter();
		int validity = segment.parameterValidity(segParam);

		switch (validity) {
		case JgclParameterValidity.OUTSIDE:
		    continue;
		case JgclParameterValidity.TOLERATED_LOWER_LIMIT:
		    if (segParam < 0.0) {
			if ((!closed()) && (i == 0)) {
			    segParam = 0.0;
			}
			else {
			    segParam = segLength(nSeg, i) * segParam / segLength(nSeg, (i - 1));
			}
		    }
		    break;
		case JgclParameterValidity.TOLERATED_UPPER_LIMIT:
		    if (segParam > 1.0) {
			if ((!closed()) && (i == (nSeg - 1))) {
			    segParam = 1.0;
			}
			else {
			    segParam = 1.0 + (segLength(nSeg, i) * (segParam - 1.0)) / segLength(nSeg, (i + 1));
			}
		    }
		    break;
		default: // JgclParameterValidity.PROPERLY_INSIDE
		    break;
		}
		intf.addAsIntersection(point, segParam + i,
				       segIntersect[j].pointOnCurve2().parameter());
	    }
	}
	return intf.toJgclIntersectionPoint3DArray(doExchange);
    }

    /**
     * ̃|CƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * this.{@link #doIntersect(JgclParametricCurve3D, boolean)
     * doIntersect}(mate, doExchange) ĂłB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̃|CƑ̋Ȑ (~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * this.{@link #doIntersect(JgclParametricCurve3D, boolean)
     * doIntersect}(mate, doExchange) ĂłB
     * </p>
     * 
     * @param mate	̋Ȑ (~)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclCircle3D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̃|CƑ̋Ȑ (ȉ~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * this.{@link #doIntersect(JgclParametricCurve3D, boolean)
     * doIntersect}(mate, doExchange) ĂłB
     * </p>
     * 
     * @param mate	̋Ȑ (ȉ~)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclEllipse3D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̃|CƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * this.{@link #doIntersect(JgclParametricCurve3D, boolean)
     * doIntersect}(mate, doExchange) ĂłB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclParabola3D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̃|CƑ̋Ȑ (oȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * this.{@link #doIntersect(JgclParametricCurve3D, boolean)
     * doIntersect}(mate, doExchange) ĂłB
     * </p>
     * 
     * @param mate	̋Ȑ (oȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclHyperbola3D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̃|CƑ̋Ȑ (|C) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link JgclIntsPolPol3D#intersection(JgclPolyline3D, JgclPolyline3D, boolean)
     * JgclIntsPolPol3D.intersection}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (|C)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclPolyline3D mate, boolean doExchange) {
	return JgclIntsPolPol3D.intersection(this, mate, doExchange);
    }

    /**
     * ̃|CƑ̋Ȑ (xWGȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * this.{@link #doIntersect(JgclParametricCurve3D, boolean)
     * doIntersect}(mate, doExchange) ĂłB
     * </p>
     * 
     * @param mate	̋Ȑ (xWGȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̃|CƑ̋Ȑ (aXvCȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * this.{@link #doIntersect(JgclParametricCurve3D, boolean)
     * doIntersect}(mate, doExchange) ĂłB
     * </p>
     * 
     * @param mate	̋Ȑ (aXvCȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̃|CƑ̋Ȑ (gȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * gȐ̃NX́ugȐ vs. |Cv̌_Z\bh
     * {@link JgclTrimmedCurve3D#intersect(JgclPolyline3D, boolean)
     * JgclTrimmedCurve3D.intersect(JgclPolyline3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (gȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclTrimmedCurve3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̃|CƑ̋Ȑ (ȐZOg) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȐZOg̃NX́uȐZOg vs. |Cv̌_Z\bh
     * {@link JgclCompositeCurveSegment3D#intersect(JgclPolyline3D, boolean)
     * JgclCompositeCurveSegment3D.intersect(JgclPolyline3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (ȐZOg)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclCompositeCurveSegment3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̃|CƑ̋Ȑ (Ȑ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȐNX́uȐ vs. |Cv̌_Z\bh
     * {@link JgclCompositeCurve3D#intersect(JgclPolyline3D, boolean)
     * JgclCompositeCurve3D.intersect(JgclPolyline3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (Ȑ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclCompositeCurve3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * {@link #doIntersect(JgclParametricSurface3D, boolean)
     * doIntersect(JgclParametricSurface3D, boolean)}
     * 邽߂ LineSegmentAccumulator ̎B
     */
    private class IntersectWithSurfaceAccumulator extends LineSegmentAccumulator {
	JgclPolyline3D curve;
	JgclParametricSurface3D surface;
	JgclCurveSurfaceInterferenceList intfList;

	IntersectWithSurfaceAccumulator(JgclPolyline3D curve,
					JgclParametricSurface3D surface)
	{
	    this.curve = curve;
	    this.surface = surface;
	}

	void allocate(int nsegs) {
	    intfList = new JgclCurveSurfaceInterferenceList(curve, surface);
	}

	void doit(JgclPoint3D sp, JgclPoint3D ep,
		  double sParam, double eParam) {
	    JgclLine3D line;
	    try {
		line = new JgclLine3D(sp, ep);
	    } catch (JgclInvalidArgumentValue e) {	// segment is reduced
		return;
	    }

	    // remake tolerance
  	    double dTol = getToleranceForDistance();
  	    double segtol = Math.abs(line.dir().norm());
  	    if (segtol < dTol)
  		segtol = -1.0;
  	    else
  		segtol = dTol / segtol;

	    JgclIntersectionPoint3D[] intp;
	    try {
		intp = line.intersect(surface);
	    }
	    catch (JgclIndefiniteSolution e ){
		throw new JgclFatal();
	    }

	    for (int i = 0; i < intp.length; i++) {
		double crvParam =
		    ((JgclPointOnCurve3D)intp[i].pointOnGeometry1()).parameter();
		double srfUParam =
		    ((JgclPointOnSurface3D)intp[i].pointOnGeometry2()).uParameter();
		double srfVParam =
		    ((JgclPointOnSurface3D)intp[i].pointOnGeometry2()).vParameter();

		// validation check

		// is_valid_ints method of GHL
		if ((crvParam < (0.0 - segtol)) || (crvParam > (1.0 + segtol)))
		    continue;
		if (crvParam < 0.0) crvParam = 0.0;
		if (crvParam > 1.0) crvParam = 1.0;
		crvParam += sParam;

		// GHL ł́Ais_isolate_ints method Ă΂邪A
		// JGCL ł́A add ۂɁAꐫ`FbNĂ̂ŁA
		// ͕̏KvȂƎvĂB

		// add solution to List
		intfList.addAsIntersection(intp[i].coordinates(), crvParam,
					   srfUParam, srfVParam);
	    }
	}

	JgclIntersectionPoint3D[] extract(boolean doExchange) {
	    return intfList.toJgclIntersectionPoint3DArray(doExchange);
	}
    }
	
    /**
     * ̋ȐƑ̋Ȗʂ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * <ul>
     * <li>	eZOgɂāA[_ʂ钼lA̒Ƒ̋ȖʂƂ̌_߂B
     * <li>	̏ŋ߂_̓ŁAΉZOg̓ɂ̂u_vƂB
     * </ul>
     * </p>
     * 
     * @param mate	̋Ȗ
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] doIntersect(JgclParametricSurface3D mate,
					  boolean doExchange)
    {
	IntersectWithSurfaceAccumulator acc =
	    new IntersectWithSurfaceAccumulator(this, mate);
	acc.accumulate(parameterDomain().section());
	return acc.extract(doExchange);
    }

    /**
     * ̋ȐƑ̋Ȗʂ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȗ
     * @return		_̔z
     */
    public JgclIntersectionPoint3D[] intersect(JgclParametricSurface3D mate) {
	return doIntersect(mate, false);
    }

    /**
     * ̋ȐƑ̋Ȗʂ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȗ
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclParametricSurface3D mate,
					       boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȗ (͋Ȗ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȗ (͋Ȗ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclElementarySurface3D mate,
					       boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȗ (xWGȖ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȗ (xWGȖ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclPureBezierSurface3D mate,
					       boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȗ (aXvCȖ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȗ (aXvCȖ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclBsplineSurface3D mate,
					       boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ () Ƃ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̃NX́u vs. |Cv̊Z\bh
     * {@link JgclBoundedLine3D#interfere(JgclPolyline3D, boolean)
     * JgclBoundedLine3D.interfere(JgclPolyline3D, boolean)}
     * ĂяoĂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference3D[] interfere(JgclBoundedLine3D mate,
					     boolean doExchange)
    {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (|C) Ƃ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link JgclIntsPolPol3D#interference(JgclPolyline3D, JgclPolyline3D)
     * JgclIntsPolPol3D.interference(JgclPolyline3D, JgclPolyline3D)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (|C)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference3D[] interfere(JgclPolyline3D mate,
					     boolean doExchange)
    {
	if (!doExchange) {
	    return JgclIntsPolPol3D.interference(this, mate);
	} else {
	    return JgclIntsPolPol3D.interference(mate, this);
	}
    }

    /**
     * ^ꂽ̑ΏۂƂȂȐ̃|CɕύXB
     *
     * @param sourceInterferences	̔z
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    private JgclCurveCurveInterference3D[]
    convertInterferences(JgclCurveCurveInterference3D[] sourceInterferences,
			 boolean doExchange)
    {
	Vector resultVector = new Vector();

	for (int i = 0; i < sourceInterferences.length; i++) {
	    JgclCurveCurveInterference3D intf;
	    if (!doExchange)
		intf = sourceInterferences[i].changeCurve1(this);
	    else
		intf = sourceInterferences[i].changeCurve2(this);
	    if (intf != null)
		resultVector.addElement(intf);
	}

	JgclCurveCurveInterference3D[] result =
	    new JgclCurveCurveInterference3D[resultVector.size()];
	resultVector.copyInto(result);
	return result;
    }

    /**
     * ̗LȐƑ̗LȐ (xWGȐ) Ƃ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̃|CLaXvCȐɕϊA
     * aXvCȐ̃NX́uaXvCȐ vs. xWGȐv̊Z\bh
     * {@link JgclBsplineCurve3D#interfere(JgclPureBezierCurve3D, boolean)
     * JgclBsplineCurve3D.interfere(JgclPureBezierCurve3D, boolean)}
     * ĂяoĂB
     * </p>
     * 
     * @param mate	̋Ȑ (xWGȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference3D[] interfere(JgclPureBezierCurve3D mate,
					     boolean doExchange) {
	return this.convertInterferences(this.toBsplineCurve().interfere(mate, doExchange),
					 doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (aXvCȐ) Ƃ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̃|CLaXvCȐɕϊA
     * aXvCȐ̃NX́uaXvCȐ vs. aXvCȐv̊Z\bh
     * {@link JgclBsplineCurve3D#interfere(JgclPureBezierCurve3D, boolean)
     * JgclBsplineCurve3D.interfere(JgclPureBezierCurve3D, boolean)}
     * ĂяoĂB
     * </p>
     * 
     * @param mate	̋Ȑ (aXvCȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference3D[] interfere(JgclBsplineCurve3D mate,
					     boolean doExchange) {
	return this.convertInterferences(this.toBsplineCurve().interfere(mate, doExchange),
					 doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (gȐ) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * gȐ̃NX́ugȐ vs. |Cv̊Z\bh
     * {@link JgclTrimmedCurve3D#interfere(JgclPolyline3D, boolean)
     * JgclTrimmedCurve3D.interfere(JgclPolyline3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̗LȐ (gȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference3D[] interfere(JgclTrimmedCurve3D mate,
					     boolean doExchange) {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (ȐZOg) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȐZOg̃NX́uȐZOg vs. |Cv̊Z\bh
     * {@link JgclCompositeCurveSegment3D#interfere(JgclPolyline3D, boolean)
     * JgclCompositeCurveSegment3D.interfere(JgclPolyline3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̗LȐ (ȐZOg)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference3D[] interfere(JgclCompositeCurveSegment3D mate,
					     boolean doExchange) {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (Ȑ) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * Ȑ̃NX́uȐ vs. |Cv̊Z\bh
     * {@link JgclCompositeCurve3D#interfere(JgclPolyline3D, boolean)
     * JgclCompositeCurve3D.interfere(JgclPolyline3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̗LȐ (Ȑ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference3D[] interfere(JgclCompositeCurve3D mate,
					     boolean doExchange) {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		Ȑ̊̔z
     */
    public JgclCurveCurveInterference3D[] interfere(JgclBoundedCurve3D mate) {
	return mate.interfere(this, true);
    }

    /**
     * ̃|C̎Ȍ_߂B
     * <p>
     * Ȍ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     *
     * @return	Ȍ_̔z
     */
    public JgclIntersectionPoint3D[] selfIntersect() {
	return JgclSelfIntsPol3D.intersection(this);
    }

    /**
     * ̃|C̎Ȋ߂B
     * <p>
     * Ȋ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     *
     * @return		Ȋ̔z
     */
    public JgclCurveCurveInterference3D[] selfInterfere() {
	return JgclSelfIntsPol3D.interference(this);
    }

    /**
     * ̃|C𔽓]|CԂB
     *
     * @return	]|C
     */
    JgclPolyline3D reverse() {
	int uip = nPoints();
	JgclPoint3D[] rPnts = new JgclPoint3D[uip];
	int i, j;

	if (closed) {
	    rPnts[0] = points[0];
	    i = 1;
	} else {
	    i = 0;
	}
	for (j = uip - 1; i < uip; i++, j--) {
	    rPnts[i] = points[j];
	}
	return new JgclPolyline3D(rPnts, closed);
    }

    /**
     * ̃|C̑ݔ͈͂̂ԂB
     *
     * @return	ݔ͈͂
     */
    JgclEnclosingBox3D enclosingBox() {
	double min_crd_x;
	double min_crd_y;
	double min_crd_z;
	double max_crd_x;
	double max_crd_y;
	double max_crd_z;

	max_crd_x = min_crd_x = pointAt(0).x();
	max_crd_y = min_crd_y = pointAt(0).y();
	max_crd_z = min_crd_z = pointAt(0).z();

	for (int i = 1; i < nPoints(); i++) {
	    min_crd_x = Math.min(min_crd_x, pointAt(i).x());
	    min_crd_y = Math.min(min_crd_y, pointAt(i).y());
	    min_crd_z = Math.min(min_crd_z, pointAt(i).z());
	    max_crd_x = Math.max(max_crd_x, pointAt(i).x());
	    max_crd_y = Math.max(max_crd_y, pointAt(i).y());
	    max_crd_z = Math.max(max_crd_z, pointAt(i).z());
	}
	return new JgclEnclosingBox3D(min_crd_x, min_crd_y, min_crd_z,
				      max_crd_x, max_crd_y, max_crd_z);
    }

    /**
     * ̋ȐA^ꂽxNgɏ]ĕsړȐԂB
     *
     * @param moveVec	sړ̕Ɨʂ\xNg
     * @return		sړ̋Ȑ
     */
    public JgclParametricCurve3D parallelTranslate(JgclVector3D moveVec) {
	JgclPoint3D[] pnts = new JgclPoint3D[nPoints()];
	for (int i = 0; i < nPoints(); i++)
	    pnts[i] = pointAt(i).add(moveVec);
	return new JgclPolyline3D(pnts, closed);
    }

    /**
     * ̋Ȑ̃p[^`ԂB
     * 
     * @return	p[^`
     */
    JgclParameterDomain getParameterDomain() {
	double n = closed ? points.length : points.length-1;

	try {
	    return new JgclParameterDomain(closed, 0, n);
	}
	catch (JgclInvalidArgumentValue e) {
	    // should never be occurred
	    throw new JgclFatal();
	}
    }

    /**
     * ̊􉽗vfR`󂩔ۂԂB
     *
     * @return	 true
     */
    public boolean isFreeform() {
	return true;
    }

    /**
     * ̗LȐ̊Jn_ԂB
     * <p>
     * Ȑ`̏ꍇ null ԂB
     * </p>
     *
     * @return	Jn_
     */
    public JgclPoint3D startPoint() {
	if (isPeriodic())
	    return null;

	return points[0];
    }

    /**
     * ̗LȐ̏I_ԂB
     * <p>
     * Ȑ`̏ꍇ null ԂB
     * </p>
     *
     * @return	I_
     */
    public JgclPoint3D endPoint() {
	if (isPeriodic())
	    return null;

	return points[points.length-1];
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricCurve3D#POLYLINE_3D JgclParametricCurve3D.POLYLINE_3D}
     */
    int type() {
	return POLYLINE_3D;
    }

    /**
     * {@link #toBoundedLines(JgclParameterSection)
     * toBoundedLines(JgclParameterSection)}
     * 邽߂ LineSegmentAccumulator ̎B
     */
    private class ToBoundedLinesAccumulator extends LineSegmentAccumulator {
	JgclBoundedLine3D[] boundedLines;
	int index;
	boolean rvrs;

	ToBoundedLinesAccumulator(boolean reverse) {
	    rvrs = reverse;
	}

	void allocate(int nsegs) {
	    boundedLines = new JgclBoundedLine3D[nsegs];
	    if (rvrs == false)
		index = 0;
	    else
		index = nsegs - 1;
	}

	void doit(JgclPoint3D sp, JgclPoint3D ep,
		  double sParam, double eParam) {
	    if (rvrs == false)
		boundedLines[index++] = new JgclBoundedLine3D(sp, ep, false);
	    else
		boundedLines[index--] = new JgclBoundedLine3D(ep, sp, false);
	}

	JgclBoundedLine3D[] extract() {
	    return boundedLines;
	}
    }

    /**
     * ̃|C̎w̋ԂɕϊB
     *
     * @param pint	ɕϊp[^
     * @return	w肳ꂽԂϊ
     */
    public JgclBoundedLine3D[] toBoundedLines(JgclParameterSection pint) {
	ToBoundedLinesAccumulator acc =
	    new ToBoundedLinesAccumulator(pint.increase() < 0.0);
	acc.accumulate(pint);
	return acc.extract();
    }

    /**
     * ̃|CŜɕϊB
     *
     * @return	ȐŜϊ
     */
    public JgclBoundedLine3D[] toBoundedLines() {
	return this.toBoundedLines(this.parameterDomain().section());
    }

    /**
     * ̋ȐA^ꂽǏWn Z ̎ɁA
     * ^ꂽpx]ȐԂB
     *
     * @param trns	ǏWn瓾ꂽWϊZq
     * @param rCos	cos(]px)
     * @param rSin	sin(]px)
     * @return		]̋Ȑ
     */
    JgclParametricCurve3D rotateZ(JgclCartesianTransformationOperator3D trns,
				  double rCos, double rSin) {
	int n_pnts = nPoints();
	JgclPoint3D[] pnts = new JgclPoint3D[n_pnts];

	for (int i = 0; i < n_pnts; i++)
	    pnts[i] = pointAt(i).rotateZ(trns, rCos, rSin);

	return new JgclPolyline3D(pnts, closed());
    }

    /**
     * ̋Ȑ̓_ŁA^ꂽɂȂ_ԂB
     *
     * @param line	
     * @return		^ꂽɂȂ_
     */
    JgclPoint3D getPointNotOnLine(JgclLine3D line) {
	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double dTol2 = condition.getToleranceForDistance2();

	int itry = 0, limit = nPoints();
	JgclPoint3D point;
	JgclVector3D vector;

	/*
	 * Get a point which is not on the line, then verify that
	 * the distance between a point and the line is greater
	 * than the tolerance.
	 */
	do {
	    if (itry >= limit) {
		throw new JgclFatal();	// should never be occurred
	    }
	    point = pointAt(itry);
	    vector = point.subtract(line.project1From(point));
	    itry ++;
	} while(point.isOn(line) || vector.norm() < dTol2);

	return point;
    }

    /**
     * ̋ȐA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricCurve3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclPoint3D[] tPoints =
	    JgclPoint3D.transform(this.points,
				  reverseTransform,
				  transformationOperator,
				  transformedGeometries);
	return new JgclPolyline3D(tPoints, this.closed);
    }

    /**
     * ̋Ȑ|C̕܂ނۂԂB
     *
     * @return	̋Ȑ|Cł邩A
     *		܂͎g\镔iƂă|C܂ނȂ trueA
     *		łȂ false
     */
    protected boolean hasPolyline() {
	return true;
    }

    /**
     * ̋Ȑ|C̕łłĂ邩ۂԂB
     *
     * @return	̋Ȑ|Cł邩A
     *		܂͎g\镔iƂă|C܂ނȂ trueA
     *		łȂ false
     */
    protected boolean isComposedOfOnlyPolylines() {
	return true;
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tpoints");
	for (int i = 0; i < nPoints(); i++) {
	    points[i].output(writer, indent + 2);
        }
        writer.println(indent_tab + "\tclosed\t" + closed);
        writer.println(indent_tab + "End");
    }
}
