/*
 * 1D|C\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclPolyline1D.java,v 1.8 2000/04/26 09:39:18 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.util.Vector;
import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * 1D|C\NX
 *
 * @version $Revision: 1.8 $, $Date: 2000/04/26 09:39:18 $
 * @author Information-technology Promotion Agency, Japan
 */
class JgclPolyline1D {
    private static final boolean CHECK_SAME_POINTS = false;

    // internal use
    private class PolyParam {
	JgclPoint1D sp;
	JgclPoint1D ep;
	double weight;
	double param;
        int index;
    }

    /**
     * ߓ_̔z
     *
     * @see		JgclPoint1D
     */
    private JgclPoint1D[] points;

    /**
     * `ۂ\tO
     */
    private boolean closed;

    /**
     * p[^hC
     */
    JgclParameterDomain parameterDomain;

    /**
     * p[^hC𒲂ׂ
     *
     * @return		p[^hC
     * @see		JgclParameterDomain
     */
    JgclParameterDomain getParameterDomain() {
	double n = closed ? points.length : points.length-1;

	try {
	    return new JgclParameterDomain(closed, 0, n);
	}
	catch (JgclInvalidArgumentValue e) {
	    // should never be occurred
	    throw new JgclFatal();
	}
    }

    /**
     * ߓ_̔zݒ肷
     *
     * @param points	ߓ_̔z
     * @param closed	Ă邩ۂ\tO
     * @see		JgclPoint1D
     */
    private void setPoints(JgclPoint1D[] points, boolean closed) {
	if (!closed && points.length < 2 ||
	    closed && points.length < 3)
	    throw new JgclInvalidArgumentValue();

	this.closed = closed;
	this.points = new JgclPoint1D[points.length];

	this.points[0] = points[0];
	for (int i = 1; i < points.length; i++) {
	    if (CHECK_SAME_POINTS) {
		if (points[i].identical(points[i-1]))
		    throw new JgclInvalidArgumentValue();
	    }
	    this.points[i] = points[i];
	}
	if (CHECK_SAME_POINTS) {
	    if (closed && points[0].identical(points[points.length-1]))
		throw new JgclInvalidArgumentValue();
	}
    }

    /**
     * `^Đ
     * 
     * @param points	ߓ_̔z
     * @param closed	Ă邩ۂ\tO
     * @see		JgclPoint1D
     */
    public JgclPolyline1D(JgclPoint1D[] points, boolean closed) {
	super();
	setPoints(points, closed);
    }

    /**
     * _^ĊJ|C𐶐
     * 
     * @param points	ߓ_̔z
     * @see		JgclPoint1D
     */
    public JgclPolyline1D(JgclPoint1D[] points) {
	super();
	setPoints(points, false);
    }

    /**
     * ߓ_̔zԂ
     * 
     * @return		ߓ_̔z
     */
    public JgclPoint1D[] points() {
	JgclPoint1D[] pnts = new JgclPoint1D[points.length];

	for (int i = 0; i < points.length; i++)
	    pnts[i] = points[i];
	return pnts;
    }

    /**
     * n Ԃ߂̐ߓ_Ԃ
     * `ŁAn ߓ_̐ɓꍇ́A0Ԃ߂̐ߓ_Ԃ
     * 
     * @return		n Ԃ߂̐ߓ_
     */
    public JgclPoint1D pointAt(int n) {
	if (closed() && n == nPoints())
	    return points[0];

	return points[n];
    }

    /**
     * `ۂԂ
     * 
     * @return		`ł <code>true</code> ԂA
     *			Ȃ <code>false</code> ԂB
     */
    public boolean closed() {
	return this.closed;
    }

    /**
     * ߓ_̐Ԃ
     * 
     * @return		ߓ_̐
     */
    public int nPoints() {
	return points.length;
    }

    /**
     * ZOg̐Ԃ
     *
     * @return		ZOg̐
     */
    public int nSegments() {
	if (closed())
	    return nPoints();

	return nPoints() - 1;
    }

    /**
     * p[^hC𒲂ׂ
     *
     * @return		p[^hC
     * @see		JgclParameterDomain
     */
    JgclParameterDomain parameterDomain() {
	return parameterDomain;
    }

    /**
     * p[^Lۂ𒲂ׂ
     * 
     * @param value	p[^
     * @exception JgclParameterOutOfRange	p[^Ԃ`OĂ
     */
    public void checkValidity(double value) {
	parameterDomain().checkValidity(value);
    }

    /**
     * p[^͈̔͂
     * 
     * @return		ߓ_̐
     * @exception JgclParameterOutOfRange p[^`͈̔͊Oł
     * @see		JgclParameterOutOfRange
     */
    private PolyParam checkParameter(double param)
    {
	PolyParam p = new PolyParam();

	int n = closed ? points.length : points.length-1;

	if (closed) {
	    param = parameterDomain().wrap(param);
	}
	else {
	    checkValidity(param);
	}

	int idx = (int)Math.floor(param);
	if (idx < 0)
	    idx = 0;
	if (n-1 < idx)
	    idx = n-1;

	p.sp = points[idx];
	if (idx+1 == points.length)
	    p.ep = points[0];	// only closed case
	else
	    p.ep = points[idx+1];

	p.weight = param - idx;
	p.param = param;
        p.index = idx;
	return p;
    }

    /**
     * ^ꂽp[^ł̍Wl߂
     * 
     * @param param	p[^
     * @return		Wl
     * @see		JgclPoint1D
     */
    public JgclPoint1D coordinates(double param)
    {
	PolyParam p = checkParameter(param);
	return p.ep.linearInterpolate(p.sp, p.weight);
    }
}
