/*
 * R : ʂ\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclPlane3D.java,v 1.70 2000/08/11 06:18:55 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.Vector;
import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * R : ʂ\NXB
 * <p>
 * ̃NXɓLȑ\tB[h͓ɂȂB
 * ʂ̋ǏIȌ_Ɗe̕zu (ǏWn) ́A
 * {@link JgclElementarySurface3D X[p[NX}  position ŕێB
 * </p>
 * <p>
 * ʂ̃p[^` U/V ƂɁAŔIłB
 * </p>
 * <p>
 * (u, v) p[^Ƃ镽 P(u, v) ̃pgbN\́Aȉ̒ʂB
 * <pre>
 *	P(u, v) = c + u * x + v * y
 * </pre>
 * ŁAc, x, y ͂ꂼ
 * <pre>
 *	c : position.location()
 *	x : position.x()
 *	y : position.y()
 * </pre>
 * \B
 * </p>
 *
 * @version $Revision: 1.70 $, $Date: 2000/08/11 06:18:55 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclPlane3D extends JgclElementarySurface3D {
    /**
     * ǏWnw肵ăIuWFNg\zB
     * <p>
     * position  null ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param position	Ǐ_Ɗe̕ǏWn
     * @see	JgclInvalidArgumentValue
     */
    public JgclPlane3D(JgclAxis2Placement3D position) {
	super(position);
    }

    /**
     * Ǐ_Ɩ@xNg^ăIuWFNg\zB
     * <p>
     * \z镽ʂ̋Ǐ X/Y ́̕A
     * ̃RXgN^̓Ō肷B
     * </p>
     * 
     * @param pnt	Ǐ_̍Wl
     * @param normal	@xNg
     */
    public JgclPlane3D(JgclPoint3D pnt, JgclVector3D normal)
    {
	super(new JgclAxis2Placement3D(pnt, normal,
				       normal.verticalVector().unitized()));
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̍WlԂB
     * 
     * @param uParam	U p[^l
     * @param vParam	V p[^l
     * @return		Wl
     */
    public JgclPoint3D coordinates(double uParam, double vParam) {
	JgclPoint3D center = position().location();
	JgclVector3D x = position().x();
	JgclVector3D y = position().y();

	// c + u*x + v*y
	return center.add(x.multiply(uParam)).add(y.multiply(vParam));
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̐ڃxNgԂB
     * <p>
     * ł̐ڃxNgƂ́Ap[^ U/V ̊eXɂĂ̈ꎟΓ֐łB
     * </p>
     * <p>
     * ʂƂĕԂz̗vf 2 łB
     * z̍ŏ̗vfɂ U p[^ɂĂ̐ڃxNgA
     * Ԗڂ̗vfɂ V p[^ɂĂ̐ڃxNg܂ށB
     * </p>
     *
     * @param uParam	U p[^l
     * @param vParam	V p[^l
     * @return		ڃxNg̔z
     */
    public JgclVector3D[] tangentVector(double uParam, double vParam) {
	JgclVector3D[] tangent = new JgclVector3D[2];
	tangent[0] = position().x();
	tangent[1] = position().y();
	return tangent;
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̖@xNgԂB
     * <p>
     * ̃\bhԂ@xNǵAKꂽPʃxNgłB 
     * </p>
     *
     * @param uParam	U ̃p[^l
     * @param vParam	V ̃p[^l
     * @return		Kꂽ@xNg
     */
    public JgclVector3D normalVector(double uParam, double vParam)
    {
	return position().z();
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̎ȗԂB
     * <p>
     * ̎ȗ (principalCurvature1, principalCurvature2) ̒l͂ǂ 0 łB
     * xNg1 (principalDirection1) ɂ͋Ǐ X ̒PʃxNgA
     * xNg2 (principalDirection2) ɂ͋Ǐ Y ̒PʃxNg
     * ԂB
     * </p>
     * 
     * @param uParam	U ̃p[^l
     * @param vParam	V ̃p[^l
     * @return		ȗ
     */
    public JgclSurfaceCurvature3D curvature(double uParam, double vParam) {
	return new JgclSurfaceCurvature3D(0.0, position().x(),
					  0.0, position().y());
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̕Γ֐ԂB
     * 
     * @param uParam	U ̃p[^l
     * @param vParam	V ̃p[^l
     * @return		Γ֐
     */
    public JgclSurfaceDerivative3D evaluation(double uParam, double vParam) {
	JgclPoint3D center = position().location();
	JgclVector3D x = position().x();
	JgclVector3D y = position().y();
	JgclVector3D zerov = JgclVector3D.zeroVector;
	// c + u*x + v*y
	JgclPoint3D p = center.add(x.multiply(uParam)).add(y.multiply(vParam));

	return new JgclSurfaceDerivative3D(p, x, y, zerov, zerov, zerov);
    }

    /**
     * ^ꂽ_炱̋Ȗʂւ (݂) e_߂B
     * <p>
     * []
     * <br>
     * ^ꂽ_ɂāA̕ʂ̋ǏWnɂWl߁A
     *  x, y p[^l (uParameter, vParameter)
     * Ƃʏ_ue_vƂĂB
     * </p>
     * 
     * @param point	e̓_
     * @return		e_
     * @see	#projectFrom(JgclPoint3D)
     */
    public JgclPointOnSurface3D project1From(JgclPoint3D point) 
    {
	JgclCartesianTransformationOperator3D gtrans = toGlobal();
	JgclPoint3D lpoint = gtrans.reverseTransform(point);
	JgclPointOnSurface3D foot =
	    new JgclPointOnSurface3D(this, lpoint.x(), lpoint.y(), doCheckDebug);
	return foot;
    }

    /**
     * ^ꂽ_炱̋Ȗʂւ̓e_߂B
     * <p>
     * 镽ʂւ̔Cӂ̓_̓e_͕̐K 1 ɂȂB
     * </p>
     * 
     * @param point	e̓_
     * @return		e_̔z
     * @see	#project1From(JgclPoint3D)
     */
    public JgclPointOnSurface3D[] projectFrom(JgclPoint3D point) 
    {
	JgclPointOnSurface3D[] proj = { project1From(point) };
	return proj;
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂA
     * ^ꂽ덷ŕʋߎiq_QԂB
     * <p>
     * ʂƂĕԂiq_Q\_́A
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D 
     * 邱Ƃ҂łB
     * </p>
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @param tol	̋e덷
     * @return		̋Ȗʂ̎w̋Ԃ𕽖ʋߎiq_Q
     * @see		JgclPointOnSurface3D
     */
    public JgclMesh3D
    toMesh(JgclParameterSection uPint, JgclParameterSection vPint,
	   JgclToleranceForDistance tol)
    {
	JgclPointOnSurface3D[][] mesh = new JgclPointOnSurface3D[2][2];
	double uParam, vParam;
	int i, j;

	uParam = uPint.lower();
	for (i = 0; i < 2; i++) {
	    vParam = vPint.lower();
	    for (j = 0; j < 2; j++) {
		try {
		    mesh[i][j] = new JgclPointOnSurface3D(this, uParam, vParam, doCheckDebug);
		} catch (JgclInvalidArgumentValue e) {
		    throw new JgclFatal();
		}
		vParam = vPint.upper();
	    }
	    uParam = uPint.upper();
	}

	return new JgclMesh3D(mesh, false);
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂɍČL Bspline ȖʂԂB
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @return		̋Ȗʂ̎w̋ԂČL Bspline Ȗ
     */
    public JgclBsplineSurface3D
    toBsplineSurface(JgclParameterSection uPint,
		     JgclParameterSection vPint)
    {
	JgclPoint3D[][] controlPoints = new JgclPoint3D[2][2];
	double[][] weights = new double[2][2];

	double[] uParams = {uPint.start(), uPint.end()};
	double[] vParams = {vPint.start(), vPint.end()};

	for (int vi = 0; vi < 2; vi++) {
	    for (int ui = 0; ui < 2; ui++) {
		controlPoints[ui][vi] = this.coordinates(uParams[ui], vParams[vi]);
		weights[ui][vi] = 1.0;
	    }
	}

	return new JgclBsplineSurface3D(JgclBsplineKnot.quasiUniformKnotsOfLinearOneSegment,
					JgclBsplineKnot.quasiUniformKnotsOfLinearOneSegment,
					controlPoints, weights);
    }

    /**
     * ̏Ȗʂ (\ꂽ) RȐ̌_\㐔𐶐B
     * 
     * @param poly	xWGȐ邢͂aXvCȐ̂ZOg̑\̔z
     * @return		̏Ȗʂ poly ̌_\㐔̍
     */
    JgclRealPolynomial makePoly(JgclRealPolynomial[] poly) {
	return poly[2];
    }

    /**
     * ^ꂽ_̋Ȗʏɂ邩ۂ`FbNB
     * 
     * @param point	ΏۂƂȂ_
     * @return		^ꂽ_̋Ȗʏɂ trueAłȂ false
     */
    boolean checkSolution(JgclPoint3D point) {
	double dTol = getToleranceForDistance();
	return Math.abs(point.z()) < dTol;
    }

    /**
     * ̋ȖʂƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		_̔z
     */
    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate)
	throws JgclIndefiniteSolution
    {
	return mate.intersect(this, true);
    }

    /**
     * ̕ʂƗ^ꂽ () _߂
     * <p>
     * mate  this ̋ǏWnł̕\ɕϊ̂ M ƂāA
     * ݐݒ肳Ă鉉Z̉ŁA
     * M ̕xNgPʉxNg Z ̐Βl
     * ̋e덷΁A
     * ҂͌Ȃ̂Ƃ null ԂB
     * <br>
     * Ȁꍇɂ
     * M ̃p[^l 0 ̓_ Z ̐Βl
     * ̋e덷΁A
     * mate  this ɏĂ̂Ƃ
     * JgclIndefiniteSolution ̗O𔭐B
     * </p>
     * 
     * @param mate	
     * @return		_
     * @exception	JgclIndefiniteSolution	mate  this ɏĂAsł
     */
    public JgclIntersectionPoint3D intersect1(JgclLine3D mate)
        throws JgclIndefiniteSolution
    {
	JgclCartesianTransformationOperator3D gtrans = toGlobal();
	JgclPoint3D  localPnt = gtrans.reverseTransform(mate.pnt());
	JgclVector3D localDir = gtrans.reverseTransform(mate.dir());
	double dTol = getToleranceForDistance();

	// parallel ?
	JgclVector3D unitDir = localDir.unitized();
	if (Math.abs(unitDir.z()) < dTol) {
	    // overlap ?
	    if (Math.abs(localPnt.z()) < dTol) {
		throw new JgclIndefiniteSolution(mate.pnt());
	    }

	    return null;
	}

	// Line3D's parameter at intersection
	double eT = (- localPnt.z() / localDir.z());

	// Gh3Plane's parameter at intersection
	double eU = localPnt.x() + eT * localDir.x();
	double eV = localPnt.y() + eT * localDir.y();

	JgclPointOnSurface3D Apnt = new JgclPointOnSurface3D(this, eU, eV, doCheckDebug);
	JgclPointOnCurve3D   Bpnt = new JgclPointOnCurve3D(mate, eT, doCheckDebug);
	JgclIntersectionPoint3D intersectionPoint = new
	    JgclIntersectionPoint3D(Apnt, Apnt, Bpnt, doCheckDebug);

	return intersectionPoint;
    }

    /**
     * ̋ȖʂƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * {@link #intersect1(JgclLine3D) intersect1(JgclLine3D)}
     * ĂяoĂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	mate  this ɏĂAsł
     */
    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange)
	throws JgclIndefiniteSolution
    {
	JgclIntersectionPoint3D intp;
	try {
	    intp = intersect1(mate);
	} catch (JgclIndefiniteSolution e) {
	    intp = (JgclIntersectionPoint3D)e.suitable();
	    if (doExchange)
		intp = intp.exchange();
	    throw new JgclIndefiniteSolution(intp);
	}
	if (intp == null)
	    return new JgclIntersectionPoint3D[0];

	if (doExchange) {
	    intp = intp.exchange();
	}
	JgclIntersectionPoint3D[] ints = { intp };
	return ints;
    }

    /**
     * ̋ȖʂƑ̋Ȑ (~Ȑ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * <ul>
     * <li> ̕ (this) A Ɨ^ꂽ~Ȑ (mate) ̏镽 B Ƃ̌ I ߂B
     *		{@link #intersect1Plane(JgclPlane3D) intersect1Plane(JgclPlane3D)} 𗘗pB
     * <li> A  B ɌȂ΁Athis  mate ̌_ȂB
     * <li> A  B I[o[bvĂ΁AJgclIndefiniteSolution ̗O𔭐B
     * <li> mate  I ̌_߁A this  mate ̌_ƂB
     * </ul>
     * </p>
     * 
     * @param mate	̋Ȑ (~Ȑ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	mate  this ɏĂAsł
     */
    JgclIntersectionPoint3D[] intersect(JgclConic3D mate, boolean doExchange)
  	throws JgclIndefiniteSolution
    {
	// get osculating plane 
	JgclPlane3D osculating_plane = new JgclPlane3D(mate.position());
	
	// does planes intersect?
	JgclLine3D intAB;
	try{
	    intAB = intersect1Plane(osculating_plane);
	} catch(JgclIndefiniteSolution ip){
	    // overlap
	    JgclPoint3D pnt = coordinates(0.0,0.0);
	    throw new JgclIndefiniteSolution(pnt);
	}
	
	if(intAB == null)
	    return new JgclIntersectionPoint3D[0];
	
	// intersection between line & conic
	JgclIntersectionPoint3D[] int_pnt = mate.intersect(intAB,false);
	
	// make a intersection point plane & conic
	JgclIntersectionPoint3D[] return_pnt = new JgclIntersectionPoint3D[int_pnt.length];
	for(int i=0;i<int_pnt.length;i++){
	    
	    // intersection Point
	    JgclPoint3D pnt = int_pnt[i].coordinates();
	    
	    // plane's parameter
	    JgclAxis2Placement3D plane_axis = position();
	    JgclPoint3D plane_org = plane_axis.location();
	    JgclVector3D dir_vec = pnt.subtract(plane_org);
	    
	    // calculate parameter
	    double dU = dir_vec.dotProduct(plane_axis.x());
	    double dV = dir_vec.dotProduct(plane_axis.y());
	    
	    // point on plane(surface)
	    JgclPointOnSurface3D PonS = 
		new JgclPointOnSurface3D(this,dU,dV,doCheckDebug);
	    // point on conic(curve)
	    JgclPointOnGeometry3D PonC = int_pnt[i].pointOnGeometry1();
	    
	    // make a intersectionPoint
	    if(!doExchange)
		return_pnt[i] = new JgclIntersectionPoint3D(pnt,PonS,PonC,doCheckDebug);
	    else
		return_pnt[i] = new JgclIntersectionPoint3D(pnt,PonC,PonS,doCheckDebug);
	}
    	return return_pnt;
    }

    /**
     * ̋ȖʂƑ̋Ȗʂ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ȖʂӏɂẮA (JgclIntersectionCurve3D) ԂB
     * </p>
     * <p>
     * ȖʂڂӏɂẮA_ (JgclIntersectionPoint3D) Ԃ邱ƂB
     * </p>
     * 
     * @param mate	̋Ȗ
     * @return		 (܂͌_) ̔z
     * @exception	JgclIndefiniteSolution	mate ʂŁA҂I[o[bvĂAsł
     * @see		JgclIntersectionCurve3D
     * @see		JgclIntersectionPoint3D
     */
    public JgclSurfaceSurfaceInterference3D[] intersect(JgclParametricSurface3D mate)
	 throws JgclIndefiniteSolution
    {
	return mate.intersect(this, true);
    }

    /**
     * ̕ʂƑ̕ʂ̂̌𒼐Ƃċ߂B
     * <p>
     * ݐݒ肳Ă鉉Z̉ŁA
     * this  mate ̖@xNĝȂpx
     * px̋e덷ꍇɂ
     * ҂͌Ȃ̂Ƃ null ԂB
     * <br>
     * Ȁꍇɂ
     * ̕ʂ̋Ǐ_瑼̕ʂւ̋
     * ̋e덷ꍇɂ
     * ҂̓I[o[bvĂ̂Ƃ
     * JgclIndefiniteSolution ̗O𔭐B
     * </p>
     * 
     * @param mate	̕
     * @return		\
     * @exception	JgclIndefiniteSolution	this  mate I[o[bvĂAsł
     */
    public JgclLine3D intersect1Plane(JgclPlane3D mate)
	throws JgclIndefiniteSolution
    {
	JgclPoint3D  pnt;
	JgclVector3D dir;
	JgclLine3D   intersectLine;
	double aTol = getToleranceForAngle();

	// get unitized normal vectors
	JgclVector3D eAnorm = this.position().z();
	JgclVector3D eBnorm = mate.position().z();
	JgclPoint3D  eAloc  = this.position().location();
	JgclPoint3D  eBloc  = mate.position().location();
	if (Math.abs(eAnorm.dotProduct(eBnorm)) > Math.cos(aTol)) {
	    // 2 planes are parallel
	    JgclVector3D evec = eBloc.subtract(eAloc);
	    double dTol = getToleranceForDistance();
	    if ((Math.abs(evec.dotProduct(eAnorm)) < dTol) &&
		(Math.abs(evec.dotProduct(eBnorm)) < dTol))
	    {
		// 2 planes are overlap
		double dTol2 = getToleranceForDistance2();

		pnt = this.position().location();
		dir = mate.position().x();
		intersectLine = new JgclLine3D(pnt ,dir);

		throw new JgclIndefiniteSolution(intersectLine);
	    }
	    return null;
	}

	// direction vector of intersection
	dir = eAnorm.crossProduct(eBnorm).unitized();

	// point of intersection
	JgclVector3D pdir = dir.crossProduct(eAnorm);
	JgclLine3D perpendicularOfIntersection = new JgclLine3D(eAloc, pdir);
	try {
	    pnt = mate.intersect1(perpendicularOfIntersection);
	} catch (JgclIndefiniteSolution e) {
	    pnt = (JgclPoint3D) e.suitable();
	}
	JgclLine3D line = new JgclLine3D(pnt, dir);
	return line;
    }

    /**
     * ̋ȖʂƑ̋Ȗ () ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * {@link #intersect1Plane(JgclPlane3D) intersect1Plane(JgclPlane3D)}
     * ĂяoĂB
     * </p>
     * 
     * @param mate	̋Ȗ ()
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     * @exception	JgclIndefiniteSolution	this  mate I[o[bvĂAsł
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclPlane3D mate, boolean doExchange)
	 throws JgclIndefiniteSolution
    {
	JgclLine3D line;
	boolean indefinite = false;
	try {
	    line = intersect1Plane(mate);
	} catch (JgclIndefiniteSolution e) {
	    line = (JgclLine3D)e.suitable();
	    indefinite = true;
	}
	if (line == null) {
	    return new JgclSurfaceSurfaceInterference3D[0];
	}
	JgclIntersectionCurve3D ints = curveToIntersectionCurve(line, mate, doExchange);
	if (indefinite)
	    throw new JgclIndefiniteSolution(ints);
	JgclSurfaceSurfaceInterference3D[] sol = {ints};

	return sol;
    }

    /**
     * ̋ȖʂƑ̋Ȗ () ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * mate ̒S this ւ̋ DAmate ̔a R Ƃ
     * <ul>
     * <li> |D - R| ̋e덷΁Athis  mate ͈_Ō̂ƂA_ԂB
     * <li> D  R ΁AԂB̌̂R\͉~łB
     * <li> D  R 傫΁A͂ȂB
     * </ul>
     * </p>
     * 
     * @param mate	̋Ȗ ()
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     * @see	JgclElementarySurface3D#curveToIntersectionCurve(JgclParametricCurve3D, JgclElementarySurface3D, boolean)
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclSphericalSurface3D mate, boolean doExchange) {
	JgclPointOnSurface3D pcenter = project1From(mate.position().location());
	double dist = pcenter.distance(mate.position().location());
	double d_tol = getToleranceForDistance();

	if (Math.abs(dist - mate.radius()) <= d_tol) {
	    /*
	     * intersection is a point
	     */
	    double[] mateParams = mate.pointToParameter(pcenter);
	    JgclIntersectionPoint3D intsPnt;
	    if (!doExchange)
		intsPnt
		    = new JgclIntersectionPoint3D(this, pcenter.uParameter(), pcenter.vParameter(),
						  mate, mateParams[0], mateParams[1], doCheckDebug);
	    else
		intsPnt
		    = new JgclIntersectionPoint3D(mate, mateParams[0], mateParams[1],
						  this, pcenter.uParameter(), pcenter.vParameter(),
						  doCheckDebug);
	    JgclSurfaceSurfaceInterference3D[] intf = {intsPnt};
	    return intf;
	}

	if (dist > mate.radius()) {
	    /*
	     * no intersection
	     */
	    return new JgclSurfaceSurfaceInterference3D[0];
	}

	/*
	 * intersection is a circle
	 */
	JgclAxis2Placement3D axis
	    = new JgclAxis2Placement3D(pcenter.coordinates(), position().z(), position().x());
	double radius = Math.sqrt(mate.radius() * mate.radius() - dist * dist);
	JgclCircle3D res = new JgclCircle3D(axis, radius);
	JgclIntersectionCurve3D ints = curveToIntersectionCurve(res, mate, doExchange);
	JgclSurfaceSurfaceInterference3D[] sol = {ints};
	return sol;
    }

    /**
     * ̋ȖʂƑ̋Ȗ (~) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * <ul>
     * <li> this ̖@xNg mate ̋Ǐ Z ̂ȂpxƂ
     *		px̋e덷΁A (R\͉~) ԂB
     * <li> | - | px̋e덷ꍇA
     *		mate ̋Ǐ_ this ւ̋ DAmate ̔a R Ƃ
     * <ul>
     * <li>	|D - R| ̋e덷΁A (R\͒) ԂB
     * <li>	D  R ΁A (R\͒) ԂB
     * <li>	D  R 傫΁Athis  mate Ɍ͂ȂB
     * </ul>
     * <li> L̂łȂ΁A (R\͑ȉ~) ԂB
     * </ul>
     * </p>
     * 
     * @param mate	̋Ȗ (~)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     * @see	JgclElementarySurface3D#curveToIntersectionCurve(JgclParametricCurve3D, JgclElementarySurface3D, boolean)
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclCylindricalSurface3D mate,
						 boolean doExchange) {
	JgclPoint3D Borg = mate.position().location();
	JgclVector3D Bz = mate.position().z();
	JgclPointOnSurface3D pcenter;
	JgclVector3D ecrs = position().z().crossProduct(Bz);
	double dist;
	double a_tol = getToleranceForAngle();

	if (ecrs.length() < Math.sin(a_tol)) {
	    /*
	     * intersection is a circle
	     */
	    pcenter = project1From(Borg);
	    JgclAxis2Placement3D axis
		= new JgclAxis2Placement3D(pcenter.coordinates(), position().z(), position().x());
	    double radius = mate.radius();
	    JgclCircle3D res = new JgclCircle3D(axis, radius);
	    JgclIntersectionCurve3D ints = curveToIntersectionCurve(res, mate, doExchange);
	    JgclSurfaceSurfaceInterference3D[] sol = {ints};
	    return sol;
	}
	double d_tol = getToleranceForDistance();
	double edot = Math.abs(position().z().dotProduct(Bz));
	if (edot < Math.sin(a_tol)) {
	    /*
	     * sin(DATL) = cos(PI / 2 - DATL)
	     *
	     * intersections are lines
	     */
	    pcenter = project1From(Borg);
	    dist = pcenter.distance(Borg);
	    if (Math.abs(dist - mate.radius()) < d_tol) {
		/*
		 * intersection is a line
		 */
		JgclLine3D res = new JgclLine3D(pcenter.coordinates(), Bz);
		JgclIntersectionCurve3D ints = curveToIntersectionCurve(res, mate, doExchange);
		JgclSurfaceSurfaceInterference3D[] sol = {ints};
		return sol;
	    }
	    if (dist < mate.radius()) {
		/*
		 * intersections are 2 lines
		 */
		dist = Math.sqrt(mate.radius() * mate.radius() - dist * dist);
		ecrs = ecrs.unitized().multiply(dist);
		JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[2];
		JgclLine3D res1 = new JgclLine3D(pcenter.add(ecrs), Bz);
		JgclLine3D res2 = new JgclLine3D(pcenter.subtract(ecrs), Bz);
		sol[0] = curveToIntersectionCurve(res1, mate, doExchange);
		sol[1] = curveToIntersectionCurve(res2, mate, doExchange);
		return sol;
	    }
	    return new JgclSurfaceSurfaceInterference3D[0];
	}

	/*
	 * intersection is an ellipse
	 */
	JgclCartesianTransformationOperator3D trns = toGlobal();
	JgclPoint3D BorginA = trns.toLocal(Borg);
	JgclVector3D BzinA = trns.toLocal(Bz);
	dist = (- BorginA.z() / BzinA.z());

	JgclAxis2Placement3D axis
	    = new JgclAxis2Placement3D(Borg.add(Bz.multiply(dist)),
				       position().z(), position().z().crossProduct(ecrs));
	JgclEllipse3D res = new JgclEllipse3D(axis, mate.radius() / edot, mate.radius());
	JgclIntersectionCurve3D ints = curveToIntersectionCurve(res, mate, doExchange);
	JgclSurfaceSurfaceInterference3D[] sol = {ints};
	return sol;
    }

    /**
     * ̋ȖʂƑ̋Ȗ (~) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsPlnCon3D JgclIntsPlnCon3D}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (~)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclConicalSurface3D mate,
						 boolean doExchange) {
	JgclIntsPlnCon3D doObj = new JgclIntsPlnCon3D(this, mate);
	return doObj.getInterference(doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ (xWGȖ) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsQrdBzs3D#intersection(JgclElementarySurface3D, JgclPureBezierSurface3D, boolean)
     * JgclIntsQrdBzs3D.intersection}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (xWGȖ)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclPureBezierSurface3D mate,
						 boolean doExchange) {
	return JgclIntsQrdBzs3D.intersection(this, mate, doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ (aXvCȖ) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsSrfBss3D#intersection(JgclElementarySurface3D, JgclBsplineSurface3D, boolean)
     * JgclIntsSrfBss3D.intersection}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (aXvCȖ)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclBsplineSurface3D mate,
						 boolean doExchange) {
	return JgclIntsSrfBss3D.intersection(this, mate, doExchange);
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂItZbgȖʂ
     * ^ꂽ덷ŋߎ Bspline Ȗʂ߂B
     * <p>
     * ̃\bhԂaXvCȖʂ́A
     * ʂItZbgȖʂɌɍČB
     * āÃ\bhł tol ̒l͎QƂȂB
     * </p>
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.FRONT/BACK)
     * @param tol     	̋e덷
     * @return		̋Ȗʂ̎w̋`Ԃ̃ItZbgȖʂߎ Bspline Ȗ
     * @see	JgclWhichSide
     */
    public JgclBsplineSurface3D 
	offsetByBsplineSurface(JgclParameterSection uPint,
			       JgclParameterSection vPint,
			       double magni,
			       int side,
			       JgclToleranceForDistance tol) {
	// _
	int uicp = 4;
	
	// mbgz̗vf
	int uik = 2;
	
	// mbgz
	double[] uknots = new double[2];
	double[] vknots = new double[2];
	int[] uknot_multi = new int[2];
	int[] vknot_multi = new int[2];
	
	uknots[0] = 0.0;     uknot_multi[0] = 4;
	uknots[1] = Math.abs(uPint.increase()); uknot_multi[1] = 4;
	
	vknots[0] = 0.0;     vknot_multi[0] = 4;
	vknots[1] = Math.abs(vPint.increase()); vknot_multi[1] = 4;
	
	// p[^Ԋu
	double uparam_interval = uPint.increase()/(uicp -1);
	double vparam_interval = vPint.increase()/(uicp -1);
	
	// ItZbgxNg
	JgclVector3D offset_vector;        
	if(side == JgclWhichSide.FRONT)
	    offset_vector = normalVector(uPint.start(),vPint.start());
	else if(side == JgclWhichSide.BACK){
	    offset_vector = normalVector(uPint.start(),vPint.start());
	    offset_vector = offset_vector.reverse();
	} else 
	    throw new JgclInvalidArgumentValue(); 
		
	offset_vector = offset_vector.multiply(magni);
	
	// ItZbg
	int i,j;
	double crnt_param;
	JgclPoint3D[][] crnt_pnt = new JgclPoint3D[uicp][uicp];
	
	for(i=0;i<uicp;i++){
	    for(j=0;j<uicp;j++){
		crnt_pnt[i][j] = 
		    coordinates(uPint.start() + i * uparam_interval,
			       vPint.start() + j * vparam_interval);
		crnt_pnt[i][j] = crnt_pnt[i][j].add(offset_vector);
	    }
	}
	
	// BXvCǖʃItWFNg̍쐬
	JgclBsplineSurface3D bss =  
	    new JgclBsplineSurface3D(3,false,uknot_multi,uknots, 
				     3,false,vknot_multi,vknots,crnt_pnt);
	return bss;
    }
    
    /*
     * ̋Ȗʂ U p[^̈ʒuɂ铙p[^ȐԂB
     *
     * @param uParam	U ̃p[^l
     * @return	w U p[^lł̓p[^Ȑ
     */
    public JgclParametricCurve3D uIsoParametricCurve(double uParam) {
	JgclPoint3D pnt = coordinates(uParam, 0.0);
	JgclVector3D dir = position().y();
	return new JgclLine3D(pnt, dir);
    }

    /*
     * ̋Ȗʂ V p[^̈ʒuɂ铙p[^ȐԂB
     *
     * @param vParam	V ̃p[^l
     * @return	w V p[^lł̓p[^Ȑ
     */
    public JgclParametricCurve3D vIsoParametricCurve(double vParam) {
	JgclPoint3D pnt = coordinates(0.0, vParam);
	JgclVector3D dir = position().x();
	return new JgclLine3D(pnt, dir);
    }

    /*
     * ̋Ȗʂ U ̃p[^`ԂB
     * <p>
     * ŔIȒ`ԂB
     * </p>
     *
     * @return	̋Ȗʂ U ̃p[^`
     */
    JgclParameterDomain getUParameterDomain() {
	return new JgclParameterDomain();
    }

    /*
     * ̋Ȗʂ V ̃p[^`ԂB
     * <p>
     * ŔIȒ`ԂB
     * </p>
     *
     * @return	̋Ȗʂ V ̃p[^`
     */
    JgclParameterDomain getVParameterDomain() {
	return new JgclParameterDomain();
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricSurface3D#PLANE_3D JgclParametricSurface3D.PLANE_3D}
     */
    int type() {
	return PLANE_3D;
    }

    /**
     * ^ꂽ_A̕ʂ̂ǂ瑤ɂ邩𒲂ׂB
     * <p>
     * point  this ̋ǏWnł̕\ɕϊ̂ P ƂāA
     * ݐݒ肳Ă鉉Z̉ŁA
     * P  Z ̒l̋e덷傫 JgclWhichSide.FRONTA
     * (- ̋e덷)  JgclWhichSide.BACKA
     * ǂłȂ JgclWhichSide.ON
     * ԂB
     * </p>
     *
     * @return	JgclWhichSide.{ON, FRONT, BACK} ̂ꂩ
     * @see	JgclWhichSide
     */
    int pointIsWhichSide(JgclPoint3D point) {
	double d_tol = getToleranceForDistance();

	/*
	 * transform dApnt into plane's coordinates system
	 */
	JgclCartesianTransformationOperator3D trns
	    = new JgclCartesianTransformationOperator3D(position(), 1.0);
	JgclPoint3D eApnt = trns.toLocal(point);

	/*
	 * judgement
	 */
	int result;

	if (eApnt.z() > d_tol)
	    result = JgclWhichSide.FRONT;
	else if (eApnt.z() < (- d_tol))
	    result = JgclWhichSide.BACK;
	else
	    result = JgclWhichSide.ON;

	return result;
    }

    /**
     * ^ꂽ_Qꕽʏɂ邩 (ʂȂ) ǂ𒲂ׂB
     * <p>
     * ^ꂽ_̔z̗vf 2 ȉ̏ꍇɂ̓[xNgԂB
     * </p>
     * <p>
     * ^ꂽ_Q_ɏkނĂ邩A邢͋Ԃɂꍇɂ
     * [xNgԂB
     * </p>
     * <p>
     * ^ꂽ_QʏԂɂȂꍇɂ null ԂB
     * </p>
     *
     * @param points    _Q
     * @return	_Q̏Ă镽ʂ̒Pʖ@xNg
     */
    public static JgclVector3D coplaner(JgclPoint3D[] points) {
	int npnts = points.length;
	if (npnts <= 2)
	    return JgclVector3D.zeroVector();

	JgclVector3D[] spanPlane = new JgclVector3D[2];
	JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
	double dTol2 = condition.getToleranceForDistance2();
	double aTol = condition.getToleranceForAngle();
	int k = 0;
	JgclVector3D evec;

	// make the reference plane
	for (int j = 1; j < npnts; j++) {
	    evec = points[j].subtract(points[0]);
	    if (evec.norm() > dTol2) {
		evec = evec.unitized();
		if ((k != 0) && (Math.abs(evec.dotProduct(spanPlane[0])) > Math.cos(aTol)))
		    continue;
		spanPlane[k] = evec;
		if ((++k) == 2) break;
	    }
	}
	if (k != 2) {
	    // points are concurrent or collinear
	    return JgclVector3D.zeroVector();
	}

	JgclVector3D uax = spanPlane[0].crossProduct(spanPlane[1]).unitized();
	for (int j = 1; j < npnts; j++) {
	    evec = points[j].subtract(points[0]);
	    if (Math.abs(evec.dotProduct(uax)) > condition.getToleranceForDistance())
		return null;
	}
	return uax;
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂA
     * ^ꂽ덷ŕʋߎ_QԂB
     * <p>
     * ʂƂē_Q͈ʂɁAʑIɂ􉽓IɂAiqł͂ȂB
     * </p>
     * <p>
     * scalingFactor ́A͗pł͂ȂAo͗p̈łB
     * scalingFactor ɂ́Avf 2 ̔z^B
     * scalingFactor[0] ɂ U ̏kڔ{A
     * scalingFactor[1] ɂ V ̏kڔ{ԂB
     * ̒l͉炩̐Βlł͂ȂA
     * p[^̐iޑx T ɑ΂āA
     * U/V ɂĎԏŋȖʏ̓_iޑx Pu/Pv \ΒlłB
     * ܂Ap[^ T iނƁA
     * ԏł̋Ȗʏ̓_ U ł Pu (scalingFactor[0])A
     * V ł Pv (scalingFactor[1]) iނƂ\ĂB
     * T ̑傫͖Ȃ̂ŁA̒lQƂۂɂ́A
     * scalingFactor[0]  scalingFactor[1] ̔䂾pׂłB
     * ȂA̒l͂܂łڈłAȑx̂ł͂ȂB
     * </p>
     * <p>
     * ʂƂĕԂ Vector Ɋ܂܂evf
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D
     * ł邱Ƃ҂łB
     * </p>
     *
     * @param uParameterSection	U ̃p[^
     * @param vParameterSection	V ̃p[^
     * @param tolerance	̋e덷
     * @param scalingFactor	_QOp`ۂɗLpƎv U/V ̏kڔ{
     * @return	_Q܂ Vector
     * @see	JgclPointOnSurface3D
     */
    public Vector toNonStructuredPoints(JgclParameterSection uParameterSection,
					JgclParameterSection vParameterSection,
					double tolerance,
					double[] scalingFactor) {
	Vector result = new Vector();
	double uParameter;
	double vParameter;
	JgclPointOnSurface3D point;

	for (int u = 0; u < 2; u++) {
	    uParameter = (u == 0)
		? uParameterSection.start() : uParameterSection.end();
	    for (int v = 0; v < 2; v++) {
		vParameter = (v == 0)
		    ? vParameterSection.start() : vParameterSection.end();
		point = new JgclPointOnSurface3D(this, uParameter, vParameter, doCheckDebug);
		result.addElement(point);
	    }
	}

	scalingFactor[0] = 1.0;
	scalingFactor[1] = 1.0;

	return result;
    }

    /**
     * ̋ȖʂA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricSurface3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclAxis2Placement3D tPosition =
	    this.position().transformBy(reverseTransform,
					transformationOperator,
					transformedGeometries);
	return new JgclPlane3D(tPosition);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
	String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tposition");
        position().output(writer, indent + 2);
        writer.println(indent_tab + "End");
    }
}
