/*
 * pgbNȋȐ̃NXKw̃[gƂȂ钊ۃNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclParametricCurve.java,v 1.22 2000/04/26 09:39:15 hideit Exp $
 */

package jp.go.ipa.jgcl;

/**
 * pgbNȋȐ P(t) ̃NXKw̃[gƂȂ钊ۃNXB
 * <p>
 * ̃NX́A̎lŕ\p[^ t ̒lɂāA
 * ʒu肳Ȑ P(t) Sʂ\B
 * </p>
 *
 * @version $Revision: 1.22 $, $Date: 2000/04/26 09:39:15 $
 * @author Information-technology Promotion Agency, Japan
 * @see	JgclParameterDomain
 * @see	JgclParametricSurface
 */

public abstract class JgclParametricCurve extends JgclGeometry {

    /**
     * Ȑ̃p[^`B
     * <p>
     * KvɉăLbVB
     * 쐬̒l nullB
     * </p>
     * @serial
     */
    private JgclParameterDomain domain;

    /**
     * 􉽓IɕĂ邩ۂtOB
     * <p>
     * KvɉăLbVB
     * 쐬̒l JgclTrueFalseUndefined.UNDEFINEDB
     * </p>
     * @serial
     * @see	JgclTrueFalseUndefined
     */
    private int closedCurve;

    /**
     * ^ɃIuWFNg\zB
     */
    protected JgclParametricCurve() {
	super();
	initFields();
    }

    /**
     * private ȃtB[hB
     * @see	JgclTrueFalseUndefined
     */
    private void initFields() {
	domain = null;
	closedCurve = JgclTrueFalseUndefined.UNDEFINED;
    }

    /**
     * ^ꂽp[^Ԃɂ邱̋Ȑ̎ԏł̒ (̂) Ԃۃ\bhB
     * <p>
     * Ȑ̃p[^`悪LŔIȏꍇA
     * pint p[^Ԃ́A
     * Ȑ̃p[^`̓Ɏ܂ĂȂ΂ȂȂB
     * </p>
     * <p>
     * ȂApint ̑l͕ł܂ȂB
     * </p>
     *
     * @param pint	Ȑ̒߂p[^
     * @return	w肳ꂽp[^ԂɂȐ̒
     * @see	#parameterDomain()
     */
    public abstract double length(JgclParameterSection pint);

    /**
     * ̋Ȑ̃p[^`ԂB
     * 
     * @return	Ȑ̃p[^`
     */
    public JgclParameterDomain parameterDomain() {
	if (domain == null) {
	    domain = getParameterDomain();
	}
	return domain;
    }

    /**
     * ̋Ȑ􉽓IɕĂ邩ۂԂB
     * 
     * @return	􉽓IɕĂ trueAłȂ false
     */
    public boolean isClosed() {
	if (closedCurve == JgclTrueFalseUndefined.UNDEFINED) {
	    if (getClosedFlag()) {
		closedCurve = JgclTrueFalseUndefined.TRUE;
	    } else {
		closedCurve = JgclTrueFalseUndefined.FALSE;
	    }
	}
	if (closedCurve == JgclTrueFalseUndefined.TRUE) {
	    return true;
	} else {
	    return false;
	}
    }

    /**
     * ̋Ȑ􉽓IɊJĂ邩ۂԂB
     * 
     * @return	􉽓IɊJĂ trueAłȂ false
     */
    public boolean isOpen() {
	return !isClosed();
    }

    /**
     * ȐۂԂB
     * <p>
     *  true ԂB
     * </p>
     *
     * @return	ȐȂ̂ŁA <code>true</code>
     */
    public boolean isCurve() {
	return true;
    }

    /**
     * pgbNۂԂB
     * <p>
     *  true ԂB
     * </p>
     * 
     * @return	pgbNȂ̂ŁA <code>true</code>
     */
    public boolean isParametric() {
	return true;
    }

    /**
     * ̋ȐLۂԂB
     * 
     * @return	Lł trueAłȂ false
     */
    public boolean isFinite() {
	return parameterDomain().isFinite();
    }

    /**
     * ̋ȐۂԂB
     * 
     * @return	ł trueAłȂ false
     */
    public boolean isInfinite() {
	return parameterDomain().isInfinite();
    }

    /**
     * ̋Ȑ̃p[^`悪IۂԂB
     * 
     * @return	Ił trueAłȂ false
     */
    public boolean isPeriodic() {
	return parameterDomain().isPeriodic();
    }

    /**
     * ̋Ȑ̃p[^`悪IۂԂB
     * 
     * @return	Ił trueAłȂ false
     */
    public boolean isNonPeriodic() {
	return parameterDomain().isNonPeriodic();
    }

    /**
     * ^ꂽp[^A̋Ȑ̒`̓ɂ邩ۂԂB
     * <p>
     * value ALȃp[^Ԃ̒[_ɂꍇɂ́uvƔfB
     * </p>
     * <p>
     * e덷ƂāAݐݒ肳Ă鉉Źup[^l̋e덷vQƂB
     * </p>
     * 
     * @param value	p[^
     * @return		value `̓ɂ trueAłȂ false
     * @see	JgclConditionOfOperation
     * @see	JgclParameterDomain#isValid(double)
     */
    public boolean isValid(double value) {
	return parameterDomain().isValid(value);
    }

    /**
     * ^ꂽp[^lA̋Ȑ̒`ɑ΂ėLۂ𒲂ׂB
     * <p>
     * value ̋Ȑ̃p[^`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param value	p[^l
     * @see	JgclParameterOutOfRange
     * @see	JgclParameterDomain#checkValidity(double)
     */
    public void checkValidity(double value) {
	parameterDomain().checkValidity(value);
    }

    /**
     * ^ꂽp[^ԂA̋Ȑ̒`ɑ΂ėLۂ𒲂ׂB
     * <p>
     * section ̑l͕ł\ȂB
     * </p>
     * 
     * @param section	p[^
     * @exception JgclParameterOutOfRange	p[^Ԃ`OĂ
     * @exception JgclInvalidArgumentValue	p[^Ԃ̒A蒷
     *						(Iȏꍇ̂)
     * @see	JgclParameterDomain#checkValidity(JgclParameterSection)
     */
    public void checkValidity(JgclParameterSection section) {
	parameterDomain().checkValidity(section);
    }

    /**
     * ̋Ȑ̃p[^`Ԃۃ\bhB
     *
     * @return	̋Ȑ̃p[^`
     */
    abstract JgclParameterDomain getParameterDomain();

    /**
     * ̋Ȑ􉽓IɕĂ邩ۂԂۃ\bhB
     *
     * @return	􉽓IɕĂ trueAłȂ false
     */
    abstract boolean getClosedFlag();
}
