/*
 * p[^l̑ݔ͈͂p[^Ԃ\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclParameterSection.java,v 1.21 2000/04/26 09:39:14 hideit Exp $
 */

package jp.go.ipa.jgcl;

/**
 * p[^l̑ݔ͈͂p[^Ԃ\NXB
 *
 * @version $Revision: 1.21 $, $Date: 2000/04/26 09:39:14 $
 * @author Information-technology Promotion Agency, Japan
 * @see	JgclParameterDomain
 */

public class JgclParameterSection extends java.lang.Object
implements java.io.Serializable
{

    /**
     * JnlB
     * @serial
     */
    private final double start;

    /**
     * lB
     * @serial
     */
    private final double increase;

    /**
     * Il (end = start + increase) B
     * @serial
     */
    private final double end;

    /**
     * JnlƑlw肵ăIuWFNg\zB
     * <p>
     * increase ̒l̓[邢͕łĂ\ȂB
     * </p>
     * 
     * @param start	Jnl
     * @param increase	l
     */
    public JgclParameterSection(double start, double increase) {
	super();
	this.start = start;
	this.increase = increase;
	end = start + increase;
    }

    /**
     * JnlԂB
     * 
     * @return		Jnl
     */
    public double start() {
	return this.start;
    }

    /**
     * IlԂB
     *
     * @return		Il
     */
    public double end() {
	return this.end;
    }

    /**
     * lԂB
     * 
     * @return		l
     */
    public double increase() {
	return this.increase;
    }

    /**
     * l̐ΒlԂB
     * 
     * @return		l̐Βl
     */
    public double absIncrease() {
	return Math.abs(this.increase);
    }

    /**
     * lԂB
     * 
     * @return		l
     */
    public double lower() {
	if (increase() < 0)
	    return end();
	else
	    return start();
    }

    /**
     * lԂB
     * 
     * @return		l
     */
    public double upper() {
	if (increase() >= 0)
	    return end();
	else
	    return start();
    }

    /**
     * 𔽓]IuWFNgԂB
     * <p>
     * end  start ֌IuWFNgԂB
     * </p>
     *
     * @return	𔽓]IuWFNg
     */
    public JgclParameterSection reverse() {
	return new JgclParameterSection(this.end(), (- this.increase()));
    }

    /**
     * ͈͂ŁAl̃IuWFNgԂB
     *
     * @return	͈͂ŁAl̃IuWFNg
     */
    public JgclParameterSection positiveIncrease() {
	return (this.increase() < 0.0) ? this.reverse() : this;
    }

    /**
     * ^ꂽp[^lÃp[^Ԃ̓ɂ邩ۂԂB
     * <p>
     * value Ap[^Ԃ̒[_ɂꍇɂ́uvƔfB
     * </p>
     * <p>
     * e덷ƂāAݐݒ肳Ă鉉Źup[^l̋e덷vQƂB
     * </p>
     * 
     * @param value	p[^l
     * @return		value Lł(lƏl̊Ԃɂ)
     *			<code>true</code>AȂ <code>false</code>
     * @see	JgclConditionOfOperation
     */
    public boolean isValid(double value) {
	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double sval = start();
	double eval = end();
	double pTol = condition.getToleranceForParameter();

	if (increase() >= 0) {
	    return sval-pTol <= value && value <= eval+pTol;
	}
	else {
	    return eval-pTol <= value && value <= sval+pTol;
	}
    }

    /**
     * ^ꂽԂA̋ԂƓƌȂ邩ۂԂB
     * <p>
     * e덷ƂāAݐݒ肳Ă鉉Źup[^l̋e덷vQƂB
     * </p>
     *
     * @param mate	̋
     * @return	p[^l̋e덷œȂ trueAłȂ false
     * @see	JgclConditionOfOperation
     */
    public boolean identical(JgclParameterSection mate) {
	if (this == mate)
	    return true;

	double pTol =
	    JgclConditionOfOperation.getCondition().getToleranceForParameter();

	if (Math.abs(this.start() - mate.start()) > pTol)
	    return false;

	if (Math.abs(this.increase() - mate.increase()) > pTol)
	    return false;

	return true;
    }
}

