/*
 * pgbNȊ֐ɂA̃p[^̒`\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclParameterDomain.java,v 1.24 2000/04/26 09:39:14 hideit Exp $
 */

package jp.go.ipa.jgcl;

/**
 * pgbNȊ֐ɂA̃p[^̒`\NXB
 * <p>
 * p[^`́A܂Ȃ̂ƗLȂ̂ɕB
 * JGCL ̋ȐыȖʂ̕\ɂẮA
 * Ȓ`֐̒l͖A
 * LȒ`֐̒l͗LA
 * ł̂ƂĂB
 * <br>
 * ȃp[^`ł́A
 * p[^̗LȋԂ (-, ) łB
 * <br>
 * Lȃp[^`́AɎIȂ̂ƔIȂ̂ɕB
 * <br>
 * LŎIȃp[^`ł
 * p[^̗LȋԂ (-, ) ł邪A
 * vC}ȗL [a, b] B
 * (b - a) ̒`́uvƌĂԁB
 * ŁA̃p[^ t0, t1 ƂāA
 * t0  t1 ̍ (b - a) łꍇA
 * ֐ F(t)  t0, t1 ꂼɑ΂l F(t0), F(t1) ͓ɂȂB
 * <br>
 * LŔIȃp[^`ł́A
 * p[^̗LȋԂ [a, b] łB
 * ̗LȋԂOp[^l t ɑ΂āAF(t) ͒lȂB
 * <br>
 * ȂAȃp[^`́AɔIł̂ƂB
 * </p>
 * <p>
 * ̃NXł́Ap[^͏ɐ̕ɐiނ̂ƂĈB
 * </p>
 *
 * @version $Revision: 1.24 $, $Date: 2000/04/26 09:39:14 $
 * @author Information-technology Promotion Agency, Japan
 * @see	JgclParameterSection
 * @see	JgclParametricCurve
 * @see	JgclParametricSurface
 */

public class JgclParameterDomain extends java.lang.Object
    implements java.io.Serializable {

    /**
     * LۂB
     * @serial
     */
    private final boolean finite;

    /**
     * IۂB
     * @serial
     */
    private final boolean periodic;

    /**
     * p[^̗L (Iȏꍇɂ́AvC}ȗL) B
     * @serial
     */
    private final JgclParameterSection section;

    /**
     * ŔIȃIuWFNg\zB
     */
    public JgclParameterDomain() {
	super();
	finite = false;
	periodic = false;
	section = null;
    }

    /**
     * LȃIuWFNg\zB
     * <p>
     * periodic  true ̏ꍇA
     * start  increase  vC}ȗLԂw肷lƉ߂A
     * increase ̃p[^`̎ƂȂB
     * </p>
     * <p>
     * increase ͐̒lłȂ΂ȂȂB
     * increase ̒l邢́uݐݒ肳Ăp[^l̋e덷v菬ꍇɂ
     * JgclInvalidArgumentValue ̗OB
     * </p>
     *
     * @param periodic	Iۂ
     * @param start	p[^Ԃ̊Jnl
     * @param increase	p[^Ԃ̑l
     * @see	JgclConditionOfOperation
     * @see	JgclInvalidArgumentValue
     */
    public JgclParameterDomain(boolean periodic,
			       double start, double increase)
    {
	super();
	double pTol = JgclConditionOfOperation.getCondition().
	    getToleranceForParameter();
	if (increase <= pTol)
	    throw new JgclInvalidArgumentValue("increase is less than the tolerance for parameter");

	finite = true;
	this.periodic = periodic;
	section = new JgclParameterSection(start, increase);
    }

    /**
     * LȃIuWFNg\zB
     * <p>
     * periodic  true ̏ꍇA
     * section  vC}ȗLԂw肷lƉ߂A
     * section ̑l̃p[^`̎ƂȂB
     * </p>
     * <p>
     * section ̑l͐̒lłȂ΂ȂȂB
     * section ̑l邢́uݐݒ肳Ăp[^l̋e덷v菬ꍇɂ
     * JgclInvalidArgumentValue ̗OB
     * </p>
     *
     * @param periodic	Iۂ
     * @param section	p[^
     * @see	JgclConditionOfOperation
     * @see	JgclInvalidArgumentValue
     */
    public JgclParameterDomain(boolean periodic,
			       JgclParameterSection section)
    {
	super();
	double pTol = JgclConditionOfOperation.getCondition().
	    getToleranceForParameter();
	if (section.increase() <= pTol)
	    throw new JgclInvalidArgumentValue("increase is less than the tolerance for parameter");

	finite = true;
	this.periodic = periodic;
	this.section = section;
    }

    /**
     * ̃p[^`悪LۂԂB
     * 
     * @return	LȂ <code>true</code>AȂ <code>false</code>
     */
    public boolean isFinite() {
	return finite;
    }

    /**
     * ̃p[^`悪ۂԂB
     * 
     * @return	Ȃ <code>true</code>AȂ <code>false</code>
     */
    public boolean isInfinite() {
	return !finite;
    }

    /**
     * ̃p[^`悪IۂԂB
     * 
     * @return	IȂ <code>true</code>AȂ <code>false</code>
     */
    public boolean isPeriodic() {
	return periodic;
    }

    /**
     * ̃p[^`悪IۂԂB
     * 
     * @return	Ił <code>true</code>AȂ <code>false</code>
     */
    public boolean isNonPeriodic() {
	return !periodic;
    }

    /**
     * ̃p[^`̗Lȃp[^ԂԂB
     * <p>
     * p[^`悪Iȏꍇɂ́AvC}ȗLԂԂB
     * </p>
     * <p>
     * p[^`悪ȏꍇɂ́Anull ԂB
     * </p>
     * 
     * @return	p[^
     */
    public JgclParameterSection section() {
	return this.section;
    }

    /**
     * ^ꂽp[^lÃp[^`ɂėLۂԂB
     * <p>
     * value ALȃp[^Ԃ̒[_ɂꍇɂ́uLvƔfB
     * </p>
     * <p>
     * e덷ƂāAݐݒ肳Ă鉉Źup[^l̋e덷vQƂB
     * </p>
     * 
     * @param value	p[^l
     * @return	value LȂ <code>true</code>AȂ <code>false</code>
     * @see	JgclConditionOfOperation
     * @see	JgclParameterSection#isValid(double)
     */
    public boolean isValid(double value) {
	if (isInfinite())
	    return true;
	else if (isPeriodic())
	    return true;
	else
	    return section.isValid(value);
    }

    /**
     * ^ꂽp[^lA̒`ɑ΂ėLۂ𒲂ׂB
     * <p>
     * value ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param value	p[^l
     * @see	JgclParameterOutOfRange
     * @see	#isValid(double)
     */
    public void checkValidity(double value) {
	if (!isValid(value))
	    throw new JgclParameterOutOfRange();
    }

    /**
     * ^ꂽp[^ԂA̒`ɑ΂ėLۂ𒲂ׂB
     * <p>
     * section ̑l͕ł\ȂB
     * </p>
     * 
     * @param section	p[^
     * @exception JgclParameterOutOfRange	p[^Ԃ`OĂ
     * @exception JgclInvalidArgumentValue	p[^Ԃ̒A蒷
     *						(Iȏꍇ̂)
     * @see	#checkValidity(double)
     */
    public void checkValidity(JgclParameterSection section) {
	checkValidity(section.start());
	checkValidity(section.end());

	if (isPeriodic()) {
	    double pTol = JgclConditionOfOperation.getCondition().getToleranceForParameter();
	    if (Math.abs(section.increase()) > Math.abs(section().increase()) + pTol)
		throw new JgclInvalidArgumentValue();
	}
    }

    /**
     * ^ꂽp[^lÃp[^`
     * vC}Ȏɐ܂񂾒lԂB
     * <p>
     * LŎIȏꍇȊÓAl̂܂ܕԂB
     * </p>
     * 
     * @param value	܂ރp[^l
     * @return	܂񂾒l
     */
    public double wrap(double value) {
	if (isInfinite() || isNonPeriodic())
	    return value;
	else {
	    double low, inc, n;

	    low = section.lower();
	    inc = Math.abs(section.increase());

	    if (value < low) {
		n = Math.floor((low - value) / inc) + 1;
		return value + (n * inc);
	    }
	    else if ((value > section.upper()) != true) {
		return value;
	    }
	    else {
		n = Math.floor((value - low) / inc);
		return value - (n * inc);
	    }
	}
    }

    /**
     * ^ꂽp[^lÃp[^`
     * Lȃp[^ԓɎ܂悤ϊlԂB
     * <p>
     * LŔIȏꍇȊÓAl̂܂ܕԂB
     * </p>
     * 
     * @param value	ϊp[^l
     * @return	ϊ̒l
     */
    public double force(double value) {
	if (isInfinite() || isPeriodic()) {
	    return value;
	}
	else {
	    double low, high;

	    low = section.lower();
	    high = section.upper();

	    if (value < low)
		return low;
	    else if (high < value)
		return high;
	    else
		return value;
	}
    }
}
