/*
 * R : \NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclParabola3D.java,v 1.48 2000/08/11 06:18:54 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * R : \NXB
 * <p>
 * ́A̒_̈ʒuƋǏ X/Y ̕ǏWn
 * (zuA{@link JgclAxis2Placement3D JgclAxis2Placement3D}) position 
 * _œ_܂ł̋ focalDist
 * Œ`B
 * </p>
 * <p>
 * t p[^Ƃ P(t) ̃pgbN\́Aȉ̒ʂB
 * <pre>
 *	P(t) = position.location() + focalDist * (t * t * position.x() + 2 * t * position.y())
 * </pre>
 * </p>
 *
 * @version $Revision: 1.48 $, $Date: 2000/08/11 06:18:54 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclParabola3D extends JgclConic3D {

    /**
     * _œ_܂ł̋B
     * @serial
     */
    private double focalDist;

    /**
     * _œ_܂ł̋AێtB[hɐݒ肷B
     * <p>
     * focalDist ̒l͐łȂ΂ȂȂB
     * </p>
     * <p>
     * focalDist ̒l
     * ݐݒ肳Ă鉉Z̋̋e덷菬ꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     *
     * @param focalDist	_œ_܂ł̋
     * @see	JgclInvalidArgumentValue
     */
    private void setFocalDist(double focalDist)
    {
	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double dTol = condition.getToleranceForDistance();

	if (focalDist < dTol) {
	    throw new JgclInvalidArgumentValue();
	}
	this.focalDist = focalDist;
    }

    /**
     * ǏWnƒ_œ_܂ł̋^ăIuWFNg\zB
     * <p>
     * position  null ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * focalDist ̒l
     * ݐݒ肳Ă鉉Z̋̋e덷菬ꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     * 
     * @param position	SƋǏ X/Y/Z ̕ǏWn
     * @param focalDist	_œ_܂ł̋
     * @see	JgclInvalidArgumentValue
     */
    public JgclParabola3D(JgclAxis2Placement3D position, double focalDist)
    {
	super(position);
	setFocalDist(focalDist);
    }

    /**
     * ́̕u_|œ_ԋvpāA^ꂽʒuƌXłQ̕쐬B
     * <p>
     * position  null ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param position	Q̈̕ʒuƌXǏWn
     * @return	Q̕
     * @see	JgclInvalidArgumentValue
     */
    JgclConic2D toLocal2D(JgclAxis2Placement2D position) {
	return new JgclParabola2D(position, focalDist());
    }

    /**
     * ̒̕_œ_܂ł̋ԂB
     * 
     * @return	_œ_܂ł̋
     */
    public double focalDist() {
	return this.focalDist;
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̍WlԂB
     * 
     * @param param	p[^l
     * @return		Wl
     */
    public JgclPoint3D coordinates(double param) {
	JgclAxis2Placement3D ax = position();
	JgclVector3D x = ax.x().multiply(param * param * focalDist);
	JgclVector3D y = ax.y().multiply(2 * param * focalDist);

	return ax.location().add(x.add(y));
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̐ڃxNgԂB
     * 
     * @param param	p[^l
     * @return		ڃxNg
     */
    public JgclVector3D tangentVector(double param) {
	JgclAxis2Placement3D ax = position();
	JgclVector3D x1 = ax.x().multiply(2 * param * focalDist);
	JgclVector3D y1 = ax.y().multiply(2 * focalDist);

	return x1.add(y1);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̋ȗԂB
     * 
     * @param param	p[^l
     * @return		ȗ
     */
    public JgclCurveCurvature3D curvature(double param) {
	JgclAxis2Placement3D ax = position();
	double x1len = 2 * param * focalDist;
	double y1len = 2 * focalDist;
	double x2len = 2 * focalDist;
	double tlen = Math.sqrt(x1len * x1len + y1len * y1len);
	double crv = Math.abs(y1len * x2len) / (tlen * tlen * tlen);
	JgclVector3D ex1 = ax.x().multiply(x1len);
	JgclVector3D ey1 = ax.y().multiply(y1len);

	JgclVector3D tangent = ex1.add(ey1);
	// rotate tangent PI/2 around Z axis
	JgclVector3D nrmDir = tangent.crossProduct(ax.z());
	return new JgclCurveCurvature3D(crv, nrmDir.unitized());
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̓֐ԂB
     * 
     * @param param	p[^l
     * @return		֐
     */
    public JgclCurveDerivative3D evaluation(double param) {
	JgclAxis2Placement3D ax = position();
	JgclVector3D ex = ax.x().multiply(param * param * focalDist);
	JgclVector3D ey = ax.y().multiply(2 * param * focalDist);
	JgclVector3D ex1 = ax.x().multiply(2 * param * focalDist);
	JgclVector3D ey1 = ax.y().multiply(2 * focalDist);
	JgclVector3D ex2 = ax.x().multiply(2 * focalDist);

	JgclPoint3D d0 = ax.location().add(ex.add(ey));
	JgclVector3D d1 = ex1.add(ey1);
	JgclVector3D zero = JgclVector3D.zeroVector;

	return new JgclCurveDerivative3D(d0, d1, ex2, zero);
    }

    /**
     * ^ꂽp[^ԂɂāA
     * Ԃ̗[Ԍłꂽ_̃p[^l߂B
     * <p>
     * ̃\bh
     * {@link JgclConic3D#toPolyline(JgclParameterSection, JgclToleranceForDistance) 
     * JgclConic3D.toPolyline(JgclParameterSection, JgclToleranceForDistance)}
     * ̓ŌĂяoB
     * </p>
     * 
     * @param left	[ (ԉ) ̃p[^l
     * @param right	E[ (ԏ) ̃p[^l
     * @return		łꂽ_̃p[^l
     */
    double getPeak(double left, double right) {
	return ((left + right) / 2.0);
    }

    /**
     * ̋Ȑ̎w̋ԂČLxWGȐ̗ԂB
     * <p>
     * ̏ꍇALxWGȐ̗vf͏ 1 ł
     * </p>
     *
     * @param pint	Čp[^
     * @return		̋Ȑ̎w̋ԂČLxWGȐ̔z
     */
    public JgclPureBezierCurve3D[] toPolyBezierCurves(JgclParameterSection pint) {
	JgclParabola2D this2D =
	    (JgclParabola2D)this.toLocal2D(JgclAxis2Placement2D.origin);
	JgclPureBezierCurve2D[] bzcs2D = this2D.toPolyBezierCurves(pint);
	return this.transformPolyBezierCurvesInLocal2DToGrobal3D(bzcs2D);
    }

    /**
     * ̋Ȑ̎w̋ԂČLaXvCȐԂB
     * 
     * @param pint	Čp[^
     * @return		̋Ȑ̎w̋ԂČLaXvCȐ
     */
    public JgclBsplineCurve3D toBsplineCurve(JgclParameterSection pint) {
	JgclPureBezierCurve3D[] bzcs = this.toPolyBezierCurves(pint);
	return bzcs[0].toBsplineCurve();
    }

    /**
     * ̋ȐƑ̋ȐƂ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ̂ƂɁA
     * ݐݒ肳Ă鉉Z̉ŁA
     * ꕽʏɂA
     * ̒_Ԃ̋̋e덷菬A
     * ̋Ǐ X ̂Ȃpxpx̋e덷菬A
     * ̒_|œ_ԋ̍̋e덷ȓłꍇɂ́A
     * ̓I[o[bvĂ̂ƂāA
     * JgclIndefiniteSolution ̗O𔭐B
     * </p>
     *
     * @param mate	̋Ȑ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution mate ŁA̓I[o[bvĂAsł
     */
    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate)
	 throws JgclIndefiniteSolution
    {
	return mate.intersect(this, true);
    }

    /**
     * ̕ (\ꂽ) RȐ̌_\㐔𐶐B
     * 
     * @param poly	xWGȐ邢͂aXvCȐ̂ZOg̑\̔z
     * @return		̕ poly ̌_\㐔̍
     */
    JgclRealPolynomial makePoly(JgclRealPolynomial[] poly) {
	JgclRealPolynomial yPoly = poly[1].multiply(poly[1]);
	double dA4fd = 4.0 * focalDist();
	boolean isPoly = poly.length < 4;
	int degree = yPoly.degree();
	double[] coef = new double[degree + 1];

	if (isPoly) {
	    int deg = poly[1].degree();
	    for (int j = 0; j <= degree; j++)
		if (j > (degree - deg))
		    coef[j] = yPoly.coefficientAt(j);
		else
		    coef[j] = yPoly.coefficientAt(j) -
			(dA4fd * poly[0].coefficientAt(j));
	}
	else {
	    JgclRealPolynomial xwPoly = poly[0].multiply(poly[3]);
	    for (int j = 0; j <= degree; j++)
		coef[j] = yPoly.coefficientAt(j) - (dA4fd * xwPoly.coefficientAt(j));
	}
	return new JgclRealPolynomial(coef);
    }

    /**
     * ^ꂽ_̋Ȑɂ邩ۂ`FbNB
     * 
     * @param point	ΏۂƂȂ_
     * @return		^ꂽ_̋Ȑɂ trueAłȂ false
     */
    boolean checkSolution(JgclPoint3D point) {
	double param = getParameter(point);
	double px = focalDist() * param * param;
	double py = 2.0 * focalDist() * param;

	return point.identical(new JgclCartesianPoint3D(px, py, 0.0));
	//return Math.abs(point.z()) < getToleranceForDistance();
    }

    /**
     * ^ꂽ_̋Ȑɂ̂ƂāA
     * ̓_̋Ȑł̃p[^l߂B
     * 
     * @param point	ΏۂƂȂ_
     * @return		p[^l
     */
    double getParameter(JgclPoint3D point) {
	return point.y() / (2.0 * focalDist());
    }

    /**
     * ̋ȐƑ̋Ȑ (~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclConic3D#intersectCnc(JgclConic3D, boolean)
     * JgclConic3D.intersectCnc(JgclConic3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclCircle3D mate, boolean doExchange) {
	try {
	    return intersectCnc(mate, doExchange);
	} catch (JgclIndefiniteSolution e) {
	    throw new JgclFatal();	// Never be occured
	}
    }

    /**
     * ̋ȐƑ̋Ȑ (ȉ~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclConic3D#intersectCnc(JgclConic3D, boolean)
     * JgclConic3D.intersectCnc(JgclConic3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (ȉ~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclEllipse3D  mate, boolean doExchange) {
	try {
	    return intersectCnc(mate, doExchange);
	} catch (JgclIndefiniteSolution e) {
	    throw new JgclFatal();	// Never be occured
	}
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclConic3D#intersectCnc(JgclConic3D, boolean)
     * JgclConic3D.intersectCnc(JgclConic3D, boolean)}
     * ōsȂĂB
     * </p>
     * <p>
     * ݐݒ肳Ă鉉Z̉ŁA
     * ꕽʏɂA
     * ̒_Ԃ̋̋e덷菬A
     * ̋Ǐ X ̂Ȃpxpx̋e덷菬A
     * ̒_|œ_ԋ̍̋e덷ȓłꍇɂ́A
     * ̓I[o[bvĂ̂ƂāA
     * JgclIndefiniteSolution ̗O𔭐B
     * </p>
     * 
     * @param mate      ̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution ̓I[o[bvĂAsł
     */
    JgclIntersectionPoint3D[] intersect(JgclParabola3D mate, boolean doExchange)
	 throws JgclIndefiniteSolution
    {
	return intersectCnc(mate, doExchange);
     }

    /**
     * ̋ȐƑ̋Ȑ (oȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclConic3D#intersectCnc(JgclConic3D, boolean)
     * JgclConic3D.intersectCnc(JgclConic3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (oȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclHyperbola3D mate, boolean doExchange) {
	try {
	    return intersectCnc(mate, doExchange);
	} catch (JgclIndefiniteSolution e) {
	    throw new JgclFatal();	// Never be occured
	}
    }

    /**
     * ̋ȐƑ̋Ȑ (|C) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * |C̃NX́u|C vs. v̌_Z\bh
     * {@link JgclPolyline3D#intersect(JgclParabola3D, boolean)
     * JgclPolyline3D.intersect(JgclParabola3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (|C)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclPolyline3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (gȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * gȐ̃NX́ugȐ vs. v̌_Z\bh
     * {@link JgclTrimmedCurve3D#intersect(JgclParabola3D, boolean)
     * JgclTrimmedCurve3D.intersect(JgclParabola3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (gȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclTrimmedCurve3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (ȐZOg) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȐZOg̃NX́uȐZOg vs. v̌_Z\bh
     * {@link JgclCompositeCurveSegment3D#intersect(JgclParabola3D, boolean)
     * JgclCompositeCurveSegment3D.intersect(JgclParabola3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (ȐZOg)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclCompositeCurveSegment3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (Ȑ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȐNX́uȐ vs. v̌_Z\bh
     * {@link JgclCompositeCurve3D#intersect(JgclParabola3D, boolean)
     * JgclCompositeCurve3D.intersect(JgclParabola3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (Ȑ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclCompositeCurve3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐA^ꂽxNgɏ]ĕsړȐԂB
     *
     * @param moveVec	sړ̕Ɨʂ\xNg
     * @return		sړ̋Ȑ
     */
    public JgclParametricCurve3D parallelTranslate(JgclVector3D moveVec) {
	return new JgclParabola3D(position().parallelTranslate(moveVec), focalDist);
    }

    /**
     * ̋Ȑ̃p[^`ԂB
     * <p>
     * ŔIȃp[^`ԂB
     * </p>
     * 
     * @return	ŔIȃp[^`
     */
    JgclParameterDomain getParameterDomain() {
	return new JgclParameterDomain();
    }

    /**
     * ̋Ȑ􉽓IɕĂ邩ۂԂB
     * <p>
     * Ȃ̂ŁA false ԂB
     * </p>
     *
     * @return	͕邱Ƃ͂Ȃ̂ŁA <code>false</code>
     */
    boolean getClosedFlag() {
	return false;
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricCurve3D#PARABOLA_3D JgclParametricCurve3D.PARABOLA_3D}
     */
    int type() {
	return PARABOLA_3D;
    }

    /**
     * ̋ȐA^ꂽǏWn Z ̎ɁA
     * ^ꂽpx]ȐԂB
     *
     * @param trns	ǏWn瓾ꂽWϊZq
     * @param rCos	cos(]px)
     * @param rSin	sin(]px)
     * @return		]̋Ȑ
     */
    JgclParametricCurve3D rotateZ(JgclCartesianTransformationOperator3D trns,
				  double rCos, double rSin) {
	JgclAxis2Placement3D rpos = position().rotateZ(trns, rCos, rSin);
	return new JgclParabola3D(rpos, focalDist());
    }

    /**
     * ̋Ȑ̓_ŁA^ꂽɂȂ_ԂB
     *
     * @param line	
     * @return		^ꂽɂȂ_
     */
    JgclPoint3D getPointNotOnLine(JgclLine3D line) {
	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double dTol2 = condition.getToleranceForDistance2();

	double start = 0.0, increase = 1.0;
	int itry = 0, limit = 100;
	JgclPoint3D point;
	JgclVector3D vector;

	/*
	 * Get a point which is not on the line, then verify that
	 * the distance between a point and the line is greater
	 * than the tolerance.
	 */
	do {
	    if (itry > limit) {
		throw new JgclFatal();	// should never be occurred
	    }
	    point = this.coordinates(start + (increase * itry));
	    vector = point.subtract(line.project1From(point));
	    itry ++;
	} while(point.isOn(line) || vector.norm() < dTol2);

	return point;
    }

    /**
     * ̋ȐƁAꂽxWGȖʂƂ̊𒲂ׂB
     * <p>
     * ̃\bh {@link JgclIntsCncBzs3D JgclIntsCncBzs3D} ̓ŎgB
     * </p>
     *
     * @param bi	ꂽxWGȖʂ̏
     * @return	Ă trueAłȂ false
     */
    boolean checkInterfere(JgclIntsCncBzs3D.BezierSurfaceInfo bi) {
	double dTol = getToleranceForDistance();
	if (!((bi.box.min().z() < -dTol) && (bi.box.max().z() > dTol))) 
	    return false; /* no interference */

	if (bi.box.max().x() < -dTol)
	    return false; /* no interference */

	boolean all_in = true;
	boolean all_out = true;

	JgclPoint2D point = null;
	for (int i = 0; i < 4; i++) {
	    switch (i) {
	    case 0:
		point = new JgclCartesianPoint2D(bi.box.min().x(), bi.box.min().y());
		break;
	    case 1:
		point = new JgclCartesianPoint2D(bi.box.max().x(), bi.box.min().y());
		break;
	    case 2:
		point = new JgclCartesianPoint2D(bi.box.max().x(), bi.box.max().y());
		break;
	    case 3:
		point = new JgclCartesianPoint2D(bi.box.min().x(), bi.box.max().y());
		break;
	    }
	    double epara = point.y() / (2.0 * this.focalDist());
	    double ex = this.focalDist() * epara * epara;
	    ex = point.x() - ex;

	    if (ex < -dTol)
		all_in = false;
	    else if (ex > dTol)
		all_out = false;
	    else {
		all_out = false;
		all_in = false;
	    }
	}

	if (all_in == true)
	    return false; /* no interfere */

	else if (all_out == true) {
	    return ((bi.box.min().y() * bi.box.max().y()) > 0.0)
		? false /* no interfere */
		: true; /* interfere */
	}
	else
	    return true;
    }

    /**
     * ̉~ȐƗ^ꂽʂ̌_߂B
     * <p>
     * ̃\bh {@link JgclIntsCncBzs3D JgclIntsCncBzs3D} ̓ŎgB
     * </p>
     *
     * @param plane  
     * @return       _̔z
     */
    JgclIntersectionPoint3D[] intersectConicPlane(JgclPlane3D plane) {
	JgclAxis2Placement3D position =
	    new JgclAxis2Placement3D(JgclPoint3D.origin, null, null);
	JgclParabola3D parabola = new JgclParabola3D(position,
						     this.focalDist());
	try {
	    return parabola.intersect(plane);
	}
	catch (JgclIndefiniteSolution e) {
	    throw new JgclFatal();
	}
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł (̉~Ȑ̋ǏWnł) Wl
     * ԂB
     * 
     * @param parameter	p[^l
     * @return	̉~Ȑ̋ǏWnł̍Wl
     */
    JgclPoint3D nlFunc(double parameter) {
	double y = this.focalDist() * parameter;
	double x = y * parameter;
	y = 2.0 * y;
	double z = 0.0;

	return new JgclCartesianPoint3D(x, y, z);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł (̉~Ȑ̋ǏWnł) ڃxNg
     * ԂB
     * 
     * @param parameter	p[^l
     * @return	̉~Ȑ̋ǏWnł̐ڃxNg
     */
    JgclVector3D dnlFunc(double parameter) {
	double y = 2.0 * this.focalDist();
	double x = y * parameter;
	double z = 0.0;

	return new JgclLiteralVector3D(x, y, z);
    }

    /**
     * ̋ȐA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricCurve3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclAxis2Placement3D tPosition =
	    this.position().transformBy(reverseTransform,
					transformationOperator,
					transformedGeometries);
	double tFocalDist;
	if (reverseTransform != true)
	    tFocalDist = transformationOperator.transform(this.focalDist());
	else
	    tFocalDist = transformationOperator.reverseTransform(this.focalDist());
	return new JgclParabola3D(tPosition, tFocalDist);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tposition");
        position().output(writer, indent + 2);
        writer.println(indent_tab + "\tfocalDist " + focalDist);
        writer.println(indent_tab + "End");
    }
}
