/*
 * Q : \NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclParabola2D.java,v 1.60 2000/08/11 06:18:54 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;

/**
 * Q : \NXB
 * <p>
 * ́A̒_̈ʒuƋǏ X/Y ̕ǏWn
 * (zuA{@link JgclAxis2Placement2D JgclAxis2Placement2D}) position 
 * _œ_܂ł̋ focalDist
 * Œ`B
 * </p>
 * <p>
 * t p[^Ƃ P(t) ̃pgbN\́Aȉ̒ʂB
 * <pre>
 *	P(t) = position.location() + focalDist * (t * t * position.x() + 2 * t * position.y())
 * </pre>
 * </p>
 *
 * @version $Revision: 1.60 $, $Date: 2000/08/11 06:18:54 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclParabola2D extends JgclConic2D {

    /**
     * _œ_܂ł̋B
     * @serial
     */
    private double focalDist;

    /**
     * _œ_܂ł̋AێtB[hɐݒ肷B
     * <p>
     * focalDist ̒l͐łȂ΂ȂȂB
     * </p>
     * <p>
     * focalDist ̒l
     * ݐݒ肳Ă鉉Z̋̋e덷菬ꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     *
     * @param focalDist	_œ_܂ł̋
     * @see	JgclInvalidArgumentValue
     */
    private void setFocalDist(double focalDist)
    {
	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double dTol = condition.getToleranceForDistance();

	if (focalDist < dTol) {
	    throw new JgclInvalidArgumentValue();
	}
	this.focalDist = focalDist;
    }

    /**
     * ǏWnƒ_œ_܂ł̋^ăIuWFNg\zB
     * <p>
     * position  null ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * focalDist ̒l
     * ݐݒ肳Ă鉉Z̋̋e덷菬ꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     * 
     * @param position	SƋǏ X/Y ̕ǏWn
     * @param focalDist	_œ_܂ł̋
     * @see	JgclInvalidArgumentValue
     */
    public JgclParabola2D(JgclAxis2Placement2D position, double focalDist)
    {
	super(position);
	setFocalDist(focalDist);
    }

    /**
     * ̒̕_œ_܂ł̋ԂB
     * 
     * @return	_œ_܂ł̋
     */
    public double focalDist() {
	return this.focalDist;
    }

    /**
     * ^ꂽp[^Ԃɂ邱̋Ȑ̎ԏł̒ (̂) ԂB
     * <p>
     * pint ̑l͕ł܂ȂB
     * </p>
     * 
     * @param pint	Ȑ̒߂p[^
     * @return	w肳ꂽp[^ԂɂȐ̒
     */
    public double length(JgclParameterSection pint) {
        final double m2pbl_2fcldst = 2.0 * focalDist();
        double dTol = getToleranceForDistance() / 2.0;
        
        return JgclMath.getDefiniteIntegral
            (new JgclRealFunctionWithOneVariable(){
                    public double evaluate(double parameter){
                        return m2pbl_2fcldst * Math.sqrt(parameter * parameter
                                                         + 1.0);
                    }
                },
             pint, dTol);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̍WlԂB
     * 
     * @param param	p[^l
     * @return		Wl
     */
    public JgclPoint2D coordinates(double param) {
	JgclAxis2Placement2D ax = position();
	JgclVector2D x = ax.x().multiply(param * param * focalDist);
	JgclVector2D y = ax.y().multiply(2 * param * focalDist);

	return ax.location().add(x.add(y));
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̐ڃxNgԂB
     * 
     * @param param	p[^l
     * @return		ڃxNg
     */
    public JgclVector2D tangentVector(double param) {
	JgclAxis2Placement2D ax = position();
	JgclVector2D x1 = ax.x().multiply(2 * param * focalDist);
	JgclVector2D y1 = ax.y().multiply(2 * focalDist);

	return x1.add(y1);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̋ȗԂB
     * 
     * @param param	p[^l
     * @return		ȗ
     */
    public JgclCurveCurvature2D curvature(double param) {
	JgclAxis2Placement2D ax = position();
	double x1len = 2 * param * focalDist;
	double y1len = 2 * focalDist;
	double x2len = 2 * focalDist;
	double tlen = Math.sqrt(x1len * x1len + y1len * y1len);
	double crv = Math.abs(y1len * x2len) / (tlen * tlen * tlen);
	JgclVector2D ex1 = ax.x().multiply(x1len);
	JgclVector2D ey1 = ax.y().multiply(y1len);

	JgclVector2D tangent = ex1.add(ey1);
	// rotate tangent PI/2
	JgclVector2D nrmDir =
	    new JgclLiteralVector2D(tangent.y(), -tangent.x());
	return new JgclCurveCurvature2D(crv, nrmDir.unitized());
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̓֐ԂB
     * 
     * @param param	p[^l
     * @return		֐
     */
    public JgclCurveDerivative2D evaluation(double param) {
	JgclAxis2Placement2D ax = position();
	JgclVector2D ex = ax.x().multiply(param * param * focalDist);
	JgclVector2D ey = ax.y().multiply(2 * param * focalDist);
	JgclVector2D ex1 = ax.x().multiply(2 * param * focalDist);
	JgclVector2D ey1 = ax.y().multiply(2 * focalDist);
	JgclVector2D ex2 = ax.x().multiply(2 * focalDist);

	JgclPoint2D d0 = ax.location().add(ex.add(ey));
	JgclVector2D d1 = ex1.add(ey1);

	return new JgclCurveDerivative2D(d0, d1, ex2);
    }

    /**
     * ^ꂽ_炱̋Ȑւ̓e_߂B
     * <p>
     * []
     * <br>
     * Ȏ㐔̍߂邱ƂɋAāA㐔IɉĂB
     * </p>
     * 
     * @param point	e̓_
     * @return		e_
     */
    public JgclPointOnCurve2D[] projectFrom(JgclPoint2D point)
    {
	double dTol2 = getToleranceForDistance2();

	/*
	 * NOTE:
	 * equation of normal line
	 *
	 *	A * T3 + 0 * T2 + ( 2 * A - Px ) * T - Py = 0
	 *		( A = dB->focal_dist, Px,Py = dApnt, T = parameter )
	 *
	 * distinction
	 *	A3 ** 2 / 4 + A2 ** 3 / 27   <  0  --> 3 points
	 *                                   =  0  --> 1 point
	 *                                   >  0  --> 1 point
	 */

	JgclCartesianTransformationOperator2D trans;

	try {
	    trans = new JgclCartesianTransformationOperator2D(position(), 1.0);
	}
	catch (JgclInvalidArgumentValue e) {
	    throw new JgclFatal();
	}
	// vector from B's center to A
	JgclVector2D Bc2A = point.subtract(position().location());

	// inverse rotated point
	JgclVector2D eAir = trans.reverseTransform(Bc2A);

	JgclComplex[] root;

	// coefficients of polynomial (real)
	double[] ercoef = new double[4];

	// make polynomial
	ercoef[3] = focalDist;
	ercoef[2] = 0.0;
	ercoef[1] = 2.0 * focalDist - eAir.x();
	ercoef[0] = (- eAir.y());


	// distinction

	if (ercoef[1]*ercoef[1] < dTol2 && ercoef[0]*ercoef[0] < dTol2) {
	    root = new JgclComplex[1];
	    root[0] = new JgclComplex(0.0);
	}
	else {

	    JgclComplexPolynomial pol;
	    try {
		pol = new JgclComplexPolynomial(ercoef);
	    }
	    catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }

	    try {
		root = pol.getRootsByDKA();
	    }
	    catch (JgclComplexPolynomial.DKANotConverge e) {
		root = e.getValues();
	    }
	    catch (JgclComplexPolynomial.ImpossibleEquation e) {
		throw new JgclFatal();
	    }
	    catch (JgclComplexPolynomial.IndefiniteEquation e) {
		throw new JgclFatal();
	    }
	}

	JgclPointOnGeometryList projList = new JgclPointOnGeometryList();

	for (int i = 0; i < root.length; i++) {
	    JgclPointOnCurve2D proj;

	    double epara = root[i].real();

	    proj = checkProjection(epara, point, dTol2);
	    if (proj != null)
		projList.addPoint(proj);
	}
	return projList.toJgclPointOnCurve2DArray();
    }

    /**
     * ^ꂽp[^ԂɂāA
     * Ԃ̗[Ԍłꂽ_̃p[^l߂B
     * <p>
     * ̃\bh
     * {@link JgclConic2D#toPolyline(JgclParameterSection, JgclToleranceForDistance) 
     * JgclConic2D.toPolyline(JgclParameterSection, JgclToleranceForDistance)}
     * ̓ŌĂяoB
     * </p>
     * 
     * @param left	[ (ԉ) ̃p[^l
     * @param right	E[ (ԏ) ̃p[^l
     * @return		łꂽ_̃p[^l
     */
    double getPeak(double left, double right) {
	return ((left + right) / 2.0);
    }

    /**
     * ̋Ȑ̎w̋ԂČLxWGȐ̗ԂB
     * <p>
     * ̏ꍇALxWGȐ̗vf͏ 1 ł
     * </p>
     *
     * @param pint	Čp[^
     * @return		̋Ȑ̎w̋ԂČLxWGȐ̔z
     */
    public JgclPureBezierCurve2D[] toPolyBezierCurves(JgclParameterSection pint) {
	double[] weights = {1.0, 1.0, 1.0};
	JgclPureBezierCurve2D[] bzcs = {
	    new JgclPureBezierCurve2D(this.getControlPointsOfBezierCurve(pint),
				      weights)};
	return bzcs;
    }

    /**
     * ̋Ȑ̎w̋ԂČLaXvCȐԂB
     * 
     * @param pint	Čp[^
     * @return		̋Ȑ̎w̋ԂČLaXvCȐ
     */
    public JgclBsplineCurve2D toBsplineCurve(JgclParameterSection pint) {
	JgclPureBezierCurve2D[] bzcs = this.toPolyBezierCurves(pint);
	return bzcs[0].toBsplineCurve();
    }

    /**
     * ̋ȐƑ̋ȐƂ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ̂ƂɁA
     * ݐݒ肳Ă鉉Z̉ŁA
     * ̒_Ԃ̋̋e덷菬A
     * ̋Ǐ X ̂Ȃpxpx̋e덷菬A
     * ̒_|œ_ԋ̍̋e덷ȓłꍇɂ́A
     * ̓I[o[bvĂ̂ƂāA
     * JgclIndefiniteSolution ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution mate ŁA̓I[o[bvĂAsł
     */
    public JgclIntersectionPoint2D[] intersect(JgclParametricCurve2D mate)
	 throws JgclIndefiniteSolution
    {
	return mate.intersect(this, true);
    }

    /**
     * ̕ (\ꂽ) RȐ̌_\㐔𐶐B
     * 
     * @param poly	xWGȐ邢͂aXvCȐ̂ZOg̑\̔z
     * @return		̕ poly ̌_\㐔̍
     */
    JgclRealPolynomial makePoly(JgclRealPolynomial[] poly) {
	JgclRealPolynomial yPoly = poly[1].multiply(poly[1]);
	double dA4fd = 4.0 * focalDist();
	boolean isPoly = poly.length < 3;	
	int degree = yPoly.degree();
	double[] coef = new double[degree + 1];

	if (isPoly) {
	    int deg = poly[1].degree();
	    for (int j = 0; j <= degree; j++)
		if (j > (degree - deg))
		    coef[j] = yPoly.coefficientAt(j);
		else
		    coef[j] = yPoly.coefficientAt(j) -
			(dA4fd * poly[0].coefficientAt(j));
	}
	else {
	    JgclRealPolynomial xwPoly = poly[0].multiply(poly[2]);
	    for (int j = 0; j <= degree; j++)
		coef[j] = yPoly.coefficientAt(j) - (dA4fd * xwPoly.coefficientAt(j));
	}
	return new JgclRealPolynomial(coef);
    }

    /**
     * ^ꂽ_̋Ȑɂ邩ۂ`FbNB
     * 
     * @param point	ΏۂƂȂ_
     * @return		^ꂽ_̋Ȑɂ trueAłȂ false
     */
    boolean checkSolution(JgclPoint2D point) {
	double param = getParameter(point);
	double px = focalDist() * param * param;
	double py = 2.0 * focalDist() * param;

	return point.identical(new JgclCartesianPoint2D(px, py));
    }

    /**
     * ^ꂽ_̋Ȑɂ̂ƂāA
     * ̓_̋Ȑł̃p[^l߂B
     * 
     * @param point	ΏۂƂȂ_
     * @return		p[^l
     */
    double getParameter(JgclPoint2D point) {
	return point.y() / (2.0 * focalDist());
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link JgclIntsLinCnc2D#intersection(JgclLine2D, JgclParabola2D, boolean)
     * JgclIntsLinCnc2D.intersection}(mate, this, !doExchange)
     * ōsȂĂB
     * </p>
     *
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclLine2D mate, boolean doExchange) {
	JgclIntsLinCnc2D doObj = new JgclIntsLinCnc2D(mate, this);
	return doObj.intersection(mate, this, !doExchange);
     }

    /**
     * ̋ȐƑ̋Ȑ (~) ̌_߂
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ~̃NX́u~ vs. v̌_Z\bh
     * {@link JgclCircle2D#intersect(JgclParabola2D, boolean)
     * JgclCircle2D.intersect(JgclParabola2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclCircle2D  mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (ȉ~) ̌_߂
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȉ~̃NX́uȉ~ vs. v̌_Z\bh
     * {@link JgclEllipse2D#intersect(JgclParabola2D, boolean)
     * JgclEllipse2D.intersect(JgclParabola2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (ȉ~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclEllipse2D  mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ݐݒ肳Ă鉉Z̉ŁA
     * ̒_Ԃ̋̋e덷菬A
     * ̋Ǐ X ̂Ȃpxpx̋e덷菬A
     * ̒_|œ_ԋ̍̋e덷ȓłꍇɂ́A
     * ̓I[o[bvĂ̂ƂāA
     * JgclIndefiniteSolution ̗O𔭐B
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link JgclIntsParCnc2D#intersection(JgclParabola2D, JgclParabola2D, boolean)
     * JgclIntsParCnc2D.intersection}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution ̓I[o[bvĂAsł
     */
    JgclIntersectionPoint2D[] intersect(JgclParabola2D  mate, boolean doExchange)
	 throws JgclIndefiniteSolution
    {
        if ((this.position().location().identical(mate.position().location())) &&
	    (this.position().x().identicalDirection(mate.position().x()))) {
	    double d_tol = getToleranceForDistance();
	    if (Math.abs(this.focalDist() - mate.focalDist()) <= d_tol) {
		JgclIntersectionPoint2D one_sol;
		if (!doExchange)
		    one_sol = new JgclIntersectionPoint2D(this, 0.0, mate, 0.0, doCheckDebug);
		else
		    one_sol = new JgclIntersectionPoint2D(mate, 0.0, this, 0.0, doCheckDebug);
		throw new JgclIndefiniteSolution(one_sol);
	    }
	}
	JgclIntsParCnc2D doObj = new JgclIntsParCnc2D();
	return doObj.intersection(this, mate, doExchange);
     }

    /**
     * ̋ȐƑ̋Ȑ (oȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link JgclIntsParCnc2D#intersection(JgclParabola2D, JgclHyperbola2D, boolean)
     * JgclIntsParCnc2D.intersection}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (oȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclHyperbola2D  mate, boolean doExchange) {
	JgclIntsParCnc2D doObj = new JgclIntsParCnc2D();
	return doObj.intersection(this, mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (|C) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * |C̃NX́u|C vs. v̌_Z\bh
     * {@link JgclPolyline2D#intersect(JgclParabola2D, boolean)
     * JgclPolyline2D.intersect(JgclParabola2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (|C)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclPolyline2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (gȐ) Ƃ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * gȐ̃NX́ugȐ vs. v̌_Z\bh
     * {@link JgclTrimmedCurve2D#intersect(JgclParabola2D, boolean)
     * JgclTrimmedCurve2D.intersect(JgclParabola2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (gȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclTrimmedCurve2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (ȐZOg) Ƃ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȐZOg̃NX́uȐZOg vs. v̌_Z\bh
     * {@link JgclCompositeCurveSegment2D#intersect(JgclParabola2D, boolean)
     * JgclCompositeCurveSegment2D.intersect(JgclParabola2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (ȐZOg)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclCompositeCurveSegment2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (Ȑ) Ƃ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * Ȑ̃NX́uȐ vs. v̌_Z\bh
     * {@link JgclCompositeCurve2D#intersect(JgclParabola2D, boolean)
     * JgclCompositeCurve2D.intersect(JgclParabola2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (Ȑ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclCompositeCurve2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋Ȑ̎w̋ԂItZbgȐA
     * ^ꂽ덷ŋߎ Bspline Ȑ߂B
     * 
     * @param pint	ItZbgp[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.LEFT/RIGHT)
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ̃ItZbgȐߎ Bspline Ȑ
     * @see	JgclWhichSide
     */
    public JgclBsplineCurve2D
	offsetByBsplineCurve(JgclParameterSection pint,
			     double magni,
                             int side,
                             JgclToleranceForDistance tol) {
	JgclOfst2D doObj = new JgclOfst2D(this,pint,magni,side,tol);
	return doObj.offset();
    }

    /**
     * ̋ȐƑ̋ȐƂ̋ʐڐ߂B
     * <p>
     * ʐڐ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * _ł͎ĂȂ߁A
     * JgclNotSupported	̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		ʐڐ̔z
     * @exception	JgclNotSupported	܂̂ƂAȂ@\ł
     */
    public JgclCommonTangent2D[] commonTangent(JgclParametricCurve2D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋ȐƂ̋ʖ@߂B
     * <p>
     * ʖ@݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * _ł͎ĂȂ߁A
     * JgclNotSupported	̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		ʖ@̔z
     * @exception	JgclNotSupported	܂̂ƂAȂ@\ł
     */
    public JgclCommonNormal2D[]	commonNormal(JgclParametricCurve2D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̋Ȑ̃p[^`ԂB
     * <p>
     * ŔIȃp[^`ԂB
     * </p>
     * 
     * @return	ŔIȃp[^`
     */
    JgclParameterDomain getParameterDomain() {
	return new JgclParameterDomain();
    }

    /**
     * ̋Ȑ􉽓IɕĂ邩ۂԂB
     * <p>
     * Ȃ̂ŁA false ԂB
     * </p>
     *
     * @return	͕邱Ƃ͂Ȃ̂ŁA <code>false</code>
     */
    boolean getClosedFlag() {
	return false;
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricCurve2D#PARABOLA_2D JgclParametricCurve2D.PARABOLA_2D}
     */
    int type() {
	return PARABOLA_2D;
    }

    /**
     * ̋ȐA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricCurve2D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator2D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclAxis2Placement2D tPosition =
	    this.position().transformBy(reverseTransform,
					transformationOperator,
					transformedGeometries);
	double tFocalDist;
	if (reverseTransform != true)
	    tFocalDist = transformationOperator.transform(this.focalDist());
	else
	    tFocalDist = transformationOperator.reverseTransform(this.focalDist());
	return new JgclParabola2D(tPosition, tFocalDist);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tposition");
        position().output(writer, indent + 2);
        writer.println(indent_tab + "\tfocalDist " + focalDist);
        writer.println(indent_tab + "End");
    }
}
