/*
 * Q : Ȑ () I[o[bvĂԂ\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclOverlapCurve2D.java,v 1.16 2000/04/26 09:39:10 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * Q : Ȑ () I[o[bvĂԂ\NXB
 * <p>
 * ̃NX̃CX^X́A
 * Ȑ̃I[o[bv
 * ̋Ȑɂp[^͈͂\gȐ trc1
 * 
 * ̋Ȑɂp[^͈͂\gȐ trc2
 * ێB
 * </p>
 * <p>
 * ȂA
 * trc1  trc2 ۂɓOՂǂ́A
 * ̃NX̓ł͊֒mȂB
 * </p>
 *
 * @version $Revision: 1.16 $, $Date: 2000/04/26 09:39:10 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclOverlapCurve2D extends JgclNonParametricCurve2D implements JgclCurveCurveInterference2D {
    /**
     * ̋Ȑ (Ȑ1) I[o[bvԂŃg~OȐ
     * @serial
     */
    private JgclTrimmedCurve2D trc1;

    /**
     * ̋Ȑ (Ȑ2) I[o[bvԂŃg~OȐ
     * @serial
     */
    private JgclTrimmedCurve2D trc2;

    /**
     * ȐI[o[bvԂ̎w肹ɃIuWFNg\zB
     */
    private JgclOverlapCurve2D() {
	trc1 = null;
	trc2 = null;
    }

    /**
     * ̃gȐ^ăIuWFNg\zB
     * <p>
     * doCheck ̒l͎QƂȂB
     * </p>
     *
     * @param trc1	̋Ȑ (Ȑ1) I[o[bvԂŃg~OȐ
     * @param trc2	̋Ȑ (Ȑ2) I[o[bvԂŃg~OȐ
     * @param doCheck	̃`FbN邩ǂ̃tO
     */
    JgclOverlapCurve2D(JgclTrimmedCurve2D trc1,
		       JgclTrimmedCurve2D trc2,
		       boolean doCheck) {
	super();
	this.trc1 = trc1;
	this.trc2 = trc2;
    }

    /**
     * ̋ȐƁAI[o[bvԂ̂ꂼ̋Ȑł̃p[^͈͂^ăIuWFNg\zB
     * <p>
     * doCheck ̒l͎QƂȂB
     * </p>
     *
     * @param curve1	̋Ȑ (Ȑ1)
     * @param section1	I[o[bvԂ̋Ȑ1 ł̃p[^
     * @param curve2	̋Ȑ (Ȑ2)
     * @param section2	I[o[bvԂ̋Ȑ2 ł̃p[^
     * @param doCheck	̃`FbN邩ǂ̃tO
     */
    JgclOverlapCurve2D(JgclParametricCurve2D curve1,
		       JgclParameterSection section1,
		       JgclParametricCurve2D curve2,
		       JgclParameterSection section2,
		       boolean doCheck) {
	super();
	this.trc1 = new JgclTrimmedCurve2D(curve1, section1);
	this.trc2 = new JgclTrimmedCurve2D(curve2, section2);
    }

    /**
     * ̋ȐƁAI[o[bvԂ̂ꂼ̋Ȑł̃p[^͈͂^ăIuWFNg\zB
     * <p>
     * doCheck ̒l͎QƂȂB
     * </p>
     *
     * @param curve1	̋Ȑ (Ȑ1)
     * @param start1	I[o[bvԂ̋Ȑ1 ł̃p[^Ԃ̊Jnl
     * @param inc1	I[o[bvԂ̋Ȑ1 ł̃p[^Ԃ̑l
     * @param curve2	̋Ȑ (Ȑ2)
     * @param start2	I[o[bvԂ̋Ȑ2 ł̃p[^Ԃ̊Jnl
     * @param inc2	I[o[bvԂ̋Ȑ2 ł̃p[^Ԃ̑l
     * @param doCheck	̃`FbN邩ǂ̃tO
     */
    public JgclOverlapCurve2D(JgclParametricCurve2D curve1,
			      double start1, double inc1,
			      JgclParametricCurve2D curve2,
			      double start2, double inc2,
			      boolean doCheck) {
	super();
	this.trc1 = new JgclTrimmedCurve2D(curve1, new JgclParameterSection(start1, inc1));
	this.trc2 = new JgclTrimmedCurve2D(curve2, new JgclParameterSection(start2, inc2));
    }

    /**
     * ̃I[o[bv̈̋Ȑ (Ȑ1) ԂB
     *
     * @return	Ȑ1
     */
    public JgclParametricCurve2D curve1() {
	return trc1.basisCurve();
    }

    /**
     * ̃I[o[bv̈̋Ȑ (Ȑ1) ł̃p[^Ԃ̊JnlԂB
     *
     * @return	Ȑ1 ł̃p[^Ԃ̊Jnl
     */
    public double start1() {
	return trc1.tParam1();
    }

    /**
     * ̃I[o[bv̈̋Ȑ (Ȑ1) ł̃p[^Ԃ̏IlԂB
     *
     * @return	Ȑ1 ł̃p[^Ԃ̏Il
     */
    public double end1() {
	return trc1.tParam2();
    }

    /**
     * ̃I[o[bv̈̋Ȑ (Ȑ1) ł̃p[^Ԃ̑lԂB
     *
     * @return	Ȑ1 ł̃p[^Ԃ̑l
     */
    public double increase1() {
	return end1() - start1();
    }

    /**
     * ̃I[o[bv̑̋Ȑ (Ȑ2) ԂB
     *
     * @return	Ȑ2
     */
    public JgclParametricCurve2D curve2() {
	return trc2.basisCurve();
    }

    /**
     * ̃I[o[bv̑̋Ȑ (Ȑ2) ł̃p[^Ԃ̊JnlԂB
     *
     * @return	Ȑ2 ł̃p[^Ԃ̊Jnl
     */
    public double start2() {
	return trc2.tParam1();
    }

    /**
     * ̃I[o[bv̑̋Ȑ (Ȑ2) ł̃p[^Ԃ̏IlԂB
     *
     * @return	Ȑ2 ł̃p[^Ԃ̏Il
     */
    public double end2() {
	return trc2.tParam2();
    }

    /**
     * ̃I[o[bv̑̋Ȑ (Ȑ2) ł̃p[^Ԃ̑lԂB
     *
     * @return	Ȑ2 ł̃p[^Ԃ̑l
     */
    public double increase2() {
	return end2() - start2();
    }

    /**
     * ̊_ł邩ۂԂB
     *
     * @return	_ł͂ȂI[o[bvȂ̂ŁA false
     */
    public boolean isIntersectionPoint() {
	return false;
    }

    /**
     * ̊I[o[bvł邩ۂԂB
     *
     * @return	I[o[bvȂ̂ŁA true
     */
    public boolean isOverlapCurve() {
	return true;
    }

    /**
     * ̊_ɕϊB
     * <p>
     * I[o[bv_ɕϊ邱Ƃ͂łȂ̂ null ԂB
     * </p>
     *
     * @return	 null
     */
    public JgclIntersectionPoint2D toIntersectionPoint() {
	return null;
    }

    /**
     * ̊I[o[bvɕϊB
     * <p>
     * gԂB
     * </p>
     *
     * @return	g
     */
    public JgclOverlapCurve2D toOverlapCurve() {
	return this;
    }

    /**
     * ̃I[o[bv trc1  trc2 I[o[bvԂB
     *
     * @return	trc1  trc2 I[o[bv
     */
    public JgclOverlapCurve2D exchange() {
	JgclOverlapCurve2D ex = new JgclOverlapCurve2D();
	ex.trc1 = this.trc2;
	ex.trc2 = this.trc1;
	return ex;
    }

    /**
     * ̊̈̋Ȑ (Ȑ1) ł̈ʒuA
     * ^ꂽϊɂĕϊ̂ɒuԂB
     *
     * @param sec	Ȑ1 ̃p[^
     * @param conv	Ȑ1 ̃p[^lϊIuWFNg
     * @return	Ȑ1 ̈ʒu^ꂽϊɂĕϊ̂ɒu
     */
    public JgclCurveCurveInterference2D trim1(JgclParameterSection sec,
					      JgclParameterConversion2D conv) {
	// sec  trc1 ̕Ȑ̃p[^łB
	// (JgclIntersectionPoint2D ƓӖɂ邽)
	// senseAgreement == (tParam1 < tParam2)

	int lowerValidity, upperValidity;
	double lower1, upper1;
	double lower, upper;
	if (trc1.senseAgreement()) {
	    lower1 = sec.lower();
	    upper1 = sec.upper();
	}
	else {
	    lower1 = sec.upper();
	    upper1 = sec.lower();
	}

	lower = trc1.toOwnParameter(lower1);
	upper = trc1.toOwnParameter(upper1);
	lowerValidity = trc1.parameterValidity(lower);
	upperValidity = trc1.parameterValidity(upper);

	// gȐ parameterDomain  [0..v]
	//  v = abs(tParam2 - tParam1)
	if (lowerValidity == JgclParameterValidity.OUTSIDE &&
	    lower > 0)
	    return null;	// sec is above upper

	if (upperValidity == JgclParameterValidity.OUTSIDE &&
	    upper <= 0)
	    return null;	// sec is below lower

	if (lowerValidity == JgclParameterValidity.TOLERATED_UPPER_LIMIT) {
	    // touch at upper, so make JgclIntersectionPoint
	    // gȐ parameter ԍő̓_
	    // == Ȑ tParam2 ̓_
	    JgclPointOnCurve2D poc2 =
		new JgclPointOnCurve2D(trc2.basisCurve(), trc2.tParam2(), doCheckDebug);
	    return new JgclIntersectionPoint2D(conv.convToPoint(lower1),
					       poc2,
					       JgclGeometry.doCheckDebug);
	}

	if (upperValidity == JgclParameterValidity.TOLERATED_LOWER_LIMIT) {
	    // touch at lower, so make JgclIntersectionPoint
	    JgclPointOnCurve2D poc1 =
		new JgclPointOnCurve2D(trc2.basisCurve(), trc2.tParam1(), doCheckDebug);
	    return new JgclIntersectionPoint2D(conv.convToPoint(upper1),
					       poc1,
					       JgclGeometry.doCheckDebug);
	}

	double lparam1 = 0;
	double uparam1 = Math.abs(trc1.tParam2() - trc1.tParam1());
	double lparam2 = 0;
	double uparam2 = Math.abs(trc2.tParam2() - trc2.tParam1());

	if (upperValidity == JgclParameterValidity.PROPERLY_INSIDE) {
	    JgclPoint2D upoint1 =
		new JgclPointOnCurve2D(trc1.basisCurve(), upper1, doCheckDebug);
	    uparam2 = trc2.pointToParameter(upoint1);
	    uparam1 = upper;
	}
	if (lowerValidity == JgclParameterValidity.PROPERLY_INSIDE) {
	    JgclPoint2D lpoint1 =
		new JgclPointOnCurve2D(trc1.basisCurve(), lower1, doCheckDebug);
	    lparam2 = trc2.pointToParameter(lpoint1);
	    lparam1 = lower;
	}

	JgclParameterSection pint1 = 
	    trc1.toBasisParameter(new JgclParameterSection(lparam1,
							   uparam1 - lparam1));
	JgclParameterSection pint2 = 
	    trc2.toBasisParameter(new JgclParameterSection(lparam2,
							   uparam2 - lparam2));

	if (upperValidity != JgclParameterValidity.PROPERLY_INSIDE &&
	    lowerValidity != JgclParameterValidity.PROPERLY_INSIDE) {
	    // both lower and upper are outside, so no trim required
	    return new JgclOverlapCurve2D(conv.convToTrimmedCurve(pint1),
					  trc2,
					  false);
	}
	else {
	    JgclTrimmedCurve2D trc =
		new JgclTrimmedCurve2D(trc2.basisCurve(), pint2);
	    return new JgclOverlapCurve2D(conv.convToTrimmedCurve(pint1),
					  trc,
					  false);
	}
    }

    /**
     * ̊̑̋Ȑ (Ȑ2) ł̈ʒuA
     * ^ꂽϊɂĕϊ̂ɒuԂB
     *
     * @param sec	Ȑ2 ̃p[^
     * @param conv	Ȑ2 ̃p[^lϊIuWFNg
     * @return	Ȑ2 ̈ʒu^ꂽϊɂĕϊ̂ɒu
     */
    public JgclCurveCurveInterference2D trim2(JgclParameterSection sec,
					      JgclParameterConversion2D conv) {
	// sec  trc2 ̕Ȑ̃p[^łB
	// (JgclIntersectionPoint2D ƓӖɂ邽)
	// senseAgreement == (tParam1 < tParam2)

	int lowerValidity, upperValidity;
	double lower2, upper2;
	double lower, upper;
	if (trc2.senseAgreement()) {
	    lower2 = sec.lower();
	    upper2 = sec.upper();
	}
	else {
	    lower2 = sec.upper();
	    upper2 = sec.lower();
	}

	lower = trc2.toOwnParameter(lower2);
	upper = trc2.toOwnParameter(upper2);
	lowerValidity = trc2.parameterValidity(lower);
	upperValidity = trc2.parameterValidity(upper);

	// gȐ parameterDomain  [0..v]
	//  v = abs(tParam2 - tParam1)
	if (lowerValidity == JgclParameterValidity.OUTSIDE &&
	    lower > 0)
	    return null;	// sec is above upper

	if (upperValidity == JgclParameterValidity.OUTSIDE &&
	    upper <= 0)
	    return null;	// sec is below lower

	if (lowerValidity == JgclParameterValidity.TOLERATED_UPPER_LIMIT) {
	    // touch at upper, so make JgclIntersectionPoint
	    // gȐ parameter ԍő̓_
	    // == Ȑ tParam2 ̓_
	    JgclPointOnCurve2D poc2 =
		new JgclPointOnCurve2D(trc1.basisCurve(), trc1.tParam2(), doCheckDebug);
	    return new JgclIntersectionPoint2D(poc2,
					       conv.convToPoint(lower2),
					       JgclGeometry.doCheckDebug);
	}

	if (upperValidity == JgclParameterValidity.TOLERATED_LOWER_LIMIT) {
	    // touch at lower, so make JgclIntersectionPoint
	    JgclPointOnCurve2D poc1 =
		new JgclPointOnCurve2D(trc1.basisCurve(), trc1.tParam1(), doCheckDebug);
	    return new JgclIntersectionPoint2D(poc1,
					       conv.convToPoint(upper2),
					       JgclGeometry.doCheckDebug);
	}

	double lparam1 = 0;
	double uparam1 = Math.abs(trc1.tParam2() - trc1.tParam1());
	double lparam2 = 0;
	double uparam2 = Math.abs(trc2.tParam2() - trc2.tParam1());

	if (upperValidity == JgclParameterValidity.PROPERLY_INSIDE) {
	    JgclPoint2D upoint2 =
		new JgclPointOnCurve2D(trc2.basisCurve(), upper2, doCheckDebug);
	    uparam2 = upper;
	    uparam1 = trc1.pointToParameter(upoint2);
	}
	if (lowerValidity == JgclParameterValidity.PROPERLY_INSIDE) {
	    JgclPoint2D lpoint2 =
		new JgclPointOnCurve2D(trc2.basisCurve(), lower2, doCheckDebug);
	    lparam2 = lower;
	    lparam1 = trc1.pointToParameter(lpoint2);
	}

	JgclParameterSection pint1 = 
	    trc1.toBasisParameter(new JgclParameterSection(lparam1,
							   uparam1 - lparam1));
	JgclParameterSection pint2 = 
	    trc2.toBasisParameter(new JgclParameterSection(lparam2,
							   uparam2 - lparam2));

	if (upperValidity != JgclParameterValidity.PROPERLY_INSIDE &&
	    lowerValidity != JgclParameterValidity.PROPERLY_INSIDE) {
	    // both lower and upper are outside, so no trim required
	    return new JgclOverlapCurve2D(trc1,
					  conv.convToTrimmedCurve(pint2),
					  false);
	}
	else {
	    JgclTrimmedCurve2D trc =
		new JgclTrimmedCurve2D(trc1.basisCurve(), pint1);
	    return new JgclOverlapCurve2D(trc,
					  conv.convToTrimmedCurve(pint2),
					  false);
	}
    }

    /**
     * ̊̈̋Ȑ (Ȑ1) ^ꂽȐɒuԂB
     * <p>
     * p[^lȂǂ͂̂܂܁B
     * </p>
     *
     * @param newCurve	Ȑ1 ɐݒ肷Ȑ
     * @return	Ȑ1u
     */
    public JgclCurveCurveInterference2D changeCurve1(JgclParametricCurve2D newCurve) {
	JgclTrimmedCurve2D newTrc1 =
	    new JgclTrimmedCurve2D(newCurve,
				   this.trc1.tPnt1(), this.trc1.tPnt2(),
				   this.trc1.tParam1(), this.trc1.tParam2(),
				   this.trc1.masterRepresentation1(),
				   this.trc1.masterRepresentation2(),
				   this.trc1.senseAgreement());
	return new JgclOverlapCurve2D(newTrc1, this.trc2, false);
    }

    /**
     * ̊̑̋Ȑ (Ȑ2) ^ꂽȐɒuԂB
     * <p>
     * p[^lȂǂ͂̂܂܁B
     * </p>
     *
     * @param newCurve	Ȑ2 ɐݒ肷Ȑ
     * @return	Ȑ2 u
     */
    public JgclCurveCurveInterference2D changeCurve2(JgclParametricCurve2D newCurve) {
	JgclTrimmedCurve2D newTrc2 =
	    new JgclTrimmedCurve2D(newCurve,
				   this.trc2.tPnt1(), this.trc2.tPnt2(),
				   this.trc2.tParam1(), this.trc2.tParam2(),
				   this.trc2.masterRepresentation1(),
				   this.trc2.masterRepresentation2(),
				   this.trc2.senseAgreement());
	return new JgclOverlapCurve2D(this.trc1, newTrc2, false);
    }

    /**
     * ̊􉽗vfR`󂩔ۂԂB
     *
     * @return	trc1, trc2 ƂɎR`łȂ trueAȂ false
     */
    public boolean isFreeform() {
	return (this.trc1.isFreeform() && this.trc2.isFreeform());
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\ttrc1");
        trc1.output(writer, indent + 2);
        writer.println(indent_tab + "\ttrc2");
        trc2.output(writer, indent + 2);
        writer.println(indent_tab + "End");
    }
}
