/*
 * R : iq_Ԃ\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclMesh3D.java,v 1.27 2000/04/26 09:39:07 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.util.Vector;
import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * R : iq_Ԃ\NXB
 * <p>
 * ̃NX͈ʑIɊiq̍\_QԂȖʂ\B
 * </p>
 * <p>
 * bV́Aiq_̂Qz points 
 * U/V eX̕ɕ`ł邩ۂ\tO uClosed/vClosed
 * Œ`B
 * </p>
 * <p>
 * points ́AU ̃CfbNXAV ̃CfbNXB
 * ܂AU  i ԖځAV  j Ԗڂ̓_ points[i][j] Ɋi[B
 * </p>
 * <p>
 * bV U ̃p[^`́A
 * אڂiq_̊Ԃ̃p[^Ԃ̑傫 1 ƂāA
 * ȖʑSł [0, N] ƂȂB
 *  N ́A
 * bV U ɊJ`ł (iq_ U ̐ - 1)A
 * `ł (iq_ U ̐ - 1) ɂȂB
 * </p>
 * <p>
 * V ̃p[^`ɂĂAlłB
 * </p>
 * <p>
 * (u, v) p[^Ƃ镽 P(u, v) ̃pgbN\́Aȉ̒ʂB
 * <pre>
 *	P(u, v) =
 *		(1 - lv) * ((1 - lu) * points[i][j]     + lu * points[i + 1][j]) +
 *		     lv  * ((1 - lu) * points[i][j + 1] + lu * points[i + 1][j + 1])
 * </pre>
 *  i  u zȂő̐A j  v zȂő̐B
 *  lu = (u - i), lv = (v - j) łB
 * </p>
 *
 * @version $Revision: 1.27 $, $Date: 2000/04/26 09:39:07 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclMesh3D extends JgclBoundedSurface3D {
    /**
     * iq_Ԃ\QzB
     * <p>
     * U ̃CfbNXAV ̃CfbNXB
     * ܂AU  i ԖځAV  j Ԗڂ̓_ points[i][j] Ɋi[B
     * </p>
     * @serial
     */
    private JgclPoint3D[][] points;

    /**
     * U ɕ`ۂ\tOB
     * @serial
     */
    private boolean uClosed;

    /**
     * V ɕ`ۂ\tOB
     * @serial
     */
    private boolean vClosed;

    /**
     * iq_Ԃ̃tB[hɒlݒ肷B
     * <p>
     * points  U ̃CfbNXAV ̃CfbNXB
     * ܂AU  i ԖځAV  j Ԗڂ̓_ points[i][j] Ɋi[Ă̂ƂB
     * </p>
     * <p>
     * U ̓_̐ n ƂāA
     * points[i] (i = 0, ..., (n - 1)) ̗vfȂꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * U ̓_̐ nAV ̓_̐ m ƂāA
     * points[i][j] (i = 0, ..., (n - 1), j = 0, ..., (m - 1)) ̒l null ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param points	iq_Ԃ̔z
     * @see	JgclInvalidArgumentValue
     */
    private void setPoints(JgclPoint3D[][] points) {
	int uUip = points.length;
	int vUip = points[0].length;
	int i, j;

	this.points = new JgclPoint3D[uUip][vUip];

	for (i = 0; i < uUip; i++) {
	    if (points[i].length != vUip)
		throw new JgclInvalidArgumentValue();

	    for (j = 0; j < vUip; j++) {
		if (points[i][j] == null)
		    throw new JgclNullArgument();
		this.points[i][j] = points[i][j];
	    }
	}
    }

    /**
     * iq_AU/V ̊J^ăIuWFNg\zB
     * <p>
     * points  U ̃CfbNXAV ̃CfbNXB
     * ܂AU  i ԖځAV  j Ԗڂ̓_ points[i][j] Ɋi[Ă̂ƂB
     * </p>
     * <p>
     * U ̓_̐ n ƂāA
     * points[i] (i = 0, ..., (n - 1)) ̗vfȂꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * U ̓_̐ nAV ̓_̐ m ƂāA
     * points[i][j] (i = 0, ..., (n - 1), j = 0, ..., (m - 1)) ̒l null ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param points	iq_Ԃ̔z
     * @param uClosed	U ɕ`ۂ\tO
     * @param vClosed	V ɕ`ۂ\tO
     * @see	JgclInvalidArgumentValue
     */
    public JgclMesh3D(JgclPoint3D[][] points, boolean uClosed, boolean vClosed) {
	super();
	this.uClosed = uClosed;
	this.vClosed = vClosed;
	setPoints(points);
    }

    /**
     * iq_^ U/V ƂɊJ`ŃIuWFNg\zB
     * <p>
     * points  U ̃CfbNXAV ̃CfbNXB
     * ܂AU  i ԖځAV  j Ԗڂ̓_ points[i][j] Ɋi[Ă̂ƂB
     * </p>
     * <p>
     * U ̓_̐ n ƂāA
     * points[i] (i = 0, ..., (n - 1)) ̗vfȂꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * U ̓_̐ nAV ̓_̐ m ƂāA
     * points[i][j] (i = 0, ..., (n - 1), j = 0, ..., (m - 1)) ̒l null ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param points	iq_Ԃ̔z
     * @see	JgclInvalidArgumentValue
     */
    public JgclMesh3D(JgclPoint3D[][] points) {
	super();
	this.uClosed = false;
	this.vClosed = false;
	setPoints(points);
    }

    /**
     * iq_^ U/V ƂɊJ`ŃIuWFNg\zB
     * <p>
     * points  U ̃CfbNXAV ̃CfbNXB
     * ܂AU  i ԖځAV  j Ԗڂ̓_ points[i][j] Ɋi[Ă̂ƂB
     * </p>
     * <p>
     * doCheck  true ̏ꍇɂ́Aȉ̃`FbNsȂB
     * </p>
     * <blockquote>
     * <p>
     * U ̓_̐ n ƂāA
     * points[i] (i = 0, ..., (n - 1)) ̗vfȂꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * U ̓_̐ nAV ̓_̐ m ƂāA
     * points[i][j] (i = 0, ..., (n - 1), j = 0, ..., (m - 1)) ̒l null ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * </blockquote>
     * <p>
     * doCheck  false ̏ꍇɂ́A
     * ^ꂽ points ̂܂܃CX^X̃tB[hɑB
     * </p>
     * 
     * @param points	iq_Ԃ̔z
     * @param doCheck	̃`FbN邩ǂ̃tO
     * @see	JgclInvalidArgumentValue
     */
    JgclMesh3D(JgclPoint3D[][] points, boolean doCheck) {
	super();
	this.uClosed = false;
	this.vClosed = false;
	if (doCheck)
	    setPoints(points);
	else
	    this.points = points;
    }

    /**
     * LȋȖʂ̑ŜA^ꂽe덷ŋߎIuWFNg\zB
     * 
     * @param surface	LȋȖ
     * @param tol	̋e덷
     * @see	JgclBoundedSurface3D#toMesh(JgclToleranceForDistance)
     */
    public JgclMesh3D(JgclBoundedSurface3D surface,
		      JgclToleranceForDistance tol) {
	super();
	JgclMesh3D mesh = surface.toMesh(tol);
	this.uClosed = mesh.uClosed;
	this.vClosed = mesh.vClosed;
	this.points = mesh.points;
    }

    /**
     * Ȗʂ̎w (p[^I) `ԂA
     * ^ꂽe덷ŋߎIuWFNg\zB
     * 
     * @param surface	Ȗ
     * @param uPint	ߎ U ̃p[^
     * @param vPint	ߎ V ̃p[^
     * @param tol	̋e덷
     * @see	JgclParametricSurface3D#toMesh(JgclParameterSection, JgclParameterSection, JgclToleranceForDistance)
     */
    public JgclMesh3D(JgclParametricSurface3D surface,
		      JgclParameterSection uPint,
		      JgclParameterSection vPint,
		      JgclToleranceForDistance tol) {
	super();
	JgclMesh3D mesh = surface.toMesh(uPint, vPint, tol);
	this.uClosed = mesh.uClosed;
	this.vClosed = mesh.vClosed;
	this.points = mesh.points;
    }

    /**
     * ̃bV̊iq_Ԃ̔zԂB
     * 
     * @return	iq_Ԃ̔z
     */
    public JgclPoint3D[][] points() {
	JgclPoint3D[][] pnts = new JgclPoint3D[uNPoints()][vNPoints()];
	int i, j;

	for (i = 0; i < uNPoints(); i++)
	    for (j = 0; j < vNPoints(); j++)
		pnts[i][j] = pointAt(i, j);
	return pnts;
    }

    /**
     * ̃bV (i, j) Ԗڂ̊iq_ԂB
     * <p>
     * U  i ԖځAV  j Ԗڂ̊iq_ԂB
     * </p>
     * 
     * @return	(i, j) Ԗڂ̊iq_
     */
    public JgclPoint3D pointAt(int i, int j) {
	if (uClosed() && i == uNPoints())
	    i = 0;
	if (vClosed() && j == vNPoints())
	    j = 0;

	return points[i][j];
    }

    /**
     * ̃bV U ɕ`ۂԂB
     * 
     * @return	`Ȃ trueAȂ false
     */
    public boolean uClosed() {
	return this.uClosed;
    }

    /**
     * ̃bV V ɕ`ۂԂB
     * 
     * @return	`Ȃ trueAȂ false
     */
    public boolean vClosed() {
	return this.vClosed;
    }

    /**
     * ̃bV U ̊iq̐ԂB
     * 
     * @return	U ̊iq̐
     */
    public int uNPoints() {
	return points.length;
    }

    /**
     * ̃bV V ̊iq̐ԂB
     * 
     * @return	V ̊iq̐
     */
    public int vNPoints() {
	return points[0].length;
    }

    /**
     * ̃bV U ̃ZOg̐ԂB
     *
     * @return	U ̃ZOg̐
     */
    public int uNSegments() {
	if (uClosed())
	    return uNPoints();

	return uNPoints() - 1;
    }

    /**
     * ̃bV V ̃ZOg̐ԂB
     *
     * @return	V ̃ZOg̐
     */
    public int vNSegments() {
	if (vClosed())
	    return vNPoints();

	return vNPoints() - 1;
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̍WlԂB
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param	uParam	U ̃p[^l
     * @param	vParam	V ̃p[^l
     * @return		Wl
     * @see	JgclNotSupported
     */
    public JgclPoint3D coordinates(double uParam, double vParam) {
	throw new JgclNotSupported();
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̐ڃxNgԂB
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param	uParam	U ̃p[^l
     * @param	vParam	V ̃p[^l
     * @return		ڃxNg
     * @see	JgclNotSupported
     */
    public JgclVector3D[] tangentVector(double uParam, double vParam) {
	throw new JgclNotSupported();
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̓֐ԂB
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param	uParam	U ̃p[^l
     * @param	vParam	V ̃p[^l
     * @return		֐
     * @see	JgclNotSupported
     */
    public JgclSurfaceDerivative3D evaluation(double uParam, double vParam) {
	throw new JgclNotSupported();
    }

    /**
     * ^ꂽ_炱̋Ȗʂւ̓e_߂B
     * <p>
     * e_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param point	e̓_
     * @return		e_
     * @see	JgclNotSupported
     */
    public JgclPointOnSurface3D[] projectFrom(JgclPoint3D point) {
	throw new JgclNotSupported();
    }

    /**
     * `^ꂽ덷Ŋiq_Qɕ
     * iq_Q\_JgclPointOnSurface3Dł邱Ƃ҂ł
     * ̋@\̓T|[gĂȂ
     * 
     * @param uPint	Ũp[^
     * @param vPint	Ṽp[^
     * @param tol	덷
     * @return		iq_
     * @see		JgclParameterSection
     * @see		JgclToleranceForDistance
     * @see		JgclMesh3D
     * @see		JgclPointOnSurface3D
     */
    public JgclMesh3D
	toMesh(JgclParameterSection uPint, JgclParameterSection vPint,
	       JgclToleranceForDistance tol) {
	    throw new JgclNotSupported();
    }

    /**
     *  (`̃p[^`) LȖʑŜA^ꂽ덷ŕʋߎ
     * iq_QԂۃ\bhB
     * <p>
     * ʂƂĕԂiq_Q\_́A
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D 
     * 邱Ƃ҂łB
     * </p>
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param tol	̋e덷
     * @return		̗LȖʑŜ𕽖ʋߎiq_Q
     * @see	JgclPointOnSurface3D
     * @see	JgclNotSupported
     */
    public JgclMesh3D toMesh(JgclToleranceForDistance tol) {
	    throw new JgclNotSupported();
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂɍČ
     * L Bspline ȖʂԂۃ\bhB
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @return		̋Ȗʂ̎w̋ԂČL Bspline Ȗ
     * @see	JgclNotSupported
     */
    public JgclBsplineSurface3D
	toBsplineSurface(JgclParameterSection uPint,
			 JgclParameterSection vPint) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȖʂƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		_̔z
     * @see	JgclNotSupported
     */
    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȖʂƑ̋Ȑ (~Ȑ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (~Ȑ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclConic3D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȖʂƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȖʂƑ̋Ȑ (xWGȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (xWGȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȖʂƑ̋Ȑ (aXvCȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (aXvCȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȖʂƑ̋ȖʂƂ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȗ
     * @return		 (܂͌_) ̔z
     * @see	JgclNotSupported
     */
    public JgclSurfaceSurfaceInterference3D[] intersect(JgclParametricSurface3D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȖʂƑ̋Ȗ () Ƃ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȗ ()
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		 (܂͌_) ̔z
     * @see	JgclNotSupported
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclPlane3D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȖʂƑ̋Ȗ () Ƃ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȗ ()
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		 (܂͌_) ̔z
     * @see	JgclNotSupported
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclSphericalSurface3D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȖʂƑ̋Ȗ (~) Ƃ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȗ (~)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		 (܂͌_) ̔z
     * @see	JgclNotSupported
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclCylindricalSurface3D mate,
						 boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȖʂƑ̋Ȗ (~) Ƃ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȗ (~)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		 (܂͌_) ̔z
     * @see	JgclNotSupported
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclConicalSurface3D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȖʂƑ̋Ȗ (xWGȖ) Ƃ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȗ (xWGȖ)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		 (܂͌_) ̔z
     * @see	JgclNotSupported
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclPureBezierSurface3D mate,
						 boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȖʂƑ̋Ȗ (aXvCȖ) Ƃ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȗ (aXvCȖ)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		 (܂͌_) ̔z
     * @see	JgclNotSupported
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclBsplineSurface3D mate,
						 boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂItZbgȖʂ
     * ^ꂽ덷ŋߎ Bspline Ȗʂ߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.FRONT/BACK)
     * @param tol     	̋e덷
     * @return		̋Ȗʂ̎w̋`Ԃ̃ItZbgȖʂߎ Bspline Ȗ
     * @see	JgclWhichSide
     * @see	JgclNotSupported
     */
    public JgclBsplineSurface3D
	offsetByBsplineSurface(JgclParameterSection uPint,
			       JgclParameterSection vPint,
			       double magni,
			       int side,
			       JgclToleranceForDistance tol) {
	throw new JgclNotSupported();
    }

    /*
     * ̋Ȗʂ U p[^̈ʒuɂ铙p[^ȐԂB
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     *
     * @param parameter	U ̃p[^l
     * @return	w U p[^lł̓p[^Ȑ
     * @see	JgclNotSupported
     */
    public JgclParametricCurve3D uIsoParametricCurve(double parameter) {
	throw new JgclNotSupported();
    }

    /*
     * ̋Ȗʂ V p[^̈ʒuɂ铙p[^ȐԂB
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     *
     * @param parameter	V ̃p[^l
     * @return	w V p[^lł̓p[^Ȑ
     * @see	JgclNotSupported
     */
    public JgclParametricCurve3D vIsoParametricCurve(double parameter) {
	throw new JgclNotSupported();
    }

    /**
     * ̃bVOp`̏WɕϊB
     *
     * @return	Op`̏W
     * @see	JgclSetOfTriangles3D#JgclSetOfTriangles3D(JgclMesh3D)
     */
    public JgclSetOfTriangles3D toSetOfTriangles() {
	return new JgclSetOfTriangles3D(this);
    }

    /**
     * ̋Ȗʂ U ̃p[^`ԂB
     *
     * @return	̋Ȗʂ U ̃p[^`
     */
    JgclParameterDomain getUParameterDomain() {
	double n = uClosed ? uNPoints() : uNPoints()-1;

	return new JgclParameterDomain(uClosed, 0, n);
    }

    /**
     * ̋Ȗʂ V ̃p[^`ԂB
     *
     * @return	̋Ȗʂ V ̃p[^`
     */
    JgclParameterDomain getVParameterDomain() {
	double n = vClosed ? vNPoints() : vNPoints()-1;

	return new JgclParameterDomain(vClosed, 0, n);
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricSurface3D#MESH_3D JgclParametricSurface3D.MESH_3D}
     */
    int type() {
	return MESH_3D;
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂA
     * ^ꂽ덷ŕʋߎ_QԂB
     * <p>
     * ʂƂē_Q͈ʂɁAʑIɂ􉽓IɂAiqł͂ȂB
     * </p>
     * <p>
     * scalingFactor ́A͗pł͂ȂAo͗p̈łB
     * scalingFactor ɂ́Avf 2 ̔z^B
     * scalingFactor[0] ɂ U ̏kڔ{A
     * scalingFactor[1] ɂ V ̏kڔ{ԂB
     * ̒l͉炩̐Βlł͂ȂA
     * p[^̐iޑx T ɑ΂āA
     * U/V ɂĎԏŋȖʏ̓_iޑx Pu/Pv \ΒlłB
     * ܂Ap[^ T iނƁA
     * ԏł̋Ȗʏ̓_ U ł Pu (scalingFactor[0])A
     * V ł Pv (scalingFactor[1]) iނƂ\ĂB
     * T ̑傫͖Ȃ̂ŁA̒lQƂۂɂ́A
     * scalingFactor[0]  scalingFactor[1] ̔䂾pׂłB
     * ȂA̒l͂܂łڈłAȑx̂ł͂ȂB
     * </p>
     * <p>
     * ʂƂĕԂ Vector Ɋ܂܂evf
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D
     * ł邱Ƃ҂łB
     * </p>
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     *
     * @param uParameterSection	U ̃p[^
     * @param vParameterSection	V ̃p[^
     * @param tolerance	̋e덷
     * @param scalingFactor	_QOp`ۂɗLpƎv U/V ̏kڔ{
     * @return	_Q܂ Vector
     * @see	JgclPointOnSurface3D
     * @see	JgclNotSupported
     */
    public Vector toNonStructuredPoints(JgclParameterSection uParameterSection,
					JgclParameterSection vParameterSection,
					double tolerance,
					double[] scalingFactor) {
	throw new JgclNotSupported();	// toNonStructuredPoints
    }

    /**
     * ̊􉽗vfR`󂩔ۂԂB
     *
     * @return	 true
     */
    public boolean isFreeform() {
	return true;
    }

    /**
     * ̋ȖʂA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricSurface3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclPoint3D[][] tPoints = new JgclPoint3D[this.uNPoints()][];
	for (int i = 0; i < this.uNPoints(); i++)
	    tPoints[i] = JgclPoint3D.transform(this.points[i],
					       reverseTransform,
					       transformationOperator,
					       transformedGeometries);
	return new JgclMesh3D(tPoints, this.uClosed, this.vClosed);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);
	int i, j;

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tpoints");
	for (i = 0; i < uNPoints(); i++) {
	    for (j = 0; j < vNPoints(); j++) {
		pointAt(i, j).output(writer, indent + 2);
	    }
        }
        writer.println(indent_tab + "\tuClosed\t" + uClosed);
        writer.println(indent_tab + "\tvClosed\t" + vClosed);
        writer.println(indent_tab + "End");
    }
}
