/*
 * vfƂs\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclMatrix.java,v 1.19 2000/08/11 06:18:54 shikano Exp $
 */

package jp.go.ipa.jgcl;

/**
 * vfƂs\NXB
 * <p>
 * ̃NX̃CX^X́A
 * s̊evf̒l܂ގ̓񎟌z elm[s][]
 * B
 * </p>
 *
 * @version $Revision: 1.19 $, $Date: 2000/08/11 06:18:54 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclMatrix extends java.lang.Object implements java.lang.Cloneable {

    /**
     * LU sȂۂ̑Ίpvfׂ̈̃CvV (萔) B
     * <p>
     * ݂ 1.0e-8 ɐݒ肳ĂB
     * </p>
     *
     * @see	#doLUDecompose()
     */
    static private final double epsilon4DiagonalElements = 1.0e-8;

    /**
     * s (number of rows) B
     */
    private int nRows;

    /**
     *  (number of columns) B
     */
    private int nCols;

    /**
     * s\vf̓񎟌z ([s][]) B
     */
    private double elm[][];

    /**
     * s̃s{bg̏ԂzB
     * <p>
     * ͖̏{NX̓ł̂ݗpAO͌ȂB
     * </p>
     */
    private int pvt[];

    /**
     * LU Ă邩ۂtOB
     * <p>
     * ͖̏{NX̓ł̂ݗpAO͌ȂB
     * </p>
     */
    private boolean LUDecomposed;

    /**
     * sRs[ăIuWFNg\zB
     * <p>
     * ̃RXgN^ private łA
     * ̃NX̗p҂sRs[ꍇɂ copy 𗘗pB
     * </p>
     *
     * @param	src	Rs[̍s
     * @see	#copy()
     */
    private JgclMatrix(JgclMatrix src) {
	this.nRows = src.getRowSize();
	this.nCols = src.getColumnSize();
	this.elm = new double[this.nRows][this.nCols];
	this.pvt = new int[this.nRows];
	for (int i = 0; i < this.nRows; i++) {
	    this.pvt[i] = src.pvt[i];
	    for (int j = 0; j < this.nCols; j++)
		this.elm[this.pvt[i]][j] = src.elm[src.pvt[i]][j];
	}
	this.LUDecomposed = src.LUDecomposed;
    }

    /**
     * w肳ꂽs/񐔂IuWFNg\zB
     * <p>
     * ׂĂ̗vf̒l 0.0 ɏB
     * </p>
     *
     * @param	r	s
     * @param	c	
     */
    public JgclMatrix(int r, int c) {
	this.nRows = r;
	this.nCols = c;
	this.elm = new double[this.nRows][this.nCols];
	this.pvt = new int[this.nRows];
	for (int i = 0; i < this.nRows; i++) {
	    this.pvt[i] = i;
	    for (int j = 0; j < this.nCols; j++)
		this.elm[this.pvt[i]][j] = 0.0;
	}
	this.LUDecomposed = false;
    }

    /**
     * ̓񎟌z^ăIuWFNg\zB
     *
     * @param	values	s̊evf̒l܂ޓ񎟌z
     */
    public JgclMatrix(double[][] values) {
	this.nRows = values.length;
	this.nCols = values[0].length;
	this.elm = new double[this.nRows][this.nCols];
	this.pvt = new int[this.nRows];
	for (int i = 0; i < this.nRows; i++) {
	    this.pvt[i] = i;
	    for (int j = 0; j < this.nCols; j++)
		this.elm[this.pvt[i]][j] = values[i][j];
	}
	this.LUDecomposed = false;
    }

    /**
     * ̍s̍sԂB
     *
     * @return s
     */
    public int getRowSize() {
	return this.nRows;
    }

    /**
     * ̍s̗񐔂ԂB
     *
     * @return 
     */
    public int getColumnSize() {
	return this.nCols;
    }

    /**
     * s񂪊 LU ĂāAvf̒lύX邱ƂłȂƂO̓NXB
     */
    public class MatrixIsLUDecomposed extends JgclRuntimeException {
	/**
	 * ^ɃIuWFNg\zB
	 */
	public MatrixIsLUDecomposed() {
	    super();
	}

	/**
	 * ^ăIuWFNg\zB
	 *
	 * @param s	
	 */
	public MatrixIsLUDecomposed(String s) {
	    super(s);
	}
    }

    /**
     * ^ꂽꎟz̊evf̒lA̍s̎w̍s̊evfɐݒ肷B
     * <p>
     * elm[i][j]  value[j] B
     * </p>
     *
     * @param	i	s̔ԍ (0 x[X)
     * @param	value	vf̒l܂ވꎟz
     * @exception	MatrixIsLUDecomposed	s LU Ă̂ŕύXłȂ
     */
    public void setElementsAt(int i, double[] value) {
	if (LUDecomposed)
	    throw new MatrixIsLUDecomposed();

	for (int j = 0; j < nCols; j++)
	    this.elm[this.pvt[i]][j] = value[j];
    }

    /**
     * ^ꂽlA̍s̎w̍s/̗vfɐݒ肷B
     * <p>
     * elm[i][j]  value B
     * </p>
     *
     * @param	i	s̔ԍ (0 x[X)
     * @param	j	̔ԍ (0 x[X)
     * @param	value	vf̒l
     * @exception	MatrixIsLUDecomposed	s LU Ă̂ŕύXłȂ
     */
    public void setElementAt(int i, int j, double value) {
	if (LUDecomposed)
	    throw new MatrixIsLUDecomposed();

	this.elm[this.pvt[i]][j] = value;
    }

    /**
     * ̍s̎w̍s/̗vf̒lԂB
     * <p>
     * elm[i][j] ̒lԂB
     * </p>
     *
     * @param	i	s̔ԍ (0 x[X)
     * @param	j	̔ԍ (0 x[X)
     * @return	vf̒l
     */
    public double getElementAt(int i, int j) {
	return this.elm[this.pvt[i]][j];
    }

    /**
     * ̍s̎w̍s/̗vf̒lԂB
     * <p>
     * elm[i][j] ̒lԂB
     * </p>
     *
     * @param	i	s̔ԍ (0 x[X)
     * @param	j	̔ԍ (0 x[X)
     * @return	vf̒l
     */
    private double elm(int i, int j) {
	return this.elm[this.pvt[i]][j];
    }

    /**
     * ̍s̕ԂB
     *
     * @return	ꂽsB
     */
    public JgclMatrix copy() {
	return new JgclMatrix(this);
    }

    /**
     * ̍s̕ԂB
     *
     * @return	ꂽs
     */
    public java.lang.Object clone() {
	return this.copy();
    }

    /**
     * ̍sƑ̍śuav\sԂB
     * <p>
     * this  mate ̍sƗ񐔂͂ꂼꓙȂ΂ȂȂB
     * this  mate ̍s邢͗񐔂قȂꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param	mate	a鑊̍s
     * @return		s̘a (this + mate)
     * @see	JgclInvalidArgumentValue 
     */
    public JgclMatrix add(JgclMatrix mate) {
	if (!(this.nRows == mate.nRows) || !(this.nCols == mate.nCols)) {
	    throw new JgclInvalidArgumentValue();
	}
	    
	JgclMatrix add = new JgclMatrix(this.nRows, this.nCols);
	for (int i = 0; i < this.nRows; i++) {
	    for (int j = 0; j < this.nCols; j++) {
		add.setElementAt(i, j,
				 this.getElementAt(i, j) +
				 mate.getElementAt(i, j));
	    }
	}

	return add;
    }

    /**
     * ̍sƑ̍śuv\sԂB
     * <p>
     * this  mate ̍sƗ񐔂͂ꂼꓙȂ΂ȂȂB
     * this  mate ̍s邢͗񐔂قȂꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param	mate	鑊̍s
     * @return		s̍ (this - mate)
     * @see	JgclInvalidArgumentValue 
     */
    public JgclMatrix subtract(JgclMatrix mate) {
	if (!(this.nRows == mate.nRows) || !(this.nCols == mate.nCols)) {
	    throw new JgclInvalidArgumentValue();
	}
	    
	JgclMatrix sub = new JgclMatrix(this.nRows, this.nCols);
	for (int i = 0; i < this.nRows; i++) {
	    for (int j = 0; j < this.nCols; j++) {
		sub.setElementAt(i, j,
				 this.getElementAt(i, j) -
				 mate.getElementAt(i, j));
	    }
	}

	return sub;
    }

    /**
     * ̍sƑ̍śuρv\sԂB
     * <p>
     * ʂƂēs
     * s this ̍sɓA
     * 񐔂 mate ̗񐔂ɓB
     * </p>
     * <p>
     * this ̗񐔂 mate ̍s͓Ȃ΂ȂȂB
     * this Ɨ񐔂 mate ̍sقȂꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param	mate	ς鑊̍s
     * @return		s̐ (this * mate)
     * @see	JgclInvalidArgumentValue 
     */
    public JgclMatrix multiply(JgclMatrix mate) {
	if (!(this.nCols == mate.nRows)) {
	    throw new JgclInvalidArgumentValue();
	}
	    
	JgclMatrix multi = new JgclMatrix(this.nRows, mate.nCols);
	for (int i = 0; i < this.nRows; i++) {
	    double[] iRow = this.elm[i];
	    for (int j = 0; j < mate.nCols; j++) {
		double value = 0.0;
		for (int k = 0; k < this.nCols; k++) {
		    value = 
			value + (iRow[k] * mate.getElementAt(k, j));
		}
		multi.setElementAt(i, j, value);
	    }
	}

	return multi;
    }

    /**
     * s񂪐łȂƂO̓NXB
     */
    public class MatrixIsNotSquare extends JgclRuntimeException {
	/**
	 * ^ɃIuWFNg\zB
	 */
	public MatrixIsNotSquare() {
	    super();
	}

	/**
	 * ^ăIuWFNg\zB
	 *
	 * @param s	
	 */
	public MatrixIsNotSquare(String s) {
	    super(s);
	}
    }

    /**
     * ̍s̍s񎮂̒lԂB
     * <p>
     * ̍s񂪐słȂꍇɂ́A
     * MatrixIsNotSquare ̗O𔭐B
     * </p>
     *
     * @return s񎮂̒l
     */
    public double determinant() {
	if (this.nRows != this.nCols)
	    throw new MatrixIsNotSquare();

	int theSize = this.nRows; // = this.nCols;

	if (theSize == 2)
	    return ((elm(0, 0) * elm(1, 1)) - (elm(0, 1) * elm(1, 0)));

	double result = 0.0;

	for (int i = 0; i < theSize; i++) {
	    double valueP = 1.0;
	    double valueM = 1.0;
	    for (int j = 0; j < theSize; j++) {
		int k = (i + j) % theSize;
		valueP *= elm(k, j);
		valueM *= elm(((theSize - 1) - k), j);
	    }
	    result += valueP;
	    result -= valueM;
	}

	return result;
    }

    /**
     * ̍s (N x N s)  LU B
     * <p>
     * this  (s{bg) Ίpvf
     * {@link #epsilon4DiagonalElements epsilon4DiagonalElements}
     * ̂ꍇɂ́ArŒfAfalse ԂB
     * </p>
     * <p>
     * this słȂꍇɂ́A
     * MatrixIsNotSquare ̗O𓊂B
     * </p>
     *
     * @return	ɏI trueAłȂ false
     * @see	#makeLUDecomposition()
     */
    private boolean doLUDecompose() {
	if (this.nRows != this.nCols)
	    throw new MatrixIsNotSquare();

	int theSize = this.nRows; // = this.nCols;

	for (int i = 0; i < theSize; i++) {
	    /*
	     * i ڂ̍őls (maxIdx s) T
	     */
	    int maxIdx = i;
	    double maxVal = Math.abs(this.elm(maxIdx, i));
	    for (int j = (i + 1); j < theSize; j++) {
		double jValue = Math.abs(this.elm(j, i));
		if (jValue > maxVal) {
		    maxIdx = j;
		    maxVal = jValue;
		}
	    }

	    /*
	     * i sڂ maxIdx sڂꊷ
	     */
	    if (maxIdx != i) {
		int pvtVal = this.pvt[i];
		this.pvt[i] = this.pvt[maxIdx];
		this.pvt[maxIdx] = pvtVal;
	    }

	    /*
	     * ۂ𔻒fElƂ 1.0e-8 g
	     * ̔fɂ (oI) machineEpsilon ̒l͏
	     */
	    if (Math.abs(this.elm(i, i)) < JgclMatrix.epsilon4DiagonalElements)
		return false;

	    /*
	     * Gauss @
	     */
	    this.setElementAt(i, i, 1.0 / this.elm(i, i));

	    for (int j = (i + 1); j < theSize; j++) {
		this.setElementAt(j, i, (this.elm(j, i) * this.elm(i, i)));
		for (int k = (i + 1); k < theSize; k++)
		    this.setElementAt(j, k, (this.elm(j, k) - (this.elm(j, i) * this.elm(i, k))));
	    }
	}

	return true;
    }

    /**
     * ̍s (N x N s)  LU ʂԂB
     * <p>
     *  this ̑Ίpvf
     * 1.0e-8 l̂ꍇɂ́Anull ԂB
     *  1.0e-8 ƂĺA
     * ݂͂̃NX̓Œ萔ƂĐݒ肳ĂA
     * ̃NX̃\[XvOҏWȂAύX邱Ƃ͂łȂB
     * </p>
     * <p>
     * this  LU ꂽ̂łꍇ́Athis ԂB
     * </p>
     * <p>
     * this słȂꍇɂ́A
     * MatrixIsNotSquare ̗O𓊂B
     * </p>
     *
     * @return	LU ̌
     */
    public JgclMatrix makeLUDecomposition() {
	if (this.nRows != this.nCols)
	    throw new MatrixIsNotSquare();

	if (this.LUDecomposed == true)
	    return this;

	JgclMatrix dst = this.copy();
	if (dst.doLUDecompose() != true) {
	    return null;
	}
	dst.LUDecomposed = true;

	return dst;
    }

    /**
     * ̍sӂ̈ꎟ̌W (A) ƂAꎟ AX = B B
     * <p>
     * ̉E (B) ͈Ƃė^A X ԂB
     * </p>
     * <p>
     * this (A) ͐słA\ LU ĂȂ΂ȂȂB
     * </p>
     * <p>
     * this słȂA\ LU ĂȂꍇɂ null ԂB
     * </p>
     *
     * @param rightHandValues	ẢE (B)
     * @return	Ả (X)
     * @see	#makeLUDecomposition()
     * @see	#solveSimultaneousLinearEquations(double[])
     */
    private double[] doSolveSimultaneousLinearEquations(double[] rightHandValues) {
	/*
	 * the matrix should be LUDecomposed in advance
	 */
	if (this.LUDecomposed != true) {
	    return null;
	}

	int n = this.nRows;	// = this.nCols

	/*
	 * size of the array of right hand values should be same as this
	 */
	if (n != rightHandValues.length)
	    throw new JgclInvalidArgumentValue();

	double[] result = new double[n];
	double theValue;	// work area

	/*
	 * forward substitution
	 */
	for (int i = 0; i < n; i++) {
	    theValue = rightHandValues[this.pvt[i]];
	    for (int j = 0; j < i; j++)
		theValue -= this.elm(i, j) * result[j];
	    result[i] = theValue;
	}

	/*
	 * backward substitution
	 */
	for (int i = (n - 1); i >= 0; i--) {
	    theValue = result[i];
	    for (int j = (i + 1); j < n; j++)
		theValue -= this.elm(i, j) * result[j];
	    result[i] = theValue * elm(i, i);
	}

	return result;
    }

    /**
     * ̍sӂ̈ꎟ̌W (A) ƂAꎟ AX = B B
     * <p>
     * ̉E (B) ͈Ƃė^A X ԂB
     * </p>
     * <p>
     * this (A) ͐słȂ΂ȂȂB
     * </p>
     * <p>
     * this słȂAtsȂꍇɂ null Ԃ
     * </p>
     *
     * @param rightHandValues	ẢE (B)
     * @return	Ả (X)
     */
    public double[] solveSimultaneousLinearEquations(double[] rightHandValues) {
	JgclMatrix LUDecomp = this.makeLUDecomposition();

	if (LUDecomp == null) {
	    return null;
	}

	return LUDecomp.doSolveSimultaneousLinearEquations(rightHandValues);
    }

    /**
     * vs A  QR ̌ʂ\NXB
     */
    private class QRDecomposition {
	private double[]   rd;
	private double[]   coef;
	private int        rank;
	private int[]      ip;	// null ̉\
	private double	   cond;

	QRDecomposition(double[] rd, double[] coef, int[] ip, int rank, double cond)
	{
	    this.rd     = rd;
	    this.coef   = coef;
	    this.ip     = ip;
	    this.rank   = rank;
	    this.cond	= cond;
	}

	private double[] getDiagonalElementOfR(){
	    return rd;
	}

	private double[] getCoefficent() {
	    return coef;
	}

	private int[] getIndexVector() {
	    return ip;
	}

	private int getApproximatedRankOfA() {
	    return rank;
	}

	private double getCondition() {
	    return cond;
	}
    }

    /**
     * ̍s (vs A)  Householder @ɂ QR ʂԂB
     * <p>
     * vs A  A = Q * R  Q, R ɕB
     * </p>
     *
     * @return	QR  ̌
     * @see	#solveLinearLeastSquare(double[])
     * @see	#solveQREquations(JgclMatrix.QRDecomposition, double[])
     */
    private QRDecomposition doHouseHolderQRDecomposition()
    {
	/*
	 * Note:
	 *
	 * the orthogonal matrix Q can be written as
	 *	Q = Q(0) * Q(1) * ... * Q(m-1)
	 * where
	 *	Q(k) = I - c(k) * w(k) * w(transpose)(k).
	 *
	 * vector w(k) is stored in ip(k)-th column of A
	 *
	 *	A[i][ip(k)] = Q[i][ip(k)],	i = k, n - 1
	 *	A[i][ip(k)] = R[i][ip(k)],	i = 0, k - 1
	 *
	 * the diagonal of R is stored in rd
	 */
	int n = getRowSize();		// number of rows of A
	int m = getColumnSize();	// number of columns of A

	int[] ip = new int[m];
	double[] rd     = new double[m];
	double[] g2     = new double[m];
	double[] coef   = new double[m];
	int rank;
	double cond;
	double gmax = 0.0;
	double tmax = 0.0;
	int i, j, k, l;

	// JgclMachineEpsilon.DOUBLE == 2.220446049250313E-16
	// Ȃ̂ɂ͕KvH (Solaris7 for Intel, jdk1.1.7 ̏ꍇ)
	double my_minute = 1.0e-75;

	for (i = 0; i < m; i++) {
	    ip[i] = i;
	}

	/*
	 * Householder transformation with pivoting
	 */
	for (k = 0; k < m; k++) {

	    /*
	     * find the pivot column
	     */
	    int kp = 0;
	    gmax = 0.0;
	    tmax = 0.0;
	    for (j = k; j < m; j++) {
		double t = 0.0;
		for (i = k; i < n; i++) {
		    t += elm(i, ip[j]) * elm(i, ip[j]);
		}

		if (k == 0) {
		    g2[ip[j]] = t;
		    if (t > tmax) {
			tmax = t;
			kp = j;
		    }
		} else {
		    double gv = 0.0;
		    if (g2[ip[j]] != 0.0)
			gv = t / g2[ip[j]];
		    if (gv > gmax) {
			gmax = gv;
			tmax = t;
			kp = j;
		    }
		}
	    }
	    
	    if (((k == 0) && (tmax < my_minute)) ||
		((k > 0)  && (gmax < JgclMachineEpsilon.DOUBLE))) {
		/*
		 * rank deficiency
		 */
		rank = k;
		cond = 1 / Math.sqrt(JgclMachineEpsilon.DOUBLE);
		return new QRDecomposition(rd, coef, ip, rank, cond);
	    }

	    /*
	     * column exchange
	     */
	    if (kp != k) {
		int kv = ip[k];
		ip[k] = ip[kp];
		ip[kp] = kv;
	    }
	    
	    /*
	     * Householder transformation
	     */
	    double s = Math.sqrt(tmax);
	    if (elm(k, ip[k]) < 0.0) s = (- s);
	    
	    setElementAt(k, ip[k], elm(k, ip[k]) + s);
	    coef[ip[k]] = 1.0 / (elm(k, ip[k]) * s);
	    rd[ip[k]] = (- 1.0 / s);
	    
	    for (j = k + 1; j < m; j++) {
		double t = 0.0;
		for (l = k; l < n; l++) {
		    t += elm(l, ip[k]) * elm(l, ip[j]);
		}
		t *= coef[ip[k]];
		
		setElementAt(k, ip[j], elm(k, ip[j]) - t * elm(k, ip[k]));
		for (i = k + 1; i < n; i++) {
		    setElementAt(i, ip[j], elm(i, ip[j]) - t * elm(i, ip[k]));
		}
	    }
	}
	
	/*
	 * full rank
	 */
	rank = m;
	cond = 1 / Math.sqrt(gmax);
	return new QRDecomposition(rd, coef, ip, rank, cond);
    }

    /**
     * `̘A R * X = Q * B  X ߂B
     *
     * @param	decomposition	QR ̌
     * @param	rightHandValues	ẢE (B)
     * @return	Ả (X)
     * @see	#solveLinearLeastSquare(double[])
     * @see	#doHouseHolderQRDecomposition()
     */
    private double[] solveQREquations(QRDecomposition decomposition,
				      double[] rightHandValues)
    {
	double[] rd = decomposition.getDiagonalElementOfR();
	double[] coef = decomposition.getCoefficent();
	int[] ip = decomposition.getIndexVector();
	int rank = decomposition.getApproximatedRankOfA();

	int n = getRowSize();		// number of rows of A
	int m = getColumnSize();	// number of columns of A
	double[] solution = new double[m];
	
	/*
	 * compute Q(transpose) * B
	 */
	for (int k = 0; k < rank; k++) {
	    double t = 0.0;
	    for (int l = k; l < n; l++)
		t += elm(l, ip[k]) * rightHandValues[l];
	    t *= coef[ip[k]];

	    for (int i = k; i < n; i++)
		rightHandValues[i] -= t * elm(i, ip[k]);
	}

	/*
	 * solve R * X = Q(transpose) * B
	 */
	for (int k = (rank - 1); k >= 0; k--) {
	    double t = rightHandValues[k];
	    for (int j = (k + 1); j < rank; j++) {
		t -= elm(k, ip[j]) * solution[ip[j]];
	    }
	    solution[ip[k]] = t * rd[ip[k]];
	}

	if (rank != m) {
	    /*
	     * rank deficiency
	     */
	    for (int k = rank; k < m; k++)
		solution[ip[k]] = 0.0;
	}

	return solution;
    }

    /**
     * ߏ (m̐̐̕) ̘Aꎟ AX = B
     * ɑ΂ŏ X' \NX
     *
     * @see	#solveLinearLeastSquare(double[])
     */
    public class LinearLeastSquareSolution {
	/**
	 * s A ̊K
	 */
	private int rank;

	/**
	 * s A ̏
	 */
	private double condition;

	/**
	 * ŏ̔z (X')
	 */
	private double[] solutions;

	/**
	 * etB[h̒l^ăIuWFNg\zB
	 *
	 * @param rank	s A ̊K
	 * @param condition	s A ̏
	 * @param solution	ŏ̔z (X')
	 */
	private LinearLeastSquareSolution(int rank, double condition, double[] solutions) {
	    this.rank = rank;
	    this.condition = condition;
	    this.solutions = solutions;
	}

	/**
	 * s A ̊KԂB
	 *
	 * @return	s A ̊K
	 */
	public int rank() {
	    return rank;
	}

	/**
	 * s A ̏ԂB
	 *
	 * @return	s A ̏
	 */
	public double condition() {
	    return condition;
	}

	/**
	 * w̔ԍ̍ŏԂB
	 * <p>
	 * X'[i] ԂB
	 * </p>
	 *
	 * @param i	X' ̃CfbNX
	 * @return	i Ԗڂ̍ŏ
	 */
	public double solutionAt(int i) {
	    return solutions[i];
	}

	/**
	 * w̔ԍ̍ŏ X' ԂB
	 *
	 * @return	ŏ̔z (X')
	 */
	public double[] solutions() {
	    return (double[])solutions.clone();
	}
    }

    /**
     * ̍sӂ̈ꎟ̌W (A) Ƃ
     * ߏ (m̐̐̕) ̘Aꎟ AX = B
     * ɑ΂ŏ X' ߂B
     * <p>
     * ̍s̗񐔂 rightHandValues ̗vfvȂ΁A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param	rightHandValues	ẢE (B)
     * @return	A̍ŏ (X')
     * @see	JgclInvalidArgumentValue
     * @see	#solveLinearLeastSquare2(double[])
     */
    public LinearLeastSquareSolution solveLinearLeastSquare(double[] rightHandValues) {
	/*
	 * ̃RǵAƂƂ͏ javadoc p̃RgȂ񂾂ǁA
	 * private Ȃ̂ւ̎QƂȂ̂ŁAOĂ
	 *
	 * @see	QRDecomposition
	 * @see	#doHouseHolderQRDecomposition()
	 * @see	#solveQREquations(JgclMatrix.QRDecomposition, double[])
	 */

	if (this.nRows != rightHandValues.length) {
	    throw new JgclInvalidArgumentValue();
	}

	JgclMatrix me = this.copy();	// vf̒l̂ŕKRs[

	QRDecomposition decomposition = me.doHouseHolderQRDecomposition();
	double[] solutions = me.solveQREquations(decomposition, rightHandValues);

	return new LinearLeastSquareSolution(decomposition.getApproximatedRankOfA(),
					     decomposition.getCondition(), solutions);
    }

    /**
     * ̍s (vs A)  Householder @ɂ QR ʂԂ (^Cv 2) B
     * <p>
     * vs A  A = Q * R  Q, R ɕB
     * </p>
     *
     * @return	QR  ̌
     * @see	#solveLinearLeastSquare2(double[])
     * @see	#solveQREquations2(JgclMatrix.QRDecomposition, double[])
     */
    private QRDecomposition doHouseHolderQRDecomposition2()
    {
	/*
	 * Note:
	 *
	 * the orthogonal matrix Q can be written as
	 *	Q = Q(0) * Q(1) * ... * Q(m-1)
	 * where
	 *	Q(k) = I - c(k) * w(k) * w(transpose)(k).
	 *
	 * vector w(k) is stored in ip(k)-th column of A
	 *
	 *	A[i][ip(k)] = Q[i][ip(k)],	i = k, n - 1
	 *	A[i][ip(k)] = R[i][ip(k)],	i = 0, k - 1
	 *
	 * the diagonal of R is stored in rd
	 */
	int n = getRowSize();		// number of rows of A
	int m = getColumnSize();	// number of columns of A

	double[] rd   = new double[m];
	double[] coef = new double[m];
	double[] g2   = new double[m];
	int rank;
	double cond;
	double gmax = 0.0;
	double tmax = 0.0;
	int i, j, k, l;

	// JgclMachineEpsilon.DOUBLE == 2.220446049250313E-16
	// Ȃ̂ɂ͕KvH(Solaris7 for Intel, jdk1.1.7 ̏ꍇ)
	double my_minute = 1.0e-75;

	/*
	 * Householder transformation WITHOUT pivoting
	 */
	for (k = 0; k < m; k++) {
	    /*
	     * get (tmax)
	     */
	    gmax = 0.0;
	    tmax = 0.0;
	    if (k == 0) {
		for (j = k; j < m; j++) {
		    double t = 0.0;
		    for (i = k; i < n; i++) {
			if (elm(i, j) != 0.0)
			    t += elm(i, j) * elm(i, j);
		    }
		    g2[j] = t;
		}
		tmax = g2[0];
		
	    } else {
		double t = 0.0;
		for (i = k; i < n; i++)
		    if (elm(i, k) != 0.0)
			t += elm(i, k) * elm(i, k);
		
		gmax = (g2[k] != 0.0) ? (t / g2[k]) : 0.0;
		tmax = t;
	    }
	    
	    if ((k == 0) && (tmax < my_minute) ||
		(k > 0)  && (gmax < JgclMachineEpsilon.DOUBLE))
	    {
		/***
		 * rank deficiency
		 */
		rank = k;
		cond = 1 / Math.sqrt(JgclMachineEpsilon.DOUBLE);
		return new QRDecomposition(rd, coef, null, rank, cond);
	    }
	    
	    /*
	     * Householder transformation
	     */
	    double s = Math.sqrt(tmax);
	    if (elm(k, k) < 0.0) s = (- s);
    
	    setElementAt(k, k, elm(k, k) + s);
	    coef[k] = 1.0 / (elm(k, k) * s);
	    rd[k] = (- 1.0 / s);
	    
	    for (j = k + 1; j < m; j++) {
		double t = 0.0;
		for (l = k; l < n; l++) {
		    if (elm(l, k) == 0.0)
			break;
		    if (elm(l, j) != 0.0)
			t += elm(l, k) * elm(l, j);
		}
		t *= coef[k];
		
		setElementAt(k, j, elm(k, j) - t * elm(k, k));
		for (i = k + 1; i < n; i++) {
		    if (elm(i, k) == 0.0)
			break;
		    setElementAt(i, j, elm(i, j) - t * elm(i ,k));
		}
	    }
	}

	/*
	 * full rank
	 *
	 */
	rank = m;
	cond = 1 / Math.sqrt(gmax);
	return new QRDecomposition(rd, coef, null, rank, cond);
    }

    /**
     * `̘A R * X = Q * B  X ߂ (^Cv 2) B
     *
     * @param	decomposition	QR ̌
     * @param	rightHandValues	ẢE (B)
     * @return	Ả (X)
     * @see	#solveLinearLeastSquare2(double[])
     * @see	#doHouseHolderQRDecomposition2()
     */
    private double[] solveQREquations2(QRDecomposition decomposition,
				       double[] rightHandValues)
    {
	double[] rd = decomposition.getDiagonalElementOfR();
	double[] coef = decomposition.getCoefficent();
	int rank = decomposition.getApproximatedRankOfA();

	int n = getRowSize();		// number of rows of A
	int m = getColumnSize();	// number of columns of A
	double[] solution = new double[m];
	
	/*
	 * compute Q(transpose) * B
	 */
	for (int k = 0; k < rank; k++) {
	    double t = 0.0;
	    for (int l = k; l < n; l++) {
		if (elm(l, k) != 0.0) {
		    t += elm(l, k) * rightHandValues[l];
		}
	    }
	    t *= coef[k];

	    for (int i = k; i < n; i++) {
		if (elm(i, k) != 0.0) {
		    rightHandValues[i] -= t * elm(i, k);
		}
	    }
	}

	/*
	 * solve R * X = Q(transpose) * B
	 */
	for (int k = (rank - 1); k >= 0; k--) {
	    double t = rightHandValues[k];
	    for (int j = (k + 1); j < rank; j++) {
		if (elm(k, j) != 0.0) {
		    t -= elm(k, j) * solution[j];
		}
	    }
	    solution[k] = t * rd[k];
	}

	if (rank != m) {
	    /*
	     * rank deficiency
	     */
	    for (int k = rank; k < m; k++) {
		solution[k] = 0.0;
	    }
	}

	return solution;
    }

    /**
     * ̍sӂ̈ꎟ̌W (A) Ƃ
     * ߏ (m̐̐̕) ̘Aꎟ AX = B
     * ɑ΂ŏ X' ߂ (^Cv 2) B
     * <p>
     * ̍s̗񐔂 rightHandValues ̗vfvȂ΁A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * ̃\bh́A{Iɂ
     * {@link #solveLinearLeastSquare(double[]) solveLinearLeastSquare(double[])}
     * Ɠl̏sȂAs A ̓eɈȉ̐t邱ƂŁA
     * ɂo[WłB
     * <ul>
     * <li>Ίpʒu̗vf͔ł邱ƁB
     * <li>Ίpʒu荶̗vf elm[i][j] (i ͍sAj ͗Ai >= j) ɊւāA
     * <ul>
     * <li>e[i][j] ł -> e[i+1][j] ͉łǂ
     * <li>e[i][j] ł   -> e[i+1][j] ͗łȂ΂ȂȂ
     * </ul>
     * </ul>
     * ̃\bh̓ł́A
     * this ̏𖞂Ă̂Ƃďi߂ĂA
     * this ̏𖞂ĂȂꍇɂ͗\łȂʂB
     * </p>
     *
     * @param	rightHandValues	ẢE (B)
     * @return	Ả (X)
     * @see	JgclInvalidArgumentValue
     * @see	#solveLinearLeastSquare(double[])
     */
    public LinearLeastSquareSolution solveLinearLeastSquare2(double[] rightHandValues) {
	/*
	 * ̃RǵAƂƂ͏ javadoc p̃RgȂ񂾂ǁA
	 * private Ȃ̂ւ̎QƂȂ̂ŁAOĂ
	 *
	 * @see	QRDecomposition
	 * @see	#doHouseHolderQRDecomposition2()
	 * @see	#solveQREquations2(JgclMatrix.QRDecomposition, double[])
	 */
	int n = getRowSize();
	int m = getColumnSize();

	if (n != rightHandValues.length) {
	    throw new JgclInvalidArgumentValue();
	}

	int i, j, k;
	for (i = 0; i < n; i++)
	    if (elm(i, 0) == 0.0)
		break;

	for (; i < n; i++)
	    if (elm(i, 0) != 0.0)
		break;

	JgclMatrix me;
	if (i < n) {
	    JgclMatrix copy = new JgclMatrix(n, m);
	    double[] rhsv2 = new double[n];
	    for (j = 0; j < n; j++, i++) {
		if (i >= n)
		    i = 0;
		for (k = 0; k < m; k++)
		    copy.setElementAt(j, k, elm(i, k));
		rhsv2[j] = rightHandValues[i];
	    }
	    me = copy;
	    rightHandValues = rhsv2;
	} else {
	    me = this.copy();	// vf̒l̂ŕKRs[
	}

	QRDecomposition decomposition =
	    me.doHouseHolderQRDecomposition2();
	double[] solutions =
	    me.solveQREquations2(decomposition, rightHandValues);

	return new LinearLeastSquareSolution(decomposition.getApproximatedRankOfA(),
					     decomposition.getCondition(), solutions);
    }

    // for Debug
    /**
     * fobOpCvOB
     */
    public static void main(String argv[]) {
	/*
	JgclMatrix matrix = new JgclMatrix(3, 3);
	double[] m0  = { 3,   4,  7};
	double[] m1  = {-2,   3, 19};
	double[] m2  = { 5, -10,  6};

	matrix.setElementsAt(0, m0);
	matrix.setElementsAt(1, m1);
	matrix.setElementsAt(2, m2);

	*/
	double[] m0  = { 3,   4,  7};
	double[] m1  = {-2,   3, 19};
	double[] m2  = { 5, -10,  6};
	double[][] mmm = {m0, m1, m2};
	JgclMatrix matrix = new JgclMatrix(mmm);

	// s񓯎m̉Z,Z,Z̃eXg
	JgclMatrix add = matrix.add(matrix);
	JgclMatrix sub = matrix.subtract(matrix);
	JgclMatrix multi = matrix.multiply(matrix);

	System.out.println("\n[matrix + matrix]");
	for (int i = 0; i < 3; i++) {
	    System.out.println(i + "th row : (" + 
			       add.getElementAt(i, 0) + ", " +
			       add.getElementAt(i, 1) + ", " +
			       add.getElementAt(i, 2) + ")");
	}
	System.out.println("\n[matrix - matrix]");
	for (int i = 0; i < 3; i++) {
	    System.out.println(i + "th row : (" + 
			       sub.getElementAt(i, 0) + ", " +
			       sub.getElementAt(i, 1) + ", " +
			       sub.getElementAt(i, 2) + ")");
	}
	System.out.println("\n[matrix * matrix]");
	for (int i = 0; i < 3; i++) {
	    System.out.println(i + "th row : (" + 
			       multi.getElementAt(i, 0) + ", " +
			       multi.getElementAt(i, 1) + ", " +
			       multi.getElementAt(i, 2) + ")");
	}
	System.out.println();

	// Aꎟ̃eXg
	double[] rrr = { 3,  -4,  8};
	double[] result = matrix.solveSimultaneousLinearEquations(rrr);
	for (int i = 0; i < 3; i++) {
	    System.out.println("Equations solving result : " +
			       result[i] + ", value : " +
			       ((matrix.getElementAt(i, 0) * result[0]) + 
				(matrix.getElementAt(i, 1) * result[1]) + 
				(matrix.getElementAt(i, 2) * result[2]) -
				rrr[i]));
	}

	// ŏ@̃eXg
	LinearLeastSquareSolution result1 = matrix.solveLinearLeastSquare(rrr);
	System.out.println("LinearLeastSquare result : {" +
			   result1.solutionAt(0) + ", " +
			   result1.solutionAt(1) + ", " +
			   result1.solutionAt(2) + "}");

	LinearLeastSquareSolution result2 = matrix.solveLinearLeastSquare2(rrr);
	System.out.println("LinearLeastSquare2 result : {" +
			   result2.solutionAt(0) + ", " +
			   result2.solutionAt(1) + ", " +
			   result2.solutionAt(2) + "}");
    }
}

/* end of file */
