/*
 * RFe萔Œ`ꂽxNg\
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclLiteralVector3D.java,v 1.18 2000/04/26 09:39:05 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.io.PrintWriter;

/**
 * RFe萔Œ`ꂽxNg\NXB
 *
 * @version $Revision: 1.18 $, $Date: 2000/04/26 09:39:05 $
 * @author Information-technology Promotion Agency, Japan
 * @see	JgclHomogeneousVector3D
 */

public class JgclLiteralVector3D extends JgclVector3D {

    /**
     * X B
     * @serial
     */
    private final double x;

    /**
     * Y B
     * @serial
     */
    private final double y;

    /**
     * Z B
     * @serial
     */
    private final double z;


    /**
     * (x, y, z) Œ`IuWFNg\zB
     *
     * @param x		X 
     * @param y		Y 
     * @param z		Z 
     */
    public JgclLiteralVector3D(double x, double y, double z) {
	super();
	this.x = x;
	this.y = y;
	this.z = z;
    }

    /**
     * (c[0], c[1], c[2]) Œ`IuWFNg\zB
     *
     * @param c		̔z
     */
    public JgclLiteralVector3D(double[] c) {
	super();
	this.x = c[0];
	this.y = c[1];
	this.z = c[2];
    }

    /**
     * (x, y, z) Œ`IuWFNg\zB
     * 
     * @param x		X 
     * @param y		Y 
     * @param confirmedAsUnitized	悤ƂxNg
     *					PʃxNgł邱ƂĂȂ <code>true</code>A
     *					Ȃ <code>false</code>
     */
    JgclLiteralVector3D(double x, double y, double z,
			boolean confirmedAsUnitized) {
	super(confirmedAsUnitized);
	this.x = x;
	this.y = y;
	this.z = z;
    }

    /**
     * (c[0], c[1], c[2]) Œ`IuWFNg\zB
     * 
     * @param c		̔z
     * @param confirmedAsUnitized	悤ƂxNg
     *					PʃxNgł邱ƂĂȂ <code>true</code>A
     *					Ȃ <code>false</code>
     */
    JgclLiteralVector3D(double[] c, boolean confirmedAsUnitized) {
	super(confirmedAsUnitized);
	this.x = c[0];
	this.y = c[1];
	this.z = c[2];
    }

    /**
     * X ԂB
     * 
     * @return		xNg X 
     */
    public double x() {
	return this.x;
    }

    /**
     * Y ԂB
     * 
     * @return		xNg Y 
     */
    public double y() {
	return this.y;
    }

    /**
     * Z ԂB
     * 
     * @return		xNg Z 
     */
    public double z() {
	return this.z;
    }

    /**
     * ̃xNgA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclVector3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	if (reverseTransform == false)
	    return transformationOperator.transform(this);
	else
	    return transformationOperator.reverseTransform(this);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab
                       + getClassName() + " "
                       + x() + " "
                       + y() + " "
                       + z() + " End");
    }
}

