/*
 * Xg (Vector) ̊evfAvf̒lɏ]ďɃ\[gNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclListSorter.java,v 1.6 2000/04/26 09:39:05 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * Xg (Vector) ̊evf̈ʒuAvf̒lɏ]ďɃ\[gNXB
 * <p>
 * ̃NX static ȃ\bĥ݂B
 * </p>
 * <p>
 * ̃NX̃CX^X邱Ƃ͂łȂB
 * </p>
 *
 * @version $Revision: 1.6 $, $Date: 2000/04/26 09:39:05 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclListSorter {

    /**
     * ̃IuWFNǵu傫vrIuWFNg̃C^[tFCXB
     */
    public interface ObjectComparator {
	/**
	 * ҂O҂傫ۂԂB
	 *
	 * @param former	O
	 * @param latter	
	 * @return	҂O҂傫 trueAłȂ false
	 */
	boolean latterIsGreaterThanFormer(java.lang.Object former,
					  java.lang.Object latter);
    }

    /**
     * ̃NX̃CX^X͍ȂB
     */
    private JgclListSorter() {
    }

    /**
     * ^ꂽXg̊evf̈ʒuAvf̒lɏ]ďɃ\[gB
     *
     * @param list	\[g郊Xg
     * @param comparator	̃IuWFNǵu傫v𔻒肷IuWFNg
     */
    public static void doSorting(java.util.Vector list,
				 JgclListSorter.ObjectComparator comparator) {
	int low = 0;
	int up  = list.size() - 1;

	if (low < up)
	    doIt(list, low, up, comparator);
    }

    /**
     * ^ꂽXg̊evf̈ʒuAvf̒lɏ]ďɃ\[gB
     *
     * @param list	\[g郊Xg
     * @param low	\[g͈͂̉ (0 x[X)
     * @param up	\[g͈͂̏ (0 x[X)
     * @param comparator	̃IuWFNǵu傫v𔻒肷IuWFNg
     */
    private static void doIt(java.util.Vector list,
			     int low,
			     int up,
			     JgclListSorter.ObjectComparator comparator) {
	int lidx = low;
	int uidx = up;
	java.lang.Object lnode = list.elementAt(lidx);
	java.lang.Object unode = list.elementAt(uidx);
	java.lang.Object key   = list.elementAt((lidx + uidx) / 2);

	while (lidx < uidx) {
	    for (;
		 (lnode != key) && comparator.latterIsGreaterThanFormer(lnode, key);
		 lnode = list.elementAt(++lidx))
		; // nop

	    for (;
		 (key != unode) && comparator.latterIsGreaterThanFormer(key, unode);
		 unode = list.elementAt(--uidx))
		; // nop

	    if (lidx <= uidx) {
		list.insertElementAt(unode, lidx);
		list.removeElementAt(lidx + 1);
		list.insertElementAt(lnode, uidx);
		list.removeElementAt(uidx + 1);

		lidx++;
		uidx--;
		if (lidx <= (list.size() - 1))
		    lnode = list.elementAt(lidx);
		if (uidx >= 0)
		    unode = list.elementAt(uidx);
	    }
	}

	if (low  < uidx) doIt(list, low,  uidx, comparator);
	if (lidx < up)   doIt(list, lidx, up,   comparator);
    }
}

// end of file
