/*
 * 3D Ɖ~̌߂NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclIntsSphCyl3D.java,v 1.13 2000/08/11 06:18:53 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * 3D Ɖ~̌߂NX
 *
 * @version $Revision: 1.13 $, $Date: 2000/08/11 06:18:53 $
 * @author Information-technology Promotion Agency, Japan
 */
class JgclIntsSphCyl3D {
    /**
     * \|C̓_̐
     */
    static final int nst = 41;

    static JgclPoint3D UVpntfromT(JgclPoint3D c, JgclVector3D u, JgclVector3D v,
				  double r, double t) {
	double cost, sint;

	cost = Math.cos(t);
	sint = Math.sin(t);

	return c.add(u.multiply(cost).add(v.multiply(sint)).multiply(r));
    }

    /**
     * Ɖ~̌߂
     * 
     * @param Sph		
     * @param Cyl		~
     * @param doExchange	ʂ̋Ɖ~邩ǂ̃tO
     * @see JgclSphericalSurface3D
     * @see JgclCylindricalSurface3D
     * @see JgclSurfaceSurfaceInterference3D
     */
    static JgclSurfaceSurfaceInterference3D[]
    intersection(JgclSphericalSurface3D Sph, JgclCylindricalSurface3D Cyl, boolean doExchange) {
	JgclLine3D C_axis = new JgclLine3D(Cyl.position().location(), Cyl.position().z());
	JgclPoint3D projp = C_axis.project1From(Sph.position().location());
	double dist = projp.distance(Sph.position().location());
	double d_tol = Sph.getToleranceForDistance();

	if (dist < d_tol) {
	    /*
	     * ̒S~̎ɂ
	     */
	    if (Math.abs(Sph.radius() - Cyl.radius()) < d_tol) {
		/*
		 * a :
		 * ڂ~
		 */
		JgclAxis2Placement3D a2p
		    = new JgclAxis2Placement3D(Sph.position().location(),
					       Cyl.position().z(), Cyl.position().x());
		JgclCircle3D res
		    = new JgclCircle3D(a2p, (Cyl.radius() + Sph.radius()) / 2.0);
		JgclIntersectionCurve3D ints = Sph.curveToIntersectionCurve(res, Cyl, doExchange);
		JgclSurfaceSurfaceInterference3D[] sol = {ints};
		return sol;
	    }
	    if (Sph.radius() > Cyl.radius()) {
		/*
		 * ̔a~̔a傫 :
		 * ~
		 */
		double r = Math.sqrt(Sph.radius() * Sph.radius() - Cyl.radius() * Cyl.radius());
		JgclVector3D offset = Cyl.position().z().multiply(r);

		JgclAxis2Placement3D a2p
		    = new JgclAxis2Placement3D(Sph.position().location().add(offset),
					       Cyl.position().z(), Cyl.position().x());
		JgclCircle3D res = new JgclCircle3D(a2p, Cyl.radius());
		JgclIntersectionCurve3D ints1 = Sph.curveToIntersectionCurve(res, Cyl, doExchange);

		a2p = new JgclAxis2Placement3D(Sph.position().location().subtract(offset),
					       Cyl.position().z(), Cyl.position().x());
		res = new JgclCircle3D(a2p, Cyl.radius());
		JgclIntersectionCurve3D ints2 = Sph.curveToIntersectionCurve(res, Cyl, doExchange);

		JgclSurfaceSurfaceInterference3D[] sol = {ints1, ints2};
		return sol;
	    }
	    /*
	     * ̔a~̔a菬 :
	     * Ȃ
	     */
	    return new JgclSurfaceSurfaceInterference3D[0];
	}

	/*
	 * ̒S͉~̎ɂ͂Ȃ
	 */
	JgclVector3D Cu, Cv, Cw;	// new local axis

	Cw = Cyl.position().z();
	Cu = Sph.position().location().subtract(Cyl.position().location());
	Cv = Cw.crossProduct(Cu);
	Cu = Cv.crossProduct(Cw).unitized();
	Cv = Cv.unitized();

	if ((Math.abs(dist - (Cyl.radius() + Sph.radius())) < d_tol) ||
	    (Math.abs(dist - (Cyl.radius() - Sph.radius())) < d_tol)) {
	    /*
	     * ~ɊO/ڂ鋅 :
	     * 1_Őڂ
	     */
	    JgclPoint3D res;
	    if (Math.abs(dist - (Cyl.radius() + Sph.radius())) < d_tol)
		res = Sph.position().location().subtract(Cu.multiply(Sph.radius()));
	    else
		res = Sph.position().location().add(Cu.multiply(Sph.radius()));
	    JgclIntersectionPoint3D intsPnt =
		Sph.pointToIntersectionPoint(res, Cyl, doExchange);
	    JgclSurfaceSurfaceInterference3D[] intf = {intsPnt};
	    return intf;
	}
	if ((Math.abs(dist - (Sph.radius() - Cyl.radius())) < d_tol) ||
	    (dist < (Sph.radius() - Cyl.radius()))) {
	    /*
	     * 2ȐŌ :
	     * 8̎Ȑ
	     *   
	     * ʁX2Ȑ
	     */
	    JgclPoint3D[] pnts1, pnts2;
	    double[] dA = new double[3];	// coefficients of polynomial
	    JgclRealPolynomial pol;
	    double[] dX;			// roots of polynomial
	    double dX0, dX1;
	    double t;				// first parameter of Cylinder
	    double step;			// delta t
	    JgclPoint3D UVp;			// UV point of t
	    JgclVector3D evec;			// work area

	    pnts1 = new JgclPoint3D[nst];
	    pnts2 = new JgclPoint3D[nst];

	    step = JgclMath.PI2 / (nst - 1);
	    evec = Cyl.position().location().subtract(Sph.position().location());
	    dA[2] = 1.0;
	    dA[1] = 2.0 * evec.dotProduct(Cw);

	    for (int i = 0; i < nst; i++) {
		t = (- Math.PI) + step * i;
		UVp = UVpntfromT(Cyl.position().location(), Cu, Cv, Cyl.radius(), t);
		evec = UVp.subtract(Sph.position().location());
		dA[0] = evec.dotProduct(evec) - (Sph.radius() * Sph.radius());
		pol = new JgclRealPolynomial(dA);
		if ((dX = pol.getAlwaysRootsIfQuadric()) == null)
		    throw new JgclFatal();
		if (dX.length == 1)
		    dX0 = dX1 = dX[0];
		else if (dX[0] < dX[1]) {
		    dX0 = dX[1];
		    dX1 = dX[0];
		} else {
		    dX0 = dX[0];
		    dX1 = dX[1];
		}
		pnts1[i] = UVp.add(Cw.multiply(dX0));
		pnts2[i] = UVp.add(Cw.multiply(dX1));
	    }
	    JgclPolyline3D res = new JgclPolyline3D(pnts1);
	    JgclIntersectionCurve3D ints1 = Sph.curveToIntersectionCurve(res, Cyl, doExchange);
	    res = new JgclPolyline3D(pnts2);
	    JgclIntersectionCurve3D ints2 = Sph.curveToIntersectionCurve(res, Cyl, doExchange);
	    JgclSurfaceSurfaceInterference3D[] sol = {ints1, ints2};
	    return sol;
	}
	if ((dist < (Cyl.radius() - Sph.radius())) ||
	    (dist > (Cyl.radius() + Sph.radius()))) {
	    /*
	     * ͉~̊Oɂ邩Aɂ :
	     * Ȃ
	     */
	    return new JgclSurfaceSurfaceInterference3D[0];
	}

	/*
	 * ~Ƌ1ȐŌ
	 */
	JgclPoint3D[] pnts;
	int my_nst;
	JgclIntersectionPoint3D[] CCint;
	JgclVector3D evec;
	double t0;

	double[] dA = new double[3];	// coefficients of polynomial
	JgclRealPolynomial pol;
	double[] dX;			// roots of polynomial
	double dX0, dX1;
	double t;			// first parameter of Cylinder
	double step;			// delta t
	JgclPoint3D UVp;		// UV point of t
      
	my_nst = 2 * nst - 1;
	pnts = new JgclPoint3D[my_nst];
      
	/*
	 * parametric range [-t0, t0]
	 */
	JgclAxis2Placement3D a2p
	    = new JgclAxis2Placement3D(Sph.position().location(), Cyl.position().z(),
				       Cyl.position().x());
	JgclCircle3D Cir = new JgclCircle3D(a2p, Sph.radius());
	try {
	    CCint = Cir.intersect(Cyl);
	} catch (JgclIndefiniteSolution e) {
	    throw new JgclFatal();
	}
	evec = CCint[0].subtract(Cyl.position().location());
	evec = evec.project(Cw).unitized();
	t0 = Math.acos(evec.dotProduct(Cu));
      
	/*
	 * solution
	 */
	step = 2.0 * t0 / (nst - 1);
	evec = Cyl.position().location().subtract(Sph.position().location());
	dA[2] = 1.0;
	dA[1] = 2.0 * evec.dotProduct(Cw);

	t = (- t0);
	UVp = UVpntfromT(Cyl.position().location(), Cu, Cv, Cyl.radius(), t);
	evec = UVp.subtract(Sph.position().location());
	dA[0] = evec.dotProduct(evec) - (Sph.radius() * Sph.radius());
	pol = new JgclRealPolynomial(dA);
	if ((dX = pol.getAlwaysRootsIfQuadric()) == null)
	    throw new JgclFatal();
	pnts[0] = pnts[my_nst - 1] = UVp.add(Cw.multiply(dX[0]));

	for (int i = 1; i < (nst - 1); i++) {
	    t = (- t0) + i * step;
	    UVp = UVpntfromT(Cyl.position().location(), Cu, Cv, Cyl.radius(), t);
	    evec = UVp.subtract(Sph.position().location());
	    dA[0] = evec.dotProduct(evec) - (Sph.radius() * Sph.radius());
	    pol = new JgclRealPolynomial(dA);
	    if ((dX = pol.getAlwaysRootsIfQuadric()) == null)
		throw new JgclFatal();
	    if (dX[0] < dX[1]) {
		dX0 = dX[1];
		dX1 = dX[0];
	    } else {
		dX0 = dX[0];
		dX1 = dX[1];
	    }
	    pnts[i] = UVp.add(Cw.multiply(dX0));
	    pnts[my_nst - 1 - i] = UVp.add(Cw.multiply(dX1));
	}

	t = t0;
	UVp = UVpntfromT(Cyl.position().location(), Cu, Cv, Cyl.radius(), t);
	evec = UVp.subtract(Sph.position().location());
	dA[0] = evec.dotProduct(evec) - (Sph.radius() * Sph.radius());
	pol = new JgclRealPolynomial(dA);
	if ((dX = pol.getAlwaysRootsIfQuadric()) == null)
	    throw new JgclFatal();
	pnts[nst - 1] = UVp.add(Cw.multiply(dX[0]));

	JgclPolyline3D res = new JgclPolyline3D(pnts);
	JgclIntersectionCurve3D ints = Sph.curveToIntersectionCurve(res, Cyl, doExchange);
	JgclSurfaceSurfaceInterference3D[] sol = {ints};
	return sol;
    }
}
