/*
 * 3D Ɖ~̌߂NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclIntsSphCon3D.java,v 1.12 2000/08/11 06:18:53 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * 3D Ɖ~̌߂NX
 *
 * @version $Revision: 1.12 $, $Date: 2000/08/11 06:18:53 $
 * @author Information-technology Promotion Agency, Japan
 */
class JgclIntsSphCon3D {
    /**
     * foOtO(ʏfalse)
     */
    private static final boolean debug = false;

    /**
     * \|C̓_̐
     */
    private static final int nst = 41;

    /**
     * 
     * @see JgclSphericalSurface3D
     */
    private final JgclSphericalSurface3D Sph;

    /**
     * ~
     * @see JgclConicalSurface3D
     */
    private final JgclConicalSurface3D Con;

    private double d_tol;
    private double a_tol;

    private double C_cos, C_sin, C_tan;	// cos, sin & tan(Con.semiAngle)

    private JgclPoint3D C_org;		// Cone's local coordinates system (Corg is vertex)
    private JgclVector3D[] C_xyz;

    private JgclVector3D C2S;		// vector from vertex of Cone to center of Sphere
    private JgclVector3D S2C;		// opposite C2S
    private double distC2S;		// distance from center of Sphere to vetex of Cone

    /**
     * RXgN^
     *
     * @param Sph		
     * @param Con		~
     * @param doExchange	ʂ̋Ɖ~邩ǂ̃tO
     * @see JgclSphericalSurface3D
     * @see JgclConicalSurface3D
     */
    JgclIntsSphCon3D(JgclSphericalSurface3D Sph, JgclConicalSurface3D Con) {
	super();
	this.Sph = Sph;
	this.Con = Con;

	d_tol = Sph.getToleranceForDistance();
	a_tol = Sph.getToleranceForAngle();

	C_cos = Math.cos(Con.semiAngle());
	C_sin = Math.sin(Con.semiAngle());
	C_tan = Math.tan(Con.semiAngle());
	C_org = Con.position().location();
	C_xyz = Con.position().axes();
	C_org = C_org.subtract(C_xyz[2].multiply(Con.radius() / C_tan));

	C2S = Sph.position().location().subtract(C_org);
	S2C = C2S.reverse();
	distC2S = C2S.length();
    }

    private static JgclVector3D UVWpntfromT(JgclVector3D u, JgclVector3D v, JgclVector3D w,
					    double Ctan, double t) {
	double cost, sint;

	cost = Math.cos(t);
	sint = Math.sin(t);

	return u.multiply(cost).add(v.multiply(sint)).multiply(Ctan).add(w);
    }

    /**
     * ~ƂȂ𐶐
     * @param loc	~̒S
     * @param axis	~̏镽ʂ̖@
     * @param refDir	~̋ǏWnX
     * @param radius	~̔a
     * @param doExchange	ʂ̋Ɖ~邩ǂ̃tO
     * @see JgclPoint3D
     * @see JgclVector3D
     * @see JgclIntersectionCurve3D
     */
    private JgclIntersectionCurve3D makeCircle(JgclPoint3D loc, JgclVector3D axis,
					       JgclVector3D refDir, double radius,
					       boolean doExchange) {
	JgclAxis2Placement3D a2p = new JgclAxis2Placement3D(loc, axis, refDir);
	JgclCircle3D resC = new JgclCircle3D(a2p, radius);
	return Sph.curveToIntersectionCurve(resC, Con, doExchange);
    }

    /**
     * |CƂȂ𐶐
     * @param t0		|C̊Jn_\p[^
     * @param nst		|C̐ړ_̐()
     * @param Cu		~̋ǏU(狅̒SɌ)
     * @param Cv		~̋ǏV(CWCůOϕ)
     * @param Cw		~̋ǏW()
     * @param doExchange	ʂ̋Ɖ~邩ǂ̃tO
     * @see JgclVector3D
     * @see JgclIntersectionCurve3D
     */
    private JgclIntersectionCurve3D makePolyline(double t0, int nst,
						 JgclVector3D Cu, JgclVector3D Cv, JgclVector3D Cw,
						 boolean doExchange) {
	JgclPoint3D[] pnts = new JgclPoint3D[nst];
	double step;
	double a, b;	// coefficients
	double t, s;
	JgclVector3D evec;

	step = (2.0 * t0) / (nst - 1);
	a = C_tan * C_tan + 1.0;
	for (int i = 0; i < nst; i++) {
	    t = (- t0) + i * step;
	    evec = UVWpntfromT(Cu, Cv, Cw, C_tan, t);
	    b = 2.0 * evec.dotProduct(S2C);
	    s = (- b / a);
	    pnts[i] = C_org.add(evec.multiply(s));
	}

	JgclPolyline3D res = new JgclPolyline3D(pnts);
	return Sph.curveToIntersectionCurve(res, Con, doExchange);
    }

    /**
     * 2|CƂȂ𐶐
     * @param nst		|C̐ړ_̐()
     * @param Cu		~̋ǏU(狅̒SɌ)
     * @param Cv		~̋ǏV(CWCůOϕ)
     * @param Cw		~̋ǏW()
     * @param doExchange	ʂ̋Ɖ~邩ǂ̃tO
     * @see JgclVector3D
     * @see JgclSurfaceSurfaceInterference3D
     */
    private JgclSurfaceSurfaceInterference3D[]
    makeTwoPolyline(int nst,
		    JgclVector3D Cu, JgclVector3D Cv, JgclVector3D Cw,
		    boolean doExchange) {
	double step;
	JgclRealPolynomial pol;
	double[] dA = new double[3];	// coefficients
	double[] dX;			// roots
	double dX0, dX1;
	int icnt;
	double t;
	JgclVector3D evec;

	JgclPoint3D[] pnts1 = new JgclPoint3D[nst];
	JgclPoint3D[] pnts2 = new JgclPoint3D[nst];

	step = JgclMath.PI2 / (nst - 1);
	dA[2] = C_tan * C_tan + 1.0;
	dA[0] = distC2S * distC2S - (Sph.radius() * Sph.radius());
	for (int i = 0; i < nst; i++) {
	    t = (- Math.PI) + i * step;
	    evec = UVWpntfromT(Cu, Cv, Cw, C_tan, t);
	    dA[1] = 2.0 * evec.dotProduct(S2C);
	    pol = new JgclRealPolynomial(dA);
	    if ((dX = pol.getAlwaysRootsIfQuadric()) == null)
		throw new JgclFatal();
	    if (dX.length == 1) {
		dX0 = dX1 = dX[0];
	    } else if (dX[0] > dX[1]) {
		dX0 = dX[0];
		dX1 = dX[1];
	    } else {
		dX0 = dX[1];
		dX1 = dX[0];
	    }
	    pnts1[i] = C_org.add(evec.multiply(dX0));
	    pnts2[i] = C_org.add(evec.multiply(dX1));
	}

	JgclPolyline3D res = new JgclPolyline3D(pnts1);
	JgclIntersectionCurve3D ints1 = Sph.curveToIntersectionCurve(res, Con, doExchange);
	res = new JgclPolyline3D(pnts2);
	JgclIntersectionCurve3D ints2 = Sph.curveToIntersectionCurve(res, Con, doExchange);
	JgclSurfaceSurfaceInterference3D[] sol = {ints1, ints2};
	return sol;
    }

    /**
     * |CƂȂ~̈̑ɐ
     * @param nst		|C̐ړ_̐()
     * @param Cu		~̋ǏU(狅̒SɌ)
     * @param Cv		~̋ǏV(CWCůOϕ)
     * @param Cw		~̋ǏW()
     * @param doExchange	ʂ̋Ɖ~邩ǂ̃tO
     * @see JgclVector3D
     * @see JgclIntersectionCurve3D
     */
    private JgclIntersectionCurve3D
    makePolylineAtOneSide(int nst,
			  JgclVector3D Cu, JgclVector3D Cv, JgclVector3D Cw,
			  boolean doExchange) {
	JgclIntersectionPoint3D[] CSint;
	JgclVector3D evec;
	double ework;
	double t0;
	double step;
	JgclRealPolynomial pol;
	double[] dA = new double[3];	// coefficients
	double[] dX;			// roots
	double dX0, dX1;
	double t;

	int my_nst = 2 * nst - 1;
	JgclPoint3D[] pnts = new JgclPoint3D[my_nst];

	/*
	 * parametric range [-t0, t0]
	 */
	ework = Math.sqrt((distC2S * distC2S) - (Sph.radius() * Sph.radius()));
	JgclPoint3D loc = C_org.add(Cw.multiply(ework * C_cos));
	JgclAxis2Placement3D a2p
	    = new JgclAxis2Placement3D(loc, Con.position().z(), Con.position().x());
	JgclCircle3D Cir = new JgclCircle3D(a2p, ework * C_sin);
	try {
	    CSint = Cir.intersect(Sph);
	} catch (JgclIndefiniteSolution e) {
	    throw new JgclFatal();
	}
	if (CSint.length < 1) {
	    if (debug) {
		Cir.output(System.out);
		Sph.output(System.out);
	    }
	    throw new JgclFatal();
	}
	evec = CSint[0].subtract(Cir.position().location()).unitized();
	t0 = Math.acos(Cu.dotProduct(evec));

	step = (2.0 * t0) / (nst - 1);
	dA[2] = C_tan * C_tan + 1.0;
	dA[0] = distC2S * distC2S - (Sph.radius() * Sph.radius());
	for (int i = 0; i < (nst - 1); i++) {
	    t = (- t0) + i * step;
	    evec = UVWpntfromT(Cu, Cv, Cw, C_tan, t);
	    dA[1] = 2.0 * evec.dotProduct(S2C);
	    pol = new JgclRealPolynomial(dA);
	    if ((dX = pol.getAlwaysRootsIfQuadric()) == null)
		throw new JgclFatal();
	    if (dX.length == 1)
		dX0 = dX1 = dX[0];
	    else if (dX[0] < dX[1]) {
		dX0 = dX[1];
		dX1 = dX[0];
	    } else {
		dX0 = dX[0];
		dX1 = dX[1];
	    }
	    pnts[i]              = C_org.add(evec.multiply(dX0));
	    pnts[my_nst - 1 - i] = C_org.add(evec.multiply(dX1));
	}

	evec = UVWpntfromT(Cu, Cv, Cw, C_tan, t0);
	dA[1] = 2.0 * evec.dotProduct(S2C);
	pol = new JgclRealPolynomial(dA);
	if ((dX = pol.getAlwaysRootsIfQuadric()) == null)
	    throw new JgclFatal();
	if ((dX.length == 2) && (dX[0] < dX[1]))
	    dX[0] = dX[1];

	pnts[nst - 1] = C_org.add(evec.multiply(dX[0]));

	JgclPolyline3D res = new JgclPolyline3D(pnts);
	return Sph.curveToIntersectionCurve(res, Con, doExchange);
    }

    /**
     * ̒S~̎ɂA~̒_ɏĂ :
     * _Ɖ~ɂȂ
     * @param doExchange	ʂ̋Ɖ~邩ǂ̃tO
     * @see JgclSurfaceSurfaceInterference3D
     */
    private JgclSurfaceSurfaceInterference3D[] oneCircleOnePoint(boolean doExchange) {
	JgclIntersectionPoint3D intsP
	    = Sph.pointToIntersectionPoint(C_org, Con, doExchange);

	double ework = 2.0 * Sph.radius() * C_cos * C_cos;
	if (C2S.dotProduct(C_xyz[2]) < 0.0) ework *= -1.0;
	JgclIntersectionCurve3D intsC
	    = makeCircle(C_org.add(C_xyz[2].multiply(ework)), C_xyz[2], C_xyz[0],
			 2.0 * Sph.radius() * C_cos * C_sin, doExchange);

	JgclSurfaceSurfaceInterference3D[] sol = {intsP, intsC};
	return sol;
    }

    /**
     * ̒S~̎ɂA~̒_̓ɂ :
     * ~̂ꂼ̑ɉ~ł
     * @param doExchange	ʂ̋Ɖ~邩ǂ̃tO
     * @see JgclSurfaceSurfaceInterference3D
     */
    private JgclSurfaceSurfaceInterference3D[]
    twoCircleAtEachSide(boolean doExchange) {
	JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[2];
	double ework;
	double side = C2S.dotProduct(C_xyz[2]);

	for (int i = 0; i < 2; i++) {
	    if (i == 0) {
		ework = (- distC2S * C_cos) +
		    Math.sqrt((Sph.radius()*Sph.radius()) - (distC2S*distC2S)*(C_sin*C_sin));
		if (side > 0.0)
		    ework *= -1.0;
	    } else {
		ework = (distC2S * C_cos) +
		    Math.sqrt((Sph.radius()*Sph.radius()) - (distC2S*distC2S)*(C_sin*C_sin));
		if (side < 0.0)
		    ework *= -1.0;
	    }

	    sol[i] = makeCircle(C_org.add(C_xyz[2].multiply(ework * C_cos)),
				C_xyz[2], C_xyz[0], Math.abs(ework * C_sin), doExchange);
	}
	return sol;
    }

    /**
     * ̒S~̎ɂAƉ~ڂ :
     * ~
     * @param doExchange	ʂ̋Ɖ~邩ǂ̃tO
     * @see JgclSurfaceSurfaceInterference3D
     */
    private JgclSurfaceSurfaceInterference3D[] oneTangentCircle(boolean doExchange) {
	double ework = Sph.radius() * C_sin;
	if (C2S.dotProduct(C_xyz[2]) < 0.0)
	    ework *= -1.0;
	JgclIntersectionCurve3D intsC
	    = makeCircle(Sph.position().location().subtract(C_xyz[2].multiply(ework)),
			 C_xyz[2], C_xyz[0], Sph.radius() * C_cos, doExchange);
	JgclSurfaceSurfaceInterference3D[] sol = {intsC};
	return sol;
    }

    /**
     * ̒S~̎ɂA~̒_̊Oɂ :
     * ~̈̑ɉ~ł
     * @param doExchange	ʂ̋Ɖ~邩ǂ̃tO
     * @see JgclSurfaceSurfaceInterference3D
     */
    private JgclSurfaceSurfaceInterference3D[]
    twoCircleAtOneSide(boolean doExchange) {
	double ework = Math.sqrt((Sph.radius()*Sph.radius())-(distC2S*distC2S)*(C_sin*C_sin));
	double x1 = distC2S * C_cos + ework;
	double x2 = distC2S * C_cos - ework;
	if (C2S.dotProduct(C_xyz[2]) < 0.0) {
	    x1 *= -1.0;
	    x2 *= -1.0;
	}

	JgclIntersectionCurve3D intsC1
	    = makeCircle(C_org.add(C_xyz[2].multiply(x1 * C_cos)), 
			 C_xyz[2], C_xyz[0], Math.abs(x1 * C_sin), doExchange);

	JgclIntersectionCurve3D intsC2
	    = makeCircle(C_org.add(C_xyz[2].multiply(x2 * C_cos)),
			 C_xyz[2], C_xyz[0], Math.abs(x2 * C_sin), doExchange);

	JgclSurfaceSurfaceInterference3D[] sol = {intsC1, intsC2};
	return sol;
    }

    /**
     * ~̒_ɏĂꍇ
     * @param doExchange	ʂ̋Ɖ~邩ǂ̃tO
     * @see JgclSurfaceSurfaceInterference3D
     */
    private JgclSurfaceSurfaceInterference3D[]
    vertexOfConeIsOnSphere(boolean doExchange) {
	JgclVector3D Cu, Cv, Cw;	// new local axis
	JgclVector3D CuR, CvR, CwR;	// reversed;
	double cosd;			// dot-product(C2S, Cw) / distC2S
	double acosd;
	boolean revSide;

	Cw = C_xyz[2];
	Cv = Cw.crossProduct(C2S);
	Cu = Cv.crossProduct(Cw);
	Cu = Cu.unitized();
	Cv = Cv.unitized();

	CuR = Cu;
	CvR = Cv.reverse();
	CwR = Cw.reverse();

	cosd = C2S.dotProduct(Cw) / distC2S;
	if (cosd < 0.0) {
	    revSide = true;
	    cosd *= -1.0;
	} else
	    revSide = false;
	if (cosd > 1.0) cosd = 1.0;
	acosd = Math.acos(cosd);

	if (Math.abs(acosd - ((Math.PI / 2) - Con.semiAngle())) < a_tol) {
	    /*
	     * ~̒_܂ދȐ
	     */
	    JgclIntersectionCurve3D ints;
	    if (!revSide)
		ints = makePolyline(Math.PI, nst, Cu, Cv, Cw, doExchange);
	    else
		ints = makePolyline(Math.PI, nst, CuR, CvR, CwR, doExchange);
	    JgclSurfaceSurfaceInterference3D[] sol = {ints};
	    return sol;
	}

	if (acosd < ((Math.PI / 2) - Con.semiAngle())) {
	    /*
	     * ~̒_ƁAȐ
	     */
	    JgclIntersectionCurve3D intsC;
	    if (!revSide)
		intsC = makePolyline(Math.PI, nst, Cu, Cv, Cw, doExchange);
	    else
		intsC = makePolyline(Math.PI, nst, CuR, CvR, CwR, doExchange);

	    JgclIntersectionPoint3D intsP
		= Sph.pointToIntersectionPoint(C_org, Con, doExchange);

	    JgclSurfaceSurfaceInterference3D[] sol = {intsC, intsP};
	    return sol;
	}

	/*
	 * 8̎Ȑ`
	 */
	double t0;	// the starting point

	if (Math.abs(acosd - (Math.PI / 2.0)) < a_tol)
	    t0 = Math.PI / 2.0;
	else
	    t0 = Math.acos(- (1.0 / Math.tan(acosd)) / C_tan);

	JgclIntersectionCurve3D ints1
	    = makePolyline(t0, nst, Cu, Cv, Cw, doExchange);

	JgclIntersectionCurve3D ints2
	    = makePolyline(t0, nst, CuR, CvR, CwR, doExchange);

	JgclSurfaceSurfaceInterference3D[] sol = {ints1, ints2};
	return sol;
    }

    /**
     * ~̒_̓ɑ݂ꍇ :
     * |C2
     * @param doExchange	ʂ̋Ɖ~邩ǂ̃tO
     * @see JgclSurfaceSurfaceInterference3D
     */
    private JgclSurfaceSurfaceInterference3D[]
    vertexOfConeIsInSphere(boolean doExchange) {
	JgclVector3D Cu, Cv, Cw;		// new local axis

	Cw = C_xyz[2];
	Cv = Cw.crossProduct(C2S);
	Cu = Cv.crossProduct(Cw);
	Cu = Cu.unitized();
	Cv = Cv.unitized();

	if (C2S.dotProduct(Cw) < 0.0) {
	    Cu = Cu;
	    Cv = Cv.reverse();
	    Cw = Cw.reverse();
	}

	return makeTwoPolyline(nst, Cu, Cv, Cw, doExchange);
    }

    /**
     * ~̒_̊Oɑ݂ꍇ
     * @param doExchange	ʂ̋Ɖ~邩ǂ̃tO
     * @see JgclSurfaceSurfaceInterference3D
     */
    private JgclSurfaceSurfaceInterference3D[]
    vertexOfConeIsNotInSphere(boolean doExchange) {
	JgclVector3D Cu, Cv, Cw;	// new local axis
	JgclVector3D CuR, CvR, CwR;	// reversed;
	double cosd;			// dot-product(C2S, Cw) / distC2S
	double alpha, theta, phi;
	boolean revSide;

	Cw = C_xyz[2];
	Cv = Cw.crossProduct(C2S);
	Cu = Cv.crossProduct(Cw);
	Cu = Cu.unitized();
	Cv = Cv.unitized();

	CuR = Cu;
	CvR = Cv.reverse();
	CwR = Cw.reverse();

	cosd = C2S.dotProduct(Cw) / distC2S;
	if (cosd < 0.0) {
	    revSide = true;
	    cosd *= -1.0;
	} else
	    revSide = false;
	if (cosd > 1.0) cosd = 1.0;

	alpha = Con.semiAngle();
	theta = Math.asin(Sph.radius() / distC2S);
	phi = Math.acos(cosd);

	if ((Math.abs(phi - (alpha + theta)) < a_tol) ||
	    (Math.abs(phi - (alpha - theta)) < a_tol)) {
	    /*
	     * 1_2_ŊOڂ
	     */
	    if (revSide) {
		Cu = CuR;
		Cv = CvR;
		Cw = CwR;
	    }

	    double ework = Math.sqrt(distC2S * distC2S - Sph.radius() * Sph.radius());

	    JgclPoint3D resP = C_org.add(Cw.multiply(ework * C_cos));
	    resP = resP.add(Cu.multiply(ework * C_sin));
	    JgclIntersectionPoint3D intsP = Sph.pointToIntersectionPoint(resP, Con, doExchange);

	    if ((Math.abs(phi - (alpha + theta)) < a_tol) &&
		(Math.abs(phi - Math.PI / 2.0) < a_tol)) {
		/*
		 * 2 points
		 */
		resP = C_org.subtract(Cw.multiply(ework * C_cos));
		resP = resP.add(Cu.multiply(ework * C_sin));
		JgclIntersectionPoint3D intsP2
		    = Sph.pointToIntersectionPoint(resP, Con, doExchange);
		JgclSurfaceSurfaceInterference3D[] intf = {intsP, intsP2};
		return intf;
	    }
	    JgclSurfaceSurfaceInterference3D[] intf = {intsP};
	    return intf;
	}

	if ((phi > (alpha + theta)) || (phi < (alpha - theta))) {
	    /*
	     * ݂͑Ȃ
	     */
	    return new JgclSurfaceSurfaceInterference3D[0];
	}

	if ((Math.abs(theta - (alpha + phi)) < a_tol) ||
	    (theta > (alpha + phi))) {
	    /*
	     * an 8 figure curve
	     *   or
	     * 2 curves
	     */
	    if (revSide) {
		Cu = CuR;
		Cv = CvR;
		Cw = CwR;
	    }
	    return makeTwoPolyline(nst, Cu, Cv, Cw, doExchange);
	}

	/*
	 * 1 curve
	 *   or
	 * 1 curve + 1 more point at another side
	 *   or
	 * 1 curve + 1 more curve at another side
	 */

	/*
	 * ܂~̈̑ɋȐ
	 */
	JgclIntersectionCurve3D ints;
	if (!revSide)
	    ints = makePolylineAtOneSide(nst, Cu, Cv, Cw, doExchange);
	else
	    ints = makePolylineAtOneSide(nst, CuR, CvR, CwR, doExchange);

	if (Math.abs(Math.PI - (theta + phi + alpha)) < a_tol) {
	    /*
	     * ɉ~̑̑1_ŊO
	     */
	    if (!revSide) {
		Cu = CuR;
		Cv = CvR;
		Cw = CwR;
	    }

	    double ework = Math.sqrt(distC2S * distC2S - Sph.radius() * Sph.radius());

	    JgclPoint3D resP = C_org.add(Cw.multiply(ework * C_cos));
	    resP = resP.add(Cu.multiply(ework * C_sin));
	    JgclIntersectionPoint3D intsP = Sph.pointToIntersectionPoint(resP, Con, doExchange);

	    JgclSurfaceSurfaceInterference3D[] sol = {ints, intsP};
	    return sol;
	}
	if (theta + phi + alpha > Math.PI) {
	    /*
	     * ɉ~̑̑ɂȐ
	     */
	    if (!revSide) {
		Cu = CuR;
		Cv = CvR;
		Cw = CwR;
	    }
	    JgclIntersectionCurve3D ints2 = makePolylineAtOneSide(nst, Cu, Cv, Cw, doExchange);

	    JgclSurfaceSurfaceInterference3D[] sol = {ints, ints2};
	    return sol;
	}

	JgclSurfaceSurfaceInterference3D[] sol = {ints};
	return sol;
    }

    /**
     * ߂
     *
     * @param doExchange	ʂ̋Ɖ~邩ǂ̃tO
     * @see JgclSurfaceSurfaceInterference3D
     */
    JgclSurfaceSurfaceInterference3D[]
    getInterference(boolean doExchange) {
	JgclSurfaceSurfaceInterference3D[] intf;
	JgclLine3D C_axis = new JgclLine3D(C_org, C_xyz[2]);	// axis of Cone
	JgclPoint3D projp = C_axis.project1From(Sph.position().location());

	if (projp.distance(Sph.position().location()) < d_tol) {
	    /*
	     * ̒S~̎ɂ :
	     * ͓_~ŕ\
	     */

	    /*
	     * ~̒_ɏĂ :
	     * _Ɖ~ɂȂ
	     */
	    if (Math.abs(distC2S - Sph.radius()) < d_tol) {
		return oneCircleOnePoint(doExchange);
	    }

	    /*
	     * ~̒_̓ɂ :
	     * ~̂ꂼ̑ɉ~ł
	     */
	    if (distC2S < Sph.radius()) {
		return twoCircleAtEachSide(doExchange);
	    }

	    /*
	     * Ɖ~ڂ :
	     * ~
	     */
	    if (Math.abs(distC2S - (Sph.radius() / C_sin)) < d_tol) {
		return oneTangentCircle(doExchange);
	    }

	    /*
	     * ~̒_̊Oɂ :
	     * ~̈̑ɉ~ł
	     */
	    if (distC2S < (Sph.radius() / C_sin)) {
		return twoCircleAtOneSide(doExchange);
	    }

	    /*
	     * ~ɓɋ݂
	     * ݂͑Ȃ
	     */
	    return new JgclSurfaceSurfaceInterference3D[0];
	}

	/*
	 * ~̒_ɏĂꍇ
	 */
	if (Math.abs(distC2S - Sph.radius()) < d_tol) {
	    return vertexOfConeIsOnSphere(doExchange);
	}

	/*
	 * ~̒_̓ɑ݂ꍇ
	 */
	if (distC2S < Sph.radius()) {
	    return vertexOfConeIsInSphere(doExchange);
	}

	/*
	 * ~̒_̊Oɑ݂ꍇ
	 */
	return vertexOfConeIsNotInSphere(doExchange);
    }
}
