/*
 * 2D̒Ɖ~Ȑ̌_߂NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclIntsLinCnc2D.java,v 1.12 2000/08/11 06:18:52 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.Vector;

/**
 * 2D̒Ɖ~Ȑ̌_߂NX
 *
 * @version $Revision: 1.12 $, $Date: 2000/08/11 06:18:52 $
 * @author Information-technology Promotion Agency, Japan
 */

class JgclIntsLinCnc2D {

    private JgclLine2D line;
    private JgclConic2D conic;

    JgclIntsLinCnc2D(JgclLine2D line, JgclConic2D conic) {
	super();

	this.line = line;
	this.conic = conic;
    }

    /**
     *  2̌W𓾂
     *
     * @param coef	2̌W
     * @return		2̉
     */
    private double[] getRoot(double[] coef) {
	JgclRealPolynomial poly;
	try {
	    poly = new JgclRealPolynomial(coef);
	}
	catch (JgclInvalidArgumentValue e) {
	    throw new JgclFatal();
	}

	// solve quadratic equation
	double[] root = poly.getRootsIfQuadric();
	return root;
    }

    /**
     *  2̉d폜
     *
     * @param root	2̌W
     * @return		d̖2̉
     */
    private double[] checkDuplicate(JgclLine2D line, double[] root) {
	double dTol2 =  line.getToleranceForDistance2();
	double[] realRoot;

	if (root == null) {		// for no root
	    return null;
	}

	if (root.length == 2) {	// for duplicate roots
	    double diff = Math.abs(root[1] - root[0]);
	    if (diff * diff * line.dir().norm() < dTol2)
	    {
		realRoot = new double[1];
		realRoot[0] = root[0];
	    } else {
		realRoot = root;
	    }
	} else {
	    realRoot = root;
	}

	return realRoot;
    }

    /**
     *  2̉_߂
     *
     * @param line	
     * @param conic	~Ȑ
     * @param root	2̌W
     * @return		_̔z
     */
    private JgclIntersectionPoint2D[]
	getIntersect(JgclLine2D line, JgclConic2D conic, double[] root, boolean doExchange)
    {
	// get intersections
	Vector intervec = new Vector();
	for (int i = 0; i < root.length; i++) {
	    // get parameter
	    double eApara = root[i];
	    JgclPoint2D etmp = line.coordinates(eApara);
	    double eBpara;
	    try {
		eBpara = conic.pointToParameter(etmp);
	    } catch (JgclInvalidArgumentValue e) {
		continue;
	    }

	    // make intersection points
	    JgclPointOnCurve2D pntA = new JgclPointOnCurve2D(line, eApara, JgclGeometry.doCheckDebug);
	    JgclPointOnCurve2D pntB = new JgclPointOnCurve2D(conic, eBpara, JgclGeometry.doCheckDebug);
	    JgclIntersectionPoint2D inter;
	    if (!doExchange) {
		inter = new JgclIntersectionPoint2D(pntB, pntA, pntB, JgclGeometry.doCheckDebug);
	    } else {
		inter = new JgclIntersectionPoint2D(pntB, pntB, pntA, JgclGeometry.doCheckDebug);
	    }
	    if (inter != null && pntA.identical(pntB)) { // identical check
		intervec.addElement(inter);
	    }
	}

	JgclIntersectionPoint2D[] intersectPoints = new 
	    JgclIntersectionPoint2D[intervec.size()];
	intervec.copyInto(intersectPoints);
	return intersectPoints;
    }

    /**
     * Ɖ~̌_߂邽߂2̌W𓾂
     *
     * @param line	
     * @param circle	~
     * @return		2̌W
     */
    private double[] getCoef(JgclLine2D line, JgclCircle2D circle) {
	/*
	 * NOTE:
	 *
	 * equation of intersection are
	 *
	 *	x = Px + u * Vx  =  r * cosT
	 *	y = Py + u * Vy  =  r * sinT
	 *
	 * , so a polynomial of u is
	 *
	 *	A0 * u**2 + A1 * u + A2 = 0
	 *
	 *		A0 = Vx**2 + Vy**2
	 *		A1 = 2*(Px*Vx +Py*Vy)
	 *		A2 = Px**2 + Py**2 - r**2
	 */

	double[] ercoef = new double[3];

	JgclVector2D eApnt = line.pnt().subtract(circle.position().location());

	ercoef[2] = line.dir().x() * line.dir().x() +
	            line.dir().y() * line.dir().y();
	ercoef[1] = 2.0 * ( eApnt.x() * line.dir().x() +
			    eApnt.y() * line.dir().y());
	ercoef[0] = eApnt.x() * eApnt.x() + eApnt.y() * eApnt.y() -
		    circle.radius() * circle.radius();

	return ercoef;
    }

    /**
     * Ɖ~̌_߂
     *
     * @param line	
     * @param circle	~
     * @return		_
     * @see		JgclIntersectionPoint2D
     */
    JgclIntersectionPoint2D[] intersection(JgclLine2D line,
                                           JgclCircle2D circle, boolean doExchange)
    {
	double[] ercoef = getCoef(line, circle);
	double[] root = getRoot(ercoef);	// solving equation
	if (root == null) {	// for no root
	    return new JgclIntersectionPoint2D[0];
	}
  	double[] realRoot = checkDuplicate(line, root);	// duplicate check
  	return getIntersect(line, circle, realRoot, doExchange);
     }

    /**
     * Ƒȉ~̌_߂邽߂2̌W𓾂
     *
     * @param line	
     * @param ell	ȉ~
     * @return		2̌W
     */
    private double[] getCoef(JgclLine2D line, JgclEllipse2D ell) {
	/*
	 * NOTE:
	 *
	 * equation of intersection is
	 *
	 *	x**2/A**2 + y**2/B**2 = 1   ( A = dBlrd, B = dBsrd )
	 *		x = Px + t * Vx
	 *		y = Py + t * Vy
	 *
	 * , so a polynomial of cosT is
	 *
	 *	A0 * t2 + 2 * A1 * t + A2 = 0
	 *		( A0 = A**2 * Vy**2 + B**2 * Vx**2 )
	 *		( A1 = 2 * ( A**2 * Py * Vy + B**2 * Px * Vx ) )
	 *		( A2 = A**2 * Py**2 + B**2 * Px**2 - A**2 * B**2 )
	 */

	double dBlrd, dBsrd;	/* longer / shorter radius of B */
	JgclCartesianTransformationOperator2D trans;

	if (ell.semiAxis1() < ell.semiAxis2()) {
	    dBlrd = ell.semiAxis2();
	    dBsrd = ell.semiAxis1();
	    try {
		JgclAxis2Placement2D axis =
		    new JgclAxis2Placement2D(ell.position().location(), 
					     ell.position().y());
		trans = new JgclCartesianTransformationOperator2D(axis, 1.0);
	    }
	    catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }
	}
	else {
	    dBlrd = ell.semiAxis1();
	    dBsrd = ell.semiAxis2();
	    try {
		trans = new JgclCartesianTransformationOperator2D(ell.position(), 1.0);
	    }
	    catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }
	}

	// vector from B's center to A
	JgclVector2D Bc2A = line.pnt().subtract(ell.position().location());

	// inverse rotated point
	JgclVector2D eAirpnt = trans.toLocal(Bc2A);
 	JgclVector2D eAirvec = trans.toLocal(line.dir());

	// make polynomial
	double eA2 = dBlrd * dBlrd;
	double eB2 = dBsrd * dBsrd;

	// coefficients of polynomial (real)
	double[] ercoef = new double[3];

	ercoef[2] = eA2 * eAirvec.y() * eAirvec.y() +
	            eB2 * eAirvec.x() * eAirvec.x();
	ercoef[1] = 2.0 * ( eA2 * eAirpnt.y() * eAirvec.y() +
			    eB2 * eAirpnt.x() * eAirvec.x());
	ercoef[0] = eA2 * eAirpnt.y() * eAirpnt.y() +
	            eB2 * eAirpnt.x() * eAirpnt.x() -
		    eA2 * eB2;

	return ercoef;
    }

    /**
     * Ƒȉ~̌_߂
     *
     * @param line	
     * @param ell	ȉ~
     * @return		_
     * @see		JgclIntersectionPoint2D
     */
    JgclIntersectionPoint2D[] intersection(JgclLine2D line,
						  JgclEllipse2D ell, boolean doExchange)
    {
	double[] ercoef = getCoef(line, ell);
	double[] root = getRoot(ercoef);	// solving equation
	if (root == null) {	// for no root
	    return new JgclIntersectionPoint2D[0];
	}
	double[] realRoot = checkDuplicate(line, root);	// duplicate check
	return getIntersect(line, ell, realRoot, doExchange);
     }

    /**
     * ƕ̌_߂邽߂2̌W𓾂
     *
     * @param line	
     * @param par	
     * @return		2̌W
     */
    private double[] getCoef(JgclLine2D line, JgclParabola2D par) {
	/*
	 * NOTE:
	 *
	 * equation of intersection is
	 *
	 *	x = Px + u * Vx  =  a * t**2
	 *	y = Py + u * Vy  =  2 * a * t
	 *
	 * , so a polynomial of u is
	 *
	 *	Vy**2 * u**2 + 2(Py*Vy - 2*a*Vx) * u + Py**2 - 4*a*Px = 0
	 */
	
	JgclCartesianTransformationOperator2D trans;
	
	try {
	    trans = new JgclCartesianTransformationOperator2D(par.position(), 1.0);
	}
	catch (JgclInvalidArgumentValue e) {
	    throw new JgclFatal();
	}
	// vector from B's center to A
	JgclVector2D Bc2A = line.pnt().subtract(par.position().location());

	// inverse rotated point
	JgclVector2D eAirpnt = trans.reverseTransform(Bc2A);
	JgclVector2D eAirvec = trans.reverseTransform(line.dir());

	// coefficients of polynomial (real)
	double[] ercoef = new double[3];

	// make polynomial
	ercoef[2] = eAirvec.y() * eAirvec.y();
	ercoef[1] = 2.0 * (eAirpnt.y() * eAirvec.y() - 2.0 *
			   par.focalDist() * eAirvec.x());
	ercoef[0] = eAirpnt.y() * eAirpnt.y() -
		    4.0 * par.focalDist() * eAirpnt.x();

	return ercoef;
    }

    /**
     * ƕ̌_߂
     *
     * @param line	
     * @param par	
     * @return		_
     * @see		JgclIntersectionPoint2D
     */
    JgclIntersectionPoint2D[] intersection(JgclLine2D line,
						  JgclParabola2D par, boolean doExchange)
    {
	double[] ercoef = getCoef(line, par);
	double[] root = getRoot(ercoef);	// solving equation
	if (root == null) {	// for no root
	    return new JgclIntersectionPoint2D[0];
	}
	double[] realRoot = checkDuplicate(line, root);	// duplicate check
	return getIntersect(line, par, realRoot, doExchange);
     }

    /**
     * ƕ̌_߂邽߂2̌W𓾂
     *
     * @param line	
     * @param hyp	
     * @return		2̌W
     */
    private double[] getCoef(JgclLine2D line, JgclHyperbola2D hyp) {
	/*
	 * NOTE:
	 *
	 * equation of intersection are
	 *
	 *	x = Px + u * Vx  =  a * coshT
	 *	y = Py + u * Vy  =  b * sinhT
	 *
	 * , so the polynomial of sinhT is
	 *
	 *	A0 * sinhT**2 + A1 * sinhT + A2 = 0
	 *		A0 = (a*Vy)**2 - (b*Vx)**2
	 *		A1 = -2*(b*Vx)*(Px*Vy - Py*Vx )
	 *		A2 = (a*Vy)**2 - (Px*Vy - Py*Vx )**2
	 *
	 * , and the polynomial of u is
	 *
	 *	A0 * u**2 + A1 * u + A2 = 0
	 *		A0 = (b*Vx)**2  - (a*Vy)**2
	 *		A1 = 2 * (b**2 * Px * Vx - a**2 * Py * Vy)
	 *		A2 = (b**2 * Px**2 - a**2 * Py**2) - a**2 * b**2
	 */

	JgclCartesianTransformationOperator2D trans;

	try {
	    trans = new JgclCartesianTransformationOperator2D(hyp.position(), 1.0);
	}
	catch (JgclInvalidArgumentValue e) {
	    throw new JgclFatal();
	}
	// vector from B's center to A
	JgclVector2D Bc2A = line.pnt().subtract(hyp.position().location());

	// inverse rotated point
	JgclVector2D eAirpnt = trans.reverseTransform(Bc2A);
	JgclVector2D eAirvec = trans.reverseTransform(line.dir());

	// make polynomial
	double eA2 = hyp.semiAxis() * hyp.semiAxis();
	double eB2 = hyp.semiImagAxis() * hyp.semiImagAxis();

	// coefficients of polynomial (real)
	double[] ercoef = new double[3];

	ercoef[2] = eB2 * eAirvec.x() * eAirvec.x() -
		    eA2 * eAirvec.y() * eAirvec.y();
	ercoef[1] = 2.0 * (eB2 * eAirpnt.x() * eAirvec.x() -
			   eA2 * eAirpnt.y() * eAirvec.y());
	ercoef[0] = eB2 * eAirpnt.x() * eAirpnt.x() -
		    eA2 * eAirpnt.y() * eAirpnt.y() - eA2 * eB2;

	return ercoef;
    }

    /**
     * ƕ̌_߂
     *
     * @param line	
     * @param hyp	
     * @return		_
     * @see		JgclIntersectionPoint2D
     */
    JgclIntersectionPoint2D[] intersection(JgclLine2D line,
					   JgclHyperbola2D hyp, boolean doExchange)
    {
	double[] ercoef = getCoef(line, hyp);
	double[] root = getRoot(ercoef);	// solving equation
	if (root == null) {	// for no root
	    return new JgclIntersectionPoint2D[0];
	}
	double[] realRoot = checkDuplicate(line, root);	// duplicate check
	return getIntersect(line, hyp, realRoot, doExchange);
     }
}
