/*
 * 3DV_m̌_߂NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclIntsCylCyl3D.java,v 1.21 2000/08/11 06:18:52 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * RFV_m̌_߂NX
 * <p>
 * ~m̌́AQ̈ʒu֌WɂďꍇāAꂼꋁ߂B
 * ~m̈ʒu֌WɂAPOʂ̏ꍇ݂B
 * </p>
 * @version $Revision: 1.21 $, $Date: 2000/08/11 06:18:52 $
 * @author Information-technology Promotion Agency, Japan
 */

class JgclIntsCylCyl3D {
    /**
     * 2V_̊֌W\邽߂̒萔
     */
    /**
     * V_v
     */
    private static final int COINCIDENT = 0;

    /**
     * V_̎s̏
     */
    private static final int PARALLEL = 1;

    /**
     * V_̎sV_mڐGȂ
     */
    private static final int PARALLEL_NO_TOUCH = 2;

    /**
     * V_̎sV_mڐG
     */
    private static final int PARALLEL_TOUCH = 3;

    /**
     * V_̎sV_m
     */
    private static final int PARALLEL_INTERSECT = 4;

    /**
     * V_̎邩a
     */
    private static final int INTERSECT_SAME_RADIUS = 5;

    /** 
     * V_̎Ȃ
     * ̃V_̃V_ƌȂ
     */
    private static final int NO_INTERSECT_OUT_OF_LINE = 6;

    /**
     * V_̎Ȃ
     * ̃V_̂̃V_ƊSɓŌ
     */
    private static final int NO_INTERSECT_BETWEEN_LINE = 7;

    /**
     * V_̎Ȃ
     * ̃V_̃V_ƊOŐڐG
     */
    private static final int NO_INTERSECT_TOUCH_OUTSIDE = 8;

    /**
     * V_̎Ȃ
     * ̃V_̃V_ƓŐڐG
     */
    private static final int NO_INTERSECT_TOUCH_INSIDE = 9;

    /** 
     * V_̎Ȃ
     * ̃V_̃V_ƕIɌ
     */
    private static final int NO_INTERSECT_LINE_INTERSECT = 10;

    /**
     * V_
     */
    private JgclCylindricalSurface3D bCyl;

    /**
     * V_
     */
    private JgclCylindricalSurface3D sCyl;

    /**
     * V_̌_
     */
    private JgclPoint3D bOrg;

    /**
     * V_̌_
     */
    private JgclPoint3D sOrg;

    /**
     * V_̎
     */
    private JgclLine3D bAxis;

    /**
     * V_̎
     */
    private JgclLine3D sAxis;

    /**
     * PʃxNg
     */
    private JgclVector3D bCylU;
    private JgclVector3D bCylV;
    private JgclVector3D bCylW;

    /**
     * V_m̎̓
     */
    private double w1w2;

    /**
     * \|C̓_̐
     */
    private static final int nst = 41;

    /**
     * V_邩ǂ̃tO
     */
    private boolean doExchange;

    /**
     * ̌_(ȉ~̒Sɗp)
     */
    private JgclIntersectionPoint3D axisIntsP;

    /**
     * V_̐ƏV_̌_
     */
    private JgclIntersectionPoint3D[] bLineSCylIntsP;


    /**
     * 2̉~ƌʂ邩ǂ̃tO^
     * ߂邽߂̃IuWFNg\zB
     *
     * @param cyl1         V_
     * @param cyl2         V_
     * @param doExchange   V_邩ǂ̃tO
     */
    private JgclIntsCylCyl3D(JgclCylindricalSurface3D cyl1,
			     JgclCylindricalSurface3D cyl2,
			     boolean doExchange) {
	//
	// ȃ傫Ȃǂ𒲂ׁAelݒ肷
	//
	if (cyl1.radius() < cyl2.radius()) {
	    sCyl = cyl1;
	    bCyl = cyl2;
	    this.doExchange = !doExchange;
	}
	else {
	    sCyl = cyl2;
	    bCyl = cyl1;
	    this.doExchange = doExchange;
	}

	JgclAxis2Placement3D bPosition = bCyl.position();
	JgclAxis2Placement3D sPosition = sCyl.position();

	bOrg = bPosition.location();
	sOrg = sPosition.location(); 

	bAxis = bCyl.getAxis();
	sAxis = sCyl.getAxis();

	bCylW = bPosition.z();
	bCylV = bCylW.crossProduct(sOrg.subtract(bOrg)).unitized();
	bCylU = bCylV.crossProduct(bCylW).unitized();
	w1w2 = bAxis.dir().dotProduct(sAxis.dir());

    }

    /**
     * V_̎ʂ镽ʂƂ̃V_Ăł
     *
     * @return        2{̌
     */
    private JgclLine3D[] makeLinesOnCylinder() {
	JgclVector3D zOfSCyl = sAxis.dir();
	JgclVector3D zOfBCyl = bAxis.dir();
	JgclVector3D evec = zOfSCyl.crossProduct(zOfBCyl);

	JgclVector3D axis = evec.crossProduct(zOfBCyl);
	JgclVector3D refDirection = zOfBCyl;
	JgclPoint3D location = bCyl.position().location();

	JgclPlane3D bPlane = new JgclPlane3D
	    (new JgclAxis2Placement3D(location, axis, refDirection));

	try {
	    JgclSurfaceSurfaceInterference3D[] intf = bCyl.intersect(bPlane);
	    int nSol = intf.length;
	    JgclLine3D[] lines = new JgclLine3D[nSol];
	    for (int i = 0; i < nSol; i++) {
		JgclParametricCurve3D curve = intf[i].toIntersectionCurve().curve3d();
		if (curve instanceof JgclLine3D) {
		    lines[i] = (JgclLine3D)curve;
		}
	    }
	    return lines;
	} catch (JgclIndefiniteSolution e) {
	    throw new JgclFatal();
	}
    }

    /**
     * V_m̎sȏԂɂāAȂԂ𒲂ׂĕԂ
     * <p>
     * V_m̎sȂƂAɍׂ3̏ꍇɕB
     * 𔻕ʂĂяoɒ萔lƂĕԋpB
     * </p>
     * @return        V_m̏Ԃ\
     */
    private int getRelationInParallel() {
	JgclPoint3D source = sOrg;
	JgclPointOnCurve3D[] foot = bAxis.projectFrom(source);
	if (foot.length != 1) throw new JgclFatal();
	double dist = source.distance(foot[0]);
	double dTol = bCyl.getToleranceForDistance();
	double bRadius = bCyl.radius();
	double sRadius = sCyl.radius();

	if (Math.abs(dist - (bRadius + sRadius)) < dTol
	    || Math.abs(dist - (bRadius - sRadius)) < dTol)
	    return PARALLEL_TOUCH;
	else if (dist > (bRadius + sRadius)
		 || dist < (bRadius - sRadius))
	    return PARALLEL_NO_TOUCH;
	else
	    return PARALLEL_INTERSECT;
    }

    /**
     * V_m̎słȂԂɂāAȂԂ𒲂ׂĕԂ
     * <p>
     * V_m̎słȂƂAɍׂꍇɕB
     * 𔻕ʂĂяoɒ萔lƂĕԋpB
     * </p>
     * @return        V_m̏Ԃ\
     */
    private int getRelationInNotParallel() {
	double dTol = bCyl.getToleranceForDistance();
	JgclIntersectionPoint3D[] intsP;
	try {
	    intsP = bAxis.intersect(sAxis);
	}
	catch (JgclIndefiniteSolution e){
	    throw new JgclFatal();
	}

	if ((intsP.length == 1) && (Math.abs(bCyl.radius() - sCyl.radius()) < dTol)) {
	    axisIntsP = intsP[0];
	    return INTERSECT_SAME_RADIUS;
	}
	else 
	    return getRelationInNotParallelNotIntersect();
    }

    /**
     * V_m̎słȂȂԂɂāA
     * ȂԂ𒲂ׂĕԂ
     * <p>
     * V_m̎słȂAȂԂɂāA
     * ɍׂꍇɕB
     * 𔻕ʂĂяoɒ萔lƂĕԋpB
     * </p>
     * @return        V_m̏Ԃ\
     */
    private int getRelationInNotParallelNotIntersect() {
	JgclLine3D[] bLines = makeLinesOnCylinder();
	JgclIntersectionPoint3D[] intsPB1;
	JgclIntersectionPoint3D[] intsPB2;
	try {
	    intsPB1 = bLines[0].intersect(sCyl);
	    intsPB2 = bLines[1].intersect(sCyl);
	}
	catch (JgclIndefiniteSolution e) {
	    // V_m̎słȂ̂ŁÃP[X͋N蓾Ȃ͂
	    throw new JgclFatal();
	}
	int n1 = intsPB1.length;
	int n2 = intsPB2.length;

	if (n1 != 0)
	    bLineSCylIntsP = intsPB1;
	else if (n2 != 0)
	    bLineSCylIntsP = intsPB2;
	else
	    bLineSCylIntsP = null;

	if ((n1 == 0) && (n2 == 0))
	    return noIntersectionPoint();
	else if (((n1 == 0) && (n2 == 1)) || ((n1 == 1) && (n2 == 0))) {
	    return oneIntersectionPoint();
	}
	else if (((n1 == 0) && (n2 == 2)) || ((n1 == 2) && (n2 == 0)))
	    // 1 curve
	    return NO_INTERSECT_LINE_INTERSECT;
	else
	    throw new JgclFatal();
    }

    /**
     * V_m̓ŊSɌ邩A܂Ȃ𒲂ׂĕԂ
     * <p>
     * V_m̓ŊSɌ邩A܂Ȃ𒲂ׂāA
     * ̒萔lĂяoɕԋpB
     * </p>
     * @return        V_m̏Ԃ\
     */
    private int noIntersectionPoint() {
	JgclIntersectionPoint3D[] point;
	try {
	    point = bCyl.intersect(sAxis);
	}
	catch (JgclIndefiniteSolution e) {
	    // V_m̎słȂ̂ŁÃP[X͋N蓾Ȃ͂
	    throw new JgclFatal();
	}
	if (point.length == 0)
	    // nothing
	    return NO_INTERSECT_OUT_OF_LINE;
	else
	    // 2 freeform curve
	    return NO_INTERSECT_BETWEEN_LINE;
    }

    /**
     * V_mŐڐG邩AOŐڐG邩𒲂ׂĕԂ
     * <p>
     * V_m̐ڐG𒲂ׁȀԂ\萔lĂяoɕԋpB
     * </p>
     * @return        V_m̏Ԃ\
     */
    private int oneIntersectionPoint() {
	JgclIntersectionPoint3D[] point;
	try {
	    point = bCyl.intersect(sAxis);
	}
	catch (JgclIndefiniteSolution e) {
	    // V_m̎słȂ̂ŁÃP[X͋N蓾Ȃ͂
	    throw new JgclFatal();
	}
	if (point.length == 0)
	    // 1 point
	    return NO_INTERSECT_TOUCH_OUTSIDE;
	else
	    // 8-figure curve(freeform curve)
	    return NO_INTERSECT_TOUCH_INSIDE;
    }

    private int twoIntersectionPoint() {
	// 1 freeform curve
	return NO_INTERSECT_LINE_INTERSECT;
    }

    /**
     * V_m̊֌W𒲂ׂĕԂ
     * <p>
     * V_mv邩A
     * V_m̎sAłȂ𒲂ׁAɍׂԂ𒲂ׂB
     * </p>
     * @return        V_m̏Ԃ\
     */
    private int getRelation() {
	// Cylinders are coincident
	if (bCyl.equals(sCyl)) return COINCIDENT;

	// Is Cylinders Parallel or not?
	if (bCyl.isParallel(sCyl)) {
	    return getRelationInParallel();
	}
	else {
	    return getRelationInNotParallel();	    
	}
    }

    /**
     * V_m̌(1 )Ԃ
     * <p>
     * V_ɂāAV_̎ƕsȒ߂B
     * </p>
     * @return        ̔z
     */
    private JgclSurfaceSurfaceInterference3D[] makeOneLine() {
	JgclVector3D bTos = bCylU.multiply(bCyl.radius());
	JgclPoint3D point = bOrg.add(bTos);
	JgclVector3D direction = bCylW;
	JgclLine3D res = new JgclLine3D(point, direction);
	JgclIntersectionCurve3D ints = bCyl.curveToIntersectionCurve(res, sCyl, doExchange);
	JgclSurfaceSurfaceInterference3D[] sol = {ints};
	return sol;
    }

    /**
     * V_m̌(2 )Ԃ
     * <p>
     * õV_̉~lǍ_߂B
     * ̌_痼V_̎ɐLт߂ƂȂB
     * </p>
     * @return        ̔z
     */
    private JgclSurfaceSurfaceInterference3D[] makeTwoLine() {
	JgclCircle3D bCylCircle = new JgclCircle3D(bCyl.position(), bCyl.radius());
	JgclIntersectionPoint3D[] intsP;
	try {
	    intsP = bCylCircle.intersect(sCyl);
	} catch (JgclIndefiniteSolution e) {
	    throw new JgclFatal();
	}

	if (intsP.length != 2) throw new JgclFatal();
	
	JgclLine3D res = new JgclLine3D(intsP[0], bCylW);
	JgclIntersectionCurve3D ints1 = bCyl.curveToIntersectionCurve(res, sCyl, doExchange);
	res = new JgclLine3D(intsP[1], bCylW);
	JgclIntersectionCurve3D ints2 = bCyl.curveToIntersectionCurve(res, sCyl, doExchange);
	JgclSurfaceSurfaceInterference3D[] sol = {ints1, ints2};
	return sol;
    }

    /**
     * V_m̌(2 ȉ~)Ԃ
     * <p>
     * V_̎m̌_2ȉ~̒SɂȂB
     * V_̒Zȉ~̔aɂȂB
     * ȉ~͎̒mĂpxȂǂ狁߂B
     * </p>
     * @return        ̔z
     */
    private JgclSurfaceSurfaceInterference3D[] makeTwoEllipse() {
	double theta = bAxis.angleWith(sAxis);
	JgclVector3D zOfBCyl = bAxis.dir();
	JgclVector3D zOfSCyl = sAxis.dir();
	JgclVector3D w1 = zOfSCyl.add(zOfBCyl).unitized();
	JgclVector3D w2 = zOfSCyl.subtract(zOfBCyl).unitized();

	// axisIntsP should be assign when intersection bAxis and sAxis
	if (axisIntsP == null) throw new JgclFatal();

	// use intersection point of two cylinder's z-axis as center of ellipse
	JgclAxis2Placement3D position;
	double xRadius, yRadius;
	double bRadius = bCyl.radius();

	// make ellipse1	
	position = new JgclAxis2Placement3D(axisIntsP, w1, w2);
	xRadius = bRadius / Math.cos(theta / 2.0);
	yRadius = bRadius;
	JgclEllipse3D ellipse = new JgclEllipse3D(position, xRadius, yRadius);
	JgclIntersectionCurve3D ints1 = bCyl.curveToIntersectionCurve(ellipse, sCyl, doExchange);

	// make ellipse2
	position = new JgclAxis2Placement3D(axisIntsP, w2, w1);
	xRadius = bRadius / Math.sin(theta / 2.0);
	yRadius = bRadius;
	ellipse = new JgclEllipse3D(position, xRadius, yRadius);
	JgclIntersectionCurve3D ints2 = bCyl.curveToIntersectionCurve(ellipse, sCyl, doExchange);
	JgclSurfaceSurfaceInterference3D[] sol = {ints1, ints2};
	return sol;
    }

    private JgclPoint3D uvPointFromT(JgclPoint3D point, JgclVector3D uVec, JgclVector3D vVec, double r, double t) {
	double cost = Math.cos(t);
	double sint = Math.sin(t);

	return new JgclCartesianPoint3D
	    (point.x() + r * ((cost * uVec.x()) + (sint * vVec.x())),
	     point.y() + r * ((cost * uVec.y()) + (sint * vVec.y())),
	     point.z() + r * ((cost * uVec.z()) + (sint * vVec.z())));
    }

    private JgclVector3D[] getUVVector() {
	JgclVector3D cSu, cSv, cSw;
	JgclPointOnCurve3D[] cNorm;
	try {
	    cNorm = sAxis.commonNormal(bAxis);
	}
	catch (JgclIndefiniteSolution e) {
	    throw new JgclFatal();
	}

	cSw = sAxis.dir();
	cSu = cNorm[1].subtract(cNorm[0]).unitized();
	if (cSu.norm() == 0) {
	    cSu = sCyl.position().effectiveRefDirection();
	}
	cSv = cSw.crossProduct(cSu).unitized();
	JgclVector3D[] unitVec = {cSu, cSv, cSw};

	return unitVec;
    }

    /**
     * V_m̌(2 RȐ, 8^Ȑ)Ԃ
     * <p>
     * 2RȐ߂B
     * V_̏񂩂𗧂āẢpāA
     * RȐƂẴ|C\𓾂B
     * </p>
     * @return        ̔z
     */
    private JgclSurfaceSurfaceInterference3D[] makeTwoCurve() {
	double step = 2 * Math.PI / (nst - 1);
	double[] dA = new double[3];
	JgclVector3D[] uvVec = getUVVector();
	JgclPoint3D ePnt;
	JgclVector3D evec;
	JgclVector3D evec2;
	double ework;
	double t;
	JgclPoint3D[] pArray1 = new JgclPoint3D[nst];
	JgclPoint3D[] pArray2 = new JgclPoint3D[nst];
	double dX0, dX1;
	double[] dX;

	dA[2] = 1.0 - w1w2 * w1w2;
	for (int i = 0; i < nst; i++) {
	    t = -Math.PI + i * step;
	    ePnt = uvPointFromT(sOrg, uvVec[0], uvVec[1], sCyl.radius(), t);
	    evec = sAxis.dir().subtract(bAxis.dir().multiply(w1w2));
	    evec2 = ePnt.subtract(bOrg);

	    dA[1] = 2.0 * evec.dotProduct(evec2);
	    ework = evec2.dotProduct(bAxis.dir());
	    dA[0] = evec2.dotProduct(evec2)
		- (ework * ework) - (bCyl.radius() * bCyl.radius());
	    JgclRealPolynomial poly = new JgclRealPolynomial(dA);
	    if ((dX = poly.getAlwaysRootsIfQuadric()) == null){
		throw new JgclFatal();
	    }
	    if (dX.length == 1)
		dX0 = dX1 = dX[0];
	    else if (dX[0] < dX[1]) {
		dX0 = dX[1];
		dX1 = dX[0];
	    }
	    else {
		dX0 = dX[0];
		dX1 = dX[1];
	    }
	    pArray1[i] = ePnt.add(sAxis.dir().multiply(dX0));
	    pArray2[i] = ePnt.add(sAxis.dir().multiply(dX1));
	}
	JgclPolyline3D pol = new JgclPolyline3D(pArray1);
	JgclIntersectionCurve3D ints1 = bCyl.curveToIntersectionCurve(pol, sCyl, doExchange);
	pol = new JgclPolyline3D(pArray2);
	JgclIntersectionCurve3D ints2 = bCyl.curveToIntersectionCurve(pol, sCyl, doExchange);
	JgclSurfaceSurfaceInterference3D[] sol = {ints1, ints2};
	return sol;
    }

    /**
     * V_m̌(1 _)Ԃ
     *
     * @return        _
     */
    private JgclSurfaceSurfaceInterference3D[] makeOnePoint() {
	if (bLineSCylIntsP.length != 1) throw new JgclFatal();

	JgclSurfaceSurfaceInterferenceList intf = new
	    JgclSurfaceSurfaceInterferenceList(bCyl, sCyl);

	JgclPoint3D point = bLineSCylIntsP[0].coordinates();
  	double[] paramsA = bCyl.pointToParameter(point);
  	double[] paramsB = sCyl.pointToParameter(point);
  	intf.addAsIntersectionPoint(point, paramsA[0], paramsA[1], paramsB[0], paramsB[1]);
	return intf.toJgclSurfaceSurfaceInterference3DArray(doExchange);
    }

    /**
     * V_m̌(8^Ȑ)Ԃ
     * <p>
     * makeTwoCurve()\bhƓ
     * </p>
     * @return        ̔z
     */
    private JgclSurfaceSurfaceInterference3D[] makeEightFigureCurve() {
	return makeTwoCurve();
    }

    /**
     * V_m̌(1 RȐ)Ԃ
     * <p>
     * 1RȐ߂B
     * V_̏񂩂𗧂āẢpāA
     * RȐƂẴ|C\𓾂B
     * </p>
     * @return        ̔z
     */
    private JgclSurfaceSurfaceInterference3D[] makeOneCurve() {
	int myNst = 2 * nst - 1;
	double[] dA = new double[3];
	JgclVector3D[] uvVec = getUVVector();
	JgclPoint3D ePnt;
	JgclVector3D evec;
	JgclVector3D evec2;
	double ework;
	double t;
	JgclRealPolynomial poly;
	double dX0, dX1;
	double dX[];
	JgclPoint3D[] pArray = new JgclPoint3D[myNst];

	evec = bLineSCylIntsP[0].subtract(sOrg);
	evec = evec.project(uvVec[2]).unitized();
	double t0 = Math.acos(evec.dotProduct(uvVec[0]));

	double step = (2.0 * t0) / (nst - 1);
	dA[2] = 1.0 - w1w2 * w1w2;

	for (int i = 0; i < (nst - 1); i++) {
	    t = (-t0) + i * step;
	    ePnt = uvPointFromT(sOrg, uvVec[0], uvVec[1], sCyl.radius(), t);
	    evec = sAxis.dir().subtract(bAxis.dir().multiply(w1w2));
	    evec2 = ePnt.subtract(bOrg);

	    dA[1] = 2.0 * evec.dotProduct(evec2);
	    ework = evec2.dotProduct(bAxis.dir());
	    dA[0] = evec2.dotProduct(evec2)
		- (ework * ework) - (bCyl.radius() * bCyl.radius());
	    poly = new JgclRealPolynomial(dA);
	    if ((dX = poly.getAlwaysRootsIfQuadric()) == null){
		throw new JgclFatal();
	    }
	    if (dX.length == 1)
		dX0 = dX1 = dX[0];
	    else if (dX[0] < dX[1]) {
		dX0 = dX[1];
		dX1 = dX[0];
	    }
	    else {
		dX0 = dX[0];
		dX1 = dX[1];
	    }
	    pArray[i] = ePnt.add(sAxis.dir().multiply(dX0));
	    pArray[myNst - 1 - i] = ePnt.add(sAxis.dir().multiply(dX1));
	}

	t = t0;
	ePnt = uvPointFromT(sOrg, uvVec[0], uvVec[1], sCyl.radius(), t);
	evec = sAxis.dir().subtract(bAxis.dir().multiply(w1w2));
	evec2 = ePnt.subtract(bOrg);

	dA[1] = 2.0 * evec.dotProduct(evec2);
	ework = evec2.dotProduct(bAxis.dir());
	dA[0] = evec2.dotProduct(evec2) - (ework * ework) - (bCyl.radius() * bCyl.radius());
	poly = new JgclRealPolynomial(dA);
	if ((dX = poly.getAlwaysRootsIfQuadric()) == null){
	    throw new JgclFatal();
	}
	if (dX.length == 1)
	    dX0 = dX1 = dX[0];
	else if (dX[0] < dX[1]) {
	    dX0 = dX[1];
	    dX1 = dX[0];
	}
	else {
	    dX0 = dX[0];
	    dX1 = dX[1];
	}
	pArray[nst - 1] = ePnt.add(sAxis.dir().multiply(dX0));
	JgclPolyline3D pol = new JgclPolyline3D(pArray);
	JgclIntersectionCurve3D ints = bCyl.curveToIntersectionCurve(pol, sCyl, doExchange);
	JgclSurfaceSurfaceInterference3D[] sol = {ints};
	return sol;
    }

    private JgclSurfaceSurfaceInterference3D[] noIntersectionCurve() {
	return new JgclSurfaceSurfaceInterference3D[0];
    }

    /**
     * V_m̌߂
     * <p>
     * 2̃V_̈ʒu֌WꍇsA
     * ̏ꍇɂ@gāA߂B
     * </p>
     * @param cyl1       V_1
     * @param cyl2       V_2
     * @param doExchange V_邩ǂ̃tO
     * @return           ̔z
     */
    static JgclSurfaceSurfaceInterference3D[] intersection(JgclCylindricalSurface3D cyl1, JgclCylindricalSurface3D cyl2, boolean doExchange) throws JgclIndefiniteSolution {
	JgclSurfaceSurfaceInterference3D[] result;

	JgclIntsCylCyl3D doObj = new JgclIntsCylCyl3D(cyl1, cyl2, doExchange);
	switch (doObj.getRelation()) {
	case COINCIDENT:
	    // throw IndefiniteSolution
	    throw new JgclIndefiniteSolution(cyl1);
	case PARALLEL_NO_TOUCH:
	    // no intersection
	    return doObj.noIntersectionCurve();
	case PARALLEL_TOUCH:
	    // 1 line
	    return doObj.makeOneLine();
	case PARALLEL_INTERSECT:
	    // 2 line
	    return doObj.makeTwoLine();
	case INTERSECT_SAME_RADIUS:
	    // 2 ellipse
	    return doObj.makeTwoEllipse();
	case NO_INTERSECT_OUT_OF_LINE:
	    // no intersection
	    return doObj.noIntersectionCurve();
	case NO_INTERSECT_BETWEEN_LINE:
	    // 2 freeform curve
	    return doObj.makeTwoCurve();
	case NO_INTERSECT_TOUCH_OUTSIDE:
	    // 1 point
	    return doObj.makeOnePoint();
	case NO_INTERSECT_TOUCH_INSIDE:
	    // 8-figure curve
	    return doObj.makeEightFigureCurve();
	case NO_INTERSECT_LINE_INTERSECT:
	    // 1 freefrom curve
	    return doObj.makeOneCurve();
	}
	throw new JgclFatal();
    }
}
