/*
 * 3D ~Ɖ~̌_߂NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclIntsCylCon3D.java,v 1.18 2000/08/11 06:18:52 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * RF~Ɖ~̌_߂NX
 * <p>
 * ~Ɖ~̌́AQ̈ʒu֌WɂĈȉ̏ꍇ
 * ꂼꋁ߂B
 * 1. ʂȏꍇɂĂRʂ
 * 2. ~̒_~ɂꍇƂĂTʂ
 * 3. ~̒_~ɂꍇƂĂQʂ
 * 4. ~̒_~OɂꍇƂĂRʂ
 * </p>
 *
 * @version $Revision: 1.18 $, $Date: 2000/08/11 06:18:52 $
 * @author Information-technology Promotion Agency, Japan
 */

class JgclIntsCylCon3D {

    /**
     * ~Ɖ~̊֌W\邽߂̒萔
     */
    /**
     * ʂȏ1
     */
    private static final int SPECIAL_CASE_1 = 0;

    /**
     * ʂȏ2
     */
    private static final int SPECIAL_CASE_2 = 1;

    /**
     * ʂȏ3
     */
    private static final int SPECIAL_CASE_3 = 2;

    /**
     * ~̒_~ɂ
     */
    private static final int CONE_VERTEX_ON_CYLINDER = 3;
    private static final int CONE_ENTIRE_OUTSIDE_CYLINDER = 30;
    private static final int CONE_RULE_ON_CYLINDER = 31;
    private static final int THETA_EQUAL_SEMI_ANGLE = 32;
    private static final int THETA_NOT_EQUAL_SEMI_ANGLE = 33;
    private static final int CONE_ANGLE_INSIDE_CYLINDER = 34;

    /**
     * ~̒_~ɂ
     */
    private static final int CONE_VERTEX_IN_CYLINDER = 4;
    private static final int BOTH_AXIS_IS_EQUAL_SEMI_ANGLE = 40;
    private static final int BOTH_AXIS_IS_NOT_EQUAL_SEMI_ANGLE = 41;


    /**
     * ~̒_~Oɂ
     */
    private static final int CONE_VERTEX_OUT_CYLINDER = 5;
    private static final int RULING_IS_PARALLEL_TO_AXIS = 50;
    private static final int ANGLE_IS_SMALLER_CONS_SEMI_ANGLE = 51;
    private static final int ANGLE_IS_GREATER_CONS_SEMI_ANGLE = 52;

    /**
     * ~
     */
    private JgclCylindricalSurface3D cyl;

    /**
     * ~̌_
     */
    private JgclPoint3D cylOrg;

    /**
     * ~̎
     */
    private JgclLine3D cylAxis;

    /**
     * ~
     */
    private JgclConicalSurface3D con;

    /**
     * ~̌_
     */
    private JgclPoint3D conOrg;

    /**
     * ~̎
     */
    private JgclLine3D conAxis;

    /**
     * \|C̓_̐
     */
    private static final int nst = 41;

    /**
     * ʂ邩ǂ̃tO
     */
    private boolean doExchange;

    /**
     * ̋e덷
     */
    private double dTol;

    /**
     * px̋e덷
     */
    private double aTol;

    /**
     * ~̒_Ɖ~̎̋
     */
    private double dist;

    /**
     * ~Ɖ~̎px
     */
    private double theta;

    /**
     * ~̎Ɖ~̒_~̎ւ̐px
     */
    private double beta;

    /**
     * ~̒_~̎ւ̐̃xNg
     */
    private JgclVector3D con2cyl;

    /**
     * ʂȏꍇ3̂ƂɎg_
     */
    private JgclPoint3D specialCase3Point;

    private double conCos;
    private double conTan;

    /**
     * ~̋ǏW
     */
    private JgclVector3D[] cylAxes;

    /**
     * ~̋ǏW
     */
    private JgclVector3D[] conAxes;

    /**
     * ~Ɖ~ƌʂ邩ǂ̃tO^
     * ߂邽߂̃IuWFNg\zB
     *
     * @param cyl         ~
     * @param con         ~
     * @param doExchange  ʂ邩ǂ̃tO
     */
    private JgclIntsCylCon3D(JgclCylindricalSurface3D cyl,
			     JgclConicalSurface3D con,
			     boolean doExchange) {
	// elݒ肷
	this.cyl = cyl;
	this.con = con;
	this.doExchange = doExchange;

	// ~ɊւtB[hlݒ
	cylOrg = cyl.position().location();
	cylAxis = cyl.getAxis();
	cylAxes = cyl.position().axes();

	// ~ɊւtB[hlݒ
	conCos = Math.cos(con.semiAngle());
	conTan = Math.tan(con.semiAngle());
	conOrg = con.position().location();
	conAxis = con.getAxis();
	conAxes = con.position().axes();
	conOrg = conOrg.subtract(conAxes[2].multiply(con.radius() / conTan));

	// 덷ȂǂɊւtB[hlݒ
	dTol = cyl.getToleranceForDistance();
	aTol = cyl.getToleranceForAngle();
	JgclPointOnCurve3D[] projectedPoint = cylAxis.projectFrom(conOrg);
	dist = conOrg.distance(projectedPoint[0]);
	con2cyl = projectedPoint[0].subtract(conOrg);

	// ~A~̎m̊֌WȂǂ
	double ework = cylAxes[2].dotProduct(conAxes[2]);
	if (ework > 1.0) ework = 1.0;
	if (ework < -1.0) ework = -1.0;
	theta = Math.acos(ework);

	if (dist > dTol) {
	    ework = con2cyl.dotProduct(conAxes[2]) / dist; 
	    if (ework > 1.0) ework = 1.0;
	    if (ework < -1.0) ework = -1.0;
	    beta = Math.acos(ework);
	}
    }

    /**
     * ʂȏꍇ1 ǂׂ
     * <p>
     * mvāA~̒_ɂB 1~
     * </p>
     * @return ʂȏꍇ1 ǂ̐^Ul
     */
    private boolean isSpecialCase1() {
	return (((theta < dTol) || (theta > (Math.PI - dTol))) && (dist < dTol));
    }

    /**
     * ʂȏꍇ2 ǂׂ
     * <p>
     * ~̗Ő~̕\ʂɉ悤ɈvB 1ȉ~1 or 1
     * ƊOŐڂƂ2p^[
     * </p>
     * @return ʂȏꍇ2 ǂ^Ul
     */
    private boolean isSpecialCase2() {
	double semiAngle = con.semiAngle();
	return (((Math.abs(theta - semiAngle) < aTol)
		 || (Math.abs(theta - (Math.PI - semiAngle)) < aTol))
		&& ((Math.abs(beta - (Math.PI / 2.0 - semiAngle)) < aTol)
		    || (Math.abs(beta - (Math.PI / 2.0 + semiAngle)) < aTol))
		&& (Math.abs(dist - cyl.radius()) < dTol));
    }

    /**
     * ʂȏꍇ3 ǂׂ
     * <p>
     * ~~̓ł̗ŐɐڂB 2ȉ~
     * </p>
     * @return ʂȏꍇ3 ǂ
     */
    private boolean isSpecialCase3() {
	//
	// ~̌_ʂĉ~̋ǏWʂlA
	// ̕ʂƉ~̌߂B
	//
	JgclAxis2Placement3D position =
	    new JgclAxis2Placement3D(conOrg, cylAxes[2], cylAxes[0]);
	JgclPlane3D plane = new JgclPlane3D(position);
	JgclSurfaceSurfaceInterference3D[] intf;
	try {
	    intf = plane.intersect(con);
	}
	catch (JgclIndefiniteSolution e) {
	    throw new JgclFatal();
	}

	//
	// (ł~̗Őł钼)2{݂ȂA
	// ꂼ̐Ɖ~̒S̋
	// ~̔aƌ덷ȓňv邩ǂB
	//
	if (intf.length != 2)
	    return false;

	for (int i = 0; i < 2; i++) {
	    try {
  		double ework = ((JgclLine3D)intf[i].toIntersectionCurve().
				curve3d()).distanceFrom(cylAxis);
		if (Math.abs(ework - cyl.radius()) > dTol)
		    return false;
	    }
	    catch (JgclIndefiniteSolution e) {
		return false;
	    }
	}

	//
	// ~̗ŐƉ~̌lA肪1̓_ɂȂ̂ł΁A
	// ~Ɖ~̊֌W͓ʂȏꍇ1Ƃ݂ȂB
	//
	JgclIntersectionPoint3D[] intp;
	try {
	    intp = ((JgclLine3D)intf[0]).intersect(cyl);
	}
	catch (JgclIndefiniteSolution e) {
	    // ō~2̗Ő́A
	    // ~̎ƕsɂȂȂ̂ŁÃP[X͗L蓾Ȃ
	    throw new JgclFatal();
	}
	if (intp.length != 1)
	    throw new JgclFatal();

	specialCase3Point = intp[0];
	return true;
    }

    /**
     * ~̒_~ɂ邩ǂׂ
     *
     * @return ~̒_~ɂ邩ǂ̐^UlB
     */
    private boolean isConesVertexOnCylinder() {
	return Math.abs(dist - cyl.radius()) < dTol;
    }

    /**
     * ~̒_~ɂ邩ǂׂ
     *
     * @return ~̒_~ɂ邩ǂ̐^UlB
     */
    private boolean isConesVertexInCylinder() {
	return dist < cyl.radius();
    }

    /**
     * ƂẲ~B(special case 1 ̂Ƃ)
     * <p>
     * ~̔aA~̔aA~̊J
     * ƂĂǂ̈ʒuɉ~ł邩vZB
     * </p>
     * @return        (1~)
     */
    private JgclGeometry[] oneCircle() {
	double radius = cyl.radius();
	double d = radius / conTan;
	JgclVector3D axis = conAxes[2];
	JgclPoint3D org = conOrg.add(axis.multiply(d));
	JgclAxis2Placement3D position = new
	    JgclAxis2Placement3D(org, axis, cylAxes[0]);
	JgclCircle3D circle = new JgclCircle3D(position, radius);
	JgclGeometry[] sol = {circle};
	return sol;
    }

    /**
     * ƂĂ1ȉ~1B(special case 2 ̂Ƃ)
     * <p>
     * ~~ɂꍇ́A܂łȉ~߁A
     * ̌A~A~̒߂B
     * </p>
     * @return        (1ȉ~1)
     */
    private JgclGeometry[] oneEllipseOneLine() {
	//
	// ~Ɖ~̓OAȉ~߂B
	//
  	JgclGeometry[] ellipse = null;
	if (Math.abs(beta - (Math.PI / 2.0 - con.semiAngle())) < aTol) {
	    ellipse = oneEllipse();
  	    if (ellipse.length != 1)
		throw new JgclFatal();
	}
	//
	// ͉~̌_ʂ~̎̌̂߂΂悢B
	//
	JgclLine3D line = new JgclLine3D(conOrg, cyl.position().z());

	//
	// ꂽ܂Ƃ߂
	//
  	JgclGeometry[] sol;
  	if (ellipse != null) {
	    sol = new JgclGeometry[2];
	    sol[0] = line;
	    sol[1] = ellipse[0];
	}
	else {
	    sol = new JgclGeometry[1];
	    sol[0] = line;
	}
	return sol;
    }

    /**
     * ƂĂ1ȉ~B(special case 2 ̂Ƃ)
     * <p>
     * ~̗Ő4oA̒Ɖ~̌_߂
     * 4̂ȂƂ3͌_͂Ȃ̂ŁA3̌_ŕʂB
     * ʂƉ~̌Ƃ߂ȉ~łB
     * </p>
     * @return        (1ȉ~)
     */
    private JgclGeometry[] oneEllipse() {
	JgclVector3D conU, conV, conW;

	conW = conAxes[2];
	conV = cylAxes[2].crossProduct(conW);
	conU = conV.crossProduct(conW);
	conU = conU.unitized();
	conV = conV.unitized();

	JgclPoint3D[] planePoint = new JgclPoint3D[3];
	//
	// 4̗Ő߁A~Ƃ̌_Œ3͋߂
	//
	for (int i = 0, j = 0; i < 4; i++, j++) {
	    double t = (Math.PI / 2) * i;
	    JgclVector3D dir = cnPointFromT(conU, conV, conW, t);
	    JgclLine3D conRuling = new JgclLine3D(conOrg, dir);
	    JgclVector3D evec = dir.unitized();
	    // ~̎Ɖ~̎̐px0x̏ꍇ̓XLbv
	    if (Math.abs(evec.dotProduct(cylAxes[2])) > Math.cos(aTol))
		continue;
	    JgclIntersectionPoint3D[] intp;
	    try {
		intp = conRuling.intersect(cyl);
	    }
	    catch (JgclIndefiniteSolution e) {
		// ~̎Ɖ~̎̐px0x̏ꍇ́A
		// ŏȂĂ̂ŁÃP[X͋N蓾Ȃ
		throw new JgclFatal();
	    }
	    double ework = conOrg.distance(intp[0]);
	    if (ework > dTol)
		planePoint[j] = intp[0];
	    else
		planePoint[j] = intp[1];
	}

	//
	// ŋ߂ꂽ_gĕʂA
	// ʂƉ~̌߂B
	//
	JgclPoint3D planeOrg = planePoint[1];
	JgclVector3D planeRef1 = planePoint[0].subtract(planePoint[1]);
	JgclVector3D planeRef2 = planePoint[1].subtract(planePoint[1]);
	JgclVector3D planeAxis = planeRef1.crossProduct(planeRef2);;
	
	JgclAxis2Placement3D position =
	    new JgclAxis2Placement3D(planeOrg, planeAxis, planeRef1);
	JgclPlane3D plane = new JgclPlane3D(position);
	JgclSurfaceSurfaceInterference3D[] intf;
	try {
	    intf = plane.intersect(cyl);
	}
	catch (JgclIndefiniteSolution e) {
	    throw new JgclFatal();
	}

	if ((intf.length != 0) || (!intf[0].isIntersectionCurve()))
	    throw new JgclFatal();
	JgclParametricCurve3D curve = intf[0].toIntersectionCurve().curve3d();
	JgclGeometry[] sol = {curve};
	return sol;
    }

    /**
     * ƂĂ2ȉ~B(special case 3 ̂Ƃ)
     * <p>
     * ~̗Ő2oA̒Ɖ~̌_߂
     * Ɖ~ƌ_ƁA炩ߋ߂Ă_3̌_ŕʂB
     * ʂƉ~̌Ƃ߂ȉ~łB
     * </p>
     * @return        (2ȉ~)
     */
    private JgclGeometry[] twoEllipse() {
	JgclVector3D conU, conV, conW;

	conW = conAxes[2];
	conV = cylAxes[2].crossProduct(conW);
	conU = conV.crossProduct(conW);
	conU = conU.unitized();
	conV = conV.unitized();

	//
	// ~̗Ő߁AƉ~Ƃ̌_߂B
	// 180xΑlɂċ߂B
	//
	JgclPoint3D xRadiusPoint[][] = new JgclPoint3D[2][2];
	for (int i = 0; i < 2; i++) {
	    double t = Math.PI * i;
	    JgclVector3D dir = cnPointFromT(conU, conV, conW, t);
	    JgclLine3D conRuling = new JgclLine3D(conOrg, dir);
	    JgclIntersectionPoint3D[] intp;
	    try {
		intp = conRuling.intersect(cyl);
	    }
	    catch (JgclIndefiniteSolution e) {
		// ʂȏꍇ3̎́A~̗ŐƉ~ڂ邱Ƃ́A
		// N蓾Ȃ
		throw new JgclFatal();
	    }
	    double dist0 = conOrg.distance(intp[0]);
	    double dist1 = conOrg.distance(intp[1]);

	    if (dist0 < dist1) {
		if (i == 0) {
		    xRadiusPoint[0][0] = intp[0];
		    xRadiusPoint[1][0] = intp[1];
		}
		else {
		    xRadiusPoint[0][1] = intp[1];
		    xRadiusPoint[1][1] = intp[0];
		}
	    }
	    else {
		if (i == 0) {
		    xRadiusPoint[0][0] = intp[1];
		    xRadiusPoint[1][0] = intp[0];
		}
		else {
		    xRadiusPoint[0][1] = intp[0];
		    xRadiusPoint[1][1] = intp[1];
		}
	    }
	}
	//
	// ꂼ2̓_̑gƂ炩ߋ߂Ă_3g
	// ʂAƉ~̌߂
	// 
	JgclSurfaceSurfaceInterference3D[] intf;
	JgclGeometry[] sol = new JgclGeometry[2];
	for (int i = 0; i < 2; i++) {
	    JgclPoint3D planeOrg = specialCase3Point;
	    JgclVector3D planeRef1 = xRadiusPoint[i][0].subtract(specialCase3Point);
	    JgclVector3D planeRef2 = xRadiusPoint[i][1].subtract(specialCase3Point);
	    JgclVector3D planeAxis = planeRef1.crossProduct(planeRef2);
	    JgclAxis2Placement3D position =
		new JgclAxis2Placement3D(planeOrg, planeAxis, planeRef1);
	    JgclPlane3D plane = new JgclPlane3D(position);
	    try {
		intf = plane.intersect(cyl);
	    }
	    catch (JgclIndefiniteSolution e) {
		throw new JgclFatal();
	    }
	    if ((intf.length != 1) || (intf[0].isIntersectionCurve()))
		throw new JgclFatal();
  	    JgclParametricCurve3D curve = intf[0].toIntersectionCurve().curve3d();
	    sol[i] = curve;
	}
	return sol;
    }

    /**
     * ~̒_~ɂƂÅ֌W̏ڍ׏󋵂𒲂ׂ
     * <p>
     * ~̒_~ɂƂAɍׂ5̏ꍇɕB
     * 𔻕ʂĂяoɒ萔lƂĕԋpB
     * </p>
     * @return ~̒_~ɂƂÅ֌W̏ڍ׏
     */
    private int getRelationInConeVertexOnCylinder() {
	double semiAngle = con.semiAngle();
	double HARF_PI = Math.PI / 2.0;
	if ((Math.abs(beta - (HARF_PI + semiAngle)) < aTol)
	    || (beta > (HARF_PI + semiAngle)))
	    // 1 point
	    return CONE_ENTIRE_OUTSIDE_CYLINDER;
	else if (Math.abs(beta - (HARF_PI - semiAngle)) < aTol)
	    // 1 curve
	    return CONE_RULE_ON_CYLINDER;
	else if ((beta > (HARF_PI - semiAngle))
		 && (beta < (HARF_PI + semiAngle)))
	    if ((Math.abs(theta - semiAngle) < aTol)
		|| (Math.abs(theta - (Math.PI - semiAngle)) < aTol))
		// 1 line & 1 curve
		return THETA_EQUAL_SEMI_ANGLE;
	    else
		// 1 leaf of an 8 figure curve
		return THETA_NOT_EQUAL_SEMI_ANGLE;
	else 
	    // 1 curve & 1 point
	    return CONE_ANGLE_INSIDE_CYLINDER;
    }

    /**
     * ~̒_~ɂƂ̌Ԃ
     * <p>
     * ꂽ萔lY郁\bhĂяoA߂B
     * </p>
     * @return 󋵂ɉ
     */
    private JgclGeometry[] coneVertexOnCylinder() {
	switch (getRelationInConeVertexOnCylinder()) {
	    case CONE_ENTIRE_OUTSIDE_CYLINDER:
		return onePoint();
	    case CONE_RULE_ON_CYLINDER:
  		return oneCurve();
	    case THETA_EQUAL_SEMI_ANGLE:
  		return oneLineOneCurve();
	    case THETA_NOT_EQUAL_SEMI_ANGLE:
		return oneLeafOfEightFigureCurve();
	    case CONE_ANGLE_INSIDE_CYLINDER:
  		return oneCurveOnePoint();
	}
	throw new JgclFatal();
    }

    /**
     * ƂĂ1_B
     * <p>
     * ~̒_ԂB
     * </p>
     * @return        (1_)
     */
    private JgclGeometry[] onePoint() {
	JgclGeometry[] sol = { conOrg };	
	return sol;
    }

    /**
     * ƂĂ1ȐB
     * <p>
     * 1RȐ(|C\)Ԃ
     * </p>
     * @return        (1Ȑ)
     */
    private JgclGeometry[] oneCurve() {
	JgclVector3D conU, conV, conW;

	conW = conAxes[2];
	conV = con2cyl.crossProduct(conW);
	conU = conV.crossProduct(conW);
	conU = conU.unitized();
	conV = conV.unitized();

	JgclPoint3D[] point = new JgclPoint3D[nst];
	double step = Math.PI * 2 / (nst - 1);
	for (int i = 0; i < nst; i++) {
	    double t = -Math.PI + i * step;
	    JgclVector3D evec = cnPointFromT(conU, conV, conW, t);
	    double s = -coefBCon(evec, cylAxes[2]) / coefACon(evec, cylAxes[2]);
	    point[i] = conOrg.add(evec.multiply(s));
	}
	JgclGeometry[] sol = { new JgclPolyline3D(point) };
	return sol;
    }

    /**
     * ƂĂ11ȐB
     * <p>
     * 11RȐ(|C\)Ԃ
     * </p>
     * @return        (11Ȑ)
     */
    private JgclGeometry[] oneLineOneCurve() {
	JgclVector3D conU, conV, conW;

	conW = conAxes[2];
	conV = con2cyl.crossProduct(conW);
	conU = conV.crossProduct(conW);
	conU = conU.unitized();
	conV = conV.unitized();

	double t, t0, t1, t2, t3;
	double[] bzero = bZero(cylAxes[2], conU, conW);
	JgclVector3D evec = cnPointFromT(conU, conV, conW, bzero[0]);
	double step, step1, step2;
	if (Math.abs(coefACon(evec, cylAxes[2])) < dTol) {
	    t0 = bzero[0];
	    if (bzero[0] < bzero[1]) {
		step1 = (bzero[1] - bzero[0]) / (nst - 1);
		step2 = (Math.PI * 2 + bzero[0] - bzero[1]) / (nst - 1);
		t1 = t0 + (step1 / 2.0);
		t2 = bzero[1];
		t3 = t0 + Math.PI * 2 - (step2 / 2.0);
	    }
	    else {
		step1 = (bzero[0] - bzero[1]) / (nst - 1);
		step2 = (Math.PI * 2 + bzero[1] - bzero[0]) / (nst - 1);
		t1 = t0 + (step1 / 2.0);
		t2 = bzero[1] + Math.PI * 2;
		t3 = t0 + Math.PI * 2 - (step2 / 2.0);
	    }
	}
	else {
	    t0 = bzero[1];
	    if (bzero[1] < bzero[0]) {
		step1 = (bzero[0] - bzero[1]) / (nst - 1);
		step2 = (Math.PI * 2 + bzero[1] - bzero[0]) / (nst - 1);
		t1 = t0 + (step1 / 2.0);
		t2 = bzero[0];
		t3 = t0 + Math.PI * 2 - (step2 / 2.0);
	    }
	    else {
		step1 = (bzero[1] - bzero[0]) / (nst - 1);
		step2 = (Math.PI * 2 + bzero[0] - bzero[1]) / (nst - 1);
		t1 = t0 + (step1 / 2.0);
		t2 = bzero[0] + Math.PI * 2;
		t3 = t0 + Math.PI * 2 - (step2 / 2.0);
	    }
	}

	t = (t1 + t2) / 2.0;
	evec = cnPointFromT(conU, conV, conW, t);
	double a = coefACon(evec, cylAxes[2]);
	double b = coefBCon(evec, cylAxes[2]);
	if ((b / a) > 0.0) {
	    t1 = t2;
	    t2 = t3;
	}

	step = (t2 - t1) / (nst - 1);
	JgclPoint3D[] points = new JgclPoint3D[nst];

	// for Polyline
	for (int i = 0; i < nst; i++) {
	    t = t1 + i * step;
	    evec = cnPointFromT(conU, conV, conW, t);
	    a = coefACon(evec, cylAxes[2]);
	    b = coefBCon(evec, cylAxes[2]);
	    points[i] = conOrg.add(evec.multiply(-b / a));
	}
	JgclPolyline3D polyline = new JgclPolyline3D(points);

	// for Line
	evec = cnPointFromT(conU, conV, conW, t0);
	JgclLine3D line = new JgclLine3D(conOrg, evec);

	JgclGeometry[] sol = {polyline, line};
	return sol;
    }

    /**
     * ƂĂ1Ȑ(8̎Ȑ1t)B
     * <p>
     * 1RȐ(|C\)Ԃ
     * </p>
     * @return        (1Ȑ:8̎Ȑ1t)
     */
    private JgclGeometry[] oneLeafOfEightFigureCurve() {
	JgclVector3D conU, conV, conW;

	conW = conAxes[2];
	conV = con2cyl.crossProduct(conW);
	conU = conV.crossProduct(conW);
	conU = conU.unitized();
	conV = conV.unitized();

	double[] bzero = bZero(cylAxes[2], conU, conW);
	double t1, t2;
	double step;
	if (bzero[0] < bzero[1]) {
	    t1 = bzero[0];
	    t2 = bzero[1];
	}
	else {
	    t2 = bzero[0];
	    t1 = bzero[1];
	}

	double t = (t1 + t2) / 2.0;
	JgclVector3D evec = cnPointFromT(conU, conV, conW, t);
	double a = coefACon(evec, cylAxes[2]);
	double b = coefBCon(evec, cylAxes[2]);
	if ((b / a) > 0.0) {
	    t1 = t2;
	    t2 = t1 + Math.PI * 2;
	}
	step = (t2 - t1) / (nst - 1);
	JgclPoint3D[] point = new JgclPoint3D[nst];	
	for (int i = 0; i < nst; i++) {
	    t = t1 + i * step;
	    evec = cnPointFromT(conU, conV, conW, t);
	    a = coefACon(evec, cylAxes[2]);
	    b = coefBCon(evec, cylAxes[2]);
	    point[i] = conOrg.add(evec.multiply(-b / a));
	}

	JgclGeometry[] sol = { new JgclPolyline3D(point) };
	return sol;
    }

    /**
     * ƂĂ1Ȑ1_B
     * <p>
     * 1_1RȐ(|C\)Ԃ
     * </p>
     * @return        (1Ȑ1_)
     */
    private JgclGeometry[] oneCurveOnePoint() {
	JgclVector3D conU, conV, conW;

	conW = conAxes[2];
	if (beta < aTol)
	    conV = conW.crossProduct(cylAxes[2]);
	else
	    conV = con2cyl.crossProduct(conW);
	conU = conV.crossProduct(conW);
	conU = conU.unitized();
	conV = conV.unitized();

	double step = Math.PI * 2 / (nst - 1);
	JgclPoint3D[] points = new JgclPoint3D[nst];
	for (int i = 0; i < nst; i++) {
	    double t = -Math.PI + i * step;
	    JgclVector3D evec = cnPointFromT(conU, conV, conW, t);
	    double s = -coefBCon(evec, cylAxes[2]) / coefACon(evec, cylAxes[2]);
	    points[i] = conOrg.add(evec.multiply(s));
	}

	JgclGeometry[] sol = { new JgclPolyline3D(points), conOrg };	
	return sol;
    }

    /**
     * ~̒_~ɂƂÅ֌W̏ڍ׏󋵂𒲂ׂ
     * <p>
     * ~̒_~ɂƂAɍׂ2̏ꍇɕB
     * 𔻕ʂĂяoɒ萔lƂĕԋpB
     * </p>
     * @return ~̒_~ɂƂÅ֌W̏ڍ׏
     */
    private int getRelationInConeVertexInCylinder() {
	double semiAngle = con.semiAngle();
	if ((Math.abs(theta - semiAngle) < aTol)
	    || (Math.abs(theta - (Math.PI - semiAngle)) < aTol)) {
		return BOTH_AXIS_IS_EQUAL_SEMI_ANGLE;
	    }
	else {
	    return BOTH_AXIS_IS_NOT_EQUAL_SEMI_ANGLE;
	}
    }

    /**
     * ~̒_~ɂƂ̌Ԃ
     * <p>
     * ꂽ萔lY郁\bhĂяoA߂B
     * </p>
     * @return 󋵂ɉ
     */
    private JgclGeometry[] coneVertexInCylinder() {
	switch (getRelationInConeVertexInCylinder()) {
	    case BOTH_AXIS_IS_EQUAL_SEMI_ANGLE:
		return thetaAndSemiAngleIsSame();
	    case BOTH_AXIS_IS_NOT_EQUAL_SEMI_ANGLE:
		return thetaAndSemiAngleIsNotSame();
	}
	throw new JgclFatal();
    }

    /**
     * ƂĂ1ȐB
     * <p>
     * 1RȐ(|C\)Ԃ
     * </p>
     * @return        (1Ȑ)
     */
    private JgclGeometry[] thetaAndSemiAngleIsSame() {
	JgclVector3D cylU, cylV, cylW;
	JgclVector3D conU, conV, conW;

	cylW = cylAxes[2];
	cylV = cylW.crossProduct(con2cyl);
	cylU = cylV.crossProduct(cylW);
	cylU = cylU.unitized();
	cylV = cylV.unitized();

	conW = conAxes[2];
	conV = conW.crossProduct(con2cyl).reverse();
	conU = conV.crossProduct(conW);
	conU = conU.unitized();
	conV = conV.unitized();

	JgclVector3D norm = conW.project(cylW);

	JgclAxis2Placement3D position =
		new JgclAxis2Placement3D(conOrg, norm, cylW);
	JgclPlane3D plane = new JgclPlane3D(position);

	JgclSurfaceSurfaceInterference3D[] intf;
	try {
	    intf = plane.intersect(cyl);
	}
	catch (JgclIndefiniteSolution e) {
	    throw new JgclFatal();
	}

	double[] t = new double[2];
	JgclVector3D evec;
	for (int i = 0; i < intf.length; i++) {
	    if (!intf[i].isIntersectionCurve())
		throw new JgclFatal();

	    JgclParametricCurve3D curve = intf[i].toIntersectionCurve().curve3d();
	    JgclLine3D line = (JgclLine3D)curve;
	    evec = line.pnt().subtract(cylOrg);
	    evec = evec.project(cylW);
	    t[i] = cylU.angleWith(evec, cylW);
	}

	double ework;
	if (t[0] > t[1]) {
	    ework = t[0];
	    t[0] = t[1];
	    t[1] = ework;
	}

	double t0 = (t[0] + t[1]) / 2.0;
	JgclPoint3D epnt = clPointFromT(cylOrg, cylU, cylV, cyl.radius(), t0);
	double b = coefBCyl(epnt, conW, cylW);
	double c = coefCCyl(epnt, conW);
	double s = -c / b;
	JgclPoint3D epnt2 = epnt.add(cylW.multiply(s));
	evec = epnt2.subtract(conOrg);

	if (evec.dotProduct(conW) < 0.0) {
	    ework = t[0];
	    t[0] = t[1];
	    t[1] = ework + Math.PI * 2;
	}

	double step = (t[1] - t[0]) / (nst - 1);
	t[0] += step / 2.0;
	t[1] -= step / 2.0;
	step = (t[1] - t[0]) / (nst - 1);

	JgclPoint3D[] points = new JgclPoint3D[nst];
	for (int i = 0; i < nst; i++) {
	    t0 = t[0] + i * step;
	    epnt = clPointFromT(cylOrg, cylU, cylV, cyl.radius(), t0);
	    s = - coefCCyl(epnt, conW) / coefBCyl(epnt, conW, cylW);
	    points[i] = epnt.add(cylW.multiply(s));
	}

	JgclPolyline3D polyline = new JgclPolyline3D(points);
	JgclGeometry[] sol = {polyline};
	return sol;
    }

    /**
     * ƂĂ1ȐB
     * <p>
     * 1RȐ(|C\)Ԃ
     * </p>
     * @return        (1Ȑ)
     */
    private JgclGeometry[] thetaAndSemiAngleIsNotSame() {
	JgclVector3D conU, conV, conW;
	double dX0, dX1;
	double[] dX;

	conW = conAxes[2];
	if (dist < dTol)
	    conV = cylAxes[2].crossProduct(conW);
	else
	    conV = con2cyl.crossProduct(conW);
	conU = conV.crossProduct(conW);
	conU = conU.unitized();
	conV = conV.unitized();

	double step = Math.PI * 2 / (nst - 1);
	double[] dA = new double[3];
	dA[0] = coefCCon(cylAxes[2], cyl.radius());
	JgclPoint3D[] points = new JgclPoint3D[nst];
	for (int i = 0; i < nst; i++) {
	    double t = -Math.PI + i * step;
	    JgclVector3D evec = cnPointFromT(conU, conV, conW, t);
	    dA[2] = coefACon(evec, cylAxes[2]);
	    dA[1] = coefBCon(evec, cylAxes[2]);
	    if ((dX = (new JgclRealPolynomial(dA)).getAlwaysRootsIfQuadric()) == null)
		throw new JgclFatal();
	    if (dX.length == 1)
		dX0 = dX1 = dX[0];
	    else if (dX[0] < dX[1]) {
		dX0 = dX[1];
		dX1 = dX[0];
	    }
	    else {
		dX0 = dX[0];
		dX1 = dX[1];
	    }
	    points[i] = conOrg.add(evec.multiply(dX0));
	}

	JgclPolyline3D polyline = new JgclPolyline3D(points);
	JgclGeometry[] sol = {polyline};
	return sol;
    }

    /**
     * ~̒_~OɂƂÅ֌W̏ڍ׏󋵂𒲂ׂ
     * <p>
     * ~̒_~OɂƂAɍׂ3̏ꍇɕB
     * 𔻕ʂĂяoɒ萔lƂĕԋpB
     * </p>
     * @return ~̒_~OɂƂÅ֌W̏ڍ׏
     */
    private int getRelationInConeVertexOutCylinder() {
	double semiAngle = con.semiAngle();
	if ((Math.abs(theta - semiAngle) < aTol)
	    || (Math.abs(theta - (Math.PI - semiAngle)) < aTol))
	    return RULING_IS_PARALLEL_TO_AXIS;
	else if (theta < semiAngle || theta > (Math.PI - semiAngle))
	    return ANGLE_IS_SMALLER_CONS_SEMI_ANGLE;
	else
	    return ANGLE_IS_GREATER_CONS_SEMI_ANGLE;

    }

    /**
     * ~̒_~OɂƂ̌Ԃ
     * <p>
     * ꂽ萔lY郁\bhĂяoA߂B
     * </p>
     * @return 󋵂ɉ
     */
    private JgclGeometry[] coneVertexOutCylinder() {
	switch (getRelationInConeVertexOutCylinder()) {
	    case RULING_IS_PARALLEL_TO_AXIS:
		return rulingIsParallelToAxis();
	    case ANGLE_IS_SMALLER_CONS_SEMI_ANGLE:
		return angleIsSmallerConsSemiAngle();
	    case ANGLE_IS_GREATER_CONS_SEMI_ANGLE:
		return angleIsGreaterConsSemiAngle();
	}
	throw new JgclFatal();
    }

    /**
     * ƂĂ1ȐB
     * <p>
     * 1RȐ(|C\)Ԃ
     * </p>
     * @return        (1Ȑ)
     */
    private JgclGeometry[] rulingIsParallelToAxis() {
	if (con2cyl.dotProduct(conAxes[2]) < 0.0)
	    return new JgclGeometry[0];

	JgclVector3D cylU, cylV, cylW, conW;

	cylW = cylAxes[2];
	cylV = cylW.crossProduct(con2cyl);
	cylU = cylV.crossProduct(cylW);
	cylU = cylU.unitized();
	cylV = cylV.unitized();
	conW = conAxes[2];

	double step = Math.PI * 2 / (nst - 1);
	JgclPoint3D[] points = new JgclPoint3D[nst];
	for (int i = 0; i < nst; i++) {
	    double t = -Math.PI + i * step;
	    JgclPoint3D epnt = clPointFromT(cylOrg, cylU, cylV, cyl.radius(), t);
	    double s = -coefCCyl(epnt, conW) / coefBCyl(epnt, conW, cylW);
	    points[i] = epnt.add(cylW.multiply(s));
	}
	JgclPolyline3D polyline = new JgclPolyline3D(points);
	JgclGeometry[] sol = {polyline};
	return sol;
    }

    /**
     * ƂĂ1ȐB
     * <p>
     * 1RȐ(|C\)Ԃ
     * </p>
     * @return        (1Ȑ)
     */
    private JgclGeometry[] angleIsSmallerConsSemiAngle() {
	JgclVector3D cylU, cylV, cylW, conW;
	double dX0, dX1;
	double[] dX;

	cylW = cylAxes[2];
	cylV = cylW.crossProduct(con2cyl);
	cylU = cylV.crossProduct(cylW);
	cylU = cylU.unitized();
	cylV = cylV.unitized();
	conW = conAxes[2];

	double[] dA = new double[3];
	dA[2] = coefACyl(conW, cylW);
	JgclPoint3D epnt = clPointFromT(cylOrg, cylU, cylV, cyl.radius(), 0.0);
	dA[1] = coefBCyl(epnt, conW, cylW);
	dA[0] = coefCCyl(epnt, conW);

	if ((dX = (new JgclRealPolynomial(dA)).getAlwaysRootsIfQuadric()) == null)
	throw new JgclFatal();
	if (dX.length == 1)
	    dX0 = dX1 = dX[0];
	else if ((dX.length == 2) && (dX[0] < dX[1])) {
	    dX0 = dX[1];
	    dX1 = dX[0];
	}
	else {
	    dX0 = dX[0];
	    dX1 = dX[1];
	}
	JgclPoint3D epnt2 = epnt.add(cylW.multiply(dX0));
	JgclVector3D evec = epnt.subtract(conOrg);

	double step = Math.PI * 2 / (nst - 1);
	JgclPoint3D[] points = new JgclPoint3D[nst];
	for (int i = 0; i < nst; i ++) {
	    double t = Math.PI + i * step;
	    epnt = clPointFromT(cylOrg, cylU, cylV, cyl.radius(), t);
	    dA[1] = coefBCyl(epnt, conW, cylW);
	    dA[0] = coefCCyl(epnt, conW);
	    if ((dX = (new JgclRealPolynomial(dA)).getAlwaysRootsIfQuadric()) == null)
		throw new JgclFatal();
	    if (dX.length == 1)
		dX0 = dX1 = dX[0];
	    else if ((dX.length == 2) && (dX[0] < dX[1])) {
		dX0 = dX[1];
		dX1 = dX[0];
	    }
	    else {
		dX0 = dX[0];
		dX1 = dX[1];
	    }
	    double s = (evec.dotProduct(conW) > 0.0) ? dX0 : dX1;
	    points[i] = epnt.add(cylW.multiply(s));
	}
	JgclPolyline3D polyline = new JgclPolyline3D(points);
	JgclGeometry[] sol = {polyline};
	return sol;
    }

    /**
     * ƂĂ̑ȐB
     * <p>
     * RȐ(|C\)Ԃ
     * </p>
     * @return        (Ȑ)
     */
    private JgclGeometry[] angleIsGreaterConsSemiAngle() {
	int myNst = nst / 2;
	double dX0, dX1;
	double dX[];
	JgclPoint3D[][] points = new JgclPoint3D[10][];

	if (con2cyl.dotProduct(conAxes[2]) < 0.0)
	    return new JgclGeometry[0];

	JgclVector3D evec = con2cyl.unitized();
	JgclVector3D cylU, cylV, cylW;
	JgclVector3D conU, conV, conW;

	cylW = cylAxes[2];
	conW = conAxes[2];

	if (Math.abs(cylW.dotProduct(evec)) > Math.cos(aTol))
	    cylV = cylW.crossProduct(conW);
	else
	    cylV = cylW.crossProduct(con2cyl);
	cylU = cylV.crossProduct(cylW);
	cylU = cylU.unitized();
	cylV = cylV.unitized();

	if (Math.abs(conW.dotProduct(evec)) > Math.cos(aTol)) 
	    conV = conW.crossProduct(cylW);
	else
	    conV = conW.crossProduct(con2cyl);
	conV = conV.reverse();
	conU = conV.crossProduct(conW);
	conU = conU.unitized();
	conV = conV.unitized();

	double euw, evw, eww;
	euw = conU.dotProduct(cylW);
	evw = conV.dotProduct(cylW);
	eww = conW.dotProduct(cylW);

	double[] dA = new double[3];
	dA[2] = (euw * euw) + (evw * evw);
	dA[1] = 2.0 * conTan * eww * euw;
	dA[0] = (conTan * conTan * eww * eww) - (evw * evw);

	if ((dX = (new JgclRealPolynomial(dA)).getAlwaysRootsIfQuadric()) == null)
	    throw new JgclFatal();
	int nnn = dX.length;
	if (nnn == 1)
	    dX0 = dX1 = dX[0];
	else if ((nnn == 2) && (dX[0] < dX[1])) {
	    dX0 = dX[1];
	    dX1 = dX[0];
	}
	else {
	    dX0 = dX[0];
	    dX1 = dX[1];
	}

	double ecos = dX0;
	double esin;
	int nnnn = 0; 
	JgclVector3D[] norm = new JgclVector3D[2];
	double reps = 1.0e-8;
	if (((-1.0 - reps) < ecos) && (ecos < (1.0 + reps))) {
	    if (ecos > 1.0) ecos = 1.0;
	    if (ecos < -1.0) ecos = -1.0;
	    esin = Math.sqrt(1.0 - (ecos * ecos));
	    if (Math.abs((conTan * eww) + (ecos * euw) + (esin * evw)) > dTol)
		esin = -esin;
	    norm[0] = conW.multiply(conTan);
	    norm[0] = norm[0].add(conU.multiply(ecos));
	    norm[0] = norm[0].add(conV.multiply(esin));
	    nnnn++;
	}

	if (nnn == 2) {
	    ecos = dX1;
	    if (((-1.0 - reps) < ecos) && (ecos < (1.0 + reps))) {
		if (ecos > 1.0) ecos = 1.0;
		if (ecos < -1.0) ecos = -1.0;
		esin = Math.sqrt(1.0 - (ecos * ecos));
		if (Math.abs((conTan * eww) + (ecos * euw) + (esin * evw)) > dTol)
		    esin = -esin;
		norm[nnnn] = conW.multiply(conTan);
		norm[nnnn] = norm[nnnn].add(conU.multiply(ecos));
		norm[nnnn] = norm[nnnn].add(conV.multiply(esin));
		nnnn++;
	    }
	}
	nnn = nnnn;

	int n = 0;
	JgclLine3D savedLine = null;
	double[] t = new double[5];
	int num = 0;
	for (int i = 0; i < nnn; i++) {
	    JgclAxis2Placement3D position = new JgclAxis2Placement3D(conOrg, norm[i], cylW);
	    JgclPlane3D plane = new JgclPlane3D(position);
	    JgclSurfaceSurfaceInterference3D[] intf;
	    try {
		intf = plane.intersect(cyl);
	    }
	    catch (JgclIndefiniteSolution e) {
		throw new JgclFatal();
	    }

	    if (intf.length <= 0) continue;

	    JgclLine3D line = null;
	    for (int j = 0; j < intf.length; j++) {
		line = (JgclLine3D)intf[j].toIntersectionCurve().curve3d();
		if (num == 0) {
		    savedLine = new JgclLine3D(line.pnt(), line.dir());
		}
		evec = line.pnt().subtract(cylOrg);
		evec = evec.project(cylW);
		t[num++] = cylU.angleWith(evec, cylW);
	    }
	}

	if (num != 0) {
	    int j0 = 0;
	    int jn = num - 1;
	    JgclUtil.sortDoubleArray(t, j0, jn);
	    t[num] = t[0] + Math.PI * 2;
	}
	else {
	    num = 1;
	    t[0] = -Math.PI;
	    t[num] = Math.PI;
	}
	dA[2] = coefACyl(conW, cylW);

	double step;
	JgclPolyline3D[] polyline = new JgclPolyline3D[10];
	for (int i = 0; i < num; i++) {
	    double t0 = (t[i] + t[i + 1]) / 2.0;
	    JgclPoint3D epnt = clPointFromT(cylOrg, cylU, cylV, cyl.radius(), t0);
	    dA[1] = coefBCyl(epnt, conW, cylW);
	    dA[0] = coefCCyl(epnt, conW);
	    double d = dA[1] * dA[1] - (4.0 * dA[2] * dA[0]);
	    if (d < 0.0) {
		if ((num == 1) && (savedLine != null)) {
		    JgclPointOnCurve3D[] pt;
		    try {
			pt = conAxis.commonNormal(savedLine);
		    }
		    catch (JgclIndefiniteSolution e) {
			throw new JgclFatal();
		    }
		    JgclPoint3D point = pt[1];
		    JgclGeometry[] sol = {point};
		    return sol;
		}
		continue;
	    }

	    if (num == 1) {
		points[n] = new JgclPoint3D[nst];
		points[n+1] = new JgclPoint3D[nst];
		step = (t[i + 1] - t[i]) / (nst - 1);
		for (int j = 0; j < nst; j++) {
		    t0 = t[i] + (j * step);
		    epnt = clPointFromT(cylOrg, cylU, cylV, cyl.radius(), t0);
		    dA[1] = coefBCyl(epnt, conW, cylW);
		    dA[0] = coefCCyl(epnt, conW);
		    if ((dX = (new JgclRealPolynomial(dA)).getAlwaysRootsIfQuadric()) == null)
			throw new JgclFatal();
		    int nn = dX.length;
		    if (nn == 1)
			dX0 = dX1 = dX[0];
		    else if ((nn == 2) && (dX[0] < dX[1])) {
			dX0 = dX[1];
			dX1 = dX[0];
		    }
		    else {
			dX0 = dX[0];
			dX1 = dX[1];
		    }
		    points[n][j] = epnt.add(cylW.multiply(dX0));
		    points[n + 1][j] = epnt.add(cylW.multiply(dX1));
		}
		n += 2;
	    }
	    else {
		points[n] = new JgclPoint3D[nst];
		step = (t[i + 1] - t[i]) / myNst;
		int j;
		for (j = 0; j < myNst; j++) {
		    t0 = t[i] + (j * step);
		    epnt = clPointFromT(cylOrg, cylU, cylV, cyl.radius(), t0);
		    dA[1] = coefBCyl(epnt, conW, cylW);
		    dA[0] = coefCCyl(epnt, conW);
		    if ((dX = (new JgclRealPolynomial(dA)).getAlwaysRootsIfQuadric()) == null)
			throw new JgclFatal();
		    int nn = dX.length;
		    if (nn == 1)
			dX0 = dX1 = dX[0];
		    else if ((nn == 2) && (dX[0] < dX[1])) {
			dX0 = dX[1];
			dX1 = dX[0];
		    }
		    else {
			dX0 = dX[0];
			dX1 = dX[1];
		    }
  		    points[n][j] = epnt.add(cylW.multiply(dX0));
  		    points[n][nst - 1 - j] = epnt.add(cylW.multiply(dX1));
		}
		t0 = t[i] + (j * step);
		epnt = clPointFromT(cylOrg, cylU, cylV, cyl.radius(), t0);
		dA[1] = coefBCyl(epnt, conW, cylW);
		dA[0] = coefCCyl(epnt, conW);
		if ((dX = (new JgclRealPolynomial(dA)).getAlwaysRootsIfQuadric()) == null)
		    throw new JgclFatal();
		int nn = dX.length;
		if (nn == 1)
		    dX0 = dX1 = dX[0];
		else if ((nn == 2) && (dX[0] < dX[1])) {
		    dX0 = dX[1];
		    dX1 = dX[0];
		}
		else {
		    dX0 = dX[0];
		    dX1 = dX[1];
		}
		points[n][j] = epnt.add(cylW.multiply(dX0));
		n += 1;
	    }
	}

	JgclGeometry[] sol = new JgclGeometry[n];
	for (int i = 0; i < n; i++) {
	    sol[i] = new JgclPolyline3D(points[i], false);
	}
    	return sol;
    }

    /**
     * private function (cnPointFromT)
     */
    private JgclVector3D cnPointFromT(JgclVector3D conU,
				      JgclVector3D conV,
				      JgclVector3D conW,
				      double t) {
	double cost, sint;

	cost = Math.cos(t);
	sint = Math.sin(t);

	return new JgclLiteralVector3D
	    (conTan * ((cost * conU.x()) + (sint * conV.x())) + conW.x(),
	     conTan * ((cost * conU.y()) + (sint * conV.y())) + conW.y(),
	     conTan * ((cost * conU.z()) + (sint * conV.z())) + conW.z());
    }

    /**
     * private function (coefACon)
     */
    private double coefACon(JgclVector3D conVec, JgclVector3D cylW) {
	double edot;

	edot = conVec.dotProduct(cylW);
	return ((conTan * conTan) + 1.0 - (edot * edot));
    }

    /**
     * private function (coefBCon)
     */
    private double coefBCon(JgclVector3D conVec, JgclVector3D cylW) {
	double edot;
	JgclVector3D evec;
	JgclVector3D cyl2con = con2cyl.reverse();

	edot = cyl2con.dotProduct(cylW);
	evec = cyl2con.subtract(cylW.multiply(edot));
	
	return (2.0 * evec.dotProduct(conVec));
    }

    /**
     * private function (coefCCon)
     */
    private double coefCCon(JgclVector3D cylW, double clr) {
	double edot, edot2;

	edot = con2cyl.dotProduct(con2cyl);
	edot2 = con2cyl.dotProduct(cylW);

	return (edot - (edot2 * edot2) - (clr * clr));
    }

    /**
     * private function (bZero)
     */
    private double[] bZero(JgclVector3D cylW, JgclVector3D conU, JgclVector3D conW) {
	JgclVector3D axis = conU.project(cylW);
	JgclAxis2Placement3D position =
	    new JgclAxis2Placement3D(conOrg, axis, cylW);
	JgclPlane3D plane = new JgclPlane3D(position);
	JgclCircle3D circle = new JgclCircle3D(con.position(), con.radius());
	JgclIntersectionPoint3D[] intp;
	try {
	    intp = circle.intersect(plane);
	}
	catch (JgclIndefiniteSolution e) {
	    throw new JgclFatal();
	}
	JgclVector3D evec;

	double[] bzero = new double[intp.length];
	for (int i = 0; i < intp.length; i++) {
	    evec = intp[i].subtract(conOrg);
	    evec = evec.project(conW);
	    bzero[i] = conU.angleWith(evec, conW);
	}
	return bzero;
    }

    /**
     * private function (clPointFromT)
     */
    private JgclPoint3D clPointFromT(JgclPoint3D c,
				     JgclVector3D u,
				     JgclVector3D v,
				     double r,
				     double t) {
	double cost, sint;

	cost = Math.cos(t);
	sint = Math.sin(t);

	return new JgclCartesianPoint3D
	    (c.x() + r * ((cost * u.x()) + (sint * v.x())),
	     c.y() + r * ((cost * u.y()) + (sint * v.y())),
	     c.z() + r * ((cost * u.z()) + (sint * v.z())));
    }

    /**
     * private function (coefACyl)
     */
    private double coefACyl(JgclVector3D conW, JgclVector3D cylW) {
	double edot;

	edot = conW.dotProduct(cylW);
  	return ((edot * edot) - (conCos * conCos));
    }

    /**
     * private function (coefBCyl)
     */
    private double coefBCyl(JgclPoint3D pepnt, JgclVector3D conW, JgclVector3D cylW) {
	double edot, conCos2;
	JgclVector3D evec2, evec3;

	edot = conW.dotProduct(cylW);
	conCos2 = conCos * conCos;

	evec2 = new JgclLiteralVector3D((edot * conW.x()) - (conCos2 * cylW.x()),
					(edot * conW.y()) - (conCos2 * cylW.y()),
					(edot * conW.z()) - (conCos2 * cylW.z()));
	evec3 = pepnt.subtract(conOrg);

	return (2.0 * evec3.dotProduct(evec2));
    }

    /**
     * private function (coefCCyl)
     */
    private double coefCCyl(JgclPoint3D pepnt, JgclVector3D conW) {
	JgclVector3D evec;
	double edot, edot2;
	
	evec = pepnt.subtract(conOrg);
	edot = evec.dotProduct(conW);
	edot2 = evec.dotProduct(evec);

	return ((edot * edot) - (conCos * conCos * edot2));
    }    

    /**
     * ȂԂ
     * @return         Ȃ\傫0̔z
     */
    private JgclGeometry[] noIntersectionCurve() {
  	return new JgclGeometry[0];
    }

    /**
     * ~Ɖ~̊֌W𒲂ׂĕԂ
     * <p>
     * ~Ɖ~̈ʒu֌W𒲂ׁA傫6̏ꍇɕB
     * Ăяoɒ萔lƂĕԋpB
     * </p>
     * @return        ~Ɖ~̏Ԃ\
     */
    private int getRelation() {
	if (isSpecialCase1())
	    return SPECIAL_CASE_1;
	else if (isSpecialCase2())
	    return SPECIAL_CASE_2;
	else if (isSpecialCase3())
	    return SPECIAL_CASE_3;
	else if (isConesVertexOnCylinder())
	    return CONE_VERTEX_ON_CYLINDER;
	else if (isConesVertexInCylinder())
	    return CONE_VERTEX_IN_CYLINDER;
	else
	    return CONE_VERTEX_OUT_CYLINDER;
    }

    /**
     * ~Ɖ~̊֌WɂČ߂(Б)
     * <p>
     * ꂽ萔lY郁\bhĂяoA
     * ҂̂ɍׂ֌W𒲂ׁA߂B
     * ~̕Б݂̂Ƃ̌߂B
     * </p>
     * @param relation   ~Ɖ~̏Ԃ\
     * @return           ̔z
     */
    JgclGeometry[] doIntersect(int relation) {
	switch (relation) {
	    case SPECIAL_CASE_1:
	    // Cone's and Cylinder's axis is coincident and
	    // Cone's Origin is on Cylinder's axis
	    // make one circle
	    return oneCircle();
	    case SPECIAL_CASE_2:
	    // Cone's ridge line is touch Cylinder's surface at Cylinder's inside or outside
	    // make one line & one ellipse or one line
  	    return oneEllipseOneLine();
	    case SPECIAL_CASE_3:
	    // Cone's both ridge line is touch Cylinder's surface at Cone's inside 
	    // make two ellipse
  	    return twoEllipse();
	    case CONE_VERTEX_ON_CYLINDER:
	    // Cone's vertex is on Cylinder
	    // more 5 patterns
	    return coneVertexOnCylinder();
	    case CONE_VERTEX_IN_CYLINDER:
	    // Cone's vertex is is Cylinder
	    // more 2 patterns
	    return coneVertexInCylinder();
	    case CONE_VERTEX_OUT_CYLINDER:
	    // Cone's vertex is out of Cylinder
	    // more 3 patterns
	    return coneVertexOutCylinder();
	}
	throw new JgclFatal();
    }

    /**
     * t̉~œꂽ𒲐
     * <p>
     * ~̋tƂ̌߂ʁAƓoꂽA
     * ςĂ肷}`̂ŁA𐳂ɒ
     * </p>
     * @param geoms1     ̉~œꂽ
     * @param geoms2     t̉~œꂽ
     * @param relation   ~Ɖ~̏Ԃ\
     * @return           ̔z
     */
    static JgclGeometry[] adjustSolution(JgclGeometry[] geoms1,
					 JgclGeometry[] geoms2,
					 int relation)
    {
	// ̊􉽐}`Ԉ
	// t̉~Ƃ̊Ԃɋ߂ꂽ𒲐
	switch (relation) {
	    case SPECIAL_CASE_1:
	    // Ԉ}`͂Ȃ(t͕ʂ̎RȐ͂)
	    // t̉~Ō߂Ă̂ŁA
	    // (~)̏𒲐
	    JgclCircle3D circle1 = (JgclCircle3D)geoms1[0];
	    JgclCircle3D circle2 = (JgclCircle3D)geoms2[0];
	    JgclAxis2Placement3D circlePos =
	    new JgclAxis2Placement3D(circle2.position().location(),
				     circle1.position().axis(),
				     circle1.position().refDirection());
	    geoms2[0] = new JgclCircle3D(circlePos, circle2.radius());
	    break;
	    case SPECIAL_CASE_2:
	    // ̒ʂƂĂĂꍇA
	    // ̒ʂԈ
	    // geom2ɒĂꍇ́AԈ
	    // ȉ~Ăꍇ́Aȉ~𒲐
	    if (geoms2.length == 1) {
		if (geoms2[0] instanceof JgclLine3D) {
		    geoms2 = new JgclGeometry[0];
		}
	    }
	    else if (geoms2.length == 2) {
		JgclEllipse3D ellipse;
		if ((geoms2[0] instanceof JgclLine3D)
		    && (geoms2[1] instanceof JgclEllipse3D)) {
			ellipse = (JgclEllipse3D)geoms2[1];
		    }
		else if ((geoms2[1] instanceof JgclLine3D)
		    && (geoms2[0] instanceof JgclEllipse3D)) {
			ellipse = (JgclEllipse3D)geoms2[0];
		    }
		else {
		    throw new JgclFatal();
		}
		JgclAxis2Placement3D ellipsePos =
		new JgclAxis2Placement3D(ellipse.position().location(),
					 ellipse.position().axis().reverse(),
					 ellipse.position().refDirection().reverse());
		geoms2 = new JgclGeometry[1];
		geoms2[0] = new JgclEllipse3D(ellipsePos,
					      ellipse.semiAxis1(),
					      ellipse.semiAxis2());
	    }
	    else {
		throw new JgclFatal();
	    }
	    break;
	    case SPECIAL_CASE_3:
	    // Ԉ}`͂Ȃ(t null ̂͂)
	    break;
	    case CONE_VERTEX_ON_CYLINDER:
	    // ̓_ʂƂČĂꍇAȂ́A
	    // ̒ʂƂČĂꍇA
	    // ʂԈ
	    if (geoms2.length == 1) {
		if (geoms2[0] instanceof JgclPoint3D) {
		    geoms2 = new JgclGeometry[0];
		}
	    }
	    else if (geoms2.length == 2) {
		if ((geoms2[0] instanceof JgclLine3D)
		    || (geoms2[1] instanceof JgclLine3D)) {
			JgclParametricCurve3D curve;
			if ((geoms2[0] instanceof JgclLine3D) && (geoms2[1] instanceof JgclParametricCurve3D)) {
			    curve = (JgclParametricCurve3D)geoms2[1];
			}
			else if ((geoms2[1] instanceof JgclLine3D) && (geoms2[0] instanceof JgclParametricCurve3D)) {
			    curve = (JgclParametricCurve3D)geoms2[0];
			}
			else {
			    throw new JgclFatal();
			}
			geoms2 = new JgclGeometry[1];
			geoms2[0] = curve;
		    }
		else if ((geoms2[0] instanceof JgclPoint3D)
			 || (geoms2[1] instanceof JgclPoint3D)) {
			     JgclParametricCurve3D curve;
			     if ((geoms2[0] instanceof JgclPoint3D) && (geoms2[1] instanceof JgclParametricCurve3D)) {
				 curve = (JgclParametricCurve3D)geoms2[1];
			     }
			     else if ((geoms2[1] instanceof JgclPoint3D) && (geoms2[0] instanceof JgclParametricCurve3D)) {
				 curve = (JgclParametricCurve3D)geoms2[0];
			     }
			     else {
				 throw new JgclFatal();
			     }
			     geoms2 = new JgclGeometry[1];
			     geoms2[0] = curve;
			 }
	    }
	    else {
		throw new JgclFatal();
	    }
	    break;
	    case CONE_VERTEX_IN_CYLINDER:
	    // Ԉ}`͂Ȃ(t͕ʂ̎RȐ͂)
	    break;
	    case CONE_VERTEX_OUT_CYLINDER:
	    // Ԉ}`͂Ȃ(t null ̂͂)
	    break;
	    default:
	    throw new JgclFatal();
	}
	return geoms2;
    }

    /**
     * ~Ɖ~̌߂()
     * <p>
     * ~Ɖ~̌߂BБ̉~߂A
     * ~ЂԂāAƂ߂B
     * dȂA`̌tɂȂꍇ̂ŁA
     * CāAK̉߂B
     * </p>
     * @param cyl        ~
     * @param con        ~
     * @param doExchange ʂ邩ǂ̃tO
     * @return           ̔z
     */
    static JgclSurfaceSurfaceInterference3D[] intersection(JgclCylindricalSurface3D cyl, JgclConicalSurface3D con, boolean doExchange) {
	// ̂܂܂̉~Ōʂ߂
	JgclIntsCylCon3D doObj =
	    new JgclIntsCylCon3D(cyl, con, doExchange);
	int relation1 = doObj.getRelation();
    	JgclGeometry[] geoms1 = doObj.doIntersect(relation1);

	// ~ЂԂāAʂ߂
	JgclConicalSurface3D reversedCone = con.getReverse();
	JgclIntsCylCon3D reversedDoObj = 
	new JgclIntsCylCon3D(cyl, reversedCone, doExchange);
	int relation2 = reversedDoObj.getRelation();
  	JgclGeometry[] geoms2 = reversedDoObj.doIntersect(relation2);

	// ЂԂĂA~Ɖ~̊֌W͓͂
	if (relation1 != relation2) throw new JgclFatal();

	// ꂽ𒲐
  	geoms2 = adjustSolution(geoms1, geoms2, relation2);

	// 2̉~ȖʂƂ̉}[W
	// ̍ہAx[X̉~Ȗʂɑ΂ IntersectionCurve 悤ɂ
	JgclSurfaceSurfaceInterference3D[] intf =
	    new JgclSurfaceSurfaceInterference3D[geoms1.length + geoms2.length];
	int i = 0;

	// ̉~Ƃ̌
	for (int j = 0; j < geoms1.length; j++, i++) {
	    if (geoms1[j].isCurve()){
		intf[i] = cyl.curveToIntersectionCurve((JgclParametricCurve3D)geoms1[j], con, doExchange);
						       
	    }
	    else { // geoms1[j].isPoint()
		intf[i] = cyl.pointToIntersectionPoint((JgclPoint3D)geoms1[j], con, doExchange);
	    }
	}

	// t̉~Ƃ̌
	for (int j = 0; j < geoms2.length; j++, i++) {
	    if (geoms2[j].isCurve()){
		intf[i] = cyl.curveToIntersectionCurve((JgclParametricCurve3D)geoms2[j], con, doExchange);
						       
	    }
	    else { // geoms1[j].isPoint()
		intf[i] = cyl.pointToIntersectionPoint((JgclPoint3D)geoms2[j], con, doExchange);
	    }
	}
	return intf;
    }
}
