/*
 * 3D ~m̌_߂NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclIntsConCon3D.java,v 1.19 2000/08/11 06:18:51 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * 3D ~m̌_߂NX
 *
 * @version $Revision: 1.19 $, $Date: 2000/08/11 06:18:51 $
 * @author Information-technology Promotion Agency, Japan
 */

class JgclIntsConCon3D {

    /*
     * Ƃ~ (this )
     */
    private JgclConicalSurface3D geomA;

    /*
     * ̉~ (mate )
     */
    private JgclConicalSurface3D geomB; 

    /*
     * geomA  geomB Ŋpx傫̉~
     */
    private JgclConicalSurface3D coneB;

    /*
     * geomA  geomB Ŋpx̉~
     */
    private JgclConicalSurface3D coneS;

    /*
     * 傫~̒_珬~̒_ւ̃xNg
     */
    private JgclVector3D b2s;

    /*
     * ~̒_傫~̒_ւ̃xNg
     */
    private JgclVector3D s2b;

    /* 
     * ~̒_Ƒ傫~̒_̋
     * 
     */
    private double dist;

    /*
     * ̉~̒ŜȂpx
     */
    private double theta;

    /*
     * ~̒S̃xNg s2b ̂Ȃpx
     */
    private double phiS;

    /*
     * 傫~̒S̃xNg b2s ̂Ȃpx
     */
    private double phiB;

    /*
     * ̋e덷
     */
    private double aTol;

    /*
     * px̋e덷
     */
    private double dTol;

    /*
     * RȐ(polyline)̐x
     */
    private static int nst = 20;

    /*
     * p[^~
     */
    private JgclConicalSurface3D cp;

    /*
     * p[^Ȃ̉~
     */
    private JgclConicalSurface3D co;

    /*
     * p[^~̒S̃xNg
     */
    private JgclVector3D wp;

    /*
     * p[^Ȃ̉~̒S̃xNg
     */
    private JgclVector3D wo;

    /*
     * p[^~̒_
     */
    private JgclPoint3D vep;

    /*
     * p[^Ȃ̉~̒_
     */
    private JgclPoint3D veo;

    /*
     * up[^~̒S̃xNgvƁup[^
     * ~̒_p[^Ȃ̉~̒_ւ̃xNgv
     * Ȃpx
     */
    private double phip;

    /*
     * p[^~(p / 2)
     */
    private double alpp;

    /*
     * p[^~(p / 2)  cosine
     */
    private double cosp;

    /*
     * p[^Ȃ̉~(p / 2)  cosine
     */
    private double coso;

    /*
     * p[^~(p / 2)  tangent
     */
    private double tanp;

    /*
     * p[^Ȃ̉~(p / 2)  tangent
     */
    private double tano;

    /*
     * p[^~̒_p[^Ȃ̉~
     * _ւ̃xNg
     */
    private JgclVector3D p2o;

    /*
     * p[^Ȃ̉~̒_p[^~
     * _ւ̃xNg
     */
    private JgclVector3D o2p;


    /*
     * Kvȃp[^B
     *
     * @param geomA Ƃ~
     * @param geomB ̉~
     */
    private void setupParams(JgclConicalSurface3D geomA,
			     JgclConicalSurface3D geomB)
    {
	this.aTol = geomA.getToleranceForAngle();
	this.dTol = geomA.getToleranceForDistance();
	this.geomA = geomA;
	this.geomB = geomB;
	    
	// p傫 geomA ɏ geomB ɃZbg
	if (geomA.semiAngle() > geomB.semiAngle()) {
	    this.coneB = geomA;
	    this.coneS = geomB;
	} else {
	    this.coneB = geomB;
	    this.coneS = geomA;
	}

	this.b2s  = coneS.apex().subtract(coneB.apex());
	this.s2b  = coneB.apex().subtract(coneS.apex());

	this.dist = b2s.length();

	this.phiS = Math.acos(s2b.dotProduct(coneS.position().z()) / dist);
	this.phiB = Math.acos(b2s.dotProduct(coneB.position().z()) / dist);
	
	double ework = (coneB.position().z()).dotProduct(coneS.position().z());
	if (ework >   1.0)  ework =   1.0;
	if (ework < (-1.0)) ework = (-1.0);
	this.theta = Math.acos(ework);
    }

    /*
     * IuWFNg\zB
     *
     * @param geomA	~A
     * @param geomB	~B
     */
    JgclIntsConCon3D(JgclConicalSurface3D geomA, JgclConicalSurface3D geomB) {
	super();
	setupParams(geomA, geomB);
    }

    /**
     * vCx[g\bh (uvwPointFromT)
     *
     * @param u		ǏWnx̃xNg 	
     * @param v		ǏWnỹxNg
     * @param w		ǏWnz̃xNg
     * @param ctan	~(p / 2)  tangent
     * @param t 	px
     * @return		xNg
     */
    private JgclLiteralVector3D uvwPointFromT(JgclVector3D u,
					      JgclVector3D v,
					      JgclVector3D w,
					      double ctan,
					      double t)
    {
	double cosT = Math.cos(t);
	double sinT = Math.sin(t);
	double x = ctan * ((cosT * u.x()) + (sinT * v.x())) + w.x();
	double y = ctan * ((cosT * u.y()) + (sinT * v.y())) + w.y();
	double z = ctan * ((cosT * u.z()) + (sinT * v.z())) + w.z();

	return new JgclLiteralVector3D(x, y, z);
    }

    /**
     * ߂邽߂22̌WԂB
     *
     * @param evec	uvwPointFromT() ԂxNg
     * @param w2	p[^Ȃ̉~̒S̃xNg
     * @param cosa1	p[^~(p / 2)  cosine
     * @param cosa2	p[^Ȃ̉~(p / 2)  cosine
     * @return		߂邽߂22̌W
     */
    private double coefA(JgclVector3D evec,
			 JgclVector3D w2,
			 double cosa1,
			 double cosa2)
    {
	double edot = evec.dotProduct(w2);

	return ((edot * edot) - ((cosa2 * cosa2)/ (cosa1 * cosa1)));
    }

    /**
     * ߂邽߂21̌WԂB
     *
     * @param evec	uvwPointFromT() ԂxNg
     * @param v12v2	p[^Ȃ̉~̒_p[^~̒_ւ̃xNg
     * @param w2	p[^Ȃ̉~̒S̃xNg
     * @param cosa2	p[^Ȃ̉~(p / 2)  cosine
     * @return		߂邽߂21̌W
     */
    private double coefB(JgclVector3D evec,
			 JgclVector3D v12v2,
			 JgclVector3D w2,
			 double cosa2)
    {
	double edot = v12v2.dotProduct(w2);
	double cosa22 = cosa2 * cosa2;
	JgclVector3D sw2 = w2.multiply(edot);
	sw2 = sw2.subtract(v12v2.multiply(cosa22));

	return 2.0 * sw2.dotProduct(evec);
    }

    /**
     * ߂邽߂20̌WԂB
     *
     * @param v12v2	p[^Ȃ̉~̒_p[^~̒_ւ̃xNg
     * @param w2	p[^Ȃ̉~̒S̃xNg
     * @param cosa2	p[^Ȃ̉~(p / 2)  cosine
     * @return		߂邽߂20̌W
     */
    private double coefC(JgclVector3D v12v2,
			 JgclVector3D w2,
			 double cosa2)
    {
	double edot = v12v2.dotProduct(w2);

	return ((edot * edot) - (cosa2 * cosa2 * v12v2.dotProduct(v12v2)));
    }

    /**
     * vCx[g\bh (aZero)
     *
     * @param cp	p[^~
     * @param co	p[^Ȃ̉~
     * @param cpOrg	p[^~̒_
     * @param up	p[^~̋ǏWnx̃xNg
     * @param wp	p[^~̋ǏWnz̃xNg
     * @param wo	p[^Ȃ̉~̋ǏWnz̃xNg
     * @return		̔z
     * @see JgclIndefiniteSolution
     */
    private double[] aZero(JgclConicalSurface3D cp,
			   JgclConicalSurface3D co,
			   JgclPoint3D cpOrg,
			   JgclVector3D up,
			   JgclVector3D wp,
			   JgclVector3D wo)
    { 
	JgclPoint3D loc = cpOrg.add(wo);
	JgclVector3D axis = co.position().z();
	JgclVector3D refDir = co.position().x();
	JgclAxis2Placement3D position =
	    new JgclAxis2Placement3D(loc, axis, refDir);
	double radius = Math.tan(co.semiAngle());
	JgclCircle3D circle = new JgclCircle3D(position, radius);

	JgclIntersectionPoint3D[] ints;
	try {
	    ints = circle.intersect(cp);
	} catch (JgclIndefiniteSolution e) {
	    throw new JgclFatal();
	}

	double[] azero = new double[ints.length];
 	for (int i = 0; i < ints.length; i++) {
 	    JgclVector3D evec;
	    evec = ints[i].subtract(cpOrg);
 	    evec = (evec.project(wp)).unitized();
	    azero[i] = up.angleWith(evec, wp);
 	}

	return azero;
    }

    /**
     * vCx[g\bh (bZero)
     *
     * @param cp	p[^~
     * @param co	p[^Ȃ̉~
     * @param cpOrg	p[^~̒_
     * @param up	p[^~̋ǏWnx̃xNg
     * @param wp	p[^~̋ǏWnz̃xNg
     * @param coOrg	p[^Ȃ̉~̒_
     * @param wo	p[^Ȃ̉~̋ǏWnz̃xNg
     * @return		̔z
     * @see JgclIndefiniteSolution
     */
    private double[] bZero(JgclConicalSurface3D cp,
			    JgclConicalSurface3D co,
			    JgclPoint3D cpOrg,
			    JgclVector3D up,
			    JgclVector3D wp,
			    JgclPoint3D coOrg,
			    JgclVector3D wo)
    {
	JgclVector3D eO2P = cpOrg.subtract(coOrg);
	double edot = eO2P.dotProduct(wo);
	JgclVector3D evec = wo.multiply(edot);
	double ecos = Math.cos(co.semiAngle());
	double ecos2 = ecos * ecos;

	JgclVector3D axis = evec.subtract(eO2P.multiply(ecos2));
	JgclAxis2Placement3D position =
	    new JgclAxis2Placement3D(cpOrg, axis, wo);
	
	JgclPlane3D plane = new JgclPlane3D(position);
	JgclCircle3D circle = new JgclCircle3D(cp.position(), cp.radius());

	JgclIntersectionPoint3D[] ints;
	try {
	     ints = circle.intersect(plane);
	} catch (JgclIndefiniteSolution e) {
	    throw new JgclFatal();
	}
	
	double[] bzero = new double[ints.length];
 	for (int i = 0; i < ints.length; i++) {
	    evec = ints[i].subtract(cpOrg);
 	    evec = (evec.project(wp)).unitized();
	    bzero[i] = up.angleWith(evec, wp);
 	}

	return bzero;
    }

    /**
     * ͂ꂽ3xNgʂȂׂB
     *
     * @param w1	PʃxNg
     * @param w2	PʃxNg
     * @param dif	Cӂ̒̃xNg
     * @return		ʂȂꍇ͐^,ȂȂꍇ͋UԂ???
     */
    private boolean areCoplanar(JgclVector3D w1, JgclVector3D w2,
				JgclVector3D diff)
    {
	JgclVector3D udiff = diff.unitized();
	JgclVector3D a = w1.crossProduct(udiff).unitized();
	JgclVector3D b = w2.crossProduct(udiff).unitized();
	return Math.abs(a.dotProduct(b)) > Math.cos(aTol);
    }

    /**
     * are Real Tangent?
     *
     * @param sz	xNg(coneS.axis.z())
     * @param bz	xNg(coneB.axis.z())
     * @param b2s	xNg(coneB.apex() -> coneS.apex())
     * @param s2b	xNg(coneS.apex() -> coneB.apex())
     * @return		are Real Tangent?
     */
    private boolean areRealTangent(JgclVector3D sz,
				   JgclVector3D bz,
				   JgclVector3D s2b,
				   JgclVector3D b2s)
    {
	JgclVector3D a, b;
	if (sz.dotProduct(s2b) > 0.0) {
	    a = s2b.crossProduct(sz);
	    b = s2b.crossProduct(bz);
	} else {
	    a = b2s.crossProduct(sz);
	    b = b2s.crossProduct(bz);
	}

	return a.dotProduct(b) <= 0.0;
    }

    /*
     * Sꍇ̌߂B
     *
     * @param doExchange ~邩ǂ̃tO
     * @return		 ̔z
     * @see JgclIndefiniteSolution
     */
    private JgclSurfaceSurfaceInterference3D[] axesAreOverlap(boolean doExchange)
	throws JgclIndefiniteSolution
    {
	JgclSurfaceSurfaceInterference3D[] intf;

	if (dist < dTol) {
	    JgclPoint3D mid = coneB.apex().midPoint(coneS.apex());
	    JgclIntersectionPoint3D intersectPoint = 
		geomA.pointToIntersectionPoint(mid, geomB, doExchange);
	    if (Math.abs(coneB.semiAngle() - coneS.semiAngle()) < aTol) {
		/*
		 * coincident
		 */
		throw new JgclIndefiniteSolution(intersectPoint);
	    } else {
		/*
		 * return 1 point
		 */
		JgclSurfaceSurfaceInterference3D[] work = { intersectPoint };
		intf = work;
	    }
	} else {
	    // one side
	    double tanB = Math.tan(coneB.semiAngle());
	    double tanS = Math.tan(coneS.semiAngle());
	    double x1 = dist * tanB / (tanB + tanS);
	    JgclVector3D axis = coneS.position().z();
	    JgclVector3D refDir = coneS.position().x();
	    JgclPoint3D location1 = 
	      coneS.apex().add(axis.multiply(x1));
	    JgclAxis2Placement3D position1 = new
		JgclAxis2Placement3D(location1, axis, refDir);
	    JgclCircle3D circle1 = new JgclCircle3D(position1, x1 * tanS);
		
	    // transrate one intersection curves
	    JgclIntersectionCurve3D ints1 =
		geomA.curveToIntersectionCurve(circle1, geomB, doExchange);

	    if (Math.abs(coneB.semiAngle() - coneS.semiAngle()) < aTol) {
		/*
		 * return 1 circle
		 */
		JgclSurfaceSurfaceInterference3D[] work = { ints1 };
		intf = work;
	    } else {
		/*
		 * return 2 circle
		 */

		// another side
		double x2 = dist + dist * tanS / (tanB - tanS);
		JgclPoint3D location2 =  coneS.apex().add(axis.multiply(x2));
		JgclAxis2Placement3D position2 = new
		    JgclAxis2Placement3D(location2, axis, refDir);
		JgclCircle3D circle2 = new JgclCircle3D(position2, x2 * tanS);
		
		// transrate another intersection curves
		JgclIntersectionCurve3D ints2 =
		    geomA.curveToIntersectionCurve(circle2, geomB, doExchange);

		JgclSurfaceSurfaceInterference3D[] work = { ints1, ints2 };
		intf = work;
	    }
	}

	return intf;
    }

    /**
     * ƂȂ~Ȑ𓾂B
     *
     * @return		ƂȂ~Ȑ
     * @see JgclIndefiniteSolution
     */
    private JgclSurfaceSurfaceInterference3D[] getConic() {
	JgclPoint3D[] res = new JgclPoint3D[3];
	JgclVector3D cu, cv, cw;
	cw = coneS.position().z();
	cv = (cw.crossProduct(s2b));
	cu = (cv.crossProduct(cw)).unitized();
	cv = cv.unitized();

	double[] azero = aZero(coneS, coneB, coneS.apex(), cu , cw, coneB.position().z());
	int naz = azero.length;

	if (naz < 0) {
	    return new JgclSurfaceSurfaceInterference3D[0];
	}

	if (naz > 1) {
	    JgclUtil.sortDoubleArray(azero);
	}

	for (int i = 0; i < 3; i++) {
	    double t = 0.0;

	    switch (naz) {
	    case 0:
		// ellipse
		t = (i + 1.0) * Math.PI / 2.0;
		break;
	    case 1:
		// parabola
		switch (i) {
		    case 0: t = JgclMath.PI2 / 3.0; break;
		    case 1: t = Math.PI / 36.0;      break;
		    case 2: t = 4.0 * Math.PI / 3.0; break;
		}
		break;
	    case 2:
		// hyperbola
		switch (i) {
		    case 0: t = azero[0] - aTol; break;
		    case 1: t = azero[0] / 10.0; break;
		    case 2: t = azero[1] + aTol; break;
		}
		break;
		
	    default:
		// never be occured
		throw new JgclFatal();
	    }

	    JgclVector3D dir = 
		uvwPointFromT(cu, cv, cw, Math.tan(coneS.semiAngle()), t);
	    JgclLine3D line = new JgclLine3D(coneS.apex(), dir);
	    JgclIntersectionPoint3D[] ints;
	    try {
		ints = line.intersect(coneB);
		res[i] = ints[0];
		if (ints.length == 2) {
		    double dist0 = coneS.apex().distance2(ints[0]);
		    double dist1 = coneS.apex().distance2(ints[1]);
		    if (dist0 < dist1)
			res[i] = ints[1];
		}
	    }
	    catch (JgclIndefiniteSolution e) {
		JgclPoint3D pnt = (JgclPoint3D) e.suitable();
		JgclPointOnCurve3D pocL =
		    new JgclPointOnCurve3D(pnt, line, line.pointToParameter(pnt),
					   JgclGeometry.doCheckDebug);
		double[] params = coneB.pointToParameter(pnt);
		JgclPointOnSurface3D posConeB =
		    new JgclPointOnSurface3D(pnt, coneB, params[0], params[1], JgclGeometry.doCheckDebug);
		res[i] = new JgclIntersectionPoint3D(coneS.apex(), pocL, posConeB,
						     JgclGeometry.doCheckDebug);
	    }
	}

	JgclPoint3D  loc = res[1];
	JgclVector3D rf1 = res[0].subtract(res[1]);
	JgclVector3D rf2 = res[2].subtract(res[1]);
	JgclVector3D ax  = rf1.crossProduct(rf2);
	JgclAxis2Placement3D position =
	    new JgclAxis2Placement3D(loc, rf2, ax);
	JgclPlane3D plane = new JgclPlane3D(position);
	JgclSurfaceSurfaceInterference3D[] conics;
	try {
	    conics = plane.intersect(coneB);
	} catch (JgclIndefiniteSolution e) {
	    throw new JgclFatal(); // shoud never be ocurred
	}
	return conics;
    }

    /*
     * ~mƂċȖʏ̒ꍇɌ߂B
     *
     * @param doExchange ~邩ǂ̃tO
     * @return		 ̔z
     */
    private JgclSurfaceSurfaceInterference3D[] rulingTangent(boolean doExchange) {
	JgclIntersectionCurve3D ints = null;
	JgclLine3D resL;
	JgclSurfaceSurfaceInterference3D[] resG = null;

	if ((Math.abs(theta - (coneS.semiAngle() + coneB.semiAngle())) < aTol) &&
	    areRealTangent(coneS.position().z(), coneB.position().z(), s2b, b2s))
	{
	    /*
	     * (coneB.semiAngle + coneS.semiAngle) == angle between both axes
	     *
	     * 1 line
	     */
	    if (coneS.position().z().dotProduct(s2b) > 0.0) {
		resL = new JgclLine3D(coneB.apex(), s2b);
	    } else {
		resL = new JgclLine3D(coneS.apex(), b2s);
	    }
	      
	    ints = geomA.curveToIntersectionCurve(resL, geomB, doExchange);
	} else if (Math.abs(theta - (coneB.semiAngle() - coneS.semiAngle())) < aTol) {
	    /*
	     * (coneB.semiAngle - coneS.semiAngle) == angle between both axes
	     */
	    if (coneB.position().z().dotProduct(b2s) > 0.0) {
		/*
		 * 1 line
		 */
		resL = new JgclLine3D(coneS.apex(), b2s);
		ints = geomA.curveToIntersectionCurve(resL, geomB, doExchange);
	    } else {
		/*
		 * 1 line and 1 ellipse
		 */
		resL = new JgclLine3D(coneB.apex(), s2b);
		ints = geomA.curveToIntersectionCurve(resL, geomB, doExchange);
		resG = getConic();
	    }
	} else if (Math.abs((coneS.semiAngle() + coneB.semiAngle() + theta) - Math.PI) < aTol) {
	    /*
	     * (coneB.semiAngle + coneS.semiAngle + (angle between both axes) == PI
	     */
	    if (coneB.position().z().dotProduct(b2s) > 0.0) {
		/*
		 * 1 line and 1 conic
		 */
		resL = new JgclLine3D(coneB.apex(), coneS.apex());
		ints = geomA.curveToIntersectionCurve(resL, geomB, doExchange);
		resG = getConic();
	    } else {
		if ((coneS.semiAngle() + coneB.semiAngle()) > (Math.PI / 2.0 + aTol)) {
		    /*
		     * 1 hyperbola
		     */
		    resG = getConic();
		} else {
		    /*
		     * no intersection
		     */
		}
	    }

	} else if (Math.abs((coneB.semiAngle() + theta - coneS.semiAngle()) - Math.PI) < aTol) {
	    /*
	     * (coneB.semiAngle + (angle between both axes) - coneS.semiAngle) == PI
	     */
	    if (coneB.position().z().dotProduct(b2s) > 0.0) {
		/*
		 * 1 line
		 */
		resL = new JgclLine3D(coneB.apex(), coneS.apex());
		ints = geomA.curveToIntersectionCurve(resL, geomB, doExchange);
	    } else {
		/*
		 * no intersection
		 */
	    }
	}

	Vector vec = new Vector();
	if (ints != null) {
	    vec.addElement(ints);
	}
	if (resG != null) {
	    for (int i = 0; i < resG.length; i++) {
		vec.addElement(resG[i]);
	    }
	}

	JgclSurfaceSurfaceInterference3D[] intf = new
	    JgclSurfaceSurfaceInterference3D[vec.size()];
	vec.copyInto(intf);
	return intf;
    }

    /*
     * at most 4 lines
     *
     * @param doExchange ~邩ǂ̃tO
     * @return		 ̔z
     * @see JgclIndefiniteSolution
     */
    private JgclSurfaceSurfaceInterference3D[] fourLines(boolean doExchange) {
	JgclCircle3D circle = new JgclCircle3D(coneB.position(), coneB.radius());
	JgclIntersectionPoint3D[] rcv;
	try {
	    rcv = circle.intersect(coneS);
	} catch (JgclIndefiniteSolution e) {
	    throw new JgclFatal();
	}
	int numberOfSolutions = rcv.length;

	JgclPoint3D pnt = coneB.apex().midPoint(coneS.apex());

	JgclSurfaceSurfaceInterference3D[] intf;
	if (numberOfSolutions == 0) {
	    JgclIntersectionPoint3D intersectPoint = 
		geomA.pointToIntersectionPoint(pnt, geomB, doExchange);
	    JgclSurfaceSurfaceInterference3D[] work = { intersectPoint };
	    intf = work;
	} else {
	    JgclSurfaceSurfaceInterference3D[] work = new
		JgclSurfaceSurfaceInterference3D[numberOfSolutions];
	    for (int i = 0; i < numberOfSolutions; i++) {
		JgclLine3D line = new JgclLine3D(pnt, rcv[i]);
		work[i] = geomA.curveToIntersectionCurve(line, geomB, doExchange);
	    }
	    intf = work;
	}
	return intf;
    }

    /*
     * set parameterized cone
     *
     * @param condition	ǂ̉~p[^ׂ̃tO
     */
    private void setParametarizedCone(boolean condition) {
	if (condition) {
	    this.cp = coneB;
	    this.co = coneS;
	    this.vep = coneB.apex();
	    this.veo = coneS.apex();
	    this.wp = coneB.position().z();
	    this.wo = coneS.position().z();
	    this.p2o = b2s;
	    this.o2p = s2b;
	    this.phip = phiB;
	    this.alpp = coneB.semiAngle();
	    this.cosp = Math.cos(coneB.semiAngle());
	    this.coso = Math.cos(coneS.semiAngle());
	    this.tanp = Math.tan(coneB.semiAngle());
	    this.tano = Math.tan(coneS.semiAngle());
	} else {
	    this.cp = coneS;
	    this.co = coneB;
	    this.vep = coneS.apex();
	    this.veo = coneB.apex();
	    this.wp = coneS.position().z();
	    this.wo = coneB.position().z();
	    this.p2o = s2b;
	    this.o2p = b2s;
	    this.phip = phiS;
	    this.alpp = coneS.semiAngle();
	    this.cosp = Math.cos(coneS.semiAngle());
	    this.coso = Math.cos(coneB.semiAngle());
	    this.tanp = Math.tan(coneS.semiAngle());
	    this.tano = Math.tan(coneB.semiAngle());
	}
    }

    /*
     * 
     */
    private class InterferenceOfVertexIsOnTheOther {
	private JgclPolyline3D[] pols;
	private JgclPoint3D ints;

	InterferenceOfVertexIsOnTheOther(JgclPolyline3D[] pols,
					 JgclPoint3D ints)
	{
	    this.pols = pols;
	    this.ints = ints;
	}

	JgclPolyline3D[] pols() {
	    return this.pols;
	}

	JgclPoint3D ints() {
	    return this.ints;
	}
    }

    /*
     * Е̉~̒_̉~̋Ȗʏɂꍇ̌߂B
     * 
     * @param doExchange ~邩ǂ̃tO
     * @return		 킷NX
     * @see #InterferenceOfVertexIsOnTheOther
     */
    private InterferenceOfVertexIsOnTheOther vertexIsOnTheOther(boolean doExchange) {
	/*
	 * parameterize one cone
	 */
	setParametarizedCone(Math.abs(phiS - coneS.semiAngle()) < aTol ||
			     Math.abs((Math.PI - phiS) - coneS.semiAngle()) < aTol);

	/*
	 * set temporaly local axes
	 */
	JgclVector3D cu, cv, cw;
	cw = wp;
	cv = cw.crossProduct(p2o);
	if ((cv.length() / dist) < Math.sin(aTol)) {
	    /*
	     * cw & p2o are parallel
	     */
	    cv = cw.crossProduct(wo);
	}
	cu = (cv.crossProduct(cw)).unitized();
	cv = cv.unitized();

	/*
	 * the value of t
	 */
	double[] azero = aZero(cp, co, vep, cu, cw, wo);
	int naz = azero.length;
	double[] bzero = bZero(cp, co, vep, cu, cw, veo, wo);
	int nbz = bzero.length;

	JgclPolyline3D[] res = null;
	JgclPoint3D res2 = null;
	if ((Math.abs(phip - alpp) < aTol) ||
	    (Math.abs((Math.PI - phip) - alpp) < aTol))
	{
	    /*
	     * the other vertex is also on the cone --  some polyline
	     */
	    double[] t = new double[6];
	    double t1 = 0.0;
	    int count1, count2;
	    for (count1 = 0, count2 = 2; count1 < naz; count1++) {
		if (Math.abs(bzero[0] - azero[count1]) < aTol) {
		    t1 = bzero[0];
		    t[0] = bzero[1];
		} else if (Math.abs(bzero[1] - azero[count1]) < aTol) {
		    t1 = bzero[1];
		    t[0] = bzero[0];
		} else {
		    t[count2++] = azero[count1];
		}
	    }
	    JgclVector3D evec = (wp.project(p2o)).unitized();
	    t[1] = Math.acos(evec.dotProduct(cu));

	    int j0 = 0, jn = count2 - 1;
	    JgclUtil.sortDoubleArray(t, j0, jn);
 
	    if (t1 < t[0]) {
		t1 += JgclMath.PI2;
	    }
	    t[count2] = t[0] + JgclMath.PI2;

	    Vector polvec = new Vector();
	    for (int i = 0; i < count2; i++) {
		/*
		 * check the center point of t[i] & t[i+1]	
		 */
		double t2 = (t[i] + t[i+1]) / 2.0;
		if (Math.abs(t2 - t1) < aTol) {
		    t2 = (t[i] + t2) / 2.0;
		}
		evec = uvwPointFromT(cu, cv, cw, tanp, t2);
		double s = - coefB(evec, o2p, wo, coso) / coefA(evec, wo, cosp, coso);
		if (s < 0.0) {
		    continue;
		}
		JgclPoint3D epnt = vep.add(evec.multiply(s));
		evec = epnt.subtract(veo);
		double ework = evec.dotProduct(wo);
		if (ework < 0.0) {
		    continue;
		}
   
		double step = (t[i+1] - t[i]) / (nst - 1);
		Vector pntvec = new Vector();
		for (int k = 0; k < nst; k++) {
		    t2 = t[i] + k * step;
		    if (Math.abs(t2 - t1) < aTol) {
			t2 += aTol;
		    }
		    evec = uvwPointFromT(cu, cv, cw, tanp, t2);
		    double a = coefA(evec, wo, cosp, coso);
		    if (Math.abs(a) < JgclMachineEpsilon.DOUBLE) {
			if (k == 0) {
			    t2 = t[i] + k * step / 2.0;
			} else {
			    t2 = t2 - k * step / 2.0;
			}
			if (Math.abs(t2 - t1) < aTol) {
			    t2 += aTol;
			}
			evec = uvwPointFromT(cu, cv, cw, tanp, t2);
			a = coefA(evec, wo, cosp, coso);
		    }
		    s = - coefB(evec, o2p, wo, coso) / a;
		    JgclPoint3D pnt = vep.add(evec.multiply(s));

		    if (pnt != null) {
			pntvec.addElement(pnt);
		    }
		}
		JgclPoint3D[] points = new JgclPoint3D[pntvec.size()];
		pntvec.copyInto(points);
		JgclPolyline3D pol = new JgclPolyline3D(points);

		if (pol != null) {
		    polvec.addElement(pol);
		}
	    }
    
	    res = new JgclPolyline3D[polvec.size()];
	    polvec.copyInto(res);

	} else {
	    /*
	     * the other vertex is not on the cone
	     */
	    if (naz == 0) {
		if (nbz == 0) {
		    JgclVector3D evec = uvwPointFromT(cu, cv, cw, tanp, 0.0);
		    double s = - coefB(evec, o2p, wo, coso) / coefA(evec, wo, cosp, coso);
		    JgclPoint3D epnt = vep.add(evec.multiply(s));
		    evec = epnt.subtract(veo);
		    
		    if ((s < 0.0) || (evec.dotProduct(wo) < 0.0)) {
			/*
			 * 1 point
			 */

			res2 = vep;
		    } else {
			/*
			 * 1 polyline & 1 point
			 */
			double step = JgclMath.PI2 / (nst - 1);
			Vector pntvec = new Vector();
			for (int i = 0; i < nst; i++) {
			    double t = (- Math.PI) + i * step;
			    evec = uvwPointFromT(cu, cv, cw, tanp, t);
			    s = - coefB(evec, o2p, wo, coso) / coefA(evec, wo, cosp, coso);
			    JgclPoint3D pnt = vep.add(evec.multiply(s));
			    pntvec.addElement(pnt);
			}
			JgclPoint3D[] points = new JgclPoint3D[pntvec.size()];
			pntvec.copyInto(points);
			res = new JgclPolyline3D[1];
			res[0] = new JgclPolyline3D(points);
			
			res2 = vep;
		    }
		} else if (nbz == 1) {
		    /*
		     * 1 polyline
		     */
		    JgclVector3D evec = uvwPointFromT(cu, cv, cw, tanp, 0.0);
		    double s = - coefB(evec, o2p, wo, coso) / coefA(evec, wo, cosp, coso);
	
		    if (s < 0.0) {
			res2 = vep;
		    } else {
			double step = JgclMath.PI2 / (nst - 1);
			Vector pntvec = new Vector();
			for (int i = 0; i < nst; i++) {
			    double t = (- Math.PI) + i * step;
			    evec = uvwPointFromT(cu, cv, cw, tanp, t);
			    s = - coefB(evec, o2p, wo, coso) / coefA(evec, wo, cosp, coso);
			    pntvec.addElement(vep.add(evec.multiply(s)));
			}
			JgclPoint3D[] points = new JgclPoint3D[pntvec.size()];
			pntvec.copyInto(points);
			res = new JgclPolyline3D[1];
			res[0] = new JgclPolyline3D(points);
		    }
	
		} else {
		    /*
		     * 8 figure curve : 1 polyline
		     */
		    double[] t0 = new double[2];
		    double t1;
	
		    if (bzero[0] < bzero[1]) {
			t0[0] = bzero[0];
			t0[1] = bzero[1];
		    } else {
			t0[0] = bzero[1];
			t0[1] = bzero[0];
		    }
		    double t = (t0[0] + t0[1]) / 2.0;
	
		    JgclVector3D evec = uvwPointFromT(cu, cv, cw, tanp, t);
		    double s = - coefB(evec, o2p, wo, coso) / coefA(evec, wo, cosp, coso);
		    double step;
		    if (s > 0.0) {
			t1 = t0[0];
			step = (t0[1] - t0[0]) / (nst - 1);
		    } else {
			t1 = t0[1];
			step = (JgclMath.PI2 + t0[0] - t0[1]) / (nst - 1);
		    }
	
		    Vector pntvec = new Vector();
		    for (int i = 0; i < nst; i++) {
			t = t1 + i * step;
			evec = uvwPointFromT(cu, cv, cw, tanp, t);
			s = - coefB(evec, o2p, wo, coso) / coefA(evec, wo, cosp, coso);
			pntvec.addElement(vep.add(evec.multiply(s)));
		    }
		    JgclPoint3D[] points = new JgclPoint3D[pntvec.size()];
		    pntvec.copyInto(points);
		    res = new JgclPolyline3D[1];
		    res[0] = new JgclPolyline3D(points);
		}
	    } else {
		/*
		 * naz != 0 :  some polyline
		 */
		double[] t1 = new double[7];
		int count1, count2;
		for (count1 = 0; count1 < naz; count1++) {
		    t1[count1] = azero[count1];
		}
		for (count2 = 0; count2 < nbz; count2++) {
		    t1[count1 + count2] = bzero[count2];
		}
		
		int j0 = 0, jn = naz + nbz - 1;
		JgclUtil.sortDoubleArray(t1, j0, jn);
		t1[naz + nbz] = t1[0] + JgclMath.PI2;
		
		Vector polyvec = new Vector();
		for (int i = 0; i < (naz + nbz); i++) {
		    /*
		     * check the center point of t1[i] & t1[i+1]
		     */
		    double t2 = (t1[i] + t1[i+1]) / 2.0;
		    JgclVector3D evec = uvwPointFromT(cu, cv, cw, tanp, t2);
		    double s1 = - coefB(evec, o2p, wo, coso) / coefA(evec, wo, cosp, coso);
		    if (s1 < 0.0) {
			continue;
		    }
		    JgclPoint3D epnt = vep.add(evec.multiply(s1));
		    evec = epnt.subtract(veo);
		    double ework = evec.dotProduct(wo);
		    if (ework < 0.0) {
			continue;
		    }
		    
		    double step1 = (t1[i+1] - t1[i]) / (nst - 1);
		    Vector pntvec = new Vector();
		    for (int k = 0; k < nst; k++) {
			t2 = t1[i] + k * step1;
			evec = uvwPointFromT(cu, cv, cw, tanp, t2);
			double a = coefA(evec, wo, cosp, coso);
			if (Math.abs(a) < JgclMachineEpsilon.DOUBLE) {
			    if (k == 0) {
				t2 = t1[i] + step1 / 2.0;
			    } else {
				t2 = t2 - step1 / 2.0;
			    }
			    evec = uvwPointFromT(cu, cv, cw, tanp, t2);
			    a = coefA(evec, wo, cosp, coso);
			}
			s1 = - coefB(evec, o2p, wo, coso) / a;
			pntvec.addElement(vep.add(evec.multiply(s1)));
		    }
		    JgclPoint3D[] points = new JgclPoint3D[pntvec.size()];
		    pntvec.copyInto(points);
		    JgclPolyline3D poly = new JgclPolyline3D(points);

		    polyvec.addElement(poly);
		}
		
		res = new JgclPolyline3D[polyvec.size()];
		polyvec.copyInto(res);

		/*
		 * if (nbz == 0) then some polyline & 1 point
		 */
		if (nbz == 0) {
		    res2 = vep;
		}	
	    }
	}

	return new InterferenceOfVertexIsOnTheOther(res ,res2);
    }

    /*
     * ̒l傫邩ǂ̊l
     */
    final static double MY_HUGE	= 1.0e7;

    /*
     * ^ꂽWł̉ԂB
     * ̍ŏ2͏ɏɕёւB
     * 
     * @param dA	̌W
     * @return		̉
     */
    double[] getRootsByCoefficents(double[] dA) {
	JgclRealPolynomial poly = new JgclRealPolynomial(dA);
	double[] roots;
	double dX0, dX1;
	if ((roots = poly.getAlwaysRootsIfQuadric()) == null)
	    throw new JgclFatal();
	if (roots.length == 1) {
	    dX0 = dX1 = roots[0];
	} else if (roots[0] < roots[1]) {
	    dX0 = roots[1];
	    dX1 = roots[0];
	} else {
	    dX0 = roots[0];
	    dX1 = roots[1];
	}
	if (dX0 > MY_HUGE)	// ܂傫͖ƂB
	    dX0 = dX1;
	else if (dX1 < -MY_HUGE)
	    dX1 = dX0;

	double[] dX = {dX0, dX1};
	return dX;
    }
			    
    /*
     * p[^~̒_̉~̓ɂꍇ
     * |CƂċ߂
     * 
     * @return		 ƂȂ|C̔z
     */
    private JgclPolyline3D[] vertexOfParametarizedConeIsInTheOther() {
	/*
	 * set Parametarized Cone
	 */
	setParametarizedCone(phiS < coneS.semiAngle() ||
			     (Math.PI - phiS) < coneS.semiAngle());

	// initialize local variables
	JgclVector3D cu, cv, cw;
	cw = wp;
	cv = cw.crossProduct(p2o);
	cu = (cv.crossProduct(cw)).unitized();
	cv = cv.unitized();

	// the value of t
	double[] azero = aZero(cp, co, vep, cu, cw, wo);
	int naz = azero.length;
	double[] bzero = bZero(cp, co, vep, cu, cw, veo, wo);
	int nbz = bzero.length;

	JgclPolyline3D[] pols;	// return value

	if (naz == 0) {
	    /*
	     * naz == 0
	     */
	    double[] dA = new double[3];	// coefficients

	    dA[0] = coefC(o2p, wo, coso);
	    double step = JgclMath.PI2 / (nst - 1);

	    Vector pntvec = new Vector();
	    for (int k = 0; k < nst; k++) {
		double t = (- Math.PI) + k * step;
		JgclVector3D evec = uvwPointFromT(cu, cv, cw, tanp, t);
		dA[2] = coefA(evec, wo, cosp, coso);
		dA[1] = coefB(evec, o2p, wo, coso);
       		double[] dX = getRootsByCoefficents(dA);

		JgclPoint3D pnt = vep.add(evec.multiply(dX[0]));
		
		if (dX[1] > (- JgclMachineEpsilon.DOUBLE)) {
		    JgclVector3D evec2 = pnt.subtract(veo);
		    if (evec2.dotProduct(wo) < 0.0)
			pnt = vep.add(evec.multiply(dX[1]));
		}
		pntvec.addElement(pnt);
	    }
	    
	    JgclPoint3D[] points = new JgclPoint3D[pntvec.size()];
	    pntvec.copyInto(points);
	    JgclPolyline3D[] work = { new JgclPolyline3D(points) };
	    pols = work;

	} else {
	    /*
	     * naz != 0
	     */
	    double[] dA = new double[3];
	    double[] t = new double[5];

	    for (int i = 0; i < naz && i < t.length; i++) {
		t[i] = azero[i];
	    }
	    int j0 = 0, jn = naz - 1;
	    JgclUtil.sortDoubleArray(t, j0, jn);
	    t[naz] = t[0] + JgclMath.PI2;
	    
	    dA[0] = coefC(o2p, wo, coso);
	    
	    Vector polvec = new Vector();
	    for (int i = 0; i < naz; i++) {
		double t1 = (t[i] + t[i+1]) / 2.0;
		JgclVector3D evec = uvwPointFromT(cu, cv, cw, tanp, t1);
		dA[2] = coefA(evec, wo, cosp, coso);
		dA[1] = coefB(evec, o2p, wo, coso);
		
       		double[] dX = getRootsByCoefficents(dA);
		
		if (dX[0] > 0.0) {
		    JgclPoint3D epnt = vep.add(evec.multiply(dX[0]));
		    JgclVector3D evec2 = epnt.subtract(veo);
		    double ework = evec2.dotProduct(wo);
		  
		    Vector pntvec1 = new Vector();
		    if (ework > 0.0) {
			double step = (t[i + 1] - t[i]) / (nst - 1);
			for (int k = 0; k < nst; k++) {
			    if (k == 0) {
				t1 = t[i] + (0.5 * step);
			    } else if (k == (nst - 1)) {
				t1 = t[i+1] - (0.5 * step);
			    } else {
				t1 = t[i] + (k * step);
			    }
			    evec = uvwPointFromT(cu, cv, cw, tanp, t1);
			    dA[2] = coefA(evec, wo, cosp, coso);
			    dA[1] = coefB(evec, o2p, wo, coso);

			    double[] dX2 =  getRootsByCoefficents(dA);

			    JgclPoint3D pnt = vep.add(evec.multiply(dX2[0]));
			    if (dX2[1] > (- JgclMachineEpsilon.DOUBLE)) {
				evec2 = pnt.subtract(veo);
				if (evec2.dotProduct(wo) < 0.0)
				    pnt =  vep.add(evec.multiply(dX2[1]));
			    }

			    if (pnt != null) {
				pntvec1.addElement(pnt);
			    }
			}
		    }

		    JgclPoint3D[] points = new JgclPoint3D[pntvec1.size()];

		    if (points.length > 0) {
			pntvec1.copyInto(points);

			JgclPolyline3D pol = new JgclPolyline3D(points);
			polvec.addElement(pol);
		    }
		}

		if (dX[1] > 0.0) {
		    JgclPoint3D epnt = vep.add(evec.multiply(dX[1]));
		    JgclVector3D evec2 = epnt.subtract(veo);
		    double ework = evec2.dotProduct(wo);

		    Vector pntvec2 = new Vector();
		    if (ework > 0.0) {
			double step = (t[i + 1] - t[i]) / (nst - 1);
			for (int k = 0; k < nst; k++) {
			    if (k == 0)
				t1 = t[i] + (0.5 * step);
			    else if (k == nst-1)
				t1 = t[i+1] - (0.5 * step);
			    else
				t1 = t[i] + (k * step);
			    evec = uvwPointFromT(cu, cv, cw, tanp, t1);
			    dA[2] = coefA(evec, wo, cosp, coso);
			    dA[1] = coefB(evec, o2p, wo, coso);
			    double[] dX2 = getRootsByCoefficents(dA);

			    JgclPoint3D pnt = vep.add(evec.multiply(dX2[1]));
			    if (dX2[0] > (- JgclMachineEpsilon.DOUBLE)) {
				// Maybe this 'if' statement is unnecessary.
				evec2 = pnt.subtract(veo);
				if (evec2.dotProduct(wo) < 0.0)
				    pnt = vep.add(evec.multiply(dX2[0]));
			    }
			    pntvec2.addElement(pnt);
			}

			JgclPoint3D[] points = new JgclPoint3D[pntvec2.size()];
			pntvec2.copyInto(points);

			JgclPolyline3D pol = new JgclPolyline3D(points);
			polvec.addElement(pol);
		    }
		}
	    }

	    JgclPolyline3D[] work = new	JgclPolyline3D[polvec.size()];
	    polvec.copyInto(work);
	    pols = work;

	}

	return pols;
    }

    /* 
     * 2̃|CȂ_ڑ
     * 
     * @param resp	|CȂ_
     * @param resc	|CȂ_
     * @return		2̃|Cڑ|CȂ_
     */
    private JgclPoint3D[] connect2Polyline(JgclPoint3D[] resp,
					   JgclPoint3D[] resc)
    {
	// if (true) return null;

 	int i = 0;

 	JgclPoint3D[] resn = new JgclPoint3D[resp.length + resc.length - 1];

	/*
	 *  case 1 : <---- (resp) + ----> (resc)
	 */
  	if (resp[0].identical(resc[0])) {

	    // copy resp to resn
  	    for (i = resp.length - 1; i > 0; i--) {
  		resn[resp.length - (i + 1)] =  resp[i];
  	    }

	    // make middle point
	    resn[resp.length - 1] = resp[0].midPoint(resc[0]);

	    // copy resc to resn
	    for (i = 1; i < resc.length; i++) {
		resn[(resp.length - 1) + i] = resc[i];
	    }

	    return resn;
	}

	/*
	 *  case 2 : <---- (resp) + <---- (resc)
	 */
	if (resp[0].identical(resc[resc.length - 1])) {

	    // copy resp to resn
	    for (i = resp.length - 1; i > 0; i--) {
  		resn[resp.length - (i + 1)] =  resp[i];
	    }

	    // make middle point
	    resn[resp.length - 1] = resp[0].midPoint(resc[resc.length - 1]);

	    // copy resc to resn
	    for (i = resc.length - 2; i >= 0; i--) {
		resn[(resp.length + resc.length - 2) - i] = resc[i];
	    }

	    return resn;
	}

	/*
	 *  case 3 : ----> (resp) + ----> (resc)
	 */
	if (resp[resp.length - 1].identical(resc[0])) {

	    for (i = 0; i < (resp.length - 1); i++) {
  		resn[i] =  resp[i];
	    }

	    // make middle point
	    resn[resp.length - 1] = resp[resp.length - 1].midPoint(resc[0]);

	    // copy resc to resn
	    for (i = 1; i < resc.length; i++) {
		resn[(resp.length - 1) + i] = resc[i];
	    }

	    return resn;
	}

	/*
	 * case 4 : ----> (resp) + <---- (resc)
	 */
	if (resp[resp.length - 1].identical(resc[resc.length - 1])) {

	    for (i = 0; i < (resp.length - 1); i++) {
  		resn[resp.length - (i + 2)] =  resp[i];
	    }

	    // make middle point
	    resn[resp.length - 1] = resp[resp.length - 1].midPoint(resc[resc.length - 1]);

	    // copy resc to resn
	    for (i = resc.length - 2; i >= 0; i--) {
		resn[(resp.length + resc.length - 2) - i] = resc[i];
	    }

	    return resn;
	}

	return null;	// must not be here
     }

    /*
     * C^[õ^Cv`FbN
     * 
     * @param	t1	p[^
     * @param	t2	p[^
     * @param	azero	̔z
     * @return		̔z
     */
    private int checkIntervalType(double t1, double t2, double[] azero) {
	int naz = azero.length;
	int type = 0;

	for (int i = 0; i < naz; i++)
	    if (Math.abs(t1 - azero[i]) < JgclMachineEpsilon.DOUBLE) {
	  	type++;
		break;
	    }

	for (int i = 0; i < naz; i++) {
	    if (Math.abs(t2 - azero[i]) < JgclMachineEpsilon.DOUBLE) {
		type++;
		break;
	    }
	}

	return type;
    }

    /*
     * ǂ̉~̒_̉~̊Oɂꍇ̌
     * |CƂċ߂
     * 
     * @param doExchange ~邩ǂ̃tO
     * @return		 ̃|C̔z
     * @see JgclIndefiniteSolution
     */
    private JgclPolyline3D[] bothVerticesAreOutOfTheOther() {

	/*
	 * Parametarized Bigger Cone
	 */
	setParametarizedCone(true);
	
	/*
	 * initialaize local variables
	 */
	double[] t = new double[10];
	double[] dA = new double[3];	/* coefficients of polinomial */
	JgclPoint3D[][] res = new JgclPoint3D[10][];
	int myNst = 2 * nst - 1;
	int intvlType = 0, prevIntvlType = 0;

	/*
	 * set temporaly local axes
	 */
	JgclVector3D cu, cv, cw;
	cw = wp;
	cv = cw.crossProduct(p2o);
	cu = (cv.crossProduct(cw)).unitized();
	cv = cv.unitized();

	JgclVector3D uo, vo;
	vo = wo.crossProduct(p2o).reverse();
	uo = vo.crossProduct(wo).unitized();
	uo = uo.unitized();
	vo = vo.unitized();

	int num = 0;
	JgclVector3D tmp1 = wo.multiply(tano);
	double r = tmp1.dotProduct(o2p) / uo.dotProduct(o2p);
	JgclVector3D tmp2 = tmp1.subtract(uo.multiply(r));
	if (Math.abs(r) < (1.0 + JgclMachineEpsilon.DOUBLE)) {
	    if (r > 1.0)     r = 1.0;
	    if (r < (- 1.0)) r = (- 1.0);

	    double r2 = Math.sqrt(1.0 - r * r);

	    JgclVector3D[] nor = new JgclVector3D[2];
	    nor[0] = tmp2.add(vo.multiply(r2));
	    nor[1] = tmp2.subtract(vo.multiply(r2));

	    for (int i = 0; i < 2; i++) {
	 	// ~ cp ̒_ vep _Ƃ镽ʂ쐬
		JgclPlane3D plane =
		    new JgclPlane3D(new JgclAxis2Placement3D(vep, nor[i], o2p));
		JgclSurfaceSurfaceInterference3D[] ints;

	 	// ~ cp Əō쐬ʂ̌߂B
		// ܂͈ȉ2_KB
		//   (1) ȂƂ_ vep ŌB
		//   (2) ͒_ vep ʂ钼ɂȂB
		try {
		    ints = plane.intersect(cp);
		} catch (JgclIndefiniteSolution e) {
		    // should never be occured by (1)
		    throw new JgclFatal();
		}

		// 肪_ɂȂꍇ͖
		if (ints[0] instanceof JgclIntersectionPoint3D) {
		    continue;
		}

		for (int j = 0; j < ints.length; j++) {
		    JgclLine3D line = 
			(JgclLine3D) ((JgclIntersectionCurve3D) ints[j]).curve3d();
		    JgclVector3D evec = line.dir().project(cw);
		    evec = evec.unitized();
		    t[num] = cu.angleWith(evec, cw);
		    num++;
		}
	    }
	}

	/*
	 * exec private method aZero()
	 */
	double[] azero = aZero(cp, co, vep, cu, cw, wo);
	int naz = azero.length;
	for (int i = 0; i < naz; i++) {
	    t[num++] = azero[i];
	}

	/*
	 * make coefC
	 */
	if (num > 0) {
	    int j0 = 0, jn = num - 1;
	    JgclUtil.sortDoubleArray(t, j0, jn);
	    t[num] = t[0] + JgclMath.PI2;
	    for (int j = 0; j < naz; j++) {
		if (Math.abs(t[0] - azero[j]) < JgclMachineEpsilon.DOUBLE) {
		    double[] temp = new double[naz + 1];
		    for (int jj = 0; jj < naz; jj++) {
			temp[jj] = azero[jj];
		    }
		    temp[naz] = azero[j] + JgclMath.PI2;
		    azero = temp;
		    naz = azero.length;
		    break;
		}
	    }

	    // exec private method checkIntervalType()
	    prevIntvlType = checkIntervalType(t[num - 1], t[num], azero);

	    dA[0] = coefC(o2p, wo, coso);
	}

	/*
	 * loop by "num"
	 */
	int n = 0;
	for (int i = 0; i < num; i++) {

	    // make coefA, coefB
	    double t0 = (t[i] + t[i + 1]) / 2.0;
	    JgclVector3D evec = uvwPointFromT(cu, cv, cw, tanp, t0);
	    dA[2] = coefA(evec, wo, cosp, coso);
	    dA[1] = coefB(evec, o2p, wo, coso);

	    // solve polynomial
	    JgclRealPolynomial poly = new JgclRealPolynomial(dA);
	    double dX0, dX1;
	    double[] dX = poly.getRootsIfQuadric();	// roots
	    if (dX == null) {
		throw new JgclFatal();
	    }

	    if (dX.length == 0) {
		prevIntvlType = 0;
		continue;
	    }

	    if (dX.length == 1) {
		dX0 = dX1 = dX[0];
	    } else if (dX[0] > dX[1]) {
		dX0 = dX[0];
		dX1 = dX[1];
	    } else {
		dX0 = dX[1];
		dX1 = dX[0];
	    }

	    if (dX0 < 0.0) {
		prevIntvlType = 0;
		continue;
	    }

	    JgclPoint3D epnt = vep.add(evec.multiply(dX0));
	    JgclVector3D evec2 = epnt.subtract(veo);
	    if (evec2.dotProduct(wo) < 0.0) {
		prevIntvlType = 0;
		continue;
	    }

	    // check interval type
	    intvlType = checkIntervalType(t[i], t[i + 1], azero);

	    // make array of points
	    JgclPoint3D[] points;
	    if (intvlType == 0)
		points = new JgclPoint3D[myNst];
	    else if (intvlType == 1)
		points = new JgclPoint3D[myNst-1];
	    else	// intvlType == 2
		points = new JgclPoint3D[nst];

	    double step = (t[i+1] - t[i]) / (nst - 1);
	    int nsetted = 0;

	    for (int j = 0; j < (nst - 1); j++) {
		// make coefA, coefB
		t0 = t[i] + j * step;
		evec = uvwPointFromT(cu, cv, cw, tanp, t0);
		dA[2] = coefA(evec, wo, cosp, coso);
		dA[1] = coefB(evec, o2p, wo, coso);

		// solve polynomial
		dX = getRootsByCoefficents(dA);

		switch (intvlType) {
		case 0:
		    points[j] = vep.add(evec.multiply(dX[0]));
		    points[myNst - 1 - j] = vep.add(evec.multiply(dX[1]));
		    break;
		case 1:
		    if (prevIntvlType == 0) {
			points[(nst - 1) - j - 1] = vep.add(evec.multiply(dX[0]));
			points[(nst - 1) + j - 1] = vep.add(evec.multiply(dX[1]));
		    } else {
			points[j] = vep.add(evec.multiply(dX[1]));
			if (j > 0)
			    points[myNst - 1 - j] = vep.add(evec.multiply(dX[0]));
		    }
		    break;
		case 2:
		    if (dX[0] > 0.0) {
			points[nsetted] = vep.add(evec.multiply(dX[0]));
			nsetted++;
		    }
		    break;
		}
	    }

	    /*
	     * make coefA, coefB
	     */
	    t0 = t[i + 1];
	    evec = uvwPointFromT(cu, cv, cw, tanp, t0);
	    dA[2] = coefA(evec, wo, cosp, coso);
	    dA[1] = coefB(evec, o2p, wo, coso);

	    dX = getRootsByCoefficents(dA);

	    switch (intvlType) {
	    case 0:
		points[nst - 1] = vep.add(evec.multiply(dX[0]));
		break;
	    case 1:
		if (prevIntvlType == 0)
		    points[myNst - 2] = vep.add(evec.multiply(dX[0]));
		else
		    points[nst - 1] = vep.add(evec.multiply(dX[0]));
		break;
	    case 2:
		if (dX[0] > 0.0) {
		    points[nsetted] = vep.add(evec.multiply(dX[0]));
		}
		if (nsetted != nst - 1) {
		    JgclPoint3D[] points2 = new JgclPoint3D[nsetted];
		    for (int jj = 0; jj < nsetted; jj++)
			points2[jj] = points[jj];
		    points = points2;
		}
		break;
	    }

	    res[n] = points;

	    /*
	     * connect2Polyline
	     */
	    JgclPoint3D[] newRes;
	    if (i > 0 && intvlType != 0 && prevIntvlType != 0){
		if ((newRes = connect2Polyline(res[n - 1], res[n])) != null)
		    res[n - 1] = newRes;
		else
		    n++;

	    } else if (i == num - 1 && intvlType != 0 && n > 0) {
		if ((newRes = connect2Polyline(res[0], res[n])) != null)
		    res[0] = newRes;
		else
		    n++;

	    } else {
		n++;
	    }
	    
	    prevIntvlType = intvlType;
	}

	JgclPolyline3D[] pols = new JgclPolyline3D[n];
	for (int i = 0; i < n; i++) {
	    pols[i] = new JgclPolyline3D(res[i]);
	}

	return pols;
    }

    /*
     * ǂ炩̒_Е̋Ȗʏɂꍇ̉~m̌߂
     * 
     * @return		 ̔z
     * @see JgclIndefiniteSolution
     */
    JgclSurfaceSurfaceInterference3D[] getInterferenceVertexIsOnTheOther(boolean doExchange)

	throws JgclIndefiniteSolution
    {
	/*
	 * t̉~𓾂
	 *     (geomA: , geomB: )
	 *     (geomA: , geomB: t)
	 *     (geomA: t, geomB: )
	 *     (geomA: t, geomB: t)
	 * ̑g킹̌vZBȊO̓P[Xł
	 * KvȂB
	 *
	 * (GHL ł͉~͒_݂ĕБȂ,STEP ̒`ł
	 *  _̗ɉ~悤ɂȂĂB̃NX̌
	 *  ̌vZ GHL ̎@gĂ̂(,)̌vZ
	 *  łȂB̂߉~̂tɂČvZĂ)
	 */

	JgclIntsConCon3D doObj;
	InterferenceOfVertexIsOnTheOther[] res =
	    new InterferenceOfVertexIsOnTheOther[4];

	// geomA: , geomB: 
	res[0] = vertexIsOnTheOther(doExchange);
	    
	// geomA: , geomB: t
	doObj = new JgclIntsConCon3D(geomA, geomB.getReverse());
	res[1] = doObj.vertexIsOnTheOther(doExchange);
	    
	// geomA: t, geomB: 
	doObj = new JgclIntsConCon3D(geomA.getReverse(), geomB);
	res[2] = doObj.vertexIsOnTheOther(doExchange);
	    
	// geomA: t, geomB: t
	doObj = new JgclIntsConCon3D(geomA.getReverse(), geomB.getReverse());
	res[3] = doObj.vertexIsOnTheOther(doExchange);

	Vector intfvec = new Vector();
	Vector intspnt = new Vector();
	for (int i = 0; i < res.length; i++) {
	    if (res[i] != null) {
		if (res[i].ints() != null) {
		    double[] geomAParams = geomA.pointToParameter(res[i].ints());
		    double[] geomBParams = geomB.pointToParameter(res[i].ints());
		    JgclIntersectionPoint3D intsPoint =
			new JgclIntersectionPoint3D(geomA, geomAParams[0], geomAParams[1],
						    geomB, geomBParams[0], geomBParams[1],
						    JgclGeometry.doCheckDebug);
			intspnt.addElement(intsPoint);
		}

		if (res[i].pols() != null) {
		    JgclPolyline3D[] pols = res[i].pols();
		    for (int j = 0; j < pols.length; j++) {
			if (pols[j] != null) {
			    JgclSurfaceSurfaceInterference3D intsPoly =
				geomA.curveToIntersectionCurve(pols[j], geomB, doExchange);
			    intfvec.addElement(intsPoly);
			}
		    }
		}
	    }
	}
	
	// _ꍇ_1B
	// _ꍇ͏dĂ͂Ȃ̂
	// ŏ̌_ȊO͖B
	try {
	    JgclIntersectionPoint3D pnt =
		(JgclIntersectionPoint3D) intspnt.firstElement();
	    intfvec.addElement(pnt);
	} catch (NoSuchElementException e) {
	    // _Ȃꍇ͉Ȃ
	}

	JgclSurfaceSurfaceInterference3D[] intf =
	    new JgclSurfaceSurfaceInterference3D[intfvec.size()];
	intfvec.copyInto(intf);
	return intf;
    }
	    
    /*
     * Б̉~m̌|CƂċ߂
     * 
     * @return		 ƂȂ|C̔z
     * @see JgclIndefiniteSolution
     */
    JgclPolyline3D[] getInterferenceVertexIsNotOnTheOtherHalfSide(boolean doExchange)
	throws JgclIndefiniteSolution
    {
	/*
	 * the vertex of one is not on each other
	 */
	JgclPolyline3D[] pols;

	if (phiS < coneS.semiAngle() ||
	    (Math.PI - phiS) < coneS.semiAngle() ||
	    phiB < coneB.semiAngle() ||
	    (Math.PI - phiB) < coneB.semiAngle())
	{
	    if (phiS > coneS.semiAngle() && phiB > coneB.semiAngle() &&
		theta > coneS.semiAngle() + coneB.semiAngle())
	    {
		/*
		 * no intersection
		 */
		pols =  new JgclPolyline3D[0];
	    } else {
		/*
		 * the vertex of the parameterized cone is in the other cone
		 */
		pols = vertexOfParametarizedConeIsInTheOther();
	    }
	    
	}  else {
	    /*
	     * both vertices are out of the other cone
	     */
	    pols = bothVerticesAreOutOfTheOther();
	}

	return pols;
    }

    /*
     * _̋Ȗʏɖꍇ̉~m̌߂
     * 
     * @return		 ̔z
     * @see JgclIndefiniteSolution
     */
    JgclSurfaceSurfaceInterference3D[] getInterferenceVertexIsNotOnTheOther(boolean doExchange)
	throws JgclIndefiniteSolution
    {
	/*
	 * t̉~𓾂
	 *     (geomA: , geomB: )
	 *     (geomA: , geomB: t)
	 *     (geomA: t, geomB: )
	 *     (geomA: t, geomB: t)
	 * ̑g킹̌vZBȊO̓P[Xł
	 * KvȂB
	 *
	 * (GHL ł͉~͒_݂ĕБȂ,STEP ̒`ł
	 *  _̗ɉ~悤ɂȂĂB̃NX̌
	 *  ̌vZ GHL ̎@gĂ̂(,)̌vZ
	 *  łȂB̂߉~̂tɂČvZĂ)
	 */

	JgclIntsConCon3D doObj;
	JgclPolyline3D[][] pols = new JgclPolyline3D[4][];

	// geomA: , geomB: 
	pols[0] = getInterferenceVertexIsNotOnTheOtherHalfSide(doExchange);
	    
	// geomA: , geomB: t
	doObj = new JgclIntsConCon3D(geomA, geomB.getReverse());
	pols[1] = doObj.getInterferenceVertexIsNotOnTheOtherHalfSide(doExchange);
	    
	// geomA: t, geomB: 
	doObj = new JgclIntsConCon3D(geomA.getReverse(), geomB);
	pols[2] = doObj.getInterferenceVertexIsNotOnTheOtherHalfSide(doExchange);
	    
	// geomA: t, geomB: t
	doObj = new JgclIntsConCon3D(geomA.getReverse(), geomB.getReverse());
	pols[3] = doObj.getInterferenceVertexIsNotOnTheOtherHalfSide(doExchange);

	Vector intfvec = new Vector();
	for (int i = 0; i < pols.length; i++) {
	    for (int j = 0; j < pols[i].length; j++) {
		if (pols[i][j] != null) {
		    JgclSurfaceSurfaceInterference3D intsPoly =
			geomA.curveToIntersectionCurve(pols[i][j], geomB, doExchange);
		    intfvec.addElement(intsPoly);
		}
	    }
	}

	JgclSurfaceSurfaceInterference3D[] intf =
	    new JgclSurfaceSurfaceInterference3D[intfvec.size()];
	intfvec.copyInto(intf);
	return intf;
    }

    /*
     * ~m̌߂
     * 
     * @param doExchange ~邩ǂ̃tO
     * @return		 ̔z
     * @see JgclIndefiniteSolution
     */
    JgclSurfaceSurfaceInterference3D[] getInterference(boolean doExchange)
	throws JgclIndefiniteSolution
    {
	JgclSurfaceSurfaceInterference3D[] intf;

	/*
	 * get intersections
	 */
	JgclLine3D axisBZ = new JgclLine3D(coneB.position().location(),
					   coneB.position().z());
	JgclLine3D axisSZ = new JgclLine3D(coneS.position().location(),
					   coneS.position().z());

	if (coneB.position().z().parallelDirection(coneS.position().z()) &&
	    coneS.position().location().isOn(axisBZ) &&
	    coneB.position().location().isOn(axisSZ))
	{
	    /*
	     * [special case 1]
	     * axes are overlap
	     */
	    intf = axesAreOverlap(doExchange);
	    return intf;
	}

	if ((dist > dTol) &&
	    ((Math.abs(phiS - coneS.semiAngle()) < aTol) ||
	     (Math.abs((Math.PI - phiS) - coneS.semiAngle()) < aTol)) &&
	    ((Math.abs(phiB - coneB.semiAngle()) < aTol) ||
	     (Math.abs((Math.PI - phiB) - coneB.semiAngle()) < aTol)) &&
	    areCoplanar(coneS.position().z(), coneB.position().z(), s2b))
	{
	    /*
	     * [special case 2]
	     * the cones share a ruling tangentially
	     */
	    intf = rulingTangent(doExchange);	
	} else if (dist < dTol) {
	    /*
	     * [special case 3]
	     * at most 4 lines
	     */
	    intf = fourLines(doExchange);
	} else {
	    /*
	     * [general cases]
	     *
	     * the vertex of one is on the other or not
	     */
	    if (((Math.abs(phiS - coneS.semiAngle()) < aTol) ||
		 (Math.abs((Math.PI - phiS) - coneS.semiAngle()) < aTol)) ||
		((Math.abs(phiB - coneB.semiAngle()) < aTol) ||
		 (Math.abs((Math.PI - phiB) - coneB.semiAngle()) < aTol)))
	    {
		intf = getInterferenceVertexIsOnTheOther(doExchange);
	    } else {
		intf = getInterferenceVertexIsNotOnTheOther(doExchange);

	    }
	}

	return intf;
    }

    /**
     * fobOpCvOB
     */
    public static void main(String argv[]) throws JgclIndefiniteSolution {

	// both vertices are out of the other case
	System.out.println("\n>>> [both vertices are out of the other case]\n");
	JgclConicalSurface3D coneA, coneB;
	coneA = new JgclConicalSurface3D(JgclPoint3D.origin,
					 JgclVector3D.xUnitVector,
					 0.8, 0.4);
	coneB = new JgclConicalSurface3D(JgclPoint3D.origin,
					 JgclVector3D.of(1.0, 0.8, 0.0),
					 1.0, 0.5);
	JgclSurfaceSurfaceInterference3D[] intf = coneA.intersect(coneB);
	System.out.print("both vertices are out of the other case: ");
	System.out.print("interference number is " + intf.length + "\n");

	// verteces is in the other case
	System.out.println("\n>>> [verteces is in the other case]\n");
	coneA = new JgclConicalSurface3D(JgclPoint3D.of(0.0, -0.8, 0.0),
					 JgclVector3D.xUnitVector,
					 1.0, 0.5);

	coneB = new JgclConicalSurface3D(JgclPoint3D.of(-1.8, 0.0, 0.0),
					 JgclVector3D.yUnitVector,
					 1.0, 0.5);
	intf = coneA.intersect(coneB);
	System.out.print("verteces is in the other case: ");
	System.out.print("interference number is " + intf.length + "\n");
    }
}
