/*
 * 3D BXvCȐƃxWGȖʂ̌_߂NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclIntsBscBzs3D.java,v 1.12 2000/08/11 06:18:50 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * 3D BXvCȐƃxWGȖʂ̌_߂NX
 *
 * @version $Revision: 1.12 $, $Date: 2000/08/11 06:18:50 $
 * @author Information-technology Promotion Agency, Japan
 */
final class JgclIntsBscBzs3D
{
    private static final boolean DEBUG = false;

    /**
     * BXvCȐƃxWGȖʂ̊𓾂
     *
     * @param	bscA	BXvCȐ A
     * @param	bzsB	xWGȖ B
     * @return		ȐƋȖʂ̊̃Xg
     * @see		JgclCurveCurveInterferenceList
     */
    private static JgclCurveSurfaceInterferenceList
    getInterference(JgclBsplineCurve3D bscA,
		    JgclPureBezierSurface3D bzsB)
		    
    {
	// Ȑ A ̗LȃZOg̏
	JgclBsplineKnot.ValidSegmentInfo vldsA = bscA.validSegments();
	// Ȑ A \xWGȐ
	JgclPureBezierCurve3D[] bzcsA = bscA.toPureBezierCurveArray();

	// ̃Xg
	JgclCurveSurfaceInterferenceList interferenceList
	    = new JgclCurveSurfaceInterferenceList(bscA, bzsB);

	// Ȑ A ̊eZOgɑ΂
	for (int iA = 0; iA < bzcsA.length; iA++)
	{
	    if (DEBUG) {
		bzcsA[iA].output(System.out);
		bzsB.output(System.out);
	    }

	    // xWGȐxł̊𓾂
	    // **őݗ̈̃t`FbNȂ
	    //   炩ߋ߂̂nǂ**
	    // **t`FbNȂȂ
	    //   Ńt`FbNǉ
	    JgclIntersectionPoint3D[] ints;
	    try {
		ints = bzcsA[iA].intersect(bzsB);
	    }
	    catch (JgclIndefiniteSolution e) {
		throw new JgclFatal();	// ̗O͔Ȃ͂
	    }

	    // _Xgɒǉ
	    for (int i = 0; i < ints.length; i++)
	    {
		interferenceList.addAsIntersection
		    (ints[i].coordinates(),
		     vldsA.l2Gp(iA, ints[i].pointOnCurve1().parameter()),
		     ints[i].pointOnSurface2().uParameter(),
		     ints[i].pointOnSurface2().vParameter());
	    }
	}

	return interferenceList;
    }

    /**
     * BXvCȐƃxWGȖʂ̌_𓾂
     *
     * @param	bscA	BXvCȐ A
     * @param	bzsB	xWGȖ B
     * @return		ȐƋȖʂ̌_̔z
     * @see		JgclIntersectionPoint3D
     */
    static JgclIntersectionPoint3D[] intersection(JgclBsplineCurve3D bscA,
						  JgclPureBezierSurface3D bzsB,
						  boolean doExchange) {
	return getInterference(bscA, bzsB).toJgclIntersectionPoint3DArray(doExchange);
    }
}

// end of file
