/*
 * R : 􉽗vf̌_\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclIntersectionPoint3D.java,v 1.36 2000/04/26 09:38:59 hideit Exp $
 *
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * R : 􉽗vf̌_\NX
 * <p>
 * ̃NX̃CX^X́A
 * _̎ԏł̍Wl_ coordinatesA
 * ̊􉽗vfł̈ʒu_ pointOnGeometry1A
 * ̊􉽗vfł̈ʒu_ pointOnGeometry2
 * ێB
 * </p>
 *
 * @version $Revision: 1.36 $, $Date: 2000/04/26 09:38:59 $
 * @author Information-technology Promotion Agency, Japan
 * @see	JgclOverlapCurve3D
 */

public class JgclIntersectionPoint3D extends JgclPoint3D
    implements JgclCurveCurveInterference3D, JgclSurfaceSurfaceInterference3D
{
    /**
     * ԏł̍WlB
     * @serial
     */
    private final JgclPoint3D coordinates;

    /**
     * ̊􉽗vf (􉽗vf1) ł̈ʒuB
     * @serial
     */
    private final JgclPointOnGeometry3D pointOnGeometry1;

    /**
     * ̊􉽗vf (􉽗vf2) ł̈ʒuB
     * @serial
     */
    private final JgclPointOnGeometry3D pointOnGeometry2;

    /**
     * ̃CX^X̊etB[h̒l
     * ݂ɐ̂Ƃꂽ̂ł邩ǂ`FbNB
     * <p>
     * Ȃꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * @see	JgclInvalidArgumentValue
     */
    private void checkPoints() {
	if (!this.coordinates.identical(this.pointOnGeometry1) ||
	    !this.coordinates.identical(this.pointOnGeometry2) ||
	    !this.pointOnGeometry1.identical(this.pointOnGeometry2))
	    throw new JgclInvalidArgumentValue();
    }

    /**
     * 􉽗vf̌_̍WlƊe􉽗vf̏ł̈ʒu^ăIuWFNg\zB
     * <p>
     * doCheck  true ̏ꍇɂ́A
     * etB[hɒlݒ肵
     * {@link #checkPoints() checkPoints()} ĂяoB
     * </p>
     * 
     * @param coordinates	ԏł̍Wl
     * @param pointOnGeometry1	̊􉽗vf (􉽗vf1) ł̈ʒu
     * @param pointOnGeometry2	̊􉽗vf (􉽗vf2) ł̈ʒu
     * @param doCheck		̃`FbN邩ǂ̃tO
     */
    JgclIntersectionPoint3D(JgclPoint3D coordinates,
			    JgclPointOnGeometry3D pointOnGeometry1,
			    JgclPointOnGeometry3D pointOnGeometry2,
			    boolean doCheck) {
        super();
        this.coordinates = coordinates;
        this.pointOnGeometry1 = pointOnGeometry1;
        this.pointOnGeometry2 = pointOnGeometry2;
	if (doCheck)
	    checkPoints();
    }

    /**
     * 􉽗vf̌_̊e􉽗vf̏ł̈ʒu^ăIuWFNg\zB
     * <p>
     * _̎ԏł̍WĺAꂼ̊􉽗vf̓_̒_ƂȂB
     * </p>
     * <p>
     * doCheck  true ̏ꍇɂ́A
     * etB[hɒlݒ肵
     * {@link #checkPoints() checkPoints()} ĂяoB
     * </p>
     * 
     * @param pointOnGeometry1	̊􉽗vf (􉽗vf1) ł̈ʒu
     * @param pointOnGeometry2	̊􉽗vf (􉽗vf2) ł̈ʒu
     * @param doCheck		̃`FbN邩ǂ̃tO
     */
    JgclIntersectionPoint3D(JgclPointOnGeometry3D pointOnGeometry1,
			    JgclPointOnGeometry3D pointOnGeometry2,
			    boolean doCheck) {
        super();
        this.pointOnGeometry1 = pointOnGeometry1;
        this.pointOnGeometry2 = pointOnGeometry2;
        this.coordinates = this.pointOnGeometry1.linearInterpolate(this.pointOnGeometry2, 0.5);
	if (doCheck)
	    checkPoints();
    }

    /**
     * Ȑ̌_̍WlƊeȐ̏ł̈ʒu^ăIuWFNg\zB
     * <p>
     * doCheck  true ̏ꍇɂ́A
     * etB[hɒlݒ肵
     * {@link #checkPoints() checkPoints()} ĂяoB
     * </p>
     * 
     * @param coordinates	ԏł̍Wl
     * @param curve1		̋Ȑ (Ȑ1A 􉽗vf1)
     * @param param1		Ȑ1 ̃p[^l
     * @param curve2		̋Ȑ (Ȑ2A 􉽗vf2)
     * @param param2		Ȑ2 ̃p[^l
     * @param doCheck		̃`FbN邩ǂ̃tO
     */
    JgclIntersectionPoint3D(JgclPoint3D coordinates,
			    JgclParametricCurve3D curve1, double param1,
			    JgclParametricCurve3D curve2, double param2,
			    boolean doCheck) {
        super();
        this.coordinates = coordinates;
        this.pointOnGeometry1 = new JgclPointOnCurve3D(curve1, param1, doCheckDebug);
        this.pointOnGeometry2 = new JgclPointOnCurve3D(curve2, param2, doCheckDebug);
	if (doCheck)
	    checkPoints();
    }

    /**
     * Ȑ̌_̊eȐ̏ł̈ʒu^ăIuWFNg\zB
     * <p>
     * _̎ԏł̍WĺAꂼ̋Ȑ̓_̒_ƂȂB
     * </p>
     * <p>
     * doCheck  true ̏ꍇɂ́A
     * etB[hɒlݒ肵
     * {@link #checkPoints() checkPoints()} ĂяoB
     * </p>
     * 
     * @param curve1		̋Ȑ (Ȑ1A 􉽗vf1)
     * @param param1		Ȑ1 ̃p[^l
     * @param curve2		̋Ȑ (Ȑ2A 􉽗vf2)
     * @param param2		Ȑ2 ̃p[^l
     * @param doCheck		̃`FbN邩ǂ̃tO
     */
    JgclIntersectionPoint3D(JgclParametricCurve3D curve1, double param1,
			    JgclParametricCurve3D curve2, double param2,
			    boolean doCheck) {
        super();
        this.pointOnGeometry1 = new JgclPointOnCurve3D(curve1, param1, doCheckDebug);
        this.pointOnGeometry2 = new JgclPointOnCurve3D(curve2, param2, doCheckDebug);
        this.coordinates = this.pointOnGeometry1.linearInterpolate(this.pointOnGeometry2, 0.5);
	if (doCheck)
	    checkPoints();
    }

    /**
     * ȐƋȖʂ̌_̍WlƂꂼ̊􉽗vf̏ł̈ʒu^ăIuWFNg\zB
     * <p>
     * doCheck  true ̏ꍇɂ́A
     * etB[hɒlݒ肵
     * {@link #checkPoints() checkPoints()} ĂяoB
     * </p>
     * 
     * @param coordinates	ԏł̍Wl
     * @param curve1		̋Ȑ (Ȑ1A 􉽗vf1)
     * @param param1		Ȑ1 ̃p[^l
     * @param surface2		̋Ȗ (Ȗ2A 􉽗vf2)
     * @param uParam2		Ȗ2  U p[^l
     * @param vParam2		Ȗ2  V p[^l
     * @param doCheck		̃`FbN邩ǂ̃tO
     */
    JgclIntersectionPoint3D(JgclPoint3D coordinates,
			    JgclParametricCurve3D curve1, double param1,
			    JgclParametricSurface3D surface2, double uParam2, double vParam2,
			    boolean doCheck) {
        super();
        this.coordinates = coordinates;

        this.pointOnGeometry1 = new JgclPointOnCurve3D(curve1, param1, doCheckDebug);
        this.pointOnGeometry2 = new JgclPointOnSurface3D(surface2, uParam2, vParam2, doCheckDebug);
	if (doCheck)
	    checkPoints();
    }

    /**
     * ȐƋȖʂ̌_̂ꂼ̊􉽗vf̏ł̈ʒu^ăIuWFNg\zB
     * <p>
     * _̎ԏł̍WĺAꂼ̊􉽗vf̓_̒_ƂȂB
     * </p>
     * <p>
     * doCheck  true ̏ꍇɂ́A
     * etB[hɒlݒ肵
     * {@link #checkPoints() checkPoints()} ĂяoB
     * </p>
     * 
     * @param curve1		̋Ȑ (Ȑ1A 􉽗vf1)
     * @param param1		Ȑ1 ̃p[^l
     * @param surface2		̋Ȗ (Ȗ2A 􉽗vf2)
     * @param uParam2		Ȗ2  U p[^l
     * @param vParam2		Ȗ2  V p[^l
     * @param doCheck		̃`FbN邩ǂ̃tO
     */
    JgclIntersectionPoint3D(JgclParametricCurve3D curve1, double param1,
			    JgclParametricSurface3D surface2, double uParam2, double vParam2,
			    boolean doCheck) {
        super();
        this.pointOnGeometry1 = new JgclPointOnCurve3D(curve1, param1, doCheckDebug);
        this.pointOnGeometry2 = new JgclPointOnSurface3D(surface2, uParam2, vParam2, doCheckDebug);
        this.coordinates = this.pointOnGeometry1.linearInterpolate(this.pointOnGeometry2, 0.5);
	if (doCheck)
	    checkPoints();
    }

    /**
     * ȖʂƋȐ̌_̍WlƂꂼ̊􉽗vf̏ł̈ʒu^ăIuWFNg\zB
     * <p>
     * doCheck  true ̏ꍇɂ́A
     * etB[hɒlݒ肵
     * {@link #checkPoints() checkPoints()} ĂяoB
     * </p>
     * 
     * @param coordinates	ԏł̍Wl
     * @param surface1		̋Ȗ (Ȗ1A 􉽗vf1)
     * @param uParam1		Ȗ1  U p[^l
     * @param vParam1		Ȗ1  V p[^l
     * @param curve2		̋Ȑ (Ȑ2A 􉽗vf2)
     * @param param2		Ȑ2 ̃p[^l
     * @param doCheck		̃`FbN邩ǂ̃tO
     */
    JgclIntersectionPoint3D(JgclPoint3D coordinates,
			    JgclParametricSurface3D surface1, double uParam1, double vParam1,
			    JgclParametricCurve3D curve2, double param2,
			    boolean doCheck) {
        super();
        this.coordinates = coordinates;
        this.pointOnGeometry1 = new JgclPointOnSurface3D(surface1, uParam1, vParam1, doCheckDebug);
        this.pointOnGeometry2 = new JgclPointOnCurve3D(curve2, param2, doCheckDebug);
	if (doCheck)
	    checkPoints();
    }

    /**
     * ȖʂƋȐ̌_̍WlƂꂼ̊􉽗vf̏ł̈ʒu^ăIuWFNg\zB
     * <p>
     * _̎ԏł̍WĺAꂼ̊􉽗vf̓_̒_ƂȂB
     * </p>
     * <p>
     * doCheck  true ̏ꍇɂ́A
     * etB[hɒlݒ肵
     * {@link #checkPoints() checkPoints()} ĂяoB
     * </p>
     * 
     * @param surface1		̋Ȗ (Ȗ1A 􉽗vf1)
     * @param uParam1		Ȗ1  U p[^l
     * @param vParam1		Ȗ1  V p[^l
     * @param curve2		̋Ȑ (Ȑ2A 􉽗vf2)
     * @param param2		Ȑ2 ̃p[^l
     * @param doCheck		̃`FbN邩ǂ̃tO
     */
    JgclIntersectionPoint3D(JgclParametricSurface3D surface1, double uParam1, double vParam1,
			    JgclParametricCurve3D curve2, double param2,
			    boolean doCheck) {
        super();
        this.pointOnGeometry1 = new JgclPointOnSurface3D(surface1, uParam1, vParam1, doCheckDebug);
        this.pointOnGeometry2 = new JgclPointOnCurve3D(curve2, param2, doCheckDebug);
        this.coordinates = this.pointOnGeometry1.linearInterpolate(this.pointOnGeometry2, 0.5);
	if (doCheck)
	    checkPoints();
    }

    /**
     * Ȗʂ̌_̍WlƊeȖʂ̏ł̈ʒu^ăIuWFNg\zB
     * <p>
     * doCheck  true ̏ꍇɂ́A
     * etB[hɒlݒ肵
     * {@link #checkPoints() checkPoints()} ĂяoB
     * </p>
     * 
     * @param coordinates	ԏł̍Wl
     * @param surface1		̋Ȗ (Ȗ1A 􉽗vf1)
     * @param uParam1		Ȗ1  U p[^l
     * @param vParam1		Ȗ1  V p[^l
     * @param surface2		̋Ȗ (Ȗ2A 􉽗vf2)
     * @param uParam2		Ȗ2  U p[^l
     * @param vParam2		Ȗ2  V p[^l
     * @param doCheck		̃`FbN邩ǂ̃tO
     */
    JgclIntersectionPoint3D(JgclPoint3D coordinates,
			    JgclParametricSurface3D surface1, double uParam1, double vParam1,
			    JgclParametricSurface3D surface2, double uParam2, double vParam2,
			    boolean doCheck) {
        super();
        this.coordinates = coordinates;
        this.pointOnGeometry1 = new JgclPointOnSurface3D(surface1, uParam1, vParam1, doCheckDebug);
        this.pointOnGeometry2 = new JgclPointOnSurface3D(surface2, uParam2, vParam2, doCheckDebug);
	if (doCheck)
	    checkPoints();
    }

    /**
     * Ȗʂ̌_̊eȖʂ̏ł̈ʒu^ăIuWFNg\zB
     * <p>
     * _̎ԏł̍WĺAꂼ̋Ȗʏ̓_̒_ƂȂB
     * </p>
     * <p>
     * doCheck  true ̏ꍇɂ́A
     * etB[hɒlݒ肵
     * {@link #checkPoints() checkPoints()} ĂяoB
     * </p>
     * 
     * @param surface1		̋Ȗ (Ȗ1A 􉽗vf1)
     * @param uParam1		Ȗ1  U p[^l
     * @param vParam1		Ȗ1  V p[^l
     * @param surface2		̋Ȗ (Ȗ2A 􉽗vf2)
     * @param uParam2		Ȗ2  U p[^l
     * @param vParam2		Ȗ2  V p[^l
     * @param doCheck		̃`FbN邩ǂ̃tO
     */
    JgclIntersectionPoint3D(JgclParametricSurface3D surface1, double uParam1, double vParam1,
			    JgclParametricSurface3D surface2, double uParam2, double vParam2,
			    boolean doCheck) {
        super();
        this.pointOnGeometry1 = new JgclPointOnSurface3D(surface1, uParam1, vParam1, doCheckDebug);
        this.pointOnGeometry2 = new JgclPointOnSurface3D(surface2, uParam2, vParam2, doCheckDebug);
        this.coordinates = this.pointOnGeometry1.linearInterpolate(this.pointOnGeometry2, 0.5);
	if (doCheck)
	    checkPoints();
    }

    /**
     * ̓_ X WlԂB
     *
     * @return	_ X Wl
     */
    public double x() {
        return coordinates.x();
    }

    /**
     * ̓_ Y WlԂB
     *
     * @return	_ Y Wl
     */
    public double y() {
        return coordinates.y();
    }

    /**
     * ̓_ Z WlԂB
     *
     * @return	_ Z Wl
     */
    public double z() {
        return coordinates.z();
    }

    /**
     * ̌_̎ԏł̍WlԂB
     * 
     * @return	ԏł̍Wl
     */
    public JgclPoint3D coordinates() {
        return coordinates;
    }

    /**
     * ̌_̊􉽗vf1 ł̈ʒuԂB
     * 
     * @return 􉽗vf1 ł̈ʒu
     */
    public JgclPointOnGeometry3D pointOnGeometry1() {
        return pointOnGeometry1;
    }

    /**
     * ̌_̊􉽗vf2 ł̈ʒuԂB
     * 
     * @return 􉽗vf2 ł̈ʒu
     */
    public JgclPointOnGeometry3D pointOnGeometry2() {
        return pointOnGeometry2;
    }

    /**
     * ̌_̊􉽗vf1 Ȑł̂ƂāAȐ1 ̈ʒuԂB
     * 
     * @return Ȑ1 ł̈ʒu
     */
    public JgclPointOnCurve3D pointOnCurve1() {
	if (!pointOnGeometry1().geometry().isCurve())
	    return null;
        return (JgclPointOnCurve3D)pointOnGeometry1();
    }

    /**
     * ̌_̊􉽗vf2 Ȑł̂ƂāAȐ2 ̈ʒuԂB
     * 
     * @return Ȑ2 ł̈ʒu
     */
    public JgclPointOnCurve3D pointOnCurve2() {
	if (!pointOnGeometry2().geometry().isCurve())
	    return null;
        return (JgclPointOnCurve3D)pointOnGeometry2();
    }

    /**
     * ̌_̊􉽗vf1 Ȗʂł̂ƂāAȖ1 ̈ʒuԂB
     * 
     * @return Ȗ1 ł̈ʒu
     */
    public JgclPointOnSurface3D pointOnSurface1() {
	if (!pointOnGeometry1().geometry().isSurface())
	    return null;
        return (JgclPointOnSurface3D)pointOnGeometry1();
    }

    /**
     * ̌_̊􉽗vf2 Ȗʂł̂ƂāAȖ2 ̈ʒuԂB
     * 
     * @return Ȗ2 ł̈ʒu
     */
    public JgclPointOnSurface3D pointOnSurface2() {
	if (!pointOnGeometry2().geometry().isSurface())
	    return null;
        return (JgclPointOnSurface3D)pointOnGeometry2();
    }

    /**
     * ̊_ł邩ۂԂB
     *
     * @return	_Ȃ̂ŁA true
     * @see	#isOverlapCurve()
     * @see	#isIntersectionCurve()
     */
    public boolean isIntersectionPoint() {
	return true;
    }

    /**
     * ̊I[o[bvł邩ۂԂB
     *
     * @return	I[o[bvł͂Ȃ_Ȃ̂ŁA false
     * @see	#isIntersectionPoint()
     */
    public boolean isOverlapCurve() {
	return false;
    }

    /**
     * ̊ł邩ۂԂB
     *
     * @return	ł͂Ȃ_Ȃ̂ŁA false
     * @see	#isIntersectionPoint()
     */
    public boolean isIntersectionCurve() {
	return false;
    }

    /**
     * ̊_ɕϊB
     * <p>
     * gԂB
     * </p>
     *
     * @return	g
     */
    public JgclIntersectionPoint3D toIntersectionPoint() {
	return this;
    }

    /**
     * ̊I[o[bvɕϊB
     * <p>
     * _I[o[bvɕϊ邱Ƃ͂łȂ̂ null ԂB
     * </p>
     *
     * @return	 null
     */
    public JgclOverlapCurve3D toOverlapCurve() {
	return null;
    }

    /**
     * ̊ɕϊB
     * <p>
     * _ɕϊ邱Ƃ͂łȂ̂ null ԂB
     * </p>
     *
     * @return	 null
     */
    public JgclIntersectionCurve3D toIntersectionCurve() {
	return null;
    }

    /**
     * ̌_ pointOnGeometry1  pointOnGeometry2 _ԂB
     *
     * @return	pointOnGeometry1  pointOnGeometry2 _
     */
    public JgclIntersectionPoint3D exchange() {
	JgclIntersectionPoint3D ex =
	    new JgclIntersectionPoint3D(coordinates,
					pointOnGeometry2, pointOnGeometry1, doCheckDebug);
	return ex;
    }

    /**
     * ̊̈̋Ȑ (Ȑ1) ł̈ʒuA
     * ^ꂽϊɂĕϊ̂ɒuԂB
     * <p>
     * ̌_ pointOnCurve1 ̃p[^l sec ͈̔͂OĂꍇɂ
     * null ԂB
     * </p>
     *
     * @param sec	Ȑ1 ̃p[^
     * @param conv	Ȑ1 ̃p[^lϊIuWFNg
     * @return	Ȑ1 ̈ʒu^ꂽϊɂĕϊ̂ɒu
     */
    public JgclCurveCurveInterference3D trim1(JgclParameterSection sec,
					      JgclParameterConversion3D conv) {
	JgclPointOnCurve3D pnt = (JgclPointOnCurve3D)pointOnGeometry1;
	double param = pnt.parameter();
	JgclParametricCurve3D curve =
	    (JgclParametricCurve3D)pnt.geometry();
	JgclConditionOfOperation cond =
	    JgclConditionOfOperation.getCondition();

	cond.makeCopy(cond.getToleranceForDistanceAsObject()
		      .toToleranceForParameter(curve, param)).push();
	try {
	    if (!sec.isValid(param))
		return null;
	}
	finally {
	    JgclConditionOfOperation.pop();
	}
	JgclPointOnCurve3D poc1 = conv.convToPoint(param);
	JgclPointOnCurve3D poc2 = (JgclPointOnCurve3D)pointOnGeometry2;
	return new JgclIntersectionPoint3D(poc1, poc2, doCheckDebug);
    }

    /**
     * ̊̑̋Ȑ (Ȑ2) ł̈ʒuA
     * ^ꂽϊɂĕϊ̂ɒuԂB
     * <p>
     * ̌_ pointOnCurve2 ̃p[^l sec ͈̔͂OĂꍇɂ
     * null ԂB
     * </p>
     *
     * @param sec	Ȑ2 ̃p[^
     * @param conv	Ȑ2 ̃p[^lϊIuWFNg
     * @return	Ȑ2 ̈ʒu^ꂽϊɂĕϊ̂ɒu
     */
    public JgclCurveCurveInterference3D trim2(JgclParameterSection sec,
					      JgclParameterConversion3D conv) {
	JgclPointOnCurve3D pnt = (JgclPointOnCurve3D)pointOnGeometry2;
	double param = pnt.parameter();
	JgclParametricCurve3D curve =
	    (JgclParametricCurve3D)pnt.geometry();
	JgclConditionOfOperation cond =
	    JgclConditionOfOperation.getCondition();

	cond.makeCopy(cond.getToleranceForDistanceAsObject()
		      .toToleranceForParameter(curve, param)).push();
	try {
	    if (!sec.isValid(param))
		return null;
	}
	finally {
	    JgclConditionOfOperation.pop();
	}
	JgclPointOnCurve3D poc1 = (JgclPointOnCurve3D)pointOnGeometry1;
	JgclPointOnCurve3D poc2 = conv.convToPoint(param);
	return new JgclIntersectionPoint3D(poc1, poc2, doCheckDebug);
    }

    /**
     * ̊̈̋Ȑ (Ȑ1) ^ꂽȐɒuԂB
     * <p>
     * p[^lȂǂ͂̂܂܁B
     * </p>
     *
     * @param newCurve	Ȑ1 ɐݒ肷Ȑ
     * @return	Ȑ1u
     */
    public JgclCurveCurveInterference3D changeCurve1(JgclParametricCurve3D newCurve) {
	if (!this.pointOnGeometry1().geometry().isCurve())
	    throw new JgclFatal();
	JgclPointOnCurve3D pointOnCurve1 = (JgclPointOnCurve3D)this.pointOnGeometry1();
	JgclPointOnCurve3D newPointOnCurve1 =
	    new JgclPointOnCurve3D(newCurve, pointOnCurve1.parameter(), doCheckDebug);

	return new JgclIntersectionPoint3D(newPointOnCurve1, this.pointOnGeometry2, doCheckDebug);
    }

    /**
     * ̊̑̋Ȑ (Ȑ2) ^ꂽȐɒuԂB
     * <p>
     * p[^lȂǂ͂̂܂܁B
     * </p>
     *
     * @param newCurve	Ȑ2 ɐݒ肷Ȑ
     * @return	Ȑ2 u
     */
    public JgclCurveCurveInterference3D changeCurve2(JgclParametricCurve3D newCurve) {
	if (!this.pointOnGeometry2().geometry().isCurve())
	    throw new JgclFatal();
	JgclPointOnCurve3D pointOnCurve2 = (JgclPointOnCurve3D)this.pointOnGeometry2();
	JgclPointOnCurve3D newPointOnCurve2 =
	    new JgclPointOnCurve3D(newCurve, pointOnCurve2.parameter(), doCheckDebug);

	return new JgclIntersectionPoint3D(this.pointOnGeometry1, newPointOnCurve2, doCheckDebug);
    }

    /**
     * ̓_A^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclPoint3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclPoint3D tCoordinates =
	    this.coordinates.transformBy(reverseTransform,
					 transformationOperator,
					 transformedGeometries);

	JgclPointOnGeometry3D tPointOnGeometry1;
	JgclPointOnGeometry3D tPointOnGeometry2;

	if (this.pointOnGeometry1.geometry().isPoint() == true) {
	    JgclPointOnPoint3D pointOnPoint1
		= (JgclPointOnPoint3D)this.pointOnGeometry1;
	    tPointOnGeometry1 =
		(JgclPointOnPoint3D)pointOnPoint1.transformBy(reverseTransform,
							      transformationOperator,
							      transformedGeometries);
	} else if (this.pointOnGeometry1.geometry().isCurve() == true) {
	    JgclPointOnCurve3D pointOnCurve1 =
		(JgclPointOnCurve3D)this.pointOnGeometry1;
	    tPointOnGeometry1 =
		(JgclPointOnCurve3D)pointOnCurve1.transformBy(reverseTransform,
							      transformationOperator,
							      transformedGeometries);
	} else {
	    JgclPointOnSurface3D pointOnSurface1 =
		(JgclPointOnSurface3D)this.pointOnGeometry1;
	    tPointOnGeometry1 =
		(JgclPointOnSurface3D)pointOnSurface1.transformBy(reverseTransform,
								  transformationOperator,
								  transformedGeometries);
	}

	if (this.pointOnGeometry2.geometry().isPoint() == true) {
	    JgclPointOnPoint3D pointOnPoint2 =
		(JgclPointOnPoint3D)this.pointOnGeometry2;
	    tPointOnGeometry2 =
		(JgclPointOnPoint3D)pointOnPoint2.transformBy(reverseTransform,
							      transformationOperator,
							      transformedGeometries);
	} else if (this.pointOnGeometry2.geometry().isCurve() == true) {
	    JgclPointOnCurve3D pointOnCurve2 =
		(JgclPointOnCurve3D)this.pointOnGeometry2;
	    tPointOnGeometry2 =
		(JgclPointOnCurve3D)pointOnCurve2.transformBy(reverseTransform,
							      transformationOperator,
							      transformedGeometries);
	} else {
	    JgclPointOnSurface3D pointOnSurface2 =
		(JgclPointOnSurface3D)this.pointOnGeometry2;
	    tPointOnGeometry2 =
		(JgclPointOnSurface3D)pointOnSurface2.transformBy(reverseTransform,
								  transformationOperator,
								  transformedGeometries);
	}

	return new JgclIntersectionPoint3D(tCoordinates,
					   tPointOnGeometry1,
					   tPointOnGeometry2,
					   doCheckDebug);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tcoordinates");
        coordinates.output(writer, indent + 2);
        writer.println(indent_tab + "\tpointOnGeometry1");
        pointOnGeometry1.output(writer, indent + 2);
        writer.println(indent_tab + "\tpointOnGeometry2");
        pointOnGeometry2.output(writer, indent + 2);
        writer.println(indent_tab + "End");
    }
}
